#include "myxml.h"

#define BUFFSIZE	8192

char Buff[BUFFSIZE];

int Depth;

void start(void *data, const char *el, const char **attr) 
{
	int i;
	
	for (i = 0; i < Depth; i++)
		printf("  ");
	
	printf("%s", el);
	
	for (i = 0; attr[i]; i += 2) {
		printf(" %s='%s'", attr[i], attr[i + 1]);
	}
	
	printf("\n");
	Depth++;
}  /* End of start handler */

void end(void *data, const char *el) 
{
	Depth--;
}  /* End of end handler */

int convert(void *data, const char *s)
{
	int utf = 10;
	printf("convert %s\n",s);
	return utf;
}

int GB2312Handle(void *data,const XML_Char *name,XML_Encoding *info)
{
	printf("%s %x\n",name,data);
	if ( strcmp(name,"GB2312") )
		return 0;
	for ( int i = 0 ; i < 255; i++)
	{
		if ( i < 0xff )
			info->map[i] = i;
		else
			info->map[i] = 0;
	}
	info->convert=convert;
	return 1;
}

int main(int argc, char **argv) 
{
	XML_Parser p = XML_ParserCreate("GB2312");
//	XML_Parser p = XML_ParserCreate("ISO-8859-1");
	FILE *fp;
	fp = fopen("\\My Documents\\program\\mywork\\tica18_sourcecode\\xml\\mytest.xml","r");
	assert(fp);
	if (! p) 
	{
		fprintf(stderr, "Couldn't allocate memory for parser\n");
		exit(-1);
	}
	printf("%d %x\n",BT_S,BT_S);
	XML_SetElementHandler(p, start, end);

//	XML_SetUnknownEncodingHandler(p,GB2312Handle,NULL);
	for (;;) {
		int done;
		int len;
		
		len = fread(Buff, 1, BUFFSIZE, fp);
		if (ferror(stdin)) {
			fprintf(stderr, "Read error\n");
			exit(-1);
		}
		done = feof(fp);
		
		if (! XML_Parse(p, Buff, len, done)) {
			fprintf(stderr, "Parse error at line %d:\n%s\n",
				XML_GetCurrentLineNumber(p),
				XML_ErrorString(XML_GetErrorCode(p)));
			exit(-1);
		}
		
		if (done)
			break;
	}
	XML_ParserFree(p);
	return 0;
}  /* End of main */