#!/usr/bin/perl -w
# This program was authored by Michael T. Babcock <mbabcock@fibrespeed.net>
# It is Copyright (C) 2001, FibreSpeed Inc.
#
# Feel free to use it in any project for which you need this type of
# program, but give credit to the author and Copyright holder above.
# If you don't understand these permissions, I grant you license to use
# this program under the GPL version 2.
#
# New tables are available at:
# ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
#
# cat UnicodeData.txt | ./update-tables.pl > UnicodeData.h
#
print "typedef struct {\n";
print "\tunsigned long code;\n";
print "\tconst char *description;\n";
print "} T_UNICODE_DATA;\n\n";

print "T_UNICODE_DATA unicode_data[] = {\n";
while (<>) {
	chomp;
	@rec = split(/;/);
	$#rec != 14 && next;
	# print ">>> $_\n";
	# Modify rec[2] to be an enum ...
	if ($rec[11]) { $comment = "\t/* $rec[11] */"; } else { $comment = "" };
	print "\t{ 0x$rec[0], \"$rec[1]\" },$comment\n";
}
print "};\n";
