typedef struct {
	unsigned long code;
	const char *description;
} T_UNICODE_DATA;

T_UNICODE_DATA unicode_data[] = {
	{ 0x0000, "<control>" },
	{ 0x0001, "<control>" },
	{ 0x0002, "<control>" },
	{ 0x0003, "<control>" },
	{ 0x0004, "<control>" },
	{ 0x0005, "<control>" },
	{ 0x0006, "<control>" },
	{ 0x0007, "<control>" },
	{ 0x0008, "<control>" },
	{ 0x0009, "<control>" },
	{ 0x000A, "<control>" },
	{ 0x000B, "<control>" },
	{ 0x000C, "<control>" },
	{ 0x000D, "<control>" },
	{ 0x000E, "<control>" },
	{ 0x000F, "<control>" },
	{ 0x0010, "<control>" },
	{ 0x0011, "<control>" },
	{ 0x0012, "<control>" },
	{ 0x0013, "<control>" },
	{ 0x0014, "<control>" },
	{ 0x0015, "<control>" },
	{ 0x0016, "<control>" },
	{ 0x0017, "<control>" },
	{ 0x0018, "<control>" },
	{ 0x0019, "<control>" },
	{ 0x001A, "<control>" },
	{ 0x001B, "<control>" },
	{ 0x001C, "<control>" },
	{ 0x001D, "<control>" },
	{ 0x001E, "<control>" },
	{ 0x001F, "<control>" },
	{ 0x0020, "SPACE" },
	{ 0x0021, "EXCLAMATION MARK" },
	{ 0x0022, "QUOTATION MARK" },
	{ 0x0023, "NUMBER SIGN" },
	{ 0x0024, "DOLLAR SIGN" },
	{ 0x0025, "PERCENT SIGN" },
	{ 0x0026, "AMPERSAND" },
	{ 0x0027, "APOSTROPHE" },
	{ 0x0028, "LEFT PARENTHESIS" },
	{ 0x0029, "RIGHT PARENTHESIS" },
	{ 0x002A, "ASTERISK" },
	{ 0x002B, "PLUS SIGN" },
	{ 0x002C, "COMMA" },
	{ 0x002D, "HYPHEN-MINUS" },
	{ 0x002E, "FULL STOP" },
	{ 0x002F, "SOLIDUS" },
	{ 0x0030, "DIGIT ZERO" },
	{ 0x0031, "DIGIT ONE" },
	{ 0x0032, "DIGIT TWO" },
	{ 0x0033, "DIGIT THREE" },
	{ 0x0034, "DIGIT FOUR" },
	{ 0x0035, "DIGIT FIVE" },
	{ 0x0036, "DIGIT SIX" },
	{ 0x0037, "DIGIT SEVEN" },
	{ 0x0038, "DIGIT EIGHT" },
	{ 0x0039, "DIGIT NINE" },
	{ 0x003A, "COLON" },
	{ 0x003B, "SEMICOLON" },
	{ 0x003C, "LESS-THAN SIGN" },
	{ 0x003D, "EQUALS SIGN" },
	{ 0x003E, "GREATER-THAN SIGN" },
	{ 0x003F, "QUESTION MARK" },
	{ 0x0040, "COMMERCIAL AT" },
	{ 0x0041, "LATIN CAPITAL LETTER A" },
	{ 0x0042, "LATIN CAPITAL LETTER B" },
	{ 0x0043, "LATIN CAPITAL LETTER C" },
	{ 0x0044, "LATIN CAPITAL LETTER D" },
	{ 0x0045, "LATIN CAPITAL LETTER E" },
	{ 0x0046, "LATIN CAPITAL LETTER F" },
	{ 0x0047, "LATIN CAPITAL LETTER G" },
	{ 0x0048, "LATIN CAPITAL LETTER H" },
	{ 0x0049, "LATIN CAPITAL LETTER I" },
	{ 0x004A, "LATIN CAPITAL LETTER J" },
	{ 0x004B, "LATIN CAPITAL LETTER K" },
	{ 0x004C, "LATIN CAPITAL LETTER L" },
	{ 0x004D, "LATIN CAPITAL LETTER M" },
	{ 0x004E, "LATIN CAPITAL LETTER N" },
	{ 0x004F, "LATIN CAPITAL LETTER O" },
	{ 0x0050, "LATIN CAPITAL LETTER P" },
	{ 0x0051, "LATIN CAPITAL LETTER Q" },
	{ 0x0052, "LATIN CAPITAL LETTER R" },
	{ 0x0053, "LATIN CAPITAL LETTER S" },
	{ 0x0054, "LATIN CAPITAL LETTER T" },
	{ 0x0055, "LATIN CAPITAL LETTER U" },
	{ 0x0056, "LATIN CAPITAL LETTER V" },
	{ 0x0057, "LATIN CAPITAL LETTER W" },
	{ 0x0058, "LATIN CAPITAL LETTER X" },
	{ 0x0059, "LATIN CAPITAL LETTER Y" },
	{ 0x005A, "LATIN CAPITAL LETTER Z" },
	{ 0x005B, "LEFT SQUARE BRACKET" },
	{ 0x005C, "REVERSE SOLIDUS" },
	{ 0x005D, "RIGHT SQUARE BRACKET" },
	{ 0x005E, "CIRCUMFLEX ACCENT" },
	{ 0x005F, "LOW LINE" },
	{ 0x0060, "GRAVE ACCENT" },
	{ 0x0061, "LATIN SMALL LETTER A" },
	{ 0x0062, "LATIN SMALL LETTER B" },
	{ 0x0063, "LATIN SMALL LETTER C" },
	{ 0x0064, "LATIN SMALL LETTER D" },
	{ 0x0065, "LATIN SMALL LETTER E" },
	{ 0x0066, "LATIN SMALL LETTER F" },
	{ 0x0067, "LATIN SMALL LETTER G" },
	{ 0x0068, "LATIN SMALL LETTER H" },
	{ 0x0069, "LATIN SMALL LETTER I" },
	{ 0x006A, "LATIN SMALL LETTER J" },
	{ 0x006B, "LATIN SMALL LETTER K" },
	{ 0x006C, "LATIN SMALL LETTER L" },
	{ 0x006D, "LATIN SMALL LETTER M" },
	{ 0x006E, "LATIN SMALL LETTER N" },
	{ 0x006F, "LATIN SMALL LETTER O" },
	{ 0x0070, "LATIN SMALL LETTER P" },
	{ 0x0071, "LATIN SMALL LETTER Q" },
	{ 0x0072, "LATIN SMALL LETTER R" },
	{ 0x0073, "LATIN SMALL LETTER S" },
	{ 0x0074, "LATIN SMALL LETTER T" },
	{ 0x0075, "LATIN SMALL LETTER U" },
	{ 0x0076, "LATIN SMALL LETTER V" },
	{ 0x0077, "LATIN SMALL LETTER W" },
	{ 0x0078, "LATIN SMALL LETTER X" },
	{ 0x0079, "LATIN SMALL LETTER Y" },
	{ 0x007A, "LATIN SMALL LETTER Z" },
	{ 0x007B, "LEFT CURLY BRACKET" },
	{ 0x007C, "VERTICAL LINE" },
	{ 0x007D, "RIGHT CURLY BRACKET" },
	{ 0x007E, "TILDE" },
	{ 0x007F, "<control>" },
	{ 0x0080, "<control>" },
	{ 0x0081, "<control>" },
	{ 0x0082, "<control>" },
	{ 0x0083, "<control>" },
	{ 0x0084, "<control>" },
	{ 0x0085, "<control>" },
	{ 0x0086, "<control>" },
	{ 0x0087, "<control>" },
	{ 0x0088, "<control>" },
	{ 0x0089, "<control>" },
	{ 0x008A, "<control>" },
	{ 0x008B, "<control>" },
	{ 0x008C, "<control>" },
	{ 0x008D, "<control>" },
	{ 0x008E, "<control>" },
	{ 0x008F, "<control>" },
	{ 0x0090, "<control>" },
	{ 0x0091, "<control>" },
	{ 0x0092, "<control>" },
	{ 0x0093, "<control>" },
	{ 0x0094, "<control>" },
	{ 0x0095, "<control>" },
	{ 0x0096, "<control>" },
	{ 0x0097, "<control>" },
	{ 0x0098, "<control>" },
	{ 0x0099, "<control>" },
	{ 0x009A, "<control>" },
	{ 0x009B, "<control>" },
	{ 0x009C, "<control>" },
	{ 0x009D, "<control>" },
	{ 0x009E, "<control>" },
	{ 0x009F, "<control>" },
	{ 0x00A0, "NO-BREAK SPACE" },
	{ 0x00A1, "INVERTED EXCLAMATION MARK" },
	{ 0x00A2, "CENT SIGN" },
	{ 0x00A3, "POUND SIGN" },
	{ 0x00A4, "CURRENCY SIGN" },
	{ 0x00A5, "YEN SIGN" },
	{ 0x00A6, "BROKEN BAR" },
	{ 0x00A7, "SECTION SIGN" },
	{ 0x00A8, "DIAERESIS" },
	{ 0x00A9, "COPYRIGHT SIGN" },
	{ 0x00AA, "FEMININE ORDINAL INDICATOR" },
	{ 0x00AB, "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK" },	/* * */
	{ 0x00AC, "NOT SIGN" },
	{ 0x00AD, "SOFT HYPHEN" },
	{ 0x00AE, "REGISTERED SIGN" },
	{ 0x00AF, "MACRON" },
	{ 0x00B0, "DEGREE SIGN" },
	{ 0x00B1, "PLUS-MINUS SIGN" },
	{ 0x00B2, "SUPERSCRIPT TWO" },
	{ 0x00B3, "SUPERSCRIPT THREE" },
	{ 0x00B4, "ACUTE ACCENT" },
	{ 0x00B5, "MICRO SIGN" },
	{ 0x00B6, "PILCROW SIGN" },
	{ 0x00B7, "MIDDLE DOT" },
	{ 0x00B8, "CEDILLA" },
	{ 0x00B9, "SUPERSCRIPT ONE" },
	{ 0x00BA, "MASCULINE ORDINAL INDICATOR" },
	{ 0x00BB, "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK" },	/* * */
	{ 0x00BC, "VULGAR FRACTION ONE QUARTER" },
	{ 0x00BD, "VULGAR FRACTION ONE HALF" },
	{ 0x00BE, "VULGAR FRACTION THREE QUARTERS" },
	{ 0x00BF, "INVERTED QUESTION MARK" },
	{ 0x00C0, "LATIN CAPITAL LETTER A WITH GRAVE" },
	{ 0x00C1, "LATIN CAPITAL LETTER A WITH ACUTE" },
	{ 0x00C2, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX" },
	{ 0x00C3, "LATIN CAPITAL LETTER A WITH TILDE" },
	{ 0x00C4, "LATIN CAPITAL LETTER A WITH DIAERESIS" },
	{ 0x00C5, "LATIN CAPITAL LETTER A WITH RING ABOVE" },
	{ 0x00C6, "LATIN CAPITAL LETTER AE" },	/* ash * */
	{ 0x00C7, "LATIN CAPITAL LETTER C WITH CEDILLA" },
	{ 0x00C8, "LATIN CAPITAL LETTER E WITH GRAVE" },
	{ 0x00C9, "LATIN CAPITAL LETTER E WITH ACUTE" },
	{ 0x00CA, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX" },
	{ 0x00CB, "LATIN CAPITAL LETTER E WITH DIAERESIS" },
	{ 0x00CC, "LATIN CAPITAL LETTER I WITH GRAVE" },
	{ 0x00CD, "LATIN CAPITAL LETTER I WITH ACUTE" },
	{ 0x00CE, "LATIN CAPITAL LETTER I WITH CIRCUMFLEX" },
	{ 0x00CF, "LATIN CAPITAL LETTER I WITH DIAERESIS" },
	{ 0x00D0, "LATIN CAPITAL LETTER ETH" },	/* Icelandic */
	{ 0x00D1, "LATIN CAPITAL LETTER N WITH TILDE" },
	{ 0x00D2, "LATIN CAPITAL LETTER O WITH GRAVE" },
	{ 0x00D3, "LATIN CAPITAL LETTER O WITH ACUTE" },
	{ 0x00D4, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX" },
	{ 0x00D5, "LATIN CAPITAL LETTER O WITH TILDE" },
	{ 0x00D6, "LATIN CAPITAL LETTER O WITH DIAERESIS" },
	{ 0x00D7, "MULTIPLICATION SIGN" },
	{ 0x00D8, "LATIN CAPITAL LETTER O WITH STROKE" },
	{ 0x00D9, "LATIN CAPITAL LETTER U WITH GRAVE" },
	{ 0x00DA, "LATIN CAPITAL LETTER U WITH ACUTE" },
	{ 0x00DB, "LATIN CAPITAL LETTER U WITH CIRCUMFLEX" },
	{ 0x00DC, "LATIN CAPITAL LETTER U WITH DIAERESIS" },
	{ 0x00DD, "LATIN CAPITAL LETTER Y WITH ACUTE" },
	{ 0x00DE, "LATIN CAPITAL LETTER THORN" },	/* Icelandic */
	{ 0x00DF, "LATIN SMALL LETTER SHARP S" },	/* German */
	{ 0x00E0, "LATIN SMALL LETTER A WITH GRAVE" },
	{ 0x00E1, "LATIN SMALL LETTER A WITH ACUTE" },
	{ 0x00E2, "LATIN SMALL LETTER A WITH CIRCUMFLEX" },
	{ 0x00E3, "LATIN SMALL LETTER A WITH TILDE" },
	{ 0x00E4, "LATIN SMALL LETTER A WITH DIAERESIS" },
	{ 0x00E5, "LATIN SMALL LETTER A WITH RING ABOVE" },
	{ 0x00E6, "LATIN SMALL LETTER AE" },	/* ash * */
	{ 0x00E7, "LATIN SMALL LETTER C WITH CEDILLA" },
	{ 0x00E8, "LATIN SMALL LETTER E WITH GRAVE" },
	{ 0x00E9, "LATIN SMALL LETTER E WITH ACUTE" },
	{ 0x00EA, "LATIN SMALL LETTER E WITH CIRCUMFLEX" },
	{ 0x00EB, "LATIN SMALL LETTER E WITH DIAERESIS" },
	{ 0x00EC, "LATIN SMALL LETTER I WITH GRAVE" },
	{ 0x00ED, "LATIN SMALL LETTER I WITH ACUTE" },
	{ 0x00EE, "LATIN SMALL LETTER I WITH CIRCUMFLEX" },
	{ 0x00EF, "LATIN SMALL LETTER I WITH DIAERESIS" },
	{ 0x00F0, "LATIN SMALL LETTER ETH" },	/* Icelandic */
	{ 0x00F1, "LATIN SMALL LETTER N WITH TILDE" },
	{ 0x00F2, "LATIN SMALL LETTER O WITH GRAVE" },
	{ 0x00F3, "LATIN SMALL LETTER O WITH ACUTE" },
	{ 0x00F4, "LATIN SMALL LETTER O WITH CIRCUMFLEX" },
	{ 0x00F5, "LATIN SMALL LETTER O WITH TILDE" },
	{ 0x00F6, "LATIN SMALL LETTER O WITH DIAERESIS" },
	{ 0x00F7, "DIVISION SIGN" },
	{ 0x00F8, "LATIN SMALL LETTER O WITH STROKE" },
	{ 0x00F9, "LATIN SMALL LETTER U WITH GRAVE" },
	{ 0x00FA, "LATIN SMALL LETTER U WITH ACUTE" },
	{ 0x00FB, "LATIN SMALL LETTER U WITH CIRCUMFLEX" },
	{ 0x00FC, "LATIN SMALL LETTER U WITH DIAERESIS" },
	{ 0x00FD, "LATIN SMALL LETTER Y WITH ACUTE" },
	{ 0x00FE, "LATIN SMALL LETTER THORN" },	/* Icelandic */
	{ 0x00FF, "LATIN SMALL LETTER Y WITH DIAERESIS" },
	{ 0x0100, "LATIN CAPITAL LETTER A WITH MACRON" },
	{ 0x0101, "LATIN SMALL LETTER A WITH MACRON" },
	{ 0x0102, "LATIN CAPITAL LETTER A WITH BREVE" },
	{ 0x0103, "LATIN SMALL LETTER A WITH BREVE" },
	{ 0x0104, "LATIN CAPITAL LETTER A WITH OGONEK" },
	{ 0x0105, "LATIN SMALL LETTER A WITH OGONEK" },
	{ 0x0106, "LATIN CAPITAL LETTER C WITH ACUTE" },
	{ 0x0107, "LATIN SMALL LETTER C WITH ACUTE" },
	{ 0x0108, "LATIN CAPITAL LETTER C WITH CIRCUMFLEX" },
	{ 0x0109, "LATIN SMALL LETTER C WITH CIRCUMFLEX" },
	{ 0x010A, "LATIN CAPITAL LETTER C WITH DOT ABOVE" },
	{ 0x010B, "LATIN SMALL LETTER C WITH DOT ABOVE" },
	{ 0x010C, "LATIN CAPITAL LETTER C WITH CARON" },
	{ 0x010D, "LATIN SMALL LETTER C WITH CARON" },
	{ 0x010E, "LATIN CAPITAL LETTER D WITH CARON" },
	{ 0x010F, "LATIN SMALL LETTER D WITH CARON" },
	{ 0x0110, "LATIN CAPITAL LETTER D WITH STROKE" },
	{ 0x0111, "LATIN SMALL LETTER D WITH STROKE" },
	{ 0x0112, "LATIN CAPITAL LETTER E WITH MACRON" },
	{ 0x0113, "LATIN SMALL LETTER E WITH MACRON" },
	{ 0x0114, "LATIN CAPITAL LETTER E WITH BREVE" },
	{ 0x0115, "LATIN SMALL LETTER E WITH BREVE" },
	{ 0x0116, "LATIN CAPITAL LETTER E WITH DOT ABOVE" },
	{ 0x0117, "LATIN SMALL LETTER E WITH DOT ABOVE" },
	{ 0x0118, "LATIN CAPITAL LETTER E WITH OGONEK" },
	{ 0x0119, "LATIN SMALL LETTER E WITH OGONEK" },
	{ 0x011A, "LATIN CAPITAL LETTER E WITH CARON" },
	{ 0x011B, "LATIN SMALL LETTER E WITH CARON" },
	{ 0x011C, "LATIN CAPITAL LETTER G WITH CIRCUMFLEX" },
	{ 0x011D, "LATIN SMALL LETTER G WITH CIRCUMFLEX" },
	{ 0x011E, "LATIN CAPITAL LETTER G WITH BREVE" },
	{ 0x011F, "LATIN SMALL LETTER G WITH BREVE" },
	{ 0x0120, "LATIN CAPITAL LETTER G WITH DOT ABOVE" },
	{ 0x0121, "LATIN SMALL LETTER G WITH DOT ABOVE" },
	{ 0x0122, "LATIN CAPITAL LETTER G WITH CEDILLA" },
	{ 0x0123, "LATIN SMALL LETTER G WITH CEDILLA" },
	{ 0x0124, "LATIN CAPITAL LETTER H WITH CIRCUMFLEX" },
	{ 0x0125, "LATIN SMALL LETTER H WITH CIRCUMFLEX" },
	{ 0x0126, "LATIN CAPITAL LETTER H WITH STROKE" },
	{ 0x0127, "LATIN SMALL LETTER H WITH STROKE" },
	{ 0x0128, "LATIN CAPITAL LETTER I WITH TILDE" },
	{ 0x0129, "LATIN SMALL LETTER I WITH TILDE" },
	{ 0x012A, "LATIN CAPITAL LETTER I WITH MACRON" },
	{ 0x012B, "LATIN SMALL LETTER I WITH MACRON" },
	{ 0x012C, "LATIN CAPITAL LETTER I WITH BREVE" },
	{ 0x012D, "LATIN SMALL LETTER I WITH BREVE" },
	{ 0x012E, "LATIN CAPITAL LETTER I WITH OGONEK" },
	{ 0x012F, "LATIN SMALL LETTER I WITH OGONEK" },
	{ 0x0130, "LATIN CAPITAL LETTER I WITH DOT ABOVE" },
	{ 0x0131, "LATIN SMALL LETTER DOTLESS I" },
	{ 0x0132, "LATIN CAPITAL LIGATURE IJ" },
	{ 0x0133, "LATIN SMALL LIGATURE IJ" },
	{ 0x0134, "LATIN CAPITAL LETTER J WITH CIRCUMFLEX" },
	{ 0x0135, "LATIN SMALL LETTER J WITH CIRCUMFLEX" },
	{ 0x0136, "LATIN CAPITAL LETTER K WITH CEDILLA" },
	{ 0x0137, "LATIN SMALL LETTER K WITH CEDILLA" },
	{ 0x0138, "LATIN SMALL LETTER KRA" },	/* Greenlandic */
	{ 0x0139, "LATIN CAPITAL LETTER L WITH ACUTE" },
	{ 0x013A, "LATIN SMALL LETTER L WITH ACUTE" },
	{ 0x013B, "LATIN CAPITAL LETTER L WITH CEDILLA" },
	{ 0x013C, "LATIN SMALL LETTER L WITH CEDILLA" },
	{ 0x013D, "LATIN CAPITAL LETTER L WITH CARON" },
	{ 0x013E, "LATIN SMALL LETTER L WITH CARON" },
	{ 0x013F, "LATIN CAPITAL LETTER L WITH MIDDLE DOT" },
	{ 0x0140, "LATIN SMALL LETTER L WITH MIDDLE DOT" },
	{ 0x0141, "LATIN CAPITAL LETTER L WITH STROKE" },
	{ 0x0142, "LATIN SMALL LETTER L WITH STROKE" },
	{ 0x0143, "LATIN CAPITAL LETTER N WITH ACUTE" },
	{ 0x0144, "LATIN SMALL LETTER N WITH ACUTE" },
	{ 0x0145, "LATIN CAPITAL LETTER N WITH CEDILLA" },
	{ 0x0146, "LATIN SMALL LETTER N WITH CEDILLA" },
	{ 0x0147, "LATIN CAPITAL LETTER N WITH CARON" },
	{ 0x0148, "LATIN SMALL LETTER N WITH CARON" },
	{ 0x0149, "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE" },
	{ 0x014A, "LATIN CAPITAL LETTER ENG" },	/* Sami */
	{ 0x014B, "LATIN SMALL LETTER ENG" },	/* Sami */
	{ 0x014C, "LATIN CAPITAL LETTER O WITH MACRON" },
	{ 0x014D, "LATIN SMALL LETTER O WITH MACRON" },
	{ 0x014E, "LATIN CAPITAL LETTER O WITH BREVE" },
	{ 0x014F, "LATIN SMALL LETTER O WITH BREVE" },
	{ 0x0150, "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE" },
	{ 0x0151, "LATIN SMALL LETTER O WITH DOUBLE ACUTE" },
	{ 0x0152, "LATIN CAPITAL LIGATURE OE" },
	{ 0x0153, "LATIN SMALL LIGATURE OE" },
	{ 0x0154, "LATIN CAPITAL LETTER R WITH ACUTE" },
	{ 0x0155, "LATIN SMALL LETTER R WITH ACUTE" },
	{ 0x0156, "LATIN CAPITAL LETTER R WITH CEDILLA" },
	{ 0x0157, "LATIN SMALL LETTER R WITH CEDILLA" },
	{ 0x0158, "LATIN CAPITAL LETTER R WITH CARON" },
	{ 0x0159, "LATIN SMALL LETTER R WITH CARON" },
	{ 0x015A, "LATIN CAPITAL LETTER S WITH ACUTE" },
	{ 0x015B, "LATIN SMALL LETTER S WITH ACUTE" },
	{ 0x015C, "LATIN CAPITAL LETTER S WITH CIRCUMFLEX" },
	{ 0x015D, "LATIN SMALL LETTER S WITH CIRCUMFLEX" },
	{ 0x015E, "LATIN CAPITAL LETTER S WITH CEDILLA" },	/* * */
	{ 0x015F, "LATIN SMALL LETTER S WITH CEDILLA" },	/* * */
	{ 0x0160, "LATIN CAPITAL LETTER S WITH CARON" },
	{ 0x0161, "LATIN SMALL LETTER S WITH CARON" },
	{ 0x0162, "LATIN CAPITAL LETTER T WITH CEDILLA" },	/* * */
	{ 0x0163, "LATIN SMALL LETTER T WITH CEDILLA" },	/* * */
	{ 0x0164, "LATIN CAPITAL LETTER T WITH CARON" },
	{ 0x0165, "LATIN SMALL LETTER T WITH CARON" },
	{ 0x0166, "LATIN CAPITAL LETTER T WITH STROKE" },
	{ 0x0167, "LATIN SMALL LETTER T WITH STROKE" },
	{ 0x0168, "LATIN CAPITAL LETTER U WITH TILDE" },
	{ 0x0169, "LATIN SMALL LETTER U WITH TILDE" },
	{ 0x016A, "LATIN CAPITAL LETTER U WITH MACRON" },
	{ 0x016B, "LATIN SMALL LETTER U WITH MACRON" },
	{ 0x016C, "LATIN CAPITAL LETTER U WITH BREVE" },
	{ 0x016D, "LATIN SMALL LETTER U WITH BREVE" },
	{ 0x016E, "LATIN CAPITAL LETTER U WITH RING ABOVE" },
	{ 0x016F, "LATIN SMALL LETTER U WITH RING ABOVE" },
	{ 0x0170, "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE" },
	{ 0x0171, "LATIN SMALL LETTER U WITH DOUBLE ACUTE" },
	{ 0x0172, "LATIN CAPITAL LETTER U WITH OGONEK" },
	{ 0x0173, "LATIN SMALL LETTER U WITH OGONEK" },
	{ 0x0174, "LATIN CAPITAL LETTER W WITH CIRCUMFLEX" },
	{ 0x0175, "LATIN SMALL LETTER W WITH CIRCUMFLEX" },
	{ 0x0176, "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX" },
	{ 0x0177, "LATIN SMALL LETTER Y WITH CIRCUMFLEX" },
	{ 0x0178, "LATIN CAPITAL LETTER Y WITH DIAERESIS" },
	{ 0x0179, "LATIN CAPITAL LETTER Z WITH ACUTE" },
	{ 0x017A, "LATIN SMALL LETTER Z WITH ACUTE" },
	{ 0x017B, "LATIN CAPITAL LETTER Z WITH DOT ABOVE" },
	{ 0x017C, "LATIN SMALL LETTER Z WITH DOT ABOVE" },
	{ 0x017D, "LATIN CAPITAL LETTER Z WITH CARON" },
	{ 0x017E, "LATIN SMALL LETTER Z WITH CARON" },
	{ 0x017F, "LATIN SMALL LETTER LONG S" },
	{ 0x0180, "LATIN SMALL LETTER B WITH STROKE" },
	{ 0x0181, "LATIN CAPITAL LETTER B WITH HOOK" },
	{ 0x0182, "LATIN CAPITAL LETTER B WITH TOPBAR" },
	{ 0x0183, "LATIN SMALL LETTER B WITH TOPBAR" },
	{ 0x0184, "LATIN CAPITAL LETTER TONE SIX" },
	{ 0x0185, "LATIN SMALL LETTER TONE SIX" },
	{ 0x0186, "LATIN CAPITAL LETTER OPEN O" },
	{ 0x0187, "LATIN CAPITAL LETTER C WITH HOOK" },
	{ 0x0188, "LATIN SMALL LETTER C WITH HOOK" },
	{ 0x0189, "LATIN CAPITAL LETTER AFRICAN D" },	/* * */
	{ 0x018A, "LATIN CAPITAL LETTER D WITH HOOK" },
	{ 0x018B, "LATIN CAPITAL LETTER D WITH TOPBAR" },
	{ 0x018C, "LATIN SMALL LETTER D WITH TOPBAR" },
	{ 0x018D, "LATIN SMALL LETTER TURNED DELTA" },
	{ 0x018E, "LATIN CAPITAL LETTER REVERSED E" },
	{ 0x018F, "LATIN CAPITAL LETTER SCHWA" },
	{ 0x0190, "LATIN CAPITAL LETTER OPEN E" },
	{ 0x0191, "LATIN CAPITAL LETTER F WITH HOOK" },
	{ 0x0192, "LATIN SMALL LETTER F WITH HOOK" },
	{ 0x0193, "LATIN CAPITAL LETTER G WITH HOOK" },
	{ 0x0194, "LATIN CAPITAL LETTER GAMMA" },
	{ 0x0195, "LATIN SMALL LETTER HV" },	/* hwair */
	{ 0x0196, "LATIN CAPITAL LETTER IOTA" },
	{ 0x0197, "LATIN CAPITAL LETTER I WITH STROKE" },
	{ 0x0198, "LATIN CAPITAL LETTER K WITH HOOK" },
	{ 0x0199, "LATIN SMALL LETTER K WITH HOOK" },
	{ 0x019A, "LATIN SMALL LETTER L WITH BAR" },
	{ 0x019B, "LATIN SMALL LETTER LAMBDA WITH STROKE" },
	{ 0x019C, "LATIN CAPITAL LETTER TURNED M" },
	{ 0x019D, "LATIN CAPITAL LETTER N WITH LEFT HOOK" },
	{ 0x019E, "LATIN SMALL LETTER N WITH LONG RIGHT LEG" },
	{ 0x019F, "LATIN CAPITAL LETTER O WITH MIDDLE TILDE" },	/* * */
	{ 0x01A0, "LATIN CAPITAL LETTER O WITH HORN" },
	{ 0x01A1, "LATIN SMALL LETTER O WITH HORN" },
	{ 0x01A2, "LATIN CAPITAL LETTER OI" },	/* gha */
	{ 0x01A3, "LATIN SMALL LETTER OI" },	/* gha */
	{ 0x01A4, "LATIN CAPITAL LETTER P WITH HOOK" },
	{ 0x01A5, "LATIN SMALL LETTER P WITH HOOK" },
	{ 0x01A6, "LATIN LETTER YR" },	/* * */
	{ 0x01A7, "LATIN CAPITAL LETTER TONE TWO" },
	{ 0x01A8, "LATIN SMALL LETTER TONE TWO" },
	{ 0x01A9, "LATIN CAPITAL LETTER ESH" },
	{ 0x01AA, "LATIN LETTER REVERSED ESH LOOP" },
	{ 0x01AB, "LATIN SMALL LETTER T WITH PALATAL HOOK" },
	{ 0x01AC, "LATIN CAPITAL LETTER T WITH HOOK" },
	{ 0x01AD, "LATIN SMALL LETTER T WITH HOOK" },
	{ 0x01AE, "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK" },
	{ 0x01AF, "LATIN CAPITAL LETTER U WITH HORN" },
	{ 0x01B0, "LATIN SMALL LETTER U WITH HORN" },
	{ 0x01B1, "LATIN CAPITAL LETTER UPSILON" },
	{ 0x01B2, "LATIN CAPITAL LETTER V WITH HOOK" },
	{ 0x01B3, "LATIN CAPITAL LETTER Y WITH HOOK" },
	{ 0x01B4, "LATIN SMALL LETTER Y WITH HOOK" },
	{ 0x01B5, "LATIN CAPITAL LETTER Z WITH STROKE" },
	{ 0x01B6, "LATIN SMALL LETTER Z WITH STROKE" },
	{ 0x01B7, "LATIN CAPITAL LETTER EZH" },
	{ 0x01B8, "LATIN CAPITAL LETTER EZH REVERSED" },
	{ 0x01B9, "LATIN SMALL LETTER EZH REVERSED" },
	{ 0x01BA, "LATIN SMALL LETTER EZH WITH TAIL" },
	{ 0x01BB, "LATIN LETTER TWO WITH STROKE" },
	{ 0x01BC, "LATIN CAPITAL LETTER TONE FIVE" },
	{ 0x01BD, "LATIN SMALL LETTER TONE FIVE" },
	{ 0x01BE, "LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE" },
	{ 0x01BF, "LATIN LETTER WYNN" },
	{ 0x01C0, "LATIN LETTER DENTAL CLICK" },
	{ 0x01C1, "LATIN LETTER LATERAL CLICK" },
	{ 0x01C2, "LATIN LETTER ALVEOLAR CLICK" },
	{ 0x01C3, "LATIN LETTER RETROFLEX CLICK" },
	{ 0x01C4, "LATIN CAPITAL LETTER DZ WITH CARON" },
	{ 0x01C5, "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON" },
	{ 0x01C6, "LATIN SMALL LETTER DZ WITH CARON" },
	{ 0x01C7, "LATIN CAPITAL LETTER LJ" },
	{ 0x01C8, "LATIN CAPITAL LETTER L WITH SMALL LETTER J" },
	{ 0x01C9, "LATIN SMALL LETTER LJ" },
	{ 0x01CA, "LATIN CAPITAL LETTER NJ" },
	{ 0x01CB, "LATIN CAPITAL LETTER N WITH SMALL LETTER J" },
	{ 0x01CC, "LATIN SMALL LETTER NJ" },
	{ 0x01CD, "LATIN CAPITAL LETTER A WITH CARON" },
	{ 0x01CE, "LATIN SMALL LETTER A WITH CARON" },
	{ 0x01CF, "LATIN CAPITAL LETTER I WITH CARON" },
	{ 0x01D0, "LATIN SMALL LETTER I WITH CARON" },
	{ 0x01D1, "LATIN CAPITAL LETTER O WITH CARON" },
	{ 0x01D2, "LATIN SMALL LETTER O WITH CARON" },
	{ 0x01D3, "LATIN CAPITAL LETTER U WITH CARON" },
	{ 0x01D4, "LATIN SMALL LETTER U WITH CARON" },
	{ 0x01D5, "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON" },
	{ 0x01D6, "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON" },
	{ 0x01D7, "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE" },
	{ 0x01D8, "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE" },
	{ 0x01D9, "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON" },
	{ 0x01DA, "LATIN SMALL LETTER U WITH DIAERESIS AND CARON" },
	{ 0x01DB, "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE" },
	{ 0x01DC, "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE" },
	{ 0x01DD, "LATIN SMALL LETTER TURNED E" },
	{ 0x01DE, "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON" },
	{ 0x01DF, "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON" },
	{ 0x01E0, "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON" },
	{ 0x01E1, "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON" },
	{ 0x01E2, "LATIN CAPITAL LETTER AE WITH MACRON" },	/* ash * */
	{ 0x01E3, "LATIN SMALL LETTER AE WITH MACRON" },	/* ash * */
	{ 0x01E4, "LATIN CAPITAL LETTER G WITH STROKE" },
	{ 0x01E5, "LATIN SMALL LETTER G WITH STROKE" },
	{ 0x01E6, "LATIN CAPITAL LETTER G WITH CARON" },
	{ 0x01E7, "LATIN SMALL LETTER G WITH CARON" },
	{ 0x01E8, "LATIN CAPITAL LETTER K WITH CARON" },
	{ 0x01E9, "LATIN SMALL LETTER K WITH CARON" },
	{ 0x01EA, "LATIN CAPITAL LETTER O WITH OGONEK" },
	{ 0x01EB, "LATIN SMALL LETTER O WITH OGONEK" },
	{ 0x01EC, "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON" },
	{ 0x01ED, "LATIN SMALL LETTER O WITH OGONEK AND MACRON" },
	{ 0x01EE, "LATIN CAPITAL LETTER EZH WITH CARON" },
	{ 0x01EF, "LATIN SMALL LETTER EZH WITH CARON" },
	{ 0x01F0, "LATIN SMALL LETTER J WITH CARON" },
	{ 0x01F1, "LATIN CAPITAL LETTER DZ" },
	{ 0x01F2, "LATIN CAPITAL LETTER D WITH SMALL LETTER Z" },
	{ 0x01F3, "LATIN SMALL LETTER DZ" },
	{ 0x01F4, "LATIN CAPITAL LETTER G WITH ACUTE" },
	{ 0x01F5, "LATIN SMALL LETTER G WITH ACUTE" },
	{ 0x01F6, "LATIN CAPITAL LETTER HWAIR" },
	{ 0x01F7, "LATIN CAPITAL LETTER WYNN" },
	{ 0x01F8, "LATIN CAPITAL LETTER N WITH GRAVE" },
	{ 0x01F9, "LATIN SMALL LETTER N WITH GRAVE" },
	{ 0x01FA, "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE" },
	{ 0x01FB, "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE" },
	{ 0x01FC, "LATIN CAPITAL LETTER AE WITH ACUTE" },	/* ash * */
	{ 0x01FD, "LATIN SMALL LETTER AE WITH ACUTE" },	/* ash * */
	{ 0x01FE, "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE" },
	{ 0x01FF, "LATIN SMALL LETTER O WITH STROKE AND ACUTE" },
	{ 0x0200, "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE" },
	{ 0x0201, "LATIN SMALL LETTER A WITH DOUBLE GRAVE" },
	{ 0x0202, "LATIN CAPITAL LETTER A WITH INVERTED BREVE" },
	{ 0x0203, "LATIN SMALL LETTER A WITH INVERTED BREVE" },
	{ 0x0204, "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE" },
	{ 0x0205, "LATIN SMALL LETTER E WITH DOUBLE GRAVE" },
	{ 0x0206, "LATIN CAPITAL LETTER E WITH INVERTED BREVE" },
	{ 0x0207, "LATIN SMALL LETTER E WITH INVERTED BREVE" },
	{ 0x0208, "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE" },
	{ 0x0209, "LATIN SMALL LETTER I WITH DOUBLE GRAVE" },
	{ 0x020A, "LATIN CAPITAL LETTER I WITH INVERTED BREVE" },
	{ 0x020B, "LATIN SMALL LETTER I WITH INVERTED BREVE" },
	{ 0x020C, "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE" },
	{ 0x020D, "LATIN SMALL LETTER O WITH DOUBLE GRAVE" },
	{ 0x020E, "LATIN CAPITAL LETTER O WITH INVERTED BREVE" },
	{ 0x020F, "LATIN SMALL LETTER O WITH INVERTED BREVE" },
	{ 0x0210, "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE" },
	{ 0x0211, "LATIN SMALL LETTER R WITH DOUBLE GRAVE" },
	{ 0x0212, "LATIN CAPITAL LETTER R WITH INVERTED BREVE" },
	{ 0x0213, "LATIN SMALL LETTER R WITH INVERTED BREVE" },
	{ 0x0214, "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE" },
	{ 0x0215, "LATIN SMALL LETTER U WITH DOUBLE GRAVE" },
	{ 0x0216, "LATIN CAPITAL LETTER U WITH INVERTED BREVE" },
	{ 0x0217, "LATIN SMALL LETTER U WITH INVERTED BREVE" },
	{ 0x0218, "LATIN CAPITAL LETTER S WITH COMMA BELOW" },	/* * */
	{ 0x0219, "LATIN SMALL LETTER S WITH COMMA BELOW" },	/* * */
	{ 0x021A, "LATIN CAPITAL LETTER T WITH COMMA BELOW" },	/* * */
	{ 0x021B, "LATIN SMALL LETTER T WITH COMMA BELOW" },	/* * */
	{ 0x021C, "LATIN CAPITAL LETTER YOGH" },
	{ 0x021D, "LATIN SMALL LETTER YOGH" },
	{ 0x021E, "LATIN CAPITAL LETTER H WITH CARON" },
	{ 0x021F, "LATIN SMALL LETTER H WITH CARON" },
	{ 0x0222, "LATIN CAPITAL LETTER OU" },
	{ 0x0223, "LATIN SMALL LETTER OU" },
	{ 0x0224, "LATIN CAPITAL LETTER Z WITH HOOK" },
	{ 0x0225, "LATIN SMALL LETTER Z WITH HOOK" },
	{ 0x0226, "LATIN CAPITAL LETTER A WITH DOT ABOVE" },
	{ 0x0227, "LATIN SMALL LETTER A WITH DOT ABOVE" },
	{ 0x0228, "LATIN CAPITAL LETTER E WITH CEDILLA" },
	{ 0x0229, "LATIN SMALL LETTER E WITH CEDILLA" },
	{ 0x022A, "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON" },
	{ 0x022B, "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON" },
	{ 0x022C, "LATIN CAPITAL LETTER O WITH TILDE AND MACRON" },
	{ 0x022D, "LATIN SMALL LETTER O WITH TILDE AND MACRON" },
	{ 0x022E, "LATIN CAPITAL LETTER O WITH DOT ABOVE" },
	{ 0x022F, "LATIN SMALL LETTER O WITH DOT ABOVE" },
	{ 0x0230, "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON" },
	{ 0x0231, "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON" },
	{ 0x0232, "LATIN CAPITAL LETTER Y WITH MACRON" },
	{ 0x0233, "LATIN SMALL LETTER Y WITH MACRON" },
	{ 0x0250, "LATIN SMALL LETTER TURNED A" },
	{ 0x0251, "LATIN SMALL LETTER ALPHA" },
	{ 0x0252, "LATIN SMALL LETTER TURNED ALPHA" },
	{ 0x0253, "LATIN SMALL LETTER B WITH HOOK" },
	{ 0x0254, "LATIN SMALL LETTER OPEN O" },
	{ 0x0255, "LATIN SMALL LETTER C WITH CURL" },
	{ 0x0256, "LATIN SMALL LETTER D WITH TAIL" },
	{ 0x0257, "LATIN SMALL LETTER D WITH HOOK" },
	{ 0x0258, "LATIN SMALL LETTER REVERSED E" },
	{ 0x0259, "LATIN SMALL LETTER SCHWA" },
	{ 0x025A, "LATIN SMALL LETTER SCHWA WITH HOOK" },
	{ 0x025B, "LATIN SMALL LETTER OPEN E" },
	{ 0x025C, "LATIN SMALL LETTER REVERSED OPEN E" },
	{ 0x025D, "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK" },
	{ 0x025E, "LATIN SMALL LETTER CLOSED REVERSED OPEN E" },
	{ 0x025F, "LATIN SMALL LETTER DOTLESS J WITH STROKE" },
	{ 0x0260, "LATIN SMALL LETTER G WITH HOOK" },
	{ 0x0261, "LATIN SMALL LETTER SCRIPT G" },
	{ 0x0262, "LATIN LETTER SMALL CAPITAL G" },
	{ 0x0263, "LATIN SMALL LETTER GAMMA" },
	{ 0x0264, "LATIN SMALL LETTER RAMS HORN" },
	{ 0x0265, "LATIN SMALL LETTER TURNED H" },
	{ 0x0266, "LATIN SMALL LETTER H WITH HOOK" },
	{ 0x0267, "LATIN SMALL LETTER HENG WITH HOOK" },
	{ 0x0268, "LATIN SMALL LETTER I WITH STROKE" },
	{ 0x0269, "LATIN SMALL LETTER IOTA" },
	{ 0x026A, "LATIN LETTER SMALL CAPITAL I" },
	{ 0x026B, "LATIN SMALL LETTER L WITH MIDDLE TILDE" },
	{ 0x026C, "LATIN SMALL LETTER L WITH BELT" },
	{ 0x026D, "LATIN SMALL LETTER L WITH RETROFLEX HOOK" },
	{ 0x026E, "LATIN SMALL LETTER LEZH" },
	{ 0x026F, "LATIN SMALL LETTER TURNED M" },
	{ 0x0270, "LATIN SMALL LETTER TURNED M WITH LONG LEG" },
	{ 0x0271, "LATIN SMALL LETTER M WITH HOOK" },
	{ 0x0272, "LATIN SMALL LETTER N WITH LEFT HOOK" },
	{ 0x0273, "LATIN SMALL LETTER N WITH RETROFLEX HOOK" },
	{ 0x0274, "LATIN LETTER SMALL CAPITAL N" },
	{ 0x0275, "LATIN SMALL LETTER BARRED O" },
	{ 0x0276, "LATIN LETTER SMALL CAPITAL OE" },
	{ 0x0277, "LATIN SMALL LETTER CLOSED OMEGA" },
	{ 0x0278, "LATIN SMALL LETTER PHI" },
	{ 0x0279, "LATIN SMALL LETTER TURNED R" },
	{ 0x027A, "LATIN SMALL LETTER TURNED R WITH LONG LEG" },
	{ 0x027B, "LATIN SMALL LETTER TURNED R WITH HOOK" },
	{ 0x027C, "LATIN SMALL LETTER R WITH LONG LEG" },
	{ 0x027D, "LATIN SMALL LETTER R WITH TAIL" },
	{ 0x027E, "LATIN SMALL LETTER R WITH FISHHOOK" },
	{ 0x027F, "LATIN SMALL LETTER REVERSED R WITH FISHHOOK" },
	{ 0x0280, "LATIN LETTER SMALL CAPITAL R" },	/* * */
	{ 0x0281, "LATIN LETTER SMALL CAPITAL INVERTED R" },
	{ 0x0282, "LATIN SMALL LETTER S WITH HOOK" },
	{ 0x0283, "LATIN SMALL LETTER ESH" },
	{ 0x0284, "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK" },
	{ 0x0285, "LATIN SMALL LETTER SQUAT REVERSED ESH" },
	{ 0x0286, "LATIN SMALL LETTER ESH WITH CURL" },
	{ 0x0287, "LATIN SMALL LETTER TURNED T" },
	{ 0x0288, "LATIN SMALL LETTER T WITH RETROFLEX HOOK" },
	{ 0x0289, "LATIN SMALL LETTER U BAR" },
	{ 0x028A, "LATIN SMALL LETTER UPSILON" },
	{ 0x028B, "LATIN SMALL LETTER V WITH HOOK" },
	{ 0x028C, "LATIN SMALL LETTER TURNED V" },
	{ 0x028D, "LATIN SMALL LETTER TURNED W" },
	{ 0x028E, "LATIN SMALL LETTER TURNED Y" },
	{ 0x028F, "LATIN LETTER SMALL CAPITAL Y" },
	{ 0x0290, "LATIN SMALL LETTER Z WITH RETROFLEX HOOK" },
	{ 0x0291, "LATIN SMALL LETTER Z WITH CURL" },
	{ 0x0292, "LATIN SMALL LETTER EZH" },
	{ 0x0293, "LATIN SMALL LETTER EZH WITH CURL" },
	{ 0x0294, "LATIN LETTER GLOTTAL STOP" },
	{ 0x0295, "LATIN LETTER PHARYNGEAL VOICED FRICATIVE" },
	{ 0x0296, "LATIN LETTER INVERTED GLOTTAL STOP" },
	{ 0x0297, "LATIN LETTER STRETCHED C" },
	{ 0x0298, "LATIN LETTER BILABIAL CLICK" },
	{ 0x0299, "LATIN LETTER SMALL CAPITAL B" },
	{ 0x029A, "LATIN SMALL LETTER CLOSED OPEN E" },
	{ 0x029B, "LATIN LETTER SMALL CAPITAL G WITH HOOK" },
	{ 0x029C, "LATIN LETTER SMALL CAPITAL H" },
	{ 0x029D, "LATIN SMALL LETTER J WITH CROSSED-TAIL" },
	{ 0x029E, "LATIN SMALL LETTER TURNED K" },
	{ 0x029F, "LATIN LETTER SMALL CAPITAL L" },
	{ 0x02A0, "LATIN SMALL LETTER Q WITH HOOK" },
	{ 0x02A1, "LATIN LETTER GLOTTAL STOP WITH STROKE" },
	{ 0x02A2, "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE" },
	{ 0x02A3, "LATIN SMALL LETTER DZ DIGRAPH" },
	{ 0x02A4, "LATIN SMALL LETTER DEZH DIGRAPH" },
	{ 0x02A5, "LATIN SMALL LETTER DZ DIGRAPH WITH CURL" },
	{ 0x02A6, "LATIN SMALL LETTER TS DIGRAPH" },
	{ 0x02A7, "LATIN SMALL LETTER TESH DIGRAPH" },
	{ 0x02A8, "LATIN SMALL LETTER TC DIGRAPH WITH CURL" },
	{ 0x02A9, "LATIN SMALL LETTER FENG DIGRAPH" },
	{ 0x02AA, "LATIN SMALL LETTER LS DIGRAPH" },
	{ 0x02AB, "LATIN SMALL LETTER LZ DIGRAPH" },
	{ 0x02AC, "LATIN LETTER BILABIAL PERCUSSIVE" },
	{ 0x02AD, "LATIN LETTER BIDENTAL PERCUSSIVE" },
	{ 0x02B0, "MODIFIER LETTER SMALL H" },
	{ 0x02B1, "MODIFIER LETTER SMALL H WITH HOOK" },
	{ 0x02B2, "MODIFIER LETTER SMALL J" },
	{ 0x02B3, "MODIFIER LETTER SMALL R" },
	{ 0x02B4, "MODIFIER LETTER SMALL TURNED R" },
	{ 0x02B5, "MODIFIER LETTER SMALL TURNED R WITH HOOK" },
	{ 0x02B6, "MODIFIER LETTER SMALL CAPITAL INVERTED R" },
	{ 0x02B7, "MODIFIER LETTER SMALL W" },
	{ 0x02B8, "MODIFIER LETTER SMALL Y" },
	{ 0x02B9, "MODIFIER LETTER PRIME" },
	{ 0x02BA, "MODIFIER LETTER DOUBLE PRIME" },
	{ 0x02BB, "MODIFIER LETTER TURNED COMMA" },
	{ 0x02BC, "MODIFIER LETTER APOSTROPHE" },
	{ 0x02BD, "MODIFIER LETTER REVERSED COMMA" },
	{ 0x02BE, "MODIFIER LETTER RIGHT HALF RING" },
	{ 0x02BF, "MODIFIER LETTER LEFT HALF RING" },
	{ 0x02C0, "MODIFIER LETTER GLOTTAL STOP" },
	{ 0x02C1, "MODIFIER LETTER REVERSED GLOTTAL STOP" },
	{ 0x02C2, "MODIFIER LETTER LEFT ARROWHEAD" },
	{ 0x02C3, "MODIFIER LETTER RIGHT ARROWHEAD" },
	{ 0x02C4, "MODIFIER LETTER UP ARROWHEAD" },
	{ 0x02C5, "MODIFIER LETTER DOWN ARROWHEAD" },
	{ 0x02C6, "MODIFIER LETTER CIRCUMFLEX ACCENT" },
	{ 0x02C7, "CARON" },	/* Mandarin Chinese third tone */
	{ 0x02C8, "MODIFIER LETTER VERTICAL LINE" },
	{ 0x02C9, "MODIFIER LETTER MACRON" },	/* Mandarin Chinese first tone */
	{ 0x02CA, "MODIFIER LETTER ACUTE ACCENT" },	/* Mandarin Chinese second tone */
	{ 0x02CB, "MODIFIER LETTER GRAVE ACCENT" },	/* Mandarin Chinese fourth tone */
	{ 0x02CC, "MODIFIER LETTER LOW VERTICAL LINE" },
	{ 0x02CD, "MODIFIER LETTER LOW MACRON" },
	{ 0x02CE, "MODIFIER LETTER LOW GRAVE ACCENT" },
	{ 0x02CF, "MODIFIER LETTER LOW ACUTE ACCENT" },
	{ 0x02D0, "MODIFIER LETTER TRIANGULAR COLON" },
	{ 0x02D1, "MODIFIER LETTER HALF TRIANGULAR COLON" },
	{ 0x02D2, "MODIFIER LETTER CENTRED RIGHT HALF RING" },
	{ 0x02D3, "MODIFIER LETTER CENTRED LEFT HALF RING" },
	{ 0x02D4, "MODIFIER LETTER UP TACK" },
	{ 0x02D5, "MODIFIER LETTER DOWN TACK" },
	{ 0x02D6, "MODIFIER LETTER PLUS SIGN" },
	{ 0x02D7, "MODIFIER LETTER MINUS SIGN" },
	{ 0x02D8, "BREVE" },
	{ 0x02D9, "DOT ABOVE" },	/* Mandarin Chinese light tone */
	{ 0x02DA, "RING ABOVE" },
	{ 0x02DB, "OGONEK" },
	{ 0x02DC, "SMALL TILDE" },
	{ 0x02DD, "DOUBLE ACUTE ACCENT" },
	{ 0x02DE, "MODIFIER LETTER RHOTIC HOOK" },
	{ 0x02DF, "MODIFIER LETTER CROSS ACCENT" },
	{ 0x02E0, "MODIFIER LETTER SMALL GAMMA" },
	{ 0x02E1, "MODIFIER LETTER SMALL L" },
	{ 0x02E2, "MODIFIER LETTER SMALL S" },
	{ 0x02E3, "MODIFIER LETTER SMALL X" },
	{ 0x02E4, "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP" },
	{ 0x02E5, "MODIFIER LETTER EXTRA-HIGH TONE BAR" },
	{ 0x02E6, "MODIFIER LETTER HIGH TONE BAR" },
	{ 0x02E7, "MODIFIER LETTER MID TONE BAR" },
	{ 0x02E8, "MODIFIER LETTER LOW TONE BAR" },
	{ 0x02E9, "MODIFIER LETTER EXTRA-LOW TONE BAR" },
	{ 0x02EA, "MODIFIER LETTER YIN DEPARTING TONE MARK" },
	{ 0x02EB, "MODIFIER LETTER YANG DEPARTING TONE MARK" },
	{ 0x02EC, "MODIFIER LETTER VOICING" },
	{ 0x02ED, "MODIFIER LETTER UNASPIRATED" },
	{ 0x02EE, "MODIFIER LETTER DOUBLE APOSTROPHE" },
	{ 0x0300, "COMBINING GRAVE ACCENT" },	/* Varia */
	{ 0x0301, "COMBINING ACUTE ACCENT" },	/* Oxia */
	{ 0x0302, "COMBINING CIRCUMFLEX ACCENT" },
	{ 0x0303, "COMBINING TILDE" },
	{ 0x0304, "COMBINING MACRON" },
	{ 0x0305, "COMBINING OVERLINE" },
	{ 0x0306, "COMBINING BREVE" },	/* Vrachy */
	{ 0x0307, "COMBINING DOT ABOVE" },
	{ 0x0308, "COMBINING DIAERESIS" },	/* Dialytika */
	{ 0x0309, "COMBINING HOOK ABOVE" },
	{ 0x030A, "COMBINING RING ABOVE" },
	{ 0x030B, "COMBINING DOUBLE ACUTE ACCENT" },
	{ 0x030C, "COMBINING CARON" },
	{ 0x030D, "COMBINING VERTICAL LINE ABOVE" },	/* Tonos */
	{ 0x030E, "COMBINING DOUBLE VERTICAL LINE ABOVE" },
	{ 0x030F, "COMBINING DOUBLE GRAVE ACCENT" },
	{ 0x0310, "COMBINING CANDRABINDU" },
	{ 0x0311, "COMBINING INVERTED BREVE" },
	{ 0x0312, "COMBINING TURNED COMMA ABOVE" },
	{ 0x0313, "COMBINING COMMA ABOVE" },	/* Psili */
	{ 0x0314, "COMBINING REVERSED COMMA ABOVE" },	/* Dasia */
	{ 0x0315, "COMBINING COMMA ABOVE RIGHT" },
	{ 0x0316, "COMBINING GRAVE ACCENT BELOW" },
	{ 0x0317, "COMBINING ACUTE ACCENT BELOW" },
	{ 0x0318, "COMBINING LEFT TACK BELOW" },
	{ 0x0319, "COMBINING RIGHT TACK BELOW" },
	{ 0x031A, "COMBINING LEFT ANGLE ABOVE" },
	{ 0x031B, "COMBINING HORN" },
	{ 0x031C, "COMBINING LEFT HALF RING BELOW" },
	{ 0x031D, "COMBINING UP TACK BELOW" },
	{ 0x031E, "COMBINING DOWN TACK BELOW" },
	{ 0x031F, "COMBINING PLUS SIGN BELOW" },
	{ 0x0320, "COMBINING MINUS SIGN BELOW" },
	{ 0x0321, "COMBINING PALATALIZED HOOK BELOW" },
	{ 0x0322, "COMBINING RETROFLEX HOOK BELOW" },
	{ 0x0323, "COMBINING DOT BELOW" },
	{ 0x0324, "COMBINING DIAERESIS BELOW" },
	{ 0x0325, "COMBINING RING BELOW" },
	{ 0x0326, "COMBINING COMMA BELOW" },
	{ 0x0327, "COMBINING CEDILLA" },
	{ 0x0328, "COMBINING OGONEK" },
	{ 0x0329, "COMBINING VERTICAL LINE BELOW" },
	{ 0x032A, "COMBINING BRIDGE BELOW" },
	{ 0x032B, "COMBINING INVERTED DOUBLE ARCH BELOW" },
	{ 0x032C, "COMBINING CARON BELOW" },
	{ 0x032D, "COMBINING CIRCUMFLEX ACCENT BELOW" },
	{ 0x032E, "COMBINING BREVE BELOW" },
	{ 0x032F, "COMBINING INVERTED BREVE BELOW" },
	{ 0x0330, "COMBINING TILDE BELOW" },
	{ 0x0331, "COMBINING MACRON BELOW" },
	{ 0x0332, "COMBINING LOW LINE" },
	{ 0x0333, "COMBINING DOUBLE LOW LINE" },
	{ 0x0334, "COMBINING TILDE OVERLAY" },
	{ 0x0335, "COMBINING SHORT STROKE OVERLAY" },
	{ 0x0336, "COMBINING LONG STROKE OVERLAY" },
	{ 0x0337, "COMBINING SHORT SOLIDUS OVERLAY" },
	{ 0x0338, "COMBINING LONG SOLIDUS OVERLAY" },
	{ 0x0339, "COMBINING RIGHT HALF RING BELOW" },
	{ 0x033A, "COMBINING INVERTED BRIDGE BELOW" },
	{ 0x033B, "COMBINING SQUARE BELOW" },
	{ 0x033C, "COMBINING SEAGULL BELOW" },
	{ 0x033D, "COMBINING X ABOVE" },
	{ 0x033E, "COMBINING VERTICAL TILDE" },
	{ 0x033F, "COMBINING DOUBLE OVERLINE" },
	{ 0x0340, "COMBINING GRAVE TONE MARK" },	/* Vietnamese */
	{ 0x0341, "COMBINING ACUTE TONE MARK" },	/* Vietnamese */
	{ 0x0342, "COMBINING GREEK PERISPOMENI" },
	{ 0x0343, "COMBINING GREEK KORONIS" },
	{ 0x0344, "COMBINING GREEK DIALYTIKA TONOS" },
	{ 0x0345, "COMBINING GREEK YPOGEGRAMMENI" },
	{ 0x0346, "COMBINING BRIDGE ABOVE" },
	{ 0x0347, "COMBINING EQUALS SIGN BELOW" },
	{ 0x0348, "COMBINING DOUBLE VERTICAL LINE BELOW" },
	{ 0x0349, "COMBINING LEFT ANGLE BELOW" },
	{ 0x034A, "COMBINING NOT TILDE ABOVE" },
	{ 0x034B, "COMBINING HOMOTHETIC ABOVE" },
	{ 0x034C, "COMBINING ALMOST EQUAL TO ABOVE" },
	{ 0x034D, "COMBINING LEFT RIGHT ARROW BELOW" },
	{ 0x034E, "COMBINING UPWARDS ARROW BELOW" },
	{ 0x0360, "COMBINING DOUBLE TILDE" },
	{ 0x0361, "COMBINING DOUBLE INVERTED BREVE" },
	{ 0x0362, "COMBINING DOUBLE RIGHTWARDS ARROW BELOW" },
	{ 0x0374, "GREEK NUMERAL SIGN" },	/* Dexia keraia */
	{ 0x0375, "GREEK LOWER NUMERAL SIGN" },	/* Aristeri keraia */
	{ 0x037A, "GREEK YPOGEGRAMMENI" },
	{ 0x037E, "GREEK QUESTION MARK" },	/* Erotimatiko */
	{ 0x0384, "GREEK TONOS" },
	{ 0x0385, "GREEK DIALYTIKA TONOS" },
	{ 0x0386, "GREEK CAPITAL LETTER ALPHA WITH TONOS" },
	{ 0x0387, "GREEK ANO TELEIA" },
	{ 0x0388, "GREEK CAPITAL LETTER EPSILON WITH TONOS" },
	{ 0x0389, "GREEK CAPITAL LETTER ETA WITH TONOS" },
	{ 0x038A, "GREEK CAPITAL LETTER IOTA WITH TONOS" },
	{ 0x038C, "GREEK CAPITAL LETTER OMICRON WITH TONOS" },
	{ 0x038E, "GREEK CAPITAL LETTER UPSILON WITH TONOS" },
	{ 0x038F, "GREEK CAPITAL LETTER OMEGA WITH TONOS" },
	{ 0x0390, "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" },
	{ 0x0391, "GREEK CAPITAL LETTER ALPHA" },
	{ 0x0392, "GREEK CAPITAL LETTER BETA" },
	{ 0x0393, "GREEK CAPITAL LETTER GAMMA" },
	{ 0x0394, "GREEK CAPITAL LETTER DELTA" },
	{ 0x0395, "GREEK CAPITAL LETTER EPSILON" },
	{ 0x0396, "GREEK CAPITAL LETTER ZETA" },
	{ 0x0397, "GREEK CAPITAL LETTER ETA" },
	{ 0x0398, "GREEK CAPITAL LETTER THETA" },
	{ 0x0399, "GREEK CAPITAL LETTER IOTA" },
	{ 0x039A, "GREEK CAPITAL LETTER KAPPA" },
	{ 0x039B, "GREEK CAPITAL LETTER LAMDA" },
	{ 0x039C, "GREEK CAPITAL LETTER MU" },
	{ 0x039D, "GREEK CAPITAL LETTER NU" },
	{ 0x039E, "GREEK CAPITAL LETTER XI" },
	{ 0x039F, "GREEK CAPITAL LETTER OMICRON" },
	{ 0x03A0, "GREEK CAPITAL LETTER PI" },
	{ 0x03A1, "GREEK CAPITAL LETTER RHO" },
	{ 0x03A3, "GREEK CAPITAL LETTER SIGMA" },
	{ 0x03A4, "GREEK CAPITAL LETTER TAU" },
	{ 0x03A5, "GREEK CAPITAL LETTER UPSILON" },
	{ 0x03A6, "GREEK CAPITAL LETTER PHI" },
	{ 0x03A7, "GREEK CAPITAL LETTER CHI" },
	{ 0x03A8, "GREEK CAPITAL LETTER PSI" },
	{ 0x03A9, "GREEK CAPITAL LETTER OMEGA" },
	{ 0x03AA, "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA" },
	{ 0x03AB, "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA" },
	{ 0x03AC, "GREEK SMALL LETTER ALPHA WITH TONOS" },
	{ 0x03AD, "GREEK SMALL LETTER EPSILON WITH TONOS" },
	{ 0x03AE, "GREEK SMALL LETTER ETA WITH TONOS" },
	{ 0x03AF, "GREEK SMALL LETTER IOTA WITH TONOS" },
	{ 0x03B0, "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS" },
	{ 0x03B1, "GREEK SMALL LETTER ALPHA" },
	{ 0x03B2, "GREEK SMALL LETTER BETA" },
	{ 0x03B3, "GREEK SMALL LETTER GAMMA" },
	{ 0x03B4, "GREEK SMALL LETTER DELTA" },
	{ 0x03B5, "GREEK SMALL LETTER EPSILON" },
	{ 0x03B6, "GREEK SMALL LETTER ZETA" },
	{ 0x03B7, "GREEK SMALL LETTER ETA" },
	{ 0x03B8, "GREEK SMALL LETTER THETA" },
	{ 0x03B9, "GREEK SMALL LETTER IOTA" },
	{ 0x03BA, "GREEK SMALL LETTER KAPPA" },
	{ 0x03BB, "GREEK SMALL LETTER LAMDA" },
	{ 0x03BC, "GREEK SMALL LETTER MU" },
	{ 0x03BD, "GREEK SMALL LETTER NU" },
	{ 0x03BE, "GREEK SMALL LETTER XI" },
	{ 0x03BF, "GREEK SMALL LETTER OMICRON" },
	{ 0x03C0, "GREEK SMALL LETTER PI" },
	{ 0x03C1, "GREEK SMALL LETTER RHO" },
	{ 0x03C2, "GREEK SMALL LETTER FINAL SIGMA" },
	{ 0x03C3, "GREEK SMALL LETTER SIGMA" },
	{ 0x03C4, "GREEK SMALL LETTER TAU" },
	{ 0x03C5, "GREEK SMALL LETTER UPSILON" },
	{ 0x03C6, "GREEK SMALL LETTER PHI" },
	{ 0x03C7, "GREEK SMALL LETTER CHI" },
	{ 0x03C8, "GREEK SMALL LETTER PSI" },
	{ 0x03C9, "GREEK SMALL LETTER OMEGA" },
	{ 0x03CA, "GREEK SMALL LETTER IOTA WITH DIALYTIKA" },
	{ 0x03CB, "GREEK SMALL LETTER UPSILON WITH DIALYTIKA" },
	{ 0x03CC, "GREEK SMALL LETTER OMICRON WITH TONOS" },
	{ 0x03CD, "GREEK SMALL LETTER UPSILON WITH TONOS" },
	{ 0x03CE, "GREEK SMALL LETTER OMEGA WITH TONOS" },
	{ 0x03D0, "GREEK BETA SYMBOL" },
	{ 0x03D1, "GREEK THETA SYMBOL" },
	{ 0x03D2, "GREEK UPSILON WITH HOOK SYMBOL" },
	{ 0x03D3, "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL" },
	{ 0x03D4, "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL" },
	{ 0x03D5, "GREEK PHI SYMBOL" },
	{ 0x03D6, "GREEK PI SYMBOL" },
	{ 0x03D7, "GREEK KAI SYMBOL" },
	{ 0x03DA, "GREEK LETTER STIGMA" },
	{ 0x03DB, "GREEK SMALL LETTER STIGMA" },
	{ 0x03DC, "GREEK LETTER DIGAMMA" },
	{ 0x03DD, "GREEK SMALL LETTER DIGAMMA" },
	{ 0x03DE, "GREEK LETTER KOPPA" },
	{ 0x03DF, "GREEK SMALL LETTER KOPPA" },
	{ 0x03E0, "GREEK LETTER SAMPI" },
	{ 0x03E1, "GREEK SMALL LETTER SAMPI" },
	{ 0x03E2, "COPTIC CAPITAL LETTER SHEI" },
	{ 0x03E3, "COPTIC SMALL LETTER SHEI" },
	{ 0x03E4, "COPTIC CAPITAL LETTER FEI" },
	{ 0x03E5, "COPTIC SMALL LETTER FEI" },
	{ 0x03E6, "COPTIC CAPITAL LETTER KHEI" },
	{ 0x03E7, "COPTIC SMALL LETTER KHEI" },
	{ 0x03E8, "COPTIC CAPITAL LETTER HORI" },
	{ 0x03E9, "COPTIC SMALL LETTER HORI" },
	{ 0x03EA, "COPTIC CAPITAL LETTER GANGIA" },
	{ 0x03EB, "COPTIC SMALL LETTER GANGIA" },
	{ 0x03EC, "COPTIC CAPITAL LETTER SHIMA" },
	{ 0x03ED, "COPTIC SMALL LETTER SHIMA" },
	{ 0x03EE, "COPTIC CAPITAL LETTER DEI" },
	{ 0x03EF, "COPTIC SMALL LETTER DEI" },
	{ 0x03F0, "GREEK KAPPA SYMBOL" },
	{ 0x03F1, "GREEK RHO SYMBOL" },
	{ 0x03F2, "GREEK LUNATE SIGMA SYMBOL" },
	{ 0x03F3, "GREEK LETTER YOT" },
	{ 0x03F4, "GREEK CAPITAL THETA SYMBOL" },
	{ 0x03F5, "GREEK LUNATE EPSILON SYMBOL" },
	{ 0x0400, "CYRILLIC CAPITAL LETTER IE WITH GRAVE" },
	{ 0x0401, "CYRILLIC CAPITAL LETTER IO" },
	{ 0x0402, "CYRILLIC CAPITAL LETTER DJE" },	/* Serbocroatian */
	{ 0x0403, "CYRILLIC CAPITAL LETTER GJE" },
	{ 0x0404, "CYRILLIC CAPITAL LETTER UKRAINIAN IE" },
	{ 0x0405, "CYRILLIC CAPITAL LETTER DZE" },
	{ 0x0406, "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I" },
	{ 0x0407, "CYRILLIC CAPITAL LETTER YI" },	/* Ukrainian */
	{ 0x0408, "CYRILLIC CAPITAL LETTER JE" },
	{ 0x0409, "CYRILLIC CAPITAL LETTER LJE" },
	{ 0x040A, "CYRILLIC CAPITAL LETTER NJE" },
	{ 0x040B, "CYRILLIC CAPITAL LETTER TSHE" },	/* Serbocroatian */
	{ 0x040C, "CYRILLIC CAPITAL LETTER KJE" },
	{ 0x040D, "CYRILLIC CAPITAL LETTER I WITH GRAVE" },
	{ 0x040E, "CYRILLIC CAPITAL LETTER SHORT U" },	/* Byelorussian */
	{ 0x040F, "CYRILLIC CAPITAL LETTER DZHE" },
	{ 0x0410, "CYRILLIC CAPITAL LETTER A" },
	{ 0x0411, "CYRILLIC CAPITAL LETTER BE" },
	{ 0x0412, "CYRILLIC CAPITAL LETTER VE" },
	{ 0x0413, "CYRILLIC CAPITAL LETTER GHE" },
	{ 0x0414, "CYRILLIC CAPITAL LETTER DE" },
	{ 0x0415, "CYRILLIC CAPITAL LETTER IE" },
	{ 0x0416, "CYRILLIC CAPITAL LETTER ZHE" },
	{ 0x0417, "CYRILLIC CAPITAL LETTER ZE" },
	{ 0x0418, "CYRILLIC CAPITAL LETTER I" },
	{ 0x0419, "CYRILLIC CAPITAL LETTER SHORT I" },
	{ 0x041A, "CYRILLIC CAPITAL LETTER KA" },
	{ 0x041B, "CYRILLIC CAPITAL LETTER EL" },
	{ 0x041C, "CYRILLIC CAPITAL LETTER EM" },
	{ 0x041D, "CYRILLIC CAPITAL LETTER EN" },
	{ 0x041E, "CYRILLIC CAPITAL LETTER O" },
	{ 0x041F, "CYRILLIC CAPITAL LETTER PE" },
	{ 0x0420, "CYRILLIC CAPITAL LETTER ER" },
	{ 0x0421, "CYRILLIC CAPITAL LETTER ES" },
	{ 0x0422, "CYRILLIC CAPITAL LETTER TE" },
	{ 0x0423, "CYRILLIC CAPITAL LETTER U" },
	{ 0x0424, "CYRILLIC CAPITAL LETTER EF" },
	{ 0x0425, "CYRILLIC CAPITAL LETTER HA" },
	{ 0x0426, "CYRILLIC CAPITAL LETTER TSE" },
	{ 0x0427, "CYRILLIC CAPITAL LETTER CHE" },
	{ 0x0428, "CYRILLIC CAPITAL LETTER SHA" },
	{ 0x0429, "CYRILLIC CAPITAL LETTER SHCHA" },
	{ 0x042A, "CYRILLIC CAPITAL LETTER HARD SIGN" },
	{ 0x042B, "CYRILLIC CAPITAL LETTER YERU" },
	{ 0x042C, "CYRILLIC CAPITAL LETTER SOFT SIGN" },
	{ 0x042D, "CYRILLIC CAPITAL LETTER E" },
	{ 0x042E, "CYRILLIC CAPITAL LETTER YU" },
	{ 0x042F, "CYRILLIC CAPITAL LETTER YA" },
	{ 0x0430, "CYRILLIC SMALL LETTER A" },
	{ 0x0431, "CYRILLIC SMALL LETTER BE" },
	{ 0x0432, "CYRILLIC SMALL LETTER VE" },
	{ 0x0433, "CYRILLIC SMALL LETTER GHE" },
	{ 0x0434, "CYRILLIC SMALL LETTER DE" },
	{ 0x0435, "CYRILLIC SMALL LETTER IE" },
	{ 0x0436, "CYRILLIC SMALL LETTER ZHE" },
	{ 0x0437, "CYRILLIC SMALL LETTER ZE" },
	{ 0x0438, "CYRILLIC SMALL LETTER I" },
	{ 0x0439, "CYRILLIC SMALL LETTER SHORT I" },
	{ 0x043A, "CYRILLIC SMALL LETTER KA" },
	{ 0x043B, "CYRILLIC SMALL LETTER EL" },
	{ 0x043C, "CYRILLIC SMALL LETTER EM" },
	{ 0x043D, "CYRILLIC SMALL LETTER EN" },
	{ 0x043E, "CYRILLIC SMALL LETTER O" },
	{ 0x043F, "CYRILLIC SMALL LETTER PE" },
	{ 0x0440, "CYRILLIC SMALL LETTER ER" },
	{ 0x0441, "CYRILLIC SMALL LETTER ES" },
	{ 0x0442, "CYRILLIC SMALL LETTER TE" },
	{ 0x0443, "CYRILLIC SMALL LETTER U" },
	{ 0x0444, "CYRILLIC SMALL LETTER EF" },
	{ 0x0445, "CYRILLIC SMALL LETTER HA" },
	{ 0x0446, "CYRILLIC SMALL LETTER TSE" },
	{ 0x0447, "CYRILLIC SMALL LETTER CHE" },
	{ 0x0448, "CYRILLIC SMALL LETTER SHA" },
	{ 0x0449, "CYRILLIC SMALL LETTER SHCHA" },
	{ 0x044A, "CYRILLIC SMALL LETTER HARD SIGN" },
	{ 0x044B, "CYRILLIC SMALL LETTER YERU" },
	{ 0x044C, "CYRILLIC SMALL LETTER SOFT SIGN" },
	{ 0x044D, "CYRILLIC SMALL LETTER E" },
	{ 0x044E, "CYRILLIC SMALL LETTER YU" },
	{ 0x044F, "CYRILLIC SMALL LETTER YA" },
	{ 0x0450, "CYRILLIC SMALL LETTER IE WITH GRAVE" },
	{ 0x0451, "CYRILLIC SMALL LETTER IO" },
	{ 0x0452, "CYRILLIC SMALL LETTER DJE" },	/* Serbocroatian */
	{ 0x0453, "CYRILLIC SMALL LETTER GJE" },
	{ 0x0454, "CYRILLIC SMALL LETTER UKRAINIAN IE" },
	{ 0x0455, "CYRILLIC SMALL LETTER DZE" },
	{ 0x0456, "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I" },
	{ 0x0457, "CYRILLIC SMALL LETTER YI" },	/* Ukrainian */
	{ 0x0458, "CYRILLIC SMALL LETTER JE" },
	{ 0x0459, "CYRILLIC SMALL LETTER LJE" },
	{ 0x045A, "CYRILLIC SMALL LETTER NJE" },
	{ 0x045B, "CYRILLIC SMALL LETTER TSHE" },	/* Serbocroatian */
	{ 0x045C, "CYRILLIC SMALL LETTER KJE" },
	{ 0x045D, "CYRILLIC SMALL LETTER I WITH GRAVE" },
	{ 0x045E, "CYRILLIC SMALL LETTER SHORT U" },	/* Byelorussian */
	{ 0x045F, "CYRILLIC SMALL LETTER DZHE" },
	{ 0x0460, "CYRILLIC CAPITAL LETTER OMEGA" },
	{ 0x0461, "CYRILLIC SMALL LETTER OMEGA" },
	{ 0x0462, "CYRILLIC CAPITAL LETTER YAT" },
	{ 0x0463, "CYRILLIC SMALL LETTER YAT" },
	{ 0x0464, "CYRILLIC CAPITAL LETTER IOTIFIED E" },
	{ 0x0465, "CYRILLIC SMALL LETTER IOTIFIED E" },
	{ 0x0466, "CYRILLIC CAPITAL LETTER LITTLE YUS" },
	{ 0x0467, "CYRILLIC SMALL LETTER LITTLE YUS" },
	{ 0x0468, "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS" },
	{ 0x0469, "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS" },
	{ 0x046A, "CYRILLIC CAPITAL LETTER BIG YUS" },
	{ 0x046B, "CYRILLIC SMALL LETTER BIG YUS" },
	{ 0x046C, "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS" },
	{ 0x046D, "CYRILLIC SMALL LETTER IOTIFIED BIG YUS" },
	{ 0x046E, "CYRILLIC CAPITAL LETTER KSI" },
	{ 0x046F, "CYRILLIC SMALL LETTER KSI" },
	{ 0x0470, "CYRILLIC CAPITAL LETTER PSI" },
	{ 0x0471, "CYRILLIC SMALL LETTER PSI" },
	{ 0x0472, "CYRILLIC CAPITAL LETTER FITA" },
	{ 0x0473, "CYRILLIC SMALL LETTER FITA" },
	{ 0x0474, "CYRILLIC CAPITAL LETTER IZHITSA" },
	{ 0x0475, "CYRILLIC SMALL LETTER IZHITSA" },
	{ 0x0476, "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" },
	{ 0x0477, "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" },
	{ 0x0478, "CYRILLIC CAPITAL LETTER UK" },
	{ 0x0479, "CYRILLIC SMALL LETTER UK" },
	{ 0x047A, "CYRILLIC CAPITAL LETTER ROUND OMEGA" },
	{ 0x047B, "CYRILLIC SMALL LETTER ROUND OMEGA" },
	{ 0x047C, "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO" },
	{ 0x047D, "CYRILLIC SMALL LETTER OMEGA WITH TITLO" },
	{ 0x047E, "CYRILLIC CAPITAL LETTER OT" },
	{ 0x047F, "CYRILLIC SMALL LETTER OT" },
	{ 0x0480, "CYRILLIC CAPITAL LETTER KOPPA" },
	{ 0x0481, "CYRILLIC SMALL LETTER KOPPA" },
	{ 0x0482, "CYRILLIC THOUSANDS SIGN" },
	{ 0x0483, "COMBINING CYRILLIC TITLO" },
	{ 0x0484, "COMBINING CYRILLIC PALATALIZATION" },
	{ 0x0485, "COMBINING CYRILLIC DASIA PNEUMATA" },
	{ 0x0486, "COMBINING CYRILLIC PSILI PNEUMATA" },
	{ 0x0488, "COMBINING CYRILLIC HUNDRED THOUSANDS SIGN" },
	{ 0x0489, "COMBINING CYRILLIC MILLIONS SIGN" },
	{ 0x048C, "CYRILLIC CAPITAL LETTER SEMISOFT SIGN" },
	{ 0x048D, "CYRILLIC SMALL LETTER SEMISOFT SIGN" },
	{ 0x048E, "CYRILLIC CAPITAL LETTER ER WITH TICK" },
	{ 0x048F, "CYRILLIC SMALL LETTER ER WITH TICK" },
	{ 0x0490, "CYRILLIC CAPITAL LETTER GHE WITH UPTURN" },
	{ 0x0491, "CYRILLIC SMALL LETTER GHE WITH UPTURN" },
	{ 0x0492, "CYRILLIC CAPITAL LETTER GHE WITH STROKE" },
	{ 0x0493, "CYRILLIC SMALL LETTER GHE WITH STROKE" },
	{ 0x0494, "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK" },
	{ 0x0495, "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK" },
	{ 0x0496, "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER" },
	{ 0x0497, "CYRILLIC SMALL LETTER ZHE WITH DESCENDER" },
	{ 0x0498, "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER" },
	{ 0x0499, "CYRILLIC SMALL LETTER ZE WITH DESCENDER" },
	{ 0x049A, "CYRILLIC CAPITAL LETTER KA WITH DESCENDER" },
	{ 0x049B, "CYRILLIC SMALL LETTER KA WITH DESCENDER" },
	{ 0x049C, "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE" },
	{ 0x049D, "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE" },
	{ 0x049E, "CYRILLIC CAPITAL LETTER KA WITH STROKE" },
	{ 0x049F, "CYRILLIC SMALL LETTER KA WITH STROKE" },
	{ 0x04A0, "CYRILLIC CAPITAL LETTER BASHKIR KA" },
	{ 0x04A1, "CYRILLIC SMALL LETTER BASHKIR KA" },
	{ 0x04A2, "CYRILLIC CAPITAL LETTER EN WITH DESCENDER" },
	{ 0x04A3, "CYRILLIC SMALL LETTER EN WITH DESCENDER" },
	{ 0x04A4, "CYRILLIC CAPITAL LIGATURE EN GHE" },
	{ 0x04A5, "CYRILLIC SMALL LIGATURE EN GHE" },
	{ 0x04A6, "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK" },	/* Abkhasian */
	{ 0x04A7, "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK" },	/* Abkhasian */
	{ 0x04A8, "CYRILLIC CAPITAL LETTER ABKHASIAN HA" },
	{ 0x04A9, "CYRILLIC SMALL LETTER ABKHASIAN HA" },
	{ 0x04AA, "CYRILLIC CAPITAL LETTER ES WITH DESCENDER" },
	{ 0x04AB, "CYRILLIC SMALL LETTER ES WITH DESCENDER" },
	{ 0x04AC, "CYRILLIC CAPITAL LETTER TE WITH DESCENDER" },
	{ 0x04AD, "CYRILLIC SMALL LETTER TE WITH DESCENDER" },
	{ 0x04AE, "CYRILLIC CAPITAL LETTER STRAIGHT U" },
	{ 0x04AF, "CYRILLIC SMALL LETTER STRAIGHT U" },
	{ 0x04B0, "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE" },
	{ 0x04B1, "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE" },
	{ 0x04B2, "CYRILLIC CAPITAL LETTER HA WITH DESCENDER" },
	{ 0x04B3, "CYRILLIC SMALL LETTER HA WITH DESCENDER" },
	{ 0x04B4, "CYRILLIC CAPITAL LIGATURE TE TSE" },	/* Abkhasian */
	{ 0x04B5, "CYRILLIC SMALL LIGATURE TE TSE" },	/* Abkhasian */
	{ 0x04B6, "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER" },
	{ 0x04B7, "CYRILLIC SMALL LETTER CHE WITH DESCENDER" },
	{ 0x04B8, "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE" },
	{ 0x04B9, "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE" },
	{ 0x04BA, "CYRILLIC CAPITAL LETTER SHHA" },
	{ 0x04BB, "CYRILLIC SMALL LETTER SHHA" },
	{ 0x04BC, "CYRILLIC CAPITAL LETTER ABKHASIAN CHE" },
	{ 0x04BD, "CYRILLIC SMALL LETTER ABKHASIAN CHE" },
	{ 0x04BE, "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER" },
	{ 0x04BF, "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER" },
	{ 0x04C0, "CYRILLIC LETTER PALOCHKA" },
	{ 0x04C1, "CYRILLIC CAPITAL LETTER ZHE WITH BREVE" },
	{ 0x04C2, "CYRILLIC SMALL LETTER ZHE WITH BREVE" },
	{ 0x04C3, "CYRILLIC CAPITAL LETTER KA WITH HOOK" },
	{ 0x04C4, "CYRILLIC SMALL LETTER KA WITH HOOK" },
	{ 0x04C7, "CYRILLIC CAPITAL LETTER EN WITH HOOK" },
	{ 0x04C8, "CYRILLIC SMALL LETTER EN WITH HOOK" },
	{ 0x04CB, "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE" },
	{ 0x04CC, "CYRILLIC SMALL LETTER KHAKASSIAN CHE" },
	{ 0x04D0, "CYRILLIC CAPITAL LETTER A WITH BREVE" },
	{ 0x04D1, "CYRILLIC SMALL LETTER A WITH BREVE" },
	{ 0x04D2, "CYRILLIC CAPITAL LETTER A WITH DIAERESIS" },
	{ 0x04D3, "CYRILLIC SMALL LETTER A WITH DIAERESIS" },
	{ 0x04D4, "CYRILLIC CAPITAL LIGATURE A IE" },
	{ 0x04D5, "CYRILLIC SMALL LIGATURE A IE" },
	{ 0x04D6, "CYRILLIC CAPITAL LETTER IE WITH BREVE" },
	{ 0x04D7, "CYRILLIC SMALL LETTER IE WITH BREVE" },
	{ 0x04D8, "CYRILLIC CAPITAL LETTER SCHWA" },
	{ 0x04D9, "CYRILLIC SMALL LETTER SCHWA" },
	{ 0x04DA, "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS" },
	{ 0x04DB, "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS" },
	{ 0x04DC, "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS" },
	{ 0x04DD, "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS" },
	{ 0x04DE, "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS" },
	{ 0x04DF, "CYRILLIC SMALL LETTER ZE WITH DIAERESIS" },
	{ 0x04E0, "CYRILLIC CAPITAL LETTER ABKHASIAN DZE" },
	{ 0x04E1, "CYRILLIC SMALL LETTER ABKHASIAN DZE" },
	{ 0x04E2, "CYRILLIC CAPITAL LETTER I WITH MACRON" },
	{ 0x04E3, "CYRILLIC SMALL LETTER I WITH MACRON" },
	{ 0x04E4, "CYRILLIC CAPITAL LETTER I WITH DIAERESIS" },
	{ 0x04E5, "CYRILLIC SMALL LETTER I WITH DIAERESIS" },
	{ 0x04E6, "CYRILLIC CAPITAL LETTER O WITH DIAERESIS" },
	{ 0x04E7, "CYRILLIC SMALL LETTER O WITH DIAERESIS" },
	{ 0x04E8, "CYRILLIC CAPITAL LETTER BARRED O" },
	{ 0x04E9, "CYRILLIC SMALL LETTER BARRED O" },
	{ 0x04EA, "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS" },
	{ 0x04EB, "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS" },
	{ 0x04EC, "CYRILLIC CAPITAL LETTER E WITH DIAERESIS" },
	{ 0x04ED, "CYRILLIC SMALL LETTER E WITH DIAERESIS" },
	{ 0x04EE, "CYRILLIC CAPITAL LETTER U WITH MACRON" },
	{ 0x04EF, "CYRILLIC SMALL LETTER U WITH MACRON" },
	{ 0x04F0, "CYRILLIC CAPITAL LETTER U WITH DIAERESIS" },
	{ 0x04F1, "CYRILLIC SMALL LETTER U WITH DIAERESIS" },
	{ 0x04F2, "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE" },
	{ 0x04F3, "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE" },
	{ 0x04F4, "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS" },
	{ 0x04F5, "CYRILLIC SMALL LETTER CHE WITH DIAERESIS" },
	{ 0x04F8, "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS" },
	{ 0x04F9, "CYRILLIC SMALL LETTER YERU WITH DIAERESIS" },
	{ 0x0531, "ARMENIAN CAPITAL LETTER AYB" },
	{ 0x0532, "ARMENIAN CAPITAL LETTER BEN" },
	{ 0x0533, "ARMENIAN CAPITAL LETTER GIM" },
	{ 0x0534, "ARMENIAN CAPITAL LETTER DA" },
	{ 0x0535, "ARMENIAN CAPITAL LETTER ECH" },
	{ 0x0536, "ARMENIAN CAPITAL LETTER ZA" },
	{ 0x0537, "ARMENIAN CAPITAL LETTER EH" },
	{ 0x0538, "ARMENIAN CAPITAL LETTER ET" },
	{ 0x0539, "ARMENIAN CAPITAL LETTER TO" },
	{ 0x053A, "ARMENIAN CAPITAL LETTER ZHE" },
	{ 0x053B, "ARMENIAN CAPITAL LETTER INI" },
	{ 0x053C, "ARMENIAN CAPITAL LETTER LIWN" },
	{ 0x053D, "ARMENIAN CAPITAL LETTER XEH" },
	{ 0x053E, "ARMENIAN CAPITAL LETTER CA" },
	{ 0x053F, "ARMENIAN CAPITAL LETTER KEN" },
	{ 0x0540, "ARMENIAN CAPITAL LETTER HO" },
	{ 0x0541, "ARMENIAN CAPITAL LETTER JA" },
	{ 0x0542, "ARMENIAN CAPITAL LETTER GHAD" },
	{ 0x0543, "ARMENIAN CAPITAL LETTER CHEH" },
	{ 0x0544, "ARMENIAN CAPITAL LETTER MEN" },
	{ 0x0545, "ARMENIAN CAPITAL LETTER YI" },
	{ 0x0546, "ARMENIAN CAPITAL LETTER NOW" },
	{ 0x0547, "ARMENIAN CAPITAL LETTER SHA" },
	{ 0x0548, "ARMENIAN CAPITAL LETTER VO" },
	{ 0x0549, "ARMENIAN CAPITAL LETTER CHA" },
	{ 0x054A, "ARMENIAN CAPITAL LETTER PEH" },
	{ 0x054B, "ARMENIAN CAPITAL LETTER JHEH" },
	{ 0x054C, "ARMENIAN CAPITAL LETTER RA" },
	{ 0x054D, "ARMENIAN CAPITAL LETTER SEH" },
	{ 0x054E, "ARMENIAN CAPITAL LETTER VEW" },
	{ 0x054F, "ARMENIAN CAPITAL LETTER TIWN" },
	{ 0x0550, "ARMENIAN CAPITAL LETTER REH" },
	{ 0x0551, "ARMENIAN CAPITAL LETTER CO" },
	{ 0x0552, "ARMENIAN CAPITAL LETTER YIWN" },
	{ 0x0553, "ARMENIAN CAPITAL LETTER PIWR" },
	{ 0x0554, "ARMENIAN CAPITAL LETTER KEH" },
	{ 0x0555, "ARMENIAN CAPITAL LETTER OH" },
	{ 0x0556, "ARMENIAN CAPITAL LETTER FEH" },
	{ 0x0559, "ARMENIAN MODIFIER LETTER LEFT HALF RING" },
	{ 0x055A, "ARMENIAN APOSTROPHE" },
	{ 0x055B, "ARMENIAN EMPHASIS MARK" },
	{ 0x055C, "ARMENIAN EXCLAMATION MARK" },
	{ 0x055D, "ARMENIAN COMMA" },
	{ 0x055E, "ARMENIAN QUESTION MARK" },
	{ 0x055F, "ARMENIAN ABBREVIATION MARK" },
	{ 0x0561, "ARMENIAN SMALL LETTER AYB" },
	{ 0x0562, "ARMENIAN SMALL LETTER BEN" },
	{ 0x0563, "ARMENIAN SMALL LETTER GIM" },
	{ 0x0564, "ARMENIAN SMALL LETTER DA" },
	{ 0x0565, "ARMENIAN SMALL LETTER ECH" },
	{ 0x0566, "ARMENIAN SMALL LETTER ZA" },
	{ 0x0567, "ARMENIAN SMALL LETTER EH" },
	{ 0x0568, "ARMENIAN SMALL LETTER ET" },
	{ 0x0569, "ARMENIAN SMALL LETTER TO" },
	{ 0x056A, "ARMENIAN SMALL LETTER ZHE" },
	{ 0x056B, "ARMENIAN SMALL LETTER INI" },
	{ 0x056C, "ARMENIAN SMALL LETTER LIWN" },
	{ 0x056D, "ARMENIAN SMALL LETTER XEH" },
	{ 0x056E, "ARMENIAN SMALL LETTER CA" },
	{ 0x056F, "ARMENIAN SMALL LETTER KEN" },
	{ 0x0570, "ARMENIAN SMALL LETTER HO" },
	{ 0x0571, "ARMENIAN SMALL LETTER JA" },
	{ 0x0572, "ARMENIAN SMALL LETTER GHAD" },
	{ 0x0573, "ARMENIAN SMALL LETTER CHEH" },
	{ 0x0574, "ARMENIAN SMALL LETTER MEN" },
	{ 0x0575, "ARMENIAN SMALL LETTER YI" },
	{ 0x0576, "ARMENIAN SMALL LETTER NOW" },
	{ 0x0577, "ARMENIAN SMALL LETTER SHA" },
	{ 0x0578, "ARMENIAN SMALL LETTER VO" },
	{ 0x0579, "ARMENIAN SMALL LETTER CHA" },
	{ 0x057A, "ARMENIAN SMALL LETTER PEH" },
	{ 0x057B, "ARMENIAN SMALL LETTER JHEH" },
	{ 0x057C, "ARMENIAN SMALL LETTER RA" },
	{ 0x057D, "ARMENIAN SMALL LETTER SEH" },
	{ 0x057E, "ARMENIAN SMALL LETTER VEW" },
	{ 0x057F, "ARMENIAN SMALL LETTER TIWN" },
	{ 0x0580, "ARMENIAN SMALL LETTER REH" },
	{ 0x0581, "ARMENIAN SMALL LETTER CO" },
	{ 0x0582, "ARMENIAN SMALL LETTER YIWN" },
	{ 0x0583, "ARMENIAN SMALL LETTER PIWR" },
	{ 0x0584, "ARMENIAN SMALL LETTER KEH" },
	{ 0x0585, "ARMENIAN SMALL LETTER OH" },
	{ 0x0586, "ARMENIAN SMALL LETTER FEH" },
	{ 0x0587, "ARMENIAN SMALL LIGATURE ECH YIWN" },
	{ 0x0589, "ARMENIAN FULL STOP" },
	{ 0x058A, "ARMENIAN HYPHEN" },
	{ 0x0591, "HEBREW ACCENT ETNAHTA" },
	{ 0x0592, "HEBREW ACCENT SEGOL" },
	{ 0x0593, "HEBREW ACCENT SHALSHELET" },
	{ 0x0594, "HEBREW ACCENT ZAQEF QATAN" },
	{ 0x0595, "HEBREW ACCENT ZAQEF GADOL" },
	{ 0x0596, "HEBREW ACCENT TIPEHA" },	/* * */
	{ 0x0597, "HEBREW ACCENT REVIA" },
	{ 0x0598, "HEBREW ACCENT ZARQA" },	/* * */
	{ 0x0599, "HEBREW ACCENT PASHTA" },
	{ 0x059A, "HEBREW ACCENT YETIV" },
	{ 0x059B, "HEBREW ACCENT TEVIR" },
	{ 0x059C, "HEBREW ACCENT GERESH" },
	{ 0x059D, "HEBREW ACCENT GERESH MUQDAM" },
	{ 0x059E, "HEBREW ACCENT GERSHAYIM" },
	{ 0x059F, "HEBREW ACCENT QARNEY PARA" },
	{ 0x05A0, "HEBREW ACCENT TELISHA GEDOLA" },
	{ 0x05A1, "HEBREW ACCENT PAZER" },
	{ 0x05A3, "HEBREW ACCENT MUNAH" },
	{ 0x05A4, "HEBREW ACCENT MAHAPAKH" },
	{ 0x05A5, "HEBREW ACCENT MERKHA" },	/* * */
	{ 0x05A6, "HEBREW ACCENT MERKHA KEFULA" },
	{ 0x05A7, "HEBREW ACCENT DARGA" },
	{ 0x05A8, "HEBREW ACCENT QADMA" },	/* * */
	{ 0x05A9, "HEBREW ACCENT TELISHA QETANA" },
	{ 0x05AA, "HEBREW ACCENT YERAH BEN YOMO" },	/* * */
	{ 0x05AB, "HEBREW ACCENT OLE" },
	{ 0x05AC, "HEBREW ACCENT ILUY" },
	{ 0x05AD, "HEBREW ACCENT DEHI" },
	{ 0x05AE, "HEBREW ACCENT ZINOR" },
	{ 0x05AF, "HEBREW MARK MASORA CIRCLE" },
	{ 0x05B0, "HEBREW POINT SHEVA" },
	{ 0x05B1, "HEBREW POINT HATAF SEGOL" },
	{ 0x05B2, "HEBREW POINT HATAF PATAH" },
	{ 0x05B3, "HEBREW POINT HATAF QAMATS" },
	{ 0x05B4, "HEBREW POINT HIRIQ" },
	{ 0x05B5, "HEBREW POINT TSERE" },
	{ 0x05B6, "HEBREW POINT SEGOL" },
	{ 0x05B7, "HEBREW POINT PATAH" },
	{ 0x05B8, "HEBREW POINT QAMATS" },
	{ 0x05B9, "HEBREW POINT HOLAM" },
	{ 0x05BB, "HEBREW POINT QUBUTS" },
	{ 0x05BC, "HEBREW POINT DAGESH OR MAPIQ" },	/* or shuruq */
	{ 0x05BD, "HEBREW POINT METEG" },	/* * */
	{ 0x05BE, "HEBREW PUNCTUATION MAQAF" },
	{ 0x05BF, "HEBREW POINT RAFE" },
	{ 0x05C0, "HEBREW PUNCTUATION PASEQ" },	/* * */
	{ 0x05C1, "HEBREW POINT SHIN DOT" },
	{ 0x05C2, "HEBREW POINT SIN DOT" },
	{ 0x05C3, "HEBREW PUNCTUATION SOF PASUQ" },	/* * */
	{ 0x05C4, "HEBREW MARK UPPER DOT" },
	{ 0x05D0, "HEBREW LETTER ALEF" },
	{ 0x05D1, "HEBREW LETTER BET" },
	{ 0x05D2, "HEBREW LETTER GIMEL" },
	{ 0x05D3, "HEBREW LETTER DALET" },
	{ 0x05D4, "HEBREW LETTER HE" },
	{ 0x05D5, "HEBREW LETTER VAV" },
	{ 0x05D6, "HEBREW LETTER ZAYIN" },
	{ 0x05D7, "HEBREW LETTER HET" },
	{ 0x05D8, "HEBREW LETTER TET" },
	{ 0x05D9, "HEBREW LETTER YOD" },
	{ 0x05DA, "HEBREW LETTER FINAL KAF" },
	{ 0x05DB, "HEBREW LETTER KAF" },
	{ 0x05DC, "HEBREW LETTER LAMED" },
	{ 0x05DD, "HEBREW LETTER FINAL MEM" },
	{ 0x05DE, "HEBREW LETTER MEM" },
	{ 0x05DF, "HEBREW LETTER FINAL NUN" },
	{ 0x05E0, "HEBREW LETTER NUN" },
	{ 0x05E1, "HEBREW LETTER SAMEKH" },
	{ 0x05E2, "HEBREW LETTER AYIN" },
	{ 0x05E3, "HEBREW LETTER FINAL PE" },
	{ 0x05E4, "HEBREW LETTER PE" },
	{ 0x05E5, "HEBREW LETTER FINAL TSADI" },
	{ 0x05E6, "HEBREW LETTER TSADI" },
	{ 0x05E7, "HEBREW LETTER QOF" },
	{ 0x05E8, "HEBREW LETTER RESH" },
	{ 0x05E9, "HEBREW LETTER SHIN" },
	{ 0x05EA, "HEBREW LETTER TAV" },
	{ 0x05F0, "HEBREW LIGATURE YIDDISH DOUBLE VAV" },
	{ 0x05F1, "HEBREW LIGATURE YIDDISH VAV YOD" },
	{ 0x05F2, "HEBREW LIGATURE YIDDISH DOUBLE YOD" },
	{ 0x05F3, "HEBREW PUNCTUATION GERESH" },
	{ 0x05F4, "HEBREW PUNCTUATION GERSHAYIM" },
	{ 0x060C, "ARABIC COMMA" },
	{ 0x061B, "ARABIC SEMICOLON" },
	{ 0x061F, "ARABIC QUESTION MARK" },
	{ 0x0621, "ARABIC LETTER HAMZA" },
	{ 0x0622, "ARABIC LETTER ALEF WITH MADDA ABOVE" },
	{ 0x0623, "ARABIC LETTER ALEF WITH HAMZA ABOVE" },
	{ 0x0624, "ARABIC LETTER WAW WITH HAMZA ABOVE" },
	{ 0x0625, "ARABIC LETTER ALEF WITH HAMZA BELOW" },
	{ 0x0626, "ARABIC LETTER YEH WITH HAMZA ABOVE" },
	{ 0x0627, "ARABIC LETTER ALEF" },
	{ 0x0628, "ARABIC LETTER BEH" },
	{ 0x0629, "ARABIC LETTER TEH MARBUTA" },
	{ 0x062A, "ARABIC LETTER TEH" },
	{ 0x062B, "ARABIC LETTER THEH" },
	{ 0x062C, "ARABIC LETTER JEEM" },
	{ 0x062D, "ARABIC LETTER HAH" },
	{ 0x062E, "ARABIC LETTER KHAH" },
	{ 0x062F, "ARABIC LETTER DAL" },
	{ 0x0630, "ARABIC LETTER THAL" },
	{ 0x0631, "ARABIC LETTER REH" },
	{ 0x0632, "ARABIC LETTER ZAIN" },
	{ 0x0633, "ARABIC LETTER SEEN" },
	{ 0x0634, "ARABIC LETTER SHEEN" },
	{ 0x0635, "ARABIC LETTER SAD" },
	{ 0x0636, "ARABIC LETTER DAD" },
	{ 0x0637, "ARABIC LETTER TAH" },
	{ 0x0638, "ARABIC LETTER ZAH" },
	{ 0x0639, "ARABIC LETTER AIN" },
	{ 0x063A, "ARABIC LETTER GHAIN" },
	{ 0x0640, "ARABIC TATWEEL" },
	{ 0x0641, "ARABIC LETTER FEH" },
	{ 0x0642, "ARABIC LETTER QAF" },
	{ 0x0643, "ARABIC LETTER KAF" },
	{ 0x0644, "ARABIC LETTER LAM" },
	{ 0x0645, "ARABIC LETTER MEEM" },
	{ 0x0646, "ARABIC LETTER NOON" },
	{ 0x0647, "ARABIC LETTER HEH" },
	{ 0x0648, "ARABIC LETTER WAW" },
	{ 0x0649, "ARABIC LETTER ALEF MAKSURA" },
	{ 0x064A, "ARABIC LETTER YEH" },
	{ 0x064B, "ARABIC FATHATAN" },
	{ 0x064C, "ARABIC DAMMATAN" },
	{ 0x064D, "ARABIC KASRATAN" },
	{ 0x064E, "ARABIC FATHA" },
	{ 0x064F, "ARABIC DAMMA" },
	{ 0x0650, "ARABIC KASRA" },
	{ 0x0651, "ARABIC SHADDA" },
	{ 0x0652, "ARABIC SUKUN" },
	{ 0x0653, "ARABIC MADDAH ABOVE" },
	{ 0x0654, "ARABIC HAMZA ABOVE" },
	{ 0x0655, "ARABIC HAMZA BELOW" },
	{ 0x0660, "ARABIC-INDIC DIGIT ZERO" },
	{ 0x0661, "ARABIC-INDIC DIGIT ONE" },
	{ 0x0662, "ARABIC-INDIC DIGIT TWO" },
	{ 0x0663, "ARABIC-INDIC DIGIT THREE" },
	{ 0x0664, "ARABIC-INDIC DIGIT FOUR" },
	{ 0x0665, "ARABIC-INDIC DIGIT FIVE" },
	{ 0x0666, "ARABIC-INDIC DIGIT SIX" },
	{ 0x0667, "ARABIC-INDIC DIGIT SEVEN" },
	{ 0x0668, "ARABIC-INDIC DIGIT EIGHT" },
	{ 0x0669, "ARABIC-INDIC DIGIT NINE" },
	{ 0x066A, "ARABIC PERCENT SIGN" },
	{ 0x066B, "ARABIC DECIMAL SEPARATOR" },
	{ 0x066C, "ARABIC THOUSANDS SEPARATOR" },
	{ 0x066D, "ARABIC FIVE POINTED STAR" },
	{ 0x0670, "ARABIC LETTER SUPERSCRIPT ALEF" },
	{ 0x0671, "ARABIC LETTER ALEF WASLA" },
	{ 0x0672, "ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE" },
	{ 0x0673, "ARABIC LETTER ALEF WITH WAVY HAMZA BELOW" },
	{ 0x0674, "ARABIC LETTER HIGH HAMZA" },
	{ 0x0675, "ARABIC LETTER HIGH HAMZA ALEF" },
	{ 0x0676, "ARABIC LETTER HIGH HAMZA WAW" },
	{ 0x0677, "ARABIC LETTER U WITH HAMZA ABOVE" },
	{ 0x0678, "ARABIC LETTER HIGH HAMZA YEH" },
	{ 0x0679, "ARABIC LETTER TTEH" },
	{ 0x067A, "ARABIC LETTER TTEHEH" },
	{ 0x067B, "ARABIC LETTER BEEH" },
	{ 0x067C, "ARABIC LETTER TEH WITH RING" },
	{ 0x067D, "ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS" },
	{ 0x067E, "ARABIC LETTER PEH" },
	{ 0x067F, "ARABIC LETTER TEHEH" },
	{ 0x0680, "ARABIC LETTER BEHEH" },
	{ 0x0681, "ARABIC LETTER HAH WITH HAMZA ABOVE" },
	{ 0x0682, "ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE" },
	{ 0x0683, "ARABIC LETTER NYEH" },
	{ 0x0684, "ARABIC LETTER DYEH" },
	{ 0x0685, "ARABIC LETTER HAH WITH THREE DOTS ABOVE" },
	{ 0x0686, "ARABIC LETTER TCHEH" },
	{ 0x0687, "ARABIC LETTER TCHEHEH" },
	{ 0x0688, "ARABIC LETTER DDAL" },
	{ 0x0689, "ARABIC LETTER DAL WITH RING" },
	{ 0x068A, "ARABIC LETTER DAL WITH DOT BELOW" },
	{ 0x068B, "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH" },
	{ 0x068C, "ARABIC LETTER DAHAL" },
	{ 0x068D, "ARABIC LETTER DDAHAL" },
	{ 0x068E, "ARABIC LETTER DUL" },
	{ 0x068F, "ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS" },
	{ 0x0690, "ARABIC LETTER DAL WITH FOUR DOTS ABOVE" },
	{ 0x0691, "ARABIC LETTER RREH" },
	{ 0x0692, "ARABIC LETTER REH WITH SMALL V" },
	{ 0x0693, "ARABIC LETTER REH WITH RING" },
	{ 0x0694, "ARABIC LETTER REH WITH DOT BELOW" },
	{ 0x0695, "ARABIC LETTER REH WITH SMALL V BELOW" },
	{ 0x0696, "ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE" },
	{ 0x0697, "ARABIC LETTER REH WITH TWO DOTS ABOVE" },
	{ 0x0698, "ARABIC LETTER JEH" },
	{ 0x0699, "ARABIC LETTER REH WITH FOUR DOTS ABOVE" },
	{ 0x069A, "ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE" },
	{ 0x069B, "ARABIC LETTER SEEN WITH THREE DOTS BELOW" },
	{ 0x069C, "ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE" },
	{ 0x069D, "ARABIC LETTER SAD WITH TWO DOTS BELOW" },
	{ 0x069E, "ARABIC LETTER SAD WITH THREE DOTS ABOVE" },
	{ 0x069F, "ARABIC LETTER TAH WITH THREE DOTS ABOVE" },
	{ 0x06A0, "ARABIC LETTER AIN WITH THREE DOTS ABOVE" },
	{ 0x06A1, "ARABIC LETTER DOTLESS FEH" },
	{ 0x06A2, "ARABIC LETTER FEH WITH DOT MOVED BELOW" },
	{ 0x06A3, "ARABIC LETTER FEH WITH DOT BELOW" },
	{ 0x06A4, "ARABIC LETTER VEH" },
	{ 0x06A5, "ARABIC LETTER FEH WITH THREE DOTS BELOW" },
	{ 0x06A6, "ARABIC LETTER PEHEH" },
	{ 0x06A7, "ARABIC LETTER QAF WITH DOT ABOVE" },
	{ 0x06A8, "ARABIC LETTER QAF WITH THREE DOTS ABOVE" },
	{ 0x06A9, "ARABIC LETTER KEHEH" },
	{ 0x06AA, "ARABIC LETTER SWASH KAF" },
	{ 0x06AB, "ARABIC LETTER KAF WITH RING" },
	{ 0x06AC, "ARABIC LETTER KAF WITH DOT ABOVE" },
	{ 0x06AD, "ARABIC LETTER NG" },
	{ 0x06AE, "ARABIC LETTER KAF WITH THREE DOTS BELOW" },
	{ 0x06AF, "ARABIC LETTER GAF" },	/* * */
	{ 0x06B0, "ARABIC LETTER GAF WITH RING" },
	{ 0x06B1, "ARABIC LETTER NGOEH" },
	{ 0x06B2, "ARABIC LETTER GAF WITH TWO DOTS BELOW" },
	{ 0x06B3, "ARABIC LETTER GUEH" },
	{ 0x06B4, "ARABIC LETTER GAF WITH THREE DOTS ABOVE" },
	{ 0x06B5, "ARABIC LETTER LAM WITH SMALL V" },
	{ 0x06B6, "ARABIC LETTER LAM WITH DOT ABOVE" },
	{ 0x06B7, "ARABIC LETTER LAM WITH THREE DOTS ABOVE" },
	{ 0x06B8, "ARABIC LETTER LAM WITH THREE DOTS BELOW" },
	{ 0x06B9, "ARABIC LETTER NOON WITH DOT BELOW" },
	{ 0x06BA, "ARABIC LETTER NOON GHUNNA" },
	{ 0x06BB, "ARABIC LETTER RNOON" },
	{ 0x06BC, "ARABIC LETTER NOON WITH RING" },
	{ 0x06BD, "ARABIC LETTER NOON WITH THREE DOTS ABOVE" },
	{ 0x06BE, "ARABIC LETTER HEH DOACHASHMEE" },
	{ 0x06BF, "ARABIC LETTER TCHEH WITH DOT ABOVE" },
	{ 0x06C0, "ARABIC LETTER HEH WITH YEH ABOVE" },
	{ 0x06C1, "ARABIC LETTER HEH GOAL" },
	{ 0x06C2, "ARABIC LETTER HEH GOAL WITH HAMZA ABOVE" },
	{ 0x06C3, "ARABIC LETTER TEH MARBUTA GOAL" },
	{ 0x06C4, "ARABIC LETTER WAW WITH RING" },
	{ 0x06C5, "ARABIC LETTER KIRGHIZ OE" },
	{ 0x06C6, "ARABIC LETTER OE" },
	{ 0x06C7, "ARABIC LETTER U" },
	{ 0x06C8, "ARABIC LETTER YU" },
	{ 0x06C9, "ARABIC LETTER KIRGHIZ YU" },
	{ 0x06CA, "ARABIC LETTER WAW WITH TWO DOTS ABOVE" },
	{ 0x06CB, "ARABIC LETTER VE" },
	{ 0x06CC, "ARABIC LETTER FARSI YEH" },
	{ 0x06CD, "ARABIC LETTER YEH WITH TAIL" },
	{ 0x06CE, "ARABIC LETTER YEH WITH SMALL V" },
	{ 0x06CF, "ARABIC LETTER WAW WITH DOT ABOVE" },
	{ 0x06D0, "ARABIC LETTER E" },	/* * */
	{ 0x06D1, "ARABIC LETTER YEH WITH THREE DOTS BELOW" },
	{ 0x06D2, "ARABIC LETTER YEH BARREE" },
	{ 0x06D3, "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE" },
	{ 0x06D4, "ARABIC FULL STOP" },
	{ 0x06D5, "ARABIC LETTER AE" },
	{ 0x06D6, "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA" },
	{ 0x06D7, "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA" },
	{ 0x06D8, "ARABIC SMALL HIGH MEEM INITIAL FORM" },
	{ 0x06D9, "ARABIC SMALL HIGH LAM ALEF" },
	{ 0x06DA, "ARABIC SMALL HIGH JEEM" },
	{ 0x06DB, "ARABIC SMALL HIGH THREE DOTS" },
	{ 0x06DC, "ARABIC SMALL HIGH SEEN" },
	{ 0x06DD, "ARABIC END OF AYAH" },
	{ 0x06DE, "ARABIC START OF RUB EL HIZB" },
	{ 0x06DF, "ARABIC SMALL HIGH ROUNDED ZERO" },
	{ 0x06E0, "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO" },
	{ 0x06E1, "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH" },
	{ 0x06E2, "ARABIC SMALL HIGH MEEM ISOLATED FORM" },
	{ 0x06E3, "ARABIC SMALL LOW SEEN" },
	{ 0x06E4, "ARABIC SMALL HIGH MADDA" },
	{ 0x06E5, "ARABIC SMALL WAW" },
	{ 0x06E6, "ARABIC SMALL YEH" },
	{ 0x06E7, "ARABIC SMALL HIGH YEH" },
	{ 0x06E8, "ARABIC SMALL HIGH NOON" },
	{ 0x06E9, "ARABIC PLACE OF SAJDAH" },
	{ 0x06EA, "ARABIC EMPTY CENTRE LOW STOP" },
	{ 0x06EB, "ARABIC EMPTY CENTRE HIGH STOP" },
	{ 0x06EC, "ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE" },
	{ 0x06ED, "ARABIC SMALL LOW MEEM" },
	{ 0x06F0, "EXTENDED ARABIC-INDIC DIGIT ZERO" },
	{ 0x06F1, "EXTENDED ARABIC-INDIC DIGIT ONE" },
	{ 0x06F2, "EXTENDED ARABIC-INDIC DIGIT TWO" },
	{ 0x06F3, "EXTENDED ARABIC-INDIC DIGIT THREE" },
	{ 0x06F4, "EXTENDED ARABIC-INDIC DIGIT FOUR" },
	{ 0x06F5, "EXTENDED ARABIC-INDIC DIGIT FIVE" },
	{ 0x06F6, "EXTENDED ARABIC-INDIC DIGIT SIX" },
	{ 0x06F7, "EXTENDED ARABIC-INDIC DIGIT SEVEN" },
	{ 0x06F8, "EXTENDED ARABIC-INDIC DIGIT EIGHT" },
	{ 0x06F9, "EXTENDED ARABIC-INDIC DIGIT NINE" },
	{ 0x06FA, "ARABIC LETTER SHEEN WITH DOT BELOW" },
	{ 0x06FB, "ARABIC LETTER DAD WITH DOT BELOW" },
	{ 0x06FC, "ARABIC LETTER GHAIN WITH DOT BELOW" },
	{ 0x06FD, "ARABIC SIGN SINDHI AMPERSAND" },
	{ 0x06FE, "ARABIC SIGN SINDHI POSTPOSITION MEN" },
	{ 0x0700, "SYRIAC END OF PARAGRAPH" },
	{ 0x0701, "SYRIAC SUPRALINEAR FULL STOP" },
	{ 0x0702, "SYRIAC SUBLINEAR FULL STOP" },
	{ 0x0703, "SYRIAC SUPRALINEAR COLON" },
	{ 0x0704, "SYRIAC SUBLINEAR COLON" },
	{ 0x0705, "SYRIAC HORIZONTAL COLON" },
	{ 0x0706, "SYRIAC COLON SKEWED LEFT" },
	{ 0x0707, "SYRIAC COLON SKEWED RIGHT" },
	{ 0x0708, "SYRIAC SUPRALINEAR COLON SKEWED LEFT" },
	{ 0x0709, "SYRIAC SUBLINEAR COLON SKEWED RIGHT" },
	{ 0x070A, "SYRIAC CONTRACTION" },
	{ 0x070B, "SYRIAC HARKLEAN OBELUS" },
	{ 0x070C, "SYRIAC HARKLEAN METOBELUS" },
	{ 0x070D, "SYRIAC HARKLEAN ASTERISCUS" },
	{ 0x070F, "SYRIAC ABBREVIATION MARK" },
	{ 0x0710, "SYRIAC LETTER ALAPH" },
	{ 0x0711, "SYRIAC LETTER SUPERSCRIPT ALAPH" },
	{ 0x0712, "SYRIAC LETTER BETH" },
	{ 0x0713, "SYRIAC LETTER GAMAL" },
	{ 0x0714, "SYRIAC LETTER GAMAL GARSHUNI" },
	{ 0x0715, "SYRIAC LETTER DALATH" },
	{ 0x0716, "SYRIAC LETTER DOTLESS DALATH RISH" },
	{ 0x0717, "SYRIAC LETTER HE" },
	{ 0x0718, "SYRIAC LETTER WAW" },
	{ 0x0719, "SYRIAC LETTER ZAIN" },
	{ 0x071A, "SYRIAC LETTER HETH" },
	{ 0x071B, "SYRIAC LETTER TETH" },
	{ 0x071C, "SYRIAC LETTER TETH GARSHUNI" },
	{ 0x071D, "SYRIAC LETTER YUDH" },
	{ 0x071E, "SYRIAC LETTER YUDH HE" },
	{ 0x071F, "SYRIAC LETTER KAPH" },
	{ 0x0720, "SYRIAC LETTER LAMADH" },
	{ 0x0721, "SYRIAC LETTER MIM" },
	{ 0x0722, "SYRIAC LETTER NUN" },
	{ 0x0723, "SYRIAC LETTER SEMKATH" },
	{ 0x0724, "SYRIAC LETTER FINAL SEMKATH" },
	{ 0x0725, "SYRIAC LETTER E" },
	{ 0x0726, "SYRIAC LETTER PE" },
	{ 0x0727, "SYRIAC LETTER REVERSED PE" },
	{ 0x0728, "SYRIAC LETTER SADHE" },
	{ 0x0729, "SYRIAC LETTER QAPH" },
	{ 0x072A, "SYRIAC LETTER RISH" },
	{ 0x072B, "SYRIAC LETTER SHIN" },
	{ 0x072C, "SYRIAC LETTER TAW" },
	{ 0x0730, "SYRIAC PTHAHA ABOVE" },
	{ 0x0731, "SYRIAC PTHAHA BELOW" },
	{ 0x0732, "SYRIAC PTHAHA DOTTED" },
	{ 0x0733, "SYRIAC ZQAPHA ABOVE" },
	{ 0x0734, "SYRIAC ZQAPHA BELOW" },
	{ 0x0735, "SYRIAC ZQAPHA DOTTED" },
	{ 0x0736, "SYRIAC RBASA ABOVE" },
	{ 0x0737, "SYRIAC RBASA BELOW" },
	{ 0x0738, "SYRIAC DOTTED ZLAMA HORIZONTAL" },
	{ 0x0739, "SYRIAC DOTTED ZLAMA ANGULAR" },
	{ 0x073A, "SYRIAC HBASA ABOVE" },
	{ 0x073B, "SYRIAC HBASA BELOW" },
	{ 0x073C, "SYRIAC HBASA-ESASA DOTTED" },
	{ 0x073D, "SYRIAC ESASA ABOVE" },
	{ 0x073E, "SYRIAC ESASA BELOW" },
	{ 0x073F, "SYRIAC RWAHA" },
	{ 0x0740, "SYRIAC FEMININE DOT" },
	{ 0x0741, "SYRIAC QUSHSHAYA" },
	{ 0x0742, "SYRIAC RUKKAKHA" },
	{ 0x0743, "SYRIAC TWO VERTICAL DOTS ABOVE" },
	{ 0x0744, "SYRIAC TWO VERTICAL DOTS BELOW" },
	{ 0x0745, "SYRIAC THREE DOTS ABOVE" },
	{ 0x0746, "SYRIAC THREE DOTS BELOW" },
	{ 0x0747, "SYRIAC OBLIQUE LINE ABOVE" },
	{ 0x0748, "SYRIAC OBLIQUE LINE BELOW" },
	{ 0x0749, "SYRIAC MUSIC" },
	{ 0x074A, "SYRIAC BARREKH" },
	{ 0x0780, "THAANA LETTER HAA" },
	{ 0x0781, "THAANA LETTER SHAVIYANI" },
	{ 0x0782, "THAANA LETTER NOONU" },
	{ 0x0783, "THAANA LETTER RAA" },
	{ 0x0784, "THAANA LETTER BAA" },
	{ 0x0785, "THAANA LETTER LHAVIYANI" },
	{ 0x0786, "THAANA LETTER KAAFU" },
	{ 0x0787, "THAANA LETTER ALIFU" },
	{ 0x0788, "THAANA LETTER VAAVU" },
	{ 0x0789, "THAANA LETTER MEEMU" },
	{ 0x078A, "THAANA LETTER FAAFU" },
	{ 0x078B, "THAANA LETTER DHAALU" },
	{ 0x078C, "THAANA LETTER THAA" },
	{ 0x078D, "THAANA LETTER LAAMU" },
	{ 0x078E, "THAANA LETTER GAAFU" },
	{ 0x078F, "THAANA LETTER GNAVIYANI" },
	{ 0x0790, "THAANA LETTER SEENU" },
	{ 0x0791, "THAANA LETTER DAVIYANI" },
	{ 0x0792, "THAANA LETTER ZAVIYANI" },
	{ 0x0793, "THAANA LETTER TAVIYANI" },
	{ 0x0794, "THAANA LETTER YAA" },
	{ 0x0795, "THAANA LETTER PAVIYANI" },
	{ 0x0796, "THAANA LETTER JAVIYANI" },
	{ 0x0797, "THAANA LETTER CHAVIYANI" },
	{ 0x0798, "THAANA LETTER TTAA" },
	{ 0x0799, "THAANA LETTER HHAA" },
	{ 0x079A, "THAANA LETTER KHAA" },
	{ 0x079B, "THAANA LETTER THAALU" },
	{ 0x079C, "THAANA LETTER ZAA" },
	{ 0x079D, "THAANA LETTER SHEENU" },
	{ 0x079E, "THAANA LETTER SAADHU" },
	{ 0x079F, "THAANA LETTER DAADHU" },
	{ 0x07A0, "THAANA LETTER TO" },
	{ 0x07A1, "THAANA LETTER ZO" },
	{ 0x07A2, "THAANA LETTER AINU" },
	{ 0x07A3, "THAANA LETTER GHAINU" },
	{ 0x07A4, "THAANA LETTER QAAFU" },
	{ 0x07A5, "THAANA LETTER WAAVU" },
	{ 0x07A6, "THAANA ABAFILI" },
	{ 0x07A7, "THAANA AABAAFILI" },
	{ 0x07A8, "THAANA IBIFILI" },
	{ 0x07A9, "THAANA EEBEEFILI" },
	{ 0x07AA, "THAANA UBUFILI" },
	{ 0x07AB, "THAANA OOBOOFILI" },
	{ 0x07AC, "THAANA EBEFILI" },
	{ 0x07AD, "THAANA EYBEYFILI" },
	{ 0x07AE, "THAANA OBOFILI" },
	{ 0x07AF, "THAANA OABOAFILI" },
	{ 0x07B0, "THAANA SUKUN" },
	{ 0x0901, "DEVANAGARI SIGN CANDRABINDU" },
	{ 0x0902, "DEVANAGARI SIGN ANUSVARA" },
	{ 0x0903, "DEVANAGARI SIGN VISARGA" },
	{ 0x0905, "DEVANAGARI LETTER A" },
	{ 0x0906, "DEVANAGARI LETTER AA" },
	{ 0x0907, "DEVANAGARI LETTER I" },
	{ 0x0908, "DEVANAGARI LETTER II" },
	{ 0x0909, "DEVANAGARI LETTER U" },
	{ 0x090A, "DEVANAGARI LETTER UU" },
	{ 0x090B, "DEVANAGARI LETTER VOCALIC R" },
	{ 0x090C, "DEVANAGARI LETTER VOCALIC L" },
	{ 0x090D, "DEVANAGARI LETTER CANDRA E" },
	{ 0x090E, "DEVANAGARI LETTER SHORT E" },
	{ 0x090F, "DEVANAGARI LETTER E" },
	{ 0x0910, "DEVANAGARI LETTER AI" },
	{ 0x0911, "DEVANAGARI LETTER CANDRA O" },
	{ 0x0912, "DEVANAGARI LETTER SHORT O" },
	{ 0x0913, "DEVANAGARI LETTER O" },
	{ 0x0914, "DEVANAGARI LETTER AU" },
	{ 0x0915, "DEVANAGARI LETTER KA" },
	{ 0x0916, "DEVANAGARI LETTER KHA" },
	{ 0x0917, "DEVANAGARI LETTER GA" },
	{ 0x0918, "DEVANAGARI LETTER GHA" },
	{ 0x0919, "DEVANAGARI LETTER NGA" },
	{ 0x091A, "DEVANAGARI LETTER CA" },
	{ 0x091B, "DEVANAGARI LETTER CHA" },
	{ 0x091C, "DEVANAGARI LETTER JA" },
	{ 0x091D, "DEVANAGARI LETTER JHA" },
	{ 0x091E, "DEVANAGARI LETTER NYA" },
	{ 0x091F, "DEVANAGARI LETTER TTA" },
	{ 0x0920, "DEVANAGARI LETTER TTHA" },
	{ 0x0921, "DEVANAGARI LETTER DDA" },
	{ 0x0922, "DEVANAGARI LETTER DDHA" },
	{ 0x0923, "DEVANAGARI LETTER NNA" },
	{ 0x0924, "DEVANAGARI LETTER TA" },
	{ 0x0925, "DEVANAGARI LETTER THA" },
	{ 0x0926, "DEVANAGARI LETTER DA" },
	{ 0x0927, "DEVANAGARI LETTER DHA" },
	{ 0x0928, "DEVANAGARI LETTER NA" },
	{ 0x0929, "DEVANAGARI LETTER NNNA" },
	{ 0x092A, "DEVANAGARI LETTER PA" },
	{ 0x092B, "DEVANAGARI LETTER PHA" },
	{ 0x092C, "DEVANAGARI LETTER BA" },
	{ 0x092D, "DEVANAGARI LETTER BHA" },
	{ 0x092E, "DEVANAGARI LETTER MA" },
	{ 0x092F, "DEVANAGARI LETTER YA" },
	{ 0x0930, "DEVANAGARI LETTER RA" },
	{ 0x0931, "DEVANAGARI LETTER RRA" },
	{ 0x0932, "DEVANAGARI LETTER LA" },
	{ 0x0933, "DEVANAGARI LETTER LLA" },
	{ 0x0934, "DEVANAGARI LETTER LLLA" },
	{ 0x0935, "DEVANAGARI LETTER VA" },
	{ 0x0936, "DEVANAGARI LETTER SHA" },
	{ 0x0937, "DEVANAGARI LETTER SSA" },
	{ 0x0938, "DEVANAGARI LETTER SA" },
	{ 0x0939, "DEVANAGARI LETTER HA" },
	{ 0x093C, "DEVANAGARI SIGN NUKTA" },
	{ 0x093D, "DEVANAGARI SIGN AVAGRAHA" },
	{ 0x093E, "DEVANAGARI VOWEL SIGN AA" },
	{ 0x093F, "DEVANAGARI VOWEL SIGN I" },
	{ 0x0940, "DEVANAGARI VOWEL SIGN II" },
	{ 0x0941, "DEVANAGARI VOWEL SIGN U" },
	{ 0x0942, "DEVANAGARI VOWEL SIGN UU" },
	{ 0x0943, "DEVANAGARI VOWEL SIGN VOCALIC R" },
	{ 0x0944, "DEVANAGARI VOWEL SIGN VOCALIC RR" },
	{ 0x0945, "DEVANAGARI VOWEL SIGN CANDRA E" },
	{ 0x0946, "DEVANAGARI VOWEL SIGN SHORT E" },
	{ 0x0947, "DEVANAGARI VOWEL SIGN E" },
	{ 0x0948, "DEVANAGARI VOWEL SIGN AI" },
	{ 0x0949, "DEVANAGARI VOWEL SIGN CANDRA O" },
	{ 0x094A, "DEVANAGARI VOWEL SIGN SHORT O" },
	{ 0x094B, "DEVANAGARI VOWEL SIGN O" },
	{ 0x094C, "DEVANAGARI VOWEL SIGN AU" },
	{ 0x094D, "DEVANAGARI SIGN VIRAMA" },
	{ 0x0950, "DEVANAGARI OM" },
	{ 0x0951, "DEVANAGARI STRESS SIGN UDATTA" },
	{ 0x0952, "DEVANAGARI STRESS SIGN ANUDATTA" },
	{ 0x0953, "DEVANAGARI GRAVE ACCENT" },
	{ 0x0954, "DEVANAGARI ACUTE ACCENT" },
	{ 0x0958, "DEVANAGARI LETTER QA" },
	{ 0x0959, "DEVANAGARI LETTER KHHA" },
	{ 0x095A, "DEVANAGARI LETTER GHHA" },
	{ 0x095B, "DEVANAGARI LETTER ZA" },
	{ 0x095C, "DEVANAGARI LETTER DDDHA" },
	{ 0x095D, "DEVANAGARI LETTER RHA" },
	{ 0x095E, "DEVANAGARI LETTER FA" },
	{ 0x095F, "DEVANAGARI LETTER YYA" },
	{ 0x0960, "DEVANAGARI LETTER VOCALIC RR" },
	{ 0x0961, "DEVANAGARI LETTER VOCALIC LL" },
	{ 0x0962, "DEVANAGARI VOWEL SIGN VOCALIC L" },
	{ 0x0963, "DEVANAGARI VOWEL SIGN VOCALIC LL" },
	{ 0x0964, "DEVANAGARI DANDA" },
	{ 0x0965, "DEVANAGARI DOUBLE DANDA" },
	{ 0x0966, "DEVANAGARI DIGIT ZERO" },
	{ 0x0967, "DEVANAGARI DIGIT ONE" },
	{ 0x0968, "DEVANAGARI DIGIT TWO" },
	{ 0x0969, "DEVANAGARI DIGIT THREE" },
	{ 0x096A, "DEVANAGARI DIGIT FOUR" },
	{ 0x096B, "DEVANAGARI DIGIT FIVE" },
	{ 0x096C, "DEVANAGARI DIGIT SIX" },
	{ 0x096D, "DEVANAGARI DIGIT SEVEN" },
	{ 0x096E, "DEVANAGARI DIGIT EIGHT" },
	{ 0x096F, "DEVANAGARI DIGIT NINE" },
	{ 0x0970, "DEVANAGARI ABBREVIATION SIGN" },
	{ 0x0981, "BENGALI SIGN CANDRABINDU" },
	{ 0x0982, "BENGALI SIGN ANUSVARA" },
	{ 0x0983, "BENGALI SIGN VISARGA" },
	{ 0x0985, "BENGALI LETTER A" },
	{ 0x0986, "BENGALI LETTER AA" },
	{ 0x0987, "BENGALI LETTER I" },
	{ 0x0988, "BENGALI LETTER II" },
	{ 0x0989, "BENGALI LETTER U" },
	{ 0x098A, "BENGALI LETTER UU" },
	{ 0x098B, "BENGALI LETTER VOCALIC R" },
	{ 0x098C, "BENGALI LETTER VOCALIC L" },
	{ 0x098F, "BENGALI LETTER E" },
	{ 0x0990, "BENGALI LETTER AI" },
	{ 0x0993, "BENGALI LETTER O" },
	{ 0x0994, "BENGALI LETTER AU" },
	{ 0x0995, "BENGALI LETTER KA" },
	{ 0x0996, "BENGALI LETTER KHA" },
	{ 0x0997, "BENGALI LETTER GA" },
	{ 0x0998, "BENGALI LETTER GHA" },
	{ 0x0999, "BENGALI LETTER NGA" },
	{ 0x099A, "BENGALI LETTER CA" },
	{ 0x099B, "BENGALI LETTER CHA" },
	{ 0x099C, "BENGALI LETTER JA" },
	{ 0x099D, "BENGALI LETTER JHA" },
	{ 0x099E, "BENGALI LETTER NYA" },
	{ 0x099F, "BENGALI LETTER TTA" },
	{ 0x09A0, "BENGALI LETTER TTHA" },
	{ 0x09A1, "BENGALI LETTER DDA" },
	{ 0x09A2, "BENGALI LETTER DDHA" },
	{ 0x09A3, "BENGALI LETTER NNA" },
	{ 0x09A4, "BENGALI LETTER TA" },
	{ 0x09A5, "BENGALI LETTER THA" },
	{ 0x09A6, "BENGALI LETTER DA" },
	{ 0x09A7, "BENGALI LETTER DHA" },
	{ 0x09A8, "BENGALI LETTER NA" },
	{ 0x09AA, "BENGALI LETTER PA" },
	{ 0x09AB, "BENGALI LETTER PHA" },
	{ 0x09AC, "BENGALI LETTER BA" },
	{ 0x09AD, "BENGALI LETTER BHA" },
	{ 0x09AE, "BENGALI LETTER MA" },
	{ 0x09AF, "BENGALI LETTER YA" },
	{ 0x09B0, "BENGALI LETTER RA" },
	{ 0x09B2, "BENGALI LETTER LA" },
	{ 0x09B6, "BENGALI LETTER SHA" },
	{ 0x09B7, "BENGALI LETTER SSA" },
	{ 0x09B8, "BENGALI LETTER SA" },
	{ 0x09B9, "BENGALI LETTER HA" },
	{ 0x09BC, "BENGALI SIGN NUKTA" },
	{ 0x09BE, "BENGALI VOWEL SIGN AA" },
	{ 0x09BF, "BENGALI VOWEL SIGN I" },
	{ 0x09C0, "BENGALI VOWEL SIGN II" },
	{ 0x09C1, "BENGALI VOWEL SIGN U" },
	{ 0x09C2, "BENGALI VOWEL SIGN UU" },
	{ 0x09C3, "BENGALI VOWEL SIGN VOCALIC R" },
	{ 0x09C4, "BENGALI VOWEL SIGN VOCALIC RR" },
	{ 0x09C7, "BENGALI VOWEL SIGN E" },
	{ 0x09C8, "BENGALI VOWEL SIGN AI" },
	{ 0x09CB, "BENGALI VOWEL SIGN O" },
	{ 0x09CC, "BENGALI VOWEL SIGN AU" },
	{ 0x09CD, "BENGALI SIGN VIRAMA" },
	{ 0x09D7, "BENGALI AU LENGTH MARK" },
	{ 0x09DC, "BENGALI LETTER RRA" },
	{ 0x09DD, "BENGALI LETTER RHA" },
	{ 0x09DF, "BENGALI LETTER YYA" },
	{ 0x09E0, "BENGALI LETTER VOCALIC RR" },
	{ 0x09E1, "BENGALI LETTER VOCALIC LL" },
	{ 0x09E2, "BENGALI VOWEL SIGN VOCALIC L" },
	{ 0x09E3, "BENGALI VOWEL SIGN VOCALIC LL" },
	{ 0x09E6, "BENGALI DIGIT ZERO" },
	{ 0x09E7, "BENGALI DIGIT ONE" },
	{ 0x09E8, "BENGALI DIGIT TWO" },
	{ 0x09E9, "BENGALI DIGIT THREE" },
	{ 0x09EA, "BENGALI DIGIT FOUR" },
	{ 0x09EB, "BENGALI DIGIT FIVE" },
	{ 0x09EC, "BENGALI DIGIT SIX" },
	{ 0x09ED, "BENGALI DIGIT SEVEN" },
	{ 0x09EE, "BENGALI DIGIT EIGHT" },
	{ 0x09EF, "BENGALI DIGIT NINE" },
	{ 0x09F0, "BENGALI LETTER RA WITH MIDDLE DIAGONAL" },	/* Assamese */
	{ 0x09F1, "BENGALI LETTER RA WITH LOWER DIAGONAL" },	/* Assamese */
	{ 0x09F2, "BENGALI RUPEE MARK" },
	{ 0x09F3, "BENGALI RUPEE SIGN" },
	{ 0x09F4, "BENGALI CURRENCY NUMERATOR ONE" },
	{ 0x09F5, "BENGALI CURRENCY NUMERATOR TWO" },
	{ 0x09F6, "BENGALI CURRENCY NUMERATOR THREE" },
	{ 0x09F7, "BENGALI CURRENCY NUMERATOR FOUR" },
	{ 0x09F8, "BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR" },
	{ 0x09F9, "BENGALI CURRENCY DENOMINATOR SIXTEEN" },
	{ 0x09FA, "BENGALI ISSHAR" },
	{ 0x0A02, "GURMUKHI SIGN BINDI" },
	{ 0x0A05, "GURMUKHI LETTER A" },
	{ 0x0A06, "GURMUKHI LETTER AA" },
	{ 0x0A07, "GURMUKHI LETTER I" },
	{ 0x0A08, "GURMUKHI LETTER II" },
	{ 0x0A09, "GURMUKHI LETTER U" },
	{ 0x0A0A, "GURMUKHI LETTER UU" },
	{ 0x0A0F, "GURMUKHI LETTER EE" },
	{ 0x0A10, "GURMUKHI LETTER AI" },
	{ 0x0A13, "GURMUKHI LETTER OO" },
	{ 0x0A14, "GURMUKHI LETTER AU" },
	{ 0x0A15, "GURMUKHI LETTER KA" },
	{ 0x0A16, "GURMUKHI LETTER KHA" },
	{ 0x0A17, "GURMUKHI LETTER GA" },
	{ 0x0A18, "GURMUKHI LETTER GHA" },
	{ 0x0A19, "GURMUKHI LETTER NGA" },
	{ 0x0A1A, "GURMUKHI LETTER CA" },
	{ 0x0A1B, "GURMUKHI LETTER CHA" },
	{ 0x0A1C, "GURMUKHI LETTER JA" },
	{ 0x0A1D, "GURMUKHI LETTER JHA" },
	{ 0x0A1E, "GURMUKHI LETTER NYA" },
	{ 0x0A1F, "GURMUKHI LETTER TTA" },
	{ 0x0A20, "GURMUKHI LETTER TTHA" },
	{ 0x0A21, "GURMUKHI LETTER DDA" },
	{ 0x0A22, "GURMUKHI LETTER DDHA" },
	{ 0x0A23, "GURMUKHI LETTER NNA" },
	{ 0x0A24, "GURMUKHI LETTER TA" },
	{ 0x0A25, "GURMUKHI LETTER THA" },
	{ 0x0A26, "GURMUKHI LETTER DA" },
	{ 0x0A27, "GURMUKHI LETTER DHA" },
	{ 0x0A28, "GURMUKHI LETTER NA" },
	{ 0x0A2A, "GURMUKHI LETTER PA" },
	{ 0x0A2B, "GURMUKHI LETTER PHA" },
	{ 0x0A2C, "GURMUKHI LETTER BA" },
	{ 0x0A2D, "GURMUKHI LETTER BHA" },
	{ 0x0A2E, "GURMUKHI LETTER MA" },
	{ 0x0A2F, "GURMUKHI LETTER YA" },
	{ 0x0A30, "GURMUKHI LETTER RA" },
	{ 0x0A32, "GURMUKHI LETTER LA" },
	{ 0x0A33, "GURMUKHI LETTER LLA" },
	{ 0x0A35, "GURMUKHI LETTER VA" },
	{ 0x0A36, "GURMUKHI LETTER SHA" },
	{ 0x0A38, "GURMUKHI LETTER SA" },
	{ 0x0A39, "GURMUKHI LETTER HA" },
	{ 0x0A3C, "GURMUKHI SIGN NUKTA" },
	{ 0x0A3E, "GURMUKHI VOWEL SIGN AA" },
	{ 0x0A3F, "GURMUKHI VOWEL SIGN I" },
	{ 0x0A40, "GURMUKHI VOWEL SIGN II" },
	{ 0x0A41, "GURMUKHI VOWEL SIGN U" },
	{ 0x0A42, "GURMUKHI VOWEL SIGN UU" },
	{ 0x0A47, "GURMUKHI VOWEL SIGN EE" },
	{ 0x0A48, "GURMUKHI VOWEL SIGN AI" },
	{ 0x0A4B, "GURMUKHI VOWEL SIGN OO" },
	{ 0x0A4C, "GURMUKHI VOWEL SIGN AU" },
	{ 0x0A4D, "GURMUKHI SIGN VIRAMA" },
	{ 0x0A59, "GURMUKHI LETTER KHHA" },
	{ 0x0A5A, "GURMUKHI LETTER GHHA" },
	{ 0x0A5B, "GURMUKHI LETTER ZA" },
	{ 0x0A5C, "GURMUKHI LETTER RRA" },
	{ 0x0A5E, "GURMUKHI LETTER FA" },
	{ 0x0A66, "GURMUKHI DIGIT ZERO" },
	{ 0x0A67, "GURMUKHI DIGIT ONE" },
	{ 0x0A68, "GURMUKHI DIGIT TWO" },
	{ 0x0A69, "GURMUKHI DIGIT THREE" },
	{ 0x0A6A, "GURMUKHI DIGIT FOUR" },
	{ 0x0A6B, "GURMUKHI DIGIT FIVE" },
	{ 0x0A6C, "GURMUKHI DIGIT SIX" },
	{ 0x0A6D, "GURMUKHI DIGIT SEVEN" },
	{ 0x0A6E, "GURMUKHI DIGIT EIGHT" },
	{ 0x0A6F, "GURMUKHI DIGIT NINE" },
	{ 0x0A70, "GURMUKHI TIPPI" },
	{ 0x0A71, "GURMUKHI ADDAK" },
	{ 0x0A72, "GURMUKHI IRI" },
	{ 0x0A73, "GURMUKHI URA" },
	{ 0x0A74, "GURMUKHI EK ONKAR" },
	{ 0x0A81, "GUJARATI SIGN CANDRABINDU" },
	{ 0x0A82, "GUJARATI SIGN ANUSVARA" },
	{ 0x0A83, "GUJARATI SIGN VISARGA" },
	{ 0x0A85, "GUJARATI LETTER A" },
	{ 0x0A86, "GUJARATI LETTER AA" },
	{ 0x0A87, "GUJARATI LETTER I" },
	{ 0x0A88, "GUJARATI LETTER II" },
	{ 0x0A89, "GUJARATI LETTER U" },
	{ 0x0A8A, "GUJARATI LETTER UU" },
	{ 0x0A8B, "GUJARATI LETTER VOCALIC R" },
	{ 0x0A8D, "GUJARATI VOWEL CANDRA E" },
	{ 0x0A8F, "GUJARATI LETTER E" },
	{ 0x0A90, "GUJARATI LETTER AI" },
	{ 0x0A91, "GUJARATI VOWEL CANDRA O" },
	{ 0x0A93, "GUJARATI LETTER O" },
	{ 0x0A94, "GUJARATI LETTER AU" },
	{ 0x0A95, "GUJARATI LETTER KA" },
	{ 0x0A96, "GUJARATI LETTER KHA" },
	{ 0x0A97, "GUJARATI LETTER GA" },
	{ 0x0A98, "GUJARATI LETTER GHA" },
	{ 0x0A99, "GUJARATI LETTER NGA" },
	{ 0x0A9A, "GUJARATI LETTER CA" },
	{ 0x0A9B, "GUJARATI LETTER CHA" },
	{ 0x0A9C, "GUJARATI LETTER JA" },
	{ 0x0A9D, "GUJARATI LETTER JHA" },
	{ 0x0A9E, "GUJARATI LETTER NYA" },
	{ 0x0A9F, "GUJARATI LETTER TTA" },
	{ 0x0AA0, "GUJARATI LETTER TTHA" },
	{ 0x0AA1, "GUJARATI LETTER DDA" },
	{ 0x0AA2, "GUJARATI LETTER DDHA" },
	{ 0x0AA3, "GUJARATI LETTER NNA" },
	{ 0x0AA4, "GUJARATI LETTER TA" },
	{ 0x0AA5, "GUJARATI LETTER THA" },
	{ 0x0AA6, "GUJARATI LETTER DA" },
	{ 0x0AA7, "GUJARATI LETTER DHA" },
	{ 0x0AA8, "GUJARATI LETTER NA" },
	{ 0x0AAA, "GUJARATI LETTER PA" },
	{ 0x0AAB, "GUJARATI LETTER PHA" },
	{ 0x0AAC, "GUJARATI LETTER BA" },
	{ 0x0AAD, "GUJARATI LETTER BHA" },
	{ 0x0AAE, "GUJARATI LETTER MA" },
	{ 0x0AAF, "GUJARATI LETTER YA" },
	{ 0x0AB0, "GUJARATI LETTER RA" },
	{ 0x0AB2, "GUJARATI LETTER LA" },
	{ 0x0AB3, "GUJARATI LETTER LLA" },
	{ 0x0AB5, "GUJARATI LETTER VA" },
	{ 0x0AB6, "GUJARATI LETTER SHA" },
	{ 0x0AB7, "GUJARATI LETTER SSA" },
	{ 0x0AB8, "GUJARATI LETTER SA" },
	{ 0x0AB9, "GUJARATI LETTER HA" },
	{ 0x0ABC, "GUJARATI SIGN NUKTA" },
	{ 0x0ABD, "GUJARATI SIGN AVAGRAHA" },
	{ 0x0ABE, "GUJARATI VOWEL SIGN AA" },
	{ 0x0ABF, "GUJARATI VOWEL SIGN I" },
	{ 0x0AC0, "GUJARATI VOWEL SIGN II" },
	{ 0x0AC1, "GUJARATI VOWEL SIGN U" },
	{ 0x0AC2, "GUJARATI VOWEL SIGN UU" },
	{ 0x0AC3, "GUJARATI VOWEL SIGN VOCALIC R" },
	{ 0x0AC4, "GUJARATI VOWEL SIGN VOCALIC RR" },
	{ 0x0AC5, "GUJARATI VOWEL SIGN CANDRA E" },
	{ 0x0AC7, "GUJARATI VOWEL SIGN E" },
	{ 0x0AC8, "GUJARATI VOWEL SIGN AI" },
	{ 0x0AC9, "GUJARATI VOWEL SIGN CANDRA O" },
	{ 0x0ACB, "GUJARATI VOWEL SIGN O" },
	{ 0x0ACC, "GUJARATI VOWEL SIGN AU" },
	{ 0x0ACD, "GUJARATI SIGN VIRAMA" },
	{ 0x0AD0, "GUJARATI OM" },
	{ 0x0AE0, "GUJARATI LETTER VOCALIC RR" },
	{ 0x0AE6, "GUJARATI DIGIT ZERO" },
	{ 0x0AE7, "GUJARATI DIGIT ONE" },
	{ 0x0AE8, "GUJARATI DIGIT TWO" },
	{ 0x0AE9, "GUJARATI DIGIT THREE" },
	{ 0x0AEA, "GUJARATI DIGIT FOUR" },
	{ 0x0AEB, "GUJARATI DIGIT FIVE" },
	{ 0x0AEC, "GUJARATI DIGIT SIX" },
	{ 0x0AED, "GUJARATI DIGIT SEVEN" },
	{ 0x0AEE, "GUJARATI DIGIT EIGHT" },
	{ 0x0AEF, "GUJARATI DIGIT NINE" },
	{ 0x0B01, "ORIYA SIGN CANDRABINDU" },
	{ 0x0B02, "ORIYA SIGN ANUSVARA" },
	{ 0x0B03, "ORIYA SIGN VISARGA" },
	{ 0x0B05, "ORIYA LETTER A" },
	{ 0x0B06, "ORIYA LETTER AA" },
	{ 0x0B07, "ORIYA LETTER I" },
	{ 0x0B08, "ORIYA LETTER II" },
	{ 0x0B09, "ORIYA LETTER U" },
	{ 0x0B0A, "ORIYA LETTER UU" },
	{ 0x0B0B, "ORIYA LETTER VOCALIC R" },
	{ 0x0B0C, "ORIYA LETTER VOCALIC L" },
	{ 0x0B0F, "ORIYA LETTER E" },
	{ 0x0B10, "ORIYA LETTER AI" },
	{ 0x0B13, "ORIYA LETTER O" },
	{ 0x0B14, "ORIYA LETTER AU" },
	{ 0x0B15, "ORIYA LETTER KA" },
	{ 0x0B16, "ORIYA LETTER KHA" },
	{ 0x0B17, "ORIYA LETTER GA" },
	{ 0x0B18, "ORIYA LETTER GHA" },
	{ 0x0B19, "ORIYA LETTER NGA" },
	{ 0x0B1A, "ORIYA LETTER CA" },
	{ 0x0B1B, "ORIYA LETTER CHA" },
	{ 0x0B1C, "ORIYA LETTER JA" },
	{ 0x0B1D, "ORIYA LETTER JHA" },
	{ 0x0B1E, "ORIYA LETTER NYA" },
	{ 0x0B1F, "ORIYA LETTER TTA" },
	{ 0x0B20, "ORIYA LETTER TTHA" },
	{ 0x0B21, "ORIYA LETTER DDA" },
	{ 0x0B22, "ORIYA LETTER DDHA" },
	{ 0x0B23, "ORIYA LETTER NNA" },
	{ 0x0B24, "ORIYA LETTER TA" },
	{ 0x0B25, "ORIYA LETTER THA" },
	{ 0x0B26, "ORIYA LETTER DA" },
	{ 0x0B27, "ORIYA LETTER DHA" },
	{ 0x0B28, "ORIYA LETTER NA" },
	{ 0x0B2A, "ORIYA LETTER PA" },
	{ 0x0B2B, "ORIYA LETTER PHA" },
	{ 0x0B2C, "ORIYA LETTER BA" },
	{ 0x0B2D, "ORIYA LETTER BHA" },
	{ 0x0B2E, "ORIYA LETTER MA" },
	{ 0x0B2F, "ORIYA LETTER YA" },
	{ 0x0B30, "ORIYA LETTER RA" },
	{ 0x0B32, "ORIYA LETTER LA" },
	{ 0x0B33, "ORIYA LETTER LLA" },
	{ 0x0B36, "ORIYA LETTER SHA" },
	{ 0x0B37, "ORIYA LETTER SSA" },
	{ 0x0B38, "ORIYA LETTER SA" },
	{ 0x0B39, "ORIYA LETTER HA" },
	{ 0x0B3C, "ORIYA SIGN NUKTA" },
	{ 0x0B3D, "ORIYA SIGN AVAGRAHA" },
	{ 0x0B3E, "ORIYA VOWEL SIGN AA" },
	{ 0x0B3F, "ORIYA VOWEL SIGN I" },
	{ 0x0B40, "ORIYA VOWEL SIGN II" },
	{ 0x0B41, "ORIYA VOWEL SIGN U" },
	{ 0x0B42, "ORIYA VOWEL SIGN UU" },
	{ 0x0B43, "ORIYA VOWEL SIGN VOCALIC R" },
	{ 0x0B47, "ORIYA VOWEL SIGN E" },
	{ 0x0B48, "ORIYA VOWEL SIGN AI" },
	{ 0x0B4B, "ORIYA VOWEL SIGN O" },
	{ 0x0B4C, "ORIYA VOWEL SIGN AU" },
	{ 0x0B4D, "ORIYA SIGN VIRAMA" },
	{ 0x0B56, "ORIYA AI LENGTH MARK" },
	{ 0x0B57, "ORIYA AU LENGTH MARK" },
	{ 0x0B5C, "ORIYA LETTER RRA" },
	{ 0x0B5D, "ORIYA LETTER RHA" },
	{ 0x0B5F, "ORIYA LETTER YYA" },
	{ 0x0B60, "ORIYA LETTER VOCALIC RR" },
	{ 0x0B61, "ORIYA LETTER VOCALIC LL" },
	{ 0x0B66, "ORIYA DIGIT ZERO" },
	{ 0x0B67, "ORIYA DIGIT ONE" },
	{ 0x0B68, "ORIYA DIGIT TWO" },
	{ 0x0B69, "ORIYA DIGIT THREE" },
	{ 0x0B6A, "ORIYA DIGIT FOUR" },
	{ 0x0B6B, "ORIYA DIGIT FIVE" },
	{ 0x0B6C, "ORIYA DIGIT SIX" },
	{ 0x0B6D, "ORIYA DIGIT SEVEN" },
	{ 0x0B6E, "ORIYA DIGIT EIGHT" },
	{ 0x0B6F, "ORIYA DIGIT NINE" },
	{ 0x0B70, "ORIYA ISSHAR" },
	{ 0x0B82, "TAMIL SIGN ANUSVARA" },
	{ 0x0B83, "TAMIL SIGN VISARGA" },
	{ 0x0B85, "TAMIL LETTER A" },
	{ 0x0B86, "TAMIL LETTER AA" },
	{ 0x0B87, "TAMIL LETTER I" },
	{ 0x0B88, "TAMIL LETTER II" },
	{ 0x0B89, "TAMIL LETTER U" },
	{ 0x0B8A, "TAMIL LETTER UU" },
	{ 0x0B8E, "TAMIL LETTER E" },
	{ 0x0B8F, "TAMIL LETTER EE" },
	{ 0x0B90, "TAMIL LETTER AI" },
	{ 0x0B92, "TAMIL LETTER O" },
	{ 0x0B93, "TAMIL LETTER OO" },
	{ 0x0B94, "TAMIL LETTER AU" },
	{ 0x0B95, "TAMIL LETTER KA" },
	{ 0x0B99, "TAMIL LETTER NGA" },
	{ 0x0B9A, "TAMIL LETTER CA" },
	{ 0x0B9C, "TAMIL LETTER JA" },
	{ 0x0B9E, "TAMIL LETTER NYA" },
	{ 0x0B9F, "TAMIL LETTER TTA" },
	{ 0x0BA3, "TAMIL LETTER NNA" },
	{ 0x0BA4, "TAMIL LETTER TA" },
	{ 0x0BA8, "TAMIL LETTER NA" },
	{ 0x0BA9, "TAMIL LETTER NNNA" },
	{ 0x0BAA, "TAMIL LETTER PA" },
	{ 0x0BAE, "TAMIL LETTER MA" },
	{ 0x0BAF, "TAMIL LETTER YA" },
	{ 0x0BB0, "TAMIL LETTER RA" },
	{ 0x0BB1, "TAMIL LETTER RRA" },
	{ 0x0BB2, "TAMIL LETTER LA" },
	{ 0x0BB3, "TAMIL LETTER LLA" },
	{ 0x0BB4, "TAMIL LETTER LLLA" },
	{ 0x0BB5, "TAMIL LETTER VA" },
	{ 0x0BB7, "TAMIL LETTER SSA" },
	{ 0x0BB8, "TAMIL LETTER SA" },
	{ 0x0BB9, "TAMIL LETTER HA" },
	{ 0x0BBE, "TAMIL VOWEL SIGN AA" },
	{ 0x0BBF, "TAMIL VOWEL SIGN I" },
	{ 0x0BC0, "TAMIL VOWEL SIGN II" },
	{ 0x0BC1, "TAMIL VOWEL SIGN U" },
	{ 0x0BC2, "TAMIL VOWEL SIGN UU" },
	{ 0x0BC6, "TAMIL VOWEL SIGN E" },
	{ 0x0BC7, "TAMIL VOWEL SIGN EE" },
	{ 0x0BC8, "TAMIL VOWEL SIGN AI" },
	{ 0x0BCA, "TAMIL VOWEL SIGN O" },
	{ 0x0BCB, "TAMIL VOWEL SIGN OO" },
	{ 0x0BCC, "TAMIL VOWEL SIGN AU" },
	{ 0x0BCD, "TAMIL SIGN VIRAMA" },
	{ 0x0BD7, "TAMIL AU LENGTH MARK" },
	{ 0x0BE7, "TAMIL DIGIT ONE" },
	{ 0x0BE8, "TAMIL DIGIT TWO" },
	{ 0x0BE9, "TAMIL DIGIT THREE" },
	{ 0x0BEA, "TAMIL DIGIT FOUR" },
	{ 0x0BEB, "TAMIL DIGIT FIVE" },
	{ 0x0BEC, "TAMIL DIGIT SIX" },
	{ 0x0BED, "TAMIL DIGIT SEVEN" },
	{ 0x0BEE, "TAMIL DIGIT EIGHT" },
	{ 0x0BEF, "TAMIL DIGIT NINE" },
	{ 0x0BF0, "TAMIL NUMBER TEN" },
	{ 0x0BF1, "TAMIL NUMBER ONE HUNDRED" },
	{ 0x0BF2, "TAMIL NUMBER ONE THOUSAND" },
	{ 0x0C01, "TELUGU SIGN CANDRABINDU" },
	{ 0x0C02, "TELUGU SIGN ANUSVARA" },
	{ 0x0C03, "TELUGU SIGN VISARGA" },
	{ 0x0C05, "TELUGU LETTER A" },
	{ 0x0C06, "TELUGU LETTER AA" },
	{ 0x0C07, "TELUGU LETTER I" },
	{ 0x0C08, "TELUGU LETTER II" },
	{ 0x0C09, "TELUGU LETTER U" },
	{ 0x0C0A, "TELUGU LETTER UU" },
	{ 0x0C0B, "TELUGU LETTER VOCALIC R" },
	{ 0x0C0C, "TELUGU LETTER VOCALIC L" },
	{ 0x0C0E, "TELUGU LETTER E" },
	{ 0x0C0F, "TELUGU LETTER EE" },
	{ 0x0C10, "TELUGU LETTER AI" },
	{ 0x0C12, "TELUGU LETTER O" },
	{ 0x0C13, "TELUGU LETTER OO" },
	{ 0x0C14, "TELUGU LETTER AU" },
	{ 0x0C15, "TELUGU LETTER KA" },
	{ 0x0C16, "TELUGU LETTER KHA" },
	{ 0x0C17, "TELUGU LETTER GA" },
	{ 0x0C18, "TELUGU LETTER GHA" },
	{ 0x0C19, "TELUGU LETTER NGA" },
	{ 0x0C1A, "TELUGU LETTER CA" },
	{ 0x0C1B, "TELUGU LETTER CHA" },
	{ 0x0C1C, "TELUGU LETTER JA" },
	{ 0x0C1D, "TELUGU LETTER JHA" },
	{ 0x0C1E, "TELUGU LETTER NYA" },
	{ 0x0C1F, "TELUGU LETTER TTA" },
	{ 0x0C20, "TELUGU LETTER TTHA" },
	{ 0x0C21, "TELUGU LETTER DDA" },
	{ 0x0C22, "TELUGU LETTER DDHA" },
	{ 0x0C23, "TELUGU LETTER NNA" },
	{ 0x0C24, "TELUGU LETTER TA" },
	{ 0x0C25, "TELUGU LETTER THA" },
	{ 0x0C26, "TELUGU LETTER DA" },
	{ 0x0C27, "TELUGU LETTER DHA" },
	{ 0x0C28, "TELUGU LETTER NA" },
	{ 0x0C2A, "TELUGU LETTER PA" },
	{ 0x0C2B, "TELUGU LETTER PHA" },
	{ 0x0C2C, "TELUGU LETTER BA" },
	{ 0x0C2D, "TELUGU LETTER BHA" },
	{ 0x0C2E, "TELUGU LETTER MA" },
	{ 0x0C2F, "TELUGU LETTER YA" },
	{ 0x0C30, "TELUGU LETTER RA" },
	{ 0x0C31, "TELUGU LETTER RRA" },
	{ 0x0C32, "TELUGU LETTER LA" },
	{ 0x0C33, "TELUGU LETTER LLA" },
	{ 0x0C35, "TELUGU LETTER VA" },
	{ 0x0C36, "TELUGU LETTER SHA" },
	{ 0x0C37, "TELUGU LETTER SSA" },
	{ 0x0C38, "TELUGU LETTER SA" },
	{ 0x0C39, "TELUGU LETTER HA" },
	{ 0x0C3E, "TELUGU VOWEL SIGN AA" },
	{ 0x0C3F, "TELUGU VOWEL SIGN I" },
	{ 0x0C40, "TELUGU VOWEL SIGN II" },
	{ 0x0C41, "TELUGU VOWEL SIGN U" },
	{ 0x0C42, "TELUGU VOWEL SIGN UU" },
	{ 0x0C43, "TELUGU VOWEL SIGN VOCALIC R" },
	{ 0x0C44, "TELUGU VOWEL SIGN VOCALIC RR" },
	{ 0x0C46, "TELUGU VOWEL SIGN E" },
	{ 0x0C47, "TELUGU VOWEL SIGN EE" },
	{ 0x0C48, "TELUGU VOWEL SIGN AI" },
	{ 0x0C4A, "TELUGU VOWEL SIGN O" },
	{ 0x0C4B, "TELUGU VOWEL SIGN OO" },
	{ 0x0C4C, "TELUGU VOWEL SIGN AU" },
	{ 0x0C4D, "TELUGU SIGN VIRAMA" },
	{ 0x0C55, "TELUGU LENGTH MARK" },
	{ 0x0C56, "TELUGU AI LENGTH MARK" },
	{ 0x0C60, "TELUGU LETTER VOCALIC RR" },
	{ 0x0C61, "TELUGU LETTER VOCALIC LL" },
	{ 0x0C66, "TELUGU DIGIT ZERO" },
	{ 0x0C67, "TELUGU DIGIT ONE" },
	{ 0x0C68, "TELUGU DIGIT TWO" },
	{ 0x0C69, "TELUGU DIGIT THREE" },
	{ 0x0C6A, "TELUGU DIGIT FOUR" },
	{ 0x0C6B, "TELUGU DIGIT FIVE" },
	{ 0x0C6C, "TELUGU DIGIT SIX" },
	{ 0x0C6D, "TELUGU DIGIT SEVEN" },
	{ 0x0C6E, "TELUGU DIGIT EIGHT" },
	{ 0x0C6F, "TELUGU DIGIT NINE" },
	{ 0x0C82, "KANNADA SIGN ANUSVARA" },
	{ 0x0C83, "KANNADA SIGN VISARGA" },
	{ 0x0C85, "KANNADA LETTER A" },
	{ 0x0C86, "KANNADA LETTER AA" },
	{ 0x0C87, "KANNADA LETTER I" },
	{ 0x0C88, "KANNADA LETTER II" },
	{ 0x0C89, "KANNADA LETTER U" },
	{ 0x0C8A, "KANNADA LETTER UU" },
	{ 0x0C8B, "KANNADA LETTER VOCALIC R" },
	{ 0x0C8C, "KANNADA LETTER VOCALIC L" },
	{ 0x0C8E, "KANNADA LETTER E" },
	{ 0x0C8F, "KANNADA LETTER EE" },
	{ 0x0C90, "KANNADA LETTER AI" },
	{ 0x0C92, "KANNADA LETTER O" },
	{ 0x0C93, "KANNADA LETTER OO" },
	{ 0x0C94, "KANNADA LETTER AU" },
	{ 0x0C95, "KANNADA LETTER KA" },
	{ 0x0C96, "KANNADA LETTER KHA" },
	{ 0x0C97, "KANNADA LETTER GA" },
	{ 0x0C98, "KANNADA LETTER GHA" },
	{ 0x0C99, "KANNADA LETTER NGA" },
	{ 0x0C9A, "KANNADA LETTER CA" },
	{ 0x0C9B, "KANNADA LETTER CHA" },
	{ 0x0C9C, "KANNADA LETTER JA" },
	{ 0x0C9D, "KANNADA LETTER JHA" },
	{ 0x0C9E, "KANNADA LETTER NYA" },
	{ 0x0C9F, "KANNADA LETTER TTA" },
	{ 0x0CA0, "KANNADA LETTER TTHA" },
	{ 0x0CA1, "KANNADA LETTER DDA" },
	{ 0x0CA2, "KANNADA LETTER DDHA" },
	{ 0x0CA3, "KANNADA LETTER NNA" },
	{ 0x0CA4, "KANNADA LETTER TA" },
	{ 0x0CA5, "KANNADA LETTER THA" },
	{ 0x0CA6, "KANNADA LETTER DA" },
	{ 0x0CA7, "KANNADA LETTER DHA" },
	{ 0x0CA8, "KANNADA LETTER NA" },
	{ 0x0CAA, "KANNADA LETTER PA" },
	{ 0x0CAB, "KANNADA LETTER PHA" },
	{ 0x0CAC, "KANNADA LETTER BA" },
	{ 0x0CAD, "KANNADA LETTER BHA" },
	{ 0x0CAE, "KANNADA LETTER MA" },
	{ 0x0CAF, "KANNADA LETTER YA" },
	{ 0x0CB0, "KANNADA LETTER RA" },
	{ 0x0CB1, "KANNADA LETTER RRA" },
	{ 0x0CB2, "KANNADA LETTER LA" },
	{ 0x0CB3, "KANNADA LETTER LLA" },
	{ 0x0CB5, "KANNADA LETTER VA" },
	{ 0x0CB6, "KANNADA LETTER SHA" },
	{ 0x0CB7, "KANNADA LETTER SSA" },
	{ 0x0CB8, "KANNADA LETTER SA" },
	{ 0x0CB9, "KANNADA LETTER HA" },
	{ 0x0CBE, "KANNADA VOWEL SIGN AA" },
	{ 0x0CBF, "KANNADA VOWEL SIGN I" },
	{ 0x0CC0, "KANNADA VOWEL SIGN II" },
	{ 0x0CC1, "KANNADA VOWEL SIGN U" },
	{ 0x0CC2, "KANNADA VOWEL SIGN UU" },
	{ 0x0CC3, "KANNADA VOWEL SIGN VOCALIC R" },
	{ 0x0CC4, "KANNADA VOWEL SIGN VOCALIC RR" },
	{ 0x0CC6, "KANNADA VOWEL SIGN E" },
	{ 0x0CC7, "KANNADA VOWEL SIGN EE" },
	{ 0x0CC8, "KANNADA VOWEL SIGN AI" },
	{ 0x0CCA, "KANNADA VOWEL SIGN O" },
	{ 0x0CCB, "KANNADA VOWEL SIGN OO" },
	{ 0x0CCC, "KANNADA VOWEL SIGN AU" },
	{ 0x0CCD, "KANNADA SIGN VIRAMA" },
	{ 0x0CD5, "KANNADA LENGTH MARK" },
	{ 0x0CD6, "KANNADA AI LENGTH MARK" },
	{ 0x0CDE, "KANNADA LETTER FA" },
	{ 0x0CE0, "KANNADA LETTER VOCALIC RR" },
	{ 0x0CE1, "KANNADA LETTER VOCALIC LL" },
	{ 0x0CE6, "KANNADA DIGIT ZERO" },
	{ 0x0CE7, "KANNADA DIGIT ONE" },
	{ 0x0CE8, "KANNADA DIGIT TWO" },
	{ 0x0CE9, "KANNADA DIGIT THREE" },
	{ 0x0CEA, "KANNADA DIGIT FOUR" },
	{ 0x0CEB, "KANNADA DIGIT FIVE" },
	{ 0x0CEC, "KANNADA DIGIT SIX" },
	{ 0x0CED, "KANNADA DIGIT SEVEN" },
	{ 0x0CEE, "KANNADA DIGIT EIGHT" },
	{ 0x0CEF, "KANNADA DIGIT NINE" },
	{ 0x0D02, "MALAYALAM SIGN ANUSVARA" },
	{ 0x0D03, "MALAYALAM SIGN VISARGA" },
	{ 0x0D05, "MALAYALAM LETTER A" },
	{ 0x0D06, "MALAYALAM LETTER AA" },
	{ 0x0D07, "MALAYALAM LETTER I" },
	{ 0x0D08, "MALAYALAM LETTER II" },
	{ 0x0D09, "MALAYALAM LETTER U" },
	{ 0x0D0A, "MALAYALAM LETTER UU" },
	{ 0x0D0B, "MALAYALAM LETTER VOCALIC R" },
	{ 0x0D0C, "MALAYALAM LETTER VOCALIC L" },
	{ 0x0D0E, "MALAYALAM LETTER E" },
	{ 0x0D0F, "MALAYALAM LETTER EE" },
	{ 0x0D10, "MALAYALAM LETTER AI" },
	{ 0x0D12, "MALAYALAM LETTER O" },
	{ 0x0D13, "MALAYALAM LETTER OO" },
	{ 0x0D14, "MALAYALAM LETTER AU" },
	{ 0x0D15, "MALAYALAM LETTER KA" },
	{ 0x0D16, "MALAYALAM LETTER KHA" },
	{ 0x0D17, "MALAYALAM LETTER GA" },
	{ 0x0D18, "MALAYALAM LETTER GHA" },
	{ 0x0D19, "MALAYALAM LETTER NGA" },
	{ 0x0D1A, "MALAYALAM LETTER CA" },
	{ 0x0D1B, "MALAYALAM LETTER CHA" },
	{ 0x0D1C, "MALAYALAM LETTER JA" },
	{ 0x0D1D, "MALAYALAM LETTER JHA" },
	{ 0x0D1E, "MALAYALAM LETTER NYA" },
	{ 0x0D1F, "MALAYALAM LETTER TTA" },
	{ 0x0D20, "MALAYALAM LETTER TTHA" },
	{ 0x0D21, "MALAYALAM LETTER DDA" },
	{ 0x0D22, "MALAYALAM LETTER DDHA" },
	{ 0x0D23, "MALAYALAM LETTER NNA" },
	{ 0x0D24, "MALAYALAM LETTER TA" },
	{ 0x0D25, "MALAYALAM LETTER THA" },
	{ 0x0D26, "MALAYALAM LETTER DA" },
	{ 0x0D27, "MALAYALAM LETTER DHA" },
	{ 0x0D28, "MALAYALAM LETTER NA" },
	{ 0x0D2A, "MALAYALAM LETTER PA" },
	{ 0x0D2B, "MALAYALAM LETTER PHA" },
	{ 0x0D2C, "MALAYALAM LETTER BA" },
	{ 0x0D2D, "MALAYALAM LETTER BHA" },
	{ 0x0D2E, "MALAYALAM LETTER MA" },
	{ 0x0D2F, "MALAYALAM LETTER YA" },
	{ 0x0D30, "MALAYALAM LETTER RA" },
	{ 0x0D31, "MALAYALAM LETTER RRA" },
	{ 0x0D32, "MALAYALAM LETTER LA" },
	{ 0x0D33, "MALAYALAM LETTER LLA" },
	{ 0x0D34, "MALAYALAM LETTER LLLA" },
	{ 0x0D35, "MALAYALAM LETTER VA" },
	{ 0x0D36, "MALAYALAM LETTER SHA" },
	{ 0x0D37, "MALAYALAM LETTER SSA" },
	{ 0x0D38, "MALAYALAM LETTER SA" },
	{ 0x0D39, "MALAYALAM LETTER HA" },
	{ 0x0D3E, "MALAYALAM VOWEL SIGN AA" },
	{ 0x0D3F, "MALAYALAM VOWEL SIGN I" },
	{ 0x0D40, "MALAYALAM VOWEL SIGN II" },
	{ 0x0D41, "MALAYALAM VOWEL SIGN U" },
	{ 0x0D42, "MALAYALAM VOWEL SIGN UU" },
	{ 0x0D43, "MALAYALAM VOWEL SIGN VOCALIC R" },
	{ 0x0D46, "MALAYALAM VOWEL SIGN E" },
	{ 0x0D47, "MALAYALAM VOWEL SIGN EE" },
	{ 0x0D48, "MALAYALAM VOWEL SIGN AI" },
	{ 0x0D4A, "MALAYALAM VOWEL SIGN O" },
	{ 0x0D4B, "MALAYALAM VOWEL SIGN OO" },
	{ 0x0D4C, "MALAYALAM VOWEL SIGN AU" },
	{ 0x0D4D, "MALAYALAM SIGN VIRAMA" },
	{ 0x0D57, "MALAYALAM AU LENGTH MARK" },
	{ 0x0D60, "MALAYALAM LETTER VOCALIC RR" },
	{ 0x0D61, "MALAYALAM LETTER VOCALIC LL" },
	{ 0x0D66, "MALAYALAM DIGIT ZERO" },
	{ 0x0D67, "MALAYALAM DIGIT ONE" },
	{ 0x0D68, "MALAYALAM DIGIT TWO" },
	{ 0x0D69, "MALAYALAM DIGIT THREE" },
	{ 0x0D6A, "MALAYALAM DIGIT FOUR" },
	{ 0x0D6B, "MALAYALAM DIGIT FIVE" },
	{ 0x0D6C, "MALAYALAM DIGIT SIX" },
	{ 0x0D6D, "MALAYALAM DIGIT SEVEN" },
	{ 0x0D6E, "MALAYALAM DIGIT EIGHT" },
	{ 0x0D6F, "MALAYALAM DIGIT NINE" },
	{ 0x0D82, "SINHALA SIGN ANUSVARAYA" },
	{ 0x0D83, "SINHALA SIGN VISARGAYA" },
	{ 0x0D85, "SINHALA LETTER AYANNA" },
	{ 0x0D86, "SINHALA LETTER AAYANNA" },
	{ 0x0D87, "SINHALA LETTER AEYANNA" },
	{ 0x0D88, "SINHALA LETTER AEEYANNA" },
	{ 0x0D89, "SINHALA LETTER IYANNA" },
	{ 0x0D8A, "SINHALA LETTER IIYANNA" },
	{ 0x0D8B, "SINHALA LETTER UYANNA" },
	{ 0x0D8C, "SINHALA LETTER UUYANNA" },
	{ 0x0D8D, "SINHALA LETTER IRUYANNA" },
	{ 0x0D8E, "SINHALA LETTER IRUUYANNA" },
	{ 0x0D8F, "SINHALA LETTER ILUYANNA" },
	{ 0x0D90, "SINHALA LETTER ILUUYANNA" },
	{ 0x0D91, "SINHALA LETTER EYANNA" },
	{ 0x0D92, "SINHALA LETTER EEYANNA" },
	{ 0x0D93, "SINHALA LETTER AIYANNA" },
	{ 0x0D94, "SINHALA LETTER OYANNA" },
	{ 0x0D95, "SINHALA LETTER OOYANNA" },
	{ 0x0D96, "SINHALA LETTER AUYANNA" },
	{ 0x0D9A, "SINHALA LETTER ALPAPRAANA KAYANNA" },
	{ 0x0D9B, "SINHALA LETTER MAHAAPRAANA KAYANNA" },
	{ 0x0D9C, "SINHALA LETTER ALPAPRAANA GAYANNA" },
	{ 0x0D9D, "SINHALA LETTER MAHAAPRAANA GAYANNA" },
	{ 0x0D9E, "SINHALA LETTER KANTAJA NAASIKYAYA" },
	{ 0x0D9F, "SINHALA LETTER SANYAKA GAYANNA" },
	{ 0x0DA0, "SINHALA LETTER ALPAPRAANA CAYANNA" },
	{ 0x0DA1, "SINHALA LETTER MAHAAPRAANA CAYANNA" },
	{ 0x0DA2, "SINHALA LETTER ALPAPRAANA JAYANNA" },
	{ 0x0DA3, "SINHALA LETTER MAHAAPRAANA JAYANNA" },
	{ 0x0DA4, "SINHALA LETTER TAALUJA NAASIKYAYA" },
	{ 0x0DA5, "SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA" },
	{ 0x0DA6, "SINHALA LETTER SANYAKA JAYANNA" },
	{ 0x0DA7, "SINHALA LETTER ALPAPRAANA TTAYANNA" },
	{ 0x0DA8, "SINHALA LETTER MAHAAPRAANA TTAYANNA" },
	{ 0x0DA9, "SINHALA LETTER ALPAPRAANA DDAYANNA" },
	{ 0x0DAA, "SINHALA LETTER MAHAAPRAANA DDAYANNA" },
	{ 0x0DAB, "SINHALA LETTER MUURDHAJA NAYANNA" },
	{ 0x0DAC, "SINHALA LETTER SANYAKA DDAYANNA" },
	{ 0x0DAD, "SINHALA LETTER ALPAPRAANA TAYANNA" },
	{ 0x0DAE, "SINHALA LETTER MAHAAPRAANA TAYANNA" },
	{ 0x0DAF, "SINHALA LETTER ALPAPRAANA DAYANNA" },
	{ 0x0DB0, "SINHALA LETTER MAHAAPRAANA DAYANNA" },
	{ 0x0DB1, "SINHALA LETTER DANTAJA NAYANNA" },
	{ 0x0DB3, "SINHALA LETTER SANYAKA DAYANNA" },
	{ 0x0DB4, "SINHALA LETTER ALPAPRAANA PAYANNA" },
	{ 0x0DB5, "SINHALA LETTER MAHAAPRAANA PAYANNA" },
	{ 0x0DB6, "SINHALA LETTER ALPAPRAANA BAYANNA" },
	{ 0x0DB7, "SINHALA LETTER MAHAAPRAANA BAYANNA" },
	{ 0x0DB8, "SINHALA LETTER MAYANNA" },
	{ 0x0DB9, "SINHALA LETTER AMBA BAYANNA" },
	{ 0x0DBA, "SINHALA LETTER YAYANNA" },
	{ 0x0DBB, "SINHALA LETTER RAYANNA" },
	{ 0x0DBD, "SINHALA LETTER DANTAJA LAYANNA" },
	{ 0x0DC0, "SINHALA LETTER VAYANNA" },
	{ 0x0DC1, "SINHALA LETTER TAALUJA SAYANNA" },
	{ 0x0DC2, "SINHALA LETTER MUURDHAJA SAYANNA" },
	{ 0x0DC3, "SINHALA LETTER DANTAJA SAYANNA" },
	{ 0x0DC4, "SINHALA LETTER HAYANNA" },
	{ 0x0DC5, "SINHALA LETTER MUURDHAJA LAYANNA" },
	{ 0x0DC6, "SINHALA LETTER FAYANNA" },
	{ 0x0DCA, "SINHALA SIGN AL-LAKUNA" },
	{ 0x0DCF, "SINHALA VOWEL SIGN AELA-PILLA" },
	{ 0x0DD0, "SINHALA VOWEL SIGN KETTI AEDA-PILLA" },
	{ 0x0DD1, "SINHALA VOWEL SIGN DIGA AEDA-PILLA" },
	{ 0x0DD2, "SINHALA VOWEL SIGN KETTI IS-PILLA" },
	{ 0x0DD3, "SINHALA VOWEL SIGN DIGA IS-PILLA" },
	{ 0x0DD4, "SINHALA VOWEL SIGN KETTI PAA-PILLA" },
	{ 0x0DD6, "SINHALA VOWEL SIGN DIGA PAA-PILLA" },
	{ 0x0DD8, "SINHALA VOWEL SIGN GAETTA-PILLA" },
	{ 0x0DD9, "SINHALA VOWEL SIGN KOMBUVA" },
	{ 0x0DDA, "SINHALA VOWEL SIGN DIGA KOMBUVA" },
	{ 0x0DDB, "SINHALA VOWEL SIGN KOMBU DEKA" },
	{ 0x0DDC, "SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA" },
	{ 0x0DDD, "SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA" },
	{ 0x0DDE, "SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA" },
	{ 0x0DDF, "SINHALA VOWEL SIGN GAYANUKITTA" },
	{ 0x0DF2, "SINHALA VOWEL SIGN DIGA GAETTA-PILLA" },
	{ 0x0DF3, "SINHALA VOWEL SIGN DIGA GAYANUKITTA" },
	{ 0x0DF4, "SINHALA PUNCTUATION KUNDDALIYA" },
	{ 0x0E01, "THAI CHARACTER KO KAI" },
	{ 0x0E02, "THAI CHARACTER KHO KHAI" },
	{ 0x0E03, "THAI CHARACTER KHO KHUAT" },
	{ 0x0E04, "THAI CHARACTER KHO KHWAI" },
	{ 0x0E05, "THAI CHARACTER KHO KHON" },
	{ 0x0E06, "THAI CHARACTER KHO RAKHANG" },
	{ 0x0E07, "THAI CHARACTER NGO NGU" },
	{ 0x0E08, "THAI CHARACTER CHO CHAN" },
	{ 0x0E09, "THAI CHARACTER CHO CHING" },
	{ 0x0E0A, "THAI CHARACTER CHO CHANG" },
	{ 0x0E0B, "THAI CHARACTER SO SO" },
	{ 0x0E0C, "THAI CHARACTER CHO CHOE" },
	{ 0x0E0D, "THAI CHARACTER YO YING" },
	{ 0x0E0E, "THAI CHARACTER DO CHADA" },
	{ 0x0E0F, "THAI CHARACTER TO PATAK" },
	{ 0x0E10, "THAI CHARACTER THO THAN" },
	{ 0x0E11, "THAI CHARACTER THO NANGMONTHO" },
	{ 0x0E12, "THAI CHARACTER THO PHUTHAO" },
	{ 0x0E13, "THAI CHARACTER NO NEN" },
	{ 0x0E14, "THAI CHARACTER DO DEK" },
	{ 0x0E15, "THAI CHARACTER TO TAO" },
	{ 0x0E16, "THAI CHARACTER THO THUNG" },
	{ 0x0E17, "THAI CHARACTER THO THAHAN" },
	{ 0x0E18, "THAI CHARACTER THO THONG" },
	{ 0x0E19, "THAI CHARACTER NO NU" },
	{ 0x0E1A, "THAI CHARACTER BO BAIMAI" },
	{ 0x0E1B, "THAI CHARACTER PO PLA" },
	{ 0x0E1C, "THAI CHARACTER PHO PHUNG" },
	{ 0x0E1D, "THAI CHARACTER FO FA" },
	{ 0x0E1E, "THAI CHARACTER PHO PHAN" },
	{ 0x0E1F, "THAI CHARACTER FO FAN" },
	{ 0x0E20, "THAI CHARACTER PHO SAMPHAO" },
	{ 0x0E21, "THAI CHARACTER MO MA" },
	{ 0x0E22, "THAI CHARACTER YO YAK" },
	{ 0x0E23, "THAI CHARACTER RO RUA" },
	{ 0x0E24, "THAI CHARACTER RU" },
	{ 0x0E25, "THAI CHARACTER LO LING" },
	{ 0x0E26, "THAI CHARACTER LU" },
	{ 0x0E27, "THAI CHARACTER WO WAEN" },
	{ 0x0E28, "THAI CHARACTER SO SALA" },
	{ 0x0E29, "THAI CHARACTER SO RUSI" },
	{ 0x0E2A, "THAI CHARACTER SO SUA" },
	{ 0x0E2B, "THAI CHARACTER HO HIP" },
	{ 0x0E2C, "THAI CHARACTER LO CHULA" },
	{ 0x0E2D, "THAI CHARACTER O ANG" },
	{ 0x0E2E, "THAI CHARACTER HO NOKHUK" },
	{ 0x0E2F, "THAI CHARACTER PAIYANNOI" },	/* paiyan noi */
	{ 0x0E30, "THAI CHARACTER SARA A" },
	{ 0x0E31, "THAI CHARACTER MAI HAN-AKAT" },
	{ 0x0E32, "THAI CHARACTER SARA AA" },
	{ 0x0E33, "THAI CHARACTER SARA AM" },
	{ 0x0E34, "THAI CHARACTER SARA I" },
	{ 0x0E35, "THAI CHARACTER SARA II" },
	{ 0x0E36, "THAI CHARACTER SARA UE" },
	{ 0x0E37, "THAI CHARACTER SARA UEE" },	/* sara uue */
	{ 0x0E38, "THAI CHARACTER SARA U" },
	{ 0x0E39, "THAI CHARACTER SARA UU" },
	{ 0x0E3A, "THAI CHARACTER PHINTHU" },
	{ 0x0E3F, "THAI CURRENCY SYMBOL BAHT" },
	{ 0x0E40, "THAI CHARACTER SARA E" },
	{ 0x0E41, "THAI CHARACTER SARA AE" },
	{ 0x0E42, "THAI CHARACTER SARA O" },
	{ 0x0E43, "THAI CHARACTER SARA AI MAIMUAN" },	/* sara ai mai muan */
	{ 0x0E44, "THAI CHARACTER SARA AI MAIMALAI" },	/* sara ai mai malai */
	{ 0x0E45, "THAI CHARACTER LAKKHANGYAO" },	/* lakkhang yao */
	{ 0x0E46, "THAI CHARACTER MAIYAMOK" },	/* mai yamok */
	{ 0x0E47, "THAI CHARACTER MAITAIKHU" },	/* mai taikhu */
	{ 0x0E48, "THAI CHARACTER MAI EK" },
	{ 0x0E49, "THAI CHARACTER MAI THO" },
	{ 0x0E4A, "THAI CHARACTER MAI TRI" },
	{ 0x0E4B, "THAI CHARACTER MAI CHATTAWA" },
	{ 0x0E4C, "THAI CHARACTER THANTHAKHAT" },
	{ 0x0E4D, "THAI CHARACTER NIKHAHIT" },	/* nikkhahit */
	{ 0x0E4E, "THAI CHARACTER YAMAKKAN" },
	{ 0x0E4F, "THAI CHARACTER FONGMAN" },
	{ 0x0E50, "THAI DIGIT ZERO" },
	{ 0x0E51, "THAI DIGIT ONE" },
	{ 0x0E52, "THAI DIGIT TWO" },
	{ 0x0E53, "THAI DIGIT THREE" },
	{ 0x0E54, "THAI DIGIT FOUR" },
	{ 0x0E55, "THAI DIGIT FIVE" },
	{ 0x0E56, "THAI DIGIT SIX" },
	{ 0x0E57, "THAI DIGIT SEVEN" },
	{ 0x0E58, "THAI DIGIT EIGHT" },
	{ 0x0E59, "THAI DIGIT NINE" },
	{ 0x0E5A, "THAI CHARACTER ANGKHANKHU" },
	{ 0x0E5B, "THAI CHARACTER KHOMUT" },
	{ 0x0E81, "LAO LETTER KO" },
	{ 0x0E82, "LAO LETTER KHO SUNG" },
	{ 0x0E84, "LAO LETTER KHO TAM" },
	{ 0x0E87, "LAO LETTER NGO" },
	{ 0x0E88, "LAO LETTER CO" },
	{ 0x0E8A, "LAO LETTER SO TAM" },
	{ 0x0E8D, "LAO LETTER NYO" },
	{ 0x0E94, "LAO LETTER DO" },
	{ 0x0E95, "LAO LETTER TO" },
	{ 0x0E96, "LAO LETTER THO SUNG" },
	{ 0x0E97, "LAO LETTER THO TAM" },
	{ 0x0E99, "LAO LETTER NO" },
	{ 0x0E9A, "LAO LETTER BO" },
	{ 0x0E9B, "LAO LETTER PO" },
	{ 0x0E9C, "LAO LETTER PHO SUNG" },
	{ 0x0E9D, "LAO LETTER FO TAM" },
	{ 0x0E9E, "LAO LETTER PHO TAM" },
	{ 0x0E9F, "LAO LETTER FO SUNG" },
	{ 0x0EA1, "LAO LETTER MO" },
	{ 0x0EA2, "LAO LETTER YO" },
	{ 0x0EA3, "LAO LETTER LO LING" },
	{ 0x0EA5, "LAO LETTER LO LOOT" },
	{ 0x0EA7, "LAO LETTER WO" },
	{ 0x0EAA, "LAO LETTER SO SUNG" },
	{ 0x0EAB, "LAO LETTER HO SUNG" },
	{ 0x0EAD, "LAO LETTER O" },
	{ 0x0EAE, "LAO LETTER HO TAM" },
	{ 0x0EAF, "LAO ELLIPSIS" },
	{ 0x0EB0, "LAO VOWEL SIGN A" },
	{ 0x0EB1, "LAO VOWEL SIGN MAI KAN" },
	{ 0x0EB2, "LAO VOWEL SIGN AA" },
	{ 0x0EB3, "LAO VOWEL SIGN AM" },
	{ 0x0EB4, "LAO VOWEL SIGN I" },
	{ 0x0EB5, "LAO VOWEL SIGN II" },
	{ 0x0EB6, "LAO VOWEL SIGN Y" },
	{ 0x0EB7, "LAO VOWEL SIGN YY" },
	{ 0x0EB8, "LAO VOWEL SIGN U" },
	{ 0x0EB9, "LAO VOWEL SIGN UU" },
	{ 0x0EBB, "LAO VOWEL SIGN MAI KON" },
	{ 0x0EBC, "LAO SEMIVOWEL SIGN LO" },
	{ 0x0EBD, "LAO SEMIVOWEL SIGN NYO" },
	{ 0x0EC0, "LAO VOWEL SIGN E" },
	{ 0x0EC1, "LAO VOWEL SIGN EI" },
	{ 0x0EC2, "LAO VOWEL SIGN O" },
	{ 0x0EC3, "LAO VOWEL SIGN AY" },
	{ 0x0EC4, "LAO VOWEL SIGN AI" },
	{ 0x0EC6, "LAO KO LA" },
	{ 0x0EC8, "LAO TONE MAI EK" },
	{ 0x0EC9, "LAO TONE MAI THO" },
	{ 0x0ECA, "LAO TONE MAI TI" },
	{ 0x0ECB, "LAO TONE MAI CATAWA" },
	{ 0x0ECC, "LAO CANCELLATION MARK" },
	{ 0x0ECD, "LAO NIGGAHITA" },
	{ 0x0ED0, "LAO DIGIT ZERO" },
	{ 0x0ED1, "LAO DIGIT ONE" },
	{ 0x0ED2, "LAO DIGIT TWO" },
	{ 0x0ED3, "LAO DIGIT THREE" },
	{ 0x0ED4, "LAO DIGIT FOUR" },
	{ 0x0ED5, "LAO DIGIT FIVE" },
	{ 0x0ED6, "LAO DIGIT SIX" },
	{ 0x0ED7, "LAO DIGIT SEVEN" },
	{ 0x0ED8, "LAO DIGIT EIGHT" },
	{ 0x0ED9, "LAO DIGIT NINE" },
	{ 0x0EDC, "LAO HO NO" },
	{ 0x0EDD, "LAO HO MO" },
	{ 0x0F00, "TIBETAN SYLLABLE OM" },
	{ 0x0F01, "TIBETAN MARK GTER YIG MGO TRUNCATED A" },	/* ter yik go a thung */
	{ 0x0F02, "TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA" },	/* ter yik go wum nam chey ma */
	{ 0x0F03, "TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA" },	/* ter yik go wum ter tsek ma */
	{ 0x0F04, "TIBETAN MARK INITIAL YIG MGO MDUN MA" },	/* yik go dun ma */
	{ 0x0F05, "TIBETAN MARK CLOSING YIG MGO SGAB MA" },	/* yik go kab ma */
	{ 0x0F06, "TIBETAN MARK CARET YIG MGO PHUR SHAD MA" },	/* yik go pur shey ma */
	{ 0x0F07, "TIBETAN MARK YIG MGO TSHEG SHAD MA" },	/* yik go tsek shey ma */
	{ 0x0F08, "TIBETAN MARK SBRUL SHAD" },	/* drul shey */
	{ 0x0F09, "TIBETAN MARK BSKUR YIG MGO" },	/* kur yik go */
	{ 0x0F0A, "TIBETAN MARK BKA- SHOG YIG MGO" },	/* ka sho yik go */
	{ 0x0F0B, "TIBETAN MARK INTERSYLLABIC TSHEG" },	/* tsek */
	{ 0x0F0C, "TIBETAN MARK DELIMITER TSHEG BSTAR" },	/* tsek tar */
	{ 0x0F0D, "TIBETAN MARK SHAD" },	/* shey */
	{ 0x0F0E, "TIBETAN MARK NYIS SHAD" },	/* nyi shey */
	{ 0x0F0F, "TIBETAN MARK TSHEG SHAD" },	/* tsek shey */
	{ 0x0F10, "TIBETAN MARK NYIS TSHEG SHAD" },	/* nyi tsek shey */
	{ 0x0F11, "TIBETAN MARK RIN CHEN SPUNGS SHAD" },	/* rinchen pung shey */
	{ 0x0F12, "TIBETAN MARK RGYA GRAM SHAD" },	/* gya tram shey */
	{ 0x0F13, "TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN" },	/* dzu ta me long chen */
	{ 0x0F14, "TIBETAN MARK GTER TSHEG" },	/* ter tsek */
	{ 0x0F15, "TIBETAN LOGOTYPE SIGN CHAD RTAGS" },	/* che ta */
	{ 0x0F16, "TIBETAN LOGOTYPE SIGN LHAG RTAGS" },	/* hlak ta */
	{ 0x0F17, "TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS" },	/* trachen char ta */
	{ 0x0F18, "TIBETAN ASTROLOGICAL SIGN -KHYUD PA" },	/* kyu pa */
	{ 0x0F19, "TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS" },	/* dong tsu */
	{ 0x0F1A, "TIBETAN SIGN RDEL DKAR GCIG" },	/* deka chig */
	{ 0x0F1B, "TIBETAN SIGN RDEL DKAR GNYIS" },	/* deka nyi */
	{ 0x0F1C, "TIBETAN SIGN RDEL DKAR GSUM" },	/* deka sum */
	{ 0x0F1D, "TIBETAN SIGN RDEL NAG GCIG" },	/* dena chig */
	{ 0x0F1E, "TIBETAN SIGN RDEL NAG GNYIS" },	/* dena nyi */
	{ 0x0F1F, "TIBETAN SIGN RDEL DKAR RDEL NAG" },	/* deka dena */
	{ 0x0F20, "TIBETAN DIGIT ZERO" },
	{ 0x0F21, "TIBETAN DIGIT ONE" },
	{ 0x0F22, "TIBETAN DIGIT TWO" },
	{ 0x0F23, "TIBETAN DIGIT THREE" },
	{ 0x0F24, "TIBETAN DIGIT FOUR" },
	{ 0x0F25, "TIBETAN DIGIT FIVE" },
	{ 0x0F26, "TIBETAN DIGIT SIX" },
	{ 0x0F27, "TIBETAN DIGIT SEVEN" },
	{ 0x0F28, "TIBETAN DIGIT EIGHT" },
	{ 0x0F29, "TIBETAN DIGIT NINE" },
	{ 0x0F2A, "TIBETAN DIGIT HALF ONE" },
	{ 0x0F2B, "TIBETAN DIGIT HALF TWO" },
	{ 0x0F2C, "TIBETAN DIGIT HALF THREE" },
	{ 0x0F2D, "TIBETAN DIGIT HALF FOUR" },
	{ 0x0F2E, "TIBETAN DIGIT HALF FIVE" },
	{ 0x0F2F, "TIBETAN DIGIT HALF SIX" },
	{ 0x0F30, "TIBETAN DIGIT HALF SEVEN" },
	{ 0x0F31, "TIBETAN DIGIT HALF EIGHT" },
	{ 0x0F32, "TIBETAN DIGIT HALF NINE" },
	{ 0x0F33, "TIBETAN DIGIT HALF ZERO" },
	{ 0x0F34, "TIBETAN MARK BSDUS RTAGS" },	/* du ta */
	{ 0x0F35, "TIBETAN MARK NGAS BZUNG NYI ZLA" },	/* nge zung nyi da */
	{ 0x0F36, "TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN" },	/* dzu ta shi mig chen */
	{ 0x0F37, "TIBETAN MARK NGAS BZUNG SGOR RTAGS" },	/* nge zung gor ta */
	{ 0x0F38, "TIBETAN MARK CHE MGO" },	/* che go */
	{ 0x0F39, "TIBETAN MARK TSA -PHRU" },	/* tsa tru */
	{ 0x0F3A, "TIBETAN MARK GUG RTAGS GYON" },	/* gug ta yun */
	{ 0x0F3B, "TIBETAN MARK GUG RTAGS GYAS" },	/* gug ta ye */
	{ 0x0F3C, "TIBETAN MARK ANG KHANG GYON" },	/* ang kang yun */
	{ 0x0F3D, "TIBETAN MARK ANG KHANG GYAS" },	/* ang kang ye */
	{ 0x0F3E, "TIBETAN SIGN YAR TSHES" },	/* yar tse */
	{ 0x0F3F, "TIBETAN SIGN MAR TSHES" },	/* mar tse */
	{ 0x0F40, "TIBETAN LETTER KA" },
	{ 0x0F41, "TIBETAN LETTER KHA" },
	{ 0x0F42, "TIBETAN LETTER GA" },
	{ 0x0F43, "TIBETAN LETTER GHA" },
	{ 0x0F44, "TIBETAN LETTER NGA" },
	{ 0x0F45, "TIBETAN LETTER CA" },
	{ 0x0F46, "TIBETAN LETTER CHA" },
	{ 0x0F47, "TIBETAN LETTER JA" },
	{ 0x0F49, "TIBETAN LETTER NYA" },
	{ 0x0F4A, "TIBETAN LETTER TTA" },
	{ 0x0F4B, "TIBETAN LETTER TTHA" },
	{ 0x0F4C, "TIBETAN LETTER DDA" },
	{ 0x0F4D, "TIBETAN LETTER DDHA" },
	{ 0x0F4E, "TIBETAN LETTER NNA" },
	{ 0x0F4F, "TIBETAN LETTER TA" },
	{ 0x0F50, "TIBETAN LETTER THA" },
	{ 0x0F51, "TIBETAN LETTER DA" },
	{ 0x0F52, "TIBETAN LETTER DHA" },
	{ 0x0F53, "TIBETAN LETTER NA" },
	{ 0x0F54, "TIBETAN LETTER PA" },
	{ 0x0F55, "TIBETAN LETTER PHA" },
	{ 0x0F56, "TIBETAN LETTER BA" },
	{ 0x0F57, "TIBETAN LETTER BHA" },
	{ 0x0F58, "TIBETAN LETTER MA" },
	{ 0x0F59, "TIBETAN LETTER TSA" },
	{ 0x0F5A, "TIBETAN LETTER TSHA" },
	{ 0x0F5B, "TIBETAN LETTER DZA" },
	{ 0x0F5C, "TIBETAN LETTER DZHA" },
	{ 0x0F5D, "TIBETAN LETTER WA" },
	{ 0x0F5E, "TIBETAN LETTER ZHA" },
	{ 0x0F5F, "TIBETAN LETTER ZA" },
	{ 0x0F60, "TIBETAN LETTER -A" },
	{ 0x0F61, "TIBETAN LETTER YA" },
	{ 0x0F62, "TIBETAN LETTER RA" },	/* * */
	{ 0x0F63, "TIBETAN LETTER LA" },
	{ 0x0F64, "TIBETAN LETTER SHA" },
	{ 0x0F65, "TIBETAN LETTER SSA" },
	{ 0x0F66, "TIBETAN LETTER SA" },
	{ 0x0F67, "TIBETAN LETTER HA" },
	{ 0x0F68, "TIBETAN LETTER A" },
	{ 0x0F69, "TIBETAN LETTER KSSA" },
	{ 0x0F6A, "TIBETAN LETTER FIXED-FORM RA" },	/* * */
	{ 0x0F71, "TIBETAN VOWEL SIGN AA" },
	{ 0x0F72, "TIBETAN VOWEL SIGN I" },
	{ 0x0F73, "TIBETAN VOWEL SIGN II" },
	{ 0x0F74, "TIBETAN VOWEL SIGN U" },
	{ 0x0F75, "TIBETAN VOWEL SIGN UU" },
	{ 0x0F76, "TIBETAN VOWEL SIGN VOCALIC R" },
	{ 0x0F77, "TIBETAN VOWEL SIGN VOCALIC RR" },
	{ 0x0F78, "TIBETAN VOWEL SIGN VOCALIC L" },
	{ 0x0F79, "TIBETAN VOWEL SIGN VOCALIC LL" },
	{ 0x0F7A, "TIBETAN VOWEL SIGN E" },
	{ 0x0F7B, "TIBETAN VOWEL SIGN EE" },
	{ 0x0F7C, "TIBETAN VOWEL SIGN O" },
	{ 0x0F7D, "TIBETAN VOWEL SIGN OO" },
	{ 0x0F7E, "TIBETAN SIGN RJES SU NGA RO" },	/* je su nga ro */
	{ 0x0F7F, "TIBETAN SIGN RNAM BCAD" },	/* nam chey */
	{ 0x0F80, "TIBETAN VOWEL SIGN REVERSED I" },
	{ 0x0F81, "TIBETAN VOWEL SIGN REVERSED II" },
	{ 0x0F82, "TIBETAN SIGN NYI ZLA NAA DA" },	/* nyi da na da */
	{ 0x0F83, "TIBETAN SIGN SNA LDAN" },	/* nan de */
	{ 0x0F84, "TIBETAN MARK HALANTA" },
	{ 0x0F85, "TIBETAN MARK PALUTA" },
	{ 0x0F86, "TIBETAN SIGN LCI RTAGS" },	/* ji ta */
	{ 0x0F87, "TIBETAN SIGN YANG RTAGS" },	/* yang ta */
	{ 0x0F88, "TIBETAN SIGN LCE TSA CAN" },	/* che tsa chen */
	{ 0x0F89, "TIBETAN SIGN MCHU CAN" },	/* chu chen */
	{ 0x0F8A, "TIBETAN SIGN GRU CAN RGYINGS" },	/* tru chen ging */
	{ 0x0F8B, "TIBETAN SIGN GRU MED RGYINGS" },	/* tru me ging */
	{ 0x0F90, "TIBETAN SUBJOINED LETTER KA" },
	{ 0x0F91, "TIBETAN SUBJOINED LETTER KHA" },
	{ 0x0F92, "TIBETAN SUBJOINED LETTER GA" },
	{ 0x0F93, "TIBETAN SUBJOINED LETTER GHA" },
	{ 0x0F94, "TIBETAN SUBJOINED LETTER NGA" },
	{ 0x0F95, "TIBETAN SUBJOINED LETTER CA" },
	{ 0x0F96, "TIBETAN SUBJOINED LETTER CHA" },
	{ 0x0F97, "TIBETAN SUBJOINED LETTER JA" },
	{ 0x0F99, "TIBETAN SUBJOINED LETTER NYA" },
	{ 0x0F9A, "TIBETAN SUBJOINED LETTER TTA" },
	{ 0x0F9B, "TIBETAN SUBJOINED LETTER TTHA" },
	{ 0x0F9C, "TIBETAN SUBJOINED LETTER DDA" },
	{ 0x0F9D, "TIBETAN SUBJOINED LETTER DDHA" },
	{ 0x0F9E, "TIBETAN SUBJOINED LETTER NNA" },
	{ 0x0F9F, "TIBETAN SUBJOINED LETTER TA" },
	{ 0x0FA0, "TIBETAN SUBJOINED LETTER THA" },
	{ 0x0FA1, "TIBETAN SUBJOINED LETTER DA" },
	{ 0x0FA2, "TIBETAN SUBJOINED LETTER DHA" },
	{ 0x0FA3, "TIBETAN SUBJOINED LETTER NA" },
	{ 0x0FA4, "TIBETAN SUBJOINED LETTER PA" },
	{ 0x0FA5, "TIBETAN SUBJOINED LETTER PHA" },
	{ 0x0FA6, "TIBETAN SUBJOINED LETTER BA" },
	{ 0x0FA7, "TIBETAN SUBJOINED LETTER BHA" },
	{ 0x0FA8, "TIBETAN SUBJOINED LETTER MA" },
	{ 0x0FA9, "TIBETAN SUBJOINED LETTER TSA" },
	{ 0x0FAA, "TIBETAN SUBJOINED LETTER TSHA" },
	{ 0x0FAB, "TIBETAN SUBJOINED LETTER DZA" },
	{ 0x0FAC, "TIBETAN SUBJOINED LETTER DZHA" },
	{ 0x0FAD, "TIBETAN SUBJOINED LETTER WA" },	/* * */
	{ 0x0FAE, "TIBETAN SUBJOINED LETTER ZHA" },
	{ 0x0FAF, "TIBETAN SUBJOINED LETTER ZA" },
	{ 0x0FB0, "TIBETAN SUBJOINED LETTER -A" },
	{ 0x0FB1, "TIBETAN SUBJOINED LETTER YA" },	/* * */
	{ 0x0FB2, "TIBETAN SUBJOINED LETTER RA" },	/* * */
	{ 0x0FB3, "TIBETAN SUBJOINED LETTER LA" },
	{ 0x0FB4, "TIBETAN SUBJOINED LETTER SHA" },
	{ 0x0FB5, "TIBETAN SUBJOINED LETTER SSA" },
	{ 0x0FB6, "TIBETAN SUBJOINED LETTER SA" },
	{ 0x0FB7, "TIBETAN SUBJOINED LETTER HA" },
	{ 0x0FB8, "TIBETAN SUBJOINED LETTER A" },
	{ 0x0FB9, "TIBETAN SUBJOINED LETTER KSSA" },
	{ 0x0FBA, "TIBETAN SUBJOINED LETTER FIXED-FORM WA" },	/* * */
	{ 0x0FBB, "TIBETAN SUBJOINED LETTER FIXED-FORM YA" },	/* * */
	{ 0x0FBC, "TIBETAN SUBJOINED LETTER FIXED-FORM RA" },	/* * */
	{ 0x0FBE, "TIBETAN KU RU KHA" },	/* kuruka */
	{ 0x0FBF, "TIBETAN KU RU KHA BZHI MIG CAN" },	/* kuruka shi mik chen */
	{ 0x0FC0, "TIBETAN CANTILLATION SIGN HEAVY BEAT" },
	{ 0x0FC1, "TIBETAN CANTILLATION SIGN LIGHT BEAT" },
	{ 0x0FC2, "TIBETAN CANTILLATION SIGN CANG TE-U" },	/* chang tyu */
	{ 0x0FC3, "TIBETAN CANTILLATION SIGN SBUB -CHAL" },	/* bub chey */
	{ 0x0FC4, "TIBETAN SYMBOL DRIL BU" },	/* drilbu */
	{ 0x0FC5, "TIBETAN SYMBOL RDO RJE" },	/* dorje */
	{ 0x0FC6, "TIBETAN SYMBOL PADMA GDAN" },	/* pema den */
	{ 0x0FC7, "TIBETAN SYMBOL RDO RJE RGYA GRAM" },	/* dorje gya dram */
	{ 0x0FC8, "TIBETAN SYMBOL PHUR PA" },	/* phurba */
	{ 0x0FC9, "TIBETAN SYMBOL NOR BU" },	/* norbu */
	{ 0x0FCA, "TIBETAN SYMBOL NOR BU NYIS -KHYIL" },	/* norbu nyi khyi */
	{ 0x0FCB, "TIBETAN SYMBOL NOR BU GSUM -KHYIL" },	/* norbu sum khyi */
	{ 0x0FCC, "TIBETAN SYMBOL NOR BU BZHI -KHYIL" },	/* norbu shi khyi */
	{ 0x0FCF, "TIBETAN SIGN RDEL NAG GSUM" },	/* dena sum */
	{ 0x1000, "MYANMAR LETTER KA" },
	{ 0x1001, "MYANMAR LETTER KHA" },
	{ 0x1002, "MYANMAR LETTER GA" },
	{ 0x1003, "MYANMAR LETTER GHA" },
	{ 0x1004, "MYANMAR LETTER NGA" },
	{ 0x1005, "MYANMAR LETTER CA" },
	{ 0x1006, "MYANMAR LETTER CHA" },
	{ 0x1007, "MYANMAR LETTER JA" },
	{ 0x1008, "MYANMAR LETTER JHA" },
	{ 0x1009, "MYANMAR LETTER NYA" },
	{ 0x100A, "MYANMAR LETTER NNYA" },
	{ 0x100B, "MYANMAR LETTER TTA" },
	{ 0x100C, "MYANMAR LETTER TTHA" },
	{ 0x100D, "MYANMAR LETTER DDA" },
	{ 0x100E, "MYANMAR LETTER DDHA" },
	{ 0x100F, "MYANMAR LETTER NNA" },
	{ 0x1010, "MYANMAR LETTER TA" },
	{ 0x1011, "MYANMAR LETTER THA" },
	{ 0x1012, "MYANMAR LETTER DA" },
	{ 0x1013, "MYANMAR LETTER DHA" },
	{ 0x1014, "MYANMAR LETTER NA" },
	{ 0x1015, "MYANMAR LETTER PA" },
	{ 0x1016, "MYANMAR LETTER PHA" },
	{ 0x1017, "MYANMAR LETTER BA" },
	{ 0x1018, "MYANMAR LETTER BHA" },
	{ 0x1019, "MYANMAR LETTER MA" },
	{ 0x101A, "MYANMAR LETTER YA" },
	{ 0x101B, "MYANMAR LETTER RA" },
	{ 0x101C, "MYANMAR LETTER LA" },
	{ 0x101D, "MYANMAR LETTER WA" },
	{ 0x101E, "MYANMAR LETTER SA" },
	{ 0x101F, "MYANMAR LETTER HA" },
	{ 0x1020, "MYANMAR LETTER LLA" },
	{ 0x1021, "MYANMAR LETTER A" },
	{ 0x1023, "MYANMAR LETTER I" },
	{ 0x1024, "MYANMAR LETTER II" },
	{ 0x1025, "MYANMAR LETTER U" },
	{ 0x1026, "MYANMAR LETTER UU" },
	{ 0x1027, "MYANMAR LETTER E" },
	{ 0x1029, "MYANMAR LETTER O" },
	{ 0x102A, "MYANMAR LETTER AU" },
	{ 0x102C, "MYANMAR VOWEL SIGN AA" },
	{ 0x102D, "MYANMAR VOWEL SIGN I" },
	{ 0x102E, "MYANMAR VOWEL SIGN II" },
	{ 0x102F, "MYANMAR VOWEL SIGN U" },
	{ 0x1030, "MYANMAR VOWEL SIGN UU" },
	{ 0x1031, "MYANMAR VOWEL SIGN E" },
	{ 0x1032, "MYANMAR VOWEL SIGN AI" },
	{ 0x1036, "MYANMAR SIGN ANUSVARA" },
	{ 0x1037, "MYANMAR SIGN DOT BELOW" },
	{ 0x1038, "MYANMAR SIGN VISARGA" },
	{ 0x1039, "MYANMAR SIGN VIRAMA" },
	{ 0x1040, "MYANMAR DIGIT ZERO" },
	{ 0x1041, "MYANMAR DIGIT ONE" },
	{ 0x1042, "MYANMAR DIGIT TWO" },
	{ 0x1043, "MYANMAR DIGIT THREE" },
	{ 0x1044, "MYANMAR DIGIT FOUR" },
	{ 0x1045, "MYANMAR DIGIT FIVE" },
	{ 0x1046, "MYANMAR DIGIT SIX" },
	{ 0x1047, "MYANMAR DIGIT SEVEN" },
	{ 0x1048, "MYANMAR DIGIT EIGHT" },
	{ 0x1049, "MYANMAR DIGIT NINE" },
	{ 0x104A, "MYANMAR SIGN LITTLE SECTION" },
	{ 0x104B, "MYANMAR SIGN SECTION" },
	{ 0x104C, "MYANMAR SYMBOL LOCATIVE" },
	{ 0x104D, "MYANMAR SYMBOL COMPLETED" },
	{ 0x104E, "MYANMAR SYMBOL AFOREMENTIONED" },
	{ 0x104F, "MYANMAR SYMBOL GENITIVE" },
	{ 0x1050, "MYANMAR LETTER SHA" },
	{ 0x1051, "MYANMAR LETTER SSA" },
	{ 0x1052, "MYANMAR LETTER VOCALIC R" },
	{ 0x1053, "MYANMAR LETTER VOCALIC RR" },
	{ 0x1054, "MYANMAR LETTER VOCALIC L" },
	{ 0x1055, "MYANMAR LETTER VOCALIC LL" },
	{ 0x1056, "MYANMAR VOWEL SIGN VOCALIC R" },
	{ 0x1057, "MYANMAR VOWEL SIGN VOCALIC RR" },
	{ 0x1058, "MYANMAR VOWEL SIGN VOCALIC L" },
	{ 0x1059, "MYANMAR VOWEL SIGN VOCALIC LL" },
	{ 0x10A0, "GEORGIAN CAPITAL LETTER AN" },	/* Khutsuri */
	{ 0x10A1, "GEORGIAN CAPITAL LETTER BAN" },	/* Khutsuri */
	{ 0x10A2, "GEORGIAN CAPITAL LETTER GAN" },	/* Khutsuri */
	{ 0x10A3, "GEORGIAN CAPITAL LETTER DON" },	/* Khutsuri */
	{ 0x10A4, "GEORGIAN CAPITAL LETTER EN" },	/* Khutsuri */
	{ 0x10A5, "GEORGIAN CAPITAL LETTER VIN" },	/* Khutsuri */
	{ 0x10A6, "GEORGIAN CAPITAL LETTER ZEN" },	/* Khutsuri */
	{ 0x10A7, "GEORGIAN CAPITAL LETTER TAN" },	/* Khutsuri */
	{ 0x10A8, "GEORGIAN CAPITAL LETTER IN" },	/* Khutsuri */
	{ 0x10A9, "GEORGIAN CAPITAL LETTER KAN" },	/* Khutsuri */
	{ 0x10AA, "GEORGIAN CAPITAL LETTER LAS" },	/* Khutsuri */
	{ 0x10AB, "GEORGIAN CAPITAL LETTER MAN" },	/* Khutsuri */
	{ 0x10AC, "GEORGIAN CAPITAL LETTER NAR" },	/* Khutsuri */
	{ 0x10AD, "GEORGIAN CAPITAL LETTER ON" },	/* Khutsuri */
	{ 0x10AE, "GEORGIAN CAPITAL LETTER PAR" },	/* Khutsuri */
	{ 0x10AF, "GEORGIAN CAPITAL LETTER ZHAR" },	/* Khutsuri */
	{ 0x10B0, "GEORGIAN CAPITAL LETTER RAE" },	/* Khutsuri */
	{ 0x10B1, "GEORGIAN CAPITAL LETTER SAN" },	/* Khutsuri */
	{ 0x10B2, "GEORGIAN CAPITAL LETTER TAR" },	/* Khutsuri */
	{ 0x10B3, "GEORGIAN CAPITAL LETTER UN" },	/* Khutsuri */
	{ 0x10B4, "GEORGIAN CAPITAL LETTER PHAR" },	/* Khutsuri */
	{ 0x10B5, "GEORGIAN CAPITAL LETTER KHAR" },	/* Khutsuri */
	{ 0x10B6, "GEORGIAN CAPITAL LETTER GHAN" },	/* Khutsuri */
	{ 0x10B7, "GEORGIAN CAPITAL LETTER QAR" },	/* Khutsuri */
	{ 0x10B8, "GEORGIAN CAPITAL LETTER SHIN" },	/* Khutsuri */
	{ 0x10B9, "GEORGIAN CAPITAL LETTER CHIN" },	/* Khutsuri */
	{ 0x10BA, "GEORGIAN CAPITAL LETTER CAN" },	/* Khutsuri */
	{ 0x10BB, "GEORGIAN CAPITAL LETTER JIL" },	/* Khutsuri */
	{ 0x10BC, "GEORGIAN CAPITAL LETTER CIL" },	/* Khutsuri */
	{ 0x10BD, "GEORGIAN CAPITAL LETTER CHAR" },	/* Khutsuri */
	{ 0x10BE, "GEORGIAN CAPITAL LETTER XAN" },	/* Khutsuri */
	{ 0x10BF, "GEORGIAN CAPITAL LETTER JHAN" },	/* Khutsuri */
	{ 0x10C0, "GEORGIAN CAPITAL LETTER HAE" },	/* Khutsuri */
	{ 0x10C1, "GEORGIAN CAPITAL LETTER HE" },	/* Khutsuri */
	{ 0x10C2, "GEORGIAN CAPITAL LETTER HIE" },	/* Khutsuri */
	{ 0x10C3, "GEORGIAN CAPITAL LETTER WE" },	/* Khutsuri */
	{ 0x10C4, "GEORGIAN CAPITAL LETTER HAR" },	/* Khutsuri */
	{ 0x10C5, "GEORGIAN CAPITAL LETTER HOE" },	/* Khutsuri */
	{ 0x10D0, "GEORGIAN LETTER AN" },
	{ 0x10D1, "GEORGIAN LETTER BAN" },
	{ 0x10D2, "GEORGIAN LETTER GAN" },
	{ 0x10D3, "GEORGIAN LETTER DON" },
	{ 0x10D4, "GEORGIAN LETTER EN" },
	{ 0x10D5, "GEORGIAN LETTER VIN" },
	{ 0x10D6, "GEORGIAN LETTER ZEN" },
	{ 0x10D7, "GEORGIAN LETTER TAN" },
	{ 0x10D8, "GEORGIAN LETTER IN" },
	{ 0x10D9, "GEORGIAN LETTER KAN" },
	{ 0x10DA, "GEORGIAN LETTER LAS" },
	{ 0x10DB, "GEORGIAN LETTER MAN" },
	{ 0x10DC, "GEORGIAN LETTER NAR" },
	{ 0x10DD, "GEORGIAN LETTER ON" },
	{ 0x10DE, "GEORGIAN LETTER PAR" },
	{ 0x10DF, "GEORGIAN LETTER ZHAR" },
	{ 0x10E0, "GEORGIAN LETTER RAE" },
	{ 0x10E1, "GEORGIAN LETTER SAN" },
	{ 0x10E2, "GEORGIAN LETTER TAR" },
	{ 0x10E3, "GEORGIAN LETTER UN" },
	{ 0x10E4, "GEORGIAN LETTER PHAR" },
	{ 0x10E5, "GEORGIAN LETTER KHAR" },
	{ 0x10E6, "GEORGIAN LETTER GHAN" },
	{ 0x10E7, "GEORGIAN LETTER QAR" },
	{ 0x10E8, "GEORGIAN LETTER SHIN" },
	{ 0x10E9, "GEORGIAN LETTER CHIN" },
	{ 0x10EA, "GEORGIAN LETTER CAN" },
	{ 0x10EB, "GEORGIAN LETTER JIL" },
	{ 0x10EC, "GEORGIAN LETTER CIL" },
	{ 0x10ED, "GEORGIAN LETTER CHAR" },
	{ 0x10EE, "GEORGIAN LETTER XAN" },
	{ 0x10EF, "GEORGIAN LETTER JHAN" },
	{ 0x10F0, "GEORGIAN LETTER HAE" },
	{ 0x10F1, "GEORGIAN LETTER HE" },
	{ 0x10F2, "GEORGIAN LETTER HIE" },
	{ 0x10F3, "GEORGIAN LETTER WE" },
	{ 0x10F4, "GEORGIAN LETTER HAR" },
	{ 0x10F5, "GEORGIAN LETTER HOE" },
	{ 0x10F6, "GEORGIAN LETTER FI" },
	{ 0x10FB, "GEORGIAN PARAGRAPH SEPARATOR" },
	{ 0x1100, "HANGUL CHOSEONG KIYEOK" },	/* g * */
	{ 0x1101, "HANGUL CHOSEONG SSANGKIYEOK" },	/* gg * */
	{ 0x1102, "HANGUL CHOSEONG NIEUN" },	/* n * */
	{ 0x1103, "HANGUL CHOSEONG TIKEUT" },	/* d * */
	{ 0x1104, "HANGUL CHOSEONG SSANGTIKEUT" },	/* dd * */
	{ 0x1105, "HANGUL CHOSEONG RIEUL" },	/* r * */
	{ 0x1106, "HANGUL CHOSEONG MIEUM" },	/* m * */
	{ 0x1107, "HANGUL CHOSEONG PIEUP" },	/* b * */
	{ 0x1108, "HANGUL CHOSEONG SSANGPIEUP" },	/* bb * */
	{ 0x1109, "HANGUL CHOSEONG SIOS" },	/* s * */
	{ 0x110A, "HANGUL CHOSEONG SSANGSIOS" },	/* ss * */
	{ 0x110B, "HANGUL CHOSEONG IEUNG" },
	{ 0x110C, "HANGUL CHOSEONG CIEUC" },	/* j * */
	{ 0x110D, "HANGUL CHOSEONG SSANGCIEUC" },	/* jj * */
	{ 0x110E, "HANGUL CHOSEONG CHIEUCH" },	/* c * */
	{ 0x110F, "HANGUL CHOSEONG KHIEUKH" },	/* k * */
	{ 0x1110, "HANGUL CHOSEONG THIEUTH" },	/* t * */
	{ 0x1111, "HANGUL CHOSEONG PHIEUPH" },	/* p * */
	{ 0x1112, "HANGUL CHOSEONG HIEUH" },	/* h * */
	{ 0x1113, "HANGUL CHOSEONG NIEUN-KIYEOK" },
	{ 0x1114, "HANGUL CHOSEONG SSANGNIEUN" },
	{ 0x1115, "HANGUL CHOSEONG NIEUN-TIKEUT" },
	{ 0x1116, "HANGUL CHOSEONG NIEUN-PIEUP" },
	{ 0x1117, "HANGUL CHOSEONG TIKEUT-KIYEOK" },
	{ 0x1118, "HANGUL CHOSEONG RIEUL-NIEUN" },
	{ 0x1119, "HANGUL CHOSEONG SSANGRIEUL" },
	{ 0x111A, "HANGUL CHOSEONG RIEUL-HIEUH" },
	{ 0x111B, "HANGUL CHOSEONG KAPYEOUNRIEUL" },
	{ 0x111C, "HANGUL CHOSEONG MIEUM-PIEUP" },
	{ 0x111D, "HANGUL CHOSEONG KAPYEOUNMIEUM" },
	{ 0x111E, "HANGUL CHOSEONG PIEUP-KIYEOK" },
	{ 0x111F, "HANGUL CHOSEONG PIEUP-NIEUN" },
	{ 0x1120, "HANGUL CHOSEONG PIEUP-TIKEUT" },
	{ 0x1121, "HANGUL CHOSEONG PIEUP-SIOS" },
	{ 0x1122, "HANGUL CHOSEONG PIEUP-SIOS-KIYEOK" },
	{ 0x1123, "HANGUL CHOSEONG PIEUP-SIOS-TIKEUT" },
	{ 0x1124, "HANGUL CHOSEONG PIEUP-SIOS-PIEUP" },
	{ 0x1125, "HANGUL CHOSEONG PIEUP-SSANGSIOS" },
	{ 0x1126, "HANGUL CHOSEONG PIEUP-SIOS-CIEUC" },
	{ 0x1127, "HANGUL CHOSEONG PIEUP-CIEUC" },
	{ 0x1128, "HANGUL CHOSEONG PIEUP-CHIEUCH" },
	{ 0x1129, "HANGUL CHOSEONG PIEUP-THIEUTH" },
	{ 0x112A, "HANGUL CHOSEONG PIEUP-PHIEUPH" },
	{ 0x112B, "HANGUL CHOSEONG KAPYEOUNPIEUP" },
	{ 0x112C, "HANGUL CHOSEONG KAPYEOUNSSANGPIEUP" },
	{ 0x112D, "HANGUL CHOSEONG SIOS-KIYEOK" },
	{ 0x112E, "HANGUL CHOSEONG SIOS-NIEUN" },
	{ 0x112F, "HANGUL CHOSEONG SIOS-TIKEUT" },
	{ 0x1130, "HANGUL CHOSEONG SIOS-RIEUL" },
	{ 0x1131, "HANGUL CHOSEONG SIOS-MIEUM" },
	{ 0x1132, "HANGUL CHOSEONG SIOS-PIEUP" },
	{ 0x1133, "HANGUL CHOSEONG SIOS-PIEUP-KIYEOK" },
	{ 0x1134, "HANGUL CHOSEONG SIOS-SSANGSIOS" },
	{ 0x1135, "HANGUL CHOSEONG SIOS-IEUNG" },
	{ 0x1136, "HANGUL CHOSEONG SIOS-CIEUC" },
	{ 0x1137, "HANGUL CHOSEONG SIOS-CHIEUCH" },
	{ 0x1138, "HANGUL CHOSEONG SIOS-KHIEUKH" },
	{ 0x1139, "HANGUL CHOSEONG SIOS-THIEUTH" },
	{ 0x113A, "HANGUL CHOSEONG SIOS-PHIEUPH" },
	{ 0x113B, "HANGUL CHOSEONG SIOS-HIEUH" },
	{ 0x113C, "HANGUL CHOSEONG CHITUEUMSIOS" },
	{ 0x113D, "HANGUL CHOSEONG CHITUEUMSSANGSIOS" },
	{ 0x113E, "HANGUL CHOSEONG CEONGCHIEUMSIOS" },
	{ 0x113F, "HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS" },
	{ 0x1140, "HANGUL CHOSEONG PANSIOS" },
	{ 0x1141, "HANGUL CHOSEONG IEUNG-KIYEOK" },
	{ 0x1142, "HANGUL CHOSEONG IEUNG-TIKEUT" },
	{ 0x1143, "HANGUL CHOSEONG IEUNG-MIEUM" },
	{ 0x1144, "HANGUL CHOSEONG IEUNG-PIEUP" },
	{ 0x1145, "HANGUL CHOSEONG IEUNG-SIOS" },
	{ 0x1146, "HANGUL CHOSEONG IEUNG-PANSIOS" },
	{ 0x1147, "HANGUL CHOSEONG SSANGIEUNG" },
	{ 0x1148, "HANGUL CHOSEONG IEUNG-CIEUC" },
	{ 0x1149, "HANGUL CHOSEONG IEUNG-CHIEUCH" },
	{ 0x114A, "HANGUL CHOSEONG IEUNG-THIEUTH" },
	{ 0x114B, "HANGUL CHOSEONG IEUNG-PHIEUPH" },
	{ 0x114C, "HANGUL CHOSEONG YESIEUNG" },
	{ 0x114D, "HANGUL CHOSEONG CIEUC-IEUNG" },
	{ 0x114E, "HANGUL CHOSEONG CHITUEUMCIEUC" },
	{ 0x114F, "HANGUL CHOSEONG CHITUEUMSSANGCIEUC" },
	{ 0x1150, "HANGUL CHOSEONG CEONGCHIEUMCIEUC" },
	{ 0x1151, "HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC" },
	{ 0x1152, "HANGUL CHOSEONG CHIEUCH-KHIEUKH" },
	{ 0x1153, "HANGUL CHOSEONG CHIEUCH-HIEUH" },
	{ 0x1154, "HANGUL CHOSEONG CHITUEUMCHIEUCH" },
	{ 0x1155, "HANGUL CHOSEONG CEONGCHIEUMCHIEUCH" },
	{ 0x1156, "HANGUL CHOSEONG PHIEUPH-PIEUP" },
	{ 0x1157, "HANGUL CHOSEONG KAPYEOUNPHIEUPH" },
	{ 0x1158, "HANGUL CHOSEONG SSANGHIEUH" },
	{ 0x1159, "HANGUL CHOSEONG YEORINHIEUH" },
	{ 0x115F, "HANGUL CHOSEONG FILLER" },
	{ 0x1160, "HANGUL JUNGSEONG FILLER" },
	{ 0x1161, "HANGUL JUNGSEONG A" },
	{ 0x1162, "HANGUL JUNGSEONG AE" },
	{ 0x1163, "HANGUL JUNGSEONG YA" },
	{ 0x1164, "HANGUL JUNGSEONG YAE" },
	{ 0x1165, "HANGUL JUNGSEONG EO" },
	{ 0x1166, "HANGUL JUNGSEONG E" },
	{ 0x1167, "HANGUL JUNGSEONG YEO" },
	{ 0x1168, "HANGUL JUNGSEONG YE" },
	{ 0x1169, "HANGUL JUNGSEONG O" },
	{ 0x116A, "HANGUL JUNGSEONG WA" },
	{ 0x116B, "HANGUL JUNGSEONG WAE" },
	{ 0x116C, "HANGUL JUNGSEONG OE" },
	{ 0x116D, "HANGUL JUNGSEONG YO" },
	{ 0x116E, "HANGUL JUNGSEONG U" },
	{ 0x116F, "HANGUL JUNGSEONG WEO" },
	{ 0x1170, "HANGUL JUNGSEONG WE" },
	{ 0x1171, "HANGUL JUNGSEONG WI" },
	{ 0x1172, "HANGUL JUNGSEONG YU" },
	{ 0x1173, "HANGUL JUNGSEONG EU" },
	{ 0x1174, "HANGUL JUNGSEONG YI" },
	{ 0x1175, "HANGUL JUNGSEONG I" },
	{ 0x1176, "HANGUL JUNGSEONG A-O" },
	{ 0x1177, "HANGUL JUNGSEONG A-U" },
	{ 0x1178, "HANGUL JUNGSEONG YA-O" },
	{ 0x1179, "HANGUL JUNGSEONG YA-YO" },
	{ 0x117A, "HANGUL JUNGSEONG EO-O" },
	{ 0x117B, "HANGUL JUNGSEONG EO-U" },
	{ 0x117C, "HANGUL JUNGSEONG EO-EU" },
	{ 0x117D, "HANGUL JUNGSEONG YEO-O" },
	{ 0x117E, "HANGUL JUNGSEONG YEO-U" },
	{ 0x117F, "HANGUL JUNGSEONG O-EO" },
	{ 0x1180, "HANGUL JUNGSEONG O-E" },
	{ 0x1181, "HANGUL JUNGSEONG O-YE" },
	{ 0x1182, "HANGUL JUNGSEONG O-O" },
	{ 0x1183, "HANGUL JUNGSEONG O-U" },
	{ 0x1184, "HANGUL JUNGSEONG YO-YA" },
	{ 0x1185, "HANGUL JUNGSEONG YO-YAE" },
	{ 0x1186, "HANGUL JUNGSEONG YO-YEO" },
	{ 0x1187, "HANGUL JUNGSEONG YO-O" },
	{ 0x1188, "HANGUL JUNGSEONG YO-I" },
	{ 0x1189, "HANGUL JUNGSEONG U-A" },
	{ 0x118A, "HANGUL JUNGSEONG U-AE" },
	{ 0x118B, "HANGUL JUNGSEONG U-EO-EU" },
	{ 0x118C, "HANGUL JUNGSEONG U-YE" },
	{ 0x118D, "HANGUL JUNGSEONG U-U" },
	{ 0x118E, "HANGUL JUNGSEONG YU-A" },
	{ 0x118F, "HANGUL JUNGSEONG YU-EO" },
	{ 0x1190, "HANGUL JUNGSEONG YU-E" },
	{ 0x1191, "HANGUL JUNGSEONG YU-YEO" },
	{ 0x1192, "HANGUL JUNGSEONG YU-YE" },
	{ 0x1193, "HANGUL JUNGSEONG YU-U" },
	{ 0x1194, "HANGUL JUNGSEONG YU-I" },
	{ 0x1195, "HANGUL JUNGSEONG EU-U" },
	{ 0x1196, "HANGUL JUNGSEONG EU-EU" },
	{ 0x1197, "HANGUL JUNGSEONG YI-U" },
	{ 0x1198, "HANGUL JUNGSEONG I-A" },
	{ 0x1199, "HANGUL JUNGSEONG I-YA" },
	{ 0x119A, "HANGUL JUNGSEONG I-O" },
	{ 0x119B, "HANGUL JUNGSEONG I-U" },
	{ 0x119C, "HANGUL JUNGSEONG I-EU" },
	{ 0x119D, "HANGUL JUNGSEONG I-ARAEA" },
	{ 0x119E, "HANGUL JUNGSEONG ARAEA" },
	{ 0x119F, "HANGUL JUNGSEONG ARAEA-EO" },
	{ 0x11A0, "HANGUL JUNGSEONG ARAEA-U" },
	{ 0x11A1, "HANGUL JUNGSEONG ARAEA-I" },
	{ 0x11A2, "HANGUL JUNGSEONG SSANGARAEA" },
	{ 0x11A8, "HANGUL JONGSEONG KIYEOK" },	/* g * */
	{ 0x11A9, "HANGUL JONGSEONG SSANGKIYEOK" },	/* gg * */
	{ 0x11AA, "HANGUL JONGSEONG KIYEOK-SIOS" },	/* gs * */
	{ 0x11AB, "HANGUL JONGSEONG NIEUN" },	/* n * */
	{ 0x11AC, "HANGUL JONGSEONG NIEUN-CIEUC" },	/* nj * */
	{ 0x11AD, "HANGUL JONGSEONG NIEUN-HIEUH" },	/* nh * */
	{ 0x11AE, "HANGUL JONGSEONG TIKEUT" },	/* d * */
	{ 0x11AF, "HANGUL JONGSEONG RIEUL" },	/* l * */
	{ 0x11B0, "HANGUL JONGSEONG RIEUL-KIYEOK" },	/* lg * */
	{ 0x11B1, "HANGUL JONGSEONG RIEUL-MIEUM" },	/* lm * */
	{ 0x11B2, "HANGUL JONGSEONG RIEUL-PIEUP" },	/* lb * */
	{ 0x11B3, "HANGUL JONGSEONG RIEUL-SIOS" },	/* ls * */
	{ 0x11B4, "HANGUL JONGSEONG RIEUL-THIEUTH" },	/* lt * */
	{ 0x11B5, "HANGUL JONGSEONG RIEUL-PHIEUPH" },	/* lp * */
	{ 0x11B6, "HANGUL JONGSEONG RIEUL-HIEUH" },	/* lh * */
	{ 0x11B7, "HANGUL JONGSEONG MIEUM" },	/* m * */
	{ 0x11B8, "HANGUL JONGSEONG PIEUP" },	/* b * */
	{ 0x11B9, "HANGUL JONGSEONG PIEUP-SIOS" },	/* bs * */
	{ 0x11BA, "HANGUL JONGSEONG SIOS" },	/* s * */
	{ 0x11BB, "HANGUL JONGSEONG SSANGSIOS" },	/* ss * */
	{ 0x11BC, "HANGUL JONGSEONG IEUNG" },	/* ng * */
	{ 0x11BD, "HANGUL JONGSEONG CIEUC" },	/* j * */
	{ 0x11BE, "HANGUL JONGSEONG CHIEUCH" },	/* c * */
	{ 0x11BF, "HANGUL JONGSEONG KHIEUKH" },	/* k * */
	{ 0x11C0, "HANGUL JONGSEONG THIEUTH" },	/* t * */
	{ 0x11C1, "HANGUL JONGSEONG PHIEUPH" },	/* p * */
	{ 0x11C2, "HANGUL JONGSEONG HIEUH" },	/* h * */
	{ 0x11C3, "HANGUL JONGSEONG KIYEOK-RIEUL" },
	{ 0x11C4, "HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK" },
	{ 0x11C5, "HANGUL JONGSEONG NIEUN-KIYEOK" },
	{ 0x11C6, "HANGUL JONGSEONG NIEUN-TIKEUT" },
	{ 0x11C7, "HANGUL JONGSEONG NIEUN-SIOS" },
	{ 0x11C8, "HANGUL JONGSEONG NIEUN-PANSIOS" },
	{ 0x11C9, "HANGUL JONGSEONG NIEUN-THIEUTH" },
	{ 0x11CA, "HANGUL JONGSEONG TIKEUT-KIYEOK" },
	{ 0x11CB, "HANGUL JONGSEONG TIKEUT-RIEUL" },
	{ 0x11CC, "HANGUL JONGSEONG RIEUL-KIYEOK-SIOS" },
	{ 0x11CD, "HANGUL JONGSEONG RIEUL-NIEUN" },
	{ 0x11CE, "HANGUL JONGSEONG RIEUL-TIKEUT" },
	{ 0x11CF, "HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH" },
	{ 0x11D0, "HANGUL JONGSEONG SSANGRIEUL" },
	{ 0x11D1, "HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK" },
	{ 0x11D2, "HANGUL JONGSEONG RIEUL-MIEUM-SIOS" },
	{ 0x11D3, "HANGUL JONGSEONG RIEUL-PIEUP-SIOS" },
	{ 0x11D4, "HANGUL JONGSEONG RIEUL-PIEUP-HIEUH" },
	{ 0x11D5, "HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP" },
	{ 0x11D6, "HANGUL JONGSEONG RIEUL-SSANGSIOS" },
	{ 0x11D7, "HANGUL JONGSEONG RIEUL-PANSIOS" },
	{ 0x11D8, "HANGUL JONGSEONG RIEUL-KHIEUKH" },
	{ 0x11D9, "HANGUL JONGSEONG RIEUL-YEORINHIEUH" },
	{ 0x11DA, "HANGUL JONGSEONG MIEUM-KIYEOK" },
	{ 0x11DB, "HANGUL JONGSEONG MIEUM-RIEUL" },
	{ 0x11DC, "HANGUL JONGSEONG MIEUM-PIEUP" },
	{ 0x11DD, "HANGUL JONGSEONG MIEUM-SIOS" },
	{ 0x11DE, "HANGUL JONGSEONG MIEUM-SSANGSIOS" },
	{ 0x11DF, "HANGUL JONGSEONG MIEUM-PANSIOS" },
	{ 0x11E0, "HANGUL JONGSEONG MIEUM-CHIEUCH" },
	{ 0x11E1, "HANGUL JONGSEONG MIEUM-HIEUH" },
	{ 0x11E2, "HANGUL JONGSEONG KAPYEOUNMIEUM" },
	{ 0x11E3, "HANGUL JONGSEONG PIEUP-RIEUL" },
	{ 0x11E4, "HANGUL JONGSEONG PIEUP-PHIEUPH" },
	{ 0x11E5, "HANGUL JONGSEONG PIEUP-HIEUH" },
	{ 0x11E6, "HANGUL JONGSEONG KAPYEOUNPIEUP" },
	{ 0x11E7, "HANGUL JONGSEONG SIOS-KIYEOK" },
	{ 0x11E8, "HANGUL JONGSEONG SIOS-TIKEUT" },
	{ 0x11E9, "HANGUL JONGSEONG SIOS-RIEUL" },
	{ 0x11EA, "HANGUL JONGSEONG SIOS-PIEUP" },
	{ 0x11EB, "HANGUL JONGSEONG PANSIOS" },
	{ 0x11EC, "HANGUL JONGSEONG IEUNG-KIYEOK" },
	{ 0x11ED, "HANGUL JONGSEONG IEUNG-SSANGKIYEOK" },
	{ 0x11EE, "HANGUL JONGSEONG SSANGIEUNG" },
	{ 0x11EF, "HANGUL JONGSEONG IEUNG-KHIEUKH" },
	{ 0x11F0, "HANGUL JONGSEONG YESIEUNG" },
	{ 0x11F1, "HANGUL JONGSEONG YESIEUNG-SIOS" },
	{ 0x11F2, "HANGUL JONGSEONG YESIEUNG-PANSIOS" },
	{ 0x11F3, "HANGUL JONGSEONG PHIEUPH-PIEUP" },
	{ 0x11F4, "HANGUL JONGSEONG KAPYEOUNPHIEUPH" },
	{ 0x11F5, "HANGUL JONGSEONG HIEUH-NIEUN" },
	{ 0x11F6, "HANGUL JONGSEONG HIEUH-RIEUL" },
	{ 0x11F7, "HANGUL JONGSEONG HIEUH-MIEUM" },
	{ 0x11F8, "HANGUL JONGSEONG HIEUH-PIEUP" },
	{ 0x11F9, "HANGUL JONGSEONG YEORINHIEUH" },
	{ 0x1200, "ETHIOPIC SYLLABLE HA" },
	{ 0x1201, "ETHIOPIC SYLLABLE HU" },
	{ 0x1202, "ETHIOPIC SYLLABLE HI" },
	{ 0x1203, "ETHIOPIC SYLLABLE HAA" },
	{ 0x1204, "ETHIOPIC SYLLABLE HEE" },
	{ 0x1205, "ETHIOPIC SYLLABLE HE" },
	{ 0x1206, "ETHIOPIC SYLLABLE HO" },
	{ 0x1208, "ETHIOPIC SYLLABLE LA" },
	{ 0x1209, "ETHIOPIC SYLLABLE LU" },
	{ 0x120A, "ETHIOPIC SYLLABLE LI" },
	{ 0x120B, "ETHIOPIC SYLLABLE LAA" },
	{ 0x120C, "ETHIOPIC SYLLABLE LEE" },
	{ 0x120D, "ETHIOPIC SYLLABLE LE" },
	{ 0x120E, "ETHIOPIC SYLLABLE LO" },
	{ 0x120F, "ETHIOPIC SYLLABLE LWA" },
	{ 0x1210, "ETHIOPIC SYLLABLE HHA" },
	{ 0x1211, "ETHIOPIC SYLLABLE HHU" },
	{ 0x1212, "ETHIOPIC SYLLABLE HHI" },
	{ 0x1213, "ETHIOPIC SYLLABLE HHAA" },
	{ 0x1214, "ETHIOPIC SYLLABLE HHEE" },
	{ 0x1215, "ETHIOPIC SYLLABLE HHE" },
	{ 0x1216, "ETHIOPIC SYLLABLE HHO" },
	{ 0x1217, "ETHIOPIC SYLLABLE HHWA" },
	{ 0x1218, "ETHIOPIC SYLLABLE MA" },
	{ 0x1219, "ETHIOPIC SYLLABLE MU" },
	{ 0x121A, "ETHIOPIC SYLLABLE MI" },
	{ 0x121B, "ETHIOPIC SYLLABLE MAA" },
	{ 0x121C, "ETHIOPIC SYLLABLE MEE" },
	{ 0x121D, "ETHIOPIC SYLLABLE ME" },
	{ 0x121E, "ETHIOPIC SYLLABLE MO" },
	{ 0x121F, "ETHIOPIC SYLLABLE MWA" },
	{ 0x1220, "ETHIOPIC SYLLABLE SZA" },
	{ 0x1221, "ETHIOPIC SYLLABLE SZU" },
	{ 0x1222, "ETHIOPIC SYLLABLE SZI" },
	{ 0x1223, "ETHIOPIC SYLLABLE SZAA" },
	{ 0x1224, "ETHIOPIC SYLLABLE SZEE" },
	{ 0x1225, "ETHIOPIC SYLLABLE SZE" },
	{ 0x1226, "ETHIOPIC SYLLABLE SZO" },
	{ 0x1227, "ETHIOPIC SYLLABLE SZWA" },
	{ 0x1228, "ETHIOPIC SYLLABLE RA" },
	{ 0x1229, "ETHIOPIC SYLLABLE RU" },
	{ 0x122A, "ETHIOPIC SYLLABLE RI" },
	{ 0x122B, "ETHIOPIC SYLLABLE RAA" },
	{ 0x122C, "ETHIOPIC SYLLABLE REE" },
	{ 0x122D, "ETHIOPIC SYLLABLE RE" },
	{ 0x122E, "ETHIOPIC SYLLABLE RO" },
	{ 0x122F, "ETHIOPIC SYLLABLE RWA" },
	{ 0x1230, "ETHIOPIC SYLLABLE SA" },
	{ 0x1231, "ETHIOPIC SYLLABLE SU" },
	{ 0x1232, "ETHIOPIC SYLLABLE SI" },
	{ 0x1233, "ETHIOPIC SYLLABLE SAA" },
	{ 0x1234, "ETHIOPIC SYLLABLE SEE" },
	{ 0x1235, "ETHIOPIC SYLLABLE SE" },
	{ 0x1236, "ETHIOPIC SYLLABLE SO" },
	{ 0x1237, "ETHIOPIC SYLLABLE SWA" },
	{ 0x1238, "ETHIOPIC SYLLABLE SHA" },
	{ 0x1239, "ETHIOPIC SYLLABLE SHU" },
	{ 0x123A, "ETHIOPIC SYLLABLE SHI" },
	{ 0x123B, "ETHIOPIC SYLLABLE SHAA" },
	{ 0x123C, "ETHIOPIC SYLLABLE SHEE" },
	{ 0x123D, "ETHIOPIC SYLLABLE SHE" },
	{ 0x123E, "ETHIOPIC SYLLABLE SHO" },
	{ 0x123F, "ETHIOPIC SYLLABLE SHWA" },
	{ 0x1240, "ETHIOPIC SYLLABLE QA" },
	{ 0x1241, "ETHIOPIC SYLLABLE QU" },
	{ 0x1242, "ETHIOPIC SYLLABLE QI" },
	{ 0x1243, "ETHIOPIC SYLLABLE QAA" },
	{ 0x1244, "ETHIOPIC SYLLABLE QEE" },
	{ 0x1245, "ETHIOPIC SYLLABLE QE" },
	{ 0x1246, "ETHIOPIC SYLLABLE QO" },
	{ 0x1248, "ETHIOPIC SYLLABLE QWA" },
	{ 0x124A, "ETHIOPIC SYLLABLE QWI" },
	{ 0x124B, "ETHIOPIC SYLLABLE QWAA" },
	{ 0x124C, "ETHIOPIC SYLLABLE QWEE" },
	{ 0x124D, "ETHIOPIC SYLLABLE QWE" },
	{ 0x1250, "ETHIOPIC SYLLABLE QHA" },
	{ 0x1251, "ETHIOPIC SYLLABLE QHU" },
	{ 0x1252, "ETHIOPIC SYLLABLE QHI" },
	{ 0x1253, "ETHIOPIC SYLLABLE QHAA" },
	{ 0x1254, "ETHIOPIC SYLLABLE QHEE" },
	{ 0x1255, "ETHIOPIC SYLLABLE QHE" },
	{ 0x1256, "ETHIOPIC SYLLABLE QHO" },
	{ 0x1258, "ETHIOPIC SYLLABLE QHWA" },
	{ 0x125A, "ETHIOPIC SYLLABLE QHWI" },
	{ 0x125B, "ETHIOPIC SYLLABLE QHWAA" },
	{ 0x125C, "ETHIOPIC SYLLABLE QHWEE" },
	{ 0x125D, "ETHIOPIC SYLLABLE QHWE" },
	{ 0x1260, "ETHIOPIC SYLLABLE BA" },
	{ 0x1261, "ETHIOPIC SYLLABLE BU" },
	{ 0x1262, "ETHIOPIC SYLLABLE BI" },
	{ 0x1263, "ETHIOPIC SYLLABLE BAA" },
	{ 0x1264, "ETHIOPIC SYLLABLE BEE" },
	{ 0x1265, "ETHIOPIC SYLLABLE BE" },
	{ 0x1266, "ETHIOPIC SYLLABLE BO" },
	{ 0x1267, "ETHIOPIC SYLLABLE BWA" },
	{ 0x1268, "ETHIOPIC SYLLABLE VA" },
	{ 0x1269, "ETHIOPIC SYLLABLE VU" },
	{ 0x126A, "ETHIOPIC SYLLABLE VI" },
	{ 0x126B, "ETHIOPIC SYLLABLE VAA" },
	{ 0x126C, "ETHIOPIC SYLLABLE VEE" },
	{ 0x126D, "ETHIOPIC SYLLABLE VE" },
	{ 0x126E, "ETHIOPIC SYLLABLE VO" },
	{ 0x126F, "ETHIOPIC SYLLABLE VWA" },
	{ 0x1270, "ETHIOPIC SYLLABLE TA" },
	{ 0x1271, "ETHIOPIC SYLLABLE TU" },
	{ 0x1272, "ETHIOPIC SYLLABLE TI" },
	{ 0x1273, "ETHIOPIC SYLLABLE TAA" },
	{ 0x1274, "ETHIOPIC SYLLABLE TEE" },
	{ 0x1275, "ETHIOPIC SYLLABLE TE" },
	{ 0x1276, "ETHIOPIC SYLLABLE TO" },
	{ 0x1277, "ETHIOPIC SYLLABLE TWA" },
	{ 0x1278, "ETHIOPIC SYLLABLE CA" },
	{ 0x1279, "ETHIOPIC SYLLABLE CU" },
	{ 0x127A, "ETHIOPIC SYLLABLE CI" },
	{ 0x127B, "ETHIOPIC SYLLABLE CAA" },
	{ 0x127C, "ETHIOPIC SYLLABLE CEE" },
	{ 0x127D, "ETHIOPIC SYLLABLE CE" },
	{ 0x127E, "ETHIOPIC SYLLABLE CO" },
	{ 0x127F, "ETHIOPIC SYLLABLE CWA" },
	{ 0x1280, "ETHIOPIC SYLLABLE XA" },
	{ 0x1281, "ETHIOPIC SYLLABLE XU" },
	{ 0x1282, "ETHIOPIC SYLLABLE XI" },
	{ 0x1283, "ETHIOPIC SYLLABLE XAA" },
	{ 0x1284, "ETHIOPIC SYLLABLE XEE" },
	{ 0x1285, "ETHIOPIC SYLLABLE XE" },
	{ 0x1286, "ETHIOPIC SYLLABLE XO" },
	{ 0x1288, "ETHIOPIC SYLLABLE XWA" },
	{ 0x128A, "ETHIOPIC SYLLABLE XWI" },
	{ 0x128B, "ETHIOPIC SYLLABLE XWAA" },
	{ 0x128C, "ETHIOPIC SYLLABLE XWEE" },
	{ 0x128D, "ETHIOPIC SYLLABLE XWE" },
	{ 0x1290, "ETHIOPIC SYLLABLE NA" },
	{ 0x1291, "ETHIOPIC SYLLABLE NU" },
	{ 0x1292, "ETHIOPIC SYLLABLE NI" },
	{ 0x1293, "ETHIOPIC SYLLABLE NAA" },
	{ 0x1294, "ETHIOPIC SYLLABLE NEE" },
	{ 0x1295, "ETHIOPIC SYLLABLE NE" },
	{ 0x1296, "ETHIOPIC SYLLABLE NO" },
	{ 0x1297, "ETHIOPIC SYLLABLE NWA" },
	{ 0x1298, "ETHIOPIC SYLLABLE NYA" },
	{ 0x1299, "ETHIOPIC SYLLABLE NYU" },
	{ 0x129A, "ETHIOPIC SYLLABLE NYI" },
	{ 0x129B, "ETHIOPIC SYLLABLE NYAA" },
	{ 0x129C, "ETHIOPIC SYLLABLE NYEE" },
	{ 0x129D, "ETHIOPIC SYLLABLE NYE" },
	{ 0x129E, "ETHIOPIC SYLLABLE NYO" },
	{ 0x129F, "ETHIOPIC SYLLABLE NYWA" },
	{ 0x12A0, "ETHIOPIC SYLLABLE GLOTTAL A" },
	{ 0x12A1, "ETHIOPIC SYLLABLE GLOTTAL U" },
	{ 0x12A2, "ETHIOPIC SYLLABLE GLOTTAL I" },
	{ 0x12A3, "ETHIOPIC SYLLABLE GLOTTAL AA" },
	{ 0x12A4, "ETHIOPIC SYLLABLE GLOTTAL EE" },
	{ 0x12A5, "ETHIOPIC SYLLABLE GLOTTAL E" },
	{ 0x12A6, "ETHIOPIC SYLLABLE GLOTTAL O" },
	{ 0x12A7, "ETHIOPIC SYLLABLE GLOTTAL WA" },
	{ 0x12A8, "ETHIOPIC SYLLABLE KA" },
	{ 0x12A9, "ETHIOPIC SYLLABLE KU" },
	{ 0x12AA, "ETHIOPIC SYLLABLE KI" },
	{ 0x12AB, "ETHIOPIC SYLLABLE KAA" },
	{ 0x12AC, "ETHIOPIC SYLLABLE KEE" },
	{ 0x12AD, "ETHIOPIC SYLLABLE KE" },
	{ 0x12AE, "ETHIOPIC SYLLABLE KO" },
	{ 0x12B0, "ETHIOPIC SYLLABLE KWA" },
	{ 0x12B2, "ETHIOPIC SYLLABLE KWI" },
	{ 0x12B3, "ETHIOPIC SYLLABLE KWAA" },
	{ 0x12B4, "ETHIOPIC SYLLABLE KWEE" },
	{ 0x12B5, "ETHIOPIC SYLLABLE KWE" },
	{ 0x12B8, "ETHIOPIC SYLLABLE KXA" },
	{ 0x12B9, "ETHIOPIC SYLLABLE KXU" },
	{ 0x12BA, "ETHIOPIC SYLLABLE KXI" },
	{ 0x12BB, "ETHIOPIC SYLLABLE KXAA" },
	{ 0x12BC, "ETHIOPIC SYLLABLE KXEE" },
	{ 0x12BD, "ETHIOPIC SYLLABLE KXE" },
	{ 0x12BE, "ETHIOPIC SYLLABLE KXO" },
	{ 0x12C0, "ETHIOPIC SYLLABLE KXWA" },
	{ 0x12C2, "ETHIOPIC SYLLABLE KXWI" },
	{ 0x12C3, "ETHIOPIC SYLLABLE KXWAA" },
	{ 0x12C4, "ETHIOPIC SYLLABLE KXWEE" },
	{ 0x12C5, "ETHIOPIC SYLLABLE KXWE" },
	{ 0x12C8, "ETHIOPIC SYLLABLE WA" },
	{ 0x12C9, "ETHIOPIC SYLLABLE WU" },
	{ 0x12CA, "ETHIOPIC SYLLABLE WI" },
	{ 0x12CB, "ETHIOPIC SYLLABLE WAA" },
	{ 0x12CC, "ETHIOPIC SYLLABLE WEE" },
	{ 0x12CD, "ETHIOPIC SYLLABLE WE" },
	{ 0x12CE, "ETHIOPIC SYLLABLE WO" },
	{ 0x12D0, "ETHIOPIC SYLLABLE PHARYNGEAL A" },
	{ 0x12D1, "ETHIOPIC SYLLABLE PHARYNGEAL U" },
	{ 0x12D2, "ETHIOPIC SYLLABLE PHARYNGEAL I" },
	{ 0x12D3, "ETHIOPIC SYLLABLE PHARYNGEAL AA" },
	{ 0x12D4, "ETHIOPIC SYLLABLE PHARYNGEAL EE" },
	{ 0x12D5, "ETHIOPIC SYLLABLE PHARYNGEAL E" },
	{ 0x12D6, "ETHIOPIC SYLLABLE PHARYNGEAL O" },
	{ 0x12D8, "ETHIOPIC SYLLABLE ZA" },
	{ 0x12D9, "ETHIOPIC SYLLABLE ZU" },
	{ 0x12DA, "ETHIOPIC SYLLABLE ZI" },
	{ 0x12DB, "ETHIOPIC SYLLABLE ZAA" },
	{ 0x12DC, "ETHIOPIC SYLLABLE ZEE" },
	{ 0x12DD, "ETHIOPIC SYLLABLE ZE" },
	{ 0x12DE, "ETHIOPIC SYLLABLE ZO" },
	{ 0x12DF, "ETHIOPIC SYLLABLE ZWA" },
	{ 0x12E0, "ETHIOPIC SYLLABLE ZHA" },
	{ 0x12E1, "ETHIOPIC SYLLABLE ZHU" },
	{ 0x12E2, "ETHIOPIC SYLLABLE ZHI" },
	{ 0x12E3, "ETHIOPIC SYLLABLE ZHAA" },
	{ 0x12E4, "ETHIOPIC SYLLABLE ZHEE" },
	{ 0x12E5, "ETHIOPIC SYLLABLE ZHE" },
	{ 0x12E6, "ETHIOPIC SYLLABLE ZHO" },
	{ 0x12E7, "ETHIOPIC SYLLABLE ZHWA" },
	{ 0x12E8, "ETHIOPIC SYLLABLE YA" },
	{ 0x12E9, "ETHIOPIC SYLLABLE YU" },
	{ 0x12EA, "ETHIOPIC SYLLABLE YI" },
	{ 0x12EB, "ETHIOPIC SYLLABLE YAA" },
	{ 0x12EC, "ETHIOPIC SYLLABLE YEE" },
	{ 0x12ED, "ETHIOPIC SYLLABLE YE" },
	{ 0x12EE, "ETHIOPIC SYLLABLE YO" },
	{ 0x12F0, "ETHIOPIC SYLLABLE DA" },
	{ 0x12F1, "ETHIOPIC SYLLABLE DU" },
	{ 0x12F2, "ETHIOPIC SYLLABLE DI" },
	{ 0x12F3, "ETHIOPIC SYLLABLE DAA" },
	{ 0x12F4, "ETHIOPIC SYLLABLE DEE" },
	{ 0x12F5, "ETHIOPIC SYLLABLE DE" },
	{ 0x12F6, "ETHIOPIC SYLLABLE DO" },
	{ 0x12F7, "ETHIOPIC SYLLABLE DWA" },
	{ 0x12F8, "ETHIOPIC SYLLABLE DDA" },
	{ 0x12F9, "ETHIOPIC SYLLABLE DDU" },
	{ 0x12FA, "ETHIOPIC SYLLABLE DDI" },
	{ 0x12FB, "ETHIOPIC SYLLABLE DDAA" },
	{ 0x12FC, "ETHIOPIC SYLLABLE DDEE" },
	{ 0x12FD, "ETHIOPIC SYLLABLE DDE" },
	{ 0x12FE, "ETHIOPIC SYLLABLE DDO" },
	{ 0x12FF, "ETHIOPIC SYLLABLE DDWA" },
	{ 0x1300, "ETHIOPIC SYLLABLE JA" },
	{ 0x1301, "ETHIOPIC SYLLABLE JU" },
	{ 0x1302, "ETHIOPIC SYLLABLE JI" },
	{ 0x1303, "ETHIOPIC SYLLABLE JAA" },
	{ 0x1304, "ETHIOPIC SYLLABLE JEE" },
	{ 0x1305, "ETHIOPIC SYLLABLE JE" },
	{ 0x1306, "ETHIOPIC SYLLABLE JO" },
	{ 0x1307, "ETHIOPIC SYLLABLE JWA" },
	{ 0x1308, "ETHIOPIC SYLLABLE GA" },
	{ 0x1309, "ETHIOPIC SYLLABLE GU" },
	{ 0x130A, "ETHIOPIC SYLLABLE GI" },
	{ 0x130B, "ETHIOPIC SYLLABLE GAA" },
	{ 0x130C, "ETHIOPIC SYLLABLE GEE" },
	{ 0x130D, "ETHIOPIC SYLLABLE GE" },
	{ 0x130E, "ETHIOPIC SYLLABLE GO" },
	{ 0x1310, "ETHIOPIC SYLLABLE GWA" },
	{ 0x1312, "ETHIOPIC SYLLABLE GWI" },
	{ 0x1313, "ETHIOPIC SYLLABLE GWAA" },
	{ 0x1314, "ETHIOPIC SYLLABLE GWEE" },
	{ 0x1315, "ETHIOPIC SYLLABLE GWE" },
	{ 0x1318, "ETHIOPIC SYLLABLE GGA" },
	{ 0x1319, "ETHIOPIC SYLLABLE GGU" },
	{ 0x131A, "ETHIOPIC SYLLABLE GGI" },
	{ 0x131B, "ETHIOPIC SYLLABLE GGAA" },
	{ 0x131C, "ETHIOPIC SYLLABLE GGEE" },
	{ 0x131D, "ETHIOPIC SYLLABLE GGE" },
	{ 0x131E, "ETHIOPIC SYLLABLE GGO" },
	{ 0x1320, "ETHIOPIC SYLLABLE THA" },
	{ 0x1321, "ETHIOPIC SYLLABLE THU" },
	{ 0x1322, "ETHIOPIC SYLLABLE THI" },
	{ 0x1323, "ETHIOPIC SYLLABLE THAA" },
	{ 0x1324, "ETHIOPIC SYLLABLE THEE" },
	{ 0x1325, "ETHIOPIC SYLLABLE THE" },
	{ 0x1326, "ETHIOPIC SYLLABLE THO" },
	{ 0x1327, "ETHIOPIC SYLLABLE THWA" },
	{ 0x1328, "ETHIOPIC SYLLABLE CHA" },
	{ 0x1329, "ETHIOPIC SYLLABLE CHU" },
	{ 0x132A, "ETHIOPIC SYLLABLE CHI" },
	{ 0x132B, "ETHIOPIC SYLLABLE CHAA" },
	{ 0x132C, "ETHIOPIC SYLLABLE CHEE" },
	{ 0x132D, "ETHIOPIC SYLLABLE CHE" },
	{ 0x132E, "ETHIOPIC SYLLABLE CHO" },
	{ 0x132F, "ETHIOPIC SYLLABLE CHWA" },
	{ 0x1330, "ETHIOPIC SYLLABLE PHA" },
	{ 0x1331, "ETHIOPIC SYLLABLE PHU" },
	{ 0x1332, "ETHIOPIC SYLLABLE PHI" },
	{ 0x1333, "ETHIOPIC SYLLABLE PHAA" },
	{ 0x1334, "ETHIOPIC SYLLABLE PHEE" },
	{ 0x1335, "ETHIOPIC SYLLABLE PHE" },
	{ 0x1336, "ETHIOPIC SYLLABLE PHO" },
	{ 0x1337, "ETHIOPIC SYLLABLE PHWA" },
	{ 0x1338, "ETHIOPIC SYLLABLE TSA" },
	{ 0x1339, "ETHIOPIC SYLLABLE TSU" },
	{ 0x133A, "ETHIOPIC SYLLABLE TSI" },
	{ 0x133B, "ETHIOPIC SYLLABLE TSAA" },
	{ 0x133C, "ETHIOPIC SYLLABLE TSEE" },
	{ 0x133D, "ETHIOPIC SYLLABLE TSE" },
	{ 0x133E, "ETHIOPIC SYLLABLE TSO" },
	{ 0x133F, "ETHIOPIC SYLLABLE TSWA" },
	{ 0x1340, "ETHIOPIC SYLLABLE TZA" },
	{ 0x1341, "ETHIOPIC SYLLABLE TZU" },
	{ 0x1342, "ETHIOPIC SYLLABLE TZI" },
	{ 0x1343, "ETHIOPIC SYLLABLE TZAA" },
	{ 0x1344, "ETHIOPIC SYLLABLE TZEE" },
	{ 0x1345, "ETHIOPIC SYLLABLE TZE" },
	{ 0x1346, "ETHIOPIC SYLLABLE TZO" },
	{ 0x1348, "ETHIOPIC SYLLABLE FA" },
	{ 0x1349, "ETHIOPIC SYLLABLE FU" },
	{ 0x134A, "ETHIOPIC SYLLABLE FI" },
	{ 0x134B, "ETHIOPIC SYLLABLE FAA" },
	{ 0x134C, "ETHIOPIC SYLLABLE FEE" },
	{ 0x134D, "ETHIOPIC SYLLABLE FE" },
	{ 0x134E, "ETHIOPIC SYLLABLE FO" },
	{ 0x134F, "ETHIOPIC SYLLABLE FWA" },
	{ 0x1350, "ETHIOPIC SYLLABLE PA" },
	{ 0x1351, "ETHIOPIC SYLLABLE PU" },
	{ 0x1352, "ETHIOPIC SYLLABLE PI" },
	{ 0x1353, "ETHIOPIC SYLLABLE PAA" },
	{ 0x1354, "ETHIOPIC SYLLABLE PEE" },
	{ 0x1355, "ETHIOPIC SYLLABLE PE" },
	{ 0x1356, "ETHIOPIC SYLLABLE PO" },
	{ 0x1357, "ETHIOPIC SYLLABLE PWA" },
	{ 0x1358, "ETHIOPIC SYLLABLE RYA" },
	{ 0x1359, "ETHIOPIC SYLLABLE MYA" },
	{ 0x135A, "ETHIOPIC SYLLABLE FYA" },
	{ 0x1361, "ETHIOPIC WORDSPACE" },
	{ 0x1362, "ETHIOPIC FULL STOP" },
	{ 0x1363, "ETHIOPIC COMMA" },
	{ 0x1364, "ETHIOPIC SEMICOLON" },
	{ 0x1365, "ETHIOPIC COLON" },
	{ 0x1366, "ETHIOPIC PREFACE COLON" },
	{ 0x1367, "ETHIOPIC QUESTION MARK" },
	{ 0x1368, "ETHIOPIC PARAGRAPH SEPARATOR" },
	{ 0x1369, "ETHIOPIC DIGIT ONE" },
	{ 0x136A, "ETHIOPIC DIGIT TWO" },
	{ 0x136B, "ETHIOPIC DIGIT THREE" },
	{ 0x136C, "ETHIOPIC DIGIT FOUR" },
	{ 0x136D, "ETHIOPIC DIGIT FIVE" },
	{ 0x136E, "ETHIOPIC DIGIT SIX" },
	{ 0x136F, "ETHIOPIC DIGIT SEVEN" },
	{ 0x1370, "ETHIOPIC DIGIT EIGHT" },
	{ 0x1371, "ETHIOPIC DIGIT NINE" },
	{ 0x1372, "ETHIOPIC NUMBER TEN" },
	{ 0x1373, "ETHIOPIC NUMBER TWENTY" },
	{ 0x1374, "ETHIOPIC NUMBER THIRTY" },
	{ 0x1375, "ETHIOPIC NUMBER FORTY" },
	{ 0x1376, "ETHIOPIC NUMBER FIFTY" },
	{ 0x1377, "ETHIOPIC NUMBER SIXTY" },
	{ 0x1378, "ETHIOPIC NUMBER SEVENTY" },
	{ 0x1379, "ETHIOPIC NUMBER EIGHTY" },
	{ 0x137A, "ETHIOPIC NUMBER NINETY" },
	{ 0x137B, "ETHIOPIC NUMBER HUNDRED" },
	{ 0x137C, "ETHIOPIC NUMBER TEN THOUSAND" },
	{ 0x13A0, "CHEROKEE LETTER A" },
	{ 0x13A1, "CHEROKEE LETTER E" },
	{ 0x13A2, "CHEROKEE LETTER I" },
	{ 0x13A3, "CHEROKEE LETTER O" },
	{ 0x13A4, "CHEROKEE LETTER U" },
	{ 0x13A5, "CHEROKEE LETTER V" },
	{ 0x13A6, "CHEROKEE LETTER GA" },
	{ 0x13A7, "CHEROKEE LETTER KA" },
	{ 0x13A8, "CHEROKEE LETTER GE" },
	{ 0x13A9, "CHEROKEE LETTER GI" },
	{ 0x13AA, "CHEROKEE LETTER GO" },
	{ 0x13AB, "CHEROKEE LETTER GU" },
	{ 0x13AC, "CHEROKEE LETTER GV" },
	{ 0x13AD, "CHEROKEE LETTER HA" },
	{ 0x13AE, "CHEROKEE LETTER HE" },
	{ 0x13AF, "CHEROKEE LETTER HI" },
	{ 0x13B0, "CHEROKEE LETTER HO" },
	{ 0x13B1, "CHEROKEE LETTER HU" },
	{ 0x13B2, "CHEROKEE LETTER HV" },
	{ 0x13B3, "CHEROKEE LETTER LA" },
	{ 0x13B4, "CHEROKEE LETTER LE" },
	{ 0x13B5, "CHEROKEE LETTER LI" },
	{ 0x13B6, "CHEROKEE LETTER LO" },
	{ 0x13B7, "CHEROKEE LETTER LU" },
	{ 0x13B8, "CHEROKEE LETTER LV" },
	{ 0x13B9, "CHEROKEE LETTER MA" },
	{ 0x13BA, "CHEROKEE LETTER ME" },
	{ 0x13BB, "CHEROKEE LETTER MI" },
	{ 0x13BC, "CHEROKEE LETTER MO" },
	{ 0x13BD, "CHEROKEE LETTER MU" },
	{ 0x13BE, "CHEROKEE LETTER NA" },
	{ 0x13BF, "CHEROKEE LETTER HNA" },
	{ 0x13C0, "CHEROKEE LETTER NAH" },
	{ 0x13C1, "CHEROKEE LETTER NE" },
	{ 0x13C2, "CHEROKEE LETTER NI" },
	{ 0x13C3, "CHEROKEE LETTER NO" },
	{ 0x13C4, "CHEROKEE LETTER NU" },
	{ 0x13C5, "CHEROKEE LETTER NV" },
	{ 0x13C6, "CHEROKEE LETTER QUA" },
	{ 0x13C7, "CHEROKEE LETTER QUE" },
	{ 0x13C8, "CHEROKEE LETTER QUI" },
	{ 0x13C9, "CHEROKEE LETTER QUO" },
	{ 0x13CA, "CHEROKEE LETTER QUU" },
	{ 0x13CB, "CHEROKEE LETTER QUV" },
	{ 0x13CC, "CHEROKEE LETTER SA" },
	{ 0x13CD, "CHEROKEE LETTER S" },
	{ 0x13CE, "CHEROKEE LETTER SE" },
	{ 0x13CF, "CHEROKEE LETTER SI" },
	{ 0x13D0, "CHEROKEE LETTER SO" },
	{ 0x13D1, "CHEROKEE LETTER SU" },
	{ 0x13D2, "CHEROKEE LETTER SV" },
	{ 0x13D3, "CHEROKEE LETTER DA" },
	{ 0x13D4, "CHEROKEE LETTER TA" },
	{ 0x13D5, "CHEROKEE LETTER DE" },
	{ 0x13D6, "CHEROKEE LETTER TE" },
	{ 0x13D7, "CHEROKEE LETTER DI" },
	{ 0x13D8, "CHEROKEE LETTER TI" },
	{ 0x13D9, "CHEROKEE LETTER DO" },
	{ 0x13DA, "CHEROKEE LETTER DU" },
	{ 0x13DB, "CHEROKEE LETTER DV" },
	{ 0x13DC, "CHEROKEE LETTER DLA" },
	{ 0x13DD, "CHEROKEE LETTER TLA" },
	{ 0x13DE, "CHEROKEE LETTER TLE" },
	{ 0x13DF, "CHEROKEE LETTER TLI" },
	{ 0x13E0, "CHEROKEE LETTER TLO" },
	{ 0x13E1, "CHEROKEE LETTER TLU" },
	{ 0x13E2, "CHEROKEE LETTER TLV" },
	{ 0x13E3, "CHEROKEE LETTER TSA" },
	{ 0x13E4, "CHEROKEE LETTER TSE" },
	{ 0x13E5, "CHEROKEE LETTER TSI" },
	{ 0x13E6, "CHEROKEE LETTER TSO" },
	{ 0x13E7, "CHEROKEE LETTER TSU" },
	{ 0x13E8, "CHEROKEE LETTER TSV" },
	{ 0x13E9, "CHEROKEE LETTER WA" },
	{ 0x13EA, "CHEROKEE LETTER WE" },
	{ 0x13EB, "CHEROKEE LETTER WI" },
	{ 0x13EC, "CHEROKEE LETTER WO" },
	{ 0x13ED, "CHEROKEE LETTER WU" },
	{ 0x13EE, "CHEROKEE LETTER WV" },
	{ 0x13EF, "CHEROKEE LETTER YA" },
	{ 0x13F0, "CHEROKEE LETTER YE" },
	{ 0x13F1, "CHEROKEE LETTER YI" },
	{ 0x13F2, "CHEROKEE LETTER YO" },
	{ 0x13F3, "CHEROKEE LETTER YU" },
	{ 0x13F4, "CHEROKEE LETTER YV" },
	{ 0x1401, "CANADIAN SYLLABICS E" },
	{ 0x1402, "CANADIAN SYLLABICS AAI" },
	{ 0x1403, "CANADIAN SYLLABICS I" },
	{ 0x1404, "CANADIAN SYLLABICS II" },
	{ 0x1405, "CANADIAN SYLLABICS O" },
	{ 0x1406, "CANADIAN SYLLABICS OO" },
	{ 0x1407, "CANADIAN SYLLABICS Y-CREE OO" },
	{ 0x1408, "CANADIAN SYLLABICS CARRIER EE" },
	{ 0x1409, "CANADIAN SYLLABICS CARRIER I" },
	{ 0x140A, "CANADIAN SYLLABICS A" },
	{ 0x140B, "CANADIAN SYLLABICS AA" },
	{ 0x140C, "CANADIAN SYLLABICS WE" },
	{ 0x140D, "CANADIAN SYLLABICS WEST-CREE WE" },
	{ 0x140E, "CANADIAN SYLLABICS WI" },
	{ 0x140F, "CANADIAN SYLLABICS WEST-CREE WI" },
	{ 0x1410, "CANADIAN SYLLABICS WII" },
	{ 0x1411, "CANADIAN SYLLABICS WEST-CREE WII" },
	{ 0x1412, "CANADIAN SYLLABICS WO" },
	{ 0x1413, "CANADIAN SYLLABICS WEST-CREE WO" },
	{ 0x1414, "CANADIAN SYLLABICS WOO" },
	{ 0x1415, "CANADIAN SYLLABICS WEST-CREE WOO" },
	{ 0x1416, "CANADIAN SYLLABICS NASKAPI WOO" },
	{ 0x1417, "CANADIAN SYLLABICS WA" },
	{ 0x1418, "CANADIAN SYLLABICS WEST-CREE WA" },
	{ 0x1419, "CANADIAN SYLLABICS WAA" },
	{ 0x141A, "CANADIAN SYLLABICS WEST-CREE WAA" },
	{ 0x141B, "CANADIAN SYLLABICS NASKAPI WAA" },
	{ 0x141C, "CANADIAN SYLLABICS AI" },
	{ 0x141D, "CANADIAN SYLLABICS Y-CREE W" },
	{ 0x141E, "CANADIAN SYLLABICS GLOTTAL STOP" },
	{ 0x141F, "CANADIAN SYLLABICS FINAL ACUTE" },
	{ 0x1420, "CANADIAN SYLLABICS FINAL GRAVE" },
	{ 0x1421, "CANADIAN SYLLABICS FINAL BOTTOM HALF RING" },
	{ 0x1422, "CANADIAN SYLLABICS FINAL TOP HALF RING" },
	{ 0x1423, "CANADIAN SYLLABICS FINAL RIGHT HALF RING" },
	{ 0x1424, "CANADIAN SYLLABICS FINAL RING" },
	{ 0x1425, "CANADIAN SYLLABICS FINAL DOUBLE ACUTE" },
	{ 0x1426, "CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES" },
	{ 0x1427, "CANADIAN SYLLABICS FINAL MIDDLE DOT" },
	{ 0x1428, "CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE" },
	{ 0x1429, "CANADIAN SYLLABICS FINAL PLUS" },
	{ 0x142A, "CANADIAN SYLLABICS FINAL DOWN TACK" },
	{ 0x142B, "CANADIAN SYLLABICS EN" },
	{ 0x142C, "CANADIAN SYLLABICS IN" },
	{ 0x142D, "CANADIAN SYLLABICS ON" },
	{ 0x142E, "CANADIAN SYLLABICS AN" },
	{ 0x142F, "CANADIAN SYLLABICS PE" },
	{ 0x1430, "CANADIAN SYLLABICS PAAI" },
	{ 0x1431, "CANADIAN SYLLABICS PI" },
	{ 0x1432, "CANADIAN SYLLABICS PII" },
	{ 0x1433, "CANADIAN SYLLABICS PO" },
	{ 0x1434, "CANADIAN SYLLABICS POO" },
	{ 0x1435, "CANADIAN SYLLABICS Y-CREE POO" },
	{ 0x1436, "CANADIAN SYLLABICS CARRIER HEE" },
	{ 0x1437, "CANADIAN SYLLABICS CARRIER HI" },
	{ 0x1438, "CANADIAN SYLLABICS PA" },
	{ 0x1439, "CANADIAN SYLLABICS PAA" },
	{ 0x143A, "CANADIAN SYLLABICS PWE" },
	{ 0x143B, "CANADIAN SYLLABICS WEST-CREE PWE" },
	{ 0x143C, "CANADIAN SYLLABICS PWI" },
	{ 0x143D, "CANADIAN SYLLABICS WEST-CREE PWI" },
	{ 0x143E, "CANADIAN SYLLABICS PWII" },
	{ 0x143F, "CANADIAN SYLLABICS WEST-CREE PWII" },
	{ 0x1440, "CANADIAN SYLLABICS PWO" },
	{ 0x1441, "CANADIAN SYLLABICS WEST-CREE PWO" },
	{ 0x1442, "CANADIAN SYLLABICS PWOO" },
	{ 0x1443, "CANADIAN SYLLABICS WEST-CREE PWOO" },
	{ 0x1444, "CANADIAN SYLLABICS PWA" },
	{ 0x1445, "CANADIAN SYLLABICS WEST-CREE PWA" },
	{ 0x1446, "CANADIAN SYLLABICS PWAA" },
	{ 0x1447, "CANADIAN SYLLABICS WEST-CREE PWAA" },
	{ 0x1448, "CANADIAN SYLLABICS Y-CREE PWAA" },
	{ 0x1449, "CANADIAN SYLLABICS P" },
	{ 0x144A, "CANADIAN SYLLABICS WEST-CREE P" },
	{ 0x144B, "CANADIAN SYLLABICS CARRIER H" },
	{ 0x144C, "CANADIAN SYLLABICS TE" },
	{ 0x144D, "CANADIAN SYLLABICS TAAI" },
	{ 0x144E, "CANADIAN SYLLABICS TI" },
	{ 0x144F, "CANADIAN SYLLABICS TII" },
	{ 0x1450, "CANADIAN SYLLABICS TO" },
	{ 0x1451, "CANADIAN SYLLABICS TOO" },
	{ 0x1452, "CANADIAN SYLLABICS Y-CREE TOO" },
	{ 0x1453, "CANADIAN SYLLABICS CARRIER DEE" },
	{ 0x1454, "CANADIAN SYLLABICS CARRIER DI" },
	{ 0x1455, "CANADIAN SYLLABICS TA" },
	{ 0x1456, "CANADIAN SYLLABICS TAA" },
	{ 0x1457, "CANADIAN SYLLABICS TWE" },
	{ 0x1458, "CANADIAN SYLLABICS WEST-CREE TWE" },
	{ 0x1459, "CANADIAN SYLLABICS TWI" },
	{ 0x145A, "CANADIAN SYLLABICS WEST-CREE TWI" },
	{ 0x145B, "CANADIAN SYLLABICS TWII" },
	{ 0x145C, "CANADIAN SYLLABICS WEST-CREE TWII" },
	{ 0x145D, "CANADIAN SYLLABICS TWO" },
	{ 0x145E, "CANADIAN SYLLABICS WEST-CREE TWO" },
	{ 0x145F, "CANADIAN SYLLABICS TWOO" },
	{ 0x1460, "CANADIAN SYLLABICS WEST-CREE TWOO" },
	{ 0x1461, "CANADIAN SYLLABICS TWA" },
	{ 0x1462, "CANADIAN SYLLABICS WEST-CREE TWA" },
	{ 0x1463, "CANADIAN SYLLABICS TWAA" },
	{ 0x1464, "CANADIAN SYLLABICS WEST-CREE TWAA" },
	{ 0x1465, "CANADIAN SYLLABICS NASKAPI TWAA" },
	{ 0x1466, "CANADIAN SYLLABICS T" },
	{ 0x1467, "CANADIAN SYLLABICS TTE" },
	{ 0x1468, "CANADIAN SYLLABICS TTI" },
	{ 0x1469, "CANADIAN SYLLABICS TTO" },
	{ 0x146A, "CANADIAN SYLLABICS TTA" },
	{ 0x146B, "CANADIAN SYLLABICS KE" },
	{ 0x146C, "CANADIAN SYLLABICS KAAI" },
	{ 0x146D, "CANADIAN SYLLABICS KI" },
	{ 0x146E, "CANADIAN SYLLABICS KII" },
	{ 0x146F, "CANADIAN SYLLABICS KO" },
	{ 0x1470, "CANADIAN SYLLABICS KOO" },
	{ 0x1471, "CANADIAN SYLLABICS Y-CREE KOO" },
	{ 0x1472, "CANADIAN SYLLABICS KA" },
	{ 0x1473, "CANADIAN SYLLABICS KAA" },
	{ 0x1474, "CANADIAN SYLLABICS KWE" },
	{ 0x1475, "CANADIAN SYLLABICS WEST-CREE KWE" },
	{ 0x1476, "CANADIAN SYLLABICS KWI" },
	{ 0x1477, "CANADIAN SYLLABICS WEST-CREE KWI" },
	{ 0x1478, "CANADIAN SYLLABICS KWII" },
	{ 0x1479, "CANADIAN SYLLABICS WEST-CREE KWII" },
	{ 0x147A, "CANADIAN SYLLABICS KWO" },
	{ 0x147B, "CANADIAN SYLLABICS WEST-CREE KWO" },
	{ 0x147C, "CANADIAN SYLLABICS KWOO" },
	{ 0x147D, "CANADIAN SYLLABICS WEST-CREE KWOO" },
	{ 0x147E, "CANADIAN SYLLABICS KWA" },
	{ 0x147F, "CANADIAN SYLLABICS WEST-CREE KWA" },
	{ 0x1480, "CANADIAN SYLLABICS KWAA" },
	{ 0x1481, "CANADIAN SYLLABICS WEST-CREE KWAA" },
	{ 0x1482, "CANADIAN SYLLABICS NASKAPI KWAA" },
	{ 0x1483, "CANADIAN SYLLABICS K" },
	{ 0x1484, "CANADIAN SYLLABICS KW" },
	{ 0x1485, "CANADIAN SYLLABICS SOUTH-SLAVEY KEH" },
	{ 0x1486, "CANADIAN SYLLABICS SOUTH-SLAVEY KIH" },
	{ 0x1487, "CANADIAN SYLLABICS SOUTH-SLAVEY KOH" },
	{ 0x1488, "CANADIAN SYLLABICS SOUTH-SLAVEY KAH" },
	{ 0x1489, "CANADIAN SYLLABICS CE" },
	{ 0x148A, "CANADIAN SYLLABICS CAAI" },
	{ 0x148B, "CANADIAN SYLLABICS CI" },
	{ 0x148C, "CANADIAN SYLLABICS CII" },
	{ 0x148D, "CANADIAN SYLLABICS CO" },
	{ 0x148E, "CANADIAN SYLLABICS COO" },
	{ 0x148F, "CANADIAN SYLLABICS Y-CREE COO" },
	{ 0x1490, "CANADIAN SYLLABICS CA" },
	{ 0x1491, "CANADIAN SYLLABICS CAA" },
	{ 0x1492, "CANADIAN SYLLABICS CWE" },
	{ 0x1493, "CANADIAN SYLLABICS WEST-CREE CWE" },
	{ 0x1494, "CANADIAN SYLLABICS CWI" },
	{ 0x1495, "CANADIAN SYLLABICS WEST-CREE CWI" },
	{ 0x1496, "CANADIAN SYLLABICS CWII" },
	{ 0x1497, "CANADIAN SYLLABICS WEST-CREE CWII" },
	{ 0x1498, "CANADIAN SYLLABICS CWO" },
	{ 0x1499, "CANADIAN SYLLABICS WEST-CREE CWO" },
	{ 0x149A, "CANADIAN SYLLABICS CWOO" },
	{ 0x149B, "CANADIAN SYLLABICS WEST-CREE CWOO" },
	{ 0x149C, "CANADIAN SYLLABICS CWA" },
	{ 0x149D, "CANADIAN SYLLABICS WEST-CREE CWA" },
	{ 0x149E, "CANADIAN SYLLABICS CWAA" },
	{ 0x149F, "CANADIAN SYLLABICS WEST-CREE CWAA" },
	{ 0x14A0, "CANADIAN SYLLABICS NASKAPI CWAA" },
	{ 0x14A1, "CANADIAN SYLLABICS C" },
	{ 0x14A2, "CANADIAN SYLLABICS SAYISI TH" },
	{ 0x14A3, "CANADIAN SYLLABICS ME" },
	{ 0x14A4, "CANADIAN SYLLABICS MAAI" },
	{ 0x14A5, "CANADIAN SYLLABICS MI" },
	{ 0x14A6, "CANADIAN SYLLABICS MII" },
	{ 0x14A7, "CANADIAN SYLLABICS MO" },
	{ 0x14A8, "CANADIAN SYLLABICS MOO" },
	{ 0x14A9, "CANADIAN SYLLABICS Y-CREE MOO" },
	{ 0x14AA, "CANADIAN SYLLABICS MA" },
	{ 0x14AB, "CANADIAN SYLLABICS MAA" },
	{ 0x14AC, "CANADIAN SYLLABICS MWE" },
	{ 0x14AD, "CANADIAN SYLLABICS WEST-CREE MWE" },
	{ 0x14AE, "CANADIAN SYLLABICS MWI" },
	{ 0x14AF, "CANADIAN SYLLABICS WEST-CREE MWI" },
	{ 0x14B0, "CANADIAN SYLLABICS MWII" },
	{ 0x14B1, "CANADIAN SYLLABICS WEST-CREE MWII" },
	{ 0x14B2, "CANADIAN SYLLABICS MWO" },
	{ 0x14B3, "CANADIAN SYLLABICS WEST-CREE MWO" },
	{ 0x14B4, "CANADIAN SYLLABICS MWOO" },
	{ 0x14B5, "CANADIAN SYLLABICS WEST-CREE MWOO" },
	{ 0x14B6, "CANADIAN SYLLABICS MWA" },
	{ 0x14B7, "CANADIAN SYLLABICS WEST-CREE MWA" },
	{ 0x14B8, "CANADIAN SYLLABICS MWAA" },
	{ 0x14B9, "CANADIAN SYLLABICS WEST-CREE MWAA" },
	{ 0x14BA, "CANADIAN SYLLABICS NASKAPI MWAA" },
	{ 0x14BB, "CANADIAN SYLLABICS M" },
	{ 0x14BC, "CANADIAN SYLLABICS WEST-CREE M" },
	{ 0x14BD, "CANADIAN SYLLABICS MH" },
	{ 0x14BE, "CANADIAN SYLLABICS ATHAPASCAN M" },
	{ 0x14BF, "CANADIAN SYLLABICS SAYISI M" },
	{ 0x14C0, "CANADIAN SYLLABICS NE" },
	{ 0x14C1, "CANADIAN SYLLABICS NAAI" },
	{ 0x14C2, "CANADIAN SYLLABICS NI" },
	{ 0x14C3, "CANADIAN SYLLABICS NII" },
	{ 0x14C4, "CANADIAN SYLLABICS NO" },
	{ 0x14C5, "CANADIAN SYLLABICS NOO" },
	{ 0x14C6, "CANADIAN SYLLABICS Y-CREE NOO" },
	{ 0x14C7, "CANADIAN SYLLABICS NA" },
	{ 0x14C8, "CANADIAN SYLLABICS NAA" },
	{ 0x14C9, "CANADIAN SYLLABICS NWE" },
	{ 0x14CA, "CANADIAN SYLLABICS WEST-CREE NWE" },
	{ 0x14CB, "CANADIAN SYLLABICS NWA" },
	{ 0x14CC, "CANADIAN SYLLABICS WEST-CREE NWA" },
	{ 0x14CD, "CANADIAN SYLLABICS NWAA" },
	{ 0x14CE, "CANADIAN SYLLABICS WEST-CREE NWAA" },
	{ 0x14CF, "CANADIAN SYLLABICS NASKAPI NWAA" },
	{ 0x14D0, "CANADIAN SYLLABICS N" },
	{ 0x14D1, "CANADIAN SYLLABICS CARRIER NG" },
	{ 0x14D2, "CANADIAN SYLLABICS NH" },
	{ 0x14D3, "CANADIAN SYLLABICS LE" },
	{ 0x14D4, "CANADIAN SYLLABICS LAAI" },
	{ 0x14D5, "CANADIAN SYLLABICS LI" },
	{ 0x14D6, "CANADIAN SYLLABICS LII" },
	{ 0x14D7, "CANADIAN SYLLABICS LO" },
	{ 0x14D8, "CANADIAN SYLLABICS LOO" },
	{ 0x14D9, "CANADIAN SYLLABICS Y-CREE LOO" },
	{ 0x14DA, "CANADIAN SYLLABICS LA" },
	{ 0x14DB, "CANADIAN SYLLABICS LAA" },
	{ 0x14DC, "CANADIAN SYLLABICS LWE" },
	{ 0x14DD, "CANADIAN SYLLABICS WEST-CREE LWE" },
	{ 0x14DE, "CANADIAN SYLLABICS LWI" },
	{ 0x14DF, "CANADIAN SYLLABICS WEST-CREE LWI" },
	{ 0x14E0, "CANADIAN SYLLABICS LWII" },
	{ 0x14E1, "CANADIAN SYLLABICS WEST-CREE LWII" },
	{ 0x14E2, "CANADIAN SYLLABICS LWO" },
	{ 0x14E3, "CANADIAN SYLLABICS WEST-CREE LWO" },
	{ 0x14E4, "CANADIAN SYLLABICS LWOO" },
	{ 0x14E5, "CANADIAN SYLLABICS WEST-CREE LWOO" },
	{ 0x14E6, "CANADIAN SYLLABICS LWA" },
	{ 0x14E7, "CANADIAN SYLLABICS WEST-CREE LWA" },
	{ 0x14E8, "CANADIAN SYLLABICS LWAA" },
	{ 0x14E9, "CANADIAN SYLLABICS WEST-CREE LWAA" },
	{ 0x14EA, "CANADIAN SYLLABICS L" },
	{ 0x14EB, "CANADIAN SYLLABICS WEST-CREE L" },
	{ 0x14EC, "CANADIAN SYLLABICS MEDIAL L" },
	{ 0x14ED, "CANADIAN SYLLABICS SE" },
	{ 0x14EE, "CANADIAN SYLLABICS SAAI" },
	{ 0x14EF, "CANADIAN SYLLABICS SI" },
	{ 0x14F0, "CANADIAN SYLLABICS SII" },
	{ 0x14F1, "CANADIAN SYLLABICS SO" },
	{ 0x14F2, "CANADIAN SYLLABICS SOO" },
	{ 0x14F3, "CANADIAN SYLLABICS Y-CREE SOO" },
	{ 0x14F4, "CANADIAN SYLLABICS SA" },
	{ 0x14F5, "CANADIAN SYLLABICS SAA" },
	{ 0x14F6, "CANADIAN SYLLABICS SWE" },
	{ 0x14F7, "CANADIAN SYLLABICS WEST-CREE SWE" },
	{ 0x14F8, "CANADIAN SYLLABICS SWI" },
	{ 0x14F9, "CANADIAN SYLLABICS WEST-CREE SWI" },
	{ 0x14FA, "CANADIAN SYLLABICS SWII" },
	{ 0x14FB, "CANADIAN SYLLABICS WEST-CREE SWII" },
	{ 0x14FC, "CANADIAN SYLLABICS SWO" },
	{ 0x14FD, "CANADIAN SYLLABICS WEST-CREE SWO" },
	{ 0x14FE, "CANADIAN SYLLABICS SWOO" },
	{ 0x14FF, "CANADIAN SYLLABICS WEST-CREE SWOO" },
	{ 0x1500, "CANADIAN SYLLABICS SWA" },
	{ 0x1501, "CANADIAN SYLLABICS WEST-CREE SWA" },
	{ 0x1502, "CANADIAN SYLLABICS SWAA" },
	{ 0x1503, "CANADIAN SYLLABICS WEST-CREE SWAA" },
	{ 0x1504, "CANADIAN SYLLABICS NASKAPI SWAA" },
	{ 0x1505, "CANADIAN SYLLABICS S" },
	{ 0x1506, "CANADIAN SYLLABICS ATHAPASCAN S" },
	{ 0x1507, "CANADIAN SYLLABICS SW" },
	{ 0x1508, "CANADIAN SYLLABICS BLACKFOOT S" },
	{ 0x1509, "CANADIAN SYLLABICS MOOSE-CREE SK" },
	{ 0x150A, "CANADIAN SYLLABICS NASKAPI SKW" },
	{ 0x150B, "CANADIAN SYLLABICS NASKAPI S-W" },
	{ 0x150C, "CANADIAN SYLLABICS NASKAPI SPWA" },
	{ 0x150D, "CANADIAN SYLLABICS NASKAPI STWA" },
	{ 0x150E, "CANADIAN SYLLABICS NASKAPI SKWA" },
	{ 0x150F, "CANADIAN SYLLABICS NASKAPI SCWA" },
	{ 0x1510, "CANADIAN SYLLABICS SHE" },
	{ 0x1511, "CANADIAN SYLLABICS SHI" },
	{ 0x1512, "CANADIAN SYLLABICS SHII" },
	{ 0x1513, "CANADIAN SYLLABICS SHO" },
	{ 0x1514, "CANADIAN SYLLABICS SHOO" },
	{ 0x1515, "CANADIAN SYLLABICS SHA" },
	{ 0x1516, "CANADIAN SYLLABICS SHAA" },
	{ 0x1517, "CANADIAN SYLLABICS SHWE" },
	{ 0x1518, "CANADIAN SYLLABICS WEST-CREE SHWE" },
	{ 0x1519, "CANADIAN SYLLABICS SHWI" },
	{ 0x151A, "CANADIAN SYLLABICS WEST-CREE SHWI" },
	{ 0x151B, "CANADIAN SYLLABICS SHWII" },
	{ 0x151C, "CANADIAN SYLLABICS WEST-CREE SHWII" },
	{ 0x151D, "CANADIAN SYLLABICS SHWO" },
	{ 0x151E, "CANADIAN SYLLABICS WEST-CREE SHWO" },
	{ 0x151F, "CANADIAN SYLLABICS SHWOO" },
	{ 0x1520, "CANADIAN SYLLABICS WEST-CREE SHWOO" },
	{ 0x1521, "CANADIAN SYLLABICS SHWA" },
	{ 0x1522, "CANADIAN SYLLABICS WEST-CREE SHWA" },
	{ 0x1523, "CANADIAN SYLLABICS SHWAA" },
	{ 0x1524, "CANADIAN SYLLABICS WEST-CREE SHWAA" },
	{ 0x1525, "CANADIAN SYLLABICS SH" },
	{ 0x1526, "CANADIAN SYLLABICS YE" },
	{ 0x1527, "CANADIAN SYLLABICS YAAI" },
	{ 0x1528, "CANADIAN SYLLABICS YI" },
	{ 0x1529, "CANADIAN SYLLABICS YII" },
	{ 0x152A, "CANADIAN SYLLABICS YO" },
	{ 0x152B, "CANADIAN SYLLABICS YOO" },
	{ 0x152C, "CANADIAN SYLLABICS Y-CREE YOO" },
	{ 0x152D, "CANADIAN SYLLABICS YA" },
	{ 0x152E, "CANADIAN SYLLABICS YAA" },
	{ 0x152F, "CANADIAN SYLLABICS YWE" },
	{ 0x1530, "CANADIAN SYLLABICS WEST-CREE YWE" },
	{ 0x1531, "CANADIAN SYLLABICS YWI" },
	{ 0x1532, "CANADIAN SYLLABICS WEST-CREE YWI" },
	{ 0x1533, "CANADIAN SYLLABICS YWII" },
	{ 0x1534, "CANADIAN SYLLABICS WEST-CREE YWII" },
	{ 0x1535, "CANADIAN SYLLABICS YWO" },
	{ 0x1536, "CANADIAN SYLLABICS WEST-CREE YWO" },
	{ 0x1537, "CANADIAN SYLLABICS YWOO" },
	{ 0x1538, "CANADIAN SYLLABICS WEST-CREE YWOO" },
	{ 0x1539, "CANADIAN SYLLABICS YWA" },
	{ 0x153A, "CANADIAN SYLLABICS WEST-CREE YWA" },
	{ 0x153B, "CANADIAN SYLLABICS YWAA" },
	{ 0x153C, "CANADIAN SYLLABICS WEST-CREE YWAA" },
	{ 0x153D, "CANADIAN SYLLABICS NASKAPI YWAA" },
	{ 0x153E, "CANADIAN SYLLABICS Y" },
	{ 0x153F, "CANADIAN SYLLABICS BIBLE-CREE Y" },
	{ 0x1540, "CANADIAN SYLLABICS WEST-CREE Y" },
	{ 0x1541, "CANADIAN SYLLABICS SAYISI YI" },
	{ 0x1542, "CANADIAN SYLLABICS RE" },
	{ 0x1543, "CANADIAN SYLLABICS R-CREE RE" },
	{ 0x1544, "CANADIAN SYLLABICS WEST-CREE LE" },
	{ 0x1545, "CANADIAN SYLLABICS RAAI" },
	{ 0x1546, "CANADIAN SYLLABICS RI" },
	{ 0x1547, "CANADIAN SYLLABICS RII" },
	{ 0x1548, "CANADIAN SYLLABICS RO" },
	{ 0x1549, "CANADIAN SYLLABICS ROO" },
	{ 0x154A, "CANADIAN SYLLABICS WEST-CREE LO" },
	{ 0x154B, "CANADIAN SYLLABICS RA" },
	{ 0x154C, "CANADIAN SYLLABICS RAA" },
	{ 0x154D, "CANADIAN SYLLABICS WEST-CREE LA" },
	{ 0x154E, "CANADIAN SYLLABICS RWAA" },
	{ 0x154F, "CANADIAN SYLLABICS WEST-CREE RWAA" },
	{ 0x1550, "CANADIAN SYLLABICS R" },
	{ 0x1551, "CANADIAN SYLLABICS WEST-CREE R" },
	{ 0x1552, "CANADIAN SYLLABICS MEDIAL R" },
	{ 0x1553, "CANADIAN SYLLABICS FE" },
	{ 0x1554, "CANADIAN SYLLABICS FAAI" },
	{ 0x1555, "CANADIAN SYLLABICS FI" },
	{ 0x1556, "CANADIAN SYLLABICS FII" },
	{ 0x1557, "CANADIAN SYLLABICS FO" },
	{ 0x1558, "CANADIAN SYLLABICS FOO" },
	{ 0x1559, "CANADIAN SYLLABICS FA" },
	{ 0x155A, "CANADIAN SYLLABICS FAA" },
	{ 0x155B, "CANADIAN SYLLABICS FWAA" },
	{ 0x155C, "CANADIAN SYLLABICS WEST-CREE FWAA" },
	{ 0x155D, "CANADIAN SYLLABICS F" },
	{ 0x155E, "CANADIAN SYLLABICS THE" },
	{ 0x155F, "CANADIAN SYLLABICS N-CREE THE" },
	{ 0x1560, "CANADIAN SYLLABICS THI" },
	{ 0x1561, "CANADIAN SYLLABICS N-CREE THI" },
	{ 0x1562, "CANADIAN SYLLABICS THII" },
	{ 0x1563, "CANADIAN SYLLABICS N-CREE THII" },
	{ 0x1564, "CANADIAN SYLLABICS THO" },
	{ 0x1565, "CANADIAN SYLLABICS THOO" },
	{ 0x1566, "CANADIAN SYLLABICS THA" },
	{ 0x1567, "CANADIAN SYLLABICS THAA" },
	{ 0x1568, "CANADIAN SYLLABICS THWAA" },
	{ 0x1569, "CANADIAN SYLLABICS WEST-CREE THWAA" },
	{ 0x156A, "CANADIAN SYLLABICS TH" },
	{ 0x156B, "CANADIAN SYLLABICS TTHE" },
	{ 0x156C, "CANADIAN SYLLABICS TTHI" },
	{ 0x156D, "CANADIAN SYLLABICS TTHO" },
	{ 0x156E, "CANADIAN SYLLABICS TTHA" },
	{ 0x156F, "CANADIAN SYLLABICS TTH" },
	{ 0x1570, "CANADIAN SYLLABICS TYE" },
	{ 0x1571, "CANADIAN SYLLABICS TYI" },
	{ 0x1572, "CANADIAN SYLLABICS TYO" },
	{ 0x1573, "CANADIAN SYLLABICS TYA" },
	{ 0x1574, "CANADIAN SYLLABICS NUNAVIK HE" },
	{ 0x1575, "CANADIAN SYLLABICS NUNAVIK HI" },
	{ 0x1576, "CANADIAN SYLLABICS NUNAVIK HII" },
	{ 0x1577, "CANADIAN SYLLABICS NUNAVIK HO" },
	{ 0x1578, "CANADIAN SYLLABICS NUNAVIK HOO" },
	{ 0x1579, "CANADIAN SYLLABICS NUNAVIK HA" },
	{ 0x157A, "CANADIAN SYLLABICS NUNAVIK HAA" },
	{ 0x157B, "CANADIAN SYLLABICS NUNAVIK H" },
	{ 0x157C, "CANADIAN SYLLABICS NUNAVUT H" },
	{ 0x157D, "CANADIAN SYLLABICS HK" },
	{ 0x157E, "CANADIAN SYLLABICS QAAI" },
	{ 0x157F, "CANADIAN SYLLABICS QI" },
	{ 0x1580, "CANADIAN SYLLABICS QII" },
	{ 0x1581, "CANADIAN SYLLABICS QO" },
	{ 0x1582, "CANADIAN SYLLABICS QOO" },
	{ 0x1583, "CANADIAN SYLLABICS QA" },
	{ 0x1584, "CANADIAN SYLLABICS QAA" },
	{ 0x1585, "CANADIAN SYLLABICS Q" },
	{ 0x1586, "CANADIAN SYLLABICS TLHE" },
	{ 0x1587, "CANADIAN SYLLABICS TLHI" },
	{ 0x1588, "CANADIAN SYLLABICS TLHO" },
	{ 0x1589, "CANADIAN SYLLABICS TLHA" },
	{ 0x158A, "CANADIAN SYLLABICS WEST-CREE RE" },
	{ 0x158B, "CANADIAN SYLLABICS WEST-CREE RI" },
	{ 0x158C, "CANADIAN SYLLABICS WEST-CREE RO" },
	{ 0x158D, "CANADIAN SYLLABICS WEST-CREE RA" },
	{ 0x158E, "CANADIAN SYLLABICS NGAAI" },
	{ 0x158F, "CANADIAN SYLLABICS NGI" },
	{ 0x1590, "CANADIAN SYLLABICS NGII" },
	{ 0x1591, "CANADIAN SYLLABICS NGO" },
	{ 0x1592, "CANADIAN SYLLABICS NGOO" },
	{ 0x1593, "CANADIAN SYLLABICS NGA" },
	{ 0x1594, "CANADIAN SYLLABICS NGAA" },
	{ 0x1595, "CANADIAN SYLLABICS NG" },
	{ 0x1596, "CANADIAN SYLLABICS NNG" },
	{ 0x1597, "CANADIAN SYLLABICS SAYISI SHE" },
	{ 0x1598, "CANADIAN SYLLABICS SAYISI SHI" },
	{ 0x1599, "CANADIAN SYLLABICS SAYISI SHO" },
	{ 0x159A, "CANADIAN SYLLABICS SAYISI SHA" },
	{ 0x159B, "CANADIAN SYLLABICS WOODS-CREE THE" },
	{ 0x159C, "CANADIAN SYLLABICS WOODS-CREE THI" },
	{ 0x159D, "CANADIAN SYLLABICS WOODS-CREE THO" },
	{ 0x159E, "CANADIAN SYLLABICS WOODS-CREE THA" },
	{ 0x159F, "CANADIAN SYLLABICS WOODS-CREE TH" },
	{ 0x15A0, "CANADIAN SYLLABICS LHI" },
	{ 0x15A1, "CANADIAN SYLLABICS LHII" },
	{ 0x15A2, "CANADIAN SYLLABICS LHO" },
	{ 0x15A3, "CANADIAN SYLLABICS LHOO" },
	{ 0x15A4, "CANADIAN SYLLABICS LHA" },
	{ 0x15A5, "CANADIAN SYLLABICS LHAA" },
	{ 0x15A6, "CANADIAN SYLLABICS LH" },
	{ 0x15A7, "CANADIAN SYLLABICS TH-CREE THE" },
	{ 0x15A8, "CANADIAN SYLLABICS TH-CREE THI" },
	{ 0x15A9, "CANADIAN SYLLABICS TH-CREE THII" },
	{ 0x15AA, "CANADIAN SYLLABICS TH-CREE THO" },
	{ 0x15AB, "CANADIAN SYLLABICS TH-CREE THOO" },
	{ 0x15AC, "CANADIAN SYLLABICS TH-CREE THA" },
	{ 0x15AD, "CANADIAN SYLLABICS TH-CREE THAA" },
	{ 0x15AE, "CANADIAN SYLLABICS TH-CREE TH" },
	{ 0x15AF, "CANADIAN SYLLABICS AIVILIK B" },
	{ 0x15B0, "CANADIAN SYLLABICS BLACKFOOT E" },
	{ 0x15B1, "CANADIAN SYLLABICS BLACKFOOT I" },
	{ 0x15B2, "CANADIAN SYLLABICS BLACKFOOT O" },
	{ 0x15B3, "CANADIAN SYLLABICS BLACKFOOT A" },
	{ 0x15B4, "CANADIAN SYLLABICS BLACKFOOT WE" },
	{ 0x15B5, "CANADIAN SYLLABICS BLACKFOOT WI" },
	{ 0x15B6, "CANADIAN SYLLABICS BLACKFOOT WO" },
	{ 0x15B7, "CANADIAN SYLLABICS BLACKFOOT WA" },
	{ 0x15B8, "CANADIAN SYLLABICS BLACKFOOT NE" },
	{ 0x15B9, "CANADIAN SYLLABICS BLACKFOOT NI" },
	{ 0x15BA, "CANADIAN SYLLABICS BLACKFOOT NO" },
	{ 0x15BB, "CANADIAN SYLLABICS BLACKFOOT NA" },
	{ 0x15BC, "CANADIAN SYLLABICS BLACKFOOT KE" },
	{ 0x15BD, "CANADIAN SYLLABICS BLACKFOOT KI" },
	{ 0x15BE, "CANADIAN SYLLABICS BLACKFOOT KO" },
	{ 0x15BF, "CANADIAN SYLLABICS BLACKFOOT KA" },
	{ 0x15C0, "CANADIAN SYLLABICS SAYISI HE" },
	{ 0x15C1, "CANADIAN SYLLABICS SAYISI HI" },
	{ 0x15C2, "CANADIAN SYLLABICS SAYISI HO" },
	{ 0x15C3, "CANADIAN SYLLABICS SAYISI HA" },
	{ 0x15C4, "CANADIAN SYLLABICS CARRIER GHU" },
	{ 0x15C5, "CANADIAN SYLLABICS CARRIER GHO" },
	{ 0x15C6, "CANADIAN SYLLABICS CARRIER GHE" },
	{ 0x15C7, "CANADIAN SYLLABICS CARRIER GHEE" },
	{ 0x15C8, "CANADIAN SYLLABICS CARRIER GHI" },
	{ 0x15C9, "CANADIAN SYLLABICS CARRIER GHA" },
	{ 0x15CA, "CANADIAN SYLLABICS CARRIER RU" },
	{ 0x15CB, "CANADIAN SYLLABICS CARRIER RO" },
	{ 0x15CC, "CANADIAN SYLLABICS CARRIER RE" },
	{ 0x15CD, "CANADIAN SYLLABICS CARRIER REE" },
	{ 0x15CE, "CANADIAN SYLLABICS CARRIER RI" },
	{ 0x15CF, "CANADIAN SYLLABICS CARRIER RA" },
	{ 0x15D0, "CANADIAN SYLLABICS CARRIER WU" },
	{ 0x15D1, "CANADIAN SYLLABICS CARRIER WO" },
	{ 0x15D2, "CANADIAN SYLLABICS CARRIER WE" },
	{ 0x15D3, "CANADIAN SYLLABICS CARRIER WEE" },
	{ 0x15D4, "CANADIAN SYLLABICS CARRIER WI" },
	{ 0x15D5, "CANADIAN SYLLABICS CARRIER WA" },
	{ 0x15D6, "CANADIAN SYLLABICS CARRIER HWU" },
	{ 0x15D7, "CANADIAN SYLLABICS CARRIER HWO" },
	{ 0x15D8, "CANADIAN SYLLABICS CARRIER HWE" },
	{ 0x15D9, "CANADIAN SYLLABICS CARRIER HWEE" },
	{ 0x15DA, "CANADIAN SYLLABICS CARRIER HWI" },
	{ 0x15DB, "CANADIAN SYLLABICS CARRIER HWA" },
	{ 0x15DC, "CANADIAN SYLLABICS CARRIER THU" },
	{ 0x15DD, "CANADIAN SYLLABICS CARRIER THO" },
	{ 0x15DE, "CANADIAN SYLLABICS CARRIER THE" },
	{ 0x15DF, "CANADIAN SYLLABICS CARRIER THEE" },
	{ 0x15E0, "CANADIAN SYLLABICS CARRIER THI" },
	{ 0x15E1, "CANADIAN SYLLABICS CARRIER THA" },
	{ 0x15E2, "CANADIAN SYLLABICS CARRIER TTU" },
	{ 0x15E3, "CANADIAN SYLLABICS CARRIER TTO" },
	{ 0x15E4, "CANADIAN SYLLABICS CARRIER TTE" },
	{ 0x15E5, "CANADIAN SYLLABICS CARRIER TTEE" },
	{ 0x15E6, "CANADIAN SYLLABICS CARRIER TTI" },
	{ 0x15E7, "CANADIAN SYLLABICS CARRIER TTA" },
	{ 0x15E8, "CANADIAN SYLLABICS CARRIER PU" },
	{ 0x15E9, "CANADIAN SYLLABICS CARRIER PO" },
	{ 0x15EA, "CANADIAN SYLLABICS CARRIER PE" },
	{ 0x15EB, "CANADIAN SYLLABICS CARRIER PEE" },
	{ 0x15EC, "CANADIAN SYLLABICS CARRIER PI" },
	{ 0x15ED, "CANADIAN SYLLABICS CARRIER PA" },
	{ 0x15EE, "CANADIAN SYLLABICS CARRIER P" },
	{ 0x15EF, "CANADIAN SYLLABICS CARRIER GU" },
	{ 0x15F0, "CANADIAN SYLLABICS CARRIER GO" },
	{ 0x15F1, "CANADIAN SYLLABICS CARRIER GE" },
	{ 0x15F2, "CANADIAN SYLLABICS CARRIER GEE" },
	{ 0x15F3, "CANADIAN SYLLABICS CARRIER GI" },
	{ 0x15F4, "CANADIAN SYLLABICS CARRIER GA" },
	{ 0x15F5, "CANADIAN SYLLABICS CARRIER KHU" },
	{ 0x15F6, "CANADIAN SYLLABICS CARRIER KHO" },
	{ 0x15F7, "CANADIAN SYLLABICS CARRIER KHE" },
	{ 0x15F8, "CANADIAN SYLLABICS CARRIER KHEE" },
	{ 0x15F9, "CANADIAN SYLLABICS CARRIER KHI" },
	{ 0x15FA, "CANADIAN SYLLABICS CARRIER KHA" },
	{ 0x15FB, "CANADIAN SYLLABICS CARRIER KKU" },
	{ 0x15FC, "CANADIAN SYLLABICS CARRIER KKO" },
	{ 0x15FD, "CANADIAN SYLLABICS CARRIER KKE" },
	{ 0x15FE, "CANADIAN SYLLABICS CARRIER KKEE" },
	{ 0x15FF, "CANADIAN SYLLABICS CARRIER KKI" },
	{ 0x1600, "CANADIAN SYLLABICS CARRIER KKA" },
	{ 0x1601, "CANADIAN SYLLABICS CARRIER KK" },
	{ 0x1602, "CANADIAN SYLLABICS CARRIER NU" },
	{ 0x1603, "CANADIAN SYLLABICS CARRIER NO" },
	{ 0x1604, "CANADIAN SYLLABICS CARRIER NE" },
	{ 0x1605, "CANADIAN SYLLABICS CARRIER NEE" },
	{ 0x1606, "CANADIAN SYLLABICS CARRIER NI" },
	{ 0x1607, "CANADIAN SYLLABICS CARRIER NA" },
	{ 0x1608, "CANADIAN SYLLABICS CARRIER MU" },
	{ 0x1609, "CANADIAN SYLLABICS CARRIER MO" },
	{ 0x160A, "CANADIAN SYLLABICS CARRIER ME" },
	{ 0x160B, "CANADIAN SYLLABICS CARRIER MEE" },
	{ 0x160C, "CANADIAN SYLLABICS CARRIER MI" },
	{ 0x160D, "CANADIAN SYLLABICS CARRIER MA" },
	{ 0x160E, "CANADIAN SYLLABICS CARRIER YU" },
	{ 0x160F, "CANADIAN SYLLABICS CARRIER YO" },
	{ 0x1610, "CANADIAN SYLLABICS CARRIER YE" },
	{ 0x1611, "CANADIAN SYLLABICS CARRIER YEE" },
	{ 0x1612, "CANADIAN SYLLABICS CARRIER YI" },
	{ 0x1613, "CANADIAN SYLLABICS CARRIER YA" },
	{ 0x1614, "CANADIAN SYLLABICS CARRIER JU" },
	{ 0x1615, "CANADIAN SYLLABICS SAYISI JU" },
	{ 0x1616, "CANADIAN SYLLABICS CARRIER JO" },
	{ 0x1617, "CANADIAN SYLLABICS CARRIER JE" },
	{ 0x1618, "CANADIAN SYLLABICS CARRIER JEE" },
	{ 0x1619, "CANADIAN SYLLABICS CARRIER JI" },
	{ 0x161A, "CANADIAN SYLLABICS SAYISI JI" },
	{ 0x161B, "CANADIAN SYLLABICS CARRIER JA" },
	{ 0x161C, "CANADIAN SYLLABICS CARRIER JJU" },
	{ 0x161D, "CANADIAN SYLLABICS CARRIER JJO" },
	{ 0x161E, "CANADIAN SYLLABICS CARRIER JJE" },
	{ 0x161F, "CANADIAN SYLLABICS CARRIER JJEE" },
	{ 0x1620, "CANADIAN SYLLABICS CARRIER JJI" },
	{ 0x1621, "CANADIAN SYLLABICS CARRIER JJA" },
	{ 0x1622, "CANADIAN SYLLABICS CARRIER LU" },
	{ 0x1623, "CANADIAN SYLLABICS CARRIER LO" },
	{ 0x1624, "CANADIAN SYLLABICS CARRIER LE" },
	{ 0x1625, "CANADIAN SYLLABICS CARRIER LEE" },
	{ 0x1626, "CANADIAN SYLLABICS CARRIER LI" },
	{ 0x1627, "CANADIAN SYLLABICS CARRIER LA" },
	{ 0x1628, "CANADIAN SYLLABICS CARRIER DLU" },
	{ 0x1629, "CANADIAN SYLLABICS CARRIER DLO" },
	{ 0x162A, "CANADIAN SYLLABICS CARRIER DLE" },
	{ 0x162B, "CANADIAN SYLLABICS CARRIER DLEE" },
	{ 0x162C, "CANADIAN SYLLABICS CARRIER DLI" },
	{ 0x162D, "CANADIAN SYLLABICS CARRIER DLA" },
	{ 0x162E, "CANADIAN SYLLABICS CARRIER LHU" },
	{ 0x162F, "CANADIAN SYLLABICS CARRIER LHO" },
	{ 0x1630, "CANADIAN SYLLABICS CARRIER LHE" },
	{ 0x1631, "CANADIAN SYLLABICS CARRIER LHEE" },
	{ 0x1632, "CANADIAN SYLLABICS CARRIER LHI" },
	{ 0x1633, "CANADIAN SYLLABICS CARRIER LHA" },
	{ 0x1634, "CANADIAN SYLLABICS CARRIER TLHU" },
	{ 0x1635, "CANADIAN SYLLABICS CARRIER TLHO" },
	{ 0x1636, "CANADIAN SYLLABICS CARRIER TLHE" },
	{ 0x1637, "CANADIAN SYLLABICS CARRIER TLHEE" },
	{ 0x1638, "CANADIAN SYLLABICS CARRIER TLHI" },
	{ 0x1639, "CANADIAN SYLLABICS CARRIER TLHA" },
	{ 0x163A, "CANADIAN SYLLABICS CARRIER TLU" },
	{ 0x163B, "CANADIAN SYLLABICS CARRIER TLO" },
	{ 0x163C, "CANADIAN SYLLABICS CARRIER TLE" },
	{ 0x163D, "CANADIAN SYLLABICS CARRIER TLEE" },
	{ 0x163E, "CANADIAN SYLLABICS CARRIER TLI" },
	{ 0x163F, "CANADIAN SYLLABICS CARRIER TLA" },
	{ 0x1640, "CANADIAN SYLLABICS CARRIER ZU" },
	{ 0x1641, "CANADIAN SYLLABICS CARRIER ZO" },
	{ 0x1642, "CANADIAN SYLLABICS CARRIER ZE" },
	{ 0x1643, "CANADIAN SYLLABICS CARRIER ZEE" },
	{ 0x1644, "CANADIAN SYLLABICS CARRIER ZI" },
	{ 0x1645, "CANADIAN SYLLABICS CARRIER ZA" },
	{ 0x1646, "CANADIAN SYLLABICS CARRIER Z" },
	{ 0x1647, "CANADIAN SYLLABICS CARRIER INITIAL Z" },
	{ 0x1648, "CANADIAN SYLLABICS CARRIER DZU" },
	{ 0x1649, "CANADIAN SYLLABICS CARRIER DZO" },
	{ 0x164A, "CANADIAN SYLLABICS CARRIER DZE" },
	{ 0x164B, "CANADIAN SYLLABICS CARRIER DZEE" },
	{ 0x164C, "CANADIAN SYLLABICS CARRIER DZI" },
	{ 0x164D, "CANADIAN SYLLABICS CARRIER DZA" },
	{ 0x164E, "CANADIAN SYLLABICS CARRIER SU" },
	{ 0x164F, "CANADIAN SYLLABICS CARRIER SO" },
	{ 0x1650, "CANADIAN SYLLABICS CARRIER SE" },
	{ 0x1651, "CANADIAN SYLLABICS CARRIER SEE" },
	{ 0x1652, "CANADIAN SYLLABICS CARRIER SI" },
	{ 0x1653, "CANADIAN SYLLABICS CARRIER SA" },
	{ 0x1654, "CANADIAN SYLLABICS CARRIER SHU" },
	{ 0x1655, "CANADIAN SYLLABICS CARRIER SHO" },
	{ 0x1656, "CANADIAN SYLLABICS CARRIER SHE" },
	{ 0x1657, "CANADIAN SYLLABICS CARRIER SHEE" },
	{ 0x1658, "CANADIAN SYLLABICS CARRIER SHI" },
	{ 0x1659, "CANADIAN SYLLABICS CARRIER SHA" },
	{ 0x165A, "CANADIAN SYLLABICS CARRIER SH" },
	{ 0x165B, "CANADIAN SYLLABICS CARRIER TSU" },
	{ 0x165C, "CANADIAN SYLLABICS CARRIER TSO" },
	{ 0x165D, "CANADIAN SYLLABICS CARRIER TSE" },
	{ 0x165E, "CANADIAN SYLLABICS CARRIER TSEE" },
	{ 0x165F, "CANADIAN SYLLABICS CARRIER TSI" },
	{ 0x1660, "CANADIAN SYLLABICS CARRIER TSA" },
	{ 0x1661, "CANADIAN SYLLABICS CARRIER CHU" },
	{ 0x1662, "CANADIAN SYLLABICS CARRIER CHO" },
	{ 0x1663, "CANADIAN SYLLABICS CARRIER CHE" },
	{ 0x1664, "CANADIAN SYLLABICS CARRIER CHEE" },
	{ 0x1665, "CANADIAN SYLLABICS CARRIER CHI" },
	{ 0x1666, "CANADIAN SYLLABICS CARRIER CHA" },
	{ 0x1667, "CANADIAN SYLLABICS CARRIER TTSU" },
	{ 0x1668, "CANADIAN SYLLABICS CARRIER TTSO" },
	{ 0x1669, "CANADIAN SYLLABICS CARRIER TTSE" },
	{ 0x166A, "CANADIAN SYLLABICS CARRIER TTSEE" },
	{ 0x166B, "CANADIAN SYLLABICS CARRIER TTSI" },
	{ 0x166C, "CANADIAN SYLLABICS CARRIER TTSA" },
	{ 0x166D, "CANADIAN SYLLABICS CHI SIGN" },
	{ 0x166E, "CANADIAN SYLLABICS FULL STOP" },
	{ 0x166F, "CANADIAN SYLLABICS QAI" },
	{ 0x1670, "CANADIAN SYLLABICS NGAI" },
	{ 0x1671, "CANADIAN SYLLABICS NNGI" },
	{ 0x1672, "CANADIAN SYLLABICS NNGII" },
	{ 0x1673, "CANADIAN SYLLABICS NNGO" },
	{ 0x1674, "CANADIAN SYLLABICS NNGOO" },
	{ 0x1675, "CANADIAN SYLLABICS NNGA" },
	{ 0x1676, "CANADIAN SYLLABICS NNGAA" },
	{ 0x1680, "OGHAM SPACE MARK" },
	{ 0x1681, "OGHAM LETTER BEITH" },
	{ 0x1682, "OGHAM LETTER LUIS" },
	{ 0x1683, "OGHAM LETTER FEARN" },
	{ 0x1684, "OGHAM LETTER SAIL" },
	{ 0x1685, "OGHAM LETTER NION" },
	{ 0x1686, "OGHAM LETTER UATH" },
	{ 0x1687, "OGHAM LETTER DAIR" },
	{ 0x1688, "OGHAM LETTER TINNE" },
	{ 0x1689, "OGHAM LETTER COLL" },
	{ 0x168A, "OGHAM LETTER CEIRT" },
	{ 0x168B, "OGHAM LETTER MUIN" },
	{ 0x168C, "OGHAM LETTER GORT" },
	{ 0x168D, "OGHAM LETTER NGEADAL" },
	{ 0x168E, "OGHAM LETTER STRAIF" },
	{ 0x168F, "OGHAM LETTER RUIS" },
	{ 0x1690, "OGHAM LETTER AILM" },
	{ 0x1691, "OGHAM LETTER ONN" },
	{ 0x1692, "OGHAM LETTER UR" },
	{ 0x1693, "OGHAM LETTER EADHADH" },
	{ 0x1694, "OGHAM LETTER IODHADH" },
	{ 0x1695, "OGHAM LETTER EABHADH" },
	{ 0x1696, "OGHAM LETTER OR" },
	{ 0x1697, "OGHAM LETTER UILLEANN" },
	{ 0x1698, "OGHAM LETTER IFIN" },
	{ 0x1699, "OGHAM LETTER EAMHANCHOLL" },
	{ 0x169A, "OGHAM LETTER PEITH" },
	{ 0x169B, "OGHAM FEATHER MARK" },
	{ 0x169C, "OGHAM REVERSED FEATHER MARK" },
	{ 0x16A0, "RUNIC LETTER FEHU FEOH FE F" },
	{ 0x16A1, "RUNIC LETTER V" },
	{ 0x16A2, "RUNIC LETTER URUZ UR U" },
	{ 0x16A3, "RUNIC LETTER YR" },
	{ 0x16A4, "RUNIC LETTER Y" },
	{ 0x16A5, "RUNIC LETTER W" },
	{ 0x16A6, "RUNIC LETTER THURISAZ THURS THORN" },
	{ 0x16A7, "RUNIC LETTER ETH" },
	{ 0x16A8, "RUNIC LETTER ANSUZ A" },
	{ 0x16A9, "RUNIC LETTER OS O" },
	{ 0x16AA, "RUNIC LETTER AC A" },
	{ 0x16AB, "RUNIC LETTER AESC" },
	{ 0x16AC, "RUNIC LETTER LONG-BRANCH-OSS O" },
	{ 0x16AD, "RUNIC LETTER SHORT-TWIG-OSS O" },
	{ 0x16AE, "RUNIC LETTER O" },
	{ 0x16AF, "RUNIC LETTER OE" },
	{ 0x16B0, "RUNIC LETTER ON" },
	{ 0x16B1, "RUNIC LETTER RAIDO RAD REID R" },
	{ 0x16B2, "RUNIC LETTER KAUNA" },
	{ 0x16B3, "RUNIC LETTER CEN" },
	{ 0x16B4, "RUNIC LETTER KAUN K" },
	{ 0x16B5, "RUNIC LETTER G" },
	{ 0x16B6, "RUNIC LETTER ENG" },
	{ 0x16B7, "RUNIC LETTER GEBO GYFU G" },
	{ 0x16B8, "RUNIC LETTER GAR" },
	{ 0x16B9, "RUNIC LETTER WUNJO WYNN W" },
	{ 0x16BA, "RUNIC LETTER HAGLAZ H" },
	{ 0x16BB, "RUNIC LETTER HAEGL H" },
	{ 0x16BC, "RUNIC LETTER LONG-BRANCH-HAGALL H" },
	{ 0x16BD, "RUNIC LETTER SHORT-TWIG-HAGALL H" },
	{ 0x16BE, "RUNIC LETTER NAUDIZ NYD NAUD N" },
	{ 0x16BF, "RUNIC LETTER SHORT-TWIG-NAUD N" },
	{ 0x16C0, "RUNIC LETTER DOTTED-N" },
	{ 0x16C1, "RUNIC LETTER ISAZ IS ISS I" },
	{ 0x16C2, "RUNIC LETTER E" },
	{ 0x16C3, "RUNIC LETTER JERAN J" },
	{ 0x16C4, "RUNIC LETTER GER" },
	{ 0x16C5, "RUNIC LETTER LONG-BRANCH-AR AE" },
	{ 0x16C6, "RUNIC LETTER SHORT-TWIG-AR A" },
	{ 0x16C7, "RUNIC LETTER IWAZ EOH" },
	{ 0x16C8, "RUNIC LETTER PERTHO PEORTH P" },
	{ 0x16C9, "RUNIC LETTER ALGIZ EOLHX" },
	{ 0x16CA, "RUNIC LETTER SOWILO S" },
	{ 0x16CB, "RUNIC LETTER SIGEL LONG-BRANCH-SOL S" },
	{ 0x16CC, "RUNIC LETTER SHORT-TWIG-SOL S" },
	{ 0x16CD, "RUNIC LETTER C" },
	{ 0x16CE, "RUNIC LETTER Z" },
	{ 0x16CF, "RUNIC LETTER TIWAZ TIR TYR T" },
	{ 0x16D0, "RUNIC LETTER SHORT-TWIG-TYR T" },
	{ 0x16D1, "RUNIC LETTER D" },
	{ 0x16D2, "RUNIC LETTER BERKANAN BEORC BJARKAN B" },
	{ 0x16D3, "RUNIC LETTER SHORT-TWIG-BJARKAN B" },
	{ 0x16D4, "RUNIC LETTER DOTTED-P" },
	{ 0x16D5, "RUNIC LETTER OPEN-P" },
	{ 0x16D6, "RUNIC LETTER EHWAZ EH E" },
	{ 0x16D7, "RUNIC LETTER MANNAZ MAN M" },
	{ 0x16D8, "RUNIC LETTER LONG-BRANCH-MADR M" },
	{ 0x16D9, "RUNIC LETTER SHORT-TWIG-MADR M" },
	{ 0x16DA, "RUNIC LETTER LAUKAZ LAGU LOGR L" },
	{ 0x16DB, "RUNIC LETTER DOTTED-L" },
	{ 0x16DC, "RUNIC LETTER INGWAZ" },
	{ 0x16DD, "RUNIC LETTER ING" },
	{ 0x16DE, "RUNIC LETTER DAGAZ DAEG D" },
	{ 0x16DF, "RUNIC LETTER OTHALAN ETHEL O" },
	{ 0x16E0, "RUNIC LETTER EAR" },
	{ 0x16E1, "RUNIC LETTER IOR" },
	{ 0x16E2, "RUNIC LETTER CWEORTH" },
	{ 0x16E3, "RUNIC LETTER CALC" },
	{ 0x16E4, "RUNIC LETTER CEALC" },
	{ 0x16E5, "RUNIC LETTER STAN" },
	{ 0x16E6, "RUNIC LETTER LONG-BRANCH-YR" },
	{ 0x16E7, "RUNIC LETTER SHORT-TWIG-YR" },
	{ 0x16E8, "RUNIC LETTER ICELANDIC-YR" },
	{ 0x16E9, "RUNIC LETTER Q" },
	{ 0x16EA, "RUNIC LETTER X" },
	{ 0x16EB, "RUNIC SINGLE PUNCTUATION" },
	{ 0x16EC, "RUNIC MULTIPLE PUNCTUATION" },
	{ 0x16ED, "RUNIC CROSS PUNCTUATION" },
	{ 0x16EE, "RUNIC ARLAUG SYMBOL" },	/* golden number 17 */
	{ 0x16EF, "RUNIC TVIMADUR SYMBOL" },	/* golden number 18 */
	{ 0x16F0, "RUNIC BELGTHOR SYMBOL" },	/* golden number 19 */
	{ 0x1780, "KHMER LETTER KA" },
	{ 0x1781, "KHMER LETTER KHA" },
	{ 0x1782, "KHMER LETTER KO" },
	{ 0x1783, "KHMER LETTER KHO" },
	{ 0x1784, "KHMER LETTER NGO" },
	{ 0x1785, "KHMER LETTER CA" },
	{ 0x1786, "KHMER LETTER CHA" },
	{ 0x1787, "KHMER LETTER CO" },
	{ 0x1788, "KHMER LETTER CHO" },
	{ 0x1789, "KHMER LETTER NYO" },
	{ 0x178A, "KHMER LETTER DA" },
	{ 0x178B, "KHMER LETTER TTHA" },
	{ 0x178C, "KHMER LETTER DO" },
	{ 0x178D, "KHMER LETTER TTHO" },
	{ 0x178E, "KHMER LETTER NNO" },
	{ 0x178F, "KHMER LETTER TA" },
	{ 0x1790, "KHMER LETTER THA" },
	{ 0x1791, "KHMER LETTER TO" },
	{ 0x1792, "KHMER LETTER THO" },
	{ 0x1793, "KHMER LETTER NO" },
	{ 0x1794, "KHMER LETTER BA" },
	{ 0x1795, "KHMER LETTER PHA" },
	{ 0x1796, "KHMER LETTER PO" },
	{ 0x1797, "KHMER LETTER PHO" },
	{ 0x1798, "KHMER LETTER MO" },
	{ 0x1799, "KHMER LETTER YO" },
	{ 0x179A, "KHMER LETTER RO" },
	{ 0x179B, "KHMER LETTER LO" },
	{ 0x179C, "KHMER LETTER VO" },
	{ 0x179D, "KHMER LETTER SHA" },
	{ 0x179E, "KHMER LETTER SSO" },
	{ 0x179F, "KHMER LETTER SA" },
	{ 0x17A0, "KHMER LETTER HA" },
	{ 0x17A1, "KHMER LETTER LA" },
	{ 0x17A2, "KHMER LETTER QA" },
	{ 0x17A3, "KHMER INDEPENDENT VOWEL QAQ" },
	{ 0x17A4, "KHMER INDEPENDENT VOWEL QAA" },
	{ 0x17A5, "KHMER INDEPENDENT VOWEL QI" },
	{ 0x17A6, "KHMER INDEPENDENT VOWEL QII" },
	{ 0x17A7, "KHMER INDEPENDENT VOWEL QU" },
	{ 0x17A8, "KHMER INDEPENDENT VOWEL QUK" },
	{ 0x17A9, "KHMER INDEPENDENT VOWEL QUU" },
	{ 0x17AA, "KHMER INDEPENDENT VOWEL QUUV" },
	{ 0x17AB, "KHMER INDEPENDENT VOWEL RY" },
	{ 0x17AC, "KHMER INDEPENDENT VOWEL RYY" },
	{ 0x17AD, "KHMER INDEPENDENT VOWEL LY" },
	{ 0x17AE, "KHMER INDEPENDENT VOWEL LYY" },
	{ 0x17AF, "KHMER INDEPENDENT VOWEL QE" },
	{ 0x17B0, "KHMER INDEPENDENT VOWEL QAI" },
	{ 0x17B1, "KHMER INDEPENDENT VOWEL QOO TYPE ONE" },
	{ 0x17B2, "KHMER INDEPENDENT VOWEL QOO TYPE TWO" },
	{ 0x17B3, "KHMER INDEPENDENT VOWEL QAU" },
	{ 0x17B4, "KHMER VOWEL INHERENT AQ" },
	{ 0x17B5, "KHMER VOWEL INHERENT AA" },
	{ 0x17B6, "KHMER VOWEL SIGN AA" },
	{ 0x17B7, "KHMER VOWEL SIGN I" },
	{ 0x17B8, "KHMER VOWEL SIGN II" },
	{ 0x17B9, "KHMER VOWEL SIGN Y" },
	{ 0x17BA, "KHMER VOWEL SIGN YY" },
	{ 0x17BB, "KHMER VOWEL SIGN U" },
	{ 0x17BC, "KHMER VOWEL SIGN UU" },
	{ 0x17BD, "KHMER VOWEL SIGN UA" },
	{ 0x17BE, "KHMER VOWEL SIGN OE" },
	{ 0x17BF, "KHMER VOWEL SIGN YA" },
	{ 0x17C0, "KHMER VOWEL SIGN IE" },
	{ 0x17C1, "KHMER VOWEL SIGN E" },
	{ 0x17C2, "KHMER VOWEL SIGN AE" },
	{ 0x17C3, "KHMER VOWEL SIGN AI" },
	{ 0x17C4, "KHMER VOWEL SIGN OO" },
	{ 0x17C5, "KHMER VOWEL SIGN AU" },
	{ 0x17C6, "KHMER SIGN NIKAHIT" },
	{ 0x17C7, "KHMER SIGN REAHMUK" },
	{ 0x17C8, "KHMER SIGN YUUKALEAPINTU" },
	{ 0x17C9, "KHMER SIGN MUUSIKATOAN" },
	{ 0x17CA, "KHMER SIGN TRIISAP" },
	{ 0x17CB, "KHMER SIGN BANTOC" },
	{ 0x17CC, "KHMER SIGN ROBAT" },
	{ 0x17CD, "KHMER SIGN TOANDAKHIAT" },
	{ 0x17CE, "KHMER SIGN KAKABAT" },
	{ 0x17CF, "KHMER SIGN AHSDA" },
	{ 0x17D0, "KHMER SIGN SAMYOK SANNYA" },
	{ 0x17D1, "KHMER SIGN VIRIAM" },
	{ 0x17D2, "KHMER SIGN COENG" },
	{ 0x17D3, "KHMER SIGN BATHAMASAT" },
	{ 0x17D4, "KHMER SIGN KHAN" },
	{ 0x17D5, "KHMER SIGN BARIYOOSAN" },
	{ 0x17D6, "KHMER SIGN CAMNUC PII KUUH" },
	{ 0x17D7, "KHMER SIGN LEK TOO" },
	{ 0x17D8, "KHMER SIGN BEYYAL" },
	{ 0x17D9, "KHMER SIGN PHNAEK MUAN" },
	{ 0x17DA, "KHMER SIGN KOOMUUT" },
	{ 0x17DB, "KHMER CURRENCY SYMBOL RIEL" },
	{ 0x17DC, "KHMER SIGN AVAKRAHASANYA" },
	{ 0x17E0, "KHMER DIGIT ZERO" },
	{ 0x17E1, "KHMER DIGIT ONE" },
	{ 0x17E2, "KHMER DIGIT TWO" },
	{ 0x17E3, "KHMER DIGIT THREE" },
	{ 0x17E4, "KHMER DIGIT FOUR" },
	{ 0x17E5, "KHMER DIGIT FIVE" },
	{ 0x17E6, "KHMER DIGIT SIX" },
	{ 0x17E7, "KHMER DIGIT SEVEN" },
	{ 0x17E8, "KHMER DIGIT EIGHT" },
	{ 0x17E9, "KHMER DIGIT NINE" },
	{ 0x1800, "MONGOLIAN BIRGA" },
	{ 0x1801, "MONGOLIAN ELLIPSIS" },
	{ 0x1802, "MONGOLIAN COMMA" },
	{ 0x1803, "MONGOLIAN FULL STOP" },
	{ 0x1804, "MONGOLIAN COLON" },
	{ 0x1805, "MONGOLIAN FOUR DOTS" },
	{ 0x1806, "MONGOLIAN TODO SOFT HYPHEN" },
	{ 0x1807, "MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER" },
	{ 0x1808, "MONGOLIAN MANCHU COMMA" },
	{ 0x1809, "MONGOLIAN MANCHU FULL STOP" },
	{ 0x180A, "MONGOLIAN NIRUGU" },
	{ 0x180B, "MONGOLIAN FREE VARIATION SELECTOR ONE" },
	{ 0x180C, "MONGOLIAN FREE VARIATION SELECTOR TWO" },
	{ 0x180D, "MONGOLIAN FREE VARIATION SELECTOR THREE" },
	{ 0x180E, "MONGOLIAN VOWEL SEPARATOR" },
	{ 0x1810, "MONGOLIAN DIGIT ZERO" },
	{ 0x1811, "MONGOLIAN DIGIT ONE" },
	{ 0x1812, "MONGOLIAN DIGIT TWO" },
	{ 0x1813, "MONGOLIAN DIGIT THREE" },
	{ 0x1814, "MONGOLIAN DIGIT FOUR" },
	{ 0x1815, "MONGOLIAN DIGIT FIVE" },
	{ 0x1816, "MONGOLIAN DIGIT SIX" },
	{ 0x1817, "MONGOLIAN DIGIT SEVEN" },
	{ 0x1818, "MONGOLIAN DIGIT EIGHT" },
	{ 0x1819, "MONGOLIAN DIGIT NINE" },
	{ 0x1820, "MONGOLIAN LETTER A" },
	{ 0x1821, "MONGOLIAN LETTER E" },
	{ 0x1822, "MONGOLIAN LETTER I" },
	{ 0x1823, "MONGOLIAN LETTER O" },
	{ 0x1824, "MONGOLIAN LETTER U" },
	{ 0x1825, "MONGOLIAN LETTER OE" },
	{ 0x1826, "MONGOLIAN LETTER UE" },
	{ 0x1827, "MONGOLIAN LETTER EE" },
	{ 0x1828, "MONGOLIAN LETTER NA" },
	{ 0x1829, "MONGOLIAN LETTER ANG" },
	{ 0x182A, "MONGOLIAN LETTER BA" },
	{ 0x182B, "MONGOLIAN LETTER PA" },
	{ 0x182C, "MONGOLIAN LETTER QA" },
	{ 0x182D, "MONGOLIAN LETTER GA" },
	{ 0x182E, "MONGOLIAN LETTER MA" },
	{ 0x182F, "MONGOLIAN LETTER LA" },
	{ 0x1830, "MONGOLIAN LETTER SA" },
	{ 0x1831, "MONGOLIAN LETTER SHA" },
	{ 0x1832, "MONGOLIAN LETTER TA" },
	{ 0x1833, "MONGOLIAN LETTER DA" },
	{ 0x1834, "MONGOLIAN LETTER CHA" },
	{ 0x1835, "MONGOLIAN LETTER JA" },
	{ 0x1836, "MONGOLIAN LETTER YA" },
	{ 0x1837, "MONGOLIAN LETTER RA" },
	{ 0x1838, "MONGOLIAN LETTER WA" },
	{ 0x1839, "MONGOLIAN LETTER FA" },
	{ 0x183A, "MONGOLIAN LETTER KA" },
	{ 0x183B, "MONGOLIAN LETTER KHA" },
	{ 0x183C, "MONGOLIAN LETTER TSA" },
	{ 0x183D, "MONGOLIAN LETTER ZA" },
	{ 0x183E, "MONGOLIAN LETTER HAA" },
	{ 0x183F, "MONGOLIAN LETTER ZRA" },
	{ 0x1840, "MONGOLIAN LETTER LHA" },
	{ 0x1841, "MONGOLIAN LETTER ZHI" },
	{ 0x1842, "MONGOLIAN LETTER CHI" },
	{ 0x1843, "MONGOLIAN LETTER TODO LONG VOWEL SIGN" },
	{ 0x1844, "MONGOLIAN LETTER TODO E" },
	{ 0x1845, "MONGOLIAN LETTER TODO I" },
	{ 0x1846, "MONGOLIAN LETTER TODO O" },
	{ 0x1847, "MONGOLIAN LETTER TODO U" },
	{ 0x1848, "MONGOLIAN LETTER TODO OE" },
	{ 0x1849, "MONGOLIAN LETTER TODO UE" },
	{ 0x184A, "MONGOLIAN LETTER TODO ANG" },
	{ 0x184B, "MONGOLIAN LETTER TODO BA" },
	{ 0x184C, "MONGOLIAN LETTER TODO PA" },
	{ 0x184D, "MONGOLIAN LETTER TODO QA" },
	{ 0x184E, "MONGOLIAN LETTER TODO GA" },
	{ 0x184F, "MONGOLIAN LETTER TODO MA" },
	{ 0x1850, "MONGOLIAN LETTER TODO TA" },
	{ 0x1851, "MONGOLIAN LETTER TODO DA" },
	{ 0x1852, "MONGOLIAN LETTER TODO CHA" },
	{ 0x1853, "MONGOLIAN LETTER TODO JA" },
	{ 0x1854, "MONGOLIAN LETTER TODO TSA" },
	{ 0x1855, "MONGOLIAN LETTER TODO YA" },
	{ 0x1856, "MONGOLIAN LETTER TODO WA" },
	{ 0x1857, "MONGOLIAN LETTER TODO KA" },
	{ 0x1858, "MONGOLIAN LETTER TODO GAA" },
	{ 0x1859, "MONGOLIAN LETTER TODO HAA" },
	{ 0x185A, "MONGOLIAN LETTER TODO JIA" },
	{ 0x185B, "MONGOLIAN LETTER TODO NIA" },
	{ 0x185C, "MONGOLIAN LETTER TODO DZA" },
	{ 0x185D, "MONGOLIAN LETTER SIBE E" },
	{ 0x185E, "MONGOLIAN LETTER SIBE I" },
	{ 0x185F, "MONGOLIAN LETTER SIBE IY" },
	{ 0x1860, "MONGOLIAN LETTER SIBE UE" },
	{ 0x1861, "MONGOLIAN LETTER SIBE U" },
	{ 0x1862, "MONGOLIAN LETTER SIBE ANG" },
	{ 0x1863, "MONGOLIAN LETTER SIBE KA" },
	{ 0x1864, "MONGOLIAN LETTER SIBE GA" },
	{ 0x1865, "MONGOLIAN LETTER SIBE HA" },
	{ 0x1866, "MONGOLIAN LETTER SIBE PA" },
	{ 0x1867, "MONGOLIAN LETTER SIBE SHA" },
	{ 0x1868, "MONGOLIAN LETTER SIBE TA" },
	{ 0x1869, "MONGOLIAN LETTER SIBE DA" },
	{ 0x186A, "MONGOLIAN LETTER SIBE JA" },
	{ 0x186B, "MONGOLIAN LETTER SIBE FA" },
	{ 0x186C, "MONGOLIAN LETTER SIBE GAA" },
	{ 0x186D, "MONGOLIAN LETTER SIBE HAA" },
	{ 0x186E, "MONGOLIAN LETTER SIBE TSA" },
	{ 0x186F, "MONGOLIAN LETTER SIBE ZA" },
	{ 0x1870, "MONGOLIAN LETTER SIBE RAA" },
	{ 0x1871, "MONGOLIAN LETTER SIBE CHA" },
	{ 0x1872, "MONGOLIAN LETTER SIBE ZHA" },
	{ 0x1873, "MONGOLIAN LETTER MANCHU I" },
	{ 0x1874, "MONGOLIAN LETTER MANCHU KA" },
	{ 0x1875, "MONGOLIAN LETTER MANCHU RA" },
	{ 0x1876, "MONGOLIAN LETTER MANCHU FA" },
	{ 0x1877, "MONGOLIAN LETTER MANCHU ZHA" },
	{ 0x1880, "MONGOLIAN LETTER ALI GALI ANUSVARA ONE" },
	{ 0x1881, "MONGOLIAN LETTER ALI GALI VISARGA ONE" },
	{ 0x1882, "MONGOLIAN LETTER ALI GALI DAMARU" },
	{ 0x1883, "MONGOLIAN LETTER ALI GALI UBADAMA" },
	{ 0x1884, "MONGOLIAN LETTER ALI GALI INVERTED UBADAMA" },
	{ 0x1885, "MONGOLIAN LETTER ALI GALI BALUDA" },
	{ 0x1886, "MONGOLIAN LETTER ALI GALI THREE BALUDA" },
	{ 0x1887, "MONGOLIAN LETTER ALI GALI A" },
	{ 0x1888, "MONGOLIAN LETTER ALI GALI I" },
	{ 0x1889, "MONGOLIAN LETTER ALI GALI KA" },
	{ 0x188A, "MONGOLIAN LETTER ALI GALI NGA" },
	{ 0x188B, "MONGOLIAN LETTER ALI GALI CA" },
	{ 0x188C, "MONGOLIAN LETTER ALI GALI TTA" },
	{ 0x188D, "MONGOLIAN LETTER ALI GALI TTHA" },
	{ 0x188E, "MONGOLIAN LETTER ALI GALI DDA" },
	{ 0x188F, "MONGOLIAN LETTER ALI GALI NNA" },
	{ 0x1890, "MONGOLIAN LETTER ALI GALI TA" },
	{ 0x1891, "MONGOLIAN LETTER ALI GALI DA" },
	{ 0x1892, "MONGOLIAN LETTER ALI GALI PA" },
	{ 0x1893, "MONGOLIAN LETTER ALI GALI PHA" },
	{ 0x1894, "MONGOLIAN LETTER ALI GALI SSA" },
	{ 0x1895, "MONGOLIAN LETTER ALI GALI ZHA" },
	{ 0x1896, "MONGOLIAN LETTER ALI GALI ZA" },
	{ 0x1897, "MONGOLIAN LETTER ALI GALI AH" },
	{ 0x1898, "MONGOLIAN LETTER TODO ALI GALI TA" },
	{ 0x1899, "MONGOLIAN LETTER TODO ALI GALI ZHA" },
	{ 0x189A, "MONGOLIAN LETTER MANCHU ALI GALI GHA" },
	{ 0x189B, "MONGOLIAN LETTER MANCHU ALI GALI NGA" },
	{ 0x189C, "MONGOLIAN LETTER MANCHU ALI GALI CA" },
	{ 0x189D, "MONGOLIAN LETTER MANCHU ALI GALI JHA" },
	{ 0x189E, "MONGOLIAN LETTER MANCHU ALI GALI TTA" },
	{ 0x189F, "MONGOLIAN LETTER MANCHU ALI GALI DDHA" },
	{ 0x18A0, "MONGOLIAN LETTER MANCHU ALI GALI TA" },
	{ 0x18A1, "MONGOLIAN LETTER MANCHU ALI GALI DHA" },
	{ 0x18A2, "MONGOLIAN LETTER MANCHU ALI GALI SSA" },
	{ 0x18A3, "MONGOLIAN LETTER MANCHU ALI GALI CYA" },
	{ 0x18A4, "MONGOLIAN LETTER MANCHU ALI GALI ZHA" },
	{ 0x18A5, "MONGOLIAN LETTER MANCHU ALI GALI ZA" },
	{ 0x18A6, "MONGOLIAN LETTER ALI GALI HALF U" },
	{ 0x18A7, "MONGOLIAN LETTER ALI GALI HALF YA" },
	{ 0x18A8, "MONGOLIAN LETTER MANCHU ALI GALI BHA" },
	{ 0x18A9, "MONGOLIAN LETTER ALI GALI DAGALGA" },
	{ 0x1E00, "LATIN CAPITAL LETTER A WITH RING BELOW" },
	{ 0x1E01, "LATIN SMALL LETTER A WITH RING BELOW" },
	{ 0x1E02, "LATIN CAPITAL LETTER B WITH DOT ABOVE" },
	{ 0x1E03, "LATIN SMALL LETTER B WITH DOT ABOVE" },
	{ 0x1E04, "LATIN CAPITAL LETTER B WITH DOT BELOW" },
	{ 0x1E05, "LATIN SMALL LETTER B WITH DOT BELOW" },
	{ 0x1E06, "LATIN CAPITAL LETTER B WITH LINE BELOW" },
	{ 0x1E07, "LATIN SMALL LETTER B WITH LINE BELOW" },
	{ 0x1E08, "LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE" },
	{ 0x1E09, "LATIN SMALL LETTER C WITH CEDILLA AND ACUTE" },
	{ 0x1E0A, "LATIN CAPITAL LETTER D WITH DOT ABOVE" },
	{ 0x1E0B, "LATIN SMALL LETTER D WITH DOT ABOVE" },
	{ 0x1E0C, "LATIN CAPITAL LETTER D WITH DOT BELOW" },
	{ 0x1E0D, "LATIN SMALL LETTER D WITH DOT BELOW" },
	{ 0x1E0E, "LATIN CAPITAL LETTER D WITH LINE BELOW" },
	{ 0x1E0F, "LATIN SMALL LETTER D WITH LINE BELOW" },
	{ 0x1E10, "LATIN CAPITAL LETTER D WITH CEDILLA" },
	{ 0x1E11, "LATIN SMALL LETTER D WITH CEDILLA" },
	{ 0x1E12, "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW" },
	{ 0x1E13, "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW" },
	{ 0x1E14, "LATIN CAPITAL LETTER E WITH MACRON AND GRAVE" },
	{ 0x1E15, "LATIN SMALL LETTER E WITH MACRON AND GRAVE" },
	{ 0x1E16, "LATIN CAPITAL LETTER E WITH MACRON AND ACUTE" },
	{ 0x1E17, "LATIN SMALL LETTER E WITH MACRON AND ACUTE" },
	{ 0x1E18, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW" },
	{ 0x1E19, "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW" },
	{ 0x1E1A, "LATIN CAPITAL LETTER E WITH TILDE BELOW" },
	{ 0x1E1B, "LATIN SMALL LETTER E WITH TILDE BELOW" },
	{ 0x1E1C, "LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE" },
	{ 0x1E1D, "LATIN SMALL LETTER E WITH CEDILLA AND BREVE" },
	{ 0x1E1E, "LATIN CAPITAL LETTER F WITH DOT ABOVE" },
	{ 0x1E1F, "LATIN SMALL LETTER F WITH DOT ABOVE" },
	{ 0x1E20, "LATIN CAPITAL LETTER G WITH MACRON" },
	{ 0x1E21, "LATIN SMALL LETTER G WITH MACRON" },
	{ 0x1E22, "LATIN CAPITAL LETTER H WITH DOT ABOVE" },
	{ 0x1E23, "LATIN SMALL LETTER H WITH DOT ABOVE" },
	{ 0x1E24, "LATIN CAPITAL LETTER H WITH DOT BELOW" },
	{ 0x1E25, "LATIN SMALL LETTER H WITH DOT BELOW" },
	{ 0x1E26, "LATIN CAPITAL LETTER H WITH DIAERESIS" },
	{ 0x1E27, "LATIN SMALL LETTER H WITH DIAERESIS" },
	{ 0x1E28, "LATIN CAPITAL LETTER H WITH CEDILLA" },
	{ 0x1E29, "LATIN SMALL LETTER H WITH CEDILLA" },
	{ 0x1E2A, "LATIN CAPITAL LETTER H WITH BREVE BELOW" },
	{ 0x1E2B, "LATIN SMALL LETTER H WITH BREVE BELOW" },
	{ 0x1E2C, "LATIN CAPITAL LETTER I WITH TILDE BELOW" },
	{ 0x1E2D, "LATIN SMALL LETTER I WITH TILDE BELOW" },
	{ 0x1E2E, "LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE" },
	{ 0x1E2F, "LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE" },
	{ 0x1E30, "LATIN CAPITAL LETTER K WITH ACUTE" },
	{ 0x1E31, "LATIN SMALL LETTER K WITH ACUTE" },
	{ 0x1E32, "LATIN CAPITAL LETTER K WITH DOT BELOW" },
	{ 0x1E33, "LATIN SMALL LETTER K WITH DOT BELOW" },
	{ 0x1E34, "LATIN CAPITAL LETTER K WITH LINE BELOW" },
	{ 0x1E35, "LATIN SMALL LETTER K WITH LINE BELOW" },
	{ 0x1E36, "LATIN CAPITAL LETTER L WITH DOT BELOW" },
	{ 0x1E37, "LATIN SMALL LETTER L WITH DOT BELOW" },
	{ 0x1E38, "LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON" },
	{ 0x1E39, "LATIN SMALL LETTER L WITH DOT BELOW AND MACRON" },
	{ 0x1E3A, "LATIN CAPITAL LETTER L WITH LINE BELOW" },
	{ 0x1E3B, "LATIN SMALL LETTER L WITH LINE BELOW" },
	{ 0x1E3C, "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW" },
	{ 0x1E3D, "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW" },
	{ 0x1E3E, "LATIN CAPITAL LETTER M WITH ACUTE" },
	{ 0x1E3F, "LATIN SMALL LETTER M WITH ACUTE" },
	{ 0x1E40, "LATIN CAPITAL LETTER M WITH DOT ABOVE" },
	{ 0x1E41, "LATIN SMALL LETTER M WITH DOT ABOVE" },
	{ 0x1E42, "LATIN CAPITAL LETTER M WITH DOT BELOW" },
	{ 0x1E43, "LATIN SMALL LETTER M WITH DOT BELOW" },
	{ 0x1E44, "LATIN CAPITAL LETTER N WITH DOT ABOVE" },
	{ 0x1E45, "LATIN SMALL LETTER N WITH DOT ABOVE" },
	{ 0x1E46, "LATIN CAPITAL LETTER N WITH DOT BELOW" },
	{ 0x1E47, "LATIN SMALL LETTER N WITH DOT BELOW" },
	{ 0x1E48, "LATIN CAPITAL LETTER N WITH LINE BELOW" },
	{ 0x1E49, "LATIN SMALL LETTER N WITH LINE BELOW" },
	{ 0x1E4A, "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW" },
	{ 0x1E4B, "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW" },
	{ 0x1E4C, "LATIN CAPITAL LETTER O WITH TILDE AND ACUTE" },
	{ 0x1E4D, "LATIN SMALL LETTER O WITH TILDE AND ACUTE" },
	{ 0x1E4E, "LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS" },
	{ 0x1E4F, "LATIN SMALL LETTER O WITH TILDE AND DIAERESIS" },
	{ 0x1E50, "LATIN CAPITAL LETTER O WITH MACRON AND GRAVE" },
	{ 0x1E51, "LATIN SMALL LETTER O WITH MACRON AND GRAVE" },
	{ 0x1E52, "LATIN CAPITAL LETTER O WITH MACRON AND ACUTE" },
	{ 0x1E53, "LATIN SMALL LETTER O WITH MACRON AND ACUTE" },
	{ 0x1E54, "LATIN CAPITAL LETTER P WITH ACUTE" },
	{ 0x1E55, "LATIN SMALL LETTER P WITH ACUTE" },
	{ 0x1E56, "LATIN CAPITAL LETTER P WITH DOT ABOVE" },
	{ 0x1E57, "LATIN SMALL LETTER P WITH DOT ABOVE" },
	{ 0x1E58, "LATIN CAPITAL LETTER R WITH DOT ABOVE" },
	{ 0x1E59, "LATIN SMALL LETTER R WITH DOT ABOVE" },
	{ 0x1E5A, "LATIN CAPITAL LETTER R WITH DOT BELOW" },
	{ 0x1E5B, "LATIN SMALL LETTER R WITH DOT BELOW" },
	{ 0x1E5C, "LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON" },
	{ 0x1E5D, "LATIN SMALL LETTER R WITH DOT BELOW AND MACRON" },
	{ 0x1E5E, "LATIN CAPITAL LETTER R WITH LINE BELOW" },
	{ 0x1E5F, "LATIN SMALL LETTER R WITH LINE BELOW" },
	{ 0x1E60, "LATIN CAPITAL LETTER S WITH DOT ABOVE" },
	{ 0x1E61, "LATIN SMALL LETTER S WITH DOT ABOVE" },
	{ 0x1E62, "LATIN CAPITAL LETTER S WITH DOT BELOW" },
	{ 0x1E63, "LATIN SMALL LETTER S WITH DOT BELOW" },
	{ 0x1E64, "LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE" },
	{ 0x1E65, "LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE" },
	{ 0x1E66, "LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE" },
	{ 0x1E67, "LATIN SMALL LETTER S WITH CARON AND DOT ABOVE" },
	{ 0x1E68, "LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE" },
	{ 0x1E69, "LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE" },
	{ 0x1E6A, "LATIN CAPITAL LETTER T WITH DOT ABOVE" },
	{ 0x1E6B, "LATIN SMALL LETTER T WITH DOT ABOVE" },
	{ 0x1E6C, "LATIN CAPITAL LETTER T WITH DOT BELOW" },
	{ 0x1E6D, "LATIN SMALL LETTER T WITH DOT BELOW" },
	{ 0x1E6E, "LATIN CAPITAL LETTER T WITH LINE BELOW" },
	{ 0x1E6F, "LATIN SMALL LETTER T WITH LINE BELOW" },
	{ 0x1E70, "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW" },
	{ 0x1E71, "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW" },
	{ 0x1E72, "LATIN CAPITAL LETTER U WITH DIAERESIS BELOW" },
	{ 0x1E73, "LATIN SMALL LETTER U WITH DIAERESIS BELOW" },
	{ 0x1E74, "LATIN CAPITAL LETTER U WITH TILDE BELOW" },
	{ 0x1E75, "LATIN SMALL LETTER U WITH TILDE BELOW" },
	{ 0x1E76, "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW" },
	{ 0x1E77, "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW" },
	{ 0x1E78, "LATIN CAPITAL LETTER U WITH TILDE AND ACUTE" },
	{ 0x1E79, "LATIN SMALL LETTER U WITH TILDE AND ACUTE" },
	{ 0x1E7A, "LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS" },
	{ 0x1E7B, "LATIN SMALL LETTER U WITH MACRON AND DIAERESIS" },
	{ 0x1E7C, "LATIN CAPITAL LETTER V WITH TILDE" },
	{ 0x1E7D, "LATIN SMALL LETTER V WITH TILDE" },
	{ 0x1E7E, "LATIN CAPITAL LETTER V WITH DOT BELOW" },
	{ 0x1E7F, "LATIN SMALL LETTER V WITH DOT BELOW" },
	{ 0x1E80, "LATIN CAPITAL LETTER W WITH GRAVE" },
	{ 0x1E81, "LATIN SMALL LETTER W WITH GRAVE" },
	{ 0x1E82, "LATIN CAPITAL LETTER W WITH ACUTE" },
	{ 0x1E83, "LATIN SMALL LETTER W WITH ACUTE" },
	{ 0x1E84, "LATIN CAPITAL LETTER W WITH DIAERESIS" },
	{ 0x1E85, "LATIN SMALL LETTER W WITH DIAERESIS" },
	{ 0x1E86, "LATIN CAPITAL LETTER W WITH DOT ABOVE" },
	{ 0x1E87, "LATIN SMALL LETTER W WITH DOT ABOVE" },
	{ 0x1E88, "LATIN CAPITAL LETTER W WITH DOT BELOW" },
	{ 0x1E89, "LATIN SMALL LETTER W WITH DOT BELOW" },
	{ 0x1E8A, "LATIN CAPITAL LETTER X WITH DOT ABOVE" },
	{ 0x1E8B, "LATIN SMALL LETTER X WITH DOT ABOVE" },
	{ 0x1E8C, "LATIN CAPITAL LETTER X WITH DIAERESIS" },
	{ 0x1E8D, "LATIN SMALL LETTER X WITH DIAERESIS" },
	{ 0x1E8E, "LATIN CAPITAL LETTER Y WITH DOT ABOVE" },
	{ 0x1E8F, "LATIN SMALL LETTER Y WITH DOT ABOVE" },
	{ 0x1E90, "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX" },
	{ 0x1E91, "LATIN SMALL LETTER Z WITH CIRCUMFLEX" },
	{ 0x1E92, "LATIN CAPITAL LETTER Z WITH DOT BELOW" },
	{ 0x1E93, "LATIN SMALL LETTER Z WITH DOT BELOW" },
	{ 0x1E94, "LATIN CAPITAL LETTER Z WITH LINE BELOW" },
	{ 0x1E95, "LATIN SMALL LETTER Z WITH LINE BELOW" },
	{ 0x1E96, "LATIN SMALL LETTER H WITH LINE BELOW" },
	{ 0x1E97, "LATIN SMALL LETTER T WITH DIAERESIS" },
	{ 0x1E98, "LATIN SMALL LETTER W WITH RING ABOVE" },
	{ 0x1E99, "LATIN SMALL LETTER Y WITH RING ABOVE" },
	{ 0x1E9A, "LATIN SMALL LETTER A WITH RIGHT HALF RING" },
	{ 0x1E9B, "LATIN SMALL LETTER LONG S WITH DOT ABOVE" },
	{ 0x1EA0, "LATIN CAPITAL LETTER A WITH DOT BELOW" },
	{ 0x1EA1, "LATIN SMALL LETTER A WITH DOT BELOW" },
	{ 0x1EA2, "LATIN CAPITAL LETTER A WITH HOOK ABOVE" },
	{ 0x1EA3, "LATIN SMALL LETTER A WITH HOOK ABOVE" },
	{ 0x1EA4, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1EA5, "LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1EA6, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1EA7, "LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1EA8, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1EA9, "LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1EAA, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE" },
	{ 0x1EAB, "LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE" },
	{ 0x1EAC, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1EAD, "LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1EAE, "LATIN CAPITAL LETTER A WITH BREVE AND ACUTE" },
	{ 0x1EAF, "LATIN SMALL LETTER A WITH BREVE AND ACUTE" },
	{ 0x1EB0, "LATIN CAPITAL LETTER A WITH BREVE AND GRAVE" },
	{ 0x1EB1, "LATIN SMALL LETTER A WITH BREVE AND GRAVE" },
	{ 0x1EB2, "LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE" },
	{ 0x1EB3, "LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE" },
	{ 0x1EB4, "LATIN CAPITAL LETTER A WITH BREVE AND TILDE" },
	{ 0x1EB5, "LATIN SMALL LETTER A WITH BREVE AND TILDE" },
	{ 0x1EB6, "LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW" },
	{ 0x1EB7, "LATIN SMALL LETTER A WITH BREVE AND DOT BELOW" },
	{ 0x1EB8, "LATIN CAPITAL LETTER E WITH DOT BELOW" },
	{ 0x1EB9, "LATIN SMALL LETTER E WITH DOT BELOW" },
	{ 0x1EBA, "LATIN CAPITAL LETTER E WITH HOOK ABOVE" },
	{ 0x1EBB, "LATIN SMALL LETTER E WITH HOOK ABOVE" },
	{ 0x1EBC, "LATIN CAPITAL LETTER E WITH TILDE" },
	{ 0x1EBD, "LATIN SMALL LETTER E WITH TILDE" },
	{ 0x1EBE, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1EBF, "LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1EC0, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1EC1, "LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1EC2, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1EC3, "LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1EC4, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE" },
	{ 0x1EC5, "LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE" },
	{ 0x1EC6, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1EC7, "LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1EC8, "LATIN CAPITAL LETTER I WITH HOOK ABOVE" },
	{ 0x1EC9, "LATIN SMALL LETTER I WITH HOOK ABOVE" },
	{ 0x1ECA, "LATIN CAPITAL LETTER I WITH DOT BELOW" },
	{ 0x1ECB, "LATIN SMALL LETTER I WITH DOT BELOW" },
	{ 0x1ECC, "LATIN CAPITAL LETTER O WITH DOT BELOW" },
	{ 0x1ECD, "LATIN SMALL LETTER O WITH DOT BELOW" },
	{ 0x1ECE, "LATIN CAPITAL LETTER O WITH HOOK ABOVE" },
	{ 0x1ECF, "LATIN SMALL LETTER O WITH HOOK ABOVE" },
	{ 0x1ED0, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1ED1, "LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE" },
	{ 0x1ED2, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1ED3, "LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE" },
	{ 0x1ED4, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1ED5, "LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" },
	{ 0x1ED6, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE" },
	{ 0x1ED7, "LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE" },
	{ 0x1ED8, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1ED9, "LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW" },
	{ 0x1EDA, "LATIN CAPITAL LETTER O WITH HORN AND ACUTE" },
	{ 0x1EDB, "LATIN SMALL LETTER O WITH HORN AND ACUTE" },
	{ 0x1EDC, "LATIN CAPITAL LETTER O WITH HORN AND GRAVE" },
	{ 0x1EDD, "LATIN SMALL LETTER O WITH HORN AND GRAVE" },
	{ 0x1EDE, "LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE" },
	{ 0x1EDF, "LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE" },
	{ 0x1EE0, "LATIN CAPITAL LETTER O WITH HORN AND TILDE" },
	{ 0x1EE1, "LATIN SMALL LETTER O WITH HORN AND TILDE" },
	{ 0x1EE2, "LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW" },
	{ 0x1EE3, "LATIN SMALL LETTER O WITH HORN AND DOT BELOW" },
	{ 0x1EE4, "LATIN CAPITAL LETTER U WITH DOT BELOW" },
	{ 0x1EE5, "LATIN SMALL LETTER U WITH DOT BELOW" },
	{ 0x1EE6, "LATIN CAPITAL LETTER U WITH HOOK ABOVE" },
	{ 0x1EE7, "LATIN SMALL LETTER U WITH HOOK ABOVE" },
	{ 0x1EE8, "LATIN CAPITAL LETTER U WITH HORN AND ACUTE" },
	{ 0x1EE9, "LATIN SMALL LETTER U WITH HORN AND ACUTE" },
	{ 0x1EEA, "LATIN CAPITAL LETTER U WITH HORN AND GRAVE" },
	{ 0x1EEB, "LATIN SMALL LETTER U WITH HORN AND GRAVE" },
	{ 0x1EEC, "LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE" },
	{ 0x1EED, "LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE" },
	{ 0x1EEE, "LATIN CAPITAL LETTER U WITH HORN AND TILDE" },
	{ 0x1EEF, "LATIN SMALL LETTER U WITH HORN AND TILDE" },
	{ 0x1EF0, "LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW" },
	{ 0x1EF1, "LATIN SMALL LETTER U WITH HORN AND DOT BELOW" },
	{ 0x1EF2, "LATIN CAPITAL LETTER Y WITH GRAVE" },
	{ 0x1EF3, "LATIN SMALL LETTER Y WITH GRAVE" },
	{ 0x1EF4, "LATIN CAPITAL LETTER Y WITH DOT BELOW" },
	{ 0x1EF5, "LATIN SMALL LETTER Y WITH DOT BELOW" },
	{ 0x1EF6, "LATIN CAPITAL LETTER Y WITH HOOK ABOVE" },
	{ 0x1EF7, "LATIN SMALL LETTER Y WITH HOOK ABOVE" },
	{ 0x1EF8, "LATIN CAPITAL LETTER Y WITH TILDE" },
	{ 0x1EF9, "LATIN SMALL LETTER Y WITH TILDE" },
	{ 0x1F00, "GREEK SMALL LETTER ALPHA WITH PSILI" },
	{ 0x1F01, "GREEK SMALL LETTER ALPHA WITH DASIA" },
	{ 0x1F02, "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA" },
	{ 0x1F03, "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA" },
	{ 0x1F04, "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA" },
	{ 0x1F05, "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA" },
	{ 0x1F06, "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI" },
	{ 0x1F07, "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI" },
	{ 0x1F08, "GREEK CAPITAL LETTER ALPHA WITH PSILI" },
	{ 0x1F09, "GREEK CAPITAL LETTER ALPHA WITH DASIA" },
	{ 0x1F0A, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA" },
	{ 0x1F0B, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA" },
	{ 0x1F0C, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA" },
	{ 0x1F0D, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA" },
	{ 0x1F0E, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI" },
	{ 0x1F0F, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI" },
	{ 0x1F10, "GREEK SMALL LETTER EPSILON WITH PSILI" },
	{ 0x1F11, "GREEK SMALL LETTER EPSILON WITH DASIA" },
	{ 0x1F12, "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA" },
	{ 0x1F13, "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA" },
	{ 0x1F14, "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA" },
	{ 0x1F15, "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA" },
	{ 0x1F18, "GREEK CAPITAL LETTER EPSILON WITH PSILI" },
	{ 0x1F19, "GREEK CAPITAL LETTER EPSILON WITH DASIA" },
	{ 0x1F1A, "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA" },
	{ 0x1F1B, "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA" },
	{ 0x1F1C, "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA" },
	{ 0x1F1D, "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA" },
	{ 0x1F20, "GREEK SMALL LETTER ETA WITH PSILI" },
	{ 0x1F21, "GREEK SMALL LETTER ETA WITH DASIA" },
	{ 0x1F22, "GREEK SMALL LETTER ETA WITH PSILI AND VARIA" },
	{ 0x1F23, "GREEK SMALL LETTER ETA WITH DASIA AND VARIA" },
	{ 0x1F24, "GREEK SMALL LETTER ETA WITH PSILI AND OXIA" },
	{ 0x1F25, "GREEK SMALL LETTER ETA WITH DASIA AND OXIA" },
	{ 0x1F26, "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI" },
	{ 0x1F27, "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI" },
	{ 0x1F28, "GREEK CAPITAL LETTER ETA WITH PSILI" },
	{ 0x1F29, "GREEK CAPITAL LETTER ETA WITH DASIA" },
	{ 0x1F2A, "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA" },
	{ 0x1F2B, "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA" },
	{ 0x1F2C, "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA" },
	{ 0x1F2D, "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA" },
	{ 0x1F2E, "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI" },
	{ 0x1F2F, "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI" },
	{ 0x1F30, "GREEK SMALL LETTER IOTA WITH PSILI" },
	{ 0x1F31, "GREEK SMALL LETTER IOTA WITH DASIA" },
	{ 0x1F32, "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA" },
	{ 0x1F33, "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA" },
	{ 0x1F34, "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA" },
	{ 0x1F35, "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA" },
	{ 0x1F36, "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI" },
	{ 0x1F37, "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI" },
	{ 0x1F38, "GREEK CAPITAL LETTER IOTA WITH PSILI" },
	{ 0x1F39, "GREEK CAPITAL LETTER IOTA WITH DASIA" },
	{ 0x1F3A, "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA" },
	{ 0x1F3B, "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA" },
	{ 0x1F3C, "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA" },
	{ 0x1F3D, "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA" },
	{ 0x1F3E, "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI" },
	{ 0x1F3F, "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI" },
	{ 0x1F40, "GREEK SMALL LETTER OMICRON WITH PSILI" },
	{ 0x1F41, "GREEK SMALL LETTER OMICRON WITH DASIA" },
	{ 0x1F42, "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA" },
	{ 0x1F43, "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA" },
	{ 0x1F44, "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA" },
	{ 0x1F45, "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA" },
	{ 0x1F48, "GREEK CAPITAL LETTER OMICRON WITH PSILI" },
	{ 0x1F49, "GREEK CAPITAL LETTER OMICRON WITH DASIA" },
	{ 0x1F4A, "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA" },
	{ 0x1F4B, "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA" },
	{ 0x1F4C, "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA" },
	{ 0x1F4D, "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA" },
	{ 0x1F50, "GREEK SMALL LETTER UPSILON WITH PSILI" },
	{ 0x1F51, "GREEK SMALL LETTER UPSILON WITH DASIA" },
	{ 0x1F52, "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA" },
	{ 0x1F53, "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA" },
	{ 0x1F54, "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA" },
	{ 0x1F55, "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA" },
	{ 0x1F56, "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI" },
	{ 0x1F57, "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI" },
	{ 0x1F59, "GREEK CAPITAL LETTER UPSILON WITH DASIA" },
	{ 0x1F5B, "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA" },
	{ 0x1F5D, "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA" },
	{ 0x1F5F, "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI" },
	{ 0x1F60, "GREEK SMALL LETTER OMEGA WITH PSILI" },
	{ 0x1F61, "GREEK SMALL LETTER OMEGA WITH DASIA" },
	{ 0x1F62, "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA" },
	{ 0x1F63, "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA" },
	{ 0x1F64, "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA" },
	{ 0x1F65, "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA" },
	{ 0x1F66, "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI" },
	{ 0x1F67, "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI" },
	{ 0x1F68, "GREEK CAPITAL LETTER OMEGA WITH PSILI" },
	{ 0x1F69, "GREEK CAPITAL LETTER OMEGA WITH DASIA" },
	{ 0x1F6A, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA" },
	{ 0x1F6B, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA" },
	{ 0x1F6C, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA" },
	{ 0x1F6D, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA" },
	{ 0x1F6E, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI" },
	{ 0x1F6F, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI" },
	{ 0x1F70, "GREEK SMALL LETTER ALPHA WITH VARIA" },
	{ 0x1F71, "GREEK SMALL LETTER ALPHA WITH OXIA" },
	{ 0x1F72, "GREEK SMALL LETTER EPSILON WITH VARIA" },
	{ 0x1F73, "GREEK SMALL LETTER EPSILON WITH OXIA" },
	{ 0x1F74, "GREEK SMALL LETTER ETA WITH VARIA" },
	{ 0x1F75, "GREEK SMALL LETTER ETA WITH OXIA" },
	{ 0x1F76, "GREEK SMALL LETTER IOTA WITH VARIA" },
	{ 0x1F77, "GREEK SMALL LETTER IOTA WITH OXIA" },
	{ 0x1F78, "GREEK SMALL LETTER OMICRON WITH VARIA" },
	{ 0x1F79, "GREEK SMALL LETTER OMICRON WITH OXIA" },
	{ 0x1F7A, "GREEK SMALL LETTER UPSILON WITH VARIA" },
	{ 0x1F7B, "GREEK SMALL LETTER UPSILON WITH OXIA" },
	{ 0x1F7C, "GREEK SMALL LETTER OMEGA WITH VARIA" },
	{ 0x1F7D, "GREEK SMALL LETTER OMEGA WITH OXIA" },
	{ 0x1F80, "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI" },
	{ 0x1F81, "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI" },
	{ 0x1F82, "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1F83, "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1F84, "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1F85, "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1F86, "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1F87, "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1F88, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI" },
	{ 0x1F89, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI" },
	{ 0x1F8A, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1F8B, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1F8C, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1F8D, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1F8E, "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1F8F, "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1F90, "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI" },
	{ 0x1F91, "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI" },
	{ 0x1F92, "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1F93, "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1F94, "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1F95, "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1F96, "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1F97, "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1F98, "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI" },
	{ 0x1F99, "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI" },
	{ 0x1F9A, "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1F9B, "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1F9C, "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1F9D, "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1F9E, "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1F9F, "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1FA0, "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI" },
	{ 0x1FA1, "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI" },
	{ 0x1FA2, "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1FA3, "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI" },
	{ 0x1FA4, "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1FA5, "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI" },
	{ 0x1FA6, "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1FA7, "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1FA8, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI" },
	{ 0x1FA9, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI" },
	{ 0x1FAA, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1FAB, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI" },
	{ 0x1FAC, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1FAD, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI" },
	{ 0x1FAE, "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1FAF, "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" },
	{ 0x1FB0, "GREEK SMALL LETTER ALPHA WITH VRACHY" },
	{ 0x1FB1, "GREEK SMALL LETTER ALPHA WITH MACRON" },
	{ 0x1FB2, "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI" },
	{ 0x1FB3, "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI" },
	{ 0x1FB4, "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI" },
	{ 0x1FB6, "GREEK SMALL LETTER ALPHA WITH PERISPOMENI" },
	{ 0x1FB7, "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1FB8, "GREEK CAPITAL LETTER ALPHA WITH VRACHY" },
	{ 0x1FB9, "GREEK CAPITAL LETTER ALPHA WITH MACRON" },
	{ 0x1FBA, "GREEK CAPITAL LETTER ALPHA WITH VARIA" },
	{ 0x1FBB, "GREEK CAPITAL LETTER ALPHA WITH OXIA" },
	{ 0x1FBC, "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI" },
	{ 0x1FBD, "GREEK KORONIS" },
	{ 0x1FBE, "GREEK PROSGEGRAMMENI" },
	{ 0x1FBF, "GREEK PSILI" },
	{ 0x1FC0, "GREEK PERISPOMENI" },
	{ 0x1FC1, "GREEK DIALYTIKA AND PERISPOMENI" },
	{ 0x1FC2, "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI" },
	{ 0x1FC3, "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI" },
	{ 0x1FC4, "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI" },
	{ 0x1FC6, "GREEK SMALL LETTER ETA WITH PERISPOMENI" },
	{ 0x1FC7, "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1FC8, "GREEK CAPITAL LETTER EPSILON WITH VARIA" },
	{ 0x1FC9, "GREEK CAPITAL LETTER EPSILON WITH OXIA" },
	{ 0x1FCA, "GREEK CAPITAL LETTER ETA WITH VARIA" },
	{ 0x1FCB, "GREEK CAPITAL LETTER ETA WITH OXIA" },
	{ 0x1FCC, "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI" },
	{ 0x1FCD, "GREEK PSILI AND VARIA" },
	{ 0x1FCE, "GREEK PSILI AND OXIA" },
	{ 0x1FCF, "GREEK PSILI AND PERISPOMENI" },
	{ 0x1FD0, "GREEK SMALL LETTER IOTA WITH VRACHY" },
	{ 0x1FD1, "GREEK SMALL LETTER IOTA WITH MACRON" },
	{ 0x1FD2, "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA" },
	{ 0x1FD3, "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA" },
	{ 0x1FD6, "GREEK SMALL LETTER IOTA WITH PERISPOMENI" },
	{ 0x1FD7, "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI" },
	{ 0x1FD8, "GREEK CAPITAL LETTER IOTA WITH VRACHY" },
	{ 0x1FD9, "GREEK CAPITAL LETTER IOTA WITH MACRON" },
	{ 0x1FDA, "GREEK CAPITAL LETTER IOTA WITH VARIA" },
	{ 0x1FDB, "GREEK CAPITAL LETTER IOTA WITH OXIA" },
	{ 0x1FDD, "GREEK DASIA AND VARIA" },
	{ 0x1FDE, "GREEK DASIA AND OXIA" },
	{ 0x1FDF, "GREEK DASIA AND PERISPOMENI" },
	{ 0x1FE0, "GREEK SMALL LETTER UPSILON WITH VRACHY" },
	{ 0x1FE1, "GREEK SMALL LETTER UPSILON WITH MACRON" },
	{ 0x1FE2, "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA" },
	{ 0x1FE3, "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA" },
	{ 0x1FE4, "GREEK SMALL LETTER RHO WITH PSILI" },
	{ 0x1FE5, "GREEK SMALL LETTER RHO WITH DASIA" },
	{ 0x1FE6, "GREEK SMALL LETTER UPSILON WITH PERISPOMENI" },
	{ 0x1FE7, "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI" },
	{ 0x1FE8, "GREEK CAPITAL LETTER UPSILON WITH VRACHY" },
	{ 0x1FE9, "GREEK CAPITAL LETTER UPSILON WITH MACRON" },
	{ 0x1FEA, "GREEK CAPITAL LETTER UPSILON WITH VARIA" },
	{ 0x1FEB, "GREEK CAPITAL LETTER UPSILON WITH OXIA" },
	{ 0x1FEC, "GREEK CAPITAL LETTER RHO WITH DASIA" },
	{ 0x1FED, "GREEK DIALYTIKA AND VARIA" },
	{ 0x1FEE, "GREEK DIALYTIKA AND OXIA" },
	{ 0x1FEF, "GREEK VARIA" },
	{ 0x1FF2, "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI" },
	{ 0x1FF3, "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI" },
	{ 0x1FF4, "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI" },
	{ 0x1FF6, "GREEK SMALL LETTER OMEGA WITH PERISPOMENI" },
	{ 0x1FF7, "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI" },
	{ 0x1FF8, "GREEK CAPITAL LETTER OMICRON WITH VARIA" },
	{ 0x1FF9, "GREEK CAPITAL LETTER OMICRON WITH OXIA" },
	{ 0x1FFA, "GREEK CAPITAL LETTER OMEGA WITH VARIA" },
	{ 0x1FFB, "GREEK CAPITAL LETTER OMEGA WITH OXIA" },
	{ 0x1FFC, "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI" },
	{ 0x1FFD, "GREEK OXIA" },
	{ 0x1FFE, "GREEK DASIA" },
	{ 0x2000, "EN QUAD" },
	{ 0x2001, "EM QUAD" },
	{ 0x2002, "EN SPACE" },
	{ 0x2003, "EM SPACE" },
	{ 0x2004, "THREE-PER-EM SPACE" },
	{ 0x2005, "FOUR-PER-EM SPACE" },
	{ 0x2006, "SIX-PER-EM SPACE" },
	{ 0x2007, "FIGURE SPACE" },
	{ 0x2008, "PUNCTUATION SPACE" },
	{ 0x2009, "THIN SPACE" },
	{ 0x200A, "HAIR SPACE" },
	{ 0x200B, "ZERO WIDTH SPACE" },
	{ 0x200C, "ZERO WIDTH NON-JOINER" },
	{ 0x200D, "ZERO WIDTH JOINER" },
	{ 0x200E, "LEFT-TO-RIGHT MARK" },
	{ 0x200F, "RIGHT-TO-LEFT MARK" },
	{ 0x2010, "HYPHEN" },
	{ 0x2011, "NON-BREAKING HYPHEN" },
	{ 0x2012, "FIGURE DASH" },
	{ 0x2013, "EN DASH" },
	{ 0x2014, "EM DASH" },
	{ 0x2015, "HORIZONTAL BAR" },
	{ 0x2016, "DOUBLE VERTICAL LINE" },
	{ 0x2017, "DOUBLE LOW LINE" },
	{ 0x2018, "LEFT SINGLE QUOTATION MARK" },
	{ 0x2019, "RIGHT SINGLE QUOTATION MARK" },
	{ 0x201A, "SINGLE LOW-9 QUOTATION MARK" },
	{ 0x201B, "SINGLE HIGH-REVERSED-9 QUOTATION MARK" },
	{ 0x201C, "LEFT DOUBLE QUOTATION MARK" },
	{ 0x201D, "RIGHT DOUBLE QUOTATION MARK" },
	{ 0x201E, "DOUBLE LOW-9 QUOTATION MARK" },
	{ 0x201F, "DOUBLE HIGH-REVERSED-9 QUOTATION MARK" },
	{ 0x2020, "DAGGER" },
	{ 0x2021, "DOUBLE DAGGER" },
	{ 0x2022, "BULLET" },
	{ 0x2023, "TRIANGULAR BULLET" },
	{ 0x2024, "ONE DOT LEADER" },
	{ 0x2025, "TWO DOT LEADER" },
	{ 0x2026, "HORIZONTAL ELLIPSIS" },
	{ 0x2027, "HYPHENATION POINT" },
	{ 0x2028, "LINE SEPARATOR" },
	{ 0x2029, "PARAGRAPH SEPARATOR" },
	{ 0x202A, "LEFT-TO-RIGHT EMBEDDING" },
	{ 0x202B, "RIGHT-TO-LEFT EMBEDDING" },
	{ 0x202C, "POP DIRECTIONAL FORMATTING" },
	{ 0x202D, "LEFT-TO-RIGHT OVERRIDE" },
	{ 0x202E, "RIGHT-TO-LEFT OVERRIDE" },
	{ 0x202F, "NARROW NO-BREAK SPACE" },
	{ 0x2030, "PER MILLE SIGN" },
	{ 0x2031, "PER TEN THOUSAND SIGN" },
	{ 0x2032, "PRIME" },
	{ 0x2033, "DOUBLE PRIME" },
	{ 0x2034, "TRIPLE PRIME" },
	{ 0x2035, "REVERSED PRIME" },
	{ 0x2036, "REVERSED DOUBLE PRIME" },
	{ 0x2037, "REVERSED TRIPLE PRIME" },
	{ 0x2038, "CARET" },
	{ 0x2039, "SINGLE LEFT-POINTING ANGLE QUOTATION MARK" },
	{ 0x203A, "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK" },
	{ 0x203B, "REFERENCE MARK" },
	{ 0x203C, "DOUBLE EXCLAMATION MARK" },
	{ 0x203D, "INTERROBANG" },
	{ 0x203E, "OVERLINE" },
	{ 0x203F, "UNDERTIE" },	/* Enotikon */
	{ 0x2040, "CHARACTER TIE" },
	{ 0x2041, "CARET INSERTION POINT" },
	{ 0x2042, "ASTERISM" },
	{ 0x2043, "HYPHEN BULLET" },
	{ 0x2044, "FRACTION SLASH" },
	{ 0x2045, "LEFT SQUARE BRACKET WITH QUILL" },
	{ 0x2046, "RIGHT SQUARE BRACKET WITH QUILL" },
	{ 0x2048, "QUESTION EXCLAMATION MARK" },
	{ 0x2049, "EXCLAMATION QUESTION MARK" },
	{ 0x204A, "TIRONIAN SIGN ET" },
	{ 0x204B, "REVERSED PILCROW SIGN" },
	{ 0x204C, "BLACK LEFTWARDS BULLET" },
	{ 0x204D, "BLACK RIGHTWARDS BULLET" },
	{ 0x206A, "INHIBIT SYMMETRIC SWAPPING" },
	{ 0x206B, "ACTIVATE SYMMETRIC SWAPPING" },
	{ 0x206C, "INHIBIT ARABIC FORM SHAPING" },
	{ 0x206D, "ACTIVATE ARABIC FORM SHAPING" },
	{ 0x206E, "NATIONAL DIGIT SHAPES" },
	{ 0x206F, "NOMINAL DIGIT SHAPES" },
	{ 0x2070, "SUPERSCRIPT ZERO" },
	{ 0x2074, "SUPERSCRIPT FOUR" },
	{ 0x2075, "SUPERSCRIPT FIVE" },
	{ 0x2076, "SUPERSCRIPT SIX" },
	{ 0x2077, "SUPERSCRIPT SEVEN" },
	{ 0x2078, "SUPERSCRIPT EIGHT" },
	{ 0x2079, "SUPERSCRIPT NINE" },
	{ 0x207A, "SUPERSCRIPT PLUS SIGN" },
	{ 0x207B, "SUPERSCRIPT MINUS" },
	{ 0x207C, "SUPERSCRIPT EQUALS SIGN" },
	{ 0x207D, "SUPERSCRIPT LEFT PARENTHESIS" },
	{ 0x207E, "SUPERSCRIPT RIGHT PARENTHESIS" },
	{ 0x207F, "SUPERSCRIPT LATIN SMALL LETTER N" },
	{ 0x2080, "SUBSCRIPT ZERO" },
	{ 0x2081, "SUBSCRIPT ONE" },
	{ 0x2082, "SUBSCRIPT TWO" },
	{ 0x2083, "SUBSCRIPT THREE" },
	{ 0x2084, "SUBSCRIPT FOUR" },
	{ 0x2085, "SUBSCRIPT FIVE" },
	{ 0x2086, "SUBSCRIPT SIX" },
	{ 0x2087, "SUBSCRIPT SEVEN" },
	{ 0x2088, "SUBSCRIPT EIGHT" },
	{ 0x2089, "SUBSCRIPT NINE" },
	{ 0x208A, "SUBSCRIPT PLUS SIGN" },
	{ 0x208B, "SUBSCRIPT MINUS" },
	{ 0x208C, "SUBSCRIPT EQUALS SIGN" },
	{ 0x208D, "SUBSCRIPT LEFT PARENTHESIS" },
	{ 0x208E, "SUBSCRIPT RIGHT PARENTHESIS" },
	{ 0x20A0, "EURO-CURRENCY SIGN" },
	{ 0x20A1, "COLON SIGN" },
	{ 0x20A2, "CRUZEIRO SIGN" },
	{ 0x20A3, "FRENCH FRANC SIGN" },
	{ 0x20A4, "LIRA SIGN" },
	{ 0x20A5, "MILL SIGN" },
	{ 0x20A6, "NAIRA SIGN" },
	{ 0x20A7, "PESETA SIGN" },
	{ 0x20A8, "RUPEE SIGN" },
	{ 0x20A9, "WON SIGN" },
	{ 0x20AA, "NEW SHEQEL SIGN" },
	{ 0x20AB, "DONG SIGN" },
	{ 0x20AC, "EURO SIGN" },
	{ 0x20AD, "KIP SIGN" },
	{ 0x20AE, "TUGRIK SIGN" },
	{ 0x20AF, "DRACHMA SIGN" },
	{ 0x20D0, "COMBINING LEFT HARPOON ABOVE" },
	{ 0x20D1, "COMBINING RIGHT HARPOON ABOVE" },
	{ 0x20D2, "COMBINING LONG VERTICAL LINE OVERLAY" },
	{ 0x20D3, "COMBINING SHORT VERTICAL LINE OVERLAY" },
	{ 0x20D4, "COMBINING ANTICLOCKWISE ARROW ABOVE" },
	{ 0x20D5, "COMBINING CLOCKWISE ARROW ABOVE" },
	{ 0x20D6, "COMBINING LEFT ARROW ABOVE" },
	{ 0x20D7, "COMBINING RIGHT ARROW ABOVE" },
	{ 0x20D8, "COMBINING RING OVERLAY" },
	{ 0x20D9, "COMBINING CLOCKWISE RING OVERLAY" },
	{ 0x20DA, "COMBINING ANTICLOCKWISE RING OVERLAY" },
	{ 0x20DB, "COMBINING THREE DOTS ABOVE" },
	{ 0x20DC, "COMBINING FOUR DOTS ABOVE" },
	{ 0x20DD, "COMBINING ENCLOSING CIRCLE" },
	{ 0x20DE, "COMBINING ENCLOSING SQUARE" },
	{ 0x20DF, "COMBINING ENCLOSING DIAMOND" },
	{ 0x20E0, "COMBINING ENCLOSING CIRCLE BACKSLASH" },
	{ 0x20E1, "COMBINING LEFT RIGHT ARROW ABOVE" },
	{ 0x20E2, "COMBINING ENCLOSING SCREEN" },
	{ 0x20E3, "COMBINING ENCLOSING KEYCAP" },
	{ 0x2100, "ACCOUNT OF" },
	{ 0x2101, "ADDRESSED TO THE SUBJECT" },
	{ 0x2102, "DOUBLE-STRUCK CAPITAL C" },
	{ 0x2103, "DEGREE CELSIUS" },
	{ 0x2104, "CENTRE LINE SYMBOL" },
	{ 0x2105, "CARE OF" },
	{ 0x2106, "CADA UNA" },
	{ 0x2107, "EULER CONSTANT" },
	{ 0x2108, "SCRUPLE" },
	{ 0x2109, "DEGREE FAHRENHEIT" },
	{ 0x210A, "SCRIPT SMALL G" },
	{ 0x210B, "SCRIPT CAPITAL H" },
	{ 0x210C, "BLACK-LETTER CAPITAL H" },
	{ 0x210D, "DOUBLE-STRUCK CAPITAL H" },
	{ 0x210E, "PLANCK CONSTANT" },
	{ 0x210F, "PLANCK CONSTANT OVER TWO PI" },
	{ 0x2110, "SCRIPT CAPITAL I" },
	{ 0x2111, "BLACK-LETTER CAPITAL I" },
	{ 0x2112, "SCRIPT CAPITAL L" },
	{ 0x2113, "SCRIPT SMALL L" },
	{ 0x2114, "L B BAR SYMBOL" },
	{ 0x2115, "DOUBLE-STRUCK CAPITAL N" },
	{ 0x2116, "NUMERO SIGN" },
	{ 0x2117, "SOUND RECORDING COPYRIGHT" },
	{ 0x2118, "SCRIPT CAPITAL P" },
	{ 0x2119, "DOUBLE-STRUCK CAPITAL P" },
	{ 0x211A, "DOUBLE-STRUCK CAPITAL Q" },
	{ 0x211B, "SCRIPT CAPITAL R" },
	{ 0x211C, "BLACK-LETTER CAPITAL R" },
	{ 0x211D, "DOUBLE-STRUCK CAPITAL R" },
	{ 0x211E, "PRESCRIPTION TAKE" },
	{ 0x211F, "RESPONSE" },
	{ 0x2120, "SERVICE MARK" },
	{ 0x2121, "TELEPHONE SIGN" },
	{ 0x2122, "TRADE MARK SIGN" },
	{ 0x2123, "VERSICLE" },
	{ 0x2124, "DOUBLE-STRUCK CAPITAL Z" },
	{ 0x2125, "OUNCE SIGN" },
	{ 0x2126, "OHM SIGN" },
	{ 0x2127, "INVERTED OHM SIGN" },
	{ 0x2128, "BLACK-LETTER CAPITAL Z" },
	{ 0x2129, "TURNED GREEK SMALL LETTER IOTA" },
	{ 0x212A, "KELVIN SIGN" },
	{ 0x212B, "ANGSTROM SIGN" },
	{ 0x212C, "SCRIPT CAPITAL B" },
	{ 0x212D, "BLACK-LETTER CAPITAL C" },
	{ 0x212E, "ESTIMATED SYMBOL" },
	{ 0x212F, "SCRIPT SMALL E" },
	{ 0x2130, "SCRIPT CAPITAL E" },
	{ 0x2131, "SCRIPT CAPITAL F" },
	{ 0x2132, "TURNED CAPITAL F" },
	{ 0x2133, "SCRIPT CAPITAL M" },
	{ 0x2134, "SCRIPT SMALL O" },
	{ 0x2135, "ALEF SYMBOL" },
	{ 0x2136, "BET SYMBOL" },
	{ 0x2137, "GIMEL SYMBOL" },
	{ 0x2138, "DALET SYMBOL" },
	{ 0x2139, "INFORMATION SOURCE" },
	{ 0x213A, "ROTATED CAPITAL Q" },
	{ 0x2153, "VULGAR FRACTION ONE THIRD" },
	{ 0x2154, "VULGAR FRACTION TWO THIRDS" },
	{ 0x2155, "VULGAR FRACTION ONE FIFTH" },
	{ 0x2156, "VULGAR FRACTION TWO FIFTHS" },
	{ 0x2157, "VULGAR FRACTION THREE FIFTHS" },
	{ 0x2158, "VULGAR FRACTION FOUR FIFTHS" },
	{ 0x2159, "VULGAR FRACTION ONE SIXTH" },
	{ 0x215A, "VULGAR FRACTION FIVE SIXTHS" },
	{ 0x215B, "VULGAR FRACTION ONE EIGHTH" },
	{ 0x215C, "VULGAR FRACTION THREE EIGHTHS" },
	{ 0x215D, "VULGAR FRACTION FIVE EIGHTHS" },
	{ 0x215E, "VULGAR FRACTION SEVEN EIGHTHS" },
	{ 0x215F, "FRACTION NUMERATOR ONE" },
	{ 0x2160, "ROMAN NUMERAL ONE" },
	{ 0x2161, "ROMAN NUMERAL TWO" },
	{ 0x2162, "ROMAN NUMERAL THREE" },
	{ 0x2163, "ROMAN NUMERAL FOUR" },
	{ 0x2164, "ROMAN NUMERAL FIVE" },
	{ 0x2165, "ROMAN NUMERAL SIX" },
	{ 0x2166, "ROMAN NUMERAL SEVEN" },
	{ 0x2167, "ROMAN NUMERAL EIGHT" },
	{ 0x2168, "ROMAN NUMERAL NINE" },
	{ 0x2169, "ROMAN NUMERAL TEN" },
	{ 0x216A, "ROMAN NUMERAL ELEVEN" },
	{ 0x216B, "ROMAN NUMERAL TWELVE" },
	{ 0x216C, "ROMAN NUMERAL FIFTY" },
	{ 0x216D, "ROMAN NUMERAL ONE HUNDRED" },
	{ 0x216E, "ROMAN NUMERAL FIVE HUNDRED" },
	{ 0x216F, "ROMAN NUMERAL ONE THOUSAND" },
	{ 0x2170, "SMALL ROMAN NUMERAL ONE" },
	{ 0x2171, "SMALL ROMAN NUMERAL TWO" },
	{ 0x2172, "SMALL ROMAN NUMERAL THREE" },
	{ 0x2173, "SMALL ROMAN NUMERAL FOUR" },
	{ 0x2174, "SMALL ROMAN NUMERAL FIVE" },
	{ 0x2175, "SMALL ROMAN NUMERAL SIX" },
	{ 0x2176, "SMALL ROMAN NUMERAL SEVEN" },
	{ 0x2177, "SMALL ROMAN NUMERAL EIGHT" },
	{ 0x2178, "SMALL ROMAN NUMERAL NINE" },
	{ 0x2179, "SMALL ROMAN NUMERAL TEN" },
	{ 0x217A, "SMALL ROMAN NUMERAL ELEVEN" },
	{ 0x217B, "SMALL ROMAN NUMERAL TWELVE" },
	{ 0x217C, "SMALL ROMAN NUMERAL FIFTY" },
	{ 0x217D, "SMALL ROMAN NUMERAL ONE HUNDRED" },
	{ 0x217E, "SMALL ROMAN NUMERAL FIVE HUNDRED" },
	{ 0x217F, "SMALL ROMAN NUMERAL ONE THOUSAND" },
	{ 0x2180, "ROMAN NUMERAL ONE THOUSAND C D" },
	{ 0x2181, "ROMAN NUMERAL FIVE THOUSAND" },
	{ 0x2182, "ROMAN NUMERAL TEN THOUSAND" },
	{ 0x2183, "ROMAN NUMERAL REVERSED ONE HUNDRED" },
	{ 0x2190, "LEFTWARDS ARROW" },
	{ 0x2191, "UPWARDS ARROW" },
	{ 0x2192, "RIGHTWARDS ARROW" },
	{ 0x2193, "DOWNWARDS ARROW" },
	{ 0x2194, "LEFT RIGHT ARROW" },
	{ 0x2195, "UP DOWN ARROW" },
	{ 0x2196, "NORTH WEST ARROW" },
	{ 0x2197, "NORTH EAST ARROW" },
	{ 0x2198, "SOUTH EAST ARROW" },
	{ 0x2199, "SOUTH WEST ARROW" },
	{ 0x219A, "LEFTWARDS ARROW WITH STROKE" },
	{ 0x219B, "RIGHTWARDS ARROW WITH STROKE" },
	{ 0x219C, "LEFTWARDS WAVE ARROW" },
	{ 0x219D, "RIGHTWARDS WAVE ARROW" },
	{ 0x219E, "LEFTWARDS TWO HEADED ARROW" },
	{ 0x219F, "UPWARDS TWO HEADED ARROW" },
	{ 0x21A0, "RIGHTWARDS TWO HEADED ARROW" },
	{ 0x21A1, "DOWNWARDS TWO HEADED ARROW" },
	{ 0x21A2, "LEFTWARDS ARROW WITH TAIL" },
	{ 0x21A3, "RIGHTWARDS ARROW WITH TAIL" },
	{ 0x21A4, "LEFTWARDS ARROW FROM BAR" },
	{ 0x21A5, "UPWARDS ARROW FROM BAR" },
	{ 0x21A6, "RIGHTWARDS ARROW FROM BAR" },
	{ 0x21A7, "DOWNWARDS ARROW FROM BAR" },
	{ 0x21A8, "UP DOWN ARROW WITH BASE" },
	{ 0x21A9, "LEFTWARDS ARROW WITH HOOK" },
	{ 0x21AA, "RIGHTWARDS ARROW WITH HOOK" },
	{ 0x21AB, "LEFTWARDS ARROW WITH LOOP" },
	{ 0x21AC, "RIGHTWARDS ARROW WITH LOOP" },
	{ 0x21AD, "LEFT RIGHT WAVE ARROW" },
	{ 0x21AE, "LEFT RIGHT ARROW WITH STROKE" },
	{ 0x21AF, "DOWNWARDS ZIGZAG ARROW" },
	{ 0x21B0, "UPWARDS ARROW WITH TIP LEFTWARDS" },
	{ 0x21B1, "UPWARDS ARROW WITH TIP RIGHTWARDS" },
	{ 0x21B2, "DOWNWARDS ARROW WITH TIP LEFTWARDS" },
	{ 0x21B3, "DOWNWARDS ARROW WITH TIP RIGHTWARDS" },
	{ 0x21B4, "RIGHTWARDS ARROW WITH CORNER DOWNWARDS" },
	{ 0x21B5, "DOWNWARDS ARROW WITH CORNER LEFTWARDS" },
	{ 0x21B6, "ANTICLOCKWISE TOP SEMICIRCLE ARROW" },
	{ 0x21B7, "CLOCKWISE TOP SEMICIRCLE ARROW" },
	{ 0x21B8, "NORTH WEST ARROW TO LONG BAR" },
	{ 0x21B9, "LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR" },
	{ 0x21BA, "ANTICLOCKWISE OPEN CIRCLE ARROW" },
	{ 0x21BB, "CLOCKWISE OPEN CIRCLE ARROW" },
	{ 0x21BC, "LEFTWARDS HARPOON WITH BARB UPWARDS" },
	{ 0x21BD, "LEFTWARDS HARPOON WITH BARB DOWNWARDS" },
	{ 0x21BE, "UPWARDS HARPOON WITH BARB RIGHTWARDS" },
	{ 0x21BF, "UPWARDS HARPOON WITH BARB LEFTWARDS" },
	{ 0x21C0, "RIGHTWARDS HARPOON WITH BARB UPWARDS" },
	{ 0x21C1, "RIGHTWARDS HARPOON WITH BARB DOWNWARDS" },
	{ 0x21C2, "DOWNWARDS HARPOON WITH BARB RIGHTWARDS" },
	{ 0x21C3, "DOWNWARDS HARPOON WITH BARB LEFTWARDS" },
	{ 0x21C4, "RIGHTWARDS ARROW OVER LEFTWARDS ARROW" },
	{ 0x21C5, "UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW" },
	{ 0x21C6, "LEFTWARDS ARROW OVER RIGHTWARDS ARROW" },
	{ 0x21C7, "LEFTWARDS PAIRED ARROWS" },
	{ 0x21C8, "UPWARDS PAIRED ARROWS" },
	{ 0x21C9, "RIGHTWARDS PAIRED ARROWS" },
	{ 0x21CA, "DOWNWARDS PAIRED ARROWS" },
	{ 0x21CB, "LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON" },
	{ 0x21CC, "RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON" },
	{ 0x21CD, "LEFTWARDS DOUBLE ARROW WITH STROKE" },
	{ 0x21CE, "LEFT RIGHT DOUBLE ARROW WITH STROKE" },
	{ 0x21CF, "RIGHTWARDS DOUBLE ARROW WITH STROKE" },
	{ 0x21D0, "LEFTWARDS DOUBLE ARROW" },
	{ 0x21D1, "UPWARDS DOUBLE ARROW" },
	{ 0x21D2, "RIGHTWARDS DOUBLE ARROW" },
	{ 0x21D3, "DOWNWARDS DOUBLE ARROW" },
	{ 0x21D4, "LEFT RIGHT DOUBLE ARROW" },
	{ 0x21D5, "UP DOWN DOUBLE ARROW" },
	{ 0x21D6, "NORTH WEST DOUBLE ARROW" },
	{ 0x21D7, "NORTH EAST DOUBLE ARROW" },
	{ 0x21D8, "SOUTH EAST DOUBLE ARROW" },
	{ 0x21D9, "SOUTH WEST DOUBLE ARROW" },
	{ 0x21DA, "LEFTWARDS TRIPLE ARROW" },
	{ 0x21DB, "RIGHTWARDS TRIPLE ARROW" },
	{ 0x21DC, "LEFTWARDS SQUIGGLE ARROW" },
	{ 0x21DD, "RIGHTWARDS SQUIGGLE ARROW" },
	{ 0x21DE, "UPWARDS ARROW WITH DOUBLE STROKE" },
	{ 0x21DF, "DOWNWARDS ARROW WITH DOUBLE STROKE" },
	{ 0x21E0, "LEFTWARDS DASHED ARROW" },
	{ 0x21E1, "UPWARDS DASHED ARROW" },
	{ 0x21E2, "RIGHTWARDS DASHED ARROW" },
	{ 0x21E3, "DOWNWARDS DASHED ARROW" },
	{ 0x21E4, "LEFTWARDS ARROW TO BAR" },
	{ 0x21E5, "RIGHTWARDS ARROW TO BAR" },
	{ 0x21E6, "LEFTWARDS WHITE ARROW" },
	{ 0x21E7, "UPWARDS WHITE ARROW" },
	{ 0x21E8, "RIGHTWARDS WHITE ARROW" },
	{ 0x21E9, "DOWNWARDS WHITE ARROW" },
	{ 0x21EA, "UPWARDS WHITE ARROW FROM BAR" },
	{ 0x21EB, "UPWARDS WHITE ARROW ON PEDESTAL" },
	{ 0x21EC, "UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR" },
	{ 0x21ED, "UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR" },
	{ 0x21EE, "UPWARDS WHITE DOUBLE ARROW" },
	{ 0x21EF, "UPWARDS WHITE DOUBLE ARROW ON PEDESTAL" },
	{ 0x21F0, "RIGHTWARDS WHITE ARROW FROM WALL" },
	{ 0x21F1, "NORTH WEST ARROW TO CORNER" },
	{ 0x21F2, "SOUTH EAST ARROW TO CORNER" },
	{ 0x21F3, "UP DOWN WHITE ARROW" },
	{ 0x2200, "FOR ALL" },
	{ 0x2201, "COMPLEMENT" },
	{ 0x2202, "PARTIAL DIFFERENTIAL" },
	{ 0x2203, "THERE EXISTS" },
	{ 0x2204, "THERE DOES NOT EXIST" },
	{ 0x2205, "EMPTY SET" },
	{ 0x2206, "INCREMENT" },
	{ 0x2207, "NABLA" },
	{ 0x2208, "ELEMENT OF" },
	{ 0x2209, "NOT AN ELEMENT OF" },
	{ 0x220A, "SMALL ELEMENT OF" },
	{ 0x220B, "CONTAINS AS MEMBER" },
	{ 0x220C, "DOES NOT CONTAIN AS MEMBER" },
	{ 0x220D, "SMALL CONTAINS AS MEMBER" },
	{ 0x220E, "END OF PROOF" },
	{ 0x220F, "N-ARY PRODUCT" },
	{ 0x2210, "N-ARY COPRODUCT" },
	{ 0x2211, "N-ARY SUMMATION" },
	{ 0x2212, "MINUS SIGN" },
	{ 0x2213, "MINUS-OR-PLUS SIGN" },
	{ 0x2214, "DOT PLUS" },
	{ 0x2215, "DIVISION SLASH" },
	{ 0x2216, "SET MINUS" },
	{ 0x2217, "ASTERISK OPERATOR" },
	{ 0x2218, "RING OPERATOR" },
	{ 0x2219, "BULLET OPERATOR" },
	{ 0x221A, "SQUARE ROOT" },
	{ 0x221B, "CUBE ROOT" },
	{ 0x221C, "FOURTH ROOT" },
	{ 0x221D, "PROPORTIONAL TO" },
	{ 0x221E, "INFINITY" },
	{ 0x221F, "RIGHT ANGLE" },
	{ 0x2220, "ANGLE" },
	{ 0x2221, "MEASURED ANGLE" },
	{ 0x2222, "SPHERICAL ANGLE" },
	{ 0x2223, "DIVIDES" },
	{ 0x2224, "DOES NOT DIVIDE" },
	{ 0x2225, "PARALLEL TO" },
	{ 0x2226, "NOT PARALLEL TO" },
	{ 0x2227, "LOGICAL AND" },
	{ 0x2228, "LOGICAL OR" },
	{ 0x2229, "INTERSECTION" },
	{ 0x222A, "UNION" },
	{ 0x222B, "INTEGRAL" },
	{ 0x222C, "DOUBLE INTEGRAL" },
	{ 0x222D, "TRIPLE INTEGRAL" },
	{ 0x222E, "CONTOUR INTEGRAL" },
	{ 0x222F, "SURFACE INTEGRAL" },
	{ 0x2230, "VOLUME INTEGRAL" },
	{ 0x2231, "CLOCKWISE INTEGRAL" },
	{ 0x2232, "CLOCKWISE CONTOUR INTEGRAL" },
	{ 0x2233, "ANTICLOCKWISE CONTOUR INTEGRAL" },
	{ 0x2234, "THEREFORE" },
	{ 0x2235, "BECAUSE" },
	{ 0x2236, "RATIO" },
	{ 0x2237, "PROPORTION" },
	{ 0x2238, "DOT MINUS" },
	{ 0x2239, "EXCESS" },
	{ 0x223A, "GEOMETRIC PROPORTION" },
	{ 0x223B, "HOMOTHETIC" },
	{ 0x223C, "TILDE OPERATOR" },
	{ 0x223D, "REVERSED TILDE" },	/* lazy S */
	{ 0x223E, "INVERTED LAZY S" },
	{ 0x223F, "SINE WAVE" },
	{ 0x2240, "WREATH PRODUCT" },
	{ 0x2241, "NOT TILDE" },
	{ 0x2242, "MINUS TILDE" },
	{ 0x2243, "ASYMPTOTICALLY EQUAL TO" },
	{ 0x2244, "NOT ASYMPTOTICALLY EQUAL TO" },
	{ 0x2245, "APPROXIMATELY EQUAL TO" },
	{ 0x2246, "APPROXIMATELY BUT NOT ACTUALLY EQUAL TO" },
	{ 0x2247, "NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO" },
	{ 0x2248, "ALMOST EQUAL TO" },
	{ 0x2249, "NOT ALMOST EQUAL TO" },
	{ 0x224A, "ALMOST EQUAL OR EQUAL TO" },
	{ 0x224B, "TRIPLE TILDE" },
	{ 0x224C, "ALL EQUAL TO" },
	{ 0x224D, "EQUIVALENT TO" },
	{ 0x224E, "GEOMETRICALLY EQUIVALENT TO" },
	{ 0x224F, "DIFFERENCE BETWEEN" },
	{ 0x2250, "APPROACHES THE LIMIT" },
	{ 0x2251, "GEOMETRICALLY EQUAL TO" },
	{ 0x2252, "APPROXIMATELY EQUAL TO OR THE IMAGE OF" },
	{ 0x2253, "IMAGE OF OR APPROXIMATELY EQUAL TO" },
	{ 0x2254, "COLON EQUALS" },
	{ 0x2255, "EQUALS COLON" },
	{ 0x2256, "RING IN EQUAL TO" },
	{ 0x2257, "RING EQUAL TO" },
	{ 0x2258, "CORRESPONDS TO" },
	{ 0x2259, "ESTIMATES" },
	{ 0x225A, "EQUIANGULAR TO" },
	{ 0x225B, "STAR EQUALS" },
	{ 0x225C, "DELTA EQUAL TO" },
	{ 0x225D, "EQUAL TO BY DEFINITION" },
	{ 0x225E, "MEASURED BY" },
	{ 0x225F, "QUESTIONED EQUAL TO" },
	{ 0x2260, "NOT EQUAL TO" },
	{ 0x2261, "IDENTICAL TO" },
	{ 0x2262, "NOT IDENTICAL TO" },
	{ 0x2263, "STRICTLY EQUIVALENT TO" },
	{ 0x2264, "LESS-THAN OR EQUAL TO" },
	{ 0x2265, "GREATER-THAN OR EQUAL TO" },
	{ 0x2266, "LESS-THAN OVER EQUAL TO" },
	{ 0x2267, "GREATER-THAN OVER EQUAL TO" },
	{ 0x2268, "LESS-THAN BUT NOT EQUAL TO" },
	{ 0x2269, "GREATER-THAN BUT NOT EQUAL TO" },
	{ 0x226A, "MUCH LESS-THAN" },
	{ 0x226B, "MUCH GREATER-THAN" },
	{ 0x226C, "BETWEEN" },
	{ 0x226D, "NOT EQUIVALENT TO" },
	{ 0x226E, "NOT LESS-THAN" },
	{ 0x226F, "NOT GREATER-THAN" },
	{ 0x2270, "NEITHER LESS-THAN NOR EQUAL TO" },
	{ 0x2271, "NEITHER GREATER-THAN NOR EQUAL TO" },
	{ 0x2272, "LESS-THAN OR EQUIVALENT TO" },
	{ 0x2273, "GREATER-THAN OR EQUIVALENT TO" },
	{ 0x2274, "NEITHER LESS-THAN NOR EQUIVALENT TO" },
	{ 0x2275, "NEITHER GREATER-THAN NOR EQUIVALENT TO" },
	{ 0x2276, "LESS-THAN OR GREATER-THAN" },
	{ 0x2277, "GREATER-THAN OR LESS-THAN" },
	{ 0x2278, "NEITHER LESS-THAN NOR GREATER-THAN" },
	{ 0x2279, "NEITHER GREATER-THAN NOR LESS-THAN" },
	{ 0x227A, "PRECEDES" },
	{ 0x227B, "SUCCEEDS" },
	{ 0x227C, "PRECEDES OR EQUAL TO" },
	{ 0x227D, "SUCCEEDS OR EQUAL TO" },
	{ 0x227E, "PRECEDES OR EQUIVALENT TO" },
	{ 0x227F, "SUCCEEDS OR EQUIVALENT TO" },
	{ 0x2280, "DOES NOT PRECEDE" },
	{ 0x2281, "DOES NOT SUCCEED" },
	{ 0x2282, "SUBSET OF" },
	{ 0x2283, "SUPERSET OF" },
	{ 0x2284, "NOT A SUBSET OF" },
	{ 0x2285, "NOT A SUPERSET OF" },
	{ 0x2286, "SUBSET OF OR EQUAL TO" },
	{ 0x2287, "SUPERSET OF OR EQUAL TO" },
	{ 0x2288, "NEITHER A SUBSET OF NOR EQUAL TO" },
	{ 0x2289, "NEITHER A SUPERSET OF NOR EQUAL TO" },
	{ 0x228A, "SUBSET OF WITH NOT EQUAL TO" },
	{ 0x228B, "SUPERSET OF WITH NOT EQUAL TO" },
	{ 0x228C, "MULTISET" },
	{ 0x228D, "MULTISET MULTIPLICATION" },
	{ 0x228E, "MULTISET UNION" },
	{ 0x228F, "SQUARE IMAGE OF" },
	{ 0x2290, "SQUARE ORIGINAL OF" },
	{ 0x2291, "SQUARE IMAGE OF OR EQUAL TO" },
	{ 0x2292, "SQUARE ORIGINAL OF OR EQUAL TO" },
	{ 0x2293, "SQUARE CAP" },
	{ 0x2294, "SQUARE CUP" },
	{ 0x2295, "CIRCLED PLUS" },
	{ 0x2296, "CIRCLED MINUS" },
	{ 0x2297, "CIRCLED TIMES" },
	{ 0x2298, "CIRCLED DIVISION SLASH" },
	{ 0x2299, "CIRCLED DOT OPERATOR" },
	{ 0x229A, "CIRCLED RING OPERATOR" },
	{ 0x229B, "CIRCLED ASTERISK OPERATOR" },
	{ 0x229C, "CIRCLED EQUALS" },
	{ 0x229D, "CIRCLED DASH" },
	{ 0x229E, "SQUARED PLUS" },
	{ 0x229F, "SQUARED MINUS" },
	{ 0x22A0, "SQUARED TIMES" },
	{ 0x22A1, "SQUARED DOT OPERATOR" },
	{ 0x22A2, "RIGHT TACK" },
	{ 0x22A3, "LEFT TACK" },
	{ 0x22A4, "DOWN TACK" },
	{ 0x22A5, "UP TACK" },
	{ 0x22A6, "ASSERTION" },
	{ 0x22A7, "MODELS" },
	{ 0x22A8, "TRUE" },
	{ 0x22A9, "FORCES" },
	{ 0x22AA, "TRIPLE VERTICAL BAR RIGHT TURNSTILE" },
	{ 0x22AB, "DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" },
	{ 0x22AC, "DOES NOT PROVE" },
	{ 0x22AD, "NOT TRUE" },
	{ 0x22AE, "DOES NOT FORCE" },
	{ 0x22AF, "NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" },
	{ 0x22B0, "PRECEDES UNDER RELATION" },
	{ 0x22B1, "SUCCEEDS UNDER RELATION" },
	{ 0x22B2, "NORMAL SUBGROUP OF" },
	{ 0x22B3, "CONTAINS AS NORMAL SUBGROUP" },
	{ 0x22B4, "NORMAL SUBGROUP OF OR EQUAL TO" },
	{ 0x22B5, "CONTAINS AS NORMAL SUBGROUP OR EQUAL TO" },
	{ 0x22B6, "ORIGINAL OF" },
	{ 0x22B7, "IMAGE OF" },
	{ 0x22B8, "MULTIMAP" },
	{ 0x22B9, "HERMITIAN CONJUGATE MATRIX" },
	{ 0x22BA, "INTERCALATE" },
	{ 0x22BB, "XOR" },
	{ 0x22BC, "NAND" },
	{ 0x22BD, "NOR" },
	{ 0x22BE, "RIGHT ANGLE WITH ARC" },
	{ 0x22BF, "RIGHT TRIANGLE" },
	{ 0x22C0, "N-ARY LOGICAL AND" },
	{ 0x22C1, "N-ARY LOGICAL OR" },
	{ 0x22C2, "N-ARY INTERSECTION" },
	{ 0x22C3, "N-ARY UNION" },
	{ 0x22C4, "DIAMOND OPERATOR" },
	{ 0x22C5, "DOT OPERATOR" },
	{ 0x22C6, "STAR OPERATOR" },
	{ 0x22C7, "DIVISION TIMES" },
	{ 0x22C8, "BOWTIE" },
	{ 0x22C9, "LEFT NORMAL FACTOR SEMIDIRECT PRODUCT" },
	{ 0x22CA, "RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT" },
	{ 0x22CB, "LEFT SEMIDIRECT PRODUCT" },
	{ 0x22CC, "RIGHT SEMIDIRECT PRODUCT" },
	{ 0x22CD, "REVERSED TILDE EQUALS" },
	{ 0x22CE, "CURLY LOGICAL OR" },
	{ 0x22CF, "CURLY LOGICAL AND" },
	{ 0x22D0, "DOUBLE SUBSET" },
	{ 0x22D1, "DOUBLE SUPERSET" },
	{ 0x22D2, "DOUBLE INTERSECTION" },
	{ 0x22D3, "DOUBLE UNION" },
	{ 0x22D4, "PITCHFORK" },
	{ 0x22D5, "EQUAL AND PARALLEL TO" },
	{ 0x22D6, "LESS-THAN WITH DOT" },
	{ 0x22D7, "GREATER-THAN WITH DOT" },
	{ 0x22D8, "VERY MUCH LESS-THAN" },
	{ 0x22D9, "VERY MUCH GREATER-THAN" },
	{ 0x22DA, "LESS-THAN EQUAL TO OR GREATER-THAN" },
	{ 0x22DB, "GREATER-THAN EQUAL TO OR LESS-THAN" },
	{ 0x22DC, "EQUAL TO OR LESS-THAN" },
	{ 0x22DD, "EQUAL TO OR GREATER-THAN" },
	{ 0x22DE, "EQUAL TO OR PRECEDES" },
	{ 0x22DF, "EQUAL TO OR SUCCEEDS" },
	{ 0x22E0, "DOES NOT PRECEDE OR EQUAL" },
	{ 0x22E1, "DOES NOT SUCCEED OR EQUAL" },
	{ 0x22E2, "NOT SQUARE IMAGE OF OR EQUAL TO" },
	{ 0x22E3, "NOT SQUARE ORIGINAL OF OR EQUAL TO" },
	{ 0x22E4, "SQUARE IMAGE OF OR NOT EQUAL TO" },
	{ 0x22E5, "SQUARE ORIGINAL OF OR NOT EQUAL TO" },
	{ 0x22E6, "LESS-THAN BUT NOT EQUIVALENT TO" },
	{ 0x22E7, "GREATER-THAN BUT NOT EQUIVALENT TO" },
	{ 0x22E8, "PRECEDES BUT NOT EQUIVALENT TO" },
	{ 0x22E9, "SUCCEEDS BUT NOT EQUIVALENT TO" },
	{ 0x22EA, "NOT NORMAL SUBGROUP OF" },
	{ 0x22EB, "DOES NOT CONTAIN AS NORMAL SUBGROUP" },
	{ 0x22EC, "NOT NORMAL SUBGROUP OF OR EQUAL TO" },
	{ 0x22ED, "DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL" },
	{ 0x22EE, "VERTICAL ELLIPSIS" },
	{ 0x22EF, "MIDLINE HORIZONTAL ELLIPSIS" },
	{ 0x22F0, "UP RIGHT DIAGONAL ELLIPSIS" },
	{ 0x22F1, "DOWN RIGHT DIAGONAL ELLIPSIS" },
	{ 0x2300, "DIAMETER SIGN" },
	{ 0x2301, "ELECTRIC ARROW" },
	{ 0x2302, "HOUSE" },
	{ 0x2303, "UP ARROWHEAD" },
	{ 0x2304, "DOWN ARROWHEAD" },
	{ 0x2305, "PROJECTIVE" },
	{ 0x2306, "PERSPECTIVE" },
	{ 0x2307, "WAVY LINE" },
	{ 0x2308, "LEFT CEILING" },
	{ 0x2309, "RIGHT CEILING" },
	{ 0x230A, "LEFT FLOOR" },
	{ 0x230B, "RIGHT FLOOR" },
	{ 0x230C, "BOTTOM RIGHT CROP" },
	{ 0x230D, "BOTTOM LEFT CROP" },
	{ 0x230E, "TOP RIGHT CROP" },
	{ 0x230F, "TOP LEFT CROP" },
	{ 0x2310, "REVERSED NOT SIGN" },
	{ 0x2311, "SQUARE LOZENGE" },
	{ 0x2312, "ARC" },
	{ 0x2313, "SEGMENT" },
	{ 0x2314, "SECTOR" },
	{ 0x2315, "TELEPHONE RECORDER" },
	{ 0x2316, "POSITION INDICATOR" },
	{ 0x2317, "VIEWDATA SQUARE" },
	{ 0x2318, "PLACE OF INTEREST SIGN" },
	{ 0x2319, "TURNED NOT SIGN" },
	{ 0x231A, "WATCH" },
	{ 0x231B, "HOURGLASS" },
	{ 0x231C, "TOP LEFT CORNER" },
	{ 0x231D, "TOP RIGHT CORNER" },
	{ 0x231E, "BOTTOM LEFT CORNER" },
	{ 0x231F, "BOTTOM RIGHT CORNER" },
	{ 0x2320, "TOP HALF INTEGRAL" },
	{ 0x2321, "BOTTOM HALF INTEGRAL" },
	{ 0x2322, "FROWN" },
	{ 0x2323, "SMILE" },
	{ 0x2324, "UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS" },
	{ 0x2325, "OPTION KEY" },
	{ 0x2326, "ERASE TO THE RIGHT" },
	{ 0x2327, "X IN A RECTANGLE BOX" },
	{ 0x2328, "KEYBOARD" },
	{ 0x2329, "LEFT-POINTING ANGLE BRACKET" },
	{ 0x232A, "RIGHT-POINTING ANGLE BRACKET" },
	{ 0x232B, "ERASE TO THE LEFT" },
	{ 0x232C, "BENZENE RING" },
	{ 0x232D, "CYLINDRICITY" },
	{ 0x232E, "ALL AROUND-PROFILE" },
	{ 0x232F, "SYMMETRY" },
	{ 0x2330, "TOTAL RUNOUT" },
	{ 0x2331, "DIMENSION ORIGIN" },
	{ 0x2332, "CONICAL TAPER" },
	{ 0x2333, "SLOPE" },
	{ 0x2334, "COUNTERBORE" },
	{ 0x2335, "COUNTERSINK" },
	{ 0x2336, "APL FUNCTIONAL SYMBOL I-BEAM" },
	{ 0x2337, "APL FUNCTIONAL SYMBOL SQUISH QUAD" },
	{ 0x2338, "APL FUNCTIONAL SYMBOL QUAD EQUAL" },
	{ 0x2339, "APL FUNCTIONAL SYMBOL QUAD DIVIDE" },
	{ 0x233A, "APL FUNCTIONAL SYMBOL QUAD DIAMOND" },
	{ 0x233B, "APL FUNCTIONAL SYMBOL QUAD JOT" },
	{ 0x233C, "APL FUNCTIONAL SYMBOL QUAD CIRCLE" },
	{ 0x233D, "APL FUNCTIONAL SYMBOL CIRCLE STILE" },
	{ 0x233E, "APL FUNCTIONAL SYMBOL CIRCLE JOT" },
	{ 0x233F, "APL FUNCTIONAL SYMBOL SLASH BAR" },
	{ 0x2340, "APL FUNCTIONAL SYMBOL BACKSLASH BAR" },
	{ 0x2341, "APL FUNCTIONAL SYMBOL QUAD SLASH" },
	{ 0x2342, "APL FUNCTIONAL SYMBOL QUAD BACKSLASH" },
	{ 0x2343, "APL FUNCTIONAL SYMBOL QUAD LESS-THAN" },
	{ 0x2344, "APL FUNCTIONAL SYMBOL QUAD GREATER-THAN" },
	{ 0x2345, "APL FUNCTIONAL SYMBOL LEFTWARDS VANE" },
	{ 0x2346, "APL FUNCTIONAL SYMBOL RIGHTWARDS VANE" },
	{ 0x2347, "APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW" },
	{ 0x2348, "APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW" },
	{ 0x2349, "APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH" },
	{ 0x234A, "APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR" },	/* * */
	{ 0x234B, "APL FUNCTIONAL SYMBOL DELTA STILE" },
	{ 0x234C, "APL FUNCTIONAL SYMBOL QUAD DOWN CARET" },
	{ 0x234D, "APL FUNCTIONAL SYMBOL QUAD DELTA" },
	{ 0x234E, "APL FUNCTIONAL SYMBOL DOWN TACK JOT" },	/* * */
	{ 0x234F, "APL FUNCTIONAL SYMBOL UPWARDS VANE" },
	{ 0x2350, "APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW" },
	{ 0x2351, "APL FUNCTIONAL SYMBOL UP TACK OVERBAR" },	/* * */
	{ 0x2352, "APL FUNCTIONAL SYMBOL DEL STILE" },
	{ 0x2353, "APL FUNCTIONAL SYMBOL QUAD UP CARET" },
	{ 0x2354, "APL FUNCTIONAL SYMBOL QUAD DEL" },
	{ 0x2355, "APL FUNCTIONAL SYMBOL UP TACK JOT" },	/* * */
	{ 0x2356, "APL FUNCTIONAL SYMBOL DOWNWARDS VANE" },
	{ 0x2357, "APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW" },
	{ 0x2358, "APL FUNCTIONAL SYMBOL QUOTE UNDERBAR" },
	{ 0x2359, "APL FUNCTIONAL SYMBOL DELTA UNDERBAR" },
	{ 0x235A, "APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR" },
	{ 0x235B, "APL FUNCTIONAL SYMBOL JOT UNDERBAR" },
	{ 0x235C, "APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR" },
	{ 0x235D, "APL FUNCTIONAL SYMBOL UP SHOE JOT" },
	{ 0x235E, "APL FUNCTIONAL SYMBOL QUOTE QUAD" },
	{ 0x235F, "APL FUNCTIONAL SYMBOL CIRCLE STAR" },
	{ 0x2360, "APL FUNCTIONAL SYMBOL QUAD COLON" },
	{ 0x2361, "APL FUNCTIONAL SYMBOL UP TACK DIAERESIS" },	/* * */
	{ 0x2362, "APL FUNCTIONAL SYMBOL DEL DIAERESIS" },
	{ 0x2363, "APL FUNCTIONAL SYMBOL STAR DIAERESIS" },
	{ 0x2364, "APL FUNCTIONAL SYMBOL JOT DIAERESIS" },
	{ 0x2365, "APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS" },
	{ 0x2366, "APL FUNCTIONAL SYMBOL DOWN SHOE STILE" },
	{ 0x2367, "APL FUNCTIONAL SYMBOL LEFT SHOE STILE" },
	{ 0x2368, "APL FUNCTIONAL SYMBOL TILDE DIAERESIS" },
	{ 0x2369, "APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS" },
	{ 0x236A, "APL FUNCTIONAL SYMBOL COMMA BAR" },
	{ 0x236B, "APL FUNCTIONAL SYMBOL DEL TILDE" },
	{ 0x236C, "APL FUNCTIONAL SYMBOL ZILDE" },
	{ 0x236D, "APL FUNCTIONAL SYMBOL STILE TILDE" },
	{ 0x236E, "APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR" },
	{ 0x236F, "APL FUNCTIONAL SYMBOL QUAD NOT EQUAL" },
	{ 0x2370, "APL FUNCTIONAL SYMBOL QUAD QUESTION" },
	{ 0x2371, "APL FUNCTIONAL SYMBOL DOWN CARET TILDE" },
	{ 0x2372, "APL FUNCTIONAL SYMBOL UP CARET TILDE" },
	{ 0x2373, "APL FUNCTIONAL SYMBOL IOTA" },
	{ 0x2374, "APL FUNCTIONAL SYMBOL RHO" },
	{ 0x2375, "APL FUNCTIONAL SYMBOL OMEGA" },
	{ 0x2376, "APL FUNCTIONAL SYMBOL ALPHA UNDERBAR" },
	{ 0x2377, "APL FUNCTIONAL SYMBOL EPSILON UNDERBAR" },
	{ 0x2378, "APL FUNCTIONAL SYMBOL IOTA UNDERBAR" },
	{ 0x2379, "APL FUNCTIONAL SYMBOL OMEGA UNDERBAR" },
	{ 0x237A, "APL FUNCTIONAL SYMBOL ALPHA" },
	{ 0x237B, "NOT CHECK MARK" },
	{ 0x237D, "SHOULDERED OPEN BOX" },
	{ 0x237E, "BELL SYMBOL" },
	{ 0x237F, "VERTICAL LINE WITH MIDDLE DOT" },
	{ 0x2380, "INSERTION SYMBOL" },
	{ 0x2381, "CONTINUOUS UNDERLINE SYMBOL" },
	{ 0x2382, "DISCONTINUOUS UNDERLINE SYMBOL" },
	{ 0x2383, "EMPHASIS SYMBOL" },
	{ 0x2384, "COMPOSITION SYMBOL" },
	{ 0x2385, "WHITE SQUARE WITH CENTRE VERTICAL LINE" },
	{ 0x2386, "ENTER SYMBOL" },
	{ 0x2387, "ALTERNATIVE KEY SYMBOL" },
	{ 0x2388, "HELM SYMBOL" },
	{ 0x2389, "CIRCLED HORIZONTAL BAR WITH NOTCH" },	/* pause */
	{ 0x238A, "CIRCLED TRIANGLE DOWN" },	/* break */
	{ 0x238B, "BROKEN CIRCLE WITH NORTHWEST ARROW" },	/* escape */
	{ 0x238C, "UNDO SYMBOL" },
	{ 0x238D, "MONOSTABLE SYMBOL" },
	{ 0x238E, "HYSTERESIS SYMBOL" },
	{ 0x238F, "OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL" },
	{ 0x2390, "OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL" },
	{ 0x2391, "PASSIVE-PULL-DOWN-OUTPUT SYMBOL" },
	{ 0x2392, "PASSIVE-PULL-UP-OUTPUT SYMBOL" },
	{ 0x2393, "DIRECT CURRENT SYMBOL FORM TWO" },
	{ 0x2394, "SOFTWARE-FUNCTION SYMBOL" },
	{ 0x2395, "APL FUNCTIONAL SYMBOL QUAD" },
	{ 0x2396, "DECIMAL SEPARATOR KEY SYMBOL" },
	{ 0x2397, "PREVIOUS PAGE" },
	{ 0x2398, "NEXT PAGE" },
	{ 0x2399, "PRINT SCREEN SYMBOL" },
	{ 0x239A, "CLEAR SCREEN SYMBOL" },
	{ 0x2400, "SYMBOL FOR NULL" },
	{ 0x2401, "SYMBOL FOR START OF HEADING" },
	{ 0x2402, "SYMBOL FOR START OF TEXT" },
	{ 0x2403, "SYMBOL FOR END OF TEXT" },
	{ 0x2404, "SYMBOL FOR END OF TRANSMISSION" },
	{ 0x2405, "SYMBOL FOR ENQUIRY" },
	{ 0x2406, "SYMBOL FOR ACKNOWLEDGE" },
	{ 0x2407, "SYMBOL FOR BELL" },
	{ 0x2408, "SYMBOL FOR BACKSPACE" },
	{ 0x2409, "SYMBOL FOR HORIZONTAL TABULATION" },
	{ 0x240A, "SYMBOL FOR LINE FEED" },
	{ 0x240B, "SYMBOL FOR VERTICAL TABULATION" },
	{ 0x240C, "SYMBOL FOR FORM FEED" },
	{ 0x240D, "SYMBOL FOR CARRIAGE RETURN" },
	{ 0x240E, "SYMBOL FOR SHIFT OUT" },
	{ 0x240F, "SYMBOL FOR SHIFT IN" },
	{ 0x2410, "SYMBOL FOR DATA LINK ESCAPE" },
	{ 0x2411, "SYMBOL FOR DEVICE CONTROL ONE" },
	{ 0x2412, "SYMBOL FOR DEVICE CONTROL TWO" },
	{ 0x2413, "SYMBOL FOR DEVICE CONTROL THREE" },
	{ 0x2414, "SYMBOL FOR DEVICE CONTROL FOUR" },
	{ 0x2415, "SYMBOL FOR NEGATIVE ACKNOWLEDGE" },
	{ 0x2416, "SYMBOL FOR SYNCHRONOUS IDLE" },
	{ 0x2417, "SYMBOL FOR END OF TRANSMISSION BLOCK" },
	{ 0x2418, "SYMBOL FOR CANCEL" },
	{ 0x2419, "SYMBOL FOR END OF MEDIUM" },
	{ 0x241A, "SYMBOL FOR SUBSTITUTE" },
	{ 0x241B, "SYMBOL FOR ESCAPE" },
	{ 0x241C, "SYMBOL FOR FILE SEPARATOR" },
	{ 0x241D, "SYMBOL FOR GROUP SEPARATOR" },
	{ 0x241E, "SYMBOL FOR RECORD SEPARATOR" },
	{ 0x241F, "SYMBOL FOR UNIT SEPARATOR" },
	{ 0x2420, "SYMBOL FOR SPACE" },
	{ 0x2421, "SYMBOL FOR DELETE" },
	{ 0x2422, "BLANK SYMBOL" },
	{ 0x2423, "OPEN BOX" },
	{ 0x2424, "SYMBOL FOR NEWLINE" },
	{ 0x2425, "SYMBOL FOR DELETE FORM TWO" },
	{ 0x2426, "SYMBOL FOR SUBSTITUTE FORM TWO" },
	{ 0x2440, "OCR HOOK" },
	{ 0x2441, "OCR CHAIR" },
	{ 0x2442, "OCR FORK" },
	{ 0x2443, "OCR INVERTED FORK" },
	{ 0x2444, "OCR BELT BUCKLE" },
	{ 0x2445, "OCR BOW TIE" },
	{ 0x2446, "OCR BRANCH BANK IDENTIFICATION" },
	{ 0x2447, "OCR AMOUNT OF CHECK" },
	{ 0x2448, "OCR DASH" },
	{ 0x2449, "OCR CUSTOMER ACCOUNT NUMBER" },
	{ 0x244A, "OCR DOUBLE BACKSLASH" },
	{ 0x2460, "CIRCLED DIGIT ONE" },
	{ 0x2461, "CIRCLED DIGIT TWO" },
	{ 0x2462, "CIRCLED DIGIT THREE" },
	{ 0x2463, "CIRCLED DIGIT FOUR" },
	{ 0x2464, "CIRCLED DIGIT FIVE" },
	{ 0x2465, "CIRCLED DIGIT SIX" },
	{ 0x2466, "CIRCLED DIGIT SEVEN" },
	{ 0x2467, "CIRCLED DIGIT EIGHT" },
	{ 0x2468, "CIRCLED DIGIT NINE" },
	{ 0x2469, "CIRCLED NUMBER TEN" },
	{ 0x246A, "CIRCLED NUMBER ELEVEN" },
	{ 0x246B, "CIRCLED NUMBER TWELVE" },
	{ 0x246C, "CIRCLED NUMBER THIRTEEN" },
	{ 0x246D, "CIRCLED NUMBER FOURTEEN" },
	{ 0x246E, "CIRCLED NUMBER FIFTEEN" },
	{ 0x246F, "CIRCLED NUMBER SIXTEEN" },
	{ 0x2470, "CIRCLED NUMBER SEVENTEEN" },
	{ 0x2471, "CIRCLED NUMBER EIGHTEEN" },
	{ 0x2472, "CIRCLED NUMBER NINETEEN" },
	{ 0x2473, "CIRCLED NUMBER TWENTY" },
	{ 0x2474, "PARENTHESIZED DIGIT ONE" },
	{ 0x2475, "PARENTHESIZED DIGIT TWO" },
	{ 0x2476, "PARENTHESIZED DIGIT THREE" },
	{ 0x2477, "PARENTHESIZED DIGIT FOUR" },
	{ 0x2478, "PARENTHESIZED DIGIT FIVE" },
	{ 0x2479, "PARENTHESIZED DIGIT SIX" },
	{ 0x247A, "PARENTHESIZED DIGIT SEVEN" },
	{ 0x247B, "PARENTHESIZED DIGIT EIGHT" },
	{ 0x247C, "PARENTHESIZED DIGIT NINE" },
	{ 0x247D, "PARENTHESIZED NUMBER TEN" },
	{ 0x247E, "PARENTHESIZED NUMBER ELEVEN" },
	{ 0x247F, "PARENTHESIZED NUMBER TWELVE" },
	{ 0x2480, "PARENTHESIZED NUMBER THIRTEEN" },
	{ 0x2481, "PARENTHESIZED NUMBER FOURTEEN" },
	{ 0x2482, "PARENTHESIZED NUMBER FIFTEEN" },
	{ 0x2483, "PARENTHESIZED NUMBER SIXTEEN" },
	{ 0x2484, "PARENTHESIZED NUMBER SEVENTEEN" },
	{ 0x2485, "PARENTHESIZED NUMBER EIGHTEEN" },
	{ 0x2486, "PARENTHESIZED NUMBER NINETEEN" },
	{ 0x2487, "PARENTHESIZED NUMBER TWENTY" },
	{ 0x2488, "DIGIT ONE FULL STOP" },
	{ 0x2489, "DIGIT TWO FULL STOP" },
	{ 0x248A, "DIGIT THREE FULL STOP" },
	{ 0x248B, "DIGIT FOUR FULL STOP" },
	{ 0x248C, "DIGIT FIVE FULL STOP" },
	{ 0x248D, "DIGIT SIX FULL STOP" },
	{ 0x248E, "DIGIT SEVEN FULL STOP" },
	{ 0x248F, "DIGIT EIGHT FULL STOP" },
	{ 0x2490, "DIGIT NINE FULL STOP" },
	{ 0x2491, "NUMBER TEN FULL STOP" },
	{ 0x2492, "NUMBER ELEVEN FULL STOP" },
	{ 0x2493, "NUMBER TWELVE FULL STOP" },
	{ 0x2494, "NUMBER THIRTEEN FULL STOP" },
	{ 0x2495, "NUMBER FOURTEEN FULL STOP" },
	{ 0x2496, "NUMBER FIFTEEN FULL STOP" },
	{ 0x2497, "NUMBER SIXTEEN FULL STOP" },
	{ 0x2498, "NUMBER SEVENTEEN FULL STOP" },
	{ 0x2499, "NUMBER EIGHTEEN FULL STOP" },
	{ 0x249A, "NUMBER NINETEEN FULL STOP" },
	{ 0x249B, "NUMBER TWENTY FULL STOP" },
	{ 0x249C, "PARENTHESIZED LATIN SMALL LETTER A" },
	{ 0x249D, "PARENTHESIZED LATIN SMALL LETTER B" },
	{ 0x249E, "PARENTHESIZED LATIN SMALL LETTER C" },
	{ 0x249F, "PARENTHESIZED LATIN SMALL LETTER D" },
	{ 0x24A0, "PARENTHESIZED LATIN SMALL LETTER E" },
	{ 0x24A1, "PARENTHESIZED LATIN SMALL LETTER F" },
	{ 0x24A2, "PARENTHESIZED LATIN SMALL LETTER G" },
	{ 0x24A3, "PARENTHESIZED LATIN SMALL LETTER H" },
	{ 0x24A4, "PARENTHESIZED LATIN SMALL LETTER I" },
	{ 0x24A5, "PARENTHESIZED LATIN SMALL LETTER J" },
	{ 0x24A6, "PARENTHESIZED LATIN SMALL LETTER K" },
	{ 0x24A7, "PARENTHESIZED LATIN SMALL LETTER L" },
	{ 0x24A8, "PARENTHESIZED LATIN SMALL LETTER M" },
	{ 0x24A9, "PARENTHESIZED LATIN SMALL LETTER N" },
	{ 0x24AA, "PARENTHESIZED LATIN SMALL LETTER O" },
	{ 0x24AB, "PARENTHESIZED LATIN SMALL LETTER P" },
	{ 0x24AC, "PARENTHESIZED LATIN SMALL LETTER Q" },
	{ 0x24AD, "PARENTHESIZED LATIN SMALL LETTER R" },
	{ 0x24AE, "PARENTHESIZED LATIN SMALL LETTER S" },
	{ 0x24AF, "PARENTHESIZED LATIN SMALL LETTER T" },
	{ 0x24B0, "PARENTHESIZED LATIN SMALL LETTER U" },
	{ 0x24B1, "PARENTHESIZED LATIN SMALL LETTER V" },
	{ 0x24B2, "PARENTHESIZED LATIN SMALL LETTER W" },
	{ 0x24B3, "PARENTHESIZED LATIN SMALL LETTER X" },
	{ 0x24B4, "PARENTHESIZED LATIN SMALL LETTER Y" },
	{ 0x24B5, "PARENTHESIZED LATIN SMALL LETTER Z" },
	{ 0x24B6, "CIRCLED LATIN CAPITAL LETTER A" },
	{ 0x24B7, "CIRCLED LATIN CAPITAL LETTER B" },
	{ 0x24B8, "CIRCLED LATIN CAPITAL LETTER C" },
	{ 0x24B9, "CIRCLED LATIN CAPITAL LETTER D" },
	{ 0x24BA, "CIRCLED LATIN CAPITAL LETTER E" },
	{ 0x24BB, "CIRCLED LATIN CAPITAL LETTER F" },
	{ 0x24BC, "CIRCLED LATIN CAPITAL LETTER G" },
	{ 0x24BD, "CIRCLED LATIN CAPITAL LETTER H" },
	{ 0x24BE, "CIRCLED LATIN CAPITAL LETTER I" },
	{ 0x24BF, "CIRCLED LATIN CAPITAL LETTER J" },
	{ 0x24C0, "CIRCLED LATIN CAPITAL LETTER K" },
	{ 0x24C1, "CIRCLED LATIN CAPITAL LETTER L" },
	{ 0x24C2, "CIRCLED LATIN CAPITAL LETTER M" },
	{ 0x24C3, "CIRCLED LATIN CAPITAL LETTER N" },
	{ 0x24C4, "CIRCLED LATIN CAPITAL LETTER O" },
	{ 0x24C5, "CIRCLED LATIN CAPITAL LETTER P" },
	{ 0x24C6, "CIRCLED LATIN CAPITAL LETTER Q" },
	{ 0x24C7, "CIRCLED LATIN CAPITAL LETTER R" },
	{ 0x24C8, "CIRCLED LATIN CAPITAL LETTER S" },
	{ 0x24C9, "CIRCLED LATIN CAPITAL LETTER T" },
	{ 0x24CA, "CIRCLED LATIN CAPITAL LETTER U" },
	{ 0x24CB, "CIRCLED LATIN CAPITAL LETTER V" },
	{ 0x24CC, "CIRCLED LATIN CAPITAL LETTER W" },
	{ 0x24CD, "CIRCLED LATIN CAPITAL LETTER X" },
	{ 0x24CE, "CIRCLED LATIN CAPITAL LETTER Y" },
	{ 0x24CF, "CIRCLED LATIN CAPITAL LETTER Z" },
	{ 0x24D0, "CIRCLED LATIN SMALL LETTER A" },
	{ 0x24D1, "CIRCLED LATIN SMALL LETTER B" },
	{ 0x24D2, "CIRCLED LATIN SMALL LETTER C" },
	{ 0x24D3, "CIRCLED LATIN SMALL LETTER D" },
	{ 0x24D4, "CIRCLED LATIN SMALL LETTER E" },
	{ 0x24D5, "CIRCLED LATIN SMALL LETTER F" },
	{ 0x24D6, "CIRCLED LATIN SMALL LETTER G" },
	{ 0x24D7, "CIRCLED LATIN SMALL LETTER H" },
	{ 0x24D8, "CIRCLED LATIN SMALL LETTER I" },
	{ 0x24D9, "CIRCLED LATIN SMALL LETTER J" },
	{ 0x24DA, "CIRCLED LATIN SMALL LETTER K" },
	{ 0x24DB, "CIRCLED LATIN SMALL LETTER L" },
	{ 0x24DC, "CIRCLED LATIN SMALL LETTER M" },
	{ 0x24DD, "CIRCLED LATIN SMALL LETTER N" },
	{ 0x24DE, "CIRCLED LATIN SMALL LETTER O" },
	{ 0x24DF, "CIRCLED LATIN SMALL LETTER P" },
	{ 0x24E0, "CIRCLED LATIN SMALL LETTER Q" },
	{ 0x24E1, "CIRCLED LATIN SMALL LETTER R" },
	{ 0x24E2, "CIRCLED LATIN SMALL LETTER S" },
	{ 0x24E3, "CIRCLED LATIN SMALL LETTER T" },
	{ 0x24E4, "CIRCLED LATIN SMALL LETTER U" },
	{ 0x24E5, "CIRCLED LATIN SMALL LETTER V" },
	{ 0x24E6, "CIRCLED LATIN SMALL LETTER W" },
	{ 0x24E7, "CIRCLED LATIN SMALL LETTER X" },
	{ 0x24E8, "CIRCLED LATIN SMALL LETTER Y" },
	{ 0x24E9, "CIRCLED LATIN SMALL LETTER Z" },
	{ 0x24EA, "CIRCLED DIGIT ZERO" },
	{ 0x2500, "BOX DRAWINGS LIGHT HORIZONTAL" },
	{ 0x2501, "BOX DRAWINGS HEAVY HORIZONTAL" },
	{ 0x2502, "BOX DRAWINGS LIGHT VERTICAL" },
	{ 0x2503, "BOX DRAWINGS HEAVY VERTICAL" },
	{ 0x2504, "BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL" },
	{ 0x2505, "BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL" },
	{ 0x2506, "BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL" },
	{ 0x2507, "BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL" },
	{ 0x2508, "BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL" },
	{ 0x2509, "BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL" },
	{ 0x250A, "BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL" },
	{ 0x250B, "BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL" },
	{ 0x250C, "BOX DRAWINGS LIGHT DOWN AND RIGHT" },
	{ 0x250D, "BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY" },
	{ 0x250E, "BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT" },
	{ 0x250F, "BOX DRAWINGS HEAVY DOWN AND RIGHT" },
	{ 0x2510, "BOX DRAWINGS LIGHT DOWN AND LEFT" },
	{ 0x2511, "BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY" },
	{ 0x2512, "BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" },
	{ 0x2513, "BOX DRAWINGS HEAVY DOWN AND LEFT" },
	{ 0x2514, "BOX DRAWINGS LIGHT UP AND RIGHT" },
	{ 0x2515, "BOX DRAWINGS UP LIGHT AND RIGHT HEAVY" },
	{ 0x2516, "BOX DRAWINGS UP HEAVY AND RIGHT LIGHT" },
	{ 0x2517, "BOX DRAWINGS HEAVY UP AND RIGHT" },
	{ 0x2518, "BOX DRAWINGS LIGHT UP AND LEFT" },
	{ 0x2519, "BOX DRAWINGS UP LIGHT AND LEFT HEAVY" },
	{ 0x251A, "BOX DRAWINGS UP HEAVY AND LEFT LIGHT" },
	{ 0x251B, "BOX DRAWINGS HEAVY UP AND LEFT" },
	{ 0x251C, "BOX DRAWINGS LIGHT VERTICAL AND RIGHT" },
	{ 0x251D, "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY" },
	{ 0x251E, "BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT" },
	{ 0x251F, "BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT" },
	{ 0x2520, "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT" },
	{ 0x2521, "BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY" },
	{ 0x2522, "BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY" },
	{ 0x2523, "BOX DRAWINGS HEAVY VERTICAL AND RIGHT" },
	{ 0x2524, "BOX DRAWINGS LIGHT VERTICAL AND LEFT" },
	{ 0x2525, "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY" },
	{ 0x2526, "BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT" },
	{ 0x2527, "BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT" },
	{ 0x2528, "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT" },
	{ 0x2529, "BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY" },
	{ 0x252A, "BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY" },
	{ 0x252B, "BOX DRAWINGS HEAVY VERTICAL AND LEFT" },
	{ 0x252C, "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL" },
	{ 0x252D, "BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT" },
	{ 0x252E, "BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT" },
	{ 0x252F, "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY" },
	{ 0x2530, "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT" },
	{ 0x2531, "BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY" },
	{ 0x2532, "BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY" },
	{ 0x2533, "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL" },
	{ 0x2534, "BOX DRAWINGS LIGHT UP AND HORIZONTAL" },
	{ 0x2535, "BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT" },
	{ 0x2536, "BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT" },
	{ 0x2537, "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY" },
	{ 0x2538, "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT" },
	{ 0x2539, "BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY" },
	{ 0x253A, "BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY" },
	{ 0x253B, "BOX DRAWINGS HEAVY UP AND HORIZONTAL" },
	{ 0x253C, "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL" },
	{ 0x253D, "BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT" },
	{ 0x253E, "BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT" },
	{ 0x253F, "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY" },
	{ 0x2540, "BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT" },
	{ 0x2541, "BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT" },
	{ 0x2542, "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT" },
	{ 0x2543, "BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT" },
	{ 0x2544, "BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT" },
	{ 0x2545, "BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT" },
	{ 0x2546, "BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT" },
	{ 0x2547, "BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY" },
	{ 0x2548, "BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY" },
	{ 0x2549, "BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY" },
	{ 0x254A, "BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY" },
	{ 0x254B, "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL" },
	{ 0x254C, "BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL" },
	{ 0x254D, "BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL" },
	{ 0x254E, "BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL" },
	{ 0x254F, "BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL" },
	{ 0x2550, "BOX DRAWINGS DOUBLE HORIZONTAL" },
	{ 0x2551, "BOX DRAWINGS DOUBLE VERTICAL" },
	{ 0x2552, "BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE" },
	{ 0x2553, "BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE" },
	{ 0x2554, "BOX DRAWINGS DOUBLE DOWN AND RIGHT" },
	{ 0x2555, "BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE" },
	{ 0x2556, "BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE" },
	{ 0x2557, "BOX DRAWINGS DOUBLE DOWN AND LEFT" },
	{ 0x2558, "BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE" },
	{ 0x2559, "BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE" },
	{ 0x255A, "BOX DRAWINGS DOUBLE UP AND RIGHT" },
	{ 0x255B, "BOX DRAWINGS UP SINGLE AND LEFT DOUBLE" },
	{ 0x255C, "BOX DRAWINGS UP DOUBLE AND LEFT SINGLE" },
	{ 0x255D, "BOX DRAWINGS DOUBLE UP AND LEFT" },
	{ 0x255E, "BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE" },
	{ 0x255F, "BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE" },
	{ 0x2560, "BOX DRAWINGS DOUBLE VERTICAL AND RIGHT" },
	{ 0x2561, "BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE" },
	{ 0x2562, "BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE" },
	{ 0x2563, "BOX DRAWINGS DOUBLE VERTICAL AND LEFT" },
	{ 0x2564, "BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE" },
	{ 0x2565, "BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE" },
	{ 0x2566, "BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL" },
	{ 0x2567, "BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE" },
	{ 0x2568, "BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE" },
	{ 0x2569, "BOX DRAWINGS DOUBLE UP AND HORIZONTAL" },
	{ 0x256A, "BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE" },
	{ 0x256B, "BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE" },
	{ 0x256C, "BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL" },
	{ 0x256D, "BOX DRAWINGS LIGHT ARC DOWN AND RIGHT" },
	{ 0x256E, "BOX DRAWINGS LIGHT ARC DOWN AND LEFT" },
	{ 0x256F, "BOX DRAWINGS LIGHT ARC UP AND LEFT" },
	{ 0x2570, "BOX DRAWINGS LIGHT ARC UP AND RIGHT" },
	{ 0x2571, "BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT" },
	{ 0x2572, "BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT" },
	{ 0x2573, "BOX DRAWINGS LIGHT DIAGONAL CROSS" },
	{ 0x2574, "BOX DRAWINGS LIGHT LEFT" },
	{ 0x2575, "BOX DRAWINGS LIGHT UP" },
	{ 0x2576, "BOX DRAWINGS LIGHT RIGHT" },
	{ 0x2577, "BOX DRAWINGS LIGHT DOWN" },
	{ 0x2578, "BOX DRAWINGS HEAVY LEFT" },
	{ 0x2579, "BOX DRAWINGS HEAVY UP" },
	{ 0x257A, "BOX DRAWINGS HEAVY RIGHT" },
	{ 0x257B, "BOX DRAWINGS HEAVY DOWN" },
	{ 0x257C, "BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT" },
	{ 0x257D, "BOX DRAWINGS LIGHT UP AND HEAVY DOWN" },
	{ 0x257E, "BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT" },
	{ 0x257F, "BOX DRAWINGS HEAVY UP AND LIGHT DOWN" },
	{ 0x2580, "UPPER HALF BLOCK" },
	{ 0x2581, "LOWER ONE EIGHTH BLOCK" },
	{ 0x2582, "LOWER ONE QUARTER BLOCK" },
	{ 0x2583, "LOWER THREE EIGHTHS BLOCK" },
	{ 0x2584, "LOWER HALF BLOCK" },
	{ 0x2585, "LOWER FIVE EIGHTHS BLOCK" },
	{ 0x2586, "LOWER THREE QUARTERS BLOCK" },
	{ 0x2587, "LOWER SEVEN EIGHTHS BLOCK" },
	{ 0x2588, "FULL BLOCK" },
	{ 0x2589, "LEFT SEVEN EIGHTHS BLOCK" },
	{ 0x258A, "LEFT THREE QUARTERS BLOCK" },
	{ 0x258B, "LEFT FIVE EIGHTHS BLOCK" },
	{ 0x258C, "LEFT HALF BLOCK" },
	{ 0x258D, "LEFT THREE EIGHTHS BLOCK" },
	{ 0x258E, "LEFT ONE QUARTER BLOCK" },
	{ 0x258F, "LEFT ONE EIGHTH BLOCK" },
	{ 0x2590, "RIGHT HALF BLOCK" },
	{ 0x2591, "LIGHT SHADE" },
	{ 0x2592, "MEDIUM SHADE" },
	{ 0x2593, "DARK SHADE" },
	{ 0x2594, "UPPER ONE EIGHTH BLOCK" },
	{ 0x2595, "RIGHT ONE EIGHTH BLOCK" },
	{ 0x25A0, "BLACK SQUARE" },
	{ 0x25A1, "WHITE SQUARE" },
	{ 0x25A2, "WHITE SQUARE WITH ROUNDED CORNERS" },
	{ 0x25A3, "WHITE SQUARE CONTAINING BLACK SMALL SQUARE" },
	{ 0x25A4, "SQUARE WITH HORIZONTAL FILL" },
	{ 0x25A5, "SQUARE WITH VERTICAL FILL" },
	{ 0x25A6, "SQUARE WITH ORTHOGONAL CROSSHATCH FILL" },
	{ 0x25A7, "SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL" },
	{ 0x25A8, "SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL" },
	{ 0x25A9, "SQUARE WITH DIAGONAL CROSSHATCH FILL" },
	{ 0x25AA, "BLACK SMALL SQUARE" },
	{ 0x25AB, "WHITE SMALL SQUARE" },
	{ 0x25AC, "BLACK RECTANGLE" },
	{ 0x25AD, "WHITE RECTANGLE" },
	{ 0x25AE, "BLACK VERTICAL RECTANGLE" },
	{ 0x25AF, "WHITE VERTICAL RECTANGLE" },
	{ 0x25B0, "BLACK PARALLELOGRAM" },
	{ 0x25B1, "WHITE PARALLELOGRAM" },
	{ 0x25B2, "BLACK UP-POINTING TRIANGLE" },
	{ 0x25B3, "WHITE UP-POINTING TRIANGLE" },
	{ 0x25B4, "BLACK UP-POINTING SMALL TRIANGLE" },
	{ 0x25B5, "WHITE UP-POINTING SMALL TRIANGLE" },
	{ 0x25B6, "BLACK RIGHT-POINTING TRIANGLE" },
	{ 0x25B7, "WHITE RIGHT-POINTING TRIANGLE" },
	{ 0x25B8, "BLACK RIGHT-POINTING SMALL TRIANGLE" },
	{ 0x25B9, "WHITE RIGHT-POINTING SMALL TRIANGLE" },
	{ 0x25BA, "BLACK RIGHT-POINTING POINTER" },
	{ 0x25BB, "WHITE RIGHT-POINTING POINTER" },
	{ 0x25BC, "BLACK DOWN-POINTING TRIANGLE" },
	{ 0x25BD, "WHITE DOWN-POINTING TRIANGLE" },
	{ 0x25BE, "BLACK DOWN-POINTING SMALL TRIANGLE" },
	{ 0x25BF, "WHITE DOWN-POINTING SMALL TRIANGLE" },
	{ 0x25C0, "BLACK LEFT-POINTING TRIANGLE" },
	{ 0x25C1, "WHITE LEFT-POINTING TRIANGLE" },
	{ 0x25C2, "BLACK LEFT-POINTING SMALL TRIANGLE" },
	{ 0x25C3, "WHITE LEFT-POINTING SMALL TRIANGLE" },
	{ 0x25C4, "BLACK LEFT-POINTING POINTER" },
	{ 0x25C5, "WHITE LEFT-POINTING POINTER" },
	{ 0x25C6, "BLACK DIAMOND" },
	{ 0x25C7, "WHITE DIAMOND" },
	{ 0x25C8, "WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND" },
	{ 0x25C9, "FISHEYE" },
	{ 0x25CA, "LOZENGE" },
	{ 0x25CB, "WHITE CIRCLE" },
	{ 0x25CC, "DOTTED CIRCLE" },
	{ 0x25CD, "CIRCLE WITH VERTICAL FILL" },
	{ 0x25CE, "BULLSEYE" },
	{ 0x25CF, "BLACK CIRCLE" },
	{ 0x25D0, "CIRCLE WITH LEFT HALF BLACK" },
	{ 0x25D1, "CIRCLE WITH RIGHT HALF BLACK" },
	{ 0x25D2, "CIRCLE WITH LOWER HALF BLACK" },
	{ 0x25D3, "CIRCLE WITH UPPER HALF BLACK" },
	{ 0x25D4, "CIRCLE WITH UPPER RIGHT QUADRANT BLACK" },
	{ 0x25D5, "CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK" },
	{ 0x25D6, "LEFT HALF BLACK CIRCLE" },
	{ 0x25D7, "RIGHT HALF BLACK CIRCLE" },
	{ 0x25D8, "INVERSE BULLET" },
	{ 0x25D9, "INVERSE WHITE CIRCLE" },
	{ 0x25DA, "UPPER HALF INVERSE WHITE CIRCLE" },
	{ 0x25DB, "LOWER HALF INVERSE WHITE CIRCLE" },
	{ 0x25DC, "UPPER LEFT QUADRANT CIRCULAR ARC" },
	{ 0x25DD, "UPPER RIGHT QUADRANT CIRCULAR ARC" },
	{ 0x25DE, "LOWER RIGHT QUADRANT CIRCULAR ARC" },
	{ 0x25DF, "LOWER LEFT QUADRANT CIRCULAR ARC" },
	{ 0x25E0, "UPPER HALF CIRCLE" },
	{ 0x25E1, "LOWER HALF CIRCLE" },
	{ 0x25E2, "BLACK LOWER RIGHT TRIANGLE" },
	{ 0x25E3, "BLACK LOWER LEFT TRIANGLE" },
	{ 0x25E4, "BLACK UPPER LEFT TRIANGLE" },
	{ 0x25E5, "BLACK UPPER RIGHT TRIANGLE" },
	{ 0x25E6, "WHITE BULLET" },
	{ 0x25E7, "SQUARE WITH LEFT HALF BLACK" },
	{ 0x25E8, "SQUARE WITH RIGHT HALF BLACK" },
	{ 0x25E9, "SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK" },
	{ 0x25EA, "SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK" },
	{ 0x25EB, "WHITE SQUARE WITH VERTICAL BISECTING LINE" },
	{ 0x25EC, "WHITE UP-POINTING TRIANGLE WITH DOT" },
	{ 0x25ED, "UP-POINTING TRIANGLE WITH LEFT HALF BLACK" },
	{ 0x25EE, "UP-POINTING TRIANGLE WITH RIGHT HALF BLACK" },
	{ 0x25EF, "LARGE CIRCLE" },
	{ 0x25F0, "WHITE SQUARE WITH UPPER LEFT QUADRANT" },
	{ 0x25F1, "WHITE SQUARE WITH LOWER LEFT QUADRANT" },
	{ 0x25F2, "WHITE SQUARE WITH LOWER RIGHT QUADRANT" },
	{ 0x25F3, "WHITE SQUARE WITH UPPER RIGHT QUADRANT" },
	{ 0x25F4, "WHITE CIRCLE WITH UPPER LEFT QUADRANT" },
	{ 0x25F5, "WHITE CIRCLE WITH LOWER LEFT QUADRANT" },
	{ 0x25F6, "WHITE CIRCLE WITH LOWER RIGHT QUADRANT" },
	{ 0x25F7, "WHITE CIRCLE WITH UPPER RIGHT QUADRANT" },
	{ 0x2600, "BLACK SUN WITH RAYS" },
	{ 0x2601, "CLOUD" },
	{ 0x2602, "UMBRELLA" },
	{ 0x2603, "SNOWMAN" },
	{ 0x2604, "COMET" },
	{ 0x2605, "BLACK STAR" },
	{ 0x2606, "WHITE STAR" },
	{ 0x2607, "LIGHTNING" },
	{ 0x2608, "THUNDERSTORM" },
	{ 0x2609, "SUN" },
	{ 0x260A, "ASCENDING NODE" },
	{ 0x260B, "DESCENDING NODE" },
	{ 0x260C, "CONJUNCTION" },
	{ 0x260D, "OPPOSITION" },
	{ 0x260E, "BLACK TELEPHONE" },
	{ 0x260F, "WHITE TELEPHONE" },
	{ 0x2610, "BALLOT BOX" },
	{ 0x2611, "BALLOT BOX WITH CHECK" },
	{ 0x2612, "BALLOT BOX WITH X" },
	{ 0x2613, "SALTIRE" },
	{ 0x2619, "REVERSED ROTATED FLORAL HEART BULLET" },
	{ 0x261A, "BLACK LEFT POINTING INDEX" },
	{ 0x261B, "BLACK RIGHT POINTING INDEX" },
	{ 0x261C, "WHITE LEFT POINTING INDEX" },
	{ 0x261D, "WHITE UP POINTING INDEX" },
	{ 0x261E, "WHITE RIGHT POINTING INDEX" },
	{ 0x261F, "WHITE DOWN POINTING INDEX" },
	{ 0x2620, "SKULL AND CROSSBONES" },
	{ 0x2621, "CAUTION SIGN" },
	{ 0x2622, "RADIOACTIVE SIGN" },
	{ 0x2623, "BIOHAZARD SIGN" },
	{ 0x2624, "CADUCEUS" },
	{ 0x2625, "ANKH" },
	{ 0x2626, "ORTHODOX CROSS" },
	{ 0x2627, "CHI RHO" },
	{ 0x2628, "CROSS OF LORRAINE" },
	{ 0x2629, "CROSS OF JERUSALEM" },
	{ 0x262A, "STAR AND CRESCENT" },
	{ 0x262B, "FARSI SYMBOL" },
	{ 0x262C, "ADI SHAKTI" },
	{ 0x262D, "HAMMER AND SICKLE" },
	{ 0x262E, "PEACE SYMBOL" },
	{ 0x262F, "YIN YANG" },
	{ 0x2630, "TRIGRAM FOR HEAVEN" },
	{ 0x2631, "TRIGRAM FOR LAKE" },
	{ 0x2632, "TRIGRAM FOR FIRE" },
	{ 0x2633, "TRIGRAM FOR THUNDER" },
	{ 0x2634, "TRIGRAM FOR WIND" },
	{ 0x2635, "TRIGRAM FOR WATER" },
	{ 0x2636, "TRIGRAM FOR MOUNTAIN" },
	{ 0x2637, "TRIGRAM FOR EARTH" },
	{ 0x2638, "WHEEL OF DHARMA" },
	{ 0x2639, "WHITE FROWNING FACE" },
	{ 0x263A, "WHITE SMILING FACE" },
	{ 0x263B, "BLACK SMILING FACE" },
	{ 0x263C, "WHITE SUN WITH RAYS" },
	{ 0x263D, "FIRST QUARTER MOON" },
	{ 0x263E, "LAST QUARTER MOON" },
	{ 0x263F, "MERCURY" },
	{ 0x2640, "FEMALE SIGN" },
	{ 0x2641, "EARTH" },
	{ 0x2642, "MALE SIGN" },
	{ 0x2643, "JUPITER" },
	{ 0x2644, "SATURN" },
	{ 0x2645, "URANUS" },
	{ 0x2646, "NEPTUNE" },
	{ 0x2647, "PLUTO" },
	{ 0x2648, "ARIES" },
	{ 0x2649, "TAURUS" },
	{ 0x264A, "GEMINI" },
	{ 0x264B, "CANCER" },
	{ 0x264C, "LEO" },
	{ 0x264D, "VIRGO" },
	{ 0x264E, "LIBRA" },
	{ 0x264F, "SCORPIUS" },
	{ 0x2650, "SAGITTARIUS" },
	{ 0x2651, "CAPRICORN" },
	{ 0x2652, "AQUARIUS" },
	{ 0x2653, "PISCES" },
	{ 0x2654, "WHITE CHESS KING" },
	{ 0x2655, "WHITE CHESS QUEEN" },
	{ 0x2656, "WHITE CHESS ROOK" },
	{ 0x2657, "WHITE CHESS BISHOP" },
	{ 0x2658, "WHITE CHESS KNIGHT" },
	{ 0x2659, "WHITE CHESS PAWN" },
	{ 0x265A, "BLACK CHESS KING" },
	{ 0x265B, "BLACK CHESS QUEEN" },
	{ 0x265C, "BLACK CHESS ROOK" },
	{ 0x265D, "BLACK CHESS BISHOP" },
	{ 0x265E, "BLACK CHESS KNIGHT" },
	{ 0x265F, "BLACK CHESS PAWN" },
	{ 0x2660, "BLACK SPADE SUIT" },
	{ 0x2661, "WHITE HEART SUIT" },
	{ 0x2662, "WHITE DIAMOND SUIT" },
	{ 0x2663, "BLACK CLUB SUIT" },
	{ 0x2664, "WHITE SPADE SUIT" },
	{ 0x2665, "BLACK HEART SUIT" },
	{ 0x2666, "BLACK DIAMOND SUIT" },
	{ 0x2667, "WHITE CLUB SUIT" },
	{ 0x2668, "HOT SPRINGS" },
	{ 0x2669, "QUARTER NOTE" },
	{ 0x266A, "EIGHTH NOTE" },
	{ 0x266B, "BEAMED EIGHTH NOTES" },
	{ 0x266C, "BEAMED SIXTEENTH NOTES" },
	{ 0x266D, "MUSIC FLAT SIGN" },
	{ 0x266E, "MUSIC NATURAL SIGN" },
	{ 0x266F, "MUSIC SHARP SIGN" },
	{ 0x2670, "WEST SYRIAC CROSS" },
	{ 0x2671, "EAST SYRIAC CROSS" },
	{ 0x2701, "UPPER BLADE SCISSORS" },
	{ 0x2702, "BLACK SCISSORS" },
	{ 0x2703, "LOWER BLADE SCISSORS" },
	{ 0x2704, "WHITE SCISSORS" },
	{ 0x2706, "TELEPHONE LOCATION SIGN" },
	{ 0x2707, "TAPE DRIVE" },
	{ 0x2708, "AIRPLANE" },
	{ 0x2709, "ENVELOPE" },
	{ 0x270C, "VICTORY HAND" },
	{ 0x270D, "WRITING HAND" },
	{ 0x270E, "LOWER RIGHT PENCIL" },
	{ 0x270F, "PENCIL" },
	{ 0x2710, "UPPER RIGHT PENCIL" },
	{ 0x2711, "WHITE NIB" },
	{ 0x2712, "BLACK NIB" },
	{ 0x2713, "CHECK MARK" },
	{ 0x2714, "HEAVY CHECK MARK" },
	{ 0x2715, "MULTIPLICATION X" },
	{ 0x2716, "HEAVY MULTIPLICATION X" },
	{ 0x2717, "BALLOT X" },
	{ 0x2718, "HEAVY BALLOT X" },
	{ 0x2719, "OUTLINED GREEK CROSS" },
	{ 0x271A, "HEAVY GREEK CROSS" },
	{ 0x271B, "OPEN CENTRE CROSS" },
	{ 0x271C, "HEAVY OPEN CENTRE CROSS" },
	{ 0x271D, "LATIN CROSS" },
	{ 0x271E, "SHADOWED WHITE LATIN CROSS" },
	{ 0x271F, "OUTLINED LATIN CROSS" },
	{ 0x2720, "MALTESE CROSS" },
	{ 0x2721, "STAR OF DAVID" },
	{ 0x2722, "FOUR TEARDROP-SPOKED ASTERISK" },
	{ 0x2723, "FOUR BALLOON-SPOKED ASTERISK" },
	{ 0x2724, "HEAVY FOUR BALLOON-SPOKED ASTERISK" },
	{ 0x2725, "FOUR CLUB-SPOKED ASTERISK" },
	{ 0x2726, "BLACK FOUR POINTED STAR" },
	{ 0x2727, "WHITE FOUR POINTED STAR" },
	{ 0x2729, "STRESS OUTLINED WHITE STAR" },
	{ 0x272A, "CIRCLED WHITE STAR" },
	{ 0x272B, "OPEN CENTRE BLACK STAR" },
	{ 0x272C, "BLACK CENTRE WHITE STAR" },
	{ 0x272D, "OUTLINED BLACK STAR" },
	{ 0x272E, "HEAVY OUTLINED BLACK STAR" },
	{ 0x272F, "PINWHEEL STAR" },
	{ 0x2730, "SHADOWED WHITE STAR" },
	{ 0x2731, "HEAVY ASTERISK" },
	{ 0x2732, "OPEN CENTRE ASTERISK" },
	{ 0x2733, "EIGHT SPOKED ASTERISK" },
	{ 0x2734, "EIGHT POINTED BLACK STAR" },
	{ 0x2735, "EIGHT POINTED PINWHEEL STAR" },
	{ 0x2736, "SIX POINTED BLACK STAR" },
	{ 0x2737, "EIGHT POINTED RECTILINEAR BLACK STAR" },
	{ 0x2738, "HEAVY EIGHT POINTED RECTILINEAR BLACK STAR" },
	{ 0x2739, "TWELVE POINTED BLACK STAR" },
	{ 0x273A, "SIXTEEN POINTED ASTERISK" },
	{ 0x273B, "TEARDROP-SPOKED ASTERISK" },
	{ 0x273C, "OPEN CENTRE TEARDROP-SPOKED ASTERISK" },
	{ 0x273D, "HEAVY TEARDROP-SPOKED ASTERISK" },
	{ 0x273E, "SIX PETALLED BLACK AND WHITE FLORETTE" },
	{ 0x273F, "BLACK FLORETTE" },
	{ 0x2740, "WHITE FLORETTE" },
	{ 0x2741, "EIGHT PETALLED OUTLINED BLACK FLORETTE" },
	{ 0x2742, "CIRCLED OPEN CENTRE EIGHT POINTED STAR" },
	{ 0x2743, "HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK" },
	{ 0x2744, "SNOWFLAKE" },
	{ 0x2745, "TIGHT TRIFOLIATE SNOWFLAKE" },
	{ 0x2746, "HEAVY CHEVRON SNOWFLAKE" },
	{ 0x2747, "SPARKLE" },
	{ 0x2748, "HEAVY SPARKLE" },
	{ 0x2749, "BALLOON-SPOKED ASTERISK" },
	{ 0x274A, "EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" },
	{ 0x274B, "HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" },
	{ 0x274D, "SHADOWED WHITE CIRCLE" },
	{ 0x274F, "LOWER RIGHT DROP-SHADOWED WHITE SQUARE" },
	{ 0x2750, "UPPER RIGHT DROP-SHADOWED WHITE SQUARE" },
	{ 0x2751, "LOWER RIGHT SHADOWED WHITE SQUARE" },
	{ 0x2752, "UPPER RIGHT SHADOWED WHITE SQUARE" },
	{ 0x2756, "BLACK DIAMOND MINUS WHITE X" },
	{ 0x2758, "LIGHT VERTICAL BAR" },
	{ 0x2759, "MEDIUM VERTICAL BAR" },
	{ 0x275A, "HEAVY VERTICAL BAR" },
	{ 0x275B, "HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT" },
	{ 0x275C, "HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT" },
	{ 0x275D, "HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT" },
	{ 0x275E, "HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT" },
	{ 0x2761, "CURVED STEM PARAGRAPH SIGN ORNAMENT" },
	{ 0x2762, "HEAVY EXCLAMATION MARK ORNAMENT" },
	{ 0x2763, "HEAVY HEART EXCLAMATION MARK ORNAMENT" },
	{ 0x2764, "HEAVY BLACK HEART" },
	{ 0x2765, "ROTATED HEAVY BLACK HEART BULLET" },
	{ 0x2766, "FLORAL HEART" },
	{ 0x2767, "ROTATED FLORAL HEART BULLET" },
	{ 0x2776, "DINGBAT NEGATIVE CIRCLED DIGIT ONE" },
	{ 0x2777, "DINGBAT NEGATIVE CIRCLED DIGIT TWO" },
	{ 0x2778, "DINGBAT NEGATIVE CIRCLED DIGIT THREE" },
	{ 0x2779, "DINGBAT NEGATIVE CIRCLED DIGIT FOUR" },
	{ 0x277A, "DINGBAT NEGATIVE CIRCLED DIGIT FIVE" },
	{ 0x277B, "DINGBAT NEGATIVE CIRCLED DIGIT SIX" },
	{ 0x277C, "DINGBAT NEGATIVE CIRCLED DIGIT SEVEN" },
	{ 0x277D, "DINGBAT NEGATIVE CIRCLED DIGIT EIGHT" },
	{ 0x277E, "DINGBAT NEGATIVE CIRCLED DIGIT NINE" },
	{ 0x277F, "DINGBAT NEGATIVE CIRCLED NUMBER TEN" },
	{ 0x2780, "DINGBAT CIRCLED SANS-SERIF DIGIT ONE" },
	{ 0x2781, "DINGBAT CIRCLED SANS-SERIF DIGIT TWO" },
	{ 0x2782, "DINGBAT CIRCLED SANS-SERIF DIGIT THREE" },
	{ 0x2783, "DINGBAT CIRCLED SANS-SERIF DIGIT FOUR" },
	{ 0x2784, "DINGBAT CIRCLED SANS-SERIF DIGIT FIVE" },
	{ 0x2785, "DINGBAT CIRCLED SANS-SERIF DIGIT SIX" },
	{ 0x2786, "DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN" },
	{ 0x2787, "DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT" },
	{ 0x2788, "DINGBAT CIRCLED SANS-SERIF DIGIT NINE" },
	{ 0x2789, "DINGBAT CIRCLED SANS-SERIF NUMBER TEN" },
	{ 0x278A, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE" },
	{ 0x278B, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO" },
	{ 0x278C, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE" },
	{ 0x278D, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR" },
	{ 0x278E, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE" },
	{ 0x278F, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX" },
	{ 0x2790, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN" },
	{ 0x2791, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT" },
	{ 0x2792, "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE" },
	{ 0x2793, "DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN" },
	{ 0x2794, "HEAVY WIDE-HEADED RIGHTWARDS ARROW" },
	{ 0x2798, "HEAVY SOUTH EAST ARROW" },
	{ 0x2799, "HEAVY RIGHTWARDS ARROW" },
	{ 0x279A, "HEAVY NORTH EAST ARROW" },
	{ 0x279B, "DRAFTING POINT RIGHTWARDS ARROW" },
	{ 0x279C, "HEAVY ROUND-TIPPED RIGHTWARDS ARROW" },
	{ 0x279D, "TRIANGLE-HEADED RIGHTWARDS ARROW" },
	{ 0x279E, "HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW" },
	{ 0x279F, "DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" },
	{ 0x27A0, "HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" },
	{ 0x27A1, "BLACK RIGHTWARDS ARROW" },
	{ 0x27A2, "THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD" },
	{ 0x27A3, "THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD" },
	{ 0x27A4, "BLACK RIGHTWARDS ARROWHEAD" },
	{ 0x27A5, "HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW" },
	{ 0x27A6, "HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW" },
	{ 0x27A7, "SQUAT BLACK RIGHTWARDS ARROW" },
	{ 0x27A8, "HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW" },
	{ 0x27A9, "RIGHT-SHADED WHITE RIGHTWARDS ARROW" },
	{ 0x27AA, "LEFT-SHADED WHITE RIGHTWARDS ARROW" },
	{ 0x27AB, "BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27AC, "FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27AD, "HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27AE, "HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27AF, "NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27B1, "NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" },
	{ 0x27B2, "CIRCLED HEAVY WHITE RIGHTWARDS ARROW" },
	{ 0x27B3, "WHITE-FEATHERED RIGHTWARDS ARROW" },
	{ 0x27B4, "BLACK-FEATHERED SOUTH EAST ARROW" },
	{ 0x27B5, "BLACK-FEATHERED RIGHTWARDS ARROW" },
	{ 0x27B6, "BLACK-FEATHERED NORTH EAST ARROW" },
	{ 0x27B7, "HEAVY BLACK-FEATHERED SOUTH EAST ARROW" },
	{ 0x27B8, "HEAVY BLACK-FEATHERED RIGHTWARDS ARROW" },
	{ 0x27B9, "HEAVY BLACK-FEATHERED NORTH EAST ARROW" },
	{ 0x27BA, "TEARDROP-BARBED RIGHTWARDS ARROW" },
	{ 0x27BB, "HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW" },
	{ 0x27BC, "WEDGE-TAILED RIGHTWARDS ARROW" },
	{ 0x27BD, "HEAVY WEDGE-TAILED RIGHTWARDS ARROW" },
	{ 0x27BE, "OPEN-OUTLINED RIGHTWARDS ARROW" },
	{ 0x2800, "BRAILLE PATTERN BLANK" },
	{ 0x2801, "BRAILLE PATTERN DOTS-1" },
	{ 0x2802, "BRAILLE PATTERN DOTS-2" },
	{ 0x2803, "BRAILLE PATTERN DOTS-12" },
	{ 0x2804, "BRAILLE PATTERN DOTS-3" },
	{ 0x2805, "BRAILLE PATTERN DOTS-13" },
	{ 0x2806, "BRAILLE PATTERN DOTS-23" },
	{ 0x2807, "BRAILLE PATTERN DOTS-123" },
	{ 0x2808, "BRAILLE PATTERN DOTS-4" },
	{ 0x2809, "BRAILLE PATTERN DOTS-14" },
	{ 0x280A, "BRAILLE PATTERN DOTS-24" },
	{ 0x280B, "BRAILLE PATTERN DOTS-124" },
	{ 0x280C, "BRAILLE PATTERN DOTS-34" },
	{ 0x280D, "BRAILLE PATTERN DOTS-134" },
	{ 0x280E, "BRAILLE PATTERN DOTS-234" },
	{ 0x280F, "BRAILLE PATTERN DOTS-1234" },
	{ 0x2810, "BRAILLE PATTERN DOTS-5" },
	{ 0x2811, "BRAILLE PATTERN DOTS-15" },
	{ 0x2812, "BRAILLE PATTERN DOTS-25" },
	{ 0x2813, "BRAILLE PATTERN DOTS-125" },
	{ 0x2814, "BRAILLE PATTERN DOTS-35" },
	{ 0x2815, "BRAILLE PATTERN DOTS-135" },
	{ 0x2816, "BRAILLE PATTERN DOTS-235" },
	{ 0x2817, "BRAILLE PATTERN DOTS-1235" },
	{ 0x2818, "BRAILLE PATTERN DOTS-45" },
	{ 0x2819, "BRAILLE PATTERN DOTS-145" },
	{ 0x281A, "BRAILLE PATTERN DOTS-245" },
	{ 0x281B, "BRAILLE PATTERN DOTS-1245" },
	{ 0x281C, "BRAILLE PATTERN DOTS-345" },
	{ 0x281D, "BRAILLE PATTERN DOTS-1345" },
	{ 0x281E, "BRAILLE PATTERN DOTS-2345" },
	{ 0x281F, "BRAILLE PATTERN DOTS-12345" },
	{ 0x2820, "BRAILLE PATTERN DOTS-6" },
	{ 0x2821, "BRAILLE PATTERN DOTS-16" },
	{ 0x2822, "BRAILLE PATTERN DOTS-26" },
	{ 0x2823, "BRAILLE PATTERN DOTS-126" },
	{ 0x2824, "BRAILLE PATTERN DOTS-36" },
	{ 0x2825, "BRAILLE PATTERN DOTS-136" },
	{ 0x2826, "BRAILLE PATTERN DOTS-236" },
	{ 0x2827, "BRAILLE PATTERN DOTS-1236" },
	{ 0x2828, "BRAILLE PATTERN DOTS-46" },
	{ 0x2829, "BRAILLE PATTERN DOTS-146" },
	{ 0x282A, "BRAILLE PATTERN DOTS-246" },
	{ 0x282B, "BRAILLE PATTERN DOTS-1246" },
	{ 0x282C, "BRAILLE PATTERN DOTS-346" },
	{ 0x282D, "BRAILLE PATTERN DOTS-1346" },
	{ 0x282E, "BRAILLE PATTERN DOTS-2346" },
	{ 0x282F, "BRAILLE PATTERN DOTS-12346" },
	{ 0x2830, "BRAILLE PATTERN DOTS-56" },
	{ 0x2831, "BRAILLE PATTERN DOTS-156" },
	{ 0x2832, "BRAILLE PATTERN DOTS-256" },
	{ 0x2833, "BRAILLE PATTERN DOTS-1256" },
	{ 0x2834, "BRAILLE PATTERN DOTS-356" },
	{ 0x2835, "BRAILLE PATTERN DOTS-1356" },
	{ 0x2836, "BRAILLE PATTERN DOTS-2356" },
	{ 0x2837, "BRAILLE PATTERN DOTS-12356" },
	{ 0x2838, "BRAILLE PATTERN DOTS-456" },
	{ 0x2839, "BRAILLE PATTERN DOTS-1456" },
	{ 0x283A, "BRAILLE PATTERN DOTS-2456" },
	{ 0x283B, "BRAILLE PATTERN DOTS-12456" },
	{ 0x283C, "BRAILLE PATTERN DOTS-3456" },
	{ 0x283D, "BRAILLE PATTERN DOTS-13456" },
	{ 0x283E, "BRAILLE PATTERN DOTS-23456" },
	{ 0x283F, "BRAILLE PATTERN DOTS-123456" },
	{ 0x2840, "BRAILLE PATTERN DOTS-7" },
	{ 0x2841, "BRAILLE PATTERN DOTS-17" },
	{ 0x2842, "BRAILLE PATTERN DOTS-27" },
	{ 0x2843, "BRAILLE PATTERN DOTS-127" },
	{ 0x2844, "BRAILLE PATTERN DOTS-37" },
	{ 0x2845, "BRAILLE PATTERN DOTS-137" },
	{ 0x2846, "BRAILLE PATTERN DOTS-237" },
	{ 0x2847, "BRAILLE PATTERN DOTS-1237" },
	{ 0x2848, "BRAILLE PATTERN DOTS-47" },
	{ 0x2849, "BRAILLE PATTERN DOTS-147" },
	{ 0x284A, "BRAILLE PATTERN DOTS-247" },
	{ 0x284B, "BRAILLE PATTERN DOTS-1247" },
	{ 0x284C, "BRAILLE PATTERN DOTS-347" },
	{ 0x284D, "BRAILLE PATTERN DOTS-1347" },
	{ 0x284E, "BRAILLE PATTERN DOTS-2347" },
	{ 0x284F, "BRAILLE PATTERN DOTS-12347" },
	{ 0x2850, "BRAILLE PATTERN DOTS-57" },
	{ 0x2851, "BRAILLE PATTERN DOTS-157" },
	{ 0x2852, "BRAILLE PATTERN DOTS-257" },
	{ 0x2853, "BRAILLE PATTERN DOTS-1257" },
	{ 0x2854, "BRAILLE PATTERN DOTS-357" },
	{ 0x2855, "BRAILLE PATTERN DOTS-1357" },
	{ 0x2856, "BRAILLE PATTERN DOTS-2357" },
	{ 0x2857, "BRAILLE PATTERN DOTS-12357" },
	{ 0x2858, "BRAILLE PATTERN DOTS-457" },
	{ 0x2859, "BRAILLE PATTERN DOTS-1457" },
	{ 0x285A, "BRAILLE PATTERN DOTS-2457" },
	{ 0x285B, "BRAILLE PATTERN DOTS-12457" },
	{ 0x285C, "BRAILLE PATTERN DOTS-3457" },
	{ 0x285D, "BRAILLE PATTERN DOTS-13457" },
	{ 0x285E, "BRAILLE PATTERN DOTS-23457" },
	{ 0x285F, "BRAILLE PATTERN DOTS-123457" },
	{ 0x2860, "BRAILLE PATTERN DOTS-67" },
	{ 0x2861, "BRAILLE PATTERN DOTS-167" },
	{ 0x2862, "BRAILLE PATTERN DOTS-267" },
	{ 0x2863, "BRAILLE PATTERN DOTS-1267" },
	{ 0x2864, "BRAILLE PATTERN DOTS-367" },
	{ 0x2865, "BRAILLE PATTERN DOTS-1367" },
	{ 0x2866, "BRAILLE PATTERN DOTS-2367" },
	{ 0x2867, "BRAILLE PATTERN DOTS-12367" },
	{ 0x2868, "BRAILLE PATTERN DOTS-467" },
	{ 0x2869, "BRAILLE PATTERN DOTS-1467" },
	{ 0x286A, "BRAILLE PATTERN DOTS-2467" },
	{ 0x286B, "BRAILLE PATTERN DOTS-12467" },
	{ 0x286C, "BRAILLE PATTERN DOTS-3467" },
	{ 0x286D, "BRAILLE PATTERN DOTS-13467" },
	{ 0x286E, "BRAILLE PATTERN DOTS-23467" },
	{ 0x286F, "BRAILLE PATTERN DOTS-123467" },
	{ 0x2870, "BRAILLE PATTERN DOTS-567" },
	{ 0x2871, "BRAILLE PATTERN DOTS-1567" },
	{ 0x2872, "BRAILLE PATTERN DOTS-2567" },
	{ 0x2873, "BRAILLE PATTERN DOTS-12567" },
	{ 0x2874, "BRAILLE PATTERN DOTS-3567" },
	{ 0x2875, "BRAILLE PATTERN DOTS-13567" },
	{ 0x2876, "BRAILLE PATTERN DOTS-23567" },
	{ 0x2877, "BRAILLE PATTERN DOTS-123567" },
	{ 0x2878, "BRAILLE PATTERN DOTS-4567" },
	{ 0x2879, "BRAILLE PATTERN DOTS-14567" },
	{ 0x287A, "BRAILLE PATTERN DOTS-24567" },
	{ 0x287B, "BRAILLE PATTERN DOTS-124567" },
	{ 0x287C, "BRAILLE PATTERN DOTS-34567" },
	{ 0x287D, "BRAILLE PATTERN DOTS-134567" },
	{ 0x287E, "BRAILLE PATTERN DOTS-234567" },
	{ 0x287F, "BRAILLE PATTERN DOTS-1234567" },
	{ 0x2880, "BRAILLE PATTERN DOTS-8" },
	{ 0x2881, "BRAILLE PATTERN DOTS-18" },
	{ 0x2882, "BRAILLE PATTERN DOTS-28" },
	{ 0x2883, "BRAILLE PATTERN DOTS-128" },
	{ 0x2884, "BRAILLE PATTERN DOTS-38" },
	{ 0x2885, "BRAILLE PATTERN DOTS-138" },
	{ 0x2886, "BRAILLE PATTERN DOTS-238" },
	{ 0x2887, "BRAILLE PATTERN DOTS-1238" },
	{ 0x2888, "BRAILLE PATTERN DOTS-48" },
	{ 0x2889, "BRAILLE PATTERN DOTS-148" },
	{ 0x288A, "BRAILLE PATTERN DOTS-248" },
	{ 0x288B, "BRAILLE PATTERN DOTS-1248" },
	{ 0x288C, "BRAILLE PATTERN DOTS-348" },
	{ 0x288D, "BRAILLE PATTERN DOTS-1348" },
	{ 0x288E, "BRAILLE PATTERN DOTS-2348" },
	{ 0x288F, "BRAILLE PATTERN DOTS-12348" },
	{ 0x2890, "BRAILLE PATTERN DOTS-58" },
	{ 0x2891, "BRAILLE PATTERN DOTS-158" },
	{ 0x2892, "BRAILLE PATTERN DOTS-258" },
	{ 0x2893, "BRAILLE PATTERN DOTS-1258" },
	{ 0x2894, "BRAILLE PATTERN DOTS-358" },
	{ 0x2895, "BRAILLE PATTERN DOTS-1358" },
	{ 0x2896, "BRAILLE PATTERN DOTS-2358" },
	{ 0x2897, "BRAILLE PATTERN DOTS-12358" },
	{ 0x2898, "BRAILLE PATTERN DOTS-458" },
	{ 0x2899, "BRAILLE PATTERN DOTS-1458" },
	{ 0x289A, "BRAILLE PATTERN DOTS-2458" },
	{ 0x289B, "BRAILLE PATTERN DOTS-12458" },
	{ 0x289C, "BRAILLE PATTERN DOTS-3458" },
	{ 0x289D, "BRAILLE PATTERN DOTS-13458" },
	{ 0x289E, "BRAILLE PATTERN DOTS-23458" },
	{ 0x289F, "BRAILLE PATTERN DOTS-123458" },
	{ 0x28A0, "BRAILLE PATTERN DOTS-68" },
	{ 0x28A1, "BRAILLE PATTERN DOTS-168" },
	{ 0x28A2, "BRAILLE PATTERN DOTS-268" },
	{ 0x28A3, "BRAILLE PATTERN DOTS-1268" },
	{ 0x28A4, "BRAILLE PATTERN DOTS-368" },
	{ 0x28A5, "BRAILLE PATTERN DOTS-1368" },
	{ 0x28A6, "BRAILLE PATTERN DOTS-2368" },
	{ 0x28A7, "BRAILLE PATTERN DOTS-12368" },
	{ 0x28A8, "BRAILLE PATTERN DOTS-468" },
	{ 0x28A9, "BRAILLE PATTERN DOTS-1468" },
	{ 0x28AA, "BRAILLE PATTERN DOTS-2468" },
	{ 0x28AB, "BRAILLE PATTERN DOTS-12468" },
	{ 0x28AC, "BRAILLE PATTERN DOTS-3468" },
	{ 0x28AD, "BRAILLE PATTERN DOTS-13468" },
	{ 0x28AE, "BRAILLE PATTERN DOTS-23468" },
	{ 0x28AF, "BRAILLE PATTERN DOTS-123468" },
	{ 0x28B0, "BRAILLE PATTERN DOTS-568" },
	{ 0x28B1, "BRAILLE PATTERN DOTS-1568" },
	{ 0x28B2, "BRAILLE PATTERN DOTS-2568" },
	{ 0x28B3, "BRAILLE PATTERN DOTS-12568" },
	{ 0x28B4, "BRAILLE PATTERN DOTS-3568" },
	{ 0x28B5, "BRAILLE PATTERN DOTS-13568" },
	{ 0x28B6, "BRAILLE PATTERN DOTS-23568" },
	{ 0x28B7, "BRAILLE PATTERN DOTS-123568" },
	{ 0x28B8, "BRAILLE PATTERN DOTS-4568" },
	{ 0x28B9, "BRAILLE PATTERN DOTS-14568" },
	{ 0x28BA, "BRAILLE PATTERN DOTS-24568" },
	{ 0x28BB, "BRAILLE PATTERN DOTS-124568" },
	{ 0x28BC, "BRAILLE PATTERN DOTS-34568" },
	{ 0x28BD, "BRAILLE PATTERN DOTS-134568" },
	{ 0x28BE, "BRAILLE PATTERN DOTS-234568" },
	{ 0x28BF, "BRAILLE PATTERN DOTS-1234568" },
	{ 0x28C0, "BRAILLE PATTERN DOTS-78" },
	{ 0x28C1, "BRAILLE PATTERN DOTS-178" },
	{ 0x28C2, "BRAILLE PATTERN DOTS-278" },
	{ 0x28C3, "BRAILLE PATTERN DOTS-1278" },
	{ 0x28C4, "BRAILLE PATTERN DOTS-378" },
	{ 0x28C5, "BRAILLE PATTERN DOTS-1378" },
	{ 0x28C6, "BRAILLE PATTERN DOTS-2378" },
	{ 0x28C7, "BRAILLE PATTERN DOTS-12378" },
	{ 0x28C8, "BRAILLE PATTERN DOTS-478" },
	{ 0x28C9, "BRAILLE PATTERN DOTS-1478" },
	{ 0x28CA, "BRAILLE PATTERN DOTS-2478" },
	{ 0x28CB, "BRAILLE PATTERN DOTS-12478" },
	{ 0x28CC, "BRAILLE PATTERN DOTS-3478" },
	{ 0x28CD, "BRAILLE PATTERN DOTS-13478" },
	{ 0x28CE, "BRAILLE PATTERN DOTS-23478" },
	{ 0x28CF, "BRAILLE PATTERN DOTS-123478" },
	{ 0x28D0, "BRAILLE PATTERN DOTS-578" },
	{ 0x28D1, "BRAILLE PATTERN DOTS-1578" },
	{ 0x28D2, "BRAILLE PATTERN DOTS-2578" },
	{ 0x28D3, "BRAILLE PATTERN DOTS-12578" },
	{ 0x28D4, "BRAILLE PATTERN DOTS-3578" },
	{ 0x28D5, "BRAILLE PATTERN DOTS-13578" },
	{ 0x28D6, "BRAILLE PATTERN DOTS-23578" },
	{ 0x28D7, "BRAILLE PATTERN DOTS-123578" },
	{ 0x28D8, "BRAILLE PATTERN DOTS-4578" },
	{ 0x28D9, "BRAILLE PATTERN DOTS-14578" },
	{ 0x28DA, "BRAILLE PATTERN DOTS-24578" },
	{ 0x28DB, "BRAILLE PATTERN DOTS-124578" },
	{ 0x28DC, "BRAILLE PATTERN DOTS-34578" },
	{ 0x28DD, "BRAILLE PATTERN DOTS-134578" },
	{ 0x28DE, "BRAILLE PATTERN DOTS-234578" },
	{ 0x28DF, "BRAILLE PATTERN DOTS-1234578" },
	{ 0x28E0, "BRAILLE PATTERN DOTS-678" },
	{ 0x28E1, "BRAILLE PATTERN DOTS-1678" },
	{ 0x28E2, "BRAILLE PATTERN DOTS-2678" },
	{ 0x28E3, "BRAILLE PATTERN DOTS-12678" },
	{ 0x28E4, "BRAILLE PATTERN DOTS-3678" },
	{ 0x28E5, "BRAILLE PATTERN DOTS-13678" },
	{ 0x28E6, "BRAILLE PATTERN DOTS-23678" },
	{ 0x28E7, "BRAILLE PATTERN DOTS-123678" },
	{ 0x28E8, "BRAILLE PATTERN DOTS-4678" },
	{ 0x28E9, "BRAILLE PATTERN DOTS-14678" },
	{ 0x28EA, "BRAILLE PATTERN DOTS-24678" },
	{ 0x28EB, "BRAILLE PATTERN DOTS-124678" },
	{ 0x28EC, "BRAILLE PATTERN DOTS-34678" },
	{ 0x28ED, "BRAILLE PATTERN DOTS-134678" },
	{ 0x28EE, "BRAILLE PATTERN DOTS-234678" },
	{ 0x28EF, "BRAILLE PATTERN DOTS-1234678" },
	{ 0x28F0, "BRAILLE PATTERN DOTS-5678" },
	{ 0x28F1, "BRAILLE PATTERN DOTS-15678" },
	{ 0x28F2, "BRAILLE PATTERN DOTS-25678" },
	{ 0x28F3, "BRAILLE PATTERN DOTS-125678" },
	{ 0x28F4, "BRAILLE PATTERN DOTS-35678" },
	{ 0x28F5, "BRAILLE PATTERN DOTS-135678" },
	{ 0x28F6, "BRAILLE PATTERN DOTS-235678" },
	{ 0x28F7, "BRAILLE PATTERN DOTS-1235678" },
	{ 0x28F8, "BRAILLE PATTERN DOTS-45678" },
	{ 0x28F9, "BRAILLE PATTERN DOTS-145678" },
	{ 0x28FA, "BRAILLE PATTERN DOTS-245678" },
	{ 0x28FB, "BRAILLE PATTERN DOTS-1245678" },
	{ 0x28FC, "BRAILLE PATTERN DOTS-345678" },
	{ 0x28FD, "BRAILLE PATTERN DOTS-1345678" },
	{ 0x28FE, "BRAILLE PATTERN DOTS-2345678" },
	{ 0x28FF, "BRAILLE PATTERN DOTS-12345678" },
	{ 0x2E80, "CJK RADICAL REPEAT" },
	{ 0x2E81, "CJK RADICAL CLIFF" },
	{ 0x2E82, "CJK RADICAL SECOND ONE" },
	{ 0x2E83, "CJK RADICAL SECOND TWO" },
	{ 0x2E84, "CJK RADICAL SECOND THREE" },
	{ 0x2E85, "CJK RADICAL PERSON" },
	{ 0x2E86, "CJK RADICAL BOX" },
	{ 0x2E87, "CJK RADICAL TABLE" },
	{ 0x2E88, "CJK RADICAL KNIFE ONE" },
	{ 0x2E89, "CJK RADICAL KNIFE TWO" },
	{ 0x2E8A, "CJK RADICAL DIVINATION" },
	{ 0x2E8B, "CJK RADICAL SEAL" },
	{ 0x2E8C, "CJK RADICAL SMALL ONE" },
	{ 0x2E8D, "CJK RADICAL SMALL TWO" },
	{ 0x2E8E, "CJK RADICAL LAME ONE" },
	{ 0x2E8F, "CJK RADICAL LAME TWO" },
	{ 0x2E90, "CJK RADICAL LAME THREE" },
	{ 0x2E91, "CJK RADICAL LAME FOUR" },
	{ 0x2E92, "CJK RADICAL SNAKE" },
	{ 0x2E93, "CJK RADICAL THREAD" },
	{ 0x2E94, "CJK RADICAL SNOUT ONE" },
	{ 0x2E95, "CJK RADICAL SNOUT TWO" },
	{ 0x2E96, "CJK RADICAL HEART ONE" },
	{ 0x2E97, "CJK RADICAL HEART TWO" },
	{ 0x2E98, "CJK RADICAL HAND" },
	{ 0x2E99, "CJK RADICAL RAP" },
	{ 0x2E9B, "CJK RADICAL CHOKE" },
	{ 0x2E9C, "CJK RADICAL SUN" },
	{ 0x2E9D, "CJK RADICAL MOON" },
	{ 0x2E9E, "CJK RADICAL DEATH" },
	{ 0x2E9F, "CJK RADICAL MOTHER" },
	{ 0x2EA0, "CJK RADICAL CIVILIAN" },
	{ 0x2EA1, "CJK RADICAL WATER ONE" },
	{ 0x2EA2, "CJK RADICAL WATER TWO" },
	{ 0x2EA3, "CJK RADICAL FIRE" },
	{ 0x2EA4, "CJK RADICAL PAW ONE" },
	{ 0x2EA5, "CJK RADICAL PAW TWO" },
	{ 0x2EA6, "CJK RADICAL SIMPLIFIED HALF TREE TRUNK" },
	{ 0x2EA7, "CJK RADICAL COW" },
	{ 0x2EA8, "CJK RADICAL DOG" },
	{ 0x2EA9, "CJK RADICAL JADE" },
	{ 0x2EAA, "CJK RADICAL BOLT OF CLOTH" },
	{ 0x2EAB, "CJK RADICAL EYE" },
	{ 0x2EAC, "CJK RADICAL SPIRIT ONE" },
	{ 0x2EAD, "CJK RADICAL SPIRIT TWO" },
	{ 0x2EAE, "CJK RADICAL BAMBOO" },
	{ 0x2EAF, "CJK RADICAL SILK" },
	{ 0x2EB0, "CJK RADICAL C-SIMPLIFIED SILK" },
	{ 0x2EB1, "CJK RADICAL NET ONE" },
	{ 0x2EB2, "CJK RADICAL NET TWO" },
	{ 0x2EB3, "CJK RADICAL NET THREE" },
	{ 0x2EB4, "CJK RADICAL NET FOUR" },
	{ 0x2EB5, "CJK RADICAL MESH" },
	{ 0x2EB6, "CJK RADICAL SHEEP" },
	{ 0x2EB7, "CJK RADICAL RAM" },
	{ 0x2EB8, "CJK RADICAL EWE" },
	{ 0x2EB9, "CJK RADICAL OLD" },
	{ 0x2EBA, "CJK RADICAL BRUSH ONE" },
	{ 0x2EBB, "CJK RADICAL BRUSH TWO" },
	{ 0x2EBC, "CJK RADICAL MEAT" },
	{ 0x2EBD, "CJK RADICAL MORTAR" },
	{ 0x2EBE, "CJK RADICAL GRASS ONE" },
	{ 0x2EBF, "CJK RADICAL GRASS TWO" },
	{ 0x2EC0, "CJK RADICAL GRASS THREE" },
	{ 0x2EC1, "CJK RADICAL TIGER" },
	{ 0x2EC2, "CJK RADICAL CLOTHES" },
	{ 0x2EC3, "CJK RADICAL WEST ONE" },
	{ 0x2EC4, "CJK RADICAL WEST TWO" },
	{ 0x2EC5, "CJK RADICAL C-SIMPLIFIED SEE" },
	{ 0x2EC6, "CJK RADICAL SIMPLIFIED HORN" },
	{ 0x2EC7, "CJK RADICAL HORN" },
	{ 0x2EC8, "CJK RADICAL C-SIMPLIFIED SPEECH" },
	{ 0x2EC9, "CJK RADICAL C-SIMPLIFIED SHELL" },
	{ 0x2ECA, "CJK RADICAL FOOT" },
	{ 0x2ECB, "CJK RADICAL C-SIMPLIFIED CART" },
	{ 0x2ECC, "CJK RADICAL SIMPLIFIED WALK" },
	{ 0x2ECD, "CJK RADICAL WALK ONE" },
	{ 0x2ECE, "CJK RADICAL WALK TWO" },
	{ 0x2ECF, "CJK RADICAL CITY" },
	{ 0x2ED0, "CJK RADICAL C-SIMPLIFIED GOLD" },
	{ 0x2ED1, "CJK RADICAL LONG ONE" },
	{ 0x2ED2, "CJK RADICAL LONG TWO" },
	{ 0x2ED3, "CJK RADICAL C-SIMPLIFIED LONG" },
	{ 0x2ED4, "CJK RADICAL C-SIMPLIFIED GATE" },
	{ 0x2ED5, "CJK RADICAL MOUND ONE" },
	{ 0x2ED6, "CJK RADICAL MOUND TWO" },
	{ 0x2ED7, "CJK RADICAL RAIN" },
	{ 0x2ED8, "CJK RADICAL BLUE" },
	{ 0x2ED9, "CJK RADICAL C-SIMPLIFIED TANNED LEATHER" },
	{ 0x2EDA, "CJK RADICAL C-SIMPLIFIED LEAF" },
	{ 0x2EDB, "CJK RADICAL C-SIMPLIFIED WIND" },
	{ 0x2EDC, "CJK RADICAL C-SIMPLIFIED FLY" },
	{ 0x2EDD, "CJK RADICAL EAT ONE" },
	{ 0x2EDE, "CJK RADICAL EAT TWO" },
	{ 0x2EDF, "CJK RADICAL EAT THREE" },
	{ 0x2EE0, "CJK RADICAL C-SIMPLIFIED EAT" },
	{ 0x2EE1, "CJK RADICAL HEAD" },
	{ 0x2EE2, "CJK RADICAL C-SIMPLIFIED HORSE" },
	{ 0x2EE3, "CJK RADICAL BONE" },
	{ 0x2EE4, "CJK RADICAL GHOST" },
	{ 0x2EE5, "CJK RADICAL C-SIMPLIFIED FISH" },
	{ 0x2EE6, "CJK RADICAL C-SIMPLIFIED BIRD" },
	{ 0x2EE7, "CJK RADICAL C-SIMPLIFIED SALT" },
	{ 0x2EE8, "CJK RADICAL SIMPLIFIED WHEAT" },
	{ 0x2EE9, "CJK RADICAL SIMPLIFIED YELLOW" },
	{ 0x2EEA, "CJK RADICAL C-SIMPLIFIED FROG" },
	{ 0x2EEB, "CJK RADICAL J-SIMPLIFIED EVEN" },
	{ 0x2EEC, "CJK RADICAL C-SIMPLIFIED EVEN" },
	{ 0x2EED, "CJK RADICAL J-SIMPLIFIED TOOTH" },
	{ 0x2EEE, "CJK RADICAL C-SIMPLIFIED TOOTH" },
	{ 0x2EEF, "CJK RADICAL J-SIMPLIFIED DRAGON" },
	{ 0x2EF0, "CJK RADICAL C-SIMPLIFIED DRAGON" },
	{ 0x2EF1, "CJK RADICAL TURTLE" },
	{ 0x2EF2, "CJK RADICAL J-SIMPLIFIED TURTLE" },
	{ 0x2EF3, "CJK RADICAL C-SIMPLIFIED TURTLE" },
	{ 0x2F00, "KANGXI RADICAL ONE" },
	{ 0x2F01, "KANGXI RADICAL LINE" },
	{ 0x2F02, "KANGXI RADICAL DOT" },
	{ 0x2F03, "KANGXI RADICAL SLASH" },
	{ 0x2F04, "KANGXI RADICAL SECOND" },
	{ 0x2F05, "KANGXI RADICAL HOOK" },
	{ 0x2F06, "KANGXI RADICAL TWO" },
	{ 0x2F07, "KANGXI RADICAL LID" },
	{ 0x2F08, "KANGXI RADICAL MAN" },
	{ 0x2F09, "KANGXI RADICAL LEGS" },
	{ 0x2F0A, "KANGXI RADICAL ENTER" },
	{ 0x2F0B, "KANGXI RADICAL EIGHT" },
	{ 0x2F0C, "KANGXI RADICAL DOWN BOX" },
	{ 0x2F0D, "KANGXI RADICAL COVER" },
	{ 0x2F0E, "KANGXI RADICAL ICE" },
	{ 0x2F0F, "KANGXI RADICAL TABLE" },
	{ 0x2F10, "KANGXI RADICAL OPEN BOX" },
	{ 0x2F11, "KANGXI RADICAL KNIFE" },
	{ 0x2F12, "KANGXI RADICAL POWER" },
	{ 0x2F13, "KANGXI RADICAL WRAP" },
	{ 0x2F14, "KANGXI RADICAL SPOON" },
	{ 0x2F15, "KANGXI RADICAL RIGHT OPEN BOX" },
	{ 0x2F16, "KANGXI RADICAL HIDING ENCLOSURE" },
	{ 0x2F17, "KANGXI RADICAL TEN" },
	{ 0x2F18, "KANGXI RADICAL DIVINATION" },
	{ 0x2F19, "KANGXI RADICAL SEAL" },
	{ 0x2F1A, "KANGXI RADICAL CLIFF" },
	{ 0x2F1B, "KANGXI RADICAL PRIVATE" },
	{ 0x2F1C, "KANGXI RADICAL AGAIN" },
	{ 0x2F1D, "KANGXI RADICAL MOUTH" },
	{ 0x2F1E, "KANGXI RADICAL ENCLOSURE" },
	{ 0x2F1F, "KANGXI RADICAL EARTH" },
	{ 0x2F20, "KANGXI RADICAL SCHOLAR" },
	{ 0x2F21, "KANGXI RADICAL GO" },
	{ 0x2F22, "KANGXI RADICAL GO SLOWLY" },
	{ 0x2F23, "KANGXI RADICAL EVENING" },
	{ 0x2F24, "KANGXI RADICAL BIG" },
	{ 0x2F25, "KANGXI RADICAL WOMAN" },
	{ 0x2F26, "KANGXI RADICAL CHILD" },
	{ 0x2F27, "KANGXI RADICAL ROOF" },
	{ 0x2F28, "KANGXI RADICAL INCH" },
	{ 0x2F29, "KANGXI RADICAL SMALL" },
	{ 0x2F2A, "KANGXI RADICAL LAME" },
	{ 0x2F2B, "KANGXI RADICAL CORPSE" },
	{ 0x2F2C, "KANGXI RADICAL SPROUT" },
	{ 0x2F2D, "KANGXI RADICAL MOUNTAIN" },
	{ 0x2F2E, "KANGXI RADICAL RIVER" },
	{ 0x2F2F, "KANGXI RADICAL WORK" },
	{ 0x2F30, "KANGXI RADICAL ONESELF" },
	{ 0x2F31, "KANGXI RADICAL TURBAN" },
	{ 0x2F32, "KANGXI RADICAL DRY" },
	{ 0x2F33, "KANGXI RADICAL SHORT THREAD" },
	{ 0x2F34, "KANGXI RADICAL DOTTED CLIFF" },
	{ 0x2F35, "KANGXI RADICAL LONG STRIDE" },
	{ 0x2F36, "KANGXI RADICAL TWO HANDS" },
	{ 0x2F37, "KANGXI RADICAL SHOOT" },
	{ 0x2F38, "KANGXI RADICAL BOW" },
	{ 0x2F39, "KANGXI RADICAL SNOUT" },
	{ 0x2F3A, "KANGXI RADICAL BRISTLE" },
	{ 0x2F3B, "KANGXI RADICAL STEP" },
	{ 0x2F3C, "KANGXI RADICAL HEART" },
	{ 0x2F3D, "KANGXI RADICAL HALBERD" },
	{ 0x2F3E, "KANGXI RADICAL DOOR" },
	{ 0x2F3F, "KANGXI RADICAL HAND" },
	{ 0x2F40, "KANGXI RADICAL BRANCH" },
	{ 0x2F41, "KANGXI RADICAL RAP" },
	{ 0x2F42, "KANGXI RADICAL SCRIPT" },
	{ 0x2F43, "KANGXI RADICAL DIPPER" },
	{ 0x2F44, "KANGXI RADICAL AXE" },
	{ 0x2F45, "KANGXI RADICAL SQUARE" },
	{ 0x2F46, "KANGXI RADICAL NOT" },
	{ 0x2F47, "KANGXI RADICAL SUN" },
	{ 0x2F48, "KANGXI RADICAL SAY" },
	{ 0x2F49, "KANGXI RADICAL MOON" },
	{ 0x2F4A, "KANGXI RADICAL TREE" },
	{ 0x2F4B, "KANGXI RADICAL LACK" },
	{ 0x2F4C, "KANGXI RADICAL STOP" },
	{ 0x2F4D, "KANGXI RADICAL DEATH" },
	{ 0x2F4E, "KANGXI RADICAL WEAPON" },
	{ 0x2F4F, "KANGXI RADICAL DO NOT" },
	{ 0x2F50, "KANGXI RADICAL COMPARE" },
	{ 0x2F51, "KANGXI RADICAL FUR" },
	{ 0x2F52, "KANGXI RADICAL CLAN" },
	{ 0x2F53, "KANGXI RADICAL STEAM" },
	{ 0x2F54, "KANGXI RADICAL WATER" },
	{ 0x2F55, "KANGXI RADICAL FIRE" },
	{ 0x2F56, "KANGXI RADICAL CLAW" },
	{ 0x2F57, "KANGXI RADICAL FATHER" },
	{ 0x2F58, "KANGXI RADICAL DOUBLE X" },
	{ 0x2F59, "KANGXI RADICAL HALF TREE TRUNK" },
	{ 0x2F5A, "KANGXI RADICAL SLICE" },
	{ 0x2F5B, "KANGXI RADICAL FANG" },
	{ 0x2F5C, "KANGXI RADICAL COW" },
	{ 0x2F5D, "KANGXI RADICAL DOG" },
	{ 0x2F5E, "KANGXI RADICAL PROFOUND" },
	{ 0x2F5F, "KANGXI RADICAL JADE" },
	{ 0x2F60, "KANGXI RADICAL MELON" },
	{ 0x2F61, "KANGXI RADICAL TILE" },
	{ 0x2F62, "KANGXI RADICAL SWEET" },
	{ 0x2F63, "KANGXI RADICAL LIFE" },
	{ 0x2F64, "KANGXI RADICAL USE" },
	{ 0x2F65, "KANGXI RADICAL FIELD" },
	{ 0x2F66, "KANGXI RADICAL BOLT OF CLOTH" },
	{ 0x2F67, "KANGXI RADICAL SICKNESS" },
	{ 0x2F68, "KANGXI RADICAL DOTTED TENT" },
	{ 0x2F69, "KANGXI RADICAL WHITE" },
	{ 0x2F6A, "KANGXI RADICAL SKIN" },
	{ 0x2F6B, "KANGXI RADICAL DISH" },
	{ 0x2F6C, "KANGXI RADICAL EYE" },
	{ 0x2F6D, "KANGXI RADICAL SPEAR" },
	{ 0x2F6E, "KANGXI RADICAL ARROW" },
	{ 0x2F6F, "KANGXI RADICAL STONE" },
	{ 0x2F70, "KANGXI RADICAL SPIRIT" },
	{ 0x2F71, "KANGXI RADICAL TRACK" },
	{ 0x2F72, "KANGXI RADICAL GRAIN" },
	{ 0x2F73, "KANGXI RADICAL CAVE" },
	{ 0x2F74, "KANGXI RADICAL STAND" },
	{ 0x2F75, "KANGXI RADICAL BAMBOO" },
	{ 0x2F76, "KANGXI RADICAL RICE" },
	{ 0x2F77, "KANGXI RADICAL SILK" },
	{ 0x2F78, "KANGXI RADICAL JAR" },
	{ 0x2F79, "KANGXI RADICAL NET" },
	{ 0x2F7A, "KANGXI RADICAL SHEEP" },
	{ 0x2F7B, "KANGXI RADICAL FEATHER" },
	{ 0x2F7C, "KANGXI RADICAL OLD" },
	{ 0x2F7D, "KANGXI RADICAL AND" },
	{ 0x2F7E, "KANGXI RADICAL PLOW" },
	{ 0x2F7F, "KANGXI RADICAL EAR" },
	{ 0x2F80, "KANGXI RADICAL BRUSH" },
	{ 0x2F81, "KANGXI RADICAL MEAT" },
	{ 0x2F82, "KANGXI RADICAL MINISTER" },
	{ 0x2F83, "KANGXI RADICAL SELF" },
	{ 0x2F84, "KANGXI RADICAL ARRIVE" },
	{ 0x2F85, "KANGXI RADICAL MORTAR" },
	{ 0x2F86, "KANGXI RADICAL TONGUE" },
	{ 0x2F87, "KANGXI RADICAL OPPOSE" },
	{ 0x2F88, "KANGXI RADICAL BOAT" },
	{ 0x2F89, "KANGXI RADICAL STOPPING" },
	{ 0x2F8A, "KANGXI RADICAL COLOR" },
	{ 0x2F8B, "KANGXI RADICAL GRASS" },
	{ 0x2F8C, "KANGXI RADICAL TIGER" },
	{ 0x2F8D, "KANGXI RADICAL INSECT" },
	{ 0x2F8E, "KANGXI RADICAL BLOOD" },
	{ 0x2F8F, "KANGXI RADICAL WALK ENCLOSURE" },
	{ 0x2F90, "KANGXI RADICAL CLOTHES" },
	{ 0x2F91, "KANGXI RADICAL WEST" },
	{ 0x2F92, "KANGXI RADICAL SEE" },
	{ 0x2F93, "KANGXI RADICAL HORN" },
	{ 0x2F94, "KANGXI RADICAL SPEECH" },
	{ 0x2F95, "KANGXI RADICAL VALLEY" },
	{ 0x2F96, "KANGXI RADICAL BEAN" },
	{ 0x2F97, "KANGXI RADICAL PIG" },
	{ 0x2F98, "KANGXI RADICAL BADGER" },
	{ 0x2F99, "KANGXI RADICAL SHELL" },
	{ 0x2F9A, "KANGXI RADICAL RED" },
	{ 0x2F9B, "KANGXI RADICAL RUN" },
	{ 0x2F9C, "KANGXI RADICAL FOOT" },
	{ 0x2F9D, "KANGXI RADICAL BODY" },
	{ 0x2F9E, "KANGXI RADICAL CART" },
	{ 0x2F9F, "KANGXI RADICAL BITTER" },
	{ 0x2FA0, "KANGXI RADICAL MORNING" },
	{ 0x2FA1, "KANGXI RADICAL WALK" },
	{ 0x2FA2, "KANGXI RADICAL CITY" },
	{ 0x2FA3, "KANGXI RADICAL WINE" },
	{ 0x2FA4, "KANGXI RADICAL DISTINGUISH" },
	{ 0x2FA5, "KANGXI RADICAL VILLAGE" },
	{ 0x2FA6, "KANGXI RADICAL GOLD" },
	{ 0x2FA7, "KANGXI RADICAL LONG" },
	{ 0x2FA8, "KANGXI RADICAL GATE" },
	{ 0x2FA9, "KANGXI RADICAL MOUND" },
	{ 0x2FAA, "KANGXI RADICAL SLAVE" },
	{ 0x2FAB, "KANGXI RADICAL SHORT TAILED BIRD" },
	{ 0x2FAC, "KANGXI RADICAL RAIN" },
	{ 0x2FAD, "KANGXI RADICAL BLUE" },
	{ 0x2FAE, "KANGXI RADICAL WRONG" },
	{ 0x2FAF, "KANGXI RADICAL FACE" },
	{ 0x2FB0, "KANGXI RADICAL LEATHER" },
	{ 0x2FB1, "KANGXI RADICAL TANNED LEATHER" },
	{ 0x2FB2, "KANGXI RADICAL LEEK" },
	{ 0x2FB3, "KANGXI RADICAL SOUND" },
	{ 0x2FB4, "KANGXI RADICAL LEAF" },
	{ 0x2FB5, "KANGXI RADICAL WIND" },
	{ 0x2FB6, "KANGXI RADICAL FLY" },
	{ 0x2FB7, "KANGXI RADICAL EAT" },
	{ 0x2FB8, "KANGXI RADICAL HEAD" },
	{ 0x2FB9, "KANGXI RADICAL FRAGRANT" },
	{ 0x2FBA, "KANGXI RADICAL HORSE" },
	{ 0x2FBB, "KANGXI RADICAL BONE" },
	{ 0x2FBC, "KANGXI RADICAL TALL" },
	{ 0x2FBD, "KANGXI RADICAL HAIR" },
	{ 0x2FBE, "KANGXI RADICAL FIGHT" },
	{ 0x2FBF, "KANGXI RADICAL SACRIFICIAL WINE" },
	{ 0x2FC0, "KANGXI RADICAL CAULDRON" },
	{ 0x2FC1, "KANGXI RADICAL GHOST" },
	{ 0x2FC2, "KANGXI RADICAL FISH" },
	{ 0x2FC3, "KANGXI RADICAL BIRD" },
	{ 0x2FC4, "KANGXI RADICAL SALT" },
	{ 0x2FC5, "KANGXI RADICAL DEER" },
	{ 0x2FC6, "KANGXI RADICAL WHEAT" },
	{ 0x2FC7, "KANGXI RADICAL HEMP" },
	{ 0x2FC8, "KANGXI RADICAL YELLOW" },
	{ 0x2FC9, "KANGXI RADICAL MILLET" },
	{ 0x2FCA, "KANGXI RADICAL BLACK" },
	{ 0x2FCB, "KANGXI RADICAL EMBROIDERY" },
	{ 0x2FCC, "KANGXI RADICAL FROG" },
	{ 0x2FCD, "KANGXI RADICAL TRIPOD" },
	{ 0x2FCE, "KANGXI RADICAL DRUM" },
	{ 0x2FCF, "KANGXI RADICAL RAT" },
	{ 0x2FD0, "KANGXI RADICAL NOSE" },
	{ 0x2FD1, "KANGXI RADICAL EVEN" },
	{ 0x2FD2, "KANGXI RADICAL TOOTH" },
	{ 0x2FD3, "KANGXI RADICAL DRAGON" },
	{ 0x2FD4, "KANGXI RADICAL TURTLE" },
	{ 0x2FD5, "KANGXI RADICAL FLUTE" },
	{ 0x2FF0, "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT" },
	{ 0x2FF1, "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW" },
	{ 0x2FF2, "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT" },
	{ 0x2FF3, "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW" },
	{ 0x2FF4, "IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND" },
	{ 0x2FF5, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE" },
	{ 0x2FF6, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW" },
	{ 0x2FF7, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT" },
	{ 0x2FF8, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT" },
	{ 0x2FF9, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT" },
	{ 0x2FFA, "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT" },
	{ 0x2FFB, "IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID" },
	{ 0x3000, "IDEOGRAPHIC SPACE" },
	{ 0x3001, "IDEOGRAPHIC COMMA" },
	{ 0x3002, "IDEOGRAPHIC FULL STOP" },
	{ 0x3003, "DITTO MARK" },
	{ 0x3004, "JAPANESE INDUSTRIAL STANDARD SYMBOL" },
	{ 0x3005, "IDEOGRAPHIC ITERATION MARK" },
	{ 0x3006, "IDEOGRAPHIC CLOSING MARK" },
	{ 0x3007, "IDEOGRAPHIC NUMBER ZERO" },
	{ 0x3008, "LEFT ANGLE BRACKET" },
	{ 0x3009, "RIGHT ANGLE BRACKET" },
	{ 0x300A, "LEFT DOUBLE ANGLE BRACKET" },
	{ 0x300B, "RIGHT DOUBLE ANGLE BRACKET" },
	{ 0x300C, "LEFT CORNER BRACKET" },
	{ 0x300D, "RIGHT CORNER BRACKET" },
	{ 0x300E, "LEFT WHITE CORNER BRACKET" },
	{ 0x300F, "RIGHT WHITE CORNER BRACKET" },
	{ 0x3010, "LEFT BLACK LENTICULAR BRACKET" },
	{ 0x3011, "RIGHT BLACK LENTICULAR BRACKET" },
	{ 0x3012, "POSTAL MARK" },
	{ 0x3013, "GETA MARK" },
	{ 0x3014, "LEFT TORTOISE SHELL BRACKET" },
	{ 0x3015, "RIGHT TORTOISE SHELL BRACKET" },
	{ 0x3016, "LEFT WHITE LENTICULAR BRACKET" },
	{ 0x3017, "RIGHT WHITE LENTICULAR BRACKET" },
	{ 0x3018, "LEFT WHITE TORTOISE SHELL BRACKET" },
	{ 0x3019, "RIGHT WHITE TORTOISE SHELL BRACKET" },
	{ 0x301A, "LEFT WHITE SQUARE BRACKET" },
	{ 0x301B, "RIGHT WHITE SQUARE BRACKET" },
	{ 0x301C, "WAVE DASH" },
	{ 0x301D, "REVERSED DOUBLE PRIME QUOTATION MARK" },
	{ 0x301E, "DOUBLE PRIME QUOTATION MARK" },
	{ 0x301F, "LOW DOUBLE PRIME QUOTATION MARK" },
	{ 0x3020, "POSTAL MARK FACE" },
	{ 0x3021, "HANGZHOU NUMERAL ONE" },
	{ 0x3022, "HANGZHOU NUMERAL TWO" },
	{ 0x3023, "HANGZHOU NUMERAL THREE" },
	{ 0x3024, "HANGZHOU NUMERAL FOUR" },
	{ 0x3025, "HANGZHOU NUMERAL FIVE" },
	{ 0x3026, "HANGZHOU NUMERAL SIX" },
	{ 0x3027, "HANGZHOU NUMERAL SEVEN" },
	{ 0x3028, "HANGZHOU NUMERAL EIGHT" },
	{ 0x3029, "HANGZHOU NUMERAL NINE" },
	{ 0x302A, "IDEOGRAPHIC LEVEL TONE MARK" },
	{ 0x302B, "IDEOGRAPHIC RISING TONE MARK" },
	{ 0x302C, "IDEOGRAPHIC DEPARTING TONE MARK" },
	{ 0x302D, "IDEOGRAPHIC ENTERING TONE MARK" },
	{ 0x302E, "HANGUL SINGLE DOT TONE MARK" },
	{ 0x302F, "HANGUL DOUBLE DOT TONE MARK" },
	{ 0x3030, "WAVY DASH" },
	{ 0x3031, "VERTICAL KANA REPEAT MARK" },
	{ 0x3032, "VERTICAL KANA REPEAT WITH VOICED SOUND MARK" },
	{ 0x3033, "VERTICAL KANA REPEAT MARK UPPER HALF" },
	{ 0x3034, "VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF" },
	{ 0x3035, "VERTICAL KANA REPEAT MARK LOWER HALF" },
	{ 0x3036, "CIRCLED POSTAL MARK" },
	{ 0x3037, "IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL" },
	{ 0x3038, "HANGZHOU NUMERAL TEN" },
	{ 0x3039, "HANGZHOU NUMERAL TWENTY" },
	{ 0x303A, "HANGZHOU NUMERAL THIRTY" },
	{ 0x303E, "IDEOGRAPHIC VARIATION INDICATOR" },
	{ 0x303F, "IDEOGRAPHIC HALF FILL SPACE" },
	{ 0x3041, "HIRAGANA LETTER SMALL A" },
	{ 0x3042, "HIRAGANA LETTER A" },
	{ 0x3043, "HIRAGANA LETTER SMALL I" },
	{ 0x3044, "HIRAGANA LETTER I" },
	{ 0x3045, "HIRAGANA LETTER SMALL U" },
	{ 0x3046, "HIRAGANA LETTER U" },
	{ 0x3047, "HIRAGANA LETTER SMALL E" },
	{ 0x3048, "HIRAGANA LETTER E" },
	{ 0x3049, "HIRAGANA LETTER SMALL O" },
	{ 0x304A, "HIRAGANA LETTER O" },
	{ 0x304B, "HIRAGANA LETTER KA" },
	{ 0x304C, "HIRAGANA LETTER GA" },
	{ 0x304D, "HIRAGANA LETTER KI" },
	{ 0x304E, "HIRAGANA LETTER GI" },
	{ 0x304F, "HIRAGANA LETTER KU" },
	{ 0x3050, "HIRAGANA LETTER GU" },
	{ 0x3051, "HIRAGANA LETTER KE" },
	{ 0x3052, "HIRAGANA LETTER GE" },
	{ 0x3053, "HIRAGANA LETTER KO" },
	{ 0x3054, "HIRAGANA LETTER GO" },
	{ 0x3055, "HIRAGANA LETTER SA" },
	{ 0x3056, "HIRAGANA LETTER ZA" },
	{ 0x3057, "HIRAGANA LETTER SI" },
	{ 0x3058, "HIRAGANA LETTER ZI" },
	{ 0x3059, "HIRAGANA LETTER SU" },
	{ 0x305A, "HIRAGANA LETTER ZU" },
	{ 0x305B, "HIRAGANA LETTER SE" },
	{ 0x305C, "HIRAGANA LETTER ZE" },
	{ 0x305D, "HIRAGANA LETTER SO" },
	{ 0x305E, "HIRAGANA LETTER ZO" },
	{ 0x305F, "HIRAGANA LETTER TA" },
	{ 0x3060, "HIRAGANA LETTER DA" },
	{ 0x3061, "HIRAGANA LETTER TI" },
	{ 0x3062, "HIRAGANA LETTER DI" },
	{ 0x3063, "HIRAGANA LETTER SMALL TU" },
	{ 0x3064, "HIRAGANA LETTER TU" },
	{ 0x3065, "HIRAGANA LETTER DU" },
	{ 0x3066, "HIRAGANA LETTER TE" },
	{ 0x3067, "HIRAGANA LETTER DE" },
	{ 0x3068, "HIRAGANA LETTER TO" },
	{ 0x3069, "HIRAGANA LETTER DO" },
	{ 0x306A, "HIRAGANA LETTER NA" },
	{ 0x306B, "HIRAGANA LETTER NI" },
	{ 0x306C, "HIRAGANA LETTER NU" },
	{ 0x306D, "HIRAGANA LETTER NE" },
	{ 0x306E, "HIRAGANA LETTER NO" },
	{ 0x306F, "HIRAGANA LETTER HA" },
	{ 0x3070, "HIRAGANA LETTER BA" },
	{ 0x3071, "HIRAGANA LETTER PA" },
	{ 0x3072, "HIRAGANA LETTER HI" },
	{ 0x3073, "HIRAGANA LETTER BI" },
	{ 0x3074, "HIRAGANA LETTER PI" },
	{ 0x3075, "HIRAGANA LETTER HU" },
	{ 0x3076, "HIRAGANA LETTER BU" },
	{ 0x3077, "HIRAGANA LETTER PU" },
	{ 0x3078, "HIRAGANA LETTER HE" },
	{ 0x3079, "HIRAGANA LETTER BE" },
	{ 0x307A, "HIRAGANA LETTER PE" },
	{ 0x307B, "HIRAGANA LETTER HO" },
	{ 0x307C, "HIRAGANA LETTER BO" },
	{ 0x307D, "HIRAGANA LETTER PO" },
	{ 0x307E, "HIRAGANA LETTER MA" },
	{ 0x307F, "HIRAGANA LETTER MI" },
	{ 0x3080, "HIRAGANA LETTER MU" },
	{ 0x3081, "HIRAGANA LETTER ME" },
	{ 0x3082, "HIRAGANA LETTER MO" },
	{ 0x3083, "HIRAGANA LETTER SMALL YA" },
	{ 0x3084, "HIRAGANA LETTER YA" },
	{ 0x3085, "HIRAGANA LETTER SMALL YU" },
	{ 0x3086, "HIRAGANA LETTER YU" },
	{ 0x3087, "HIRAGANA LETTER SMALL YO" },
	{ 0x3088, "HIRAGANA LETTER YO" },
	{ 0x3089, "HIRAGANA LETTER RA" },
	{ 0x308A, "HIRAGANA LETTER RI" },
	{ 0x308B, "HIRAGANA LETTER RU" },
	{ 0x308C, "HIRAGANA LETTER RE" },
	{ 0x308D, "HIRAGANA LETTER RO" },
	{ 0x308E, "HIRAGANA LETTER SMALL WA" },
	{ 0x308F, "HIRAGANA LETTER WA" },
	{ 0x3090, "HIRAGANA LETTER WI" },
	{ 0x3091, "HIRAGANA LETTER WE" },
	{ 0x3092, "HIRAGANA LETTER WO" },
	{ 0x3093, "HIRAGANA LETTER N" },
	{ 0x3094, "HIRAGANA LETTER VU" },
	{ 0x3099, "COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK" },
	{ 0x309A, "COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" },
	{ 0x309B, "KATAKANA-HIRAGANA VOICED SOUND MARK" },
	{ 0x309C, "KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" },
	{ 0x309D, "HIRAGANA ITERATION MARK" },
	{ 0x309E, "HIRAGANA VOICED ITERATION MARK" },
	{ 0x30A1, "KATAKANA LETTER SMALL A" },
	{ 0x30A2, "KATAKANA LETTER A" },
	{ 0x30A3, "KATAKANA LETTER SMALL I" },
	{ 0x30A4, "KATAKANA LETTER I" },
	{ 0x30A5, "KATAKANA LETTER SMALL U" },
	{ 0x30A6, "KATAKANA LETTER U" },
	{ 0x30A7, "KATAKANA LETTER SMALL E" },
	{ 0x30A8, "KATAKANA LETTER E" },
	{ 0x30A9, "KATAKANA LETTER SMALL O" },
	{ 0x30AA, "KATAKANA LETTER O" },
	{ 0x30AB, "KATAKANA LETTER KA" },
	{ 0x30AC, "KATAKANA LETTER GA" },
	{ 0x30AD, "KATAKANA LETTER KI" },
	{ 0x30AE, "KATAKANA LETTER GI" },
	{ 0x30AF, "KATAKANA LETTER KU" },
	{ 0x30B0, "KATAKANA LETTER GU" },
	{ 0x30B1, "KATAKANA LETTER KE" },
	{ 0x30B2, "KATAKANA LETTER GE" },
	{ 0x30B3, "KATAKANA LETTER KO" },
	{ 0x30B4, "KATAKANA LETTER GO" },
	{ 0x30B5, "KATAKANA LETTER SA" },
	{ 0x30B6, "KATAKANA LETTER ZA" },
	{ 0x30B7, "KATAKANA LETTER SI" },
	{ 0x30B8, "KATAKANA LETTER ZI" },
	{ 0x30B9, "KATAKANA LETTER SU" },
	{ 0x30BA, "KATAKANA LETTER ZU" },
	{ 0x30BB, "KATAKANA LETTER SE" },
	{ 0x30BC, "KATAKANA LETTER ZE" },
	{ 0x30BD, "KATAKANA LETTER SO" },
	{ 0x30BE, "KATAKANA LETTER ZO" },
	{ 0x30BF, "KATAKANA LETTER TA" },
	{ 0x30C0, "KATAKANA LETTER DA" },
	{ 0x30C1, "KATAKANA LETTER TI" },
	{ 0x30C2, "KATAKANA LETTER DI" },
	{ 0x30C3, "KATAKANA LETTER SMALL TU" },
	{ 0x30C4, "KATAKANA LETTER TU" },
	{ 0x30C5, "KATAKANA LETTER DU" },
	{ 0x30C6, "KATAKANA LETTER TE" },
	{ 0x30C7, "KATAKANA LETTER DE" },
	{ 0x30C8, "KATAKANA LETTER TO" },
	{ 0x30C9, "KATAKANA LETTER DO" },
	{ 0x30CA, "KATAKANA LETTER NA" },
	{ 0x30CB, "KATAKANA LETTER NI" },
	{ 0x30CC, "KATAKANA LETTER NU" },
	{ 0x30CD, "KATAKANA LETTER NE" },
	{ 0x30CE, "KATAKANA LETTER NO" },
	{ 0x30CF, "KATAKANA LETTER HA" },
	{ 0x30D0, "KATAKANA LETTER BA" },
	{ 0x30D1, "KATAKANA LETTER PA" },
	{ 0x30D2, "KATAKANA LETTER HI" },
	{ 0x30D3, "KATAKANA LETTER BI" },
	{ 0x30D4, "KATAKANA LETTER PI" },
	{ 0x30D5, "KATAKANA LETTER HU" },
	{ 0x30D6, "KATAKANA LETTER BU" },
	{ 0x30D7, "KATAKANA LETTER PU" },
	{ 0x30D8, "KATAKANA LETTER HE" },
	{ 0x30D9, "KATAKANA LETTER BE" },
	{ 0x30DA, "KATAKANA LETTER PE" },
	{ 0x30DB, "KATAKANA LETTER HO" },
	{ 0x30DC, "KATAKANA LETTER BO" },
	{ 0x30DD, "KATAKANA LETTER PO" },
	{ 0x30DE, "KATAKANA LETTER MA" },
	{ 0x30DF, "KATAKANA LETTER MI" },
	{ 0x30E0, "KATAKANA LETTER MU" },
	{ 0x30E1, "KATAKANA LETTER ME" },
	{ 0x30E2, "KATAKANA LETTER MO" },
	{ 0x30E3, "KATAKANA LETTER SMALL YA" },
	{ 0x30E4, "KATAKANA LETTER YA" },
	{ 0x30E5, "KATAKANA LETTER SMALL YU" },
	{ 0x30E6, "KATAKANA LETTER YU" },
	{ 0x30E7, "KATAKANA LETTER SMALL YO" },
	{ 0x30E8, "KATAKANA LETTER YO" },
	{ 0x30E9, "KATAKANA LETTER RA" },
	{ 0x30EA, "KATAKANA LETTER RI" },
	{ 0x30EB, "KATAKANA LETTER RU" },
	{ 0x30EC, "KATAKANA LETTER RE" },
	{ 0x30ED, "KATAKANA LETTER RO" },
	{ 0x30EE, "KATAKANA LETTER SMALL WA" },
	{ 0x30EF, "KATAKANA LETTER WA" },
	{ 0x30F0, "KATAKANA LETTER WI" },
	{ 0x30F1, "KATAKANA LETTER WE" },
	{ 0x30F2, "KATAKANA LETTER WO" },
	{ 0x30F3, "KATAKANA LETTER N" },
	{ 0x30F4, "KATAKANA LETTER VU" },
	{ 0x30F5, "KATAKANA LETTER SMALL KA" },
	{ 0x30F6, "KATAKANA LETTER SMALL KE" },
	{ 0x30F7, "KATAKANA LETTER VA" },
	{ 0x30F8, "KATAKANA LETTER VI" },
	{ 0x30F9, "KATAKANA LETTER VE" },
	{ 0x30FA, "KATAKANA LETTER VO" },
	{ 0x30FB, "KATAKANA MIDDLE DOT" },
	{ 0x30FC, "KATAKANA-HIRAGANA PROLONGED SOUND MARK" },
	{ 0x30FD, "KATAKANA ITERATION MARK" },
	{ 0x30FE, "KATAKANA VOICED ITERATION MARK" },
	{ 0x3105, "BOPOMOFO LETTER B" },
	{ 0x3106, "BOPOMOFO LETTER P" },
	{ 0x3107, "BOPOMOFO LETTER M" },
	{ 0x3108, "BOPOMOFO LETTER F" },
	{ 0x3109, "BOPOMOFO LETTER D" },
	{ 0x310A, "BOPOMOFO LETTER T" },
	{ 0x310B, "BOPOMOFO LETTER N" },
	{ 0x310C, "BOPOMOFO LETTER L" },
	{ 0x310D, "BOPOMOFO LETTER G" },
	{ 0x310E, "BOPOMOFO LETTER K" },
	{ 0x310F, "BOPOMOFO LETTER H" },
	{ 0x3110, "BOPOMOFO LETTER J" },
	{ 0x3111, "BOPOMOFO LETTER Q" },
	{ 0x3112, "BOPOMOFO LETTER X" },
	{ 0x3113, "BOPOMOFO LETTER ZH" },
	{ 0x3114, "BOPOMOFO LETTER CH" },
	{ 0x3115, "BOPOMOFO LETTER SH" },
	{ 0x3116, "BOPOMOFO LETTER R" },
	{ 0x3117, "BOPOMOFO LETTER Z" },
	{ 0x3118, "BOPOMOFO LETTER C" },
	{ 0x3119, "BOPOMOFO LETTER S" },
	{ 0x311A, "BOPOMOFO LETTER A" },
	{ 0x311B, "BOPOMOFO LETTER O" },
	{ 0x311C, "BOPOMOFO LETTER E" },
	{ 0x311D, "BOPOMOFO LETTER EH" },
	{ 0x311E, "BOPOMOFO LETTER AI" },
	{ 0x311F, "BOPOMOFO LETTER EI" },
	{ 0x3120, "BOPOMOFO LETTER AU" },
	{ 0x3121, "BOPOMOFO LETTER OU" },
	{ 0x3122, "BOPOMOFO LETTER AN" },
	{ 0x3123, "BOPOMOFO LETTER EN" },
	{ 0x3124, "BOPOMOFO LETTER ANG" },
	{ 0x3125, "BOPOMOFO LETTER ENG" },
	{ 0x3126, "BOPOMOFO LETTER ER" },
	{ 0x3127, "BOPOMOFO LETTER I" },
	{ 0x3128, "BOPOMOFO LETTER U" },
	{ 0x3129, "BOPOMOFO LETTER IU" },
	{ 0x312A, "BOPOMOFO LETTER V" },
	{ 0x312B, "BOPOMOFO LETTER NG" },
	{ 0x312C, "BOPOMOFO LETTER GN" },
	{ 0x3131, "HANGUL LETTER KIYEOK" },
	{ 0x3132, "HANGUL LETTER SSANGKIYEOK" },
	{ 0x3133, "HANGUL LETTER KIYEOK-SIOS" },
	{ 0x3134, "HANGUL LETTER NIEUN" },
	{ 0x3135, "HANGUL LETTER NIEUN-CIEUC" },
	{ 0x3136, "HANGUL LETTER NIEUN-HIEUH" },
	{ 0x3137, "HANGUL LETTER TIKEUT" },
	{ 0x3138, "HANGUL LETTER SSANGTIKEUT" },
	{ 0x3139, "HANGUL LETTER RIEUL" },
	{ 0x313A, "HANGUL LETTER RIEUL-KIYEOK" },
	{ 0x313B, "HANGUL LETTER RIEUL-MIEUM" },
	{ 0x313C, "HANGUL LETTER RIEUL-PIEUP" },
	{ 0x313D, "HANGUL LETTER RIEUL-SIOS" },
	{ 0x313E, "HANGUL LETTER RIEUL-THIEUTH" },
	{ 0x313F, "HANGUL LETTER RIEUL-PHIEUPH" },
	{ 0x3140, "HANGUL LETTER RIEUL-HIEUH" },
	{ 0x3141, "HANGUL LETTER MIEUM" },
	{ 0x3142, "HANGUL LETTER PIEUP" },
	{ 0x3143, "HANGUL LETTER SSANGPIEUP" },
	{ 0x3144, "HANGUL LETTER PIEUP-SIOS" },
	{ 0x3145, "HANGUL LETTER SIOS" },
	{ 0x3146, "HANGUL LETTER SSANGSIOS" },
	{ 0x3147, "HANGUL LETTER IEUNG" },
	{ 0x3148, "HANGUL LETTER CIEUC" },
	{ 0x3149, "HANGUL LETTER SSANGCIEUC" },
	{ 0x314A, "HANGUL LETTER CHIEUCH" },
	{ 0x314B, "HANGUL LETTER KHIEUKH" },
	{ 0x314C, "HANGUL LETTER THIEUTH" },
	{ 0x314D, "HANGUL LETTER PHIEUPH" },
	{ 0x314E, "HANGUL LETTER HIEUH" },
	{ 0x314F, "HANGUL LETTER A" },
	{ 0x3150, "HANGUL LETTER AE" },
	{ 0x3151, "HANGUL LETTER YA" },
	{ 0x3152, "HANGUL LETTER YAE" },
	{ 0x3153, "HANGUL LETTER EO" },
	{ 0x3154, "HANGUL LETTER E" },
	{ 0x3155, "HANGUL LETTER YEO" },
	{ 0x3156, "HANGUL LETTER YE" },
	{ 0x3157, "HANGUL LETTER O" },
	{ 0x3158, "HANGUL LETTER WA" },
	{ 0x3159, "HANGUL LETTER WAE" },
	{ 0x315A, "HANGUL LETTER OE" },
	{ 0x315B, "HANGUL LETTER YO" },
	{ 0x315C, "HANGUL LETTER U" },
	{ 0x315D, "HANGUL LETTER WEO" },
	{ 0x315E, "HANGUL LETTER WE" },
	{ 0x315F, "HANGUL LETTER WI" },
	{ 0x3160, "HANGUL LETTER YU" },
	{ 0x3161, "HANGUL LETTER EU" },
	{ 0x3162, "HANGUL LETTER YI" },
	{ 0x3163, "HANGUL LETTER I" },
	{ 0x3164, "HANGUL FILLER" },
	{ 0x3165, "HANGUL LETTER SSANGNIEUN" },
	{ 0x3166, "HANGUL LETTER NIEUN-TIKEUT" },
	{ 0x3167, "HANGUL LETTER NIEUN-SIOS" },
	{ 0x3168, "HANGUL LETTER NIEUN-PANSIOS" },
	{ 0x3169, "HANGUL LETTER RIEUL-KIYEOK-SIOS" },
	{ 0x316A, "HANGUL LETTER RIEUL-TIKEUT" },
	{ 0x316B, "HANGUL LETTER RIEUL-PIEUP-SIOS" },
	{ 0x316C, "HANGUL LETTER RIEUL-PANSIOS" },
	{ 0x316D, "HANGUL LETTER RIEUL-YEORINHIEUH" },
	{ 0x316E, "HANGUL LETTER MIEUM-PIEUP" },
	{ 0x316F, "HANGUL LETTER MIEUM-SIOS" },
	{ 0x3170, "HANGUL LETTER MIEUM-PANSIOS" },
	{ 0x3171, "HANGUL LETTER KAPYEOUNMIEUM" },
	{ 0x3172, "HANGUL LETTER PIEUP-KIYEOK" },
	{ 0x3173, "HANGUL LETTER PIEUP-TIKEUT" },
	{ 0x3174, "HANGUL LETTER PIEUP-SIOS-KIYEOK" },
	{ 0x3175, "HANGUL LETTER PIEUP-SIOS-TIKEUT" },
	{ 0x3176, "HANGUL LETTER PIEUP-CIEUC" },
	{ 0x3177, "HANGUL LETTER PIEUP-THIEUTH" },
	{ 0x3178, "HANGUL LETTER KAPYEOUNPIEUP" },
	{ 0x3179, "HANGUL LETTER KAPYEOUNSSANGPIEUP" },
	{ 0x317A, "HANGUL LETTER SIOS-KIYEOK" },
	{ 0x317B, "HANGUL LETTER SIOS-NIEUN" },
	{ 0x317C, "HANGUL LETTER SIOS-TIKEUT" },
	{ 0x317D, "HANGUL LETTER SIOS-PIEUP" },
	{ 0x317E, "HANGUL LETTER SIOS-CIEUC" },
	{ 0x317F, "HANGUL LETTER PANSIOS" },
	{ 0x3180, "HANGUL LETTER SSANGIEUNG" },
	{ 0x3181, "HANGUL LETTER YESIEUNG" },
	{ 0x3182, "HANGUL LETTER YESIEUNG-SIOS" },
	{ 0x3183, "HANGUL LETTER YESIEUNG-PANSIOS" },
	{ 0x3184, "HANGUL LETTER KAPYEOUNPHIEUPH" },
	{ 0x3185, "HANGUL LETTER SSANGHIEUH" },
	{ 0x3186, "HANGUL LETTER YEORINHIEUH" },
	{ 0x3187, "HANGUL LETTER YO-YA" },
	{ 0x3188, "HANGUL LETTER YO-YAE" },
	{ 0x3189, "HANGUL LETTER YO-I" },
	{ 0x318A, "HANGUL LETTER YU-YEO" },
	{ 0x318B, "HANGUL LETTER YU-YE" },
	{ 0x318C, "HANGUL LETTER YU-I" },
	{ 0x318D, "HANGUL LETTER ARAEA" },
	{ 0x318E, "HANGUL LETTER ARAEAE" },
	{ 0x3190, "IDEOGRAPHIC ANNOTATION LINKING MARK" },	/* Kanbun Tateten */
	{ 0x3191, "IDEOGRAPHIC ANNOTATION REVERSE MARK" },	/* Kaeriten */
	{ 0x3192, "IDEOGRAPHIC ANNOTATION ONE MARK" },	/* Kaeriten */
	{ 0x3193, "IDEOGRAPHIC ANNOTATION TWO MARK" },	/* Kaeriten */
	{ 0x3194, "IDEOGRAPHIC ANNOTATION THREE MARK" },	/* Kaeriten */
	{ 0x3195, "IDEOGRAPHIC ANNOTATION FOUR MARK" },	/* Kaeriten */
	{ 0x3196, "IDEOGRAPHIC ANNOTATION TOP MARK" },	/* Kaeriten */
	{ 0x3197, "IDEOGRAPHIC ANNOTATION MIDDLE MARK" },	/* Kaeriten */
	{ 0x3198, "IDEOGRAPHIC ANNOTATION BOTTOM MARK" },	/* Kaeriten */
	{ 0x3199, "IDEOGRAPHIC ANNOTATION FIRST MARK" },	/* Kaeriten */
	{ 0x319A, "IDEOGRAPHIC ANNOTATION SECOND MARK" },	/* Kaeriten */
	{ 0x319B, "IDEOGRAPHIC ANNOTATION THIRD MARK" },	/* Kaeriten */
	{ 0x319C, "IDEOGRAPHIC ANNOTATION FOURTH MARK" },	/* Kaeriten */
	{ 0x319D, "IDEOGRAPHIC ANNOTATION HEAVEN MARK" },	/* Kaeriten */
	{ 0x319E, "IDEOGRAPHIC ANNOTATION EARTH MARK" },	/* Kaeriten */
	{ 0x319F, "IDEOGRAPHIC ANNOTATION MAN MARK" },	/* Kaeriten */
	{ 0x31A0, "BOPOMOFO LETTER BU" },
	{ 0x31A1, "BOPOMOFO LETTER ZI" },
	{ 0x31A2, "BOPOMOFO LETTER JI" },
	{ 0x31A3, "BOPOMOFO LETTER GU" },
	{ 0x31A4, "BOPOMOFO LETTER EE" },
	{ 0x31A5, "BOPOMOFO LETTER ENN" },
	{ 0x31A6, "BOPOMOFO LETTER OO" },
	{ 0x31A7, "BOPOMOFO LETTER ONN" },
	{ 0x31A8, "BOPOMOFO LETTER IR" },
	{ 0x31A9, "BOPOMOFO LETTER ANN" },
	{ 0x31AA, "BOPOMOFO LETTER INN" },
	{ 0x31AB, "BOPOMOFO LETTER UNN" },
	{ 0x31AC, "BOPOMOFO LETTER IM" },
	{ 0x31AD, "BOPOMOFO LETTER NGG" },
	{ 0x31AE, "BOPOMOFO LETTER AINN" },
	{ 0x31AF, "BOPOMOFO LETTER AUNN" },
	{ 0x31B0, "BOPOMOFO LETTER AM" },
	{ 0x31B1, "BOPOMOFO LETTER OM" },
	{ 0x31B2, "BOPOMOFO LETTER ONG" },
	{ 0x31B3, "BOPOMOFO LETTER INNN" },
	{ 0x31B4, "BOPOMOFO FINAL LETTER P" },
	{ 0x31B5, "BOPOMOFO FINAL LETTER T" },
	{ 0x31B6, "BOPOMOFO FINAL LETTER K" },
	{ 0x31B7, "BOPOMOFO FINAL LETTER H" },
	{ 0x3200, "PARENTHESIZED HANGUL KIYEOK" },
	{ 0x3201, "PARENTHESIZED HANGUL NIEUN" },
	{ 0x3202, "PARENTHESIZED HANGUL TIKEUT" },
	{ 0x3203, "PARENTHESIZED HANGUL RIEUL" },
	{ 0x3204, "PARENTHESIZED HANGUL MIEUM" },
	{ 0x3205, "PARENTHESIZED HANGUL PIEUP" },
	{ 0x3206, "PARENTHESIZED HANGUL SIOS" },
	{ 0x3207, "PARENTHESIZED HANGUL IEUNG" },
	{ 0x3208, "PARENTHESIZED HANGUL CIEUC" },
	{ 0x3209, "PARENTHESIZED HANGUL CHIEUCH" },
	{ 0x320A, "PARENTHESIZED HANGUL KHIEUKH" },
	{ 0x320B, "PARENTHESIZED HANGUL THIEUTH" },
	{ 0x320C, "PARENTHESIZED HANGUL PHIEUPH" },
	{ 0x320D, "PARENTHESIZED HANGUL HIEUH" },
	{ 0x320E, "PARENTHESIZED HANGUL KIYEOK A" },
	{ 0x320F, "PARENTHESIZED HANGUL NIEUN A" },
	{ 0x3210, "PARENTHESIZED HANGUL TIKEUT A" },
	{ 0x3211, "PARENTHESIZED HANGUL RIEUL A" },
	{ 0x3212, "PARENTHESIZED HANGUL MIEUM A" },
	{ 0x3213, "PARENTHESIZED HANGUL PIEUP A" },
	{ 0x3214, "PARENTHESIZED HANGUL SIOS A" },
	{ 0x3215, "PARENTHESIZED HANGUL IEUNG A" },
	{ 0x3216, "PARENTHESIZED HANGUL CIEUC A" },
	{ 0x3217, "PARENTHESIZED HANGUL CHIEUCH A" },
	{ 0x3218, "PARENTHESIZED HANGUL KHIEUKH A" },
	{ 0x3219, "PARENTHESIZED HANGUL THIEUTH A" },
	{ 0x321A, "PARENTHESIZED HANGUL PHIEUPH A" },
	{ 0x321B, "PARENTHESIZED HANGUL HIEUH A" },
	{ 0x321C, "PARENTHESIZED HANGUL CIEUC U" },
	{ 0x3220, "PARENTHESIZED IDEOGRAPH ONE" },
	{ 0x3221, "PARENTHESIZED IDEOGRAPH TWO" },
	{ 0x3222, "PARENTHESIZED IDEOGRAPH THREE" },
	{ 0x3223, "PARENTHESIZED IDEOGRAPH FOUR" },
	{ 0x3224, "PARENTHESIZED IDEOGRAPH FIVE" },
	{ 0x3225, "PARENTHESIZED IDEOGRAPH SIX" },
	{ 0x3226, "PARENTHESIZED IDEOGRAPH SEVEN" },
	{ 0x3227, "PARENTHESIZED IDEOGRAPH EIGHT" },
	{ 0x3228, "PARENTHESIZED IDEOGRAPH NINE" },
	{ 0x3229, "PARENTHESIZED IDEOGRAPH TEN" },
	{ 0x322A, "PARENTHESIZED IDEOGRAPH MOON" },
	{ 0x322B, "PARENTHESIZED IDEOGRAPH FIRE" },
	{ 0x322C, "PARENTHESIZED IDEOGRAPH WATER" },
	{ 0x322D, "PARENTHESIZED IDEOGRAPH WOOD" },
	{ 0x322E, "PARENTHESIZED IDEOGRAPH METAL" },
	{ 0x322F, "PARENTHESIZED IDEOGRAPH EARTH" },
	{ 0x3230, "PARENTHESIZED IDEOGRAPH SUN" },
	{ 0x3231, "PARENTHESIZED IDEOGRAPH STOCK" },
	{ 0x3232, "PARENTHESIZED IDEOGRAPH HAVE" },
	{ 0x3233, "PARENTHESIZED IDEOGRAPH SOCIETY" },
	{ 0x3234, "PARENTHESIZED IDEOGRAPH NAME" },
	{ 0x3235, "PARENTHESIZED IDEOGRAPH SPECIAL" },
	{ 0x3236, "PARENTHESIZED IDEOGRAPH FINANCIAL" },
	{ 0x3237, "PARENTHESIZED IDEOGRAPH CONGRATULATION" },
	{ 0x3238, "PARENTHESIZED IDEOGRAPH LABOR" },
	{ 0x3239, "PARENTHESIZED IDEOGRAPH REPRESENT" },
	{ 0x323A, "PARENTHESIZED IDEOGRAPH CALL" },
	{ 0x323B, "PARENTHESIZED IDEOGRAPH STUDY" },
	{ 0x323C, "PARENTHESIZED IDEOGRAPH SUPERVISE" },
	{ 0x323D, "PARENTHESIZED IDEOGRAPH ENTERPRISE" },
	{ 0x323E, "PARENTHESIZED IDEOGRAPH RESOURCE" },
	{ 0x323F, "PARENTHESIZED IDEOGRAPH ALLIANCE" },
	{ 0x3240, "PARENTHESIZED IDEOGRAPH FESTIVAL" },
	{ 0x3241, "PARENTHESIZED IDEOGRAPH REST" },
	{ 0x3242, "PARENTHESIZED IDEOGRAPH SELF" },
	{ 0x3243, "PARENTHESIZED IDEOGRAPH REACH" },
	{ 0x3260, "CIRCLED HANGUL KIYEOK" },
	{ 0x3261, "CIRCLED HANGUL NIEUN" },
	{ 0x3262, "CIRCLED HANGUL TIKEUT" },
	{ 0x3263, "CIRCLED HANGUL RIEUL" },
	{ 0x3264, "CIRCLED HANGUL MIEUM" },
	{ 0x3265, "CIRCLED HANGUL PIEUP" },
	{ 0x3266, "CIRCLED HANGUL SIOS" },
	{ 0x3267, "CIRCLED HANGUL IEUNG" },
	{ 0x3268, "CIRCLED HANGUL CIEUC" },
	{ 0x3269, "CIRCLED HANGUL CHIEUCH" },
	{ 0x326A, "CIRCLED HANGUL KHIEUKH" },
	{ 0x326B, "CIRCLED HANGUL THIEUTH" },
	{ 0x326C, "CIRCLED HANGUL PHIEUPH" },
	{ 0x326D, "CIRCLED HANGUL HIEUH" },
	{ 0x326E, "CIRCLED HANGUL KIYEOK A" },
	{ 0x326F, "CIRCLED HANGUL NIEUN A" },
	{ 0x3270, "CIRCLED HANGUL TIKEUT A" },
	{ 0x3271, "CIRCLED HANGUL RIEUL A" },
	{ 0x3272, "CIRCLED HANGUL MIEUM A" },
	{ 0x3273, "CIRCLED HANGUL PIEUP A" },
	{ 0x3274, "CIRCLED HANGUL SIOS A" },
	{ 0x3275, "CIRCLED HANGUL IEUNG A" },
	{ 0x3276, "CIRCLED HANGUL CIEUC A" },
	{ 0x3277, "CIRCLED HANGUL CHIEUCH A" },
	{ 0x3278, "CIRCLED HANGUL KHIEUKH A" },
	{ 0x3279, "CIRCLED HANGUL THIEUTH A" },
	{ 0x327A, "CIRCLED HANGUL PHIEUPH A" },
	{ 0x327B, "CIRCLED HANGUL HIEUH A" },
	{ 0x327F, "KOREAN STANDARD SYMBOL" },
	{ 0x3280, "CIRCLED IDEOGRAPH ONE" },
	{ 0x3281, "CIRCLED IDEOGRAPH TWO" },
	{ 0x3282, "CIRCLED IDEOGRAPH THREE" },
	{ 0x3283, "CIRCLED IDEOGRAPH FOUR" },
	{ 0x3284, "CIRCLED IDEOGRAPH FIVE" },
	{ 0x3285, "CIRCLED IDEOGRAPH SIX" },
	{ 0x3286, "CIRCLED IDEOGRAPH SEVEN" },
	{ 0x3287, "CIRCLED IDEOGRAPH EIGHT" },
	{ 0x3288, "CIRCLED IDEOGRAPH NINE" },
	{ 0x3289, "CIRCLED IDEOGRAPH TEN" },
	{ 0x328A, "CIRCLED IDEOGRAPH MOON" },
	{ 0x328B, "CIRCLED IDEOGRAPH FIRE" },
	{ 0x328C, "CIRCLED IDEOGRAPH WATER" },
	{ 0x328D, "CIRCLED IDEOGRAPH WOOD" },
	{ 0x328E, "CIRCLED IDEOGRAPH METAL" },
	{ 0x328F, "CIRCLED IDEOGRAPH EARTH" },
	{ 0x3290, "CIRCLED IDEOGRAPH SUN" },
	{ 0x3291, "CIRCLED IDEOGRAPH STOCK" },
	{ 0x3292, "CIRCLED IDEOGRAPH HAVE" },
	{ 0x3293, "CIRCLED IDEOGRAPH SOCIETY" },
	{ 0x3294, "CIRCLED IDEOGRAPH NAME" },
	{ 0x3295, "CIRCLED IDEOGRAPH SPECIAL" },
	{ 0x3296, "CIRCLED IDEOGRAPH FINANCIAL" },
	{ 0x3297, "CIRCLED IDEOGRAPH CONGRATULATION" },
	{ 0x3298, "CIRCLED IDEOGRAPH LABOR" },
	{ 0x3299, "CIRCLED IDEOGRAPH SECRET" },
	{ 0x329A, "CIRCLED IDEOGRAPH MALE" },
	{ 0x329B, "CIRCLED IDEOGRAPH FEMALE" },
	{ 0x329C, "CIRCLED IDEOGRAPH SUITABLE" },
	{ 0x329D, "CIRCLED IDEOGRAPH EXCELLENT" },
	{ 0x329E, "CIRCLED IDEOGRAPH PRINT" },
	{ 0x329F, "CIRCLED IDEOGRAPH ATTENTION" },
	{ 0x32A0, "CIRCLED IDEOGRAPH ITEM" },
	{ 0x32A1, "CIRCLED IDEOGRAPH REST" },
	{ 0x32A2, "CIRCLED IDEOGRAPH COPY" },
	{ 0x32A3, "CIRCLED IDEOGRAPH CORRECT" },
	{ 0x32A4, "CIRCLED IDEOGRAPH HIGH" },
	{ 0x32A5, "CIRCLED IDEOGRAPH CENTRE" },
	{ 0x32A6, "CIRCLED IDEOGRAPH LOW" },
	{ 0x32A7, "CIRCLED IDEOGRAPH LEFT" },
	{ 0x32A8, "CIRCLED IDEOGRAPH RIGHT" },
	{ 0x32A9, "CIRCLED IDEOGRAPH MEDICINE" },
	{ 0x32AA, "CIRCLED IDEOGRAPH RELIGION" },
	{ 0x32AB, "CIRCLED IDEOGRAPH STUDY" },
	{ 0x32AC, "CIRCLED IDEOGRAPH SUPERVISE" },
	{ 0x32AD, "CIRCLED IDEOGRAPH ENTERPRISE" },
	{ 0x32AE, "CIRCLED IDEOGRAPH RESOURCE" },
	{ 0x32AF, "CIRCLED IDEOGRAPH ALLIANCE" },
	{ 0x32B0, "CIRCLED IDEOGRAPH NIGHT" },
	{ 0x32C0, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY" },
	{ 0x32C1, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY" },
	{ 0x32C2, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH" },
	{ 0x32C3, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL" },
	{ 0x32C4, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY" },
	{ 0x32C5, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE" },
	{ 0x32C6, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY" },
	{ 0x32C7, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST" },
	{ 0x32C8, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER" },
	{ 0x32C9, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER" },
	{ 0x32CA, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER" },
	{ 0x32CB, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER" },
	{ 0x32D0, "CIRCLED KATAKANA A" },
	{ 0x32D1, "CIRCLED KATAKANA I" },
	{ 0x32D2, "CIRCLED KATAKANA U" },
	{ 0x32D3, "CIRCLED KATAKANA E" },
	{ 0x32D4, "CIRCLED KATAKANA O" },
	{ 0x32D5, "CIRCLED KATAKANA KA" },
	{ 0x32D6, "CIRCLED KATAKANA KI" },
	{ 0x32D7, "CIRCLED KATAKANA KU" },
	{ 0x32D8, "CIRCLED KATAKANA KE" },
	{ 0x32D9, "CIRCLED KATAKANA KO" },
	{ 0x32DA, "CIRCLED KATAKANA SA" },
	{ 0x32DB, "CIRCLED KATAKANA SI" },
	{ 0x32DC, "CIRCLED KATAKANA SU" },
	{ 0x32DD, "CIRCLED KATAKANA SE" },
	{ 0x32DE, "CIRCLED KATAKANA SO" },
	{ 0x32DF, "CIRCLED KATAKANA TA" },
	{ 0x32E0, "CIRCLED KATAKANA TI" },
	{ 0x32E1, "CIRCLED KATAKANA TU" },
	{ 0x32E2, "CIRCLED KATAKANA TE" },
	{ 0x32E3, "CIRCLED KATAKANA TO" },
	{ 0x32E4, "CIRCLED KATAKANA NA" },
	{ 0x32E5, "CIRCLED KATAKANA NI" },
	{ 0x32E6, "CIRCLED KATAKANA NU" },
	{ 0x32E7, "CIRCLED KATAKANA NE" },
	{ 0x32E8, "CIRCLED KATAKANA NO" },
	{ 0x32E9, "CIRCLED KATAKANA HA" },
	{ 0x32EA, "CIRCLED KATAKANA HI" },
	{ 0x32EB, "CIRCLED KATAKANA HU" },
	{ 0x32EC, "CIRCLED KATAKANA HE" },
	{ 0x32ED, "CIRCLED KATAKANA HO" },
	{ 0x32EE, "CIRCLED KATAKANA MA" },
	{ 0x32EF, "CIRCLED KATAKANA MI" },
	{ 0x32F0, "CIRCLED KATAKANA MU" },
	{ 0x32F1, "CIRCLED KATAKANA ME" },
	{ 0x32F2, "CIRCLED KATAKANA MO" },
	{ 0x32F3, "CIRCLED KATAKANA YA" },
	{ 0x32F4, "CIRCLED KATAKANA YU" },
	{ 0x32F5, "CIRCLED KATAKANA YO" },
	{ 0x32F6, "CIRCLED KATAKANA RA" },
	{ 0x32F7, "CIRCLED KATAKANA RI" },
	{ 0x32F8, "CIRCLED KATAKANA RU" },
	{ 0x32F9, "CIRCLED KATAKANA RE" },
	{ 0x32FA, "CIRCLED KATAKANA RO" },
	{ 0x32FB, "CIRCLED KATAKANA WA" },
	{ 0x32FC, "CIRCLED KATAKANA WI" },
	{ 0x32FD, "CIRCLED KATAKANA WE" },
	{ 0x32FE, "CIRCLED KATAKANA WO" },
	{ 0x3300, "SQUARE APAATO" },
	{ 0x3301, "SQUARE ARUHUA" },
	{ 0x3302, "SQUARE ANPEA" },
	{ 0x3303, "SQUARE AARU" },
	{ 0x3304, "SQUARE ININGU" },
	{ 0x3305, "SQUARE INTI" },
	{ 0x3306, "SQUARE UON" },
	{ 0x3307, "SQUARE ESUKUUDO" },
	{ 0x3308, "SQUARE EEKAA" },
	{ 0x3309, "SQUARE ONSU" },
	{ 0x330A, "SQUARE OOMU" },
	{ 0x330B, "SQUARE KAIRI" },
	{ 0x330C, "SQUARE KARATTO" },
	{ 0x330D, "SQUARE KARORII" },
	{ 0x330E, "SQUARE GARON" },
	{ 0x330F, "SQUARE GANMA" },
	{ 0x3310, "SQUARE GIGA" },
	{ 0x3311, "SQUARE GINII" },
	{ 0x3312, "SQUARE KYURII" },
	{ 0x3313, "SQUARE GIRUDAA" },
	{ 0x3314, "SQUARE KIRO" },
	{ 0x3315, "SQUARE KIROGURAMU" },
	{ 0x3316, "SQUARE KIROMEETORU" },
	{ 0x3317, "SQUARE KIROWATTO" },
	{ 0x3318, "SQUARE GURAMU" },
	{ 0x3319, "SQUARE GURAMUTON" },
	{ 0x331A, "SQUARE KURUZEIRO" },
	{ 0x331B, "SQUARE KUROONE" },
	{ 0x331C, "SQUARE KEESU" },
	{ 0x331D, "SQUARE KORUNA" },
	{ 0x331E, "SQUARE KOOPO" },
	{ 0x331F, "SQUARE SAIKURU" },
	{ 0x3320, "SQUARE SANTIIMU" },
	{ 0x3321, "SQUARE SIRINGU" },
	{ 0x3322, "SQUARE SENTI" },
	{ 0x3323, "SQUARE SENTO" },
	{ 0x3324, "SQUARE DAASU" },
	{ 0x3325, "SQUARE DESI" },
	{ 0x3326, "SQUARE DORU" },
	{ 0x3327, "SQUARE TON" },
	{ 0x3328, "SQUARE NANO" },
	{ 0x3329, "SQUARE NOTTO" },
	{ 0x332A, "SQUARE HAITU" },
	{ 0x332B, "SQUARE PAASENTO" },
	{ 0x332C, "SQUARE PAATU" },
	{ 0x332D, "SQUARE BAARERU" },
	{ 0x332E, "SQUARE PIASUTORU" },
	{ 0x332F, "SQUARE PIKURU" },
	{ 0x3330, "SQUARE PIKO" },
	{ 0x3331, "SQUARE BIRU" },
	{ 0x3332, "SQUARE HUARADDO" },
	{ 0x3333, "SQUARE HUIITO" },
	{ 0x3334, "SQUARE BUSSYERU" },
	{ 0x3335, "SQUARE HURAN" },
	{ 0x3336, "SQUARE HEKUTAARU" },
	{ 0x3337, "SQUARE PESO" },
	{ 0x3338, "SQUARE PENIHI" },
	{ 0x3339, "SQUARE HERUTU" },
	{ 0x333A, "SQUARE PENSU" },
	{ 0x333B, "SQUARE PEEZI" },
	{ 0x333C, "SQUARE BEETA" },
	{ 0x333D, "SQUARE POINTO" },
	{ 0x333E, "SQUARE BORUTO" },
	{ 0x333F, "SQUARE HON" },
	{ 0x3340, "SQUARE PONDO" },
	{ 0x3341, "SQUARE HOORU" },
	{ 0x3342, "SQUARE HOON" },
	{ 0x3343, "SQUARE MAIKURO" },
	{ 0x3344, "SQUARE MAIRU" },
	{ 0x3345, "SQUARE MAHHA" },
	{ 0x3346, "SQUARE MARUKU" },
	{ 0x3347, "SQUARE MANSYON" },
	{ 0x3348, "SQUARE MIKURON" },
	{ 0x3349, "SQUARE MIRI" },
	{ 0x334A, "SQUARE MIRIBAARU" },
	{ 0x334B, "SQUARE MEGA" },
	{ 0x334C, "SQUARE MEGATON" },
	{ 0x334D, "SQUARE MEETORU" },
	{ 0x334E, "SQUARE YAADO" },
	{ 0x334F, "SQUARE YAARU" },
	{ 0x3350, "SQUARE YUAN" },
	{ 0x3351, "SQUARE RITTORU" },
	{ 0x3352, "SQUARE RIRA" },
	{ 0x3353, "SQUARE RUPII" },
	{ 0x3354, "SQUARE RUUBURU" },
	{ 0x3355, "SQUARE REMU" },
	{ 0x3356, "SQUARE RENTOGEN" },
	{ 0x3357, "SQUARE WATTO" },
	{ 0x3358, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO" },
	{ 0x3359, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE" },
	{ 0x335A, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO" },
	{ 0x335B, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE" },
	{ 0x335C, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR" },
	{ 0x335D, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE" },
	{ 0x335E, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX" },
	{ 0x335F, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN" },
	{ 0x3360, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT" },
	{ 0x3361, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE" },
	{ 0x3362, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN" },
	{ 0x3363, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN" },
	{ 0x3364, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE" },
	{ 0x3365, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN" },
	{ 0x3366, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN" },
	{ 0x3367, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN" },
	{ 0x3368, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN" },
	{ 0x3369, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN" },
	{ 0x336A, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN" },
	{ 0x336B, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN" },
	{ 0x336C, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY" },
	{ 0x336D, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE" },
	{ 0x336E, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO" },
	{ 0x336F, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE" },
	{ 0x3370, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR" },
	{ 0x3371, "SQUARE HPA" },
	{ 0x3372, "SQUARE DA" },
	{ 0x3373, "SQUARE AU" },
	{ 0x3374, "SQUARE BAR" },
	{ 0x3375, "SQUARE OV" },
	{ 0x3376, "SQUARE PC" },
	{ 0x337B, "SQUARE ERA NAME HEISEI" },
	{ 0x337C, "SQUARE ERA NAME SYOUWA" },
	{ 0x337D, "SQUARE ERA NAME TAISYOU" },
	{ 0x337E, "SQUARE ERA NAME MEIZI" },
	{ 0x337F, "SQUARE CORPORATION" },
	{ 0x3380, "SQUARE PA AMPS" },
	{ 0x3381, "SQUARE NA" },
	{ 0x3382, "SQUARE MU A" },
	{ 0x3383, "SQUARE MA" },
	{ 0x3384, "SQUARE KA" },
	{ 0x3385, "SQUARE KB" },
	{ 0x3386, "SQUARE MB" },
	{ 0x3387, "SQUARE GB" },
	{ 0x3388, "SQUARE CAL" },
	{ 0x3389, "SQUARE KCAL" },
	{ 0x338A, "SQUARE PF" },
	{ 0x338B, "SQUARE NF" },
	{ 0x338C, "SQUARE MU F" },
	{ 0x338D, "SQUARE MU G" },
	{ 0x338E, "SQUARE MG" },
	{ 0x338F, "SQUARE KG" },
	{ 0x3390, "SQUARE HZ" },
	{ 0x3391, "SQUARE KHZ" },
	{ 0x3392, "SQUARE MHZ" },
	{ 0x3393, "SQUARE GHZ" },
	{ 0x3394, "SQUARE THZ" },
	{ 0x3395, "SQUARE MU L" },
	{ 0x3396, "SQUARE ML" },
	{ 0x3397, "SQUARE DL" },
	{ 0x3398, "SQUARE KL" },
	{ 0x3399, "SQUARE FM" },
	{ 0x339A, "SQUARE NM" },
	{ 0x339B, "SQUARE MU M" },
	{ 0x339C, "SQUARE MM" },
	{ 0x339D, "SQUARE CM" },
	{ 0x339E, "SQUARE KM" },
	{ 0x339F, "SQUARE MM SQUARED" },
	{ 0x33A0, "SQUARE CM SQUARED" },
	{ 0x33A1, "SQUARE M SQUARED" },
	{ 0x33A2, "SQUARE KM SQUARED" },
	{ 0x33A3, "SQUARE MM CUBED" },
	{ 0x33A4, "SQUARE CM CUBED" },
	{ 0x33A5, "SQUARE M CUBED" },
	{ 0x33A6, "SQUARE KM CUBED" },
	{ 0x33A7, "SQUARE M OVER S" },
	{ 0x33A8, "SQUARE M OVER S SQUARED" },
	{ 0x33A9, "SQUARE PA" },
	{ 0x33AA, "SQUARE KPA" },
	{ 0x33AB, "SQUARE MPA" },
	{ 0x33AC, "SQUARE GPA" },
	{ 0x33AD, "SQUARE RAD" },
	{ 0x33AE, "SQUARE RAD OVER S" },
	{ 0x33AF, "SQUARE RAD OVER S SQUARED" },
	{ 0x33B0, "SQUARE PS" },
	{ 0x33B1, "SQUARE NS" },
	{ 0x33B2, "SQUARE MU S" },
	{ 0x33B3, "SQUARE MS" },
	{ 0x33B4, "SQUARE PV" },
	{ 0x33B5, "SQUARE NV" },
	{ 0x33B6, "SQUARE MU V" },
	{ 0x33B7, "SQUARE MV" },
	{ 0x33B8, "SQUARE KV" },
	{ 0x33B9, "SQUARE MV MEGA" },
	{ 0x33BA, "SQUARE PW" },
	{ 0x33BB, "SQUARE NW" },
	{ 0x33BC, "SQUARE MU W" },
	{ 0x33BD, "SQUARE MW" },
	{ 0x33BE, "SQUARE KW" },
	{ 0x33BF, "SQUARE MW MEGA" },
	{ 0x33C0, "SQUARE K OHM" },
	{ 0x33C1, "SQUARE M OHM" },
	{ 0x33C2, "SQUARE AM" },
	{ 0x33C3, "SQUARE BQ" },
	{ 0x33C4, "SQUARE CC" },
	{ 0x33C5, "SQUARE CD" },
	{ 0x33C6, "SQUARE C OVER KG" },
	{ 0x33C7, "SQUARE CO" },
	{ 0x33C8, "SQUARE DB" },
	{ 0x33C9, "SQUARE GY" },
	{ 0x33CA, "SQUARE HA" },
	{ 0x33CB, "SQUARE HP" },
	{ 0x33CC, "SQUARE IN" },
	{ 0x33CD, "SQUARE KK" },
	{ 0x33CE, "SQUARE KM CAPITAL" },
	{ 0x33CF, "SQUARE KT" },
	{ 0x33D0, "SQUARE LM" },
	{ 0x33D1, "SQUARE LN" },
	{ 0x33D2, "SQUARE LOG" },
	{ 0x33D3, "SQUARE LX" },
	{ 0x33D4, "SQUARE MB SMALL" },
	{ 0x33D5, "SQUARE MIL" },
	{ 0x33D6, "SQUARE MOL" },
	{ 0x33D7, "SQUARE PH" },
	{ 0x33D8, "SQUARE PM" },
	{ 0x33D9, "SQUARE PPM" },
	{ 0x33DA, "SQUARE PR" },
	{ 0x33DB, "SQUARE SR" },
	{ 0x33DC, "SQUARE SV" },
	{ 0x33DD, "SQUARE WB" },
	{ 0x33E0, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE" },
	{ 0x33E1, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO" },
	{ 0x33E2, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE" },
	{ 0x33E3, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR" },
	{ 0x33E4, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE" },
	{ 0x33E5, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX" },
	{ 0x33E6, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN" },
	{ 0x33E7, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT" },
	{ 0x33E8, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE" },
	{ 0x33E9, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN" },
	{ 0x33EA, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN" },
	{ 0x33EB, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE" },
	{ 0x33EC, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN" },
	{ 0x33ED, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN" },
	{ 0x33EE, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN" },
	{ 0x33EF, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN" },
	{ 0x33F0, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN" },
	{ 0x33F1, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN" },
	{ 0x33F2, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN" },
	{ 0x33F3, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY" },
	{ 0x33F4, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE" },
	{ 0x33F5, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO" },
	{ 0x33F6, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE" },
	{ 0x33F7, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR" },
	{ 0x33F8, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE" },
	{ 0x33F9, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX" },
	{ 0x33FA, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN" },
	{ 0x33FB, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT" },
	{ 0x33FC, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE" },
	{ 0x33FD, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY" },
	{ 0x33FE, "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE" },
	{ 0x3400, "<CJK Ideograph Extension A, First>" },
	{ 0x4DB5, "<CJK Ideograph Extension A, Last>" },
	{ 0x4E00, "<CJK Ideograph, First>" },
	{ 0x9FA5, "<CJK Ideograph, Last>" },
	{ 0xA000, "YI SYLLABLE IT" },
	{ 0xA001, "YI SYLLABLE IX" },
	{ 0xA002, "YI SYLLABLE I" },
	{ 0xA003, "YI SYLLABLE IP" },
	{ 0xA004, "YI SYLLABLE IET" },
	{ 0xA005, "YI SYLLABLE IEX" },
	{ 0xA006, "YI SYLLABLE IE" },
	{ 0xA007, "YI SYLLABLE IEP" },
	{ 0xA008, "YI SYLLABLE AT" },
	{ 0xA009, "YI SYLLABLE AX" },
	{ 0xA00A, "YI SYLLABLE A" },
	{ 0xA00B, "YI SYLLABLE AP" },
	{ 0xA00C, "YI SYLLABLE UOX" },
	{ 0xA00D, "YI SYLLABLE UO" },
	{ 0xA00E, "YI SYLLABLE UOP" },
	{ 0xA00F, "YI SYLLABLE OT" },
	{ 0xA010, "YI SYLLABLE OX" },
	{ 0xA011, "YI SYLLABLE O" },
	{ 0xA012, "YI SYLLABLE OP" },
	{ 0xA013, "YI SYLLABLE EX" },
	{ 0xA014, "YI SYLLABLE E" },
	{ 0xA015, "YI SYLLABLE WU" },
	{ 0xA016, "YI SYLLABLE BIT" },
	{ 0xA017, "YI SYLLABLE BIX" },
	{ 0xA018, "YI SYLLABLE BI" },
	{ 0xA019, "YI SYLLABLE BIP" },
	{ 0xA01A, "YI SYLLABLE BIET" },
	{ 0xA01B, "YI SYLLABLE BIEX" },
	{ 0xA01C, "YI SYLLABLE BIE" },
	{ 0xA01D, "YI SYLLABLE BIEP" },
	{ 0xA01E, "YI SYLLABLE BAT" },
	{ 0xA01F, "YI SYLLABLE BAX" },
	{ 0xA020, "YI SYLLABLE BA" },
	{ 0xA021, "YI SYLLABLE BAP" },
	{ 0xA022, "YI SYLLABLE BUOX" },
	{ 0xA023, "YI SYLLABLE BUO" },
	{ 0xA024, "YI SYLLABLE BUOP" },
	{ 0xA025, "YI SYLLABLE BOT" },
	{ 0xA026, "YI SYLLABLE BOX" },
	{ 0xA027, "YI SYLLABLE BO" },
	{ 0xA028, "YI SYLLABLE BOP" },
	{ 0xA029, "YI SYLLABLE BEX" },
	{ 0xA02A, "YI SYLLABLE BE" },
	{ 0xA02B, "YI SYLLABLE BEP" },
	{ 0xA02C, "YI SYLLABLE BUT" },
	{ 0xA02D, "YI SYLLABLE BUX" },
	{ 0xA02E, "YI SYLLABLE BU" },
	{ 0xA02F, "YI SYLLABLE BUP" },
	{ 0xA030, "YI SYLLABLE BURX" },
	{ 0xA031, "YI SYLLABLE BUR" },
	{ 0xA032, "YI SYLLABLE BYT" },
	{ 0xA033, "YI SYLLABLE BYX" },
	{ 0xA034, "YI SYLLABLE BY" },
	{ 0xA035, "YI SYLLABLE BYP" },
	{ 0xA036, "YI SYLLABLE BYRX" },
	{ 0xA037, "YI SYLLABLE BYR" },
	{ 0xA038, "YI SYLLABLE PIT" },
	{ 0xA039, "YI SYLLABLE PIX" },
	{ 0xA03A, "YI SYLLABLE PI" },
	{ 0xA03B, "YI SYLLABLE PIP" },
	{ 0xA03C, "YI SYLLABLE PIEX" },
	{ 0xA03D, "YI SYLLABLE PIE" },
	{ 0xA03E, "YI SYLLABLE PIEP" },
	{ 0xA03F, "YI SYLLABLE PAT" },
	{ 0xA040, "YI SYLLABLE PAX" },
	{ 0xA041, "YI SYLLABLE PA" },
	{ 0xA042, "YI SYLLABLE PAP" },
	{ 0xA043, "YI SYLLABLE PUOX" },
	{ 0xA044, "YI SYLLABLE PUO" },
	{ 0xA045, "YI SYLLABLE PUOP" },
	{ 0xA046, "YI SYLLABLE POT" },
	{ 0xA047, "YI SYLLABLE POX" },
	{ 0xA048, "YI SYLLABLE PO" },
	{ 0xA049, "YI SYLLABLE POP" },
	{ 0xA04A, "YI SYLLABLE PUT" },
	{ 0xA04B, "YI SYLLABLE PUX" },
	{ 0xA04C, "YI SYLLABLE PU" },
	{ 0xA04D, "YI SYLLABLE PUP" },
	{ 0xA04E, "YI SYLLABLE PURX" },
	{ 0xA04F, "YI SYLLABLE PUR" },
	{ 0xA050, "YI SYLLABLE PYT" },
	{ 0xA051, "YI SYLLABLE PYX" },
	{ 0xA052, "YI SYLLABLE PY" },
	{ 0xA053, "YI SYLLABLE PYP" },
	{ 0xA054, "YI SYLLABLE PYRX" },
	{ 0xA055, "YI SYLLABLE PYR" },
	{ 0xA056, "YI SYLLABLE BBIT" },
	{ 0xA057, "YI SYLLABLE BBIX" },
	{ 0xA058, "YI SYLLABLE BBI" },
	{ 0xA059, "YI SYLLABLE BBIP" },
	{ 0xA05A, "YI SYLLABLE BBIET" },
	{ 0xA05B, "YI SYLLABLE BBIEX" },
	{ 0xA05C, "YI SYLLABLE BBIE" },
	{ 0xA05D, "YI SYLLABLE BBIEP" },
	{ 0xA05E, "YI SYLLABLE BBAT" },
	{ 0xA05F, "YI SYLLABLE BBAX" },
	{ 0xA060, "YI SYLLABLE BBA" },
	{ 0xA061, "YI SYLLABLE BBAP" },
	{ 0xA062, "YI SYLLABLE BBUOX" },
	{ 0xA063, "YI SYLLABLE BBUO" },
	{ 0xA064, "YI SYLLABLE BBUOP" },
	{ 0xA065, "YI SYLLABLE BBOT" },
	{ 0xA066, "YI SYLLABLE BBOX" },
	{ 0xA067, "YI SYLLABLE BBO" },
	{ 0xA068, "YI SYLLABLE BBOP" },
	{ 0xA069, "YI SYLLABLE BBEX" },
	{ 0xA06A, "YI SYLLABLE BBE" },
	{ 0xA06B, "YI SYLLABLE BBEP" },
	{ 0xA06C, "YI SYLLABLE BBUT" },
	{ 0xA06D, "YI SYLLABLE BBUX" },
	{ 0xA06E, "YI SYLLABLE BBU" },
	{ 0xA06F, "YI SYLLABLE BBUP" },
	{ 0xA070, "YI SYLLABLE BBURX" },
	{ 0xA071, "YI SYLLABLE BBUR" },
	{ 0xA072, "YI SYLLABLE BBYT" },
	{ 0xA073, "YI SYLLABLE BBYX" },
	{ 0xA074, "YI SYLLABLE BBY" },
	{ 0xA075, "YI SYLLABLE BBYP" },
	{ 0xA076, "YI SYLLABLE NBIT" },
	{ 0xA077, "YI SYLLABLE NBIX" },
	{ 0xA078, "YI SYLLABLE NBI" },
	{ 0xA079, "YI SYLLABLE NBIP" },
	{ 0xA07A, "YI SYLLABLE NBIEX" },
	{ 0xA07B, "YI SYLLABLE NBIE" },
	{ 0xA07C, "YI SYLLABLE NBIEP" },
	{ 0xA07D, "YI SYLLABLE NBAT" },
	{ 0xA07E, "YI SYLLABLE NBAX" },
	{ 0xA07F, "YI SYLLABLE NBA" },
	{ 0xA080, "YI SYLLABLE NBAP" },
	{ 0xA081, "YI SYLLABLE NBOT" },
	{ 0xA082, "YI SYLLABLE NBOX" },
	{ 0xA083, "YI SYLLABLE NBO" },
	{ 0xA084, "YI SYLLABLE NBOP" },
	{ 0xA085, "YI SYLLABLE NBUT" },
	{ 0xA086, "YI SYLLABLE NBUX" },
	{ 0xA087, "YI SYLLABLE NBU" },
	{ 0xA088, "YI SYLLABLE NBUP" },
	{ 0xA089, "YI SYLLABLE NBURX" },
	{ 0xA08A, "YI SYLLABLE NBUR" },
	{ 0xA08B, "YI SYLLABLE NBYT" },
	{ 0xA08C, "YI SYLLABLE NBYX" },
	{ 0xA08D, "YI SYLLABLE NBY" },
	{ 0xA08E, "YI SYLLABLE NBYP" },
	{ 0xA08F, "YI SYLLABLE NBYRX" },
	{ 0xA090, "YI SYLLABLE NBYR" },
	{ 0xA091, "YI SYLLABLE HMIT" },
	{ 0xA092, "YI SYLLABLE HMIX" },
	{ 0xA093, "YI SYLLABLE HMI" },
	{ 0xA094, "YI SYLLABLE HMIP" },
	{ 0xA095, "YI SYLLABLE HMIEX" },
	{ 0xA096, "YI SYLLABLE HMIE" },
	{ 0xA097, "YI SYLLABLE HMIEP" },
	{ 0xA098, "YI SYLLABLE HMAT" },
	{ 0xA099, "YI SYLLABLE HMAX" },
	{ 0xA09A, "YI SYLLABLE HMA" },
	{ 0xA09B, "YI SYLLABLE HMAP" },
	{ 0xA09C, "YI SYLLABLE HMUOX" },
	{ 0xA09D, "YI SYLLABLE HMUO" },
	{ 0xA09E, "YI SYLLABLE HMUOP" },
	{ 0xA09F, "YI SYLLABLE HMOT" },
	{ 0xA0A0, "YI SYLLABLE HMOX" },
	{ 0xA0A1, "YI SYLLABLE HMO" },
	{ 0xA0A2, "YI SYLLABLE HMOP" },
	{ 0xA0A3, "YI SYLLABLE HMUT" },
	{ 0xA0A4, "YI SYLLABLE HMUX" },
	{ 0xA0A5, "YI SYLLABLE HMU" },
	{ 0xA0A6, "YI SYLLABLE HMUP" },
	{ 0xA0A7, "YI SYLLABLE HMURX" },
	{ 0xA0A8, "YI SYLLABLE HMUR" },
	{ 0xA0A9, "YI SYLLABLE HMYX" },
	{ 0xA0AA, "YI SYLLABLE HMY" },
	{ 0xA0AB, "YI SYLLABLE HMYP" },
	{ 0xA0AC, "YI SYLLABLE HMYRX" },
	{ 0xA0AD, "YI SYLLABLE HMYR" },
	{ 0xA0AE, "YI SYLLABLE MIT" },
	{ 0xA0AF, "YI SYLLABLE MIX" },
	{ 0xA0B0, "YI SYLLABLE MI" },
	{ 0xA0B1, "YI SYLLABLE MIP" },
	{ 0xA0B2, "YI SYLLABLE MIEX" },
	{ 0xA0B3, "YI SYLLABLE MIE" },
	{ 0xA0B4, "YI SYLLABLE MIEP" },
	{ 0xA0B5, "YI SYLLABLE MAT" },
	{ 0xA0B6, "YI SYLLABLE MAX" },
	{ 0xA0B7, "YI SYLLABLE MA" },
	{ 0xA0B8, "YI SYLLABLE MAP" },
	{ 0xA0B9, "YI SYLLABLE MUOT" },
	{ 0xA0BA, "YI SYLLABLE MUOX" },
	{ 0xA0BB, "YI SYLLABLE MUO" },
	{ 0xA0BC, "YI SYLLABLE MUOP" },
	{ 0xA0BD, "YI SYLLABLE MOT" },
	{ 0xA0BE, "YI SYLLABLE MOX" },
	{ 0xA0BF, "YI SYLLABLE MO" },
	{ 0xA0C0, "YI SYLLABLE MOP" },
	{ 0xA0C1, "YI SYLLABLE MEX" },
	{ 0xA0C2, "YI SYLLABLE ME" },
	{ 0xA0C3, "YI SYLLABLE MUT" },
	{ 0xA0C4, "YI SYLLABLE MUX" },
	{ 0xA0C5, "YI SYLLABLE MU" },
	{ 0xA0C6, "YI SYLLABLE MUP" },
	{ 0xA0C7, "YI SYLLABLE MURX" },
	{ 0xA0C8, "YI SYLLABLE MUR" },
	{ 0xA0C9, "YI SYLLABLE MYT" },
	{ 0xA0CA, "YI SYLLABLE MYX" },
	{ 0xA0CB, "YI SYLLABLE MY" },
	{ 0xA0CC, "YI SYLLABLE MYP" },
	{ 0xA0CD, "YI SYLLABLE FIT" },
	{ 0xA0CE, "YI SYLLABLE FIX" },
	{ 0xA0CF, "YI SYLLABLE FI" },
	{ 0xA0D0, "YI SYLLABLE FIP" },
	{ 0xA0D1, "YI SYLLABLE FAT" },
	{ 0xA0D2, "YI SYLLABLE FAX" },
	{ 0xA0D3, "YI SYLLABLE FA" },
	{ 0xA0D4, "YI SYLLABLE FAP" },
	{ 0xA0D5, "YI SYLLABLE FOX" },
	{ 0xA0D6, "YI SYLLABLE FO" },
	{ 0xA0D7, "YI SYLLABLE FOP" },
	{ 0xA0D8, "YI SYLLABLE FUT" },
	{ 0xA0D9, "YI SYLLABLE FUX" },
	{ 0xA0DA, "YI SYLLABLE FU" },
	{ 0xA0DB, "YI SYLLABLE FUP" },
	{ 0xA0DC, "YI SYLLABLE FURX" },
	{ 0xA0DD, "YI SYLLABLE FUR" },
	{ 0xA0DE, "YI SYLLABLE FYT" },
	{ 0xA0DF, "YI SYLLABLE FYX" },
	{ 0xA0E0, "YI SYLLABLE FY" },
	{ 0xA0E1, "YI SYLLABLE FYP" },
	{ 0xA0E2, "YI SYLLABLE VIT" },
	{ 0xA0E3, "YI SYLLABLE VIX" },
	{ 0xA0E4, "YI SYLLABLE VI" },
	{ 0xA0E5, "YI SYLLABLE VIP" },
	{ 0xA0E6, "YI SYLLABLE VIET" },
	{ 0xA0E7, "YI SYLLABLE VIEX" },
	{ 0xA0E8, "YI SYLLABLE VIE" },
	{ 0xA0E9, "YI SYLLABLE VIEP" },
	{ 0xA0EA, "YI SYLLABLE VAT" },
	{ 0xA0EB, "YI SYLLABLE VAX" },
	{ 0xA0EC, "YI SYLLABLE VA" },
	{ 0xA0ED, "YI SYLLABLE VAP" },
	{ 0xA0EE, "YI SYLLABLE VOT" },
	{ 0xA0EF, "YI SYLLABLE VOX" },
	{ 0xA0F0, "YI SYLLABLE VO" },
	{ 0xA0F1, "YI SYLLABLE VOP" },
	{ 0xA0F2, "YI SYLLABLE VEX" },
	{ 0xA0F3, "YI SYLLABLE VEP" },
	{ 0xA0F4, "YI SYLLABLE VUT" },
	{ 0xA0F5, "YI SYLLABLE VUX" },
	{ 0xA0F6, "YI SYLLABLE VU" },
	{ 0xA0F7, "YI SYLLABLE VUP" },
	{ 0xA0F8, "YI SYLLABLE VURX" },
	{ 0xA0F9, "YI SYLLABLE VUR" },
	{ 0xA0FA, "YI SYLLABLE VYT" },
	{ 0xA0FB, "YI SYLLABLE VYX" },
	{ 0xA0FC, "YI SYLLABLE VY" },
	{ 0xA0FD, "YI SYLLABLE VYP" },
	{ 0xA0FE, "YI SYLLABLE VYRX" },
	{ 0xA0FF, "YI SYLLABLE VYR" },
	{ 0xA100, "YI SYLLABLE DIT" },
	{ 0xA101, "YI SYLLABLE DIX" },
	{ 0xA102, "YI SYLLABLE DI" },
	{ 0xA103, "YI SYLLABLE DIP" },
	{ 0xA104, "YI SYLLABLE DIEX" },
	{ 0xA105, "YI SYLLABLE DIE" },
	{ 0xA106, "YI SYLLABLE DIEP" },
	{ 0xA107, "YI SYLLABLE DAT" },
	{ 0xA108, "YI SYLLABLE DAX" },
	{ 0xA109, "YI SYLLABLE DA" },
	{ 0xA10A, "YI SYLLABLE DAP" },
	{ 0xA10B, "YI SYLLABLE DUOX" },
	{ 0xA10C, "YI SYLLABLE DUO" },
	{ 0xA10D, "YI SYLLABLE DOT" },
	{ 0xA10E, "YI SYLLABLE DOX" },
	{ 0xA10F, "YI SYLLABLE DO" },
	{ 0xA110, "YI SYLLABLE DOP" },
	{ 0xA111, "YI SYLLABLE DEX" },
	{ 0xA112, "YI SYLLABLE DE" },
	{ 0xA113, "YI SYLLABLE DEP" },
	{ 0xA114, "YI SYLLABLE DUT" },
	{ 0xA115, "YI SYLLABLE DUX" },
	{ 0xA116, "YI SYLLABLE DU" },
	{ 0xA117, "YI SYLLABLE DUP" },
	{ 0xA118, "YI SYLLABLE DURX" },
	{ 0xA119, "YI SYLLABLE DUR" },
	{ 0xA11A, "YI SYLLABLE TIT" },
	{ 0xA11B, "YI SYLLABLE TIX" },
	{ 0xA11C, "YI SYLLABLE TI" },
	{ 0xA11D, "YI SYLLABLE TIP" },
	{ 0xA11E, "YI SYLLABLE TIEX" },
	{ 0xA11F, "YI SYLLABLE TIE" },
	{ 0xA120, "YI SYLLABLE TIEP" },
	{ 0xA121, "YI SYLLABLE TAT" },
	{ 0xA122, "YI SYLLABLE TAX" },
	{ 0xA123, "YI SYLLABLE TA" },
	{ 0xA124, "YI SYLLABLE TAP" },
	{ 0xA125, "YI SYLLABLE TUOT" },
	{ 0xA126, "YI SYLLABLE TUOX" },
	{ 0xA127, "YI SYLLABLE TUO" },
	{ 0xA128, "YI SYLLABLE TUOP" },
	{ 0xA129, "YI SYLLABLE TOT" },
	{ 0xA12A, "YI SYLLABLE TOX" },
	{ 0xA12B, "YI SYLLABLE TO" },
	{ 0xA12C, "YI SYLLABLE TOP" },
	{ 0xA12D, "YI SYLLABLE TEX" },
	{ 0xA12E, "YI SYLLABLE TE" },
	{ 0xA12F, "YI SYLLABLE TEP" },
	{ 0xA130, "YI SYLLABLE TUT" },
	{ 0xA131, "YI SYLLABLE TUX" },
	{ 0xA132, "YI SYLLABLE TU" },
	{ 0xA133, "YI SYLLABLE TUP" },
	{ 0xA134, "YI SYLLABLE TURX" },
	{ 0xA135, "YI SYLLABLE TUR" },
	{ 0xA136, "YI SYLLABLE DDIT" },
	{ 0xA137, "YI SYLLABLE DDIX" },
	{ 0xA138, "YI SYLLABLE DDI" },
	{ 0xA139, "YI SYLLABLE DDIP" },
	{ 0xA13A, "YI SYLLABLE DDIEX" },
	{ 0xA13B, "YI SYLLABLE DDIE" },
	{ 0xA13C, "YI SYLLABLE DDIEP" },
	{ 0xA13D, "YI SYLLABLE DDAT" },
	{ 0xA13E, "YI SYLLABLE DDAX" },
	{ 0xA13F, "YI SYLLABLE DDA" },
	{ 0xA140, "YI SYLLABLE DDAP" },
	{ 0xA141, "YI SYLLABLE DDUOX" },
	{ 0xA142, "YI SYLLABLE DDUO" },
	{ 0xA143, "YI SYLLABLE DDUOP" },
	{ 0xA144, "YI SYLLABLE DDOT" },
	{ 0xA145, "YI SYLLABLE DDOX" },
	{ 0xA146, "YI SYLLABLE DDO" },
	{ 0xA147, "YI SYLLABLE DDOP" },
	{ 0xA148, "YI SYLLABLE DDEX" },
	{ 0xA149, "YI SYLLABLE DDE" },
	{ 0xA14A, "YI SYLLABLE DDEP" },
	{ 0xA14B, "YI SYLLABLE DDUT" },
	{ 0xA14C, "YI SYLLABLE DDUX" },
	{ 0xA14D, "YI SYLLABLE DDU" },
	{ 0xA14E, "YI SYLLABLE DDUP" },
	{ 0xA14F, "YI SYLLABLE DDURX" },
	{ 0xA150, "YI SYLLABLE DDUR" },
	{ 0xA151, "YI SYLLABLE NDIT" },
	{ 0xA152, "YI SYLLABLE NDIX" },
	{ 0xA153, "YI SYLLABLE NDI" },
	{ 0xA154, "YI SYLLABLE NDIP" },
	{ 0xA155, "YI SYLLABLE NDIEX" },
	{ 0xA156, "YI SYLLABLE NDIE" },
	{ 0xA157, "YI SYLLABLE NDAT" },
	{ 0xA158, "YI SYLLABLE NDAX" },
	{ 0xA159, "YI SYLLABLE NDA" },
	{ 0xA15A, "YI SYLLABLE NDAP" },
	{ 0xA15B, "YI SYLLABLE NDOT" },
	{ 0xA15C, "YI SYLLABLE NDOX" },
	{ 0xA15D, "YI SYLLABLE NDO" },
	{ 0xA15E, "YI SYLLABLE NDOP" },
	{ 0xA15F, "YI SYLLABLE NDEX" },
	{ 0xA160, "YI SYLLABLE NDE" },
	{ 0xA161, "YI SYLLABLE NDEP" },
	{ 0xA162, "YI SYLLABLE NDUT" },
	{ 0xA163, "YI SYLLABLE NDUX" },
	{ 0xA164, "YI SYLLABLE NDU" },
	{ 0xA165, "YI SYLLABLE NDUP" },
	{ 0xA166, "YI SYLLABLE NDURX" },
	{ 0xA167, "YI SYLLABLE NDUR" },
	{ 0xA168, "YI SYLLABLE HNIT" },
	{ 0xA169, "YI SYLLABLE HNIX" },
	{ 0xA16A, "YI SYLLABLE HNI" },
	{ 0xA16B, "YI SYLLABLE HNIP" },
	{ 0xA16C, "YI SYLLABLE HNIET" },
	{ 0xA16D, "YI SYLLABLE HNIEX" },
	{ 0xA16E, "YI SYLLABLE HNIE" },
	{ 0xA16F, "YI SYLLABLE HNIEP" },
	{ 0xA170, "YI SYLLABLE HNAT" },
	{ 0xA171, "YI SYLLABLE HNAX" },
	{ 0xA172, "YI SYLLABLE HNA" },
	{ 0xA173, "YI SYLLABLE HNAP" },
	{ 0xA174, "YI SYLLABLE HNUOX" },
	{ 0xA175, "YI SYLLABLE HNUO" },
	{ 0xA176, "YI SYLLABLE HNOT" },
	{ 0xA177, "YI SYLLABLE HNOX" },
	{ 0xA178, "YI SYLLABLE HNOP" },
	{ 0xA179, "YI SYLLABLE HNEX" },
	{ 0xA17A, "YI SYLLABLE HNE" },
	{ 0xA17B, "YI SYLLABLE HNEP" },
	{ 0xA17C, "YI SYLLABLE HNUT" },
	{ 0xA17D, "YI SYLLABLE NIT" },
	{ 0xA17E, "YI SYLLABLE NIX" },
	{ 0xA17F, "YI SYLLABLE NI" },
	{ 0xA180, "YI SYLLABLE NIP" },
	{ 0xA181, "YI SYLLABLE NIEX" },
	{ 0xA182, "YI SYLLABLE NIE" },
	{ 0xA183, "YI SYLLABLE NIEP" },
	{ 0xA184, "YI SYLLABLE NAX" },
	{ 0xA185, "YI SYLLABLE NA" },
	{ 0xA186, "YI SYLLABLE NAP" },
	{ 0xA187, "YI SYLLABLE NUOX" },
	{ 0xA188, "YI SYLLABLE NUO" },
	{ 0xA189, "YI SYLLABLE NUOP" },
	{ 0xA18A, "YI SYLLABLE NOT" },
	{ 0xA18B, "YI SYLLABLE NOX" },
	{ 0xA18C, "YI SYLLABLE NO" },
	{ 0xA18D, "YI SYLLABLE NOP" },
	{ 0xA18E, "YI SYLLABLE NEX" },
	{ 0xA18F, "YI SYLLABLE NE" },
	{ 0xA190, "YI SYLLABLE NEP" },
	{ 0xA191, "YI SYLLABLE NUT" },
	{ 0xA192, "YI SYLLABLE NUX" },
	{ 0xA193, "YI SYLLABLE NU" },
	{ 0xA194, "YI SYLLABLE NUP" },
	{ 0xA195, "YI SYLLABLE NURX" },
	{ 0xA196, "YI SYLLABLE NUR" },
	{ 0xA197, "YI SYLLABLE HLIT" },
	{ 0xA198, "YI SYLLABLE HLIX" },
	{ 0xA199, "YI SYLLABLE HLI" },
	{ 0xA19A, "YI SYLLABLE HLIP" },
	{ 0xA19B, "YI SYLLABLE HLIEX" },
	{ 0xA19C, "YI SYLLABLE HLIE" },
	{ 0xA19D, "YI SYLLABLE HLIEP" },
	{ 0xA19E, "YI SYLLABLE HLAT" },
	{ 0xA19F, "YI SYLLABLE HLAX" },
	{ 0xA1A0, "YI SYLLABLE HLA" },
	{ 0xA1A1, "YI SYLLABLE HLAP" },
	{ 0xA1A2, "YI SYLLABLE HLUOX" },
	{ 0xA1A3, "YI SYLLABLE HLUO" },
	{ 0xA1A4, "YI SYLLABLE HLUOP" },
	{ 0xA1A5, "YI SYLLABLE HLOX" },
	{ 0xA1A6, "YI SYLLABLE HLO" },
	{ 0xA1A7, "YI SYLLABLE HLOP" },
	{ 0xA1A8, "YI SYLLABLE HLEX" },
	{ 0xA1A9, "YI SYLLABLE HLE" },
	{ 0xA1AA, "YI SYLLABLE HLEP" },
	{ 0xA1AB, "YI SYLLABLE HLUT" },
	{ 0xA1AC, "YI SYLLABLE HLUX" },
	{ 0xA1AD, "YI SYLLABLE HLU" },
	{ 0xA1AE, "YI SYLLABLE HLUP" },
	{ 0xA1AF, "YI SYLLABLE HLURX" },
	{ 0xA1B0, "YI SYLLABLE HLUR" },
	{ 0xA1B1, "YI SYLLABLE HLYT" },
	{ 0xA1B2, "YI SYLLABLE HLYX" },
	{ 0xA1B3, "YI SYLLABLE HLY" },
	{ 0xA1B4, "YI SYLLABLE HLYP" },
	{ 0xA1B5, "YI SYLLABLE HLYRX" },
	{ 0xA1B6, "YI SYLLABLE HLYR" },
	{ 0xA1B7, "YI SYLLABLE LIT" },
	{ 0xA1B8, "YI SYLLABLE LIX" },
	{ 0xA1B9, "YI SYLLABLE LI" },
	{ 0xA1BA, "YI SYLLABLE LIP" },
	{ 0xA1BB, "YI SYLLABLE LIET" },
	{ 0xA1BC, "YI SYLLABLE LIEX" },
	{ 0xA1BD, "YI SYLLABLE LIE" },
	{ 0xA1BE, "YI SYLLABLE LIEP" },
	{ 0xA1BF, "YI SYLLABLE LAT" },
	{ 0xA1C0, "YI SYLLABLE LAX" },
	{ 0xA1C1, "YI SYLLABLE LA" },
	{ 0xA1C2, "YI SYLLABLE LAP" },
	{ 0xA1C3, "YI SYLLABLE LUOT" },
	{ 0xA1C4, "YI SYLLABLE LUOX" },
	{ 0xA1C5, "YI SYLLABLE LUO" },
	{ 0xA1C6, "YI SYLLABLE LUOP" },
	{ 0xA1C7, "YI SYLLABLE LOT" },
	{ 0xA1C8, "YI SYLLABLE LOX" },
	{ 0xA1C9, "YI SYLLABLE LO" },
	{ 0xA1CA, "YI SYLLABLE LOP" },
	{ 0xA1CB, "YI SYLLABLE LEX" },
	{ 0xA1CC, "YI SYLLABLE LE" },
	{ 0xA1CD, "YI SYLLABLE LEP" },
	{ 0xA1CE, "YI SYLLABLE LUT" },
	{ 0xA1CF, "YI SYLLABLE LUX" },
	{ 0xA1D0, "YI SYLLABLE LU" },
	{ 0xA1D1, "YI SYLLABLE LUP" },
	{ 0xA1D2, "YI SYLLABLE LURX" },
	{ 0xA1D3, "YI SYLLABLE LUR" },
	{ 0xA1D4, "YI SYLLABLE LYT" },
	{ 0xA1D5, "YI SYLLABLE LYX" },
	{ 0xA1D6, "YI SYLLABLE LY" },
	{ 0xA1D7, "YI SYLLABLE LYP" },
	{ 0xA1D8, "YI SYLLABLE LYRX" },
	{ 0xA1D9, "YI SYLLABLE LYR" },
	{ 0xA1DA, "YI SYLLABLE GIT" },
	{ 0xA1DB, "YI SYLLABLE GIX" },
	{ 0xA1DC, "YI SYLLABLE GI" },
	{ 0xA1DD, "YI SYLLABLE GIP" },
	{ 0xA1DE, "YI SYLLABLE GIET" },
	{ 0xA1DF, "YI SYLLABLE GIEX" },
	{ 0xA1E0, "YI SYLLABLE GIE" },
	{ 0xA1E1, "YI SYLLABLE GIEP" },
	{ 0xA1E2, "YI SYLLABLE GAT" },
	{ 0xA1E3, "YI SYLLABLE GAX" },
	{ 0xA1E4, "YI SYLLABLE GA" },
	{ 0xA1E5, "YI SYLLABLE GAP" },
	{ 0xA1E6, "YI SYLLABLE GUOT" },
	{ 0xA1E7, "YI SYLLABLE GUOX" },
	{ 0xA1E8, "YI SYLLABLE GUO" },
	{ 0xA1E9, "YI SYLLABLE GUOP" },
	{ 0xA1EA, "YI SYLLABLE GOT" },
	{ 0xA1EB, "YI SYLLABLE GOX" },
	{ 0xA1EC, "YI SYLLABLE GO" },
	{ 0xA1ED, "YI SYLLABLE GOP" },
	{ 0xA1EE, "YI SYLLABLE GET" },
	{ 0xA1EF, "YI SYLLABLE GEX" },
	{ 0xA1F0, "YI SYLLABLE GE" },
	{ 0xA1F1, "YI SYLLABLE GEP" },
	{ 0xA1F2, "YI SYLLABLE GUT" },
	{ 0xA1F3, "YI SYLLABLE GUX" },
	{ 0xA1F4, "YI SYLLABLE GU" },
	{ 0xA1F5, "YI SYLLABLE GUP" },
	{ 0xA1F6, "YI SYLLABLE GURX" },
	{ 0xA1F7, "YI SYLLABLE GUR" },
	{ 0xA1F8, "YI SYLLABLE KIT" },
	{ 0xA1F9, "YI SYLLABLE KIX" },
	{ 0xA1FA, "YI SYLLABLE KI" },
	{ 0xA1FB, "YI SYLLABLE KIP" },
	{ 0xA1FC, "YI SYLLABLE KIEX" },
	{ 0xA1FD, "YI SYLLABLE KIE" },
	{ 0xA1FE, "YI SYLLABLE KIEP" },
	{ 0xA1FF, "YI SYLLABLE KAT" },
	{ 0xA200, "YI SYLLABLE KAX" },
	{ 0xA201, "YI SYLLABLE KA" },
	{ 0xA202, "YI SYLLABLE KAP" },
	{ 0xA203, "YI SYLLABLE KUOX" },
	{ 0xA204, "YI SYLLABLE KUO" },
	{ 0xA205, "YI SYLLABLE KUOP" },
	{ 0xA206, "YI SYLLABLE KOT" },
	{ 0xA207, "YI SYLLABLE KOX" },
	{ 0xA208, "YI SYLLABLE KO" },
	{ 0xA209, "YI SYLLABLE KOP" },
	{ 0xA20A, "YI SYLLABLE KET" },
	{ 0xA20B, "YI SYLLABLE KEX" },
	{ 0xA20C, "YI SYLLABLE KE" },
	{ 0xA20D, "YI SYLLABLE KEP" },
	{ 0xA20E, "YI SYLLABLE KUT" },
	{ 0xA20F, "YI SYLLABLE KUX" },
	{ 0xA210, "YI SYLLABLE KU" },
	{ 0xA211, "YI SYLLABLE KUP" },
	{ 0xA212, "YI SYLLABLE KURX" },
	{ 0xA213, "YI SYLLABLE KUR" },
	{ 0xA214, "YI SYLLABLE GGIT" },
	{ 0xA215, "YI SYLLABLE GGIX" },
	{ 0xA216, "YI SYLLABLE GGI" },
	{ 0xA217, "YI SYLLABLE GGIEX" },
	{ 0xA218, "YI SYLLABLE GGIE" },
	{ 0xA219, "YI SYLLABLE GGIEP" },
	{ 0xA21A, "YI SYLLABLE GGAT" },
	{ 0xA21B, "YI SYLLABLE GGAX" },
	{ 0xA21C, "YI SYLLABLE GGA" },
	{ 0xA21D, "YI SYLLABLE GGAP" },
	{ 0xA21E, "YI SYLLABLE GGUOT" },
	{ 0xA21F, "YI SYLLABLE GGUOX" },
	{ 0xA220, "YI SYLLABLE GGUO" },
	{ 0xA221, "YI SYLLABLE GGUOP" },
	{ 0xA222, "YI SYLLABLE GGOT" },
	{ 0xA223, "YI SYLLABLE GGOX" },
	{ 0xA224, "YI SYLLABLE GGO" },
	{ 0xA225, "YI SYLLABLE GGOP" },
	{ 0xA226, "YI SYLLABLE GGET" },
	{ 0xA227, "YI SYLLABLE GGEX" },
	{ 0xA228, "YI SYLLABLE GGE" },
	{ 0xA229, "YI SYLLABLE GGEP" },
	{ 0xA22A, "YI SYLLABLE GGUT" },
	{ 0xA22B, "YI SYLLABLE GGUX" },
	{ 0xA22C, "YI SYLLABLE GGU" },
	{ 0xA22D, "YI SYLLABLE GGUP" },
	{ 0xA22E, "YI SYLLABLE GGURX" },
	{ 0xA22F, "YI SYLLABLE GGUR" },
	{ 0xA230, "YI SYLLABLE MGIEX" },
	{ 0xA231, "YI SYLLABLE MGIE" },
	{ 0xA232, "YI SYLLABLE MGAT" },
	{ 0xA233, "YI SYLLABLE MGAX" },
	{ 0xA234, "YI SYLLABLE MGA" },
	{ 0xA235, "YI SYLLABLE MGAP" },
	{ 0xA236, "YI SYLLABLE MGUOX" },
	{ 0xA237, "YI SYLLABLE MGUO" },
	{ 0xA238, "YI SYLLABLE MGUOP" },
	{ 0xA239, "YI SYLLABLE MGOT" },
	{ 0xA23A, "YI SYLLABLE MGOX" },
	{ 0xA23B, "YI SYLLABLE MGO" },
	{ 0xA23C, "YI SYLLABLE MGOP" },
	{ 0xA23D, "YI SYLLABLE MGEX" },
	{ 0xA23E, "YI SYLLABLE MGE" },
	{ 0xA23F, "YI SYLLABLE MGEP" },
	{ 0xA240, "YI SYLLABLE MGUT" },
	{ 0xA241, "YI SYLLABLE MGUX" },
	{ 0xA242, "YI SYLLABLE MGU" },
	{ 0xA243, "YI SYLLABLE MGUP" },
	{ 0xA244, "YI SYLLABLE MGURX" },
	{ 0xA245, "YI SYLLABLE MGUR" },
	{ 0xA246, "YI SYLLABLE HXIT" },
	{ 0xA247, "YI SYLLABLE HXIX" },
	{ 0xA248, "YI SYLLABLE HXI" },
	{ 0xA249, "YI SYLLABLE HXIP" },
	{ 0xA24A, "YI SYLLABLE HXIET" },
	{ 0xA24B, "YI SYLLABLE HXIEX" },
	{ 0xA24C, "YI SYLLABLE HXIE" },
	{ 0xA24D, "YI SYLLABLE HXIEP" },
	{ 0xA24E, "YI SYLLABLE HXAT" },
	{ 0xA24F, "YI SYLLABLE HXAX" },
	{ 0xA250, "YI SYLLABLE HXA" },
	{ 0xA251, "YI SYLLABLE HXAP" },
	{ 0xA252, "YI SYLLABLE HXUOT" },
	{ 0xA253, "YI SYLLABLE HXUOX" },
	{ 0xA254, "YI SYLLABLE HXUO" },
	{ 0xA255, "YI SYLLABLE HXUOP" },
	{ 0xA256, "YI SYLLABLE HXOT" },
	{ 0xA257, "YI SYLLABLE HXOX" },
	{ 0xA258, "YI SYLLABLE HXO" },
	{ 0xA259, "YI SYLLABLE HXOP" },
	{ 0xA25A, "YI SYLLABLE HXEX" },
	{ 0xA25B, "YI SYLLABLE HXE" },
	{ 0xA25C, "YI SYLLABLE HXEP" },
	{ 0xA25D, "YI SYLLABLE NGIEX" },
	{ 0xA25E, "YI SYLLABLE NGIE" },
	{ 0xA25F, "YI SYLLABLE NGIEP" },
	{ 0xA260, "YI SYLLABLE NGAT" },
	{ 0xA261, "YI SYLLABLE NGAX" },
	{ 0xA262, "YI SYLLABLE NGA" },
	{ 0xA263, "YI SYLLABLE NGAP" },
	{ 0xA264, "YI SYLLABLE NGUOT" },
	{ 0xA265, "YI SYLLABLE NGUOX" },
	{ 0xA266, "YI SYLLABLE NGUO" },
	{ 0xA267, "YI SYLLABLE NGOT" },
	{ 0xA268, "YI SYLLABLE NGOX" },
	{ 0xA269, "YI SYLLABLE NGO" },
	{ 0xA26A, "YI SYLLABLE NGOP" },
	{ 0xA26B, "YI SYLLABLE NGEX" },
	{ 0xA26C, "YI SYLLABLE NGE" },
	{ 0xA26D, "YI SYLLABLE NGEP" },
	{ 0xA26E, "YI SYLLABLE HIT" },
	{ 0xA26F, "YI SYLLABLE HIEX" },
	{ 0xA270, "YI SYLLABLE HIE" },
	{ 0xA271, "YI SYLLABLE HAT" },
	{ 0xA272, "YI SYLLABLE HAX" },
	{ 0xA273, "YI SYLLABLE HA" },
	{ 0xA274, "YI SYLLABLE HAP" },
	{ 0xA275, "YI SYLLABLE HUOT" },
	{ 0xA276, "YI SYLLABLE HUOX" },
	{ 0xA277, "YI SYLLABLE HUO" },
	{ 0xA278, "YI SYLLABLE HUOP" },
	{ 0xA279, "YI SYLLABLE HOT" },
	{ 0xA27A, "YI SYLLABLE HOX" },
	{ 0xA27B, "YI SYLLABLE HO" },
	{ 0xA27C, "YI SYLLABLE HOP" },
	{ 0xA27D, "YI SYLLABLE HEX" },
	{ 0xA27E, "YI SYLLABLE HE" },
	{ 0xA27F, "YI SYLLABLE HEP" },
	{ 0xA280, "YI SYLLABLE WAT" },
	{ 0xA281, "YI SYLLABLE WAX" },
	{ 0xA282, "YI SYLLABLE WA" },
	{ 0xA283, "YI SYLLABLE WAP" },
	{ 0xA284, "YI SYLLABLE WUOX" },
	{ 0xA285, "YI SYLLABLE WUO" },
	{ 0xA286, "YI SYLLABLE WUOP" },
	{ 0xA287, "YI SYLLABLE WOX" },
	{ 0xA288, "YI SYLLABLE WO" },
	{ 0xA289, "YI SYLLABLE WOP" },
	{ 0xA28A, "YI SYLLABLE WEX" },
	{ 0xA28B, "YI SYLLABLE WE" },
	{ 0xA28C, "YI SYLLABLE WEP" },
	{ 0xA28D, "YI SYLLABLE ZIT" },
	{ 0xA28E, "YI SYLLABLE ZIX" },
	{ 0xA28F, "YI SYLLABLE ZI" },
	{ 0xA290, "YI SYLLABLE ZIP" },
	{ 0xA291, "YI SYLLABLE ZIEX" },
	{ 0xA292, "YI SYLLABLE ZIE" },
	{ 0xA293, "YI SYLLABLE ZIEP" },
	{ 0xA294, "YI SYLLABLE ZAT" },
	{ 0xA295, "YI SYLLABLE ZAX" },
	{ 0xA296, "YI SYLLABLE ZA" },
	{ 0xA297, "YI SYLLABLE ZAP" },
	{ 0xA298, "YI SYLLABLE ZUOX" },
	{ 0xA299, "YI SYLLABLE ZUO" },
	{ 0xA29A, "YI SYLLABLE ZUOP" },
	{ 0xA29B, "YI SYLLABLE ZOT" },
	{ 0xA29C, "YI SYLLABLE ZOX" },
	{ 0xA29D, "YI SYLLABLE ZO" },
	{ 0xA29E, "YI SYLLABLE ZOP" },
	{ 0xA29F, "YI SYLLABLE ZEX" },
	{ 0xA2A0, "YI SYLLABLE ZE" },
	{ 0xA2A1, "YI SYLLABLE ZEP" },
	{ 0xA2A2, "YI SYLLABLE ZUT" },
	{ 0xA2A3, "YI SYLLABLE ZUX" },
	{ 0xA2A4, "YI SYLLABLE ZU" },
	{ 0xA2A5, "YI SYLLABLE ZUP" },
	{ 0xA2A6, "YI SYLLABLE ZURX" },
	{ 0xA2A7, "YI SYLLABLE ZUR" },
	{ 0xA2A8, "YI SYLLABLE ZYT" },
	{ 0xA2A9, "YI SYLLABLE ZYX" },
	{ 0xA2AA, "YI SYLLABLE ZY" },
	{ 0xA2AB, "YI SYLLABLE ZYP" },
	{ 0xA2AC, "YI SYLLABLE ZYRX" },
	{ 0xA2AD, "YI SYLLABLE ZYR" },
	{ 0xA2AE, "YI SYLLABLE CIT" },
	{ 0xA2AF, "YI SYLLABLE CIX" },
	{ 0xA2B0, "YI SYLLABLE CI" },
	{ 0xA2B1, "YI SYLLABLE CIP" },
	{ 0xA2B2, "YI SYLLABLE CIET" },
	{ 0xA2B3, "YI SYLLABLE CIEX" },
	{ 0xA2B4, "YI SYLLABLE CIE" },
	{ 0xA2B5, "YI SYLLABLE CIEP" },
	{ 0xA2B6, "YI SYLLABLE CAT" },
	{ 0xA2B7, "YI SYLLABLE CAX" },
	{ 0xA2B8, "YI SYLLABLE CA" },
	{ 0xA2B9, "YI SYLLABLE CAP" },
	{ 0xA2BA, "YI SYLLABLE CUOX" },
	{ 0xA2BB, "YI SYLLABLE CUO" },
	{ 0xA2BC, "YI SYLLABLE CUOP" },
	{ 0xA2BD, "YI SYLLABLE COT" },
	{ 0xA2BE, "YI SYLLABLE COX" },
	{ 0xA2BF, "YI SYLLABLE CO" },
	{ 0xA2C0, "YI SYLLABLE COP" },
	{ 0xA2C1, "YI SYLLABLE CEX" },
	{ 0xA2C2, "YI SYLLABLE CE" },
	{ 0xA2C3, "YI SYLLABLE CEP" },
	{ 0xA2C4, "YI SYLLABLE CUT" },
	{ 0xA2C5, "YI SYLLABLE CUX" },
	{ 0xA2C6, "YI SYLLABLE CU" },
	{ 0xA2C7, "YI SYLLABLE CUP" },
	{ 0xA2C8, "YI SYLLABLE CURX" },
	{ 0xA2C9, "YI SYLLABLE CUR" },
	{ 0xA2CA, "YI SYLLABLE CYT" },
	{ 0xA2CB, "YI SYLLABLE CYX" },
	{ 0xA2CC, "YI SYLLABLE CY" },
	{ 0xA2CD, "YI SYLLABLE CYP" },
	{ 0xA2CE, "YI SYLLABLE CYRX" },
	{ 0xA2CF, "YI SYLLABLE CYR" },
	{ 0xA2D0, "YI SYLLABLE ZZIT" },
	{ 0xA2D1, "YI SYLLABLE ZZIX" },
	{ 0xA2D2, "YI SYLLABLE ZZI" },
	{ 0xA2D3, "YI SYLLABLE ZZIP" },
	{ 0xA2D4, "YI SYLLABLE ZZIET" },
	{ 0xA2D5, "YI SYLLABLE ZZIEX" },
	{ 0xA2D6, "YI SYLLABLE ZZIE" },
	{ 0xA2D7, "YI SYLLABLE ZZIEP" },
	{ 0xA2D8, "YI SYLLABLE ZZAT" },
	{ 0xA2D9, "YI SYLLABLE ZZAX" },
	{ 0xA2DA, "YI SYLLABLE ZZA" },
	{ 0xA2DB, "YI SYLLABLE ZZAP" },
	{ 0xA2DC, "YI SYLLABLE ZZOX" },
	{ 0xA2DD, "YI SYLLABLE ZZO" },
	{ 0xA2DE, "YI SYLLABLE ZZOP" },
	{ 0xA2DF, "YI SYLLABLE ZZEX" },
	{ 0xA2E0, "YI SYLLABLE ZZE" },
	{ 0xA2E1, "YI SYLLABLE ZZEP" },
	{ 0xA2E2, "YI SYLLABLE ZZUX" },
	{ 0xA2E3, "YI SYLLABLE ZZU" },
	{ 0xA2E4, "YI SYLLABLE ZZUP" },
	{ 0xA2E5, "YI SYLLABLE ZZURX" },
	{ 0xA2E6, "YI SYLLABLE ZZUR" },
	{ 0xA2E7, "YI SYLLABLE ZZYT" },
	{ 0xA2E8, "YI SYLLABLE ZZYX" },
	{ 0xA2E9, "YI SYLLABLE ZZY" },
	{ 0xA2EA, "YI SYLLABLE ZZYP" },
	{ 0xA2EB, "YI SYLLABLE ZZYRX" },
	{ 0xA2EC, "YI SYLLABLE ZZYR" },
	{ 0xA2ED, "YI SYLLABLE NZIT" },
	{ 0xA2EE, "YI SYLLABLE NZIX" },
	{ 0xA2EF, "YI SYLLABLE NZI" },
	{ 0xA2F0, "YI SYLLABLE NZIP" },
	{ 0xA2F1, "YI SYLLABLE NZIEX" },
	{ 0xA2F2, "YI SYLLABLE NZIE" },
	{ 0xA2F3, "YI SYLLABLE NZIEP" },
	{ 0xA2F4, "YI SYLLABLE NZAT" },
	{ 0xA2F5, "YI SYLLABLE NZAX" },
	{ 0xA2F6, "YI SYLLABLE NZA" },
	{ 0xA2F7, "YI SYLLABLE NZAP" },
	{ 0xA2F8, "YI SYLLABLE NZUOX" },
	{ 0xA2F9, "YI SYLLABLE NZUO" },
	{ 0xA2FA, "YI SYLLABLE NZOX" },
	{ 0xA2FB, "YI SYLLABLE NZOP" },
	{ 0xA2FC, "YI SYLLABLE NZEX" },
	{ 0xA2FD, "YI SYLLABLE NZE" },
	{ 0xA2FE, "YI SYLLABLE NZUX" },
	{ 0xA2FF, "YI SYLLABLE NZU" },
	{ 0xA300, "YI SYLLABLE NZUP" },
	{ 0xA301, "YI SYLLABLE NZURX" },
	{ 0xA302, "YI SYLLABLE NZUR" },
	{ 0xA303, "YI SYLLABLE NZYT" },
	{ 0xA304, "YI SYLLABLE NZYX" },
	{ 0xA305, "YI SYLLABLE NZY" },
	{ 0xA306, "YI SYLLABLE NZYP" },
	{ 0xA307, "YI SYLLABLE NZYRX" },
	{ 0xA308, "YI SYLLABLE NZYR" },
	{ 0xA309, "YI SYLLABLE SIT" },
	{ 0xA30A, "YI SYLLABLE SIX" },
	{ 0xA30B, "YI SYLLABLE SI" },
	{ 0xA30C, "YI SYLLABLE SIP" },
	{ 0xA30D, "YI SYLLABLE SIEX" },
	{ 0xA30E, "YI SYLLABLE SIE" },
	{ 0xA30F, "YI SYLLABLE SIEP" },
	{ 0xA310, "YI SYLLABLE SAT" },
	{ 0xA311, "YI SYLLABLE SAX" },
	{ 0xA312, "YI SYLLABLE SA" },
	{ 0xA313, "YI SYLLABLE SAP" },
	{ 0xA314, "YI SYLLABLE SUOX" },
	{ 0xA315, "YI SYLLABLE SUO" },
	{ 0xA316, "YI SYLLABLE SUOP" },
	{ 0xA317, "YI SYLLABLE SOT" },
	{ 0xA318, "YI SYLLABLE SOX" },
	{ 0xA319, "YI SYLLABLE SO" },
	{ 0xA31A, "YI SYLLABLE SOP" },
	{ 0xA31B, "YI SYLLABLE SEX" },
	{ 0xA31C, "YI SYLLABLE SE" },
	{ 0xA31D, "YI SYLLABLE SEP" },
	{ 0xA31E, "YI SYLLABLE SUT" },
	{ 0xA31F, "YI SYLLABLE SUX" },
	{ 0xA320, "YI SYLLABLE SU" },
	{ 0xA321, "YI SYLLABLE SUP" },
	{ 0xA322, "YI SYLLABLE SURX" },
	{ 0xA323, "YI SYLLABLE SUR" },
	{ 0xA324, "YI SYLLABLE SYT" },
	{ 0xA325, "YI SYLLABLE SYX" },
	{ 0xA326, "YI SYLLABLE SY" },
	{ 0xA327, "YI SYLLABLE SYP" },
	{ 0xA328, "YI SYLLABLE SYRX" },
	{ 0xA329, "YI SYLLABLE SYR" },
	{ 0xA32A, "YI SYLLABLE SSIT" },
	{ 0xA32B, "YI SYLLABLE SSIX" },
	{ 0xA32C, "YI SYLLABLE SSI" },
	{ 0xA32D, "YI SYLLABLE SSIP" },
	{ 0xA32E, "YI SYLLABLE SSIEX" },
	{ 0xA32F, "YI SYLLABLE SSIE" },
	{ 0xA330, "YI SYLLABLE SSIEP" },
	{ 0xA331, "YI SYLLABLE SSAT" },
	{ 0xA332, "YI SYLLABLE SSAX" },
	{ 0xA333, "YI SYLLABLE SSA" },
	{ 0xA334, "YI SYLLABLE SSAP" },
	{ 0xA335, "YI SYLLABLE SSOT" },
	{ 0xA336, "YI SYLLABLE SSOX" },
	{ 0xA337, "YI SYLLABLE SSO" },
	{ 0xA338, "YI SYLLABLE SSOP" },
	{ 0xA339, "YI SYLLABLE SSEX" },
	{ 0xA33A, "YI SYLLABLE SSE" },
	{ 0xA33B, "YI SYLLABLE SSEP" },
	{ 0xA33C, "YI SYLLABLE SSUT" },
	{ 0xA33D, "YI SYLLABLE SSUX" },
	{ 0xA33E, "YI SYLLABLE SSU" },
	{ 0xA33F, "YI SYLLABLE SSUP" },
	{ 0xA340, "YI SYLLABLE SSYT" },
	{ 0xA341, "YI SYLLABLE SSYX" },
	{ 0xA342, "YI SYLLABLE SSY" },
	{ 0xA343, "YI SYLLABLE SSYP" },
	{ 0xA344, "YI SYLLABLE SSYRX" },
	{ 0xA345, "YI SYLLABLE SSYR" },
	{ 0xA346, "YI SYLLABLE ZHAT" },
	{ 0xA347, "YI SYLLABLE ZHAX" },
	{ 0xA348, "YI SYLLABLE ZHA" },
	{ 0xA349, "YI SYLLABLE ZHAP" },
	{ 0xA34A, "YI SYLLABLE ZHUOX" },
	{ 0xA34B, "YI SYLLABLE ZHUO" },
	{ 0xA34C, "YI SYLLABLE ZHUOP" },
	{ 0xA34D, "YI SYLLABLE ZHOT" },
	{ 0xA34E, "YI SYLLABLE ZHOX" },
	{ 0xA34F, "YI SYLLABLE ZHO" },
	{ 0xA350, "YI SYLLABLE ZHOP" },
	{ 0xA351, "YI SYLLABLE ZHET" },
	{ 0xA352, "YI SYLLABLE ZHEX" },
	{ 0xA353, "YI SYLLABLE ZHE" },
	{ 0xA354, "YI SYLLABLE ZHEP" },
	{ 0xA355, "YI SYLLABLE ZHUT" },
	{ 0xA356, "YI SYLLABLE ZHUX" },
	{ 0xA357, "YI SYLLABLE ZHU" },
	{ 0xA358, "YI SYLLABLE ZHUP" },
	{ 0xA359, "YI SYLLABLE ZHURX" },
	{ 0xA35A, "YI SYLLABLE ZHUR" },
	{ 0xA35B, "YI SYLLABLE ZHYT" },
	{ 0xA35C, "YI SYLLABLE ZHYX" },
	{ 0xA35D, "YI SYLLABLE ZHY" },
	{ 0xA35E, "YI SYLLABLE ZHYP" },
	{ 0xA35F, "YI SYLLABLE ZHYRX" },
	{ 0xA360, "YI SYLLABLE ZHYR" },
	{ 0xA361, "YI SYLLABLE CHAT" },
	{ 0xA362, "YI SYLLABLE CHAX" },
	{ 0xA363, "YI SYLLABLE CHA" },
	{ 0xA364, "YI SYLLABLE CHAP" },
	{ 0xA365, "YI SYLLABLE CHUOT" },
	{ 0xA366, "YI SYLLABLE CHUOX" },
	{ 0xA367, "YI SYLLABLE CHUO" },
	{ 0xA368, "YI SYLLABLE CHUOP" },
	{ 0xA369, "YI SYLLABLE CHOT" },
	{ 0xA36A, "YI SYLLABLE CHOX" },
	{ 0xA36B, "YI SYLLABLE CHO" },
	{ 0xA36C, "YI SYLLABLE CHOP" },
	{ 0xA36D, "YI SYLLABLE CHET" },
	{ 0xA36E, "YI SYLLABLE CHEX" },
	{ 0xA36F, "YI SYLLABLE CHE" },
	{ 0xA370, "YI SYLLABLE CHEP" },
	{ 0xA371, "YI SYLLABLE CHUX" },
	{ 0xA372, "YI SYLLABLE CHU" },
	{ 0xA373, "YI SYLLABLE CHUP" },
	{ 0xA374, "YI SYLLABLE CHURX" },
	{ 0xA375, "YI SYLLABLE CHUR" },
	{ 0xA376, "YI SYLLABLE CHYT" },
	{ 0xA377, "YI SYLLABLE CHYX" },
	{ 0xA378, "YI SYLLABLE CHY" },
	{ 0xA379, "YI SYLLABLE CHYP" },
	{ 0xA37A, "YI SYLLABLE CHYRX" },
	{ 0xA37B, "YI SYLLABLE CHYR" },
	{ 0xA37C, "YI SYLLABLE RRAX" },
	{ 0xA37D, "YI SYLLABLE RRA" },
	{ 0xA37E, "YI SYLLABLE RRUOX" },
	{ 0xA37F, "YI SYLLABLE RRUO" },
	{ 0xA380, "YI SYLLABLE RROT" },
	{ 0xA381, "YI SYLLABLE RROX" },
	{ 0xA382, "YI SYLLABLE RRO" },
	{ 0xA383, "YI SYLLABLE RROP" },
	{ 0xA384, "YI SYLLABLE RRET" },
	{ 0xA385, "YI SYLLABLE RREX" },
	{ 0xA386, "YI SYLLABLE RRE" },
	{ 0xA387, "YI SYLLABLE RREP" },
	{ 0xA388, "YI SYLLABLE RRUT" },
	{ 0xA389, "YI SYLLABLE RRUX" },
	{ 0xA38A, "YI SYLLABLE RRU" },
	{ 0xA38B, "YI SYLLABLE RRUP" },
	{ 0xA38C, "YI SYLLABLE RRURX" },
	{ 0xA38D, "YI SYLLABLE RRUR" },
	{ 0xA38E, "YI SYLLABLE RRYT" },
	{ 0xA38F, "YI SYLLABLE RRYX" },
	{ 0xA390, "YI SYLLABLE RRY" },
	{ 0xA391, "YI SYLLABLE RRYP" },
	{ 0xA392, "YI SYLLABLE RRYRX" },
	{ 0xA393, "YI SYLLABLE RRYR" },
	{ 0xA394, "YI SYLLABLE NRAT" },
	{ 0xA395, "YI SYLLABLE NRAX" },
	{ 0xA396, "YI SYLLABLE NRA" },
	{ 0xA397, "YI SYLLABLE NRAP" },
	{ 0xA398, "YI SYLLABLE NROX" },
	{ 0xA399, "YI SYLLABLE NRO" },
	{ 0xA39A, "YI SYLLABLE NROP" },
	{ 0xA39B, "YI SYLLABLE NRET" },
	{ 0xA39C, "YI SYLLABLE NREX" },
	{ 0xA39D, "YI SYLLABLE NRE" },
	{ 0xA39E, "YI SYLLABLE NREP" },
	{ 0xA39F, "YI SYLLABLE NRUT" },
	{ 0xA3A0, "YI SYLLABLE NRUX" },
	{ 0xA3A1, "YI SYLLABLE NRU" },
	{ 0xA3A2, "YI SYLLABLE NRUP" },
	{ 0xA3A3, "YI SYLLABLE NRURX" },
	{ 0xA3A4, "YI SYLLABLE NRUR" },
	{ 0xA3A5, "YI SYLLABLE NRYT" },
	{ 0xA3A6, "YI SYLLABLE NRYX" },
	{ 0xA3A7, "YI SYLLABLE NRY" },
	{ 0xA3A8, "YI SYLLABLE NRYP" },
	{ 0xA3A9, "YI SYLLABLE NRYRX" },
	{ 0xA3AA, "YI SYLLABLE NRYR" },
	{ 0xA3AB, "YI SYLLABLE SHAT" },
	{ 0xA3AC, "YI SYLLABLE SHAX" },
	{ 0xA3AD, "YI SYLLABLE SHA" },
	{ 0xA3AE, "YI SYLLABLE SHAP" },
	{ 0xA3AF, "YI SYLLABLE SHUOX" },
	{ 0xA3B0, "YI SYLLABLE SHUO" },
	{ 0xA3B1, "YI SYLLABLE SHUOP" },
	{ 0xA3B2, "YI SYLLABLE SHOT" },
	{ 0xA3B3, "YI SYLLABLE SHOX" },
	{ 0xA3B4, "YI SYLLABLE SHO" },
	{ 0xA3B5, "YI SYLLABLE SHOP" },
	{ 0xA3B6, "YI SYLLABLE SHET" },
	{ 0xA3B7, "YI SYLLABLE SHEX" },
	{ 0xA3B8, "YI SYLLABLE SHE" },
	{ 0xA3B9, "YI SYLLABLE SHEP" },
	{ 0xA3BA, "YI SYLLABLE SHUT" },
	{ 0xA3BB, "YI SYLLABLE SHUX" },
	{ 0xA3BC, "YI SYLLABLE SHU" },
	{ 0xA3BD, "YI SYLLABLE SHUP" },
	{ 0xA3BE, "YI SYLLABLE SHURX" },
	{ 0xA3BF, "YI SYLLABLE SHUR" },
	{ 0xA3C0, "YI SYLLABLE SHYT" },
	{ 0xA3C1, "YI SYLLABLE SHYX" },
	{ 0xA3C2, "YI SYLLABLE SHY" },
	{ 0xA3C3, "YI SYLLABLE SHYP" },
	{ 0xA3C4, "YI SYLLABLE SHYRX" },
	{ 0xA3C5, "YI SYLLABLE SHYR" },
	{ 0xA3C6, "YI SYLLABLE RAT" },
	{ 0xA3C7, "YI SYLLABLE RAX" },
	{ 0xA3C8, "YI SYLLABLE RA" },
	{ 0xA3C9, "YI SYLLABLE RAP" },
	{ 0xA3CA, "YI SYLLABLE RUOX" },
	{ 0xA3CB, "YI SYLLABLE RUO" },
	{ 0xA3CC, "YI SYLLABLE RUOP" },
	{ 0xA3CD, "YI SYLLABLE ROT" },
	{ 0xA3CE, "YI SYLLABLE ROX" },
	{ 0xA3CF, "YI SYLLABLE RO" },
	{ 0xA3D0, "YI SYLLABLE ROP" },
	{ 0xA3D1, "YI SYLLABLE REX" },
	{ 0xA3D2, "YI SYLLABLE RE" },
	{ 0xA3D3, "YI SYLLABLE REP" },
	{ 0xA3D4, "YI SYLLABLE RUT" },
	{ 0xA3D5, "YI SYLLABLE RUX" },
	{ 0xA3D6, "YI SYLLABLE RU" },
	{ 0xA3D7, "YI SYLLABLE RUP" },
	{ 0xA3D8, "YI SYLLABLE RURX" },
	{ 0xA3D9, "YI SYLLABLE RUR" },
	{ 0xA3DA, "YI SYLLABLE RYT" },
	{ 0xA3DB, "YI SYLLABLE RYX" },
	{ 0xA3DC, "YI SYLLABLE RY" },
	{ 0xA3DD, "YI SYLLABLE RYP" },
	{ 0xA3DE, "YI SYLLABLE RYRX" },
	{ 0xA3DF, "YI SYLLABLE RYR" },
	{ 0xA3E0, "YI SYLLABLE JIT" },
	{ 0xA3E1, "YI SYLLABLE JIX" },
	{ 0xA3E2, "YI SYLLABLE JI" },
	{ 0xA3E3, "YI SYLLABLE JIP" },
	{ 0xA3E4, "YI SYLLABLE JIET" },
	{ 0xA3E5, "YI SYLLABLE JIEX" },
	{ 0xA3E6, "YI SYLLABLE JIE" },
	{ 0xA3E7, "YI SYLLABLE JIEP" },
	{ 0xA3E8, "YI SYLLABLE JUOT" },
	{ 0xA3E9, "YI SYLLABLE JUOX" },
	{ 0xA3EA, "YI SYLLABLE JUO" },
	{ 0xA3EB, "YI SYLLABLE JUOP" },
	{ 0xA3EC, "YI SYLLABLE JOT" },
	{ 0xA3ED, "YI SYLLABLE JOX" },
	{ 0xA3EE, "YI SYLLABLE JO" },
	{ 0xA3EF, "YI SYLLABLE JOP" },
	{ 0xA3F0, "YI SYLLABLE JUT" },
	{ 0xA3F1, "YI SYLLABLE JUX" },
	{ 0xA3F2, "YI SYLLABLE JU" },
	{ 0xA3F3, "YI SYLLABLE JUP" },
	{ 0xA3F4, "YI SYLLABLE JURX" },
	{ 0xA3F5, "YI SYLLABLE JUR" },
	{ 0xA3F6, "YI SYLLABLE JYT" },
	{ 0xA3F7, "YI SYLLABLE JYX" },
	{ 0xA3F8, "YI SYLLABLE JY" },
	{ 0xA3F9, "YI SYLLABLE JYP" },
	{ 0xA3FA, "YI SYLLABLE JYRX" },
	{ 0xA3FB, "YI SYLLABLE JYR" },
	{ 0xA3FC, "YI SYLLABLE QIT" },
	{ 0xA3FD, "YI SYLLABLE QIX" },
	{ 0xA3FE, "YI SYLLABLE QI" },
	{ 0xA3FF, "YI SYLLABLE QIP" },
	{ 0xA400, "YI SYLLABLE QIET" },
	{ 0xA401, "YI SYLLABLE QIEX" },
	{ 0xA402, "YI SYLLABLE QIE" },
	{ 0xA403, "YI SYLLABLE QIEP" },
	{ 0xA404, "YI SYLLABLE QUOT" },
	{ 0xA405, "YI SYLLABLE QUOX" },
	{ 0xA406, "YI SYLLABLE QUO" },
	{ 0xA407, "YI SYLLABLE QUOP" },
	{ 0xA408, "YI SYLLABLE QOT" },
	{ 0xA409, "YI SYLLABLE QOX" },
	{ 0xA40A, "YI SYLLABLE QO" },
	{ 0xA40B, "YI SYLLABLE QOP" },
	{ 0xA40C, "YI SYLLABLE QUT" },
	{ 0xA40D, "YI SYLLABLE QUX" },
	{ 0xA40E, "YI SYLLABLE QU" },
	{ 0xA40F, "YI SYLLABLE QUP" },
	{ 0xA410, "YI SYLLABLE QURX" },
	{ 0xA411, "YI SYLLABLE QUR" },
	{ 0xA412, "YI SYLLABLE QYT" },
	{ 0xA413, "YI SYLLABLE QYX" },
	{ 0xA414, "YI SYLLABLE QY" },
	{ 0xA415, "YI SYLLABLE QYP" },
	{ 0xA416, "YI SYLLABLE QYRX" },
	{ 0xA417, "YI SYLLABLE QYR" },
	{ 0xA418, "YI SYLLABLE JJIT" },
	{ 0xA419, "YI SYLLABLE JJIX" },
	{ 0xA41A, "YI SYLLABLE JJI" },
	{ 0xA41B, "YI SYLLABLE JJIP" },
	{ 0xA41C, "YI SYLLABLE JJIET" },
	{ 0xA41D, "YI SYLLABLE JJIEX" },
	{ 0xA41E, "YI SYLLABLE JJIE" },
	{ 0xA41F, "YI SYLLABLE JJIEP" },
	{ 0xA420, "YI SYLLABLE JJUOX" },
	{ 0xA421, "YI SYLLABLE JJUO" },
	{ 0xA422, "YI SYLLABLE JJUOP" },
	{ 0xA423, "YI SYLLABLE JJOT" },
	{ 0xA424, "YI SYLLABLE JJOX" },
	{ 0xA425, "YI SYLLABLE JJO" },
	{ 0xA426, "YI SYLLABLE JJOP" },
	{ 0xA427, "YI SYLLABLE JJUT" },
	{ 0xA428, "YI SYLLABLE JJUX" },
	{ 0xA429, "YI SYLLABLE JJU" },
	{ 0xA42A, "YI SYLLABLE JJUP" },
	{ 0xA42B, "YI SYLLABLE JJURX" },
	{ 0xA42C, "YI SYLLABLE JJUR" },
	{ 0xA42D, "YI SYLLABLE JJYT" },
	{ 0xA42E, "YI SYLLABLE JJYX" },
	{ 0xA42F, "YI SYLLABLE JJY" },
	{ 0xA430, "YI SYLLABLE JJYP" },
	{ 0xA431, "YI SYLLABLE NJIT" },
	{ 0xA432, "YI SYLLABLE NJIX" },
	{ 0xA433, "YI SYLLABLE NJI" },
	{ 0xA434, "YI SYLLABLE NJIP" },
	{ 0xA435, "YI SYLLABLE NJIET" },
	{ 0xA436, "YI SYLLABLE NJIEX" },
	{ 0xA437, "YI SYLLABLE NJIE" },
	{ 0xA438, "YI SYLLABLE NJIEP" },
	{ 0xA439, "YI SYLLABLE NJUOX" },
	{ 0xA43A, "YI SYLLABLE NJUO" },
	{ 0xA43B, "YI SYLLABLE NJOT" },
	{ 0xA43C, "YI SYLLABLE NJOX" },
	{ 0xA43D, "YI SYLLABLE NJO" },
	{ 0xA43E, "YI SYLLABLE NJOP" },
	{ 0xA43F, "YI SYLLABLE NJUX" },
	{ 0xA440, "YI SYLLABLE NJU" },
	{ 0xA441, "YI SYLLABLE NJUP" },
	{ 0xA442, "YI SYLLABLE NJURX" },
	{ 0xA443, "YI SYLLABLE NJUR" },
	{ 0xA444, "YI SYLLABLE NJYT" },
	{ 0xA445, "YI SYLLABLE NJYX" },
	{ 0xA446, "YI SYLLABLE NJY" },
	{ 0xA447, "YI SYLLABLE NJYP" },
	{ 0xA448, "YI SYLLABLE NJYRX" },
	{ 0xA449, "YI SYLLABLE NJYR" },
	{ 0xA44A, "YI SYLLABLE NYIT" },
	{ 0xA44B, "YI SYLLABLE NYIX" },
	{ 0xA44C, "YI SYLLABLE NYI" },
	{ 0xA44D, "YI SYLLABLE NYIP" },
	{ 0xA44E, "YI SYLLABLE NYIET" },
	{ 0xA44F, "YI SYLLABLE NYIEX" },
	{ 0xA450, "YI SYLLABLE NYIE" },
	{ 0xA451, "YI SYLLABLE NYIEP" },
	{ 0xA452, "YI SYLLABLE NYUOX" },
	{ 0xA453, "YI SYLLABLE NYUO" },
	{ 0xA454, "YI SYLLABLE NYUOP" },
	{ 0xA455, "YI SYLLABLE NYOT" },
	{ 0xA456, "YI SYLLABLE NYOX" },
	{ 0xA457, "YI SYLLABLE NYO" },
	{ 0xA458, "YI SYLLABLE NYOP" },
	{ 0xA459, "YI SYLLABLE NYUT" },
	{ 0xA45A, "YI SYLLABLE NYUX" },
	{ 0xA45B, "YI SYLLABLE NYU" },
	{ 0xA45C, "YI SYLLABLE NYUP" },
	{ 0xA45D, "YI SYLLABLE XIT" },
	{ 0xA45E, "YI SYLLABLE XIX" },
	{ 0xA45F, "YI SYLLABLE XI" },
	{ 0xA460, "YI SYLLABLE XIP" },
	{ 0xA461, "YI SYLLABLE XIET" },
	{ 0xA462, "YI SYLLABLE XIEX" },
	{ 0xA463, "YI SYLLABLE XIE" },
	{ 0xA464, "YI SYLLABLE XIEP" },
	{ 0xA465, "YI SYLLABLE XUOX" },
	{ 0xA466, "YI SYLLABLE XUO" },
	{ 0xA467, "YI SYLLABLE XOT" },
	{ 0xA468, "YI SYLLABLE XOX" },
	{ 0xA469, "YI SYLLABLE XO" },
	{ 0xA46A, "YI SYLLABLE XOP" },
	{ 0xA46B, "YI SYLLABLE XYT" },
	{ 0xA46C, "YI SYLLABLE XYX" },
	{ 0xA46D, "YI SYLLABLE XY" },
	{ 0xA46E, "YI SYLLABLE XYP" },
	{ 0xA46F, "YI SYLLABLE XYRX" },
	{ 0xA470, "YI SYLLABLE XYR" },
	{ 0xA471, "YI SYLLABLE YIT" },
	{ 0xA472, "YI SYLLABLE YIX" },
	{ 0xA473, "YI SYLLABLE YI" },
	{ 0xA474, "YI SYLLABLE YIP" },
	{ 0xA475, "YI SYLLABLE YIET" },
	{ 0xA476, "YI SYLLABLE YIEX" },
	{ 0xA477, "YI SYLLABLE YIE" },
	{ 0xA478, "YI SYLLABLE YIEP" },
	{ 0xA479, "YI SYLLABLE YUOT" },
	{ 0xA47A, "YI SYLLABLE YUOX" },
	{ 0xA47B, "YI SYLLABLE YUO" },
	{ 0xA47C, "YI SYLLABLE YUOP" },
	{ 0xA47D, "YI SYLLABLE YOT" },
	{ 0xA47E, "YI SYLLABLE YOX" },
	{ 0xA47F, "YI SYLLABLE YO" },
	{ 0xA480, "YI SYLLABLE YOP" },
	{ 0xA481, "YI SYLLABLE YUT" },
	{ 0xA482, "YI SYLLABLE YUX" },
	{ 0xA483, "YI SYLLABLE YU" },
	{ 0xA484, "YI SYLLABLE YUP" },
	{ 0xA485, "YI SYLLABLE YURX" },
	{ 0xA486, "YI SYLLABLE YUR" },
	{ 0xA487, "YI SYLLABLE YYT" },
	{ 0xA488, "YI SYLLABLE YYX" },
	{ 0xA489, "YI SYLLABLE YY" },
	{ 0xA48A, "YI SYLLABLE YYP" },
	{ 0xA48B, "YI SYLLABLE YYRX" },
	{ 0xA48C, "YI SYLLABLE YYR" },
	{ 0xA490, "YI RADICAL QOT" },
	{ 0xA491, "YI RADICAL LI" },
	{ 0xA492, "YI RADICAL KIT" },
	{ 0xA493, "YI RADICAL NYIP" },
	{ 0xA494, "YI RADICAL CYP" },
	{ 0xA495, "YI RADICAL SSI" },
	{ 0xA496, "YI RADICAL GGOP" },
	{ 0xA497, "YI RADICAL GEP" },
	{ 0xA498, "YI RADICAL MI" },
	{ 0xA499, "YI RADICAL HXIT" },
	{ 0xA49A, "YI RADICAL LYR" },
	{ 0xA49B, "YI RADICAL BBUT" },
	{ 0xA49C, "YI RADICAL MOP" },
	{ 0xA49D, "YI RADICAL YO" },
	{ 0xA49E, "YI RADICAL PUT" },
	{ 0xA49F, "YI RADICAL HXUO" },
	{ 0xA4A0, "YI RADICAL TAT" },
	{ 0xA4A1, "YI RADICAL GA" },
	{ 0xA4A4, "YI RADICAL DDUR" },
	{ 0xA4A5, "YI RADICAL BUR" },
	{ 0xA4A6, "YI RADICAL GGUO" },
	{ 0xA4A7, "YI RADICAL NYOP" },
	{ 0xA4A8, "YI RADICAL TU" },
	{ 0xA4A9, "YI RADICAL OP" },
	{ 0xA4AA, "YI RADICAL JJUT" },
	{ 0xA4AB, "YI RADICAL ZOT" },
	{ 0xA4AC, "YI RADICAL PYT" },
	{ 0xA4AD, "YI RADICAL HMO" },
	{ 0xA4AE, "YI RADICAL YIT" },
	{ 0xA4AF, "YI RADICAL VUR" },
	{ 0xA4B0, "YI RADICAL SHY" },
	{ 0xA4B1, "YI RADICAL VEP" },
	{ 0xA4B2, "YI RADICAL ZA" },
	{ 0xA4B3, "YI RADICAL JO" },
	{ 0xA4B5, "YI RADICAL JJY" },
	{ 0xA4B6, "YI RADICAL GOT" },
	{ 0xA4B7, "YI RADICAL JJIE" },
	{ 0xA4B8, "YI RADICAL WO" },
	{ 0xA4B9, "YI RADICAL DU" },
	{ 0xA4BA, "YI RADICAL SHUR" },
	{ 0xA4BB, "YI RADICAL LIE" },
	{ 0xA4BC, "YI RADICAL CY" },
	{ 0xA4BD, "YI RADICAL CUOP" },
	{ 0xA4BE, "YI RADICAL CIP" },
	{ 0xA4BF, "YI RADICAL HXOP" },
	{ 0xA4C0, "YI RADICAL SHAT" },
	{ 0xA4C2, "YI RADICAL SHOP" },
	{ 0xA4C3, "YI RADICAL CHE" },
	{ 0xA4C4, "YI RADICAL ZZIET" },
	{ 0xA4C6, "YI RADICAL KE" },
	{ 0xAC00, "<Hangul Syllable, First>" },
	{ 0xD7A3, "<Hangul Syllable, Last>" },
	{ 0xD800, "<Non Private Use High Surrogate, First>" },
	{ 0xDB7F, "<Non Private Use High Surrogate, Last>" },
	{ 0xDB80, "<Private Use High Surrogate, First>" },
	{ 0xDBFF, "<Private Use High Surrogate, Last>" },
	{ 0xDC00, "<Low Surrogate, First>" },
	{ 0xDFFF, "<Low Surrogate, Last>" },
	{ 0xE000, "<Private Use, First>" },
	{ 0xF8FF, "<Private Use, Last>" },
	{ 0xF900, "CJK COMPATIBILITY IDEOGRAPH-F900" },
	{ 0xF901, "CJK COMPATIBILITY IDEOGRAPH-F901" },
	{ 0xF902, "CJK COMPATIBILITY IDEOGRAPH-F902" },
	{ 0xF903, "CJK COMPATIBILITY IDEOGRAPH-F903" },
	{ 0xF904, "CJK COMPATIBILITY IDEOGRAPH-F904" },
	{ 0xF905, "CJK COMPATIBILITY IDEOGRAPH-F905" },
	{ 0xF906, "CJK COMPATIBILITY IDEOGRAPH-F906" },
	{ 0xF907, "CJK COMPATIBILITY IDEOGRAPH-F907" },
	{ 0xF908, "CJK COMPATIBILITY IDEOGRAPH-F908" },
	{ 0xF909, "CJK COMPATIBILITY IDEOGRAPH-F909" },
	{ 0xF90A, "CJK COMPATIBILITY IDEOGRAPH-F90A" },
	{ 0xF90B, "CJK COMPATIBILITY IDEOGRAPH-F90B" },
	{ 0xF90C, "CJK COMPATIBILITY IDEOGRAPH-F90C" },
	{ 0xF90D, "CJK COMPATIBILITY IDEOGRAPH-F90D" },
	{ 0xF90E, "CJK COMPATIBILITY IDEOGRAPH-F90E" },
	{ 0xF90F, "CJK COMPATIBILITY IDEOGRAPH-F90F" },
	{ 0xF910, "CJK COMPATIBILITY IDEOGRAPH-F910" },
	{ 0xF911, "CJK COMPATIBILITY IDEOGRAPH-F911" },
	{ 0xF912, "CJK COMPATIBILITY IDEOGRAPH-F912" },
	{ 0xF913, "CJK COMPATIBILITY IDEOGRAPH-F913" },
	{ 0xF914, "CJK COMPATIBILITY IDEOGRAPH-F914" },
	{ 0xF915, "CJK COMPATIBILITY IDEOGRAPH-F915" },
	{ 0xF916, "CJK COMPATIBILITY IDEOGRAPH-F916" },
	{ 0xF917, "CJK COMPATIBILITY IDEOGRAPH-F917" },
	{ 0xF918, "CJK COMPATIBILITY IDEOGRAPH-F918" },
	{ 0xF919, "CJK COMPATIBILITY IDEOGRAPH-F919" },
	{ 0xF91A, "CJK COMPATIBILITY IDEOGRAPH-F91A" },
	{ 0xF91B, "CJK COMPATIBILITY IDEOGRAPH-F91B" },
	{ 0xF91C, "CJK COMPATIBILITY IDEOGRAPH-F91C" },
	{ 0xF91D, "CJK COMPATIBILITY IDEOGRAPH-F91D" },
	{ 0xF91E, "CJK COMPATIBILITY IDEOGRAPH-F91E" },
	{ 0xF91F, "CJK COMPATIBILITY IDEOGRAPH-F91F" },
	{ 0xF920, "CJK COMPATIBILITY IDEOGRAPH-F920" },
	{ 0xF921, "CJK COMPATIBILITY IDEOGRAPH-F921" },
	{ 0xF922, "CJK COMPATIBILITY IDEOGRAPH-F922" },
	{ 0xF923, "CJK COMPATIBILITY IDEOGRAPH-F923" },
	{ 0xF924, "CJK COMPATIBILITY IDEOGRAPH-F924" },
	{ 0xF925, "CJK COMPATIBILITY IDEOGRAPH-F925" },
	{ 0xF926, "CJK COMPATIBILITY IDEOGRAPH-F926" },
	{ 0xF927, "CJK COMPATIBILITY IDEOGRAPH-F927" },
	{ 0xF928, "CJK COMPATIBILITY IDEOGRAPH-F928" },
	{ 0xF929, "CJK COMPATIBILITY IDEOGRAPH-F929" },
	{ 0xF92A, "CJK COMPATIBILITY IDEOGRAPH-F92A" },
	{ 0xF92B, "CJK COMPATIBILITY IDEOGRAPH-F92B" },
	{ 0xF92C, "CJK COMPATIBILITY IDEOGRAPH-F92C" },
	{ 0xF92D, "CJK COMPATIBILITY IDEOGRAPH-F92D" },
	{ 0xF92E, "CJK COMPATIBILITY IDEOGRAPH-F92E" },
	{ 0xF92F, "CJK COMPATIBILITY IDEOGRAPH-F92F" },
	{ 0xF930, "CJK COMPATIBILITY IDEOGRAPH-F930" },
	{ 0xF931, "CJK COMPATIBILITY IDEOGRAPH-F931" },
	{ 0xF932, "CJK COMPATIBILITY IDEOGRAPH-F932" },
	{ 0xF933, "CJK COMPATIBILITY IDEOGRAPH-F933" },
	{ 0xF934, "CJK COMPATIBILITY IDEOGRAPH-F934" },
	{ 0xF935, "CJK COMPATIBILITY IDEOGRAPH-F935" },
	{ 0xF936, "CJK COMPATIBILITY IDEOGRAPH-F936" },
	{ 0xF937, "CJK COMPATIBILITY IDEOGRAPH-F937" },
	{ 0xF938, "CJK COMPATIBILITY IDEOGRAPH-F938" },
	{ 0xF939, "CJK COMPATIBILITY IDEOGRAPH-F939" },
	{ 0xF93A, "CJK COMPATIBILITY IDEOGRAPH-F93A" },
	{ 0xF93B, "CJK COMPATIBILITY IDEOGRAPH-F93B" },
	{ 0xF93C, "CJK COMPATIBILITY IDEOGRAPH-F93C" },
	{ 0xF93D, "CJK COMPATIBILITY IDEOGRAPH-F93D" },
	{ 0xF93E, "CJK COMPATIBILITY IDEOGRAPH-F93E" },
	{ 0xF93F, "CJK COMPATIBILITY IDEOGRAPH-F93F" },
	{ 0xF940, "CJK COMPATIBILITY IDEOGRAPH-F940" },
	{ 0xF941, "CJK COMPATIBILITY IDEOGRAPH-F941" },
	{ 0xF942, "CJK COMPATIBILITY IDEOGRAPH-F942" },
	{ 0xF943, "CJK COMPATIBILITY IDEOGRAPH-F943" },
	{ 0xF944, "CJK COMPATIBILITY IDEOGRAPH-F944" },
	{ 0xF945, "CJK COMPATIBILITY IDEOGRAPH-F945" },
	{ 0xF946, "CJK COMPATIBILITY IDEOGRAPH-F946" },
	{ 0xF947, "CJK COMPATIBILITY IDEOGRAPH-F947" },
	{ 0xF948, "CJK COMPATIBILITY IDEOGRAPH-F948" },
	{ 0xF949, "CJK COMPATIBILITY IDEOGRAPH-F949" },
	{ 0xF94A, "CJK COMPATIBILITY IDEOGRAPH-F94A" },
	{ 0xF94B, "CJK COMPATIBILITY IDEOGRAPH-F94B" },
	{ 0xF94C, "CJK COMPATIBILITY IDEOGRAPH-F94C" },
	{ 0xF94D, "CJK COMPATIBILITY IDEOGRAPH-F94D" },
	{ 0xF94E, "CJK COMPATIBILITY IDEOGRAPH-F94E" },
	{ 0xF94F, "CJK COMPATIBILITY IDEOGRAPH-F94F" },
	{ 0xF950, "CJK COMPATIBILITY IDEOGRAPH-F950" },
	{ 0xF951, "CJK COMPATIBILITY IDEOGRAPH-F951" },
	{ 0xF952, "CJK COMPATIBILITY IDEOGRAPH-F952" },
	{ 0xF953, "CJK COMPATIBILITY IDEOGRAPH-F953" },
	{ 0xF954, "CJK COMPATIBILITY IDEOGRAPH-F954" },
	{ 0xF955, "CJK COMPATIBILITY IDEOGRAPH-F955" },
	{ 0xF956, "CJK COMPATIBILITY IDEOGRAPH-F956" },
	{ 0xF957, "CJK COMPATIBILITY IDEOGRAPH-F957" },
	{ 0xF958, "CJK COMPATIBILITY IDEOGRAPH-F958" },
	{ 0xF959, "CJK COMPATIBILITY IDEOGRAPH-F959" },
	{ 0xF95A, "CJK COMPATIBILITY IDEOGRAPH-F95A" },
	{ 0xF95B, "CJK COMPATIBILITY IDEOGRAPH-F95B" },
	{ 0xF95C, "CJK COMPATIBILITY IDEOGRAPH-F95C" },
	{ 0xF95D, "CJK COMPATIBILITY IDEOGRAPH-F95D" },
	{ 0xF95E, "CJK COMPATIBILITY IDEOGRAPH-F95E" },
	{ 0xF95F, "CJK COMPATIBILITY IDEOGRAPH-F95F" },
	{ 0xF960, "CJK COMPATIBILITY IDEOGRAPH-F960" },
	{ 0xF961, "CJK COMPATIBILITY IDEOGRAPH-F961" },
	{ 0xF962, "CJK COMPATIBILITY IDEOGRAPH-F962" },
	{ 0xF963, "CJK COMPATIBILITY IDEOGRAPH-F963" },
	{ 0xF964, "CJK COMPATIBILITY IDEOGRAPH-F964" },
	{ 0xF965, "CJK COMPATIBILITY IDEOGRAPH-F965" },
	{ 0xF966, "CJK COMPATIBILITY IDEOGRAPH-F966" },
	{ 0xF967, "CJK COMPATIBILITY IDEOGRAPH-F967" },
	{ 0xF968, "CJK COMPATIBILITY IDEOGRAPH-F968" },
	{ 0xF969, "CJK COMPATIBILITY IDEOGRAPH-F969" },
	{ 0xF96A, "CJK COMPATIBILITY IDEOGRAPH-F96A" },
	{ 0xF96B, "CJK COMPATIBILITY IDEOGRAPH-F96B" },
	{ 0xF96C, "CJK COMPATIBILITY IDEOGRAPH-F96C" },
	{ 0xF96D, "CJK COMPATIBILITY IDEOGRAPH-F96D" },
	{ 0xF96E, "CJK COMPATIBILITY IDEOGRAPH-F96E" },
	{ 0xF96F, "CJK COMPATIBILITY IDEOGRAPH-F96F" },
	{ 0xF970, "CJK COMPATIBILITY IDEOGRAPH-F970" },
	{ 0xF971, "CJK COMPATIBILITY IDEOGRAPH-F971" },
	{ 0xF972, "CJK COMPATIBILITY IDEOGRAPH-F972" },
	{ 0xF973, "CJK COMPATIBILITY IDEOGRAPH-F973" },
	{ 0xF974, "CJK COMPATIBILITY IDEOGRAPH-F974" },
	{ 0xF975, "CJK COMPATIBILITY IDEOGRAPH-F975" },
	{ 0xF976, "CJK COMPATIBILITY IDEOGRAPH-F976" },
	{ 0xF977, "CJK COMPATIBILITY IDEOGRAPH-F977" },
	{ 0xF978, "CJK COMPATIBILITY IDEOGRAPH-F978" },
	{ 0xF979, "CJK COMPATIBILITY IDEOGRAPH-F979" },
	{ 0xF97A, "CJK COMPATIBILITY IDEOGRAPH-F97A" },
	{ 0xF97B, "CJK COMPATIBILITY IDEOGRAPH-F97B" },
	{ 0xF97C, "CJK COMPATIBILITY IDEOGRAPH-F97C" },
	{ 0xF97D, "CJK COMPATIBILITY IDEOGRAPH-F97D" },
	{ 0xF97E, "CJK COMPATIBILITY IDEOGRAPH-F97E" },
	{ 0xF97F, "CJK COMPATIBILITY IDEOGRAPH-F97F" },
	{ 0xF980, "CJK COMPATIBILITY IDEOGRAPH-F980" },
	{ 0xF981, "CJK COMPATIBILITY IDEOGRAPH-F981" },
	{ 0xF982, "CJK COMPATIBILITY IDEOGRAPH-F982" },
	{ 0xF983, "CJK COMPATIBILITY IDEOGRAPH-F983" },
	{ 0xF984, "CJK COMPATIBILITY IDEOGRAPH-F984" },
	{ 0xF985, "CJK COMPATIBILITY IDEOGRAPH-F985" },
	{ 0xF986, "CJK COMPATIBILITY IDEOGRAPH-F986" },
	{ 0xF987, "CJK COMPATIBILITY IDEOGRAPH-F987" },
	{ 0xF988, "CJK COMPATIBILITY IDEOGRAPH-F988" },
	{ 0xF989, "CJK COMPATIBILITY IDEOGRAPH-F989" },
	{ 0xF98A, "CJK COMPATIBILITY IDEOGRAPH-F98A" },
	{ 0xF98B, "CJK COMPATIBILITY IDEOGRAPH-F98B" },
	{ 0xF98C, "CJK COMPATIBILITY IDEOGRAPH-F98C" },
	{ 0xF98D, "CJK COMPATIBILITY IDEOGRAPH-F98D" },
	{ 0xF98E, "CJK COMPATIBILITY IDEOGRAPH-F98E" },
	{ 0xF98F, "CJK COMPATIBILITY IDEOGRAPH-F98F" },
	{ 0xF990, "CJK COMPATIBILITY IDEOGRAPH-F990" },
	{ 0xF991, "CJK COMPATIBILITY IDEOGRAPH-F991" },
	{ 0xF992, "CJK COMPATIBILITY IDEOGRAPH-F992" },
	{ 0xF993, "CJK COMPATIBILITY IDEOGRAPH-F993" },
	{ 0xF994, "CJK COMPATIBILITY IDEOGRAPH-F994" },
	{ 0xF995, "CJK COMPATIBILITY IDEOGRAPH-F995" },
	{ 0xF996, "CJK COMPATIBILITY IDEOGRAPH-F996" },
	{ 0xF997, "CJK COMPATIBILITY IDEOGRAPH-F997" },
	{ 0xF998, "CJK COMPATIBILITY IDEOGRAPH-F998" },
	{ 0xF999, "CJK COMPATIBILITY IDEOGRAPH-F999" },
	{ 0xF99A, "CJK COMPATIBILITY IDEOGRAPH-F99A" },
	{ 0xF99B, "CJK COMPATIBILITY IDEOGRAPH-F99B" },
	{ 0xF99C, "CJK COMPATIBILITY IDEOGRAPH-F99C" },
	{ 0xF99D, "CJK COMPATIBILITY IDEOGRAPH-F99D" },
	{ 0xF99E, "CJK COMPATIBILITY IDEOGRAPH-F99E" },
	{ 0xF99F, "CJK COMPATIBILITY IDEOGRAPH-F99F" },
	{ 0xF9A0, "CJK COMPATIBILITY IDEOGRAPH-F9A0" },
	{ 0xF9A1, "CJK COMPATIBILITY IDEOGRAPH-F9A1" },
	{ 0xF9A2, "CJK COMPATIBILITY IDEOGRAPH-F9A2" },
	{ 0xF9A3, "CJK COMPATIBILITY IDEOGRAPH-F9A3" },
	{ 0xF9A4, "CJK COMPATIBILITY IDEOGRAPH-F9A4" },
	{ 0xF9A5, "CJK COMPATIBILITY IDEOGRAPH-F9A5" },
	{ 0xF9A6, "CJK COMPATIBILITY IDEOGRAPH-F9A6" },
	{ 0xF9A7, "CJK COMPATIBILITY IDEOGRAPH-F9A7" },
	{ 0xF9A8, "CJK COMPATIBILITY IDEOGRAPH-F9A8" },
	{ 0xF9A9, "CJK COMPATIBILITY IDEOGRAPH-F9A9" },
	{ 0xF9AA, "CJK COMPATIBILITY IDEOGRAPH-F9AA" },
	{ 0xF9AB, "CJK COMPATIBILITY IDEOGRAPH-F9AB" },
	{ 0xF9AC, "CJK COMPATIBILITY IDEOGRAPH-F9AC" },
	{ 0xF9AD, "CJK COMPATIBILITY IDEOGRAPH-F9AD" },
	{ 0xF9AE, "CJK COMPATIBILITY IDEOGRAPH-F9AE" },
	{ 0xF9AF, "CJK COMPATIBILITY IDEOGRAPH-F9AF" },
	{ 0xF9B0, "CJK COMPATIBILITY IDEOGRAPH-F9B0" },
	{ 0xF9B1, "CJK COMPATIBILITY IDEOGRAPH-F9B1" },
	{ 0xF9B2, "CJK COMPATIBILITY IDEOGRAPH-F9B2" },
	{ 0xF9B3, "CJK COMPATIBILITY IDEOGRAPH-F9B3" },
	{ 0xF9B4, "CJK COMPATIBILITY IDEOGRAPH-F9B4" },
	{ 0xF9B5, "CJK COMPATIBILITY IDEOGRAPH-F9B5" },
	{ 0xF9B6, "CJK COMPATIBILITY IDEOGRAPH-F9B6" },
	{ 0xF9B7, "CJK COMPATIBILITY IDEOGRAPH-F9B7" },
	{ 0xF9B8, "CJK COMPATIBILITY IDEOGRAPH-F9B8" },
	{ 0xF9B9, "CJK COMPATIBILITY IDEOGRAPH-F9B9" },
	{ 0xF9BA, "CJK COMPATIBILITY IDEOGRAPH-F9BA" },
	{ 0xF9BB, "CJK COMPATIBILITY IDEOGRAPH-F9BB" },
	{ 0xF9BC, "CJK COMPATIBILITY IDEOGRAPH-F9BC" },
	{ 0xF9BD, "CJK COMPATIBILITY IDEOGRAPH-F9BD" },
	{ 0xF9BE, "CJK COMPATIBILITY IDEOGRAPH-F9BE" },
	{ 0xF9BF, "CJK COMPATIBILITY IDEOGRAPH-F9BF" },
	{ 0xF9C0, "CJK COMPATIBILITY IDEOGRAPH-F9C0" },
	{ 0xF9C1, "CJK COMPATIBILITY IDEOGRAPH-F9C1" },
	{ 0xF9C2, "CJK COMPATIBILITY IDEOGRAPH-F9C2" },
	{ 0xF9C3, "CJK COMPATIBILITY IDEOGRAPH-F9C3" },
	{ 0xF9C4, "CJK COMPATIBILITY IDEOGRAPH-F9C4" },
	{ 0xF9C5, "CJK COMPATIBILITY IDEOGRAPH-F9C5" },
	{ 0xF9C6, "CJK COMPATIBILITY IDEOGRAPH-F9C6" },
	{ 0xF9C7, "CJK COMPATIBILITY IDEOGRAPH-F9C7" },
	{ 0xF9C8, "CJK COMPATIBILITY IDEOGRAPH-F9C8" },
	{ 0xF9C9, "CJK COMPATIBILITY IDEOGRAPH-F9C9" },
	{ 0xF9CA, "CJK COMPATIBILITY IDEOGRAPH-F9CA" },
	{ 0xF9CB, "CJK COMPATIBILITY IDEOGRAPH-F9CB" },
	{ 0xF9CC, "CJK COMPATIBILITY IDEOGRAPH-F9CC" },
	{ 0xF9CD, "CJK COMPATIBILITY IDEOGRAPH-F9CD" },
	{ 0xF9CE, "CJK COMPATIBILITY IDEOGRAPH-F9CE" },
	{ 0xF9CF, "CJK COMPATIBILITY IDEOGRAPH-F9CF" },
	{ 0xF9D0, "CJK COMPATIBILITY IDEOGRAPH-F9D0" },
	{ 0xF9D1, "CJK COMPATIBILITY IDEOGRAPH-F9D1" },
	{ 0xF9D2, "CJK COMPATIBILITY IDEOGRAPH-F9D2" },
	{ 0xF9D3, "CJK COMPATIBILITY IDEOGRAPH-F9D3" },
	{ 0xF9D4, "CJK COMPATIBILITY IDEOGRAPH-F9D4" },
	{ 0xF9D5, "CJK COMPATIBILITY IDEOGRAPH-F9D5" },
	{ 0xF9D6, "CJK COMPATIBILITY IDEOGRAPH-F9D6" },
	{ 0xF9D7, "CJK COMPATIBILITY IDEOGRAPH-F9D7" },
	{ 0xF9D8, "CJK COMPATIBILITY IDEOGRAPH-F9D8" },
	{ 0xF9D9, "CJK COMPATIBILITY IDEOGRAPH-F9D9" },
	{ 0xF9DA, "CJK COMPATIBILITY IDEOGRAPH-F9DA" },
	{ 0xF9DB, "CJK COMPATIBILITY IDEOGRAPH-F9DB" },
	{ 0xF9DC, "CJK COMPATIBILITY IDEOGRAPH-F9DC" },
	{ 0xF9DD, "CJK COMPATIBILITY IDEOGRAPH-F9DD" },
	{ 0xF9DE, "CJK COMPATIBILITY IDEOGRAPH-F9DE" },
	{ 0xF9DF, "CJK COMPATIBILITY IDEOGRAPH-F9DF" },
	{ 0xF9E0, "CJK COMPATIBILITY IDEOGRAPH-F9E0" },
	{ 0xF9E1, "CJK COMPATIBILITY IDEOGRAPH-F9E1" },
	{ 0xF9E2, "CJK COMPATIBILITY IDEOGRAPH-F9E2" },
	{ 0xF9E3, "CJK COMPATIBILITY IDEOGRAPH-F9E3" },
	{ 0xF9E4, "CJK COMPATIBILITY IDEOGRAPH-F9E4" },
	{ 0xF9E5, "CJK COMPATIBILITY IDEOGRAPH-F9E5" },
	{ 0xF9E6, "CJK COMPATIBILITY IDEOGRAPH-F9E6" },
	{ 0xF9E7, "CJK COMPATIBILITY IDEOGRAPH-F9E7" },
	{ 0xF9E8, "CJK COMPATIBILITY IDEOGRAPH-F9E8" },
	{ 0xF9E9, "CJK COMPATIBILITY IDEOGRAPH-F9E9" },
	{ 0xF9EA, "CJK COMPATIBILITY IDEOGRAPH-F9EA" },
	{ 0xF9EB, "CJK COMPATIBILITY IDEOGRAPH-F9EB" },
	{ 0xF9EC, "CJK COMPATIBILITY IDEOGRAPH-F9EC" },
	{ 0xF9ED, "CJK COMPATIBILITY IDEOGRAPH-F9ED" },
	{ 0xF9EE, "CJK COMPATIBILITY IDEOGRAPH-F9EE" },
	{ 0xF9EF, "CJK COMPATIBILITY IDEOGRAPH-F9EF" },
	{ 0xF9F0, "CJK COMPATIBILITY IDEOGRAPH-F9F0" },
	{ 0xF9F1, "CJK COMPATIBILITY IDEOGRAPH-F9F1" },
	{ 0xF9F2, "CJK COMPATIBILITY IDEOGRAPH-F9F2" },
	{ 0xF9F3, "CJK COMPATIBILITY IDEOGRAPH-F9F3" },
	{ 0xF9F4, "CJK COMPATIBILITY IDEOGRAPH-F9F4" },
	{ 0xF9F5, "CJK COMPATIBILITY IDEOGRAPH-F9F5" },
	{ 0xF9F6, "CJK COMPATIBILITY IDEOGRAPH-F9F6" },
	{ 0xF9F7, "CJK COMPATIBILITY IDEOGRAPH-F9F7" },
	{ 0xF9F8, "CJK COMPATIBILITY IDEOGRAPH-F9F8" },
	{ 0xF9F9, "CJK COMPATIBILITY IDEOGRAPH-F9F9" },
	{ 0xF9FA, "CJK COMPATIBILITY IDEOGRAPH-F9FA" },
	{ 0xF9FB, "CJK COMPATIBILITY IDEOGRAPH-F9FB" },
	{ 0xF9FC, "CJK COMPATIBILITY IDEOGRAPH-F9FC" },
	{ 0xF9FD, "CJK COMPATIBILITY IDEOGRAPH-F9FD" },
	{ 0xF9FE, "CJK COMPATIBILITY IDEOGRAPH-F9FE" },
	{ 0xF9FF, "CJK COMPATIBILITY IDEOGRAPH-F9FF" },
	{ 0xFA00, "CJK COMPATIBILITY IDEOGRAPH-FA00" },
	{ 0xFA01, "CJK COMPATIBILITY IDEOGRAPH-FA01" },
	{ 0xFA02, "CJK COMPATIBILITY IDEOGRAPH-FA02" },
	{ 0xFA03, "CJK COMPATIBILITY IDEOGRAPH-FA03" },
	{ 0xFA04, "CJK COMPATIBILITY IDEOGRAPH-FA04" },
	{ 0xFA05, "CJK COMPATIBILITY IDEOGRAPH-FA05" },
	{ 0xFA06, "CJK COMPATIBILITY IDEOGRAPH-FA06" },
	{ 0xFA07, "CJK COMPATIBILITY IDEOGRAPH-FA07" },
	{ 0xFA08, "CJK COMPATIBILITY IDEOGRAPH-FA08" },
	{ 0xFA09, "CJK COMPATIBILITY IDEOGRAPH-FA09" },
	{ 0xFA0A, "CJK COMPATIBILITY IDEOGRAPH-FA0A" },
	{ 0xFA0B, "CJK COMPATIBILITY IDEOGRAPH-FA0B" },
	{ 0xFA0C, "CJK COMPATIBILITY IDEOGRAPH-FA0C" },
	{ 0xFA0D, "CJK COMPATIBILITY IDEOGRAPH-FA0D" },
	{ 0xFA0E, "CJK COMPATIBILITY IDEOGRAPH-FA0E" },
	{ 0xFA0F, "CJK COMPATIBILITY IDEOGRAPH-FA0F" },
	{ 0xFA10, "CJK COMPATIBILITY IDEOGRAPH-FA10" },
	{ 0xFA11, "CJK COMPATIBILITY IDEOGRAPH-FA11" },
	{ 0xFA12, "CJK COMPATIBILITY IDEOGRAPH-FA12" },
	{ 0xFA13, "CJK COMPATIBILITY IDEOGRAPH-FA13" },
	{ 0xFA14, "CJK COMPATIBILITY IDEOGRAPH-FA14" },
	{ 0xFA15, "CJK COMPATIBILITY IDEOGRAPH-FA15" },
	{ 0xFA16, "CJK COMPATIBILITY IDEOGRAPH-FA16" },
	{ 0xFA17, "CJK COMPATIBILITY IDEOGRAPH-FA17" },
	{ 0xFA18, "CJK COMPATIBILITY IDEOGRAPH-FA18" },
	{ 0xFA19, "CJK COMPATIBILITY IDEOGRAPH-FA19" },
	{ 0xFA1A, "CJK COMPATIBILITY IDEOGRAPH-FA1A" },
	{ 0xFA1B, "CJK COMPATIBILITY IDEOGRAPH-FA1B" },
	{ 0xFA1C, "CJK COMPATIBILITY IDEOGRAPH-FA1C" },
	{ 0xFA1D, "CJK COMPATIBILITY IDEOGRAPH-FA1D" },
	{ 0xFA1E, "CJK COMPATIBILITY IDEOGRAPH-FA1E" },
	{ 0xFA1F, "CJK COMPATIBILITY IDEOGRAPH-FA1F" },	/* * */
	{ 0xFA20, "CJK COMPATIBILITY IDEOGRAPH-FA20" },
	{ 0xFA21, "CJK COMPATIBILITY IDEOGRAPH-FA21" },
	{ 0xFA22, "CJK COMPATIBILITY IDEOGRAPH-FA22" },
	{ 0xFA23, "CJK COMPATIBILITY IDEOGRAPH-FA23" },	/* * */
	{ 0xFA24, "CJK COMPATIBILITY IDEOGRAPH-FA24" },
	{ 0xFA25, "CJK COMPATIBILITY IDEOGRAPH-FA25" },
	{ 0xFA26, "CJK COMPATIBILITY IDEOGRAPH-FA26" },
	{ 0xFA27, "CJK COMPATIBILITY IDEOGRAPH-FA27" },
	{ 0xFA28, "CJK COMPATIBILITY IDEOGRAPH-FA28" },
	{ 0xFA29, "CJK COMPATIBILITY IDEOGRAPH-FA29" },
	{ 0xFA2A, "CJK COMPATIBILITY IDEOGRAPH-FA2A" },
	{ 0xFA2B, "CJK COMPATIBILITY IDEOGRAPH-FA2B" },
	{ 0xFA2C, "CJK COMPATIBILITY IDEOGRAPH-FA2C" },
	{ 0xFA2D, "CJK COMPATIBILITY IDEOGRAPH-FA2D" },
	{ 0xFB00, "LATIN SMALL LIGATURE FF" },
	{ 0xFB01, "LATIN SMALL LIGATURE FI" },
	{ 0xFB02, "LATIN SMALL LIGATURE FL" },
	{ 0xFB03, "LATIN SMALL LIGATURE FFI" },
	{ 0xFB04, "LATIN SMALL LIGATURE FFL" },
	{ 0xFB05, "LATIN SMALL LIGATURE LONG S T" },
	{ 0xFB06, "LATIN SMALL LIGATURE ST" },
	{ 0xFB13, "ARMENIAN SMALL LIGATURE MEN NOW" },
	{ 0xFB14, "ARMENIAN SMALL LIGATURE MEN ECH" },
	{ 0xFB15, "ARMENIAN SMALL LIGATURE MEN INI" },
	{ 0xFB16, "ARMENIAN SMALL LIGATURE VEW NOW" },
	{ 0xFB17, "ARMENIAN SMALL LIGATURE MEN XEH" },
	{ 0xFB1D, "HEBREW LETTER YOD WITH HIRIQ" },
	{ 0xFB1E, "HEBREW POINT JUDEO-SPANISH VARIKA" },
	{ 0xFB1F, "HEBREW LIGATURE YIDDISH YOD YOD PATAH" },
	{ 0xFB20, "HEBREW LETTER ALTERNATIVE AYIN" },
	{ 0xFB21, "HEBREW LETTER WIDE ALEF" },
	{ 0xFB22, "HEBREW LETTER WIDE DALET" },
	{ 0xFB23, "HEBREW LETTER WIDE HE" },
	{ 0xFB24, "HEBREW LETTER WIDE KAF" },
	{ 0xFB25, "HEBREW LETTER WIDE LAMED" },
	{ 0xFB26, "HEBREW LETTER WIDE FINAL MEM" },
	{ 0xFB27, "HEBREW LETTER WIDE RESH" },
	{ 0xFB28, "HEBREW LETTER WIDE TAV" },
	{ 0xFB29, "HEBREW LETTER ALTERNATIVE PLUS SIGN" },
	{ 0xFB2A, "HEBREW LETTER SHIN WITH SHIN DOT" },
	{ 0xFB2B, "HEBREW LETTER SHIN WITH SIN DOT" },
	{ 0xFB2C, "HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT" },
	{ 0xFB2D, "HEBREW LETTER SHIN WITH DAGESH AND SIN DOT" },
	{ 0xFB2E, "HEBREW LETTER ALEF WITH PATAH" },
	{ 0xFB2F, "HEBREW LETTER ALEF WITH QAMATS" },
	{ 0xFB30, "HEBREW LETTER ALEF WITH MAPIQ" },
	{ 0xFB31, "HEBREW LETTER BET WITH DAGESH" },
	{ 0xFB32, "HEBREW LETTER GIMEL WITH DAGESH" },
	{ 0xFB33, "HEBREW LETTER DALET WITH DAGESH" },
	{ 0xFB34, "HEBREW LETTER HE WITH MAPIQ" },
	{ 0xFB35, "HEBREW LETTER VAV WITH DAGESH" },
	{ 0xFB36, "HEBREW LETTER ZAYIN WITH DAGESH" },
	{ 0xFB38, "HEBREW LETTER TET WITH DAGESH" },
	{ 0xFB39, "HEBREW LETTER YOD WITH DAGESH" },
	{ 0xFB3A, "HEBREW LETTER FINAL KAF WITH DAGESH" },
	{ 0xFB3B, "HEBREW LETTER KAF WITH DAGESH" },
	{ 0xFB3C, "HEBREW LETTER LAMED WITH DAGESH" },
	{ 0xFB3E, "HEBREW LETTER MEM WITH DAGESH" },
	{ 0xFB40, "HEBREW LETTER NUN WITH DAGESH" },
	{ 0xFB41, "HEBREW LETTER SAMEKH WITH DAGESH" },
	{ 0xFB43, "HEBREW LETTER FINAL PE WITH DAGESH" },
	{ 0xFB44, "HEBREW LETTER PE WITH DAGESH" },
	{ 0xFB46, "HEBREW LETTER TSADI WITH DAGESH" },
	{ 0xFB47, "HEBREW LETTER QOF WITH DAGESH" },
	{ 0xFB48, "HEBREW LETTER RESH WITH DAGESH" },
	{ 0xFB49, "HEBREW LETTER SHIN WITH DAGESH" },
	{ 0xFB4A, "HEBREW LETTER TAV WITH DAGESH" },
	{ 0xFB4B, "HEBREW LETTER VAV WITH HOLAM" },
	{ 0xFB4C, "HEBREW LETTER BET WITH RAFE" },
	{ 0xFB4D, "HEBREW LETTER KAF WITH RAFE" },
	{ 0xFB4E, "HEBREW LETTER PE WITH RAFE" },
	{ 0xFB4F, "HEBREW LIGATURE ALEF LAMED" },
	{ 0xFB50, "ARABIC LETTER ALEF WASLA ISOLATED FORM" },
	{ 0xFB51, "ARABIC LETTER ALEF WASLA FINAL FORM" },
	{ 0xFB52, "ARABIC LETTER BEEH ISOLATED FORM" },
	{ 0xFB53, "ARABIC LETTER BEEH FINAL FORM" },
	{ 0xFB54, "ARABIC LETTER BEEH INITIAL FORM" },
	{ 0xFB55, "ARABIC LETTER BEEH MEDIAL FORM" },
	{ 0xFB56, "ARABIC LETTER PEH ISOLATED FORM" },
	{ 0xFB57, "ARABIC LETTER PEH FINAL FORM" },
	{ 0xFB58, "ARABIC LETTER PEH INITIAL FORM" },
	{ 0xFB59, "ARABIC LETTER PEH MEDIAL FORM" },
	{ 0xFB5A, "ARABIC LETTER BEHEH ISOLATED FORM" },
	{ 0xFB5B, "ARABIC LETTER BEHEH FINAL FORM" },
	{ 0xFB5C, "ARABIC LETTER BEHEH INITIAL FORM" },
	{ 0xFB5D, "ARABIC LETTER BEHEH MEDIAL FORM" },
	{ 0xFB5E, "ARABIC LETTER TTEHEH ISOLATED FORM" },
	{ 0xFB5F, "ARABIC LETTER TTEHEH FINAL FORM" },
	{ 0xFB60, "ARABIC LETTER TTEHEH INITIAL FORM" },
	{ 0xFB61, "ARABIC LETTER TTEHEH MEDIAL FORM" },
	{ 0xFB62, "ARABIC LETTER TEHEH ISOLATED FORM" },
	{ 0xFB63, "ARABIC LETTER TEHEH FINAL FORM" },
	{ 0xFB64, "ARABIC LETTER TEHEH INITIAL FORM" },
	{ 0xFB65, "ARABIC LETTER TEHEH MEDIAL FORM" },
	{ 0xFB66, "ARABIC LETTER TTEH ISOLATED FORM" },
	{ 0xFB67, "ARABIC LETTER TTEH FINAL FORM" },
	{ 0xFB68, "ARABIC LETTER TTEH INITIAL FORM" },
	{ 0xFB69, "ARABIC LETTER TTEH MEDIAL FORM" },
	{ 0xFB6A, "ARABIC LETTER VEH ISOLATED FORM" },
	{ 0xFB6B, "ARABIC LETTER VEH FINAL FORM" },
	{ 0xFB6C, "ARABIC LETTER VEH INITIAL FORM" },
	{ 0xFB6D, "ARABIC LETTER VEH MEDIAL FORM" },
	{ 0xFB6E, "ARABIC LETTER PEHEH ISOLATED FORM" },
	{ 0xFB6F, "ARABIC LETTER PEHEH FINAL FORM" },
	{ 0xFB70, "ARABIC LETTER PEHEH INITIAL FORM" },
	{ 0xFB71, "ARABIC LETTER PEHEH MEDIAL FORM" },
	{ 0xFB72, "ARABIC LETTER DYEH ISOLATED FORM" },
	{ 0xFB73, "ARABIC LETTER DYEH FINAL FORM" },
	{ 0xFB74, "ARABIC LETTER DYEH INITIAL FORM" },
	{ 0xFB75, "ARABIC LETTER DYEH MEDIAL FORM" },
	{ 0xFB76, "ARABIC LETTER NYEH ISOLATED FORM" },
	{ 0xFB77, "ARABIC LETTER NYEH FINAL FORM" },
	{ 0xFB78, "ARABIC LETTER NYEH INITIAL FORM" },
	{ 0xFB79, "ARABIC LETTER NYEH MEDIAL FORM" },
	{ 0xFB7A, "ARABIC LETTER TCHEH ISOLATED FORM" },
	{ 0xFB7B, "ARABIC LETTER TCHEH FINAL FORM" },
	{ 0xFB7C, "ARABIC LETTER TCHEH INITIAL FORM" },
	{ 0xFB7D, "ARABIC LETTER TCHEH MEDIAL FORM" },
	{ 0xFB7E, "ARABIC LETTER TCHEHEH ISOLATED FORM" },
	{ 0xFB7F, "ARABIC LETTER TCHEHEH FINAL FORM" },
	{ 0xFB80, "ARABIC LETTER TCHEHEH INITIAL FORM" },
	{ 0xFB81, "ARABIC LETTER TCHEHEH MEDIAL FORM" },
	{ 0xFB82, "ARABIC LETTER DDAHAL ISOLATED FORM" },
	{ 0xFB83, "ARABIC LETTER DDAHAL FINAL FORM" },
	{ 0xFB84, "ARABIC LETTER DAHAL ISOLATED FORM" },
	{ 0xFB85, "ARABIC LETTER DAHAL FINAL FORM" },
	{ 0xFB86, "ARABIC LETTER DUL ISOLATED FORM" },
	{ 0xFB87, "ARABIC LETTER DUL FINAL FORM" },
	{ 0xFB88, "ARABIC LETTER DDAL ISOLATED FORM" },
	{ 0xFB89, "ARABIC LETTER DDAL FINAL FORM" },
	{ 0xFB8A, "ARABIC LETTER JEH ISOLATED FORM" },
	{ 0xFB8B, "ARABIC LETTER JEH FINAL FORM" },
	{ 0xFB8C, "ARABIC LETTER RREH ISOLATED FORM" },
	{ 0xFB8D, "ARABIC LETTER RREH FINAL FORM" },
	{ 0xFB8E, "ARABIC LETTER KEHEH ISOLATED FORM" },
	{ 0xFB8F, "ARABIC LETTER KEHEH FINAL FORM" },
	{ 0xFB90, "ARABIC LETTER KEHEH INITIAL FORM" },
	{ 0xFB91, "ARABIC LETTER KEHEH MEDIAL FORM" },
	{ 0xFB92, "ARABIC LETTER GAF ISOLATED FORM" },
	{ 0xFB93, "ARABIC LETTER GAF FINAL FORM" },
	{ 0xFB94, "ARABIC LETTER GAF INITIAL FORM" },
	{ 0xFB95, "ARABIC LETTER GAF MEDIAL FORM" },
	{ 0xFB96, "ARABIC LETTER GUEH ISOLATED FORM" },
	{ 0xFB97, "ARABIC LETTER GUEH FINAL FORM" },
	{ 0xFB98, "ARABIC LETTER GUEH INITIAL FORM" },
	{ 0xFB99, "ARABIC LETTER GUEH MEDIAL FORM" },
	{ 0xFB9A, "ARABIC LETTER NGOEH ISOLATED FORM" },
	{ 0xFB9B, "ARABIC LETTER NGOEH FINAL FORM" },
	{ 0xFB9C, "ARABIC LETTER NGOEH INITIAL FORM" },
	{ 0xFB9D, "ARABIC LETTER NGOEH MEDIAL FORM" },
	{ 0xFB9E, "ARABIC LETTER NOON GHUNNA ISOLATED FORM" },
	{ 0xFB9F, "ARABIC LETTER NOON GHUNNA FINAL FORM" },
	{ 0xFBA0, "ARABIC LETTER RNOON ISOLATED FORM" },
	{ 0xFBA1, "ARABIC LETTER RNOON FINAL FORM" },
	{ 0xFBA2, "ARABIC LETTER RNOON INITIAL FORM" },
	{ 0xFBA3, "ARABIC LETTER RNOON MEDIAL FORM" },
	{ 0xFBA4, "ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM" },
	{ 0xFBA5, "ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM" },
	{ 0xFBA6, "ARABIC LETTER HEH GOAL ISOLATED FORM" },
	{ 0xFBA7, "ARABIC LETTER HEH GOAL FINAL FORM" },
	{ 0xFBA8, "ARABIC LETTER HEH GOAL INITIAL FORM" },
	{ 0xFBA9, "ARABIC LETTER HEH GOAL MEDIAL FORM" },
	{ 0xFBAA, "ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM" },
	{ 0xFBAB, "ARABIC LETTER HEH DOACHASHMEE FINAL FORM" },
	{ 0xFBAC, "ARABIC LETTER HEH DOACHASHMEE INITIAL FORM" },
	{ 0xFBAD, "ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM" },
	{ 0xFBAE, "ARABIC LETTER YEH BARREE ISOLATED FORM" },
	{ 0xFBAF, "ARABIC LETTER YEH BARREE FINAL FORM" },
	{ 0xFBB0, "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFBB1, "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM" },
	{ 0xFBD3, "ARABIC LETTER NG ISOLATED FORM" },
	{ 0xFBD4, "ARABIC LETTER NG FINAL FORM" },
	{ 0xFBD5, "ARABIC LETTER NG INITIAL FORM" },
	{ 0xFBD6, "ARABIC LETTER NG MEDIAL FORM" },
	{ 0xFBD7, "ARABIC LETTER U ISOLATED FORM" },
	{ 0xFBD8, "ARABIC LETTER U FINAL FORM" },
	{ 0xFBD9, "ARABIC LETTER OE ISOLATED FORM" },
	{ 0xFBDA, "ARABIC LETTER OE FINAL FORM" },
	{ 0xFBDB, "ARABIC LETTER YU ISOLATED FORM" },
	{ 0xFBDC, "ARABIC LETTER YU FINAL FORM" },
	{ 0xFBDD, "ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFBDE, "ARABIC LETTER VE ISOLATED FORM" },
	{ 0xFBDF, "ARABIC LETTER VE FINAL FORM" },
	{ 0xFBE0, "ARABIC LETTER KIRGHIZ OE ISOLATED FORM" },
	{ 0xFBE1, "ARABIC LETTER KIRGHIZ OE FINAL FORM" },
	{ 0xFBE2, "ARABIC LETTER KIRGHIZ YU ISOLATED FORM" },
	{ 0xFBE3, "ARABIC LETTER KIRGHIZ YU FINAL FORM" },
	{ 0xFBE4, "ARABIC LETTER E ISOLATED FORM" },
	{ 0xFBE5, "ARABIC LETTER E FINAL FORM" },
	{ 0xFBE6, "ARABIC LETTER E INITIAL FORM" },
	{ 0xFBE7, "ARABIC LETTER E MEDIAL FORM" },
	{ 0xFBE8, "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM" },
	{ 0xFBE9, "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM" },
	{ 0xFBEA, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM" },
	{ 0xFBEB, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM" },
	{ 0xFBEC, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM" },
	{ 0xFBED, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM" },
	{ 0xFBEE, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM" },
	{ 0xFBEF, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM" },
	{ 0xFBF0, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM" },
	{ 0xFBF1, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM" },
	{ 0xFBF2, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM" },
	{ 0xFBF3, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM" },
	{ 0xFBF4, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM" },
	{ 0xFBF5, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM" },
	{ 0xFBF6, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM" },
	{ 0xFBF7, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM" },
	{ 0xFBF8, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM" },
	{ 0xFBF9, "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFBFA, "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFBFB, "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM" },
	{ 0xFBFC, "ARABIC LETTER FARSI YEH ISOLATED FORM" },
	{ 0xFBFD, "ARABIC LETTER FARSI YEH FINAL FORM" },
	{ 0xFBFE, "ARABIC LETTER FARSI YEH INITIAL FORM" },
	{ 0xFBFF, "ARABIC LETTER FARSI YEH MEDIAL FORM" },
	{ 0xFC00, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM" },
	{ 0xFC01, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM" },
	{ 0xFC02, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM" },
	{ 0xFC03, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC04, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM" },
	{ 0xFC05, "ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM" },
	{ 0xFC06, "ARABIC LIGATURE BEH WITH HAH ISOLATED FORM" },
	{ 0xFC07, "ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM" },
	{ 0xFC08, "ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM" },
	{ 0xFC09, "ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC0A, "ARABIC LIGATURE BEH WITH YEH ISOLATED FORM" },
	{ 0xFC0B, "ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM" },
	{ 0xFC0C, "ARABIC LIGATURE TEH WITH HAH ISOLATED FORM" },
	{ 0xFC0D, "ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM" },
	{ 0xFC0E, "ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM" },
	{ 0xFC0F, "ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC10, "ARABIC LIGATURE TEH WITH YEH ISOLATED FORM" },
	{ 0xFC11, "ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM" },
	{ 0xFC12, "ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM" },
	{ 0xFC13, "ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC14, "ARABIC LIGATURE THEH WITH YEH ISOLATED FORM" },
	{ 0xFC15, "ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM" },
	{ 0xFC16, "ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM" },
	{ 0xFC17, "ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM" },
	{ 0xFC18, "ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM" },
	{ 0xFC19, "ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM" },
	{ 0xFC1A, "ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM" },
	{ 0xFC1B, "ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM" },
	{ 0xFC1C, "ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM" },
	{ 0xFC1D, "ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM" },
	{ 0xFC1E, "ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM" },
	{ 0xFC1F, "ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM" },
	{ 0xFC20, "ARABIC LIGATURE SAD WITH HAH ISOLATED FORM" },
	{ 0xFC21, "ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM" },
	{ 0xFC22, "ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM" },
	{ 0xFC23, "ARABIC LIGATURE DAD WITH HAH ISOLATED FORM" },
	{ 0xFC24, "ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM" },
	{ 0xFC25, "ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM" },
	{ 0xFC26, "ARABIC LIGATURE TAH WITH HAH ISOLATED FORM" },
	{ 0xFC27, "ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM" },
	{ 0xFC28, "ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM" },
	{ 0xFC29, "ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM" },
	{ 0xFC2A, "ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM" },
	{ 0xFC2B, "ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM" },
	{ 0xFC2C, "ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM" },
	{ 0xFC2D, "ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM" },
	{ 0xFC2E, "ARABIC LIGATURE FEH WITH HAH ISOLATED FORM" },
	{ 0xFC2F, "ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM" },
	{ 0xFC30, "ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM" },
	{ 0xFC31, "ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC32, "ARABIC LIGATURE FEH WITH YEH ISOLATED FORM" },
	{ 0xFC33, "ARABIC LIGATURE QAF WITH HAH ISOLATED FORM" },
	{ 0xFC34, "ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM" },
	{ 0xFC35, "ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC36, "ARABIC LIGATURE QAF WITH YEH ISOLATED FORM" },
	{ 0xFC37, "ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM" },
	{ 0xFC38, "ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM" },
	{ 0xFC39, "ARABIC LIGATURE KAF WITH HAH ISOLATED FORM" },
	{ 0xFC3A, "ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM" },
	{ 0xFC3B, "ARABIC LIGATURE KAF WITH LAM ISOLATED FORM" },
	{ 0xFC3C, "ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM" },
	{ 0xFC3D, "ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC3E, "ARABIC LIGATURE KAF WITH YEH ISOLATED FORM" },
	{ 0xFC3F, "ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM" },
	{ 0xFC40, "ARABIC LIGATURE LAM WITH HAH ISOLATED FORM" },
	{ 0xFC41, "ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM" },
	{ 0xFC42, "ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM" },
	{ 0xFC43, "ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC44, "ARABIC LIGATURE LAM WITH YEH ISOLATED FORM" },
	{ 0xFC45, "ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM" },
	{ 0xFC46, "ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM" },
	{ 0xFC47, "ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM" },
	{ 0xFC48, "ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM" },
	{ 0xFC49, "ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC4A, "ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM" },
	{ 0xFC4B, "ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM" },
	{ 0xFC4C, "ARABIC LIGATURE NOON WITH HAH ISOLATED FORM" },
	{ 0xFC4D, "ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM" },
	{ 0xFC4E, "ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM" },
	{ 0xFC4F, "ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC50, "ARABIC LIGATURE NOON WITH YEH ISOLATED FORM" },
	{ 0xFC51, "ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM" },
	{ 0xFC52, "ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM" },
	{ 0xFC53, "ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC54, "ARABIC LIGATURE HEH WITH YEH ISOLATED FORM" },
	{ 0xFC55, "ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM" },
	{ 0xFC56, "ARABIC LIGATURE YEH WITH HAH ISOLATED FORM" },
	{ 0xFC57, "ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM" },
	{ 0xFC58, "ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM" },
	{ 0xFC59, "ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFC5A, "ARABIC LIGATURE YEH WITH YEH ISOLATED FORM" },
	{ 0xFC5B, "ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM" },
	{ 0xFC5C, "ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM" },
	{ 0xFC5D, "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM" },
	{ 0xFC5E, "ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM" },
	{ 0xFC5F, "ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM" },
	{ 0xFC60, "ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM" },
	{ 0xFC61, "ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM" },
	{ 0xFC62, "ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM" },
	{ 0xFC63, "ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM" },
	{ 0xFC64, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM" },
	{ 0xFC65, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM" },
	{ 0xFC66, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM" },
	{ 0xFC67, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM" },
	{ 0xFC68, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC69, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM" },
	{ 0xFC6A, "ARABIC LIGATURE BEH WITH REH FINAL FORM" },
	{ 0xFC6B, "ARABIC LIGATURE BEH WITH ZAIN FINAL FORM" },
	{ 0xFC6C, "ARABIC LIGATURE BEH WITH MEEM FINAL FORM" },
	{ 0xFC6D, "ARABIC LIGATURE BEH WITH NOON FINAL FORM" },
	{ 0xFC6E, "ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC6F, "ARABIC LIGATURE BEH WITH YEH FINAL FORM" },
	{ 0xFC70, "ARABIC LIGATURE TEH WITH REH FINAL FORM" },
	{ 0xFC71, "ARABIC LIGATURE TEH WITH ZAIN FINAL FORM" },
	{ 0xFC72, "ARABIC LIGATURE TEH WITH MEEM FINAL FORM" },
	{ 0xFC73, "ARABIC LIGATURE TEH WITH NOON FINAL FORM" },
	{ 0xFC74, "ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC75, "ARABIC LIGATURE TEH WITH YEH FINAL FORM" },
	{ 0xFC76, "ARABIC LIGATURE THEH WITH REH FINAL FORM" },
	{ 0xFC77, "ARABIC LIGATURE THEH WITH ZAIN FINAL FORM" },
	{ 0xFC78, "ARABIC LIGATURE THEH WITH MEEM FINAL FORM" },
	{ 0xFC79, "ARABIC LIGATURE THEH WITH NOON FINAL FORM" },
	{ 0xFC7A, "ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC7B, "ARABIC LIGATURE THEH WITH YEH FINAL FORM" },
	{ 0xFC7C, "ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC7D, "ARABIC LIGATURE FEH WITH YEH FINAL FORM" },
	{ 0xFC7E, "ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC7F, "ARABIC LIGATURE QAF WITH YEH FINAL FORM" },
	{ 0xFC80, "ARABIC LIGATURE KAF WITH ALEF FINAL FORM" },
	{ 0xFC81, "ARABIC LIGATURE KAF WITH LAM FINAL FORM" },
	{ 0xFC82, "ARABIC LIGATURE KAF WITH MEEM FINAL FORM" },
	{ 0xFC83, "ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC84, "ARABIC LIGATURE KAF WITH YEH FINAL FORM" },
	{ 0xFC85, "ARABIC LIGATURE LAM WITH MEEM FINAL FORM" },
	{ 0xFC86, "ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC87, "ARABIC LIGATURE LAM WITH YEH FINAL FORM" },
	{ 0xFC88, "ARABIC LIGATURE MEEM WITH ALEF FINAL FORM" },
	{ 0xFC89, "ARABIC LIGATURE MEEM WITH MEEM FINAL FORM" },
	{ 0xFC8A, "ARABIC LIGATURE NOON WITH REH FINAL FORM" },
	{ 0xFC8B, "ARABIC LIGATURE NOON WITH ZAIN FINAL FORM" },
	{ 0xFC8C, "ARABIC LIGATURE NOON WITH MEEM FINAL FORM" },
	{ 0xFC8D, "ARABIC LIGATURE NOON WITH NOON FINAL FORM" },
	{ 0xFC8E, "ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC8F, "ARABIC LIGATURE NOON WITH YEH FINAL FORM" },
	{ 0xFC90, "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM" },
	{ 0xFC91, "ARABIC LIGATURE YEH WITH REH FINAL FORM" },
	{ 0xFC92, "ARABIC LIGATURE YEH WITH ZAIN FINAL FORM" },
	{ 0xFC93, "ARABIC LIGATURE YEH WITH MEEM FINAL FORM" },
	{ 0xFC94, "ARABIC LIGATURE YEH WITH NOON FINAL FORM" },
	{ 0xFC95, "ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFC96, "ARABIC LIGATURE YEH WITH YEH FINAL FORM" },
	{ 0xFC97, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM" },
	{ 0xFC98, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM" },
	{ 0xFC99, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM" },
	{ 0xFC9A, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM" },
	{ 0xFC9B, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM" },
	{ 0xFC9C, "ARABIC LIGATURE BEH WITH JEEM INITIAL FORM" },
	{ 0xFC9D, "ARABIC LIGATURE BEH WITH HAH INITIAL FORM" },
	{ 0xFC9E, "ARABIC LIGATURE BEH WITH KHAH INITIAL FORM" },
	{ 0xFC9F, "ARABIC LIGATURE BEH WITH MEEM INITIAL FORM" },
	{ 0xFCA0, "ARABIC LIGATURE BEH WITH HEH INITIAL FORM" },
	{ 0xFCA1, "ARABIC LIGATURE TEH WITH JEEM INITIAL FORM" },
	{ 0xFCA2, "ARABIC LIGATURE TEH WITH HAH INITIAL FORM" },
	{ 0xFCA3, "ARABIC LIGATURE TEH WITH KHAH INITIAL FORM" },
	{ 0xFCA4, "ARABIC LIGATURE TEH WITH MEEM INITIAL FORM" },
	{ 0xFCA5, "ARABIC LIGATURE TEH WITH HEH INITIAL FORM" },
	{ 0xFCA6, "ARABIC LIGATURE THEH WITH MEEM INITIAL FORM" },
	{ 0xFCA7, "ARABIC LIGATURE JEEM WITH HAH INITIAL FORM" },
	{ 0xFCA8, "ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM" },
	{ 0xFCA9, "ARABIC LIGATURE HAH WITH JEEM INITIAL FORM" },
	{ 0xFCAA, "ARABIC LIGATURE HAH WITH MEEM INITIAL FORM" },
	{ 0xFCAB, "ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM" },
	{ 0xFCAC, "ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM" },
	{ 0xFCAD, "ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM" },
	{ 0xFCAE, "ARABIC LIGATURE SEEN WITH HAH INITIAL FORM" },
	{ 0xFCAF, "ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM" },
	{ 0xFCB0, "ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM" },
	{ 0xFCB1, "ARABIC LIGATURE SAD WITH HAH INITIAL FORM" },
	{ 0xFCB2, "ARABIC LIGATURE SAD WITH KHAH INITIAL FORM" },
	{ 0xFCB3, "ARABIC LIGATURE SAD WITH MEEM INITIAL FORM" },
	{ 0xFCB4, "ARABIC LIGATURE DAD WITH JEEM INITIAL FORM" },
	{ 0xFCB5, "ARABIC LIGATURE DAD WITH HAH INITIAL FORM" },
	{ 0xFCB6, "ARABIC LIGATURE DAD WITH KHAH INITIAL FORM" },
	{ 0xFCB7, "ARABIC LIGATURE DAD WITH MEEM INITIAL FORM" },
	{ 0xFCB8, "ARABIC LIGATURE TAH WITH HAH INITIAL FORM" },
	{ 0xFCB9, "ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM" },
	{ 0xFCBA, "ARABIC LIGATURE AIN WITH JEEM INITIAL FORM" },
	{ 0xFCBB, "ARABIC LIGATURE AIN WITH MEEM INITIAL FORM" },
	{ 0xFCBC, "ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM" },
	{ 0xFCBD, "ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM" },
	{ 0xFCBE, "ARABIC LIGATURE FEH WITH JEEM INITIAL FORM" },
	{ 0xFCBF, "ARABIC LIGATURE FEH WITH HAH INITIAL FORM" },
	{ 0xFCC0, "ARABIC LIGATURE FEH WITH KHAH INITIAL FORM" },
	{ 0xFCC1, "ARABIC LIGATURE FEH WITH MEEM INITIAL FORM" },
	{ 0xFCC2, "ARABIC LIGATURE QAF WITH HAH INITIAL FORM" },
	{ 0xFCC3, "ARABIC LIGATURE QAF WITH MEEM INITIAL FORM" },
	{ 0xFCC4, "ARABIC LIGATURE KAF WITH JEEM INITIAL FORM" },
	{ 0xFCC5, "ARABIC LIGATURE KAF WITH HAH INITIAL FORM" },
	{ 0xFCC6, "ARABIC LIGATURE KAF WITH KHAH INITIAL FORM" },
	{ 0xFCC7, "ARABIC LIGATURE KAF WITH LAM INITIAL FORM" },
	{ 0xFCC8, "ARABIC LIGATURE KAF WITH MEEM INITIAL FORM" },
	{ 0xFCC9, "ARABIC LIGATURE LAM WITH JEEM INITIAL FORM" },
	{ 0xFCCA, "ARABIC LIGATURE LAM WITH HAH INITIAL FORM" },
	{ 0xFCCB, "ARABIC LIGATURE LAM WITH KHAH INITIAL FORM" },
	{ 0xFCCC, "ARABIC LIGATURE LAM WITH MEEM INITIAL FORM" },
	{ 0xFCCD, "ARABIC LIGATURE LAM WITH HEH INITIAL FORM" },
	{ 0xFCCE, "ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM" },
	{ 0xFCCF, "ARABIC LIGATURE MEEM WITH HAH INITIAL FORM" },
	{ 0xFCD0, "ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM" },
	{ 0xFCD1, "ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM" },
	{ 0xFCD2, "ARABIC LIGATURE NOON WITH JEEM INITIAL FORM" },
	{ 0xFCD3, "ARABIC LIGATURE NOON WITH HAH INITIAL FORM" },
	{ 0xFCD4, "ARABIC LIGATURE NOON WITH KHAH INITIAL FORM" },
	{ 0xFCD5, "ARABIC LIGATURE NOON WITH MEEM INITIAL FORM" },
	{ 0xFCD6, "ARABIC LIGATURE NOON WITH HEH INITIAL FORM" },
	{ 0xFCD7, "ARABIC LIGATURE HEH WITH JEEM INITIAL FORM" },
	{ 0xFCD8, "ARABIC LIGATURE HEH WITH MEEM INITIAL FORM" },
	{ 0xFCD9, "ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM" },
	{ 0xFCDA, "ARABIC LIGATURE YEH WITH JEEM INITIAL FORM" },
	{ 0xFCDB, "ARABIC LIGATURE YEH WITH HAH INITIAL FORM" },
	{ 0xFCDC, "ARABIC LIGATURE YEH WITH KHAH INITIAL FORM" },
	{ 0xFCDD, "ARABIC LIGATURE YEH WITH MEEM INITIAL FORM" },
	{ 0xFCDE, "ARABIC LIGATURE YEH WITH HEH INITIAL FORM" },
	{ 0xFCDF, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM" },
	{ 0xFCE0, "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM" },
	{ 0xFCE1, "ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM" },
	{ 0xFCE2, "ARABIC LIGATURE BEH WITH HEH MEDIAL FORM" },
	{ 0xFCE3, "ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM" },
	{ 0xFCE4, "ARABIC LIGATURE TEH WITH HEH MEDIAL FORM" },
	{ 0xFCE5, "ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM" },
	{ 0xFCE6, "ARABIC LIGATURE THEH WITH HEH MEDIAL FORM" },
	{ 0xFCE7, "ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM" },
	{ 0xFCE8, "ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM" },
	{ 0xFCE9, "ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM" },
	{ 0xFCEA, "ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM" },
	{ 0xFCEB, "ARABIC LIGATURE KAF WITH LAM MEDIAL FORM" },
	{ 0xFCEC, "ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM" },
	{ 0xFCED, "ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM" },
	{ 0xFCEE, "ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM" },
	{ 0xFCEF, "ARABIC LIGATURE NOON WITH HEH MEDIAL FORM" },
	{ 0xFCF0, "ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM" },
	{ 0xFCF1, "ARABIC LIGATURE YEH WITH HEH MEDIAL FORM" },
	{ 0xFCF2, "ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM" },
	{ 0xFCF3, "ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM" },
	{ 0xFCF4, "ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM" },
	{ 0xFCF5, "ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFCF6, "ARABIC LIGATURE TAH WITH YEH ISOLATED FORM" },
	{ 0xFCF7, "ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFCF8, "ARABIC LIGATURE AIN WITH YEH ISOLATED FORM" },
	{ 0xFCF9, "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFCFA, "ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM" },
	{ 0xFCFB, "ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFCFC, "ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM" },
	{ 0xFCFD, "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFCFE, "ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM" },
	{ 0xFCFF, "ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFD00, "ARABIC LIGATURE HAH WITH YEH ISOLATED FORM" },
	{ 0xFD01, "ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFD02, "ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM" },
	{ 0xFD03, "ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFD04, "ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM" },
	{ 0xFD05, "ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFD06, "ARABIC LIGATURE SAD WITH YEH ISOLATED FORM" },
	{ 0xFD07, "ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM" },
	{ 0xFD08, "ARABIC LIGATURE DAD WITH YEH ISOLATED FORM" },
	{ 0xFD09, "ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM" },
	{ 0xFD0A, "ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM" },
	{ 0xFD0B, "ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM" },
	{ 0xFD0C, "ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM" },
	{ 0xFD0D, "ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM" },
	{ 0xFD0E, "ARABIC LIGATURE SEEN WITH REH ISOLATED FORM" },
	{ 0xFD0F, "ARABIC LIGATURE SAD WITH REH ISOLATED FORM" },
	{ 0xFD10, "ARABIC LIGATURE DAD WITH REH ISOLATED FORM" },
	{ 0xFD11, "ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD12, "ARABIC LIGATURE TAH WITH YEH FINAL FORM" },
	{ 0xFD13, "ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD14, "ARABIC LIGATURE AIN WITH YEH FINAL FORM" },
	{ 0xFD15, "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD16, "ARABIC LIGATURE GHAIN WITH YEH FINAL FORM" },
	{ 0xFD17, "ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD18, "ARABIC LIGATURE SEEN WITH YEH FINAL FORM" },
	{ 0xFD19, "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD1A, "ARABIC LIGATURE SHEEN WITH YEH FINAL FORM" },
	{ 0xFD1B, "ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD1C, "ARABIC LIGATURE HAH WITH YEH FINAL FORM" },
	{ 0xFD1D, "ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD1E, "ARABIC LIGATURE JEEM WITH YEH FINAL FORM" },
	{ 0xFD1F, "ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD20, "ARABIC LIGATURE KHAH WITH YEH FINAL FORM" },
	{ 0xFD21, "ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD22, "ARABIC LIGATURE SAD WITH YEH FINAL FORM" },
	{ 0xFD23, "ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD24, "ARABIC LIGATURE DAD WITH YEH FINAL FORM" },
	{ 0xFD25, "ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM" },
	{ 0xFD26, "ARABIC LIGATURE SHEEN WITH HAH FINAL FORM" },
	{ 0xFD27, "ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM" },
	{ 0xFD28, "ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM" },
	{ 0xFD29, "ARABIC LIGATURE SHEEN WITH REH FINAL FORM" },
	{ 0xFD2A, "ARABIC LIGATURE SEEN WITH REH FINAL FORM" },
	{ 0xFD2B, "ARABIC LIGATURE SAD WITH REH FINAL FORM" },
	{ 0xFD2C, "ARABIC LIGATURE DAD WITH REH FINAL FORM" },
	{ 0xFD2D, "ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM" },
	{ 0xFD2E, "ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM" },
	{ 0xFD2F, "ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM" },
	{ 0xFD30, "ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM" },
	{ 0xFD31, "ARABIC LIGATURE SEEN WITH HEH INITIAL FORM" },
	{ 0xFD32, "ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM" },
	{ 0xFD33, "ARABIC LIGATURE TAH WITH MEEM INITIAL FORM" },
	{ 0xFD34, "ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM" },
	{ 0xFD35, "ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM" },
	{ 0xFD36, "ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM" },
	{ 0xFD37, "ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM" },
	{ 0xFD38, "ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM" },
	{ 0xFD39, "ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM" },
	{ 0xFD3A, "ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM" },
	{ 0xFD3B, "ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM" },
	{ 0xFD3C, "ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM" },
	{ 0xFD3D, "ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM" },
	{ 0xFD3E, "ORNATE LEFT PARENTHESIS" },
	{ 0xFD3F, "ORNATE RIGHT PARENTHESIS" },
	{ 0xFD50, "ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM" },
	{ 0xFD51, "ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM" },
	{ 0xFD52, "ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM" },
	{ 0xFD53, "ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM" },
	{ 0xFD54, "ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM" },
	{ 0xFD55, "ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM" },
	{ 0xFD56, "ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFD57, "ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM" },
	{ 0xFD58, "ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM" },
	{ 0xFD59, "ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFD5A, "ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFD5B, "ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD5C, "ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM" },
	{ 0xFD5D, "ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM" },
	{ 0xFD5E, "ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD5F, "ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM" },
	{ 0xFD60, "ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFD61, "ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM" },
	{ 0xFD62, "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD63, "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD64, "ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM" },
	{ 0xFD65, "ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM" },
	{ 0xFD66, "ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD67, "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM" },
	{ 0xFD68, "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM" },
	{ 0xFD69, "ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFD6A, "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM" },
	{ 0xFD6B, "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM" },
	{ 0xFD6C, "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD6D, "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD6E, "ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD6F, "ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM" },
	{ 0xFD70, "ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM" },
	{ 0xFD71, "ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM" },
	{ 0xFD72, "ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFD73, "ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD74, "ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFD75, "ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM" },
	{ 0xFD76, "ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD77, "ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD78, "ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD79, "ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD7A, "ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFD7B, "ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD7C, "ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM" },
	{ 0xFD7D, "ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM" },
	{ 0xFD7E, "ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM" },
	{ 0xFD7F, "ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD80, "ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM" },
	{ 0xFD81, "ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM" },
	{ 0xFD82, "ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD83, "ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM" },
	{ 0xFD84, "ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM" },
	{ 0xFD85, "ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM" },
	{ 0xFD86, "ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM" },
	{ 0xFD87, "ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM" },
	{ 0xFD88, "ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFD89, "ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM" },
	{ 0xFD8A, "ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM" },
	{ 0xFD8B, "ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM" },
	{ 0xFD8C, "ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM" },
	{ 0xFD8D, "ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM" },
	{ 0xFD8E, "ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM" },
	{ 0xFD8F, "ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM" },
	{ 0xFD92, "ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM" },
	{ 0xFD93, "ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM" },
	{ 0xFD94, "ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD95, "ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM" },
	{ 0xFD96, "ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD97, "ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM" },
	{ 0xFD98, "ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM" },
	{ 0xFD99, "ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD9A, "ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFD9B, "ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFD9C, "ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFD9D, "ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFD9E, "ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM" },
	{ 0xFD9F, "ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDA0, "ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA1, "ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM" },
	{ 0xFDA2, "ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA3, "ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDA4, "ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA5, "ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDA6, "ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA7, "ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA8, "ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM" },
	{ 0xFDA9, "ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDAA, "ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDAB, "ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDAC, "ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDAD, "ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDAE, "ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDAF, "ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDB0, "ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDB1, "ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDB2, "ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDB3, "ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDB4, "ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM" },
	{ 0xFDB5, "ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM" },
	{ 0xFDB6, "ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDB7, "ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDB8, "ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM" },
	{ 0xFDB9, "ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM" },
	{ 0xFDBA, "ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM" },
	{ 0xFDBB, "ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM" },
	{ 0xFDBC, "ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM" },
	{ 0xFDBD, "ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM" },
	{ 0xFDBE, "ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDBF, "ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDC0, "ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDC1, "ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM" },
	{ 0xFDC2, "ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM" },
	{ 0xFDC3, "ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFDC4, "ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM" },
	{ 0xFDC5, "ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM" },
	{ 0xFDC6, "ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM" },
	{ 0xFDC7, "ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM" },
	{ 0xFDF0, "ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM" },
	{ 0xFDF1, "ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM" },
	{ 0xFDF2, "ARABIC LIGATURE ALLAH ISOLATED FORM" },
	{ 0xFDF3, "ARABIC LIGATURE AKBAR ISOLATED FORM" },
	{ 0xFDF4, "ARABIC LIGATURE MOHAMMAD ISOLATED FORM" },
	{ 0xFDF5, "ARABIC LIGATURE SALAM ISOLATED FORM" },
	{ 0xFDF6, "ARABIC LIGATURE RASOUL ISOLATED FORM" },
	{ 0xFDF7, "ARABIC LIGATURE ALAYHE ISOLATED FORM" },
	{ 0xFDF8, "ARABIC LIGATURE WASALLAM ISOLATED FORM" },
	{ 0xFDF9, "ARABIC LIGATURE SALLA ISOLATED FORM" },
	{ 0xFDFA, "ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM" },
	{ 0xFDFB, "ARABIC LIGATURE JALLAJALALOUHOU" },
	{ 0xFE20, "COMBINING LIGATURE LEFT HALF" },
	{ 0xFE21, "COMBINING LIGATURE RIGHT HALF" },
	{ 0xFE22, "COMBINING DOUBLE TILDE LEFT HALF" },
	{ 0xFE23, "COMBINING DOUBLE TILDE RIGHT HALF" },
	{ 0xFE30, "PRESENTATION FORM FOR VERTICAL TWO DOT LEADER" },
	{ 0xFE31, "PRESENTATION FORM FOR VERTICAL EM DASH" },
	{ 0xFE32, "PRESENTATION FORM FOR VERTICAL EN DASH" },
	{ 0xFE33, "PRESENTATION FORM FOR VERTICAL LOW LINE" },
	{ 0xFE34, "PRESENTATION FORM FOR VERTICAL WAVY LOW LINE" },
	{ 0xFE35, "PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS" },
	{ 0xFE36, "PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS" },
	{ 0xFE37, "PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET" },
	{ 0xFE38, "PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET" },
	{ 0xFE39, "PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET" },
	{ 0xFE3A, "PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET" },
	{ 0xFE3B, "PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET" },
	{ 0xFE3C, "PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET" },
	{ 0xFE3D, "PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET" },
	{ 0xFE3E, "PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET" },
	{ 0xFE3F, "PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET" },
	{ 0xFE40, "PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET" },
	{ 0xFE41, "PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET" },
	{ 0xFE42, "PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET" },
	{ 0xFE43, "PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET" },
	{ 0xFE44, "PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET" },
	{ 0xFE49, "DASHED OVERLINE" },
	{ 0xFE4A, "CENTRELINE OVERLINE" },
	{ 0xFE4B, "WAVY OVERLINE" },
	{ 0xFE4C, "DOUBLE WAVY OVERLINE" },
	{ 0xFE4D, "DASHED LOW LINE" },
	{ 0xFE4E, "CENTRELINE LOW LINE" },
	{ 0xFE4F, "WAVY LOW LINE" },
	{ 0xFE50, "SMALL COMMA" },
	{ 0xFE51, "SMALL IDEOGRAPHIC COMMA" },
	{ 0xFE52, "SMALL FULL STOP" },
	{ 0xFE54, "SMALL SEMICOLON" },
	{ 0xFE55, "SMALL COLON" },
	{ 0xFE56, "SMALL QUESTION MARK" },
	{ 0xFE57, "SMALL EXCLAMATION MARK" },
	{ 0xFE58, "SMALL EM DASH" },
	{ 0xFE59, "SMALL LEFT PARENTHESIS" },
	{ 0xFE5A, "SMALL RIGHT PARENTHESIS" },
	{ 0xFE5B, "SMALL LEFT CURLY BRACKET" },
	{ 0xFE5C, "SMALL RIGHT CURLY BRACKET" },
	{ 0xFE5D, "SMALL LEFT TORTOISE SHELL BRACKET" },
	{ 0xFE5E, "SMALL RIGHT TORTOISE SHELL BRACKET" },
	{ 0xFE5F, "SMALL NUMBER SIGN" },
	{ 0xFE60, "SMALL AMPERSAND" },
	{ 0xFE61, "SMALL ASTERISK" },
	{ 0xFE62, "SMALL PLUS SIGN" },
	{ 0xFE63, "SMALL HYPHEN-MINUS" },
	{ 0xFE64, "SMALL LESS-THAN SIGN" },
	{ 0xFE65, "SMALL GREATER-THAN SIGN" },
	{ 0xFE66, "SMALL EQUALS SIGN" },
	{ 0xFE68, "SMALL REVERSE SOLIDUS" },
	{ 0xFE69, "SMALL DOLLAR SIGN" },
	{ 0xFE6A, "SMALL PERCENT SIGN" },
	{ 0xFE6B, "SMALL COMMERCIAL AT" },
	{ 0xFE70, "ARABIC FATHATAN ISOLATED FORM" },
	{ 0xFE71, "ARABIC TATWEEL WITH FATHATAN ABOVE" },
	{ 0xFE72, "ARABIC DAMMATAN ISOLATED FORM" },
	{ 0xFE74, "ARABIC KASRATAN ISOLATED FORM" },
	{ 0xFE76, "ARABIC FATHA ISOLATED FORM" },
	{ 0xFE77, "ARABIC FATHA MEDIAL FORM" },
	{ 0xFE78, "ARABIC DAMMA ISOLATED FORM" },
	{ 0xFE79, "ARABIC DAMMA MEDIAL FORM" },
	{ 0xFE7A, "ARABIC KASRA ISOLATED FORM" },
	{ 0xFE7B, "ARABIC KASRA MEDIAL FORM" },
	{ 0xFE7C, "ARABIC SHADDA ISOLATED FORM" },
	{ 0xFE7D, "ARABIC SHADDA MEDIAL FORM" },
	{ 0xFE7E, "ARABIC SUKUN ISOLATED FORM" },
	{ 0xFE7F, "ARABIC SUKUN MEDIAL FORM" },
	{ 0xFE80, "ARABIC LETTER HAMZA ISOLATED FORM" },
	{ 0xFE81, "ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM" },
	{ 0xFE82, "ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM" },
	{ 0xFE83, "ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFE84, "ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM" },
	{ 0xFE85, "ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFE86, "ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM" },
	{ 0xFE87, "ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM" },
	{ 0xFE88, "ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM" },
	{ 0xFE89, "ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFE8A, "ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM" },
	{ 0xFE8B, "ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM" },
	{ 0xFE8C, "ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM" },
	{ 0xFE8D, "ARABIC LETTER ALEF ISOLATED FORM" },
	{ 0xFE8E, "ARABIC LETTER ALEF FINAL FORM" },
	{ 0xFE8F, "ARABIC LETTER BEH ISOLATED FORM" },
	{ 0xFE90, "ARABIC LETTER BEH FINAL FORM" },
	{ 0xFE91, "ARABIC LETTER BEH INITIAL FORM" },
	{ 0xFE92, "ARABIC LETTER BEH MEDIAL FORM" },
	{ 0xFE93, "ARABIC LETTER TEH MARBUTA ISOLATED FORM" },
	{ 0xFE94, "ARABIC LETTER TEH MARBUTA FINAL FORM" },
	{ 0xFE95, "ARABIC LETTER TEH ISOLATED FORM" },
	{ 0xFE96, "ARABIC LETTER TEH FINAL FORM" },
	{ 0xFE97, "ARABIC LETTER TEH INITIAL FORM" },
	{ 0xFE98, "ARABIC LETTER TEH MEDIAL FORM" },
	{ 0xFE99, "ARABIC LETTER THEH ISOLATED FORM" },
	{ 0xFE9A, "ARABIC LETTER THEH FINAL FORM" },
	{ 0xFE9B, "ARABIC LETTER THEH INITIAL FORM" },
	{ 0xFE9C, "ARABIC LETTER THEH MEDIAL FORM" },
	{ 0xFE9D, "ARABIC LETTER JEEM ISOLATED FORM" },
	{ 0xFE9E, "ARABIC LETTER JEEM FINAL FORM" },
	{ 0xFE9F, "ARABIC LETTER JEEM INITIAL FORM" },
	{ 0xFEA0, "ARABIC LETTER JEEM MEDIAL FORM" },
	{ 0xFEA1, "ARABIC LETTER HAH ISOLATED FORM" },
	{ 0xFEA2, "ARABIC LETTER HAH FINAL FORM" },
	{ 0xFEA3, "ARABIC LETTER HAH INITIAL FORM" },
	{ 0xFEA4, "ARABIC LETTER HAH MEDIAL FORM" },
	{ 0xFEA5, "ARABIC LETTER KHAH ISOLATED FORM" },
	{ 0xFEA6, "ARABIC LETTER KHAH FINAL FORM" },
	{ 0xFEA7, "ARABIC LETTER KHAH INITIAL FORM" },
	{ 0xFEA8, "ARABIC LETTER KHAH MEDIAL FORM" },
	{ 0xFEA9, "ARABIC LETTER DAL ISOLATED FORM" },
	{ 0xFEAA, "ARABIC LETTER DAL FINAL FORM" },
	{ 0xFEAB, "ARABIC LETTER THAL ISOLATED FORM" },
	{ 0xFEAC, "ARABIC LETTER THAL FINAL FORM" },
	{ 0xFEAD, "ARABIC LETTER REH ISOLATED FORM" },
	{ 0xFEAE, "ARABIC LETTER REH FINAL FORM" },
	{ 0xFEAF, "ARABIC LETTER ZAIN ISOLATED FORM" },
	{ 0xFEB0, "ARABIC LETTER ZAIN FINAL FORM" },
	{ 0xFEB1, "ARABIC LETTER SEEN ISOLATED FORM" },
	{ 0xFEB2, "ARABIC LETTER SEEN FINAL FORM" },
	{ 0xFEB3, "ARABIC LETTER SEEN INITIAL FORM" },
	{ 0xFEB4, "ARABIC LETTER SEEN MEDIAL FORM" },
	{ 0xFEB5, "ARABIC LETTER SHEEN ISOLATED FORM" },
	{ 0xFEB6, "ARABIC LETTER SHEEN FINAL FORM" },
	{ 0xFEB7, "ARABIC LETTER SHEEN INITIAL FORM" },
	{ 0xFEB8, "ARABIC LETTER SHEEN MEDIAL FORM" },
	{ 0xFEB9, "ARABIC LETTER SAD ISOLATED FORM" },
	{ 0xFEBA, "ARABIC LETTER SAD FINAL FORM" },
	{ 0xFEBB, "ARABIC LETTER SAD INITIAL FORM" },
	{ 0xFEBC, "ARABIC LETTER SAD MEDIAL FORM" },
	{ 0xFEBD, "ARABIC LETTER DAD ISOLATED FORM" },
	{ 0xFEBE, "ARABIC LETTER DAD FINAL FORM" },
	{ 0xFEBF, "ARABIC LETTER DAD INITIAL FORM" },
	{ 0xFEC0, "ARABIC LETTER DAD MEDIAL FORM" },
	{ 0xFEC1, "ARABIC LETTER TAH ISOLATED FORM" },
	{ 0xFEC2, "ARABIC LETTER TAH FINAL FORM" },
	{ 0xFEC3, "ARABIC LETTER TAH INITIAL FORM" },
	{ 0xFEC4, "ARABIC LETTER TAH MEDIAL FORM" },
	{ 0xFEC5, "ARABIC LETTER ZAH ISOLATED FORM" },
	{ 0xFEC6, "ARABIC LETTER ZAH FINAL FORM" },
	{ 0xFEC7, "ARABIC LETTER ZAH INITIAL FORM" },
	{ 0xFEC8, "ARABIC LETTER ZAH MEDIAL FORM" },
	{ 0xFEC9, "ARABIC LETTER AIN ISOLATED FORM" },
	{ 0xFECA, "ARABIC LETTER AIN FINAL FORM" },
	{ 0xFECB, "ARABIC LETTER AIN INITIAL FORM" },
	{ 0xFECC, "ARABIC LETTER AIN MEDIAL FORM" },
	{ 0xFECD, "ARABIC LETTER GHAIN ISOLATED FORM" },
	{ 0xFECE, "ARABIC LETTER GHAIN FINAL FORM" },
	{ 0xFECF, "ARABIC LETTER GHAIN INITIAL FORM" },
	{ 0xFED0, "ARABIC LETTER GHAIN MEDIAL FORM" },
	{ 0xFED1, "ARABIC LETTER FEH ISOLATED FORM" },
	{ 0xFED2, "ARABIC LETTER FEH FINAL FORM" },
	{ 0xFED3, "ARABIC LETTER FEH INITIAL FORM" },
	{ 0xFED4, "ARABIC LETTER FEH MEDIAL FORM" },
	{ 0xFED5, "ARABIC LETTER QAF ISOLATED FORM" },
	{ 0xFED6, "ARABIC LETTER QAF FINAL FORM" },
	{ 0xFED7, "ARABIC LETTER QAF INITIAL FORM" },
	{ 0xFED8, "ARABIC LETTER QAF MEDIAL FORM" },
	{ 0xFED9, "ARABIC LETTER KAF ISOLATED FORM" },
	{ 0xFEDA, "ARABIC LETTER KAF FINAL FORM" },
	{ 0xFEDB, "ARABIC LETTER KAF INITIAL FORM" },
	{ 0xFEDC, "ARABIC LETTER KAF MEDIAL FORM" },
	{ 0xFEDD, "ARABIC LETTER LAM ISOLATED FORM" },
	{ 0xFEDE, "ARABIC LETTER LAM FINAL FORM" },
	{ 0xFEDF, "ARABIC LETTER LAM INITIAL FORM" },
	{ 0xFEE0, "ARABIC LETTER LAM MEDIAL FORM" },
	{ 0xFEE1, "ARABIC LETTER MEEM ISOLATED FORM" },
	{ 0xFEE2, "ARABIC LETTER MEEM FINAL FORM" },
	{ 0xFEE3, "ARABIC LETTER MEEM INITIAL FORM" },
	{ 0xFEE4, "ARABIC LETTER MEEM MEDIAL FORM" },
	{ 0xFEE5, "ARABIC LETTER NOON ISOLATED FORM" },
	{ 0xFEE6, "ARABIC LETTER NOON FINAL FORM" },
	{ 0xFEE7, "ARABIC LETTER NOON INITIAL FORM" },
	{ 0xFEE8, "ARABIC LETTER NOON MEDIAL FORM" },
	{ 0xFEE9, "ARABIC LETTER HEH ISOLATED FORM" },
	{ 0xFEEA, "ARABIC LETTER HEH FINAL FORM" },
	{ 0xFEEB, "ARABIC LETTER HEH INITIAL FORM" },
	{ 0xFEEC, "ARABIC LETTER HEH MEDIAL FORM" },
	{ 0xFEED, "ARABIC LETTER WAW ISOLATED FORM" },
	{ 0xFEEE, "ARABIC LETTER WAW FINAL FORM" },
	{ 0xFEEF, "ARABIC LETTER ALEF MAKSURA ISOLATED FORM" },
	{ 0xFEF0, "ARABIC LETTER ALEF MAKSURA FINAL FORM" },
	{ 0xFEF1, "ARABIC LETTER YEH ISOLATED FORM" },
	{ 0xFEF2, "ARABIC LETTER YEH FINAL FORM" },
	{ 0xFEF3, "ARABIC LETTER YEH INITIAL FORM" },
	{ 0xFEF4, "ARABIC LETTER YEH MEDIAL FORM" },
	{ 0xFEF5, "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM" },
	{ 0xFEF6, "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM" },
	{ 0xFEF7, "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM" },
	{ 0xFEF8, "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM" },
	{ 0xFEF9, "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM" },
	{ 0xFEFA, "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM" },
	{ 0xFEFB, "ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM" },
	{ 0xFEFC, "ARABIC LIGATURE LAM WITH ALEF FINAL FORM" },
	{ 0xFEFF, "ZERO WIDTH NO-BREAK SPACE" },
	{ 0xFF01, "FULLWIDTH EXCLAMATION MARK" },
	{ 0xFF02, "FULLWIDTH QUOTATION MARK" },
	{ 0xFF03, "FULLWIDTH NUMBER SIGN" },
	{ 0xFF04, "FULLWIDTH DOLLAR SIGN" },
	{ 0xFF05, "FULLWIDTH PERCENT SIGN" },
	{ 0xFF06, "FULLWIDTH AMPERSAND" },
	{ 0xFF07, "FULLWIDTH APOSTROPHE" },
	{ 0xFF08, "FULLWIDTH LEFT PARENTHESIS" },
	{ 0xFF09, "FULLWIDTH RIGHT PARENTHESIS" },
	{ 0xFF0A, "FULLWIDTH ASTERISK" },
	{ 0xFF0B, "FULLWIDTH PLUS SIGN" },
	{ 0xFF0C, "FULLWIDTH COMMA" },
	{ 0xFF0D, "FULLWIDTH HYPHEN-MINUS" },
	{ 0xFF0E, "FULLWIDTH FULL STOP" },
	{ 0xFF0F, "FULLWIDTH SOLIDUS" },
	{ 0xFF10, "FULLWIDTH DIGIT ZERO" },
	{ 0xFF11, "FULLWIDTH DIGIT ONE" },
	{ 0xFF12, "FULLWIDTH DIGIT TWO" },
	{ 0xFF13, "FULLWIDTH DIGIT THREE" },
	{ 0xFF14, "FULLWIDTH DIGIT FOUR" },
	{ 0xFF15, "FULLWIDTH DIGIT FIVE" },
	{ 0xFF16, "FULLWIDTH DIGIT SIX" },
	{ 0xFF17, "FULLWIDTH DIGIT SEVEN" },
	{ 0xFF18, "FULLWIDTH DIGIT EIGHT" },
	{ 0xFF19, "FULLWIDTH DIGIT NINE" },
	{ 0xFF1A, "FULLWIDTH COLON" },
	{ 0xFF1B, "FULLWIDTH SEMICOLON" },
	{ 0xFF1C, "FULLWIDTH LESS-THAN SIGN" },
	{ 0xFF1D, "FULLWIDTH EQUALS SIGN" },
	{ 0xFF1E, "FULLWIDTH GREATER-THAN SIGN" },
	{ 0xFF1F, "FULLWIDTH QUESTION MARK" },
	{ 0xFF20, "FULLWIDTH COMMERCIAL AT" },
	{ 0xFF21, "FULLWIDTH LATIN CAPITAL LETTER A" },
	{ 0xFF22, "FULLWIDTH LATIN CAPITAL LETTER B" },
	{ 0xFF23, "FULLWIDTH LATIN CAPITAL LETTER C" },
	{ 0xFF24, "FULLWIDTH LATIN CAPITAL LETTER D" },
	{ 0xFF25, "FULLWIDTH LATIN CAPITAL LETTER E" },
	{ 0xFF26, "FULLWIDTH LATIN CAPITAL LETTER F" },
	{ 0xFF27, "FULLWIDTH LATIN CAPITAL LETTER G" },
	{ 0xFF28, "FULLWIDTH LATIN CAPITAL LETTER H" },
	{ 0xFF29, "FULLWIDTH LATIN CAPITAL LETTER I" },
	{ 0xFF2A, "FULLWIDTH LATIN CAPITAL LETTER J" },
	{ 0xFF2B, "FULLWIDTH LATIN CAPITAL LETTER K" },
	{ 0xFF2C, "FULLWIDTH LATIN CAPITAL LETTER L" },
	{ 0xFF2D, "FULLWIDTH LATIN CAPITAL LETTER M" },
	{ 0xFF2E, "FULLWIDTH LATIN CAPITAL LETTER N" },
	{ 0xFF2F, "FULLWIDTH LATIN CAPITAL LETTER O" },
	{ 0xFF30, "FULLWIDTH LATIN CAPITAL LETTER P" },
	{ 0xFF31, "FULLWIDTH LATIN CAPITAL LETTER Q" },
	{ 0xFF32, "FULLWIDTH LATIN CAPITAL LETTER R" },
	{ 0xFF33, "FULLWIDTH LATIN CAPITAL LETTER S" },
	{ 0xFF34, "FULLWIDTH LATIN CAPITAL LETTER T" },
	{ 0xFF35, "FULLWIDTH LATIN CAPITAL LETTER U" },
	{ 0xFF36, "FULLWIDTH LATIN CAPITAL LETTER V" },
	{ 0xFF37, "FULLWIDTH LATIN CAPITAL LETTER W" },
	{ 0xFF38, "FULLWIDTH LATIN CAPITAL LETTER X" },
	{ 0xFF39, "FULLWIDTH LATIN CAPITAL LETTER Y" },
	{ 0xFF3A, "FULLWIDTH LATIN CAPITAL LETTER Z" },
	{ 0xFF3B, "FULLWIDTH LEFT SQUARE BRACKET" },
	{ 0xFF3C, "FULLWIDTH REVERSE SOLIDUS" },
	{ 0xFF3D, "FULLWIDTH RIGHT SQUARE BRACKET" },
	{ 0xFF3E, "FULLWIDTH CIRCUMFLEX ACCENT" },
	{ 0xFF3F, "FULLWIDTH LOW LINE" },
	{ 0xFF40, "FULLWIDTH GRAVE ACCENT" },
	{ 0xFF41, "FULLWIDTH LATIN SMALL LETTER A" },
	{ 0xFF42, "FULLWIDTH LATIN SMALL LETTER B" },
	{ 0xFF43, "FULLWIDTH LATIN SMALL LETTER C" },
	{ 0xFF44, "FULLWIDTH LATIN SMALL LETTER D" },
	{ 0xFF45, "FULLWIDTH LATIN SMALL LETTER E" },
	{ 0xFF46, "FULLWIDTH LATIN SMALL LETTER F" },
	{ 0xFF47, "FULLWIDTH LATIN SMALL LETTER G" },
	{ 0xFF48, "FULLWIDTH LATIN SMALL LETTER H" },
	{ 0xFF49, "FULLWIDTH LATIN SMALL LETTER I" },
	{ 0xFF4A, "FULLWIDTH LATIN SMALL LETTER J" },
	{ 0xFF4B, "FULLWIDTH LATIN SMALL LETTER K" },
	{ 0xFF4C, "FULLWIDTH LATIN SMALL LETTER L" },
	{ 0xFF4D, "FULLWIDTH LATIN SMALL LETTER M" },
	{ 0xFF4E, "FULLWIDTH LATIN SMALL LETTER N" },
	{ 0xFF4F, "FULLWIDTH LATIN SMALL LETTER O" },
	{ 0xFF50, "FULLWIDTH LATIN SMALL LETTER P" },
	{ 0xFF51, "FULLWIDTH LATIN SMALL LETTER Q" },
	{ 0xFF52, "FULLWIDTH LATIN SMALL LETTER R" },
	{ 0xFF53, "FULLWIDTH LATIN SMALL LETTER S" },
	{ 0xFF54, "FULLWIDTH LATIN SMALL LETTER T" },
	{ 0xFF55, "FULLWIDTH LATIN SMALL LETTER U" },
	{ 0xFF56, "FULLWIDTH LATIN SMALL LETTER V" },
	{ 0xFF57, "FULLWIDTH LATIN SMALL LETTER W" },
	{ 0xFF58, "FULLWIDTH LATIN SMALL LETTER X" },
	{ 0xFF59, "FULLWIDTH LATIN SMALL LETTER Y" },
	{ 0xFF5A, "FULLWIDTH LATIN SMALL LETTER Z" },
	{ 0xFF5B, "FULLWIDTH LEFT CURLY BRACKET" },
	{ 0xFF5C, "FULLWIDTH VERTICAL LINE" },
	{ 0xFF5D, "FULLWIDTH RIGHT CURLY BRACKET" },
	{ 0xFF5E, "FULLWIDTH TILDE" },
	{ 0xFF61, "HALFWIDTH IDEOGRAPHIC FULL STOP" },
	{ 0xFF62, "HALFWIDTH LEFT CORNER BRACKET" },
	{ 0xFF63, "HALFWIDTH RIGHT CORNER BRACKET" },
	{ 0xFF64, "HALFWIDTH IDEOGRAPHIC COMMA" },
	{ 0xFF65, "HALFWIDTH KATAKANA MIDDLE DOT" },
	{ 0xFF66, "HALFWIDTH KATAKANA LETTER WO" },
	{ 0xFF67, "HALFWIDTH KATAKANA LETTER SMALL A" },
	{ 0xFF68, "HALFWIDTH KATAKANA LETTER SMALL I" },
	{ 0xFF69, "HALFWIDTH KATAKANA LETTER SMALL U" },
	{ 0xFF6A, "HALFWIDTH KATAKANA LETTER SMALL E" },
	{ 0xFF6B, "HALFWIDTH KATAKANA LETTER SMALL O" },
	{ 0xFF6C, "HALFWIDTH KATAKANA LETTER SMALL YA" },
	{ 0xFF6D, "HALFWIDTH KATAKANA LETTER SMALL YU" },
	{ 0xFF6E, "HALFWIDTH KATAKANA LETTER SMALL YO" },
	{ 0xFF6F, "HALFWIDTH KATAKANA LETTER SMALL TU" },
	{ 0xFF70, "HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK" },
	{ 0xFF71, "HALFWIDTH KATAKANA LETTER A" },
	{ 0xFF72, "HALFWIDTH KATAKANA LETTER I" },
	{ 0xFF73, "HALFWIDTH KATAKANA LETTER U" },
	{ 0xFF74, "HALFWIDTH KATAKANA LETTER E" },
	{ 0xFF75, "HALFWIDTH KATAKANA LETTER O" },
	{ 0xFF76, "HALFWIDTH KATAKANA LETTER KA" },
	{ 0xFF77, "HALFWIDTH KATAKANA LETTER KI" },
	{ 0xFF78, "HALFWIDTH KATAKANA LETTER KU" },
	{ 0xFF79, "HALFWIDTH KATAKANA LETTER KE" },
	{ 0xFF7A, "HALFWIDTH KATAKANA LETTER KO" },
	{ 0xFF7B, "HALFWIDTH KATAKANA LETTER SA" },
	{ 0xFF7C, "HALFWIDTH KATAKANA LETTER SI" },
	{ 0xFF7D, "HALFWIDTH KATAKANA LETTER SU" },
	{ 0xFF7E, "HALFWIDTH KATAKANA LETTER SE" },
	{ 0xFF7F, "HALFWIDTH KATAKANA LETTER SO" },
	{ 0xFF80, "HALFWIDTH KATAKANA LETTER TA" },
	{ 0xFF81, "HALFWIDTH KATAKANA LETTER TI" },
	{ 0xFF82, "HALFWIDTH KATAKANA LETTER TU" },
	{ 0xFF83, "HALFWIDTH KATAKANA LETTER TE" },
	{ 0xFF84, "HALFWIDTH KATAKANA LETTER TO" },
	{ 0xFF85, "HALFWIDTH KATAKANA LETTER NA" },
	{ 0xFF86, "HALFWIDTH KATAKANA LETTER NI" },
	{ 0xFF87, "HALFWIDTH KATAKANA LETTER NU" },
	{ 0xFF88, "HALFWIDTH KATAKANA LETTER NE" },
	{ 0xFF89, "HALFWIDTH KATAKANA LETTER NO" },
	{ 0xFF8A, "HALFWIDTH KATAKANA LETTER HA" },
	{ 0xFF8B, "HALFWIDTH KATAKANA LETTER HI" },
	{ 0xFF8C, "HALFWIDTH KATAKANA LETTER HU" },
	{ 0xFF8D, "HALFWIDTH KATAKANA LETTER HE" },
	{ 0xFF8E, "HALFWIDTH KATAKANA LETTER HO" },
	{ 0xFF8F, "HALFWIDTH KATAKANA LETTER MA" },
	{ 0xFF90, "HALFWIDTH KATAKANA LETTER MI" },
	{ 0xFF91, "HALFWIDTH KATAKANA LETTER MU" },
	{ 0xFF92, "HALFWIDTH KATAKANA LETTER ME" },
	{ 0xFF93, "HALFWIDTH KATAKANA LETTER MO" },
	{ 0xFF94, "HALFWIDTH KATAKANA LETTER YA" },
	{ 0xFF95, "HALFWIDTH KATAKANA LETTER YU" },
	{ 0xFF96, "HALFWIDTH KATAKANA LETTER YO" },
	{ 0xFF97, "HALFWIDTH KATAKANA LETTER RA" },
	{ 0xFF98, "HALFWIDTH KATAKANA LETTER RI" },
	{ 0xFF99, "HALFWIDTH KATAKANA LETTER RU" },
	{ 0xFF9A, "HALFWIDTH KATAKANA LETTER RE" },
	{ 0xFF9B, "HALFWIDTH KATAKANA LETTER RO" },
	{ 0xFF9C, "HALFWIDTH KATAKANA LETTER WA" },
	{ 0xFF9D, "HALFWIDTH KATAKANA LETTER N" },
	{ 0xFF9E, "HALFWIDTH KATAKANA VOICED SOUND MARK" },	/* halfwidth katakana-hiragana voiced sound mark */
	{ 0xFF9F, "HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK" },	/* halfwidth katakana-hiragana semi-voiced sound mark */
	{ 0xFFA0, "HALFWIDTH HANGUL FILLER" },
	{ 0xFFA1, "HALFWIDTH HANGUL LETTER KIYEOK" },
	{ 0xFFA2, "HALFWIDTH HANGUL LETTER SSANGKIYEOK" },
	{ 0xFFA3, "HALFWIDTH HANGUL LETTER KIYEOK-SIOS" },
	{ 0xFFA4, "HALFWIDTH HANGUL LETTER NIEUN" },
	{ 0xFFA5, "HALFWIDTH HANGUL LETTER NIEUN-CIEUC" },
	{ 0xFFA6, "HALFWIDTH HANGUL LETTER NIEUN-HIEUH" },
	{ 0xFFA7, "HALFWIDTH HANGUL LETTER TIKEUT" },
	{ 0xFFA8, "HALFWIDTH HANGUL LETTER SSANGTIKEUT" },
	{ 0xFFA9, "HALFWIDTH HANGUL LETTER RIEUL" },
	{ 0xFFAA, "HALFWIDTH HANGUL LETTER RIEUL-KIYEOK" },
	{ 0xFFAB, "HALFWIDTH HANGUL LETTER RIEUL-MIEUM" },
	{ 0xFFAC, "HALFWIDTH HANGUL LETTER RIEUL-PIEUP" },
	{ 0xFFAD, "HALFWIDTH HANGUL LETTER RIEUL-SIOS" },
	{ 0xFFAE, "HALFWIDTH HANGUL LETTER RIEUL-THIEUTH" },
	{ 0xFFAF, "HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH" },
	{ 0xFFB0, "HALFWIDTH HANGUL LETTER RIEUL-HIEUH" },
	{ 0xFFB1, "HALFWIDTH HANGUL LETTER MIEUM" },
	{ 0xFFB2, "HALFWIDTH HANGUL LETTER PIEUP" },
	{ 0xFFB3, "HALFWIDTH HANGUL LETTER SSANGPIEUP" },
	{ 0xFFB4, "HALFWIDTH HANGUL LETTER PIEUP-SIOS" },
	{ 0xFFB5, "HALFWIDTH HANGUL LETTER SIOS" },
	{ 0xFFB6, "HALFWIDTH HANGUL LETTER SSANGSIOS" },
	{ 0xFFB7, "HALFWIDTH HANGUL LETTER IEUNG" },
	{ 0xFFB8, "HALFWIDTH HANGUL LETTER CIEUC" },
	{ 0xFFB9, "HALFWIDTH HANGUL LETTER SSANGCIEUC" },
	{ 0xFFBA, "HALFWIDTH HANGUL LETTER CHIEUCH" },
	{ 0xFFBB, "HALFWIDTH HANGUL LETTER KHIEUKH" },
	{ 0xFFBC, "HALFWIDTH HANGUL LETTER THIEUTH" },
	{ 0xFFBD, "HALFWIDTH HANGUL LETTER PHIEUPH" },
	{ 0xFFBE, "HALFWIDTH HANGUL LETTER HIEUH" },
	{ 0xFFC2, "HALFWIDTH HANGUL LETTER A" },
	{ 0xFFC3, "HALFWIDTH HANGUL LETTER AE" },
	{ 0xFFC4, "HALFWIDTH HANGUL LETTER YA" },
	{ 0xFFC5, "HALFWIDTH HANGUL LETTER YAE" },
	{ 0xFFC6, "HALFWIDTH HANGUL LETTER EO" },
	{ 0xFFC7, "HALFWIDTH HANGUL LETTER E" },
	{ 0xFFCA, "HALFWIDTH HANGUL LETTER YEO" },
	{ 0xFFCB, "HALFWIDTH HANGUL LETTER YE" },
	{ 0xFFCC, "HALFWIDTH HANGUL LETTER O" },
	{ 0xFFCD, "HALFWIDTH HANGUL LETTER WA" },
	{ 0xFFCE, "HALFWIDTH HANGUL LETTER WAE" },
	{ 0xFFCF, "HALFWIDTH HANGUL LETTER OE" },
	{ 0xFFD2, "HALFWIDTH HANGUL LETTER YO" },
	{ 0xFFD3, "HALFWIDTH HANGUL LETTER U" },
	{ 0xFFD4, "HALFWIDTH HANGUL LETTER WEO" },
	{ 0xFFD5, "HALFWIDTH HANGUL LETTER WE" },
	{ 0xFFD6, "HALFWIDTH HANGUL LETTER WI" },
	{ 0xFFD7, "HALFWIDTH HANGUL LETTER YU" },
	{ 0xFFDA, "HALFWIDTH HANGUL LETTER EU" },
	{ 0xFFDB, "HALFWIDTH HANGUL LETTER YI" },
	{ 0xFFDC, "HALFWIDTH HANGUL LETTER I" },
	{ 0xFFE0, "FULLWIDTH CENT SIGN" },
	{ 0xFFE1, "FULLWIDTH POUND SIGN" },
	{ 0xFFE2, "FULLWIDTH NOT SIGN" },
	{ 0xFFE3, "FULLWIDTH MACRON" },	/* * */
	{ 0xFFE4, "FULLWIDTH BROKEN BAR" },
	{ 0xFFE5, "FULLWIDTH YEN SIGN" },
	{ 0xFFE6, "FULLWIDTH WON SIGN" },
	{ 0xFFE8, "HALFWIDTH FORMS LIGHT VERTICAL" },
	{ 0xFFE9, "HALFWIDTH LEFTWARDS ARROW" },
	{ 0xFFEA, "HALFWIDTH UPWARDS ARROW" },
	{ 0xFFEB, "HALFWIDTH RIGHTWARDS ARROW" },
	{ 0xFFEC, "HALFWIDTH DOWNWARDS ARROW" },
	{ 0xFFED, "HALFWIDTH BLACK SQUARE" },
	{ 0xFFEE, "HALFWIDTH WHITE CIRCLE" },
	{ 0xFFF9, "INTERLINEAR ANNOTATION ANCHOR" },
	{ 0xFFFA, "INTERLINEAR ANNOTATION SEPARATOR" },
	{ 0xFFFB, "INTERLINEAR ANNOTATION TERMINATOR" },
	{ 0xFFFC, "OBJECT REPLACEMENT CHARACTER" },
	{ 0xFFFD, "REPLACEMENT CHARACTER" },
	{ 0x10300, "OLD ITALIC LETTER A" },
	{ 0x10301, "OLD ITALIC LETTER BE" },
	{ 0x10302, "OLD ITALIC LETTER KE" },
	{ 0x10303, "OLD ITALIC LETTER DE" },
	{ 0x10304, "OLD ITALIC LETTER E" },
	{ 0x10305, "OLD ITALIC LETTER VE" },
	{ 0x10306, "OLD ITALIC LETTER ZE" },
	{ 0x10307, "OLD ITALIC LETTER HE" },
	{ 0x10308, "OLD ITALIC LETTER THE" },
	{ 0x10309, "OLD ITALIC LETTER I" },
	{ 0x1030A, "OLD ITALIC LETTER KA" },
	{ 0x1030B, "OLD ITALIC LETTER EL" },
	{ 0x1030C, "OLD ITALIC LETTER EM" },
	{ 0x1030D, "OLD ITALIC LETTER EN" },
	{ 0x1030E, "OLD ITALIC LETTER ESH" },
	{ 0x1030F, "OLD ITALIC LETTER O" },	/* Faliscan */
	{ 0x10310, "OLD ITALIC LETTER PE" },
	{ 0x10311, "OLD ITALIC LETTER SHE" },
	{ 0x10312, "OLD ITALIC LETTER KU" },
	{ 0x10313, "OLD ITALIC LETTER ER" },
	{ 0x10314, "OLD ITALIC LETTER ES" },
	{ 0x10315, "OLD ITALIC LETTER TE" },
	{ 0x10316, "OLD ITALIC LETTER U" },
	{ 0x10317, "OLD ITALIC LETTER EKS" },	/* Faliscan */
	{ 0x10318, "OLD ITALIC LETTER PHE" },
	{ 0x10319, "OLD ITALIC LETTER KHE" },
	{ 0x1031A, "OLD ITALIC LETTER EF" },
	{ 0x1031B, "OLD ITALIC LETTER ERS" },	/* Umbrian */
	{ 0x1031C, "OLD ITALIC LETTER CHE" },	/* Umbrian */
	{ 0x1031D, "OLD ITALIC LETTER II" },	/* Oscan */
	{ 0x1031E, "OLD ITALIC LETTER UU" },	/* Oscan */
	{ 0x10320, "OLD ITALIC NUMERAL ONE" },
	{ 0x10321, "OLD ITALIC NUMERAL FIVE" },
	{ 0x10322, "OLD ITALIC NUMERAL TEN" },
	{ 0x10323, "OLD ITALIC NUMERAL FIFTY" },
	{ 0x10330, "GOTHIC LETTER AHSA" },
	{ 0x10331, "GOTHIC LETTER BAIRKAN" },
	{ 0x10332, "GOTHIC LETTER GIBA" },
	{ 0x10333, "GOTHIC LETTER DAGS" },
	{ 0x10334, "GOTHIC LETTER AIHVUS" },
	{ 0x10335, "GOTHIC LETTER QAIRTHRA" },
	{ 0x10336, "GOTHIC LETTER IUJA" },
	{ 0x10337, "GOTHIC LETTER HAGL" },
	{ 0x10338, "GOTHIC LETTER THIUTH" },
	{ 0x10339, "GOTHIC LETTER EIS" },
	{ 0x1033A, "GOTHIC LETTER KUSMA" },
	{ 0x1033B, "GOTHIC LETTER LAGUS" },
	{ 0x1033C, "GOTHIC LETTER MANNA" },
	{ 0x1033D, "GOTHIC LETTER NAUTHS" },
	{ 0x1033E, "GOTHIC LETTER JER" },
	{ 0x1033F, "GOTHIC LETTER URUS" },
	{ 0x10340, "GOTHIC LETTER PAIRTHRA" },
	{ 0x10341, "GOTHIC LETTER NINETY" },
	{ 0x10342, "GOTHIC LETTER RAIDA" },
	{ 0x10343, "GOTHIC LETTER SAUIL" },
	{ 0x10344, "GOTHIC LETTER TEIWS" },
	{ 0x10345, "GOTHIC LETTER WINJA" },
	{ 0x10346, "GOTHIC LETTER FAIHU" },
	{ 0x10347, "GOTHIC LETTER IGGWS" },
	{ 0x10348, "GOTHIC LETTER HWAIR" },
	{ 0x10349, "GOTHIC LETTER OTHAL" },
	{ 0x1034A, "GOTHIC LETTER NINE HUNDRED" },
	{ 0x10400, "DESERET CAPITAL LETTER LONG I" },
	{ 0x10401, "DESERET CAPITAL LETTER LONG E" },
	{ 0x10402, "DESERET CAPITAL LETTER LONG A" },
	{ 0x10403, "DESERET CAPITAL LETTER LONG AH" },
	{ 0x10404, "DESERET CAPITAL LETTER LONG O" },
	{ 0x10405, "DESERET CAPITAL LETTER LONG OO" },
	{ 0x10406, "DESERET CAPITAL LETTER SHORT I" },
	{ 0x10407, "DESERET CAPITAL LETTER SHORT E" },
	{ 0x10408, "DESERET CAPITAL LETTER SHORT A" },
	{ 0x10409, "DESERET CAPITAL LETTER SHORT AH" },
	{ 0x1040A, "DESERET CAPITAL LETTER SHORT O" },
	{ 0x1040B, "DESERET CAPITAL LETTER SHORT OO" },
	{ 0x1040C, "DESERET CAPITAL LETTER AY" },
	{ 0x1040D, "DESERET CAPITAL LETTER OW" },
	{ 0x1040E, "DESERET CAPITAL LETTER WU" },
	{ 0x1040F, "DESERET CAPITAL LETTER YEE" },
	{ 0x10410, "DESERET CAPITAL LETTER H" },
	{ 0x10411, "DESERET CAPITAL LETTER PEE" },
	{ 0x10412, "DESERET CAPITAL LETTER BEE" },
	{ 0x10413, "DESERET CAPITAL LETTER TEE" },
	{ 0x10414, "DESERET CAPITAL LETTER DEE" },
	{ 0x10415, "DESERET CAPITAL LETTER CHEE" },
	{ 0x10416, "DESERET CAPITAL LETTER JEE" },
	{ 0x10417, "DESERET CAPITAL LETTER KAY" },
	{ 0x10418, "DESERET CAPITAL LETTER GAY" },
	{ 0x10419, "DESERET CAPITAL LETTER EF" },
	{ 0x1041A, "DESERET CAPITAL LETTER VEE" },
	{ 0x1041B, "DESERET CAPITAL LETTER ETH" },
	{ 0x1041C, "DESERET CAPITAL LETTER THEE" },
	{ 0x1041D, "DESERET CAPITAL LETTER ES" },
	{ 0x1041E, "DESERET CAPITAL LETTER ZEE" },
	{ 0x1041F, "DESERET CAPITAL LETTER ESH" },
	{ 0x10420, "DESERET CAPITAL LETTER ZHEE" },
	{ 0x10421, "DESERET CAPITAL LETTER ER" },
	{ 0x10422, "DESERET CAPITAL LETTER EL" },
	{ 0x10423, "DESERET CAPITAL LETTER EM" },
	{ 0x10424, "DESERET CAPITAL LETTER EN" },
	{ 0x10425, "DESERET CAPITAL LETTER ENG" },
	{ 0x10428, "DESERET SMALL LETTER LONG I" },
	{ 0x10429, "DESERET SMALL LETTER LONG E" },
	{ 0x1042A, "DESERET SMALL LETTER LONG A" },
	{ 0x1042B, "DESERET SMALL LETTER LONG AH" },
	{ 0x1042C, "DESERET SMALL LETTER LONG O" },
	{ 0x1042D, "DESERET SMALL LETTER LONG OO" },
	{ 0x1042E, "DESERET SMALL LETTER SHORT I" },
	{ 0x1042F, "DESERET SMALL LETTER SHORT E" },
	{ 0x10430, "DESERET SMALL LETTER SHORT A" },
	{ 0x10431, "DESERET SMALL LETTER SHORT AH" },
	{ 0x10432, "DESERET SMALL LETTER SHORT O" },
	{ 0x10433, "DESERET SMALL LETTER SHORT OO" },
	{ 0x10434, "DESERET SMALL LETTER AY" },
	{ 0x10435, "DESERET SMALL LETTER OW" },
	{ 0x10436, "DESERET SMALL LETTER WU" },
	{ 0x10437, "DESERET SMALL LETTER YEE" },
	{ 0x10438, "DESERET SMALL LETTER H" },
	{ 0x10439, "DESERET SMALL LETTER PEE" },
	{ 0x1043A, "DESERET SMALL LETTER BEE" },
	{ 0x1043B, "DESERET SMALL LETTER TEE" },
	{ 0x1043C, "DESERET SMALL LETTER DEE" },
	{ 0x1043D, "DESERET SMALL LETTER CHEE" },
	{ 0x1043E, "DESERET SMALL LETTER JEE" },
	{ 0x1043F, "DESERET SMALL LETTER KAY" },
	{ 0x10440, "DESERET SMALL LETTER GAY" },
	{ 0x10441, "DESERET SMALL LETTER EF" },
	{ 0x10442, "DESERET SMALL LETTER VEE" },
	{ 0x10443, "DESERET SMALL LETTER ETH" },
	{ 0x10444, "DESERET SMALL LETTER THEE" },
	{ 0x10445, "DESERET SMALL LETTER ES" },
	{ 0x10446, "DESERET SMALL LETTER ZEE" },
	{ 0x10447, "DESERET SMALL LETTER ESH" },
	{ 0x10448, "DESERET SMALL LETTER ZHEE" },
	{ 0x10449, "DESERET SMALL LETTER ER" },
	{ 0x1044A, "DESERET SMALL LETTER EL" },
	{ 0x1044B, "DESERET SMALL LETTER EM" },
	{ 0x1044C, "DESERET SMALL LETTER EN" },
	{ 0x1044D, "DESERET SMALL LETTER ENG" },
	{ 0x1D000, "BYZANTINE MUSICAL SYMBOL PSILI" },
	{ 0x1D001, "BYZANTINE MUSICAL SYMBOL DASEIA" },
	{ 0x1D002, "BYZANTINE MUSICAL SYMBOL PERISPOMENI" },
	{ 0x1D003, "BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON" },
	{ 0x1D004, "BYZANTINE MUSICAL SYMBOL OXEIA DIPLI" },
	{ 0x1D005, "BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON" },
	{ 0x1D006, "BYZANTINE MUSICAL SYMBOL VAREIA DIPLI" },
	{ 0x1D007, "BYZANTINE MUSICAL SYMBOL KATHISTI" },
	{ 0x1D008, "BYZANTINE MUSICAL SYMBOL SYRMATIKI" },
	{ 0x1D009, "BYZANTINE MUSICAL SYMBOL PARAKLITIKI" },
	{ 0x1D00A, "BYZANTINE MUSICAL SYMBOL YPOKRISIS" },
	{ 0x1D00B, "BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI" },
	{ 0x1D00C, "BYZANTINE MUSICAL SYMBOL KREMASTI" },
	{ 0x1D00D, "BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON" },
	{ 0x1D00E, "BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON" },
	{ 0x1D00F, "BYZANTINE MUSICAL SYMBOL TELEIA" },
	{ 0x1D010, "BYZANTINE MUSICAL SYMBOL KENTIMATA" },
	{ 0x1D011, "BYZANTINE MUSICAL SYMBOL APOSTROFOS" },
	{ 0x1D012, "BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI" },
	{ 0x1D013, "BYZANTINE MUSICAL SYMBOL SYNEVMA" },
	{ 0x1D014, "BYZANTINE MUSICAL SYMBOL THITA" },
	{ 0x1D015, "BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION" },
	{ 0x1D016, "BYZANTINE MUSICAL SYMBOL GORGON ARCHAION" },
	{ 0x1D017, "BYZANTINE MUSICAL SYMBOL PSILON" },
	{ 0x1D018, "BYZANTINE MUSICAL SYMBOL CHAMILON" },
	{ 0x1D019, "BYZANTINE MUSICAL SYMBOL VATHY" },
	{ 0x1D01A, "BYZANTINE MUSICAL SYMBOL ISON ARCHAION" },
	{ 0x1D01B, "BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION" },
	{ 0x1D01C, "BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION" },
	{ 0x1D01D, "BYZANTINE MUSICAL SYMBOL SAXIMATA" },
	{ 0x1D01E, "BYZANTINE MUSICAL SYMBOL PARICHON" },
	{ 0x1D01F, "BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA" },
	{ 0x1D020, "BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION" },
	{ 0x1D021, "BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION" },
	{ 0x1D022, "BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION" },
	{ 0x1D023, "BYZANTINE MUSICAL SYMBOL APOTHEMA" },
	{ 0x1D024, "BYZANTINE MUSICAL SYMBOL KLASMA" },
	{ 0x1D025, "BYZANTINE MUSICAL SYMBOL REVMA" },
	{ 0x1D026, "BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION" },
	{ 0x1D027, "BYZANTINE MUSICAL SYMBOL TINAGMA" },
	{ 0x1D028, "BYZANTINE MUSICAL SYMBOL ANATRICHISMA" },
	{ 0x1D029, "BYZANTINE MUSICAL SYMBOL SEISMA" },
	{ 0x1D02A, "BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION" },
	{ 0x1D02B, "BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU" },
	{ 0x1D02C, "BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION" },
	{ 0x1D02D, "BYZANTINE MUSICAL SYMBOL THEMA" },
	{ 0x1D02E, "BYZANTINE MUSICAL SYMBOL LEMOI" },
	{ 0x1D02F, "BYZANTINE MUSICAL SYMBOL DYO" },
	{ 0x1D030, "BYZANTINE MUSICAL SYMBOL TRIA" },
	{ 0x1D031, "BYZANTINE MUSICAL SYMBOL TESSERA" },
	{ 0x1D032, "BYZANTINE MUSICAL SYMBOL KRATIMATA" },
	{ 0x1D033, "BYZANTINE MUSICAL SYMBOL APESO EXO NEO" },
	{ 0x1D034, "BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION" },
	{ 0x1D035, "BYZANTINE MUSICAL SYMBOL IMIFTHORA" },
	{ 0x1D036, "BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION" },
	{ 0x1D037, "BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON" },
	{ 0x1D038, "BYZANTINE MUSICAL SYMBOL PELASTON" },
	{ 0x1D039, "BYZANTINE MUSICAL SYMBOL PSIFISTON" },
	{ 0x1D03A, "BYZANTINE MUSICAL SYMBOL KONTEVMA" },
	{ 0x1D03B, "BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION" },
	{ 0x1D03C, "BYZANTINE MUSICAL SYMBOL RAPISMA" },
	{ 0x1D03D, "BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION" },
	{ 0x1D03E, "BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION" },
	{ 0x1D03F, "BYZANTINE MUSICAL SYMBOL ICHADIN" },
	{ 0x1D040, "BYZANTINE MUSICAL SYMBOL NANA" },
	{ 0x1D041, "BYZANTINE MUSICAL SYMBOL PETASMA" },
	{ 0x1D042, "BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO" },
	{ 0x1D043, "BYZANTINE MUSICAL SYMBOL TROMIKON ALLO" },
	{ 0x1D044, "BYZANTINE MUSICAL SYMBOL STRAGGISMATA" },
	{ 0x1D045, "BYZANTINE MUSICAL SYMBOL GRONTHISMATA" },
	{ 0x1D046, "BYZANTINE MUSICAL SYMBOL ISON NEO" },
	{ 0x1D047, "BYZANTINE MUSICAL SYMBOL OLIGON NEO" },
	{ 0x1D048, "BYZANTINE MUSICAL SYMBOL OXEIA NEO" },
	{ 0x1D049, "BYZANTINE MUSICAL SYMBOL PETASTI" },
	{ 0x1D04A, "BYZANTINE MUSICAL SYMBOL KOUFISMA" },
	{ 0x1D04B, "BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA" },
	{ 0x1D04C, "BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA" },
	{ 0x1D04D, "BYZANTINE MUSICAL SYMBOL PELASTON NEO" },
	{ 0x1D04E, "BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO" },
	{ 0x1D04F, "BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO" },
	{ 0x1D050, "BYZANTINE MUSICAL SYMBOL YPSILI" },
	{ 0x1D051, "BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO" },
	{ 0x1D052, "BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO" },
	{ 0x1D053, "BYZANTINE MUSICAL SYMBOL YPORROI" },
	{ 0x1D054, "BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON" },
	{ 0x1D055, "BYZANTINE MUSICAL SYMBOL ELAFRON" },
	{ 0x1D056, "BYZANTINE MUSICAL SYMBOL CHAMILI" },
	{ 0x1D057, "BYZANTINE MUSICAL SYMBOL MIKRON ISON" },
	{ 0x1D058, "BYZANTINE MUSICAL SYMBOL VAREIA NEO" },
	{ 0x1D059, "BYZANTINE MUSICAL SYMBOL PIASMA NEO" },
	{ 0x1D05A, "BYZANTINE MUSICAL SYMBOL PSIFISTON NEO" },
	{ 0x1D05B, "BYZANTINE MUSICAL SYMBOL OMALON" },
	{ 0x1D05C, "BYZANTINE MUSICAL SYMBOL ANTIKENOMA" },
	{ 0x1D05D, "BYZANTINE MUSICAL SYMBOL LYGISMA" },
	{ 0x1D05E, "BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO" },
	{ 0x1D05F, "BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO" },
	{ 0x1D060, "BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA" },
	{ 0x1D061, "BYZANTINE MUSICAL SYMBOL KYLISMA" },
	{ 0x1D062, "BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA" },
	{ 0x1D063, "BYZANTINE MUSICAL SYMBOL TROMIKON NEO" },
	{ 0x1D064, "BYZANTINE MUSICAL SYMBOL EKSTREPTON" },
	{ 0x1D065, "BYZANTINE MUSICAL SYMBOL SYNAGMA NEO" },
	{ 0x1D066, "BYZANTINE MUSICAL SYMBOL SYRMA" },
	{ 0x1D067, "BYZANTINE MUSICAL SYMBOL CHOREVMA NEO" },
	{ 0x1D068, "BYZANTINE MUSICAL SYMBOL EPEGERMA" },
	{ 0x1D069, "BYZANTINE MUSICAL SYMBOL SEISMA NEO" },
	{ 0x1D06A, "BYZANTINE MUSICAL SYMBOL XIRON KLASMA" },
	{ 0x1D06B, "BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON" },
	{ 0x1D06C, "BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA" },
	{ 0x1D06D, "BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA" },
	{ 0x1D06E, "BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA" },
	{ 0x1D06F, "BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA" },
	{ 0x1D070, "BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA" },
	{ 0x1D071, "BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA" },
	{ 0x1D072, "BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON" },
	{ 0x1D073, "BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON" },
	{ 0x1D074, "BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON" },
	{ 0x1D075, "BYZANTINE MUSICAL SYMBOL OYRANISMA NEO" },
	{ 0x1D076, "BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO" },
	{ 0x1D077, "BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO" },
	{ 0x1D078, "BYZANTINE MUSICAL SYMBOL THEMA APLOUN" },
	{ 0x1D079, "BYZANTINE MUSICAL SYMBOL THES KAI APOTHES" },
	{ 0x1D07A, "BYZANTINE MUSICAL SYMBOL KATAVASMA" },
	{ 0x1D07B, "BYZANTINE MUSICAL SYMBOL ENDOFONON" },
	{ 0x1D07C, "BYZANTINE MUSICAL SYMBOL YFEN KATO" },
	{ 0x1D07D, "BYZANTINE MUSICAL SYMBOL YFEN ANO" },
	{ 0x1D07E, "BYZANTINE MUSICAL SYMBOL STAVROS" },
	{ 0x1D07F, "BYZANTINE MUSICAL SYMBOL KLASMA ANO" },
	{ 0x1D080, "BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION" },
	{ 0x1D081, "BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION" },
	{ 0x1D082, "BYZANTINE MUSICAL SYMBOL KRATIMA ALLO" },
	{ 0x1D083, "BYZANTINE MUSICAL SYMBOL KRATIMA NEO" },
	{ 0x1D084, "BYZANTINE MUSICAL SYMBOL APODERMA NEO" },
	{ 0x1D085, "BYZANTINE MUSICAL SYMBOL APLI" },
	{ 0x1D086, "BYZANTINE MUSICAL SYMBOL DIPLI" },
	{ 0x1D087, "BYZANTINE MUSICAL SYMBOL TRIPLI" },
	{ 0x1D088, "BYZANTINE MUSICAL SYMBOL TETRAPLI" },
	{ 0x1D089, "BYZANTINE MUSICAL SYMBOL KORONIS" },
	{ 0x1D08A, "BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU" },
	{ 0x1D08B, "BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON" },
	{ 0x1D08C, "BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON" },
	{ 0x1D08D, "BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON" },
	{ 0x1D08E, "BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU" },
	{ 0x1D08F, "BYZANTINE MUSICAL SYMBOL GORGON NEO ANO" },
	{ 0x1D090, "BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA" },
	{ 0x1D091, "BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA" },
	{ 0x1D092, "BYZANTINE MUSICAL SYMBOL DIGORGON" },
	{ 0x1D093, "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO" },
	{ 0x1D094, "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO" },
	{ 0x1D095, "BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA" },
	{ 0x1D096, "BYZANTINE MUSICAL SYMBOL TRIGORGON" },
	{ 0x1D097, "BYZANTINE MUSICAL SYMBOL ARGON" },
	{ 0x1D098, "BYZANTINE MUSICAL SYMBOL IMIDIARGON" },
	{ 0x1D099, "BYZANTINE MUSICAL SYMBOL DIARGON" },
	{ 0x1D09A, "BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI" },
	{ 0x1D09B, "BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI" },
	{ 0x1D09C, "BYZANTINE MUSICAL SYMBOL AGOGI ARGI" },
	{ 0x1D09D, "BYZANTINE MUSICAL SYMBOL AGOGI METRIA" },
	{ 0x1D09E, "BYZANTINE MUSICAL SYMBOL AGOGI MESI" },
	{ 0x1D09F, "BYZANTINE MUSICAL SYMBOL AGOGI GORGI" },
	{ 0x1D0A0, "BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI" },
	{ 0x1D0A1, "BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI" },
	{ 0x1D0A2, "BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS" },
	{ 0x1D0A3, "BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS" },
	{ 0x1D0A4, "BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS" },
	{ 0x1D0A5, "BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS" },
	{ 0x1D0A6, "BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS" },
	{ 0x1D0A7, "BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS" },
	{ 0x1D0A8, "BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS" },
	{ 0x1D0A9, "BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS" },
	{ 0x1D0AA, "BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS" },
	{ 0x1D0AB, "BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS" },
	{ 0x1D0AC, "BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS" },
	{ 0x1D0AD, "BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS" },
	{ 0x1D0AE, "BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS" },
	{ 0x1D0AF, "BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS" },
	{ 0x1D0B0, "BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS" },
	{ 0x1D0B1, "BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS" },
	{ 0x1D0B2, "BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS" },
	{ 0x1D0B3, "BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS" },
	{ 0x1D0B4, "BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN" },
	{ 0x1D0B5, "BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN" },
	{ 0x1D0B6, "BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU" },
	{ 0x1D0B7, "BYZANTINE MUSICAL SYMBOL IMIFONON" },
	{ 0x1D0B8, "BYZANTINE MUSICAL SYMBOL IMIFTHORON" },
	{ 0x1D0B9, "BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU" },
	{ 0x1D0BA, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA" },
	{ 0x1D0BB, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA" },
	{ 0x1D0BC, "BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS" },
	{ 0x1D0BD, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI" },
	{ 0x1D0BE, "BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI" },
	{ 0x1D0BF, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE" },
	{ 0x1D0C0, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO" },
	{ 0x1D0C1, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO" },
	{ 0x1D0C2, "BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO" },
	{ 0x1D0C3, "BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS" },
	{ 0x1D0C4, "BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS" },
	{ 0x1D0C5, "BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS" },
	{ 0x1D0C6, "BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI" },
	{ 0x1D0C7, "BYZANTINE MUSICAL SYMBOL FTHORA NENANO" },
	{ 0x1D0C8, "BYZANTINE MUSICAL SYMBOL CHROA ZYGOS" },
	{ 0x1D0C9, "BYZANTINE MUSICAL SYMBOL CHROA KLITON" },
	{ 0x1D0CA, "BYZANTINE MUSICAL SYMBOL CHROA SPATHI" },
	{ 0x1D0CB, "BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION" },
	{ 0x1D0CC, "BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA" },
	{ 0x1D0CD, "BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION" },
	{ 0x1D0CE, "BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION" },
	{ 0x1D0CF, "BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION" },
	{ 0x1D0D0, "BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA" },
	{ 0x1D0D1, "BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA" },
	{ 0x1D0D2, "BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA" },
	{ 0x1D0D3, "BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA" },
	{ 0x1D0D4, "BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA" },
	{ 0x1D0D5, "BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA" },
	{ 0x1D0D6, "BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA" },
	{ 0x1D0D7, "BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA" },
	{ 0x1D0D8, "BYZANTINE MUSICAL SYMBOL GENIKI DIESIS" },
	{ 0x1D0D9, "BYZANTINE MUSICAL SYMBOL GENIKI YFESIS" },
	{ 0x1D0DA, "BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI" },
	{ 0x1D0DB, "BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI" },
	{ 0x1D0DC, "BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI" },
	{ 0x1D0DD, "BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS" },
	{ 0x1D0DE, "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS" },
	{ 0x1D0DF, "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU" },
	{ 0x1D0E0, "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU" },
	{ 0x1D0E1, "BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU" },
	{ 0x1D0E2, "BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS" },
	{ 0x1D0E3, "BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU" },
	{ 0x1D0E4, "BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU" },
	{ 0x1D0E5, "BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU" },
	{ 0x1D0E6, "BYZANTINE MUSICAL SYMBOL DIGRAMMA GG" },
	{ 0x1D0E7, "BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU" },
	{ 0x1D0E8, "BYZANTINE MUSICAL SYMBOL STIGMA" },
	{ 0x1D0E9, "BYZANTINE MUSICAL SYMBOL ARKTIKO PA" },
	{ 0x1D0EA, "BYZANTINE MUSICAL SYMBOL ARKTIKO VOU" },
	{ 0x1D0EB, "BYZANTINE MUSICAL SYMBOL ARKTIKO GA" },
	{ 0x1D0EC, "BYZANTINE MUSICAL SYMBOL ARKTIKO DI" },
	{ 0x1D0ED, "BYZANTINE MUSICAL SYMBOL ARKTIKO KE" },
	{ 0x1D0EE, "BYZANTINE MUSICAL SYMBOL ARKTIKO ZO" },
	{ 0x1D0EF, "BYZANTINE MUSICAL SYMBOL ARKTIKO NI" },
	{ 0x1D0F0, "BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO" },
	{ 0x1D0F1, "BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO" },
	{ 0x1D0F2, "BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO" },
	{ 0x1D0F3, "BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO" },
	{ 0x1D0F4, "BYZANTINE MUSICAL SYMBOL KLASMA KATO" },
	{ 0x1D0F5, "BYZANTINE MUSICAL SYMBOL GORGON NEO KATO" },
	{ 0x1D100, "MUSICAL SYMBOL SINGLE BARLINE" },
	{ 0x1D101, "MUSICAL SYMBOL DOUBLE BARLINE" },
	{ 0x1D102, "MUSICAL SYMBOL FINAL BARLINE" },
	{ 0x1D103, "MUSICAL SYMBOL REVERSE FINAL BARLINE" },
	{ 0x1D104, "MUSICAL SYMBOL DASHED BARLINE" },
	{ 0x1D105, "MUSICAL SYMBOL SHORT BARLINE" },
	{ 0x1D106, "MUSICAL SYMBOL LEFT REPEAT SIGN" },
	{ 0x1D107, "MUSICAL SYMBOL RIGHT REPEAT SIGN" },
	{ 0x1D108, "MUSICAL SYMBOL REPEAT DOTS" },
	{ 0x1D109, "MUSICAL SYMBOL DAL SEGNO" },
	{ 0x1D10A, "MUSICAL SYMBOL DA CAPO" },
	{ 0x1D10B, "MUSICAL SYMBOL SEGNO" },
	{ 0x1D10C, "MUSICAL SYMBOL CODA" },
	{ 0x1D10D, "MUSICAL SYMBOL REPEATED FIGURE-1" },
	{ 0x1D10E, "MUSICAL SYMBOL REPEATED FIGURE-2" },
	{ 0x1D10F, "MUSICAL SYMBOL REPEATED FIGURE-3" },
	{ 0x1D110, "MUSICAL SYMBOL FERMATA" },
	{ 0x1D111, "MUSICAL SYMBOL FERMATA BELOW" },
	{ 0x1D112, "MUSICAL SYMBOL BREATH MARK" },
	{ 0x1D113, "MUSICAL SYMBOL CAESURA" },
	{ 0x1D114, "MUSICAL SYMBOL BRACE" },
	{ 0x1D115, "MUSICAL SYMBOL BRACKET" },
	{ 0x1D116, "MUSICAL SYMBOL ONE-LINE STAFF" },
	{ 0x1D117, "MUSICAL SYMBOL TWO-LINE STAFF" },
	{ 0x1D118, "MUSICAL SYMBOL THREE-LINE STAFF" },
	{ 0x1D119, "MUSICAL SYMBOL FOUR-LINE STAFF" },
	{ 0x1D11A, "MUSICAL SYMBOL FIVE-LINE STAFF" },
	{ 0x1D11B, "MUSICAL SYMBOL SIX-LINE STAFF" },
	{ 0x1D11C, "MUSICAL SYMBOL SIX-STRING FRETBOARD" },
	{ 0x1D11D, "MUSICAL SYMBOL FOUR-STRING FRETBOARD" },
	{ 0x1D11E, "MUSICAL SYMBOL G CLEF" },
	{ 0x1D11F, "MUSICAL SYMBOL G CLEF OTTAVA ALTA" },
	{ 0x1D120, "MUSICAL SYMBOL G CLEF OTTAVA BASSA" },
	{ 0x1D121, "MUSICAL SYMBOL C CLEF" },
	{ 0x1D122, "MUSICAL SYMBOL F CLEF" },
	{ 0x1D123, "MUSICAL SYMBOL F CLEF OTTAVA ALTA" },
	{ 0x1D124, "MUSICAL SYMBOL F CLEF OTTAVA BASSA" },
	{ 0x1D125, "MUSICAL SYMBOL DRUM CLEF-1" },
	{ 0x1D126, "MUSICAL SYMBOL DRUM CLEF-2" },
	{ 0x1D12A, "MUSICAL SYMBOL DOUBLE SHARP" },
	{ 0x1D12B, "MUSICAL SYMBOL DOUBLE FLAT" },
	{ 0x1D12C, "MUSICAL SYMBOL FLAT UP" },
	{ 0x1D12D, "MUSICAL SYMBOL FLAT DOWN" },
	{ 0x1D12E, "MUSICAL SYMBOL NATURAL UP" },
	{ 0x1D12F, "MUSICAL SYMBOL NATURAL DOWN" },
	{ 0x1D130, "MUSICAL SYMBOL SHARP UP" },
	{ 0x1D131, "MUSICAL SYMBOL SHARP DOWN" },
	{ 0x1D132, "MUSICAL SYMBOL QUARTER TONE SHARP" },
	{ 0x1D133, "MUSICAL SYMBOL QUARTER TONE FLAT" },
	{ 0x1D134, "MUSICAL SYMBOL COMMON TIME" },
	{ 0x1D135, "MUSICAL SYMBOL CUT TIME" },
	{ 0x1D136, "MUSICAL SYMBOL OTTAVA ALTA" },
	{ 0x1D137, "MUSICAL SYMBOL OTTAVA BASSA" },
	{ 0x1D138, "MUSICAL SYMBOL QUINDICESIMA ALTA" },
	{ 0x1D139, "MUSICAL SYMBOL QUINDICESIMA BASSA" },
	{ 0x1D13A, "MUSICAL SYMBOL MULTI REST" },
	{ 0x1D13B, "MUSICAL SYMBOL WHOLE REST" },
	{ 0x1D13C, "MUSICAL SYMBOL HALF REST" },
	{ 0x1D13D, "MUSICAL SYMBOL QUARTER REST" },
	{ 0x1D13E, "MUSICAL SYMBOL EIGHTH REST" },
	{ 0x1D13F, "MUSICAL SYMBOL SIXTEENTH REST" },
	{ 0x1D140, "MUSICAL SYMBOL THIRTY-SECOND REST" },
	{ 0x1D141, "MUSICAL SYMBOL SIXTY-FOURTH REST" },
	{ 0x1D142, "MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST" },
	{ 0x1D143, "MUSICAL SYMBOL X NOTEHEAD" },
	{ 0x1D144, "MUSICAL SYMBOL PLUS NOTEHEAD" },
	{ 0x1D145, "MUSICAL SYMBOL CIRCLE X NOTEHEAD" },
	{ 0x1D146, "MUSICAL SYMBOL SQUARE NOTEHEAD WHITE" },
	{ 0x1D147, "MUSICAL SYMBOL SQUARE NOTEHEAD BLACK" },
	{ 0x1D148, "MUSICAL SYMBOL TRIANGLE NOTEHEAD UP WHITE" },
	{ 0x1D149, "MUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACK" },
	{ 0x1D14A, "MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITE" },
	{ 0x1D14B, "MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACK" },
	{ 0x1D14C, "MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITE" },
	{ 0x1D14D, "MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BLACK" },
	{ 0x1D14E, "MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITE" },
	{ 0x1D14F, "MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACK" },
	{ 0x1D150, "MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITE" },
	{ 0x1D151, "MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACK" },
	{ 0x1D152, "MUSICAL SYMBOL MOON NOTEHEAD WHITE" },
	{ 0x1D153, "MUSICAL SYMBOL MOON NOTEHEAD BLACK" },
	{ 0x1D154, "MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITE" },
	{ 0x1D155, "MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACK" },
	{ 0x1D156, "MUSICAL SYMBOL PARENTHESIS NOTEHEAD" },
	{ 0x1D157, "MUSICAL SYMBOL VOID NOTEHEAD" },
	{ 0x1D158, "MUSICAL SYMBOL NOTEHEAD BLACK" },
	{ 0x1D159, "MUSICAL SYMBOL NULL NOTEHEAD" },
	{ 0x1D15A, "MUSICAL SYMBOL CLUSTER NOTEHEAD WHITE" },
	{ 0x1D15B, "MUSICAL SYMBOL CLUSTER NOTEHEAD BLACK" },
	{ 0x1D15C, "MUSICAL SYMBOL BREVE" },
	{ 0x1D15D, "MUSICAL SYMBOL WHOLE NOTE" },
	{ 0x1D15E, "MUSICAL SYMBOL HALF NOTE" },
	{ 0x1D15F, "MUSICAL SYMBOL QUARTER NOTE" },
	{ 0x1D160, "MUSICAL SYMBOL EIGHTH NOTE" },
	{ 0x1D161, "MUSICAL SYMBOL SIXTEENTH NOTE" },
	{ 0x1D162, "MUSICAL SYMBOL THIRTY-SECOND NOTE" },
	{ 0x1D163, "MUSICAL SYMBOL SIXTY-FOURTH NOTE" },
	{ 0x1D164, "MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE" },
	{ 0x1D165, "MUSICAL SYMBOL COMBINING STEM" },
	{ 0x1D166, "MUSICAL SYMBOL COMBINING SPRECHGESANG STEM" },
	{ 0x1D167, "MUSICAL SYMBOL COMBINING TREMOLO-1" },
	{ 0x1D168, "MUSICAL SYMBOL COMBINING TREMOLO-2" },
	{ 0x1D169, "MUSICAL SYMBOL COMBINING TREMOLO-3" },
	{ 0x1D16A, "MUSICAL SYMBOL FINGERED TREMOLO-1" },
	{ 0x1D16B, "MUSICAL SYMBOL FINGERED TREMOLO-2" },
	{ 0x1D16C, "MUSICAL SYMBOL FINGERED TREMOLO-3" },
	{ 0x1D16D, "MUSICAL SYMBOL COMBINING AUGMENTATION DOT" },
	{ 0x1D16E, "MUSICAL SYMBOL COMBINING FLAG-1" },
	{ 0x1D16F, "MUSICAL SYMBOL COMBINING FLAG-2" },
	{ 0x1D170, "MUSICAL SYMBOL COMBINING FLAG-3" },
	{ 0x1D171, "MUSICAL SYMBOL COMBINING FLAG-4" },
	{ 0x1D172, "MUSICAL SYMBOL COMBINING FLAG-5" },
	{ 0x1D173, "MUSICAL SYMBOL BEGIN BEAM" },
	{ 0x1D174, "MUSICAL SYMBOL END BEAM" },
	{ 0x1D175, "MUSICAL SYMBOL BEGIN TIE" },
	{ 0x1D176, "MUSICAL SYMBOL END TIE" },
	{ 0x1D177, "MUSICAL SYMBOL BEGIN SLUR" },
	{ 0x1D178, "MUSICAL SYMBOL END SLUR" },
	{ 0x1D179, "MUSICAL SYMBOL BEGIN PHRASE" },
	{ 0x1D17A, "MUSICAL SYMBOL END PHRASE" },
	{ 0x1D17B, "MUSICAL SYMBOL COMBINING ACCENT" },
	{ 0x1D17C, "MUSICAL SYMBOL COMBINING STACCATO" },
	{ 0x1D17D, "MUSICAL SYMBOL COMBINING TENUTO" },
	{ 0x1D17E, "MUSICAL SYMBOL COMBINING STACCATISSIMO" },
	{ 0x1D17F, "MUSICAL SYMBOL COMBINING MARCATO" },
	{ 0x1D180, "MUSICAL SYMBOL COMBINING MARCATO-STACCATO" },
	{ 0x1D181, "MUSICAL SYMBOL COMBINING ACCENT-STACCATO" },
	{ 0x1D182, "MUSICAL SYMBOL COMBINING LOURE" },
	{ 0x1D183, "MUSICAL SYMBOL ARPEGGIATO UP" },
	{ 0x1D184, "MUSICAL SYMBOL ARPEGGIATO DOWN" },
	{ 0x1D185, "MUSICAL SYMBOL COMBINING DOIT" },
	{ 0x1D186, "MUSICAL SYMBOL COMBINING RIP" },
	{ 0x1D187, "MUSICAL SYMBOL COMBINING FLIP" },
	{ 0x1D188, "MUSICAL SYMBOL COMBINING SMEAR" },
	{ 0x1D189, "MUSICAL SYMBOL COMBINING BEND" },
	{ 0x1D18A, "MUSICAL SYMBOL COMBINING DOUBLE TONGUE" },
	{ 0x1D18B, "MUSICAL SYMBOL COMBINING TRIPLE TONGUE" },
	{ 0x1D18C, "MUSICAL SYMBOL RINFORZANDO" },
	{ 0x1D18D, "MUSICAL SYMBOL SUBITO" },
	{ 0x1D18E, "MUSICAL SYMBOL Z" },
	{ 0x1D18F, "MUSICAL SYMBOL PIANO" },
	{ 0x1D190, "MUSICAL SYMBOL MEZZO" },
	{ 0x1D191, "MUSICAL SYMBOL FORTE" },
	{ 0x1D192, "MUSICAL SYMBOL CRESCENDO" },
	{ 0x1D193, "MUSICAL SYMBOL DECRESCENDO" },
	{ 0x1D194, "MUSICAL SYMBOL GRACE NOTE SLASH" },
	{ 0x1D195, "MUSICAL SYMBOL GRACE NOTE NO SLASH" },
	{ 0x1D196, "MUSICAL SYMBOL TR" },
	{ 0x1D197, "MUSICAL SYMBOL TURN" },
	{ 0x1D198, "MUSICAL SYMBOL INVERTED TURN" },
	{ 0x1D199, "MUSICAL SYMBOL TURN SLASH" },
	{ 0x1D19A, "MUSICAL SYMBOL TURN UP" },
	{ 0x1D19B, "MUSICAL SYMBOL ORNAMENT STROKE-1" },
	{ 0x1D19C, "MUSICAL SYMBOL ORNAMENT STROKE-2" },
	{ 0x1D19D, "MUSICAL SYMBOL ORNAMENT STROKE-3" },
	{ 0x1D19E, "MUSICAL SYMBOL ORNAMENT STROKE-4" },
	{ 0x1D19F, "MUSICAL SYMBOL ORNAMENT STROKE-5" },
	{ 0x1D1A0, "MUSICAL SYMBOL ORNAMENT STROKE-6" },
	{ 0x1D1A1, "MUSICAL SYMBOL ORNAMENT STROKE-7" },
	{ 0x1D1A2, "MUSICAL SYMBOL ORNAMENT STROKE-8" },
	{ 0x1D1A3, "MUSICAL SYMBOL ORNAMENT STROKE-9" },
	{ 0x1D1A4, "MUSICAL SYMBOL ORNAMENT STROKE-10" },
	{ 0x1D1A5, "MUSICAL SYMBOL ORNAMENT STROKE-11" },
	{ 0x1D1A6, "MUSICAL SYMBOL HAUPTSTIMME" },
	{ 0x1D1A7, "MUSICAL SYMBOL NEBENSTIMME" },
	{ 0x1D1A8, "MUSICAL SYMBOL END OF STIMME" },
	{ 0x1D1A9, "MUSICAL SYMBOL DEGREE SLASH" },
	{ 0x1D1AA, "MUSICAL SYMBOL COMBINING DOWN BOW" },
	{ 0x1D1AB, "MUSICAL SYMBOL COMBINING UP BOW" },
	{ 0x1D1AC, "MUSICAL SYMBOL COMBINING HARMONIC" },
	{ 0x1D1AD, "MUSICAL SYMBOL COMBINING SNAP PIZZICATO" },
	{ 0x1D1AE, "MUSICAL SYMBOL PEDAL MARK" },
	{ 0x1D1AF, "MUSICAL SYMBOL PEDAL UP MARK" },
	{ 0x1D1B0, "MUSICAL SYMBOL HALF PEDAL MARK" },
	{ 0x1D1B1, "MUSICAL SYMBOL GLISSANDO UP" },
	{ 0x1D1B2, "MUSICAL SYMBOL GLISSANDO DOWN" },
	{ 0x1D1B3, "MUSICAL SYMBOL WITH FINGERNAILS" },
	{ 0x1D1B4, "MUSICAL SYMBOL DAMP" },
	{ 0x1D1B5, "MUSICAL SYMBOL DAMP ALL" },
	{ 0x1D1B6, "MUSICAL SYMBOL MAXIMA" },
	{ 0x1D1B7, "MUSICAL SYMBOL LONGA" },
	{ 0x1D1B8, "MUSICAL SYMBOL BREVIS" },
	{ 0x1D1B9, "MUSICAL SYMBOL SEMIBREVIS WHITE" },
	{ 0x1D1BA, "MUSICAL SYMBOL SEMIBREVIS BLACK" },
	{ 0x1D1BB, "MUSICAL SYMBOL MINIMA" },
	{ 0x1D1BC, "MUSICAL SYMBOL MINIMA BLACK" },
	{ 0x1D1BD, "MUSICAL SYMBOL SEMIMINIMA WHITE" },
	{ 0x1D1BE, "MUSICAL SYMBOL SEMIMINIMA BLACK" },
	{ 0x1D1BF, "MUSICAL SYMBOL FUSA WHITE" },
	{ 0x1D1C0, "MUSICAL SYMBOL FUSA BLACK" },
	{ 0x1D1C1, "MUSICAL SYMBOL LONGA PERFECTA REST" },
	{ 0x1D1C2, "MUSICAL SYMBOL LONGA IMPERFECTA REST" },
	{ 0x1D1C3, "MUSICAL SYMBOL BREVIS REST" },
	{ 0x1D1C4, "MUSICAL SYMBOL SEMIBREVIS REST" },
	{ 0x1D1C5, "MUSICAL SYMBOL MINIMA REST" },
	{ 0x1D1C6, "MUSICAL SYMBOL SEMIMINIMA REST" },
	{ 0x1D1C7, "MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA" },
	{ 0x1D1C8, "MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTA" },
	{ 0x1D1C9, "MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIMINUTION-1" },
	{ 0x1D1CA, "MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTA" },
	{ 0x1D1CB, "MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA" },
	{ 0x1D1CC, "MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1" },
	{ 0x1D1CD, "MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2" },
	{ 0x1D1CE, "MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3" },
	{ 0x1D1CF, "MUSICAL SYMBOL CROIX" },
	{ 0x1D1D0, "MUSICAL SYMBOL GREGORIAN C CLEF" },
	{ 0x1D1D1, "MUSICAL SYMBOL GREGORIAN F CLEF" },
	{ 0x1D1D2, "MUSICAL SYMBOL SQUARE B" },
	{ 0x1D1D3, "MUSICAL SYMBOL VIRGA" },
	{ 0x1D1D4, "MUSICAL SYMBOL PODATUS" },
	{ 0x1D1D5, "MUSICAL SYMBOL CLIVIS" },
	{ 0x1D1D6, "MUSICAL SYMBOL SCANDICUS" },
	{ 0x1D1D7, "MUSICAL SYMBOL CLIMACUS" },
	{ 0x1D1D8, "MUSICAL SYMBOL TORCULUS" },
	{ 0x1D1D9, "MUSICAL SYMBOL PORRECTUS" },
	{ 0x1D1DA, "MUSICAL SYMBOL PORRECTUS FLEXUS" },
	{ 0x1D1DB, "MUSICAL SYMBOL SCANDICUS FLEXUS" },
	{ 0x1D1DC, "MUSICAL SYMBOL TORCULUS RESUPINUS" },
	{ 0x1D1DD, "MUSICAL SYMBOL PES SUBPUNCTIS" },
	{ 0x1D400, "MATHEMATICAL BOLD CAPITAL A" },
	{ 0x1D401, "MATHEMATICAL BOLD CAPITAL B" },
	{ 0x1D402, "MATHEMATICAL BOLD CAPITAL C" },
	{ 0x1D403, "MATHEMATICAL BOLD CAPITAL D" },
	{ 0x1D404, "MATHEMATICAL BOLD CAPITAL E" },
	{ 0x1D405, "MATHEMATICAL BOLD CAPITAL F" },
	{ 0x1D406, "MATHEMATICAL BOLD CAPITAL G" },
	{ 0x1D407, "MATHEMATICAL BOLD CAPITAL H" },
	{ 0x1D408, "MATHEMATICAL BOLD CAPITAL I" },
	{ 0x1D409, "MATHEMATICAL BOLD CAPITAL J" },
	{ 0x1D40A, "MATHEMATICAL BOLD CAPITAL K" },
	{ 0x1D40B, "MATHEMATICAL BOLD CAPITAL L" },
	{ 0x1D40C, "MATHEMATICAL BOLD CAPITAL M" },
	{ 0x1D40D, "MATHEMATICAL BOLD CAPITAL N" },
	{ 0x1D40E, "MATHEMATICAL BOLD CAPITAL O" },
	{ 0x1D40F, "MATHEMATICAL BOLD CAPITAL P" },
	{ 0x1D410, "MATHEMATICAL BOLD CAPITAL Q" },
	{ 0x1D411, "MATHEMATICAL BOLD CAPITAL R" },
	{ 0x1D412, "MATHEMATICAL BOLD CAPITAL S" },
	{ 0x1D413, "MATHEMATICAL BOLD CAPITAL T" },
	{ 0x1D414, "MATHEMATICAL BOLD CAPITAL U" },
	{ 0x1D415, "MATHEMATICAL BOLD CAPITAL V" },
	{ 0x1D416, "MATHEMATICAL BOLD CAPITAL W" },
	{ 0x1D417, "MATHEMATICAL BOLD CAPITAL X" },
	{ 0x1D418, "MATHEMATICAL BOLD CAPITAL Y" },
	{ 0x1D419, "MATHEMATICAL BOLD CAPITAL Z" },
	{ 0x1D41A, "MATHEMATICAL BOLD SMALL A" },
	{ 0x1D41B, "MATHEMATICAL BOLD SMALL B" },
	{ 0x1D41C, "MATHEMATICAL BOLD SMALL C" },
	{ 0x1D41D, "MATHEMATICAL BOLD SMALL D" },
	{ 0x1D41E, "MATHEMATICAL BOLD SMALL E" },
	{ 0x1D41F, "MATHEMATICAL BOLD SMALL F" },
	{ 0x1D420, "MATHEMATICAL BOLD SMALL G" },
	{ 0x1D421, "MATHEMATICAL BOLD SMALL H" },
	{ 0x1D422, "MATHEMATICAL BOLD SMALL I" },
	{ 0x1D423, "MATHEMATICAL BOLD SMALL J" },
	{ 0x1D424, "MATHEMATICAL BOLD SMALL K" },
	{ 0x1D425, "MATHEMATICAL BOLD SMALL L" },
	{ 0x1D426, "MATHEMATICAL BOLD SMALL M" },
	{ 0x1D427, "MATHEMATICAL BOLD SMALL N" },
	{ 0x1D428, "MATHEMATICAL BOLD SMALL O" },
	{ 0x1D429, "MATHEMATICAL BOLD SMALL P" },
	{ 0x1D42A, "MATHEMATICAL BOLD SMALL Q" },
	{ 0x1D42B, "MATHEMATICAL BOLD SMALL R" },
	{ 0x1D42C, "MATHEMATICAL BOLD SMALL S" },
	{ 0x1D42D, "MATHEMATICAL BOLD SMALL T" },
	{ 0x1D42E, "MATHEMATICAL BOLD SMALL U" },
	{ 0x1D42F, "MATHEMATICAL BOLD SMALL V" },
	{ 0x1D430, "MATHEMATICAL BOLD SMALL W" },
	{ 0x1D431, "MATHEMATICAL BOLD SMALL X" },
	{ 0x1D432, "MATHEMATICAL BOLD SMALL Y" },
	{ 0x1D433, "MATHEMATICAL BOLD SMALL Z" },
	{ 0x1D434, "MATHEMATICAL ITALIC CAPITAL A" },
	{ 0x1D435, "MATHEMATICAL ITALIC CAPITAL B" },
	{ 0x1D436, "MATHEMATICAL ITALIC CAPITAL C" },
	{ 0x1D437, "MATHEMATICAL ITALIC CAPITAL D" },
	{ 0x1D438, "MATHEMATICAL ITALIC CAPITAL E" },
	{ 0x1D439, "MATHEMATICAL ITALIC CAPITAL F" },
	{ 0x1D43A, "MATHEMATICAL ITALIC CAPITAL G" },
	{ 0x1D43B, "MATHEMATICAL ITALIC CAPITAL H" },
	{ 0x1D43C, "MATHEMATICAL ITALIC CAPITAL I" },
	{ 0x1D43D, "MATHEMATICAL ITALIC CAPITAL J" },
	{ 0x1D43E, "MATHEMATICAL ITALIC CAPITAL K" },
	{ 0x1D43F, "MATHEMATICAL ITALIC CAPITAL L" },
	{ 0x1D440, "MATHEMATICAL ITALIC CAPITAL M" },
	{ 0x1D441, "MATHEMATICAL ITALIC CAPITAL N" },
	{ 0x1D442, "MATHEMATICAL ITALIC CAPITAL O" },
	{ 0x1D443, "MATHEMATICAL ITALIC CAPITAL P" },
	{ 0x1D444, "MATHEMATICAL ITALIC CAPITAL Q" },
	{ 0x1D445, "MATHEMATICAL ITALIC CAPITAL R" },
	{ 0x1D446, "MATHEMATICAL ITALIC CAPITAL S" },
	{ 0x1D447, "MATHEMATICAL ITALIC CAPITAL T" },
	{ 0x1D448, "MATHEMATICAL ITALIC CAPITAL U" },
	{ 0x1D449, "MATHEMATICAL ITALIC CAPITAL V" },
	{ 0x1D44A, "MATHEMATICAL ITALIC CAPITAL W" },
	{ 0x1D44B, "MATHEMATICAL ITALIC CAPITAL X" },
	{ 0x1D44C, "MATHEMATICAL ITALIC CAPITAL Y" },
	{ 0x1D44D, "MATHEMATICAL ITALIC CAPITAL Z" },
	{ 0x1D44E, "MATHEMATICAL ITALIC SMALL A" },
	{ 0x1D44F, "MATHEMATICAL ITALIC SMALL B" },
	{ 0x1D450, "MATHEMATICAL ITALIC SMALL C" },
	{ 0x1D451, "MATHEMATICAL ITALIC SMALL D" },
	{ 0x1D452, "MATHEMATICAL ITALIC SMALL E" },
	{ 0x1D453, "MATHEMATICAL ITALIC SMALL F" },
	{ 0x1D454, "MATHEMATICAL ITALIC SMALL G" },
	{ 0x1D456, "MATHEMATICAL ITALIC SMALL I" },
	{ 0x1D457, "MATHEMATICAL ITALIC SMALL J" },
	{ 0x1D458, "MATHEMATICAL ITALIC SMALL K" },
	{ 0x1D459, "MATHEMATICAL ITALIC SMALL L" },
	{ 0x1D45A, "MATHEMATICAL ITALIC SMALL M" },
	{ 0x1D45B, "MATHEMATICAL ITALIC SMALL N" },
	{ 0x1D45C, "MATHEMATICAL ITALIC SMALL O" },
	{ 0x1D45D, "MATHEMATICAL ITALIC SMALL P" },
	{ 0x1D45E, "MATHEMATICAL ITALIC SMALL Q" },
	{ 0x1D45F, "MATHEMATICAL ITALIC SMALL R" },
	{ 0x1D460, "MATHEMATICAL ITALIC SMALL S" },
	{ 0x1D461, "MATHEMATICAL ITALIC SMALL T" },
	{ 0x1D462, "MATHEMATICAL ITALIC SMALL U" },
	{ 0x1D463, "MATHEMATICAL ITALIC SMALL V" },
	{ 0x1D464, "MATHEMATICAL ITALIC SMALL W" },
	{ 0x1D465, "MATHEMATICAL ITALIC SMALL X" },
	{ 0x1D466, "MATHEMATICAL ITALIC SMALL Y" },
	{ 0x1D467, "MATHEMATICAL ITALIC SMALL Z" },
	{ 0x1D468, "MATHEMATICAL BOLD ITALIC CAPITAL A" },
	{ 0x1D469, "MATHEMATICAL BOLD ITALIC CAPITAL B" },
	{ 0x1D46A, "MATHEMATICAL BOLD ITALIC CAPITAL C" },
	{ 0x1D46B, "MATHEMATICAL BOLD ITALIC CAPITAL D" },
	{ 0x1D46C, "MATHEMATICAL BOLD ITALIC CAPITAL E" },
	{ 0x1D46D, "MATHEMATICAL BOLD ITALIC CAPITAL F" },
	{ 0x1D46E, "MATHEMATICAL BOLD ITALIC CAPITAL G" },
	{ 0x1D46F, "MATHEMATICAL BOLD ITALIC CAPITAL H" },
	{ 0x1D470, "MATHEMATICAL BOLD ITALIC CAPITAL I" },
	{ 0x1D471, "MATHEMATICAL BOLD ITALIC CAPITAL J" },
	{ 0x1D472, "MATHEMATICAL BOLD ITALIC CAPITAL K" },
	{ 0x1D473, "MATHEMATICAL BOLD ITALIC CAPITAL L" },
	{ 0x1D474, "MATHEMATICAL BOLD ITALIC CAPITAL M" },
	{ 0x1D475, "MATHEMATICAL BOLD ITALIC CAPITAL N" },
	{ 0x1D476, "MATHEMATICAL BOLD ITALIC CAPITAL O" },
	{ 0x1D477, "MATHEMATICAL BOLD ITALIC CAPITAL P" },
	{ 0x1D478, "MATHEMATICAL BOLD ITALIC CAPITAL Q" },
	{ 0x1D479, "MATHEMATICAL BOLD ITALIC CAPITAL R" },
	{ 0x1D47A, "MATHEMATICAL BOLD ITALIC CAPITAL S" },
	{ 0x1D47B, "MATHEMATICAL BOLD ITALIC CAPITAL T" },
	{ 0x1D47C, "MATHEMATICAL BOLD ITALIC CAPITAL U" },
	{ 0x1D47D, "MATHEMATICAL BOLD ITALIC CAPITAL V" },
	{ 0x1D47E, "MATHEMATICAL BOLD ITALIC CAPITAL W" },
	{ 0x1D47F, "MATHEMATICAL BOLD ITALIC CAPITAL X" },
	{ 0x1D480, "MATHEMATICAL BOLD ITALIC CAPITAL Y" },
	{ 0x1D481, "MATHEMATICAL BOLD ITALIC CAPITAL Z" },
	{ 0x1D482, "MATHEMATICAL BOLD ITALIC SMALL A" },
	{ 0x1D483, "MATHEMATICAL BOLD ITALIC SMALL B" },
	{ 0x1D484, "MATHEMATICAL BOLD ITALIC SMALL C" },
	{ 0x1D485, "MATHEMATICAL BOLD ITALIC SMALL D" },
	{ 0x1D486, "MATHEMATICAL BOLD ITALIC SMALL E" },
	{ 0x1D487, "MATHEMATICAL BOLD ITALIC SMALL F" },
	{ 0x1D488, "MATHEMATICAL BOLD ITALIC SMALL G" },
	{ 0x1D489, "MATHEMATICAL BOLD ITALIC SMALL H" },
	{ 0x1D48A, "MATHEMATICAL BOLD ITALIC SMALL I" },
	{ 0x1D48B, "MATHEMATICAL BOLD ITALIC SMALL J" },
	{ 0x1D48C, "MATHEMATICAL BOLD ITALIC SMALL K" },
	{ 0x1D48D, "MATHEMATICAL BOLD ITALIC SMALL L" },
	{ 0x1D48E, "MATHEMATICAL BOLD ITALIC SMALL M" },
	{ 0x1D48F, "MATHEMATICAL BOLD ITALIC SMALL N" },
	{ 0x1D490, "MATHEMATICAL BOLD ITALIC SMALL O" },
	{ 0x1D491, "MATHEMATICAL BOLD ITALIC SMALL P" },
	{ 0x1D492, "MATHEMATICAL BOLD ITALIC SMALL Q" },
	{ 0x1D493, "MATHEMATICAL BOLD ITALIC SMALL R" },
	{ 0x1D494, "MATHEMATICAL BOLD ITALIC SMALL S" },
	{ 0x1D495, "MATHEMATICAL BOLD ITALIC SMALL T" },
	{ 0x1D496, "MATHEMATICAL BOLD ITALIC SMALL U" },
	{ 0x1D497, "MATHEMATICAL BOLD ITALIC SMALL V" },
	{ 0x1D498, "MATHEMATICAL BOLD ITALIC SMALL W" },
	{ 0x1D499, "MATHEMATICAL BOLD ITALIC SMALL X" },
	{ 0x1D49A, "MATHEMATICAL BOLD ITALIC SMALL Y" },
	{ 0x1D49B, "MATHEMATICAL BOLD ITALIC SMALL Z" },
	{ 0x1D49C, "MATHEMATICAL SCRIPT CAPITAL A" },
	{ 0x1D49E, "MATHEMATICAL SCRIPT CAPITAL C" },
	{ 0x1D49F, "MATHEMATICAL SCRIPT CAPITAL D" },
	{ 0x1D4A2, "MATHEMATICAL SCRIPT CAPITAL G" },
	{ 0x1D4A5, "MATHEMATICAL SCRIPT CAPITAL J" },
	{ 0x1D4A6, "MATHEMATICAL SCRIPT CAPITAL K" },
	{ 0x1D4A9, "MATHEMATICAL SCRIPT CAPITAL N" },
	{ 0x1D4AA, "MATHEMATICAL SCRIPT CAPITAL O" },
	{ 0x1D4AB, "MATHEMATICAL SCRIPT CAPITAL P" },
	{ 0x1D4AC, "MATHEMATICAL SCRIPT CAPITAL Q" },
	{ 0x1D4AE, "MATHEMATICAL SCRIPT CAPITAL S" },
	{ 0x1D4AF, "MATHEMATICAL SCRIPT CAPITAL T" },
	{ 0x1D4B0, "MATHEMATICAL SCRIPT CAPITAL U" },
	{ 0x1D4B1, "MATHEMATICAL SCRIPT CAPITAL V" },
	{ 0x1D4B2, "MATHEMATICAL SCRIPT CAPITAL W" },
	{ 0x1D4B3, "MATHEMATICAL SCRIPT CAPITAL X" },
	{ 0x1D4B4, "MATHEMATICAL SCRIPT CAPITAL Y" },
	{ 0x1D4B5, "MATHEMATICAL SCRIPT CAPITAL Z" },
	{ 0x1D4B6, "MATHEMATICAL SCRIPT SMALL A" },
	{ 0x1D4B7, "MATHEMATICAL SCRIPT SMALL B" },
	{ 0x1D4B8, "MATHEMATICAL SCRIPT SMALL C" },
	{ 0x1D4B9, "MATHEMATICAL SCRIPT SMALL D" },
	{ 0x1D4BB, "MATHEMATICAL SCRIPT SMALL F" },
	{ 0x1D4BD, "MATHEMATICAL SCRIPT SMALL H" },
	{ 0x1D4BE, "MATHEMATICAL SCRIPT SMALL I" },
	{ 0x1D4BF, "MATHEMATICAL SCRIPT SMALL J" },
	{ 0x1D4C0, "MATHEMATICAL SCRIPT SMALL K" },
	{ 0x1D4C2, "MATHEMATICAL SCRIPT SMALL M" },
	{ 0x1D4C3, "MATHEMATICAL SCRIPT SMALL N" },
	{ 0x1D4C5, "MATHEMATICAL SCRIPT SMALL P" },
	{ 0x1D4C6, "MATHEMATICAL SCRIPT SMALL Q" },
	{ 0x1D4C7, "MATHEMATICAL SCRIPT SMALL R" },
	{ 0x1D4C8, "MATHEMATICAL SCRIPT SMALL S" },
	{ 0x1D4C9, "MATHEMATICAL SCRIPT SMALL T" },
	{ 0x1D4CA, "MATHEMATICAL SCRIPT SMALL U" },
	{ 0x1D4CB, "MATHEMATICAL SCRIPT SMALL V" },
	{ 0x1D4CC, "MATHEMATICAL SCRIPT SMALL W" },
	{ 0x1D4CD, "MATHEMATICAL SCRIPT SMALL X" },
	{ 0x1D4CE, "MATHEMATICAL SCRIPT SMALL Y" },
	{ 0x1D4CF, "MATHEMATICAL SCRIPT SMALL Z" },
	{ 0x1D4D0, "MATHEMATICAL BOLD SCRIPT CAPITAL A" },
	{ 0x1D4D1, "MATHEMATICAL BOLD SCRIPT CAPITAL B" },
	{ 0x1D4D2, "MATHEMATICAL BOLD SCRIPT CAPITAL C" },
	{ 0x1D4D3, "MATHEMATICAL BOLD SCRIPT CAPITAL D" },
	{ 0x1D4D4, "MATHEMATICAL BOLD SCRIPT CAPITAL E" },
	{ 0x1D4D5, "MATHEMATICAL BOLD SCRIPT CAPITAL F" },
	{ 0x1D4D6, "MATHEMATICAL BOLD SCRIPT CAPITAL G" },
	{ 0x1D4D7, "MATHEMATICAL BOLD SCRIPT CAPITAL H" },
	{ 0x1D4D8, "MATHEMATICAL BOLD SCRIPT CAPITAL I" },
	{ 0x1D4D9, "MATHEMATICAL BOLD SCRIPT CAPITAL J" },
	{ 0x1D4DA, "MATHEMATICAL BOLD SCRIPT CAPITAL K" },
	{ 0x1D4DB, "MATHEMATICAL BOLD SCRIPT CAPITAL L" },
	{ 0x1D4DC, "MATHEMATICAL BOLD SCRIPT CAPITAL M" },
	{ 0x1D4DD, "MATHEMATICAL BOLD SCRIPT CAPITAL N" },
	{ 0x1D4DE, "MATHEMATICAL BOLD SCRIPT CAPITAL O" },
	{ 0x1D4DF, "MATHEMATICAL BOLD SCRIPT CAPITAL P" },
	{ 0x1D4E0, "MATHEMATICAL BOLD SCRIPT CAPITAL Q" },
	{ 0x1D4E1, "MATHEMATICAL BOLD SCRIPT CAPITAL R" },
	{ 0x1D4E2, "MATHEMATICAL BOLD SCRIPT CAPITAL S" },
	{ 0x1D4E3, "MATHEMATICAL BOLD SCRIPT CAPITAL T" },
	{ 0x1D4E4, "MATHEMATICAL BOLD SCRIPT CAPITAL U" },
	{ 0x1D4E5, "MATHEMATICAL BOLD SCRIPT CAPITAL V" },
	{ 0x1D4E6, "MATHEMATICAL BOLD SCRIPT CAPITAL W" },
	{ 0x1D4E7, "MATHEMATICAL BOLD SCRIPT CAPITAL X" },
	{ 0x1D4E8, "MATHEMATICAL BOLD SCRIPT CAPITAL Y" },
	{ 0x1D4E9, "MATHEMATICAL BOLD SCRIPT CAPITAL Z" },
	{ 0x1D4EA, "MATHEMATICAL BOLD SCRIPT SMALL A" },
	{ 0x1D4EB, "MATHEMATICAL BOLD SCRIPT SMALL B" },
	{ 0x1D4EC, "MATHEMATICAL BOLD SCRIPT SMALL C" },
	{ 0x1D4ED, "MATHEMATICAL BOLD SCRIPT SMALL D" },
	{ 0x1D4EE, "MATHEMATICAL BOLD SCRIPT SMALL E" },
	{ 0x1D4EF, "MATHEMATICAL BOLD SCRIPT SMALL F" },
	{ 0x1D4F0, "MATHEMATICAL BOLD SCRIPT SMALL G" },
	{ 0x1D4F1, "MATHEMATICAL BOLD SCRIPT SMALL H" },
	{ 0x1D4F2, "MATHEMATICAL BOLD SCRIPT SMALL I" },
	{ 0x1D4F3, "MATHEMATICAL BOLD SCRIPT SMALL J" },
	{ 0x1D4F4, "MATHEMATICAL BOLD SCRIPT SMALL K" },
	{ 0x1D4F5, "MATHEMATICAL BOLD SCRIPT SMALL L" },
	{ 0x1D4F6, "MATHEMATICAL BOLD SCRIPT SMALL M" },
	{ 0x1D4F7, "MATHEMATICAL BOLD SCRIPT SMALL N" },
	{ 0x1D4F8, "MATHEMATICAL BOLD SCRIPT SMALL O" },
	{ 0x1D4F9, "MATHEMATICAL BOLD SCRIPT SMALL P" },
	{ 0x1D4FA, "MATHEMATICAL BOLD SCRIPT SMALL Q" },
	{ 0x1D4FB, "MATHEMATICAL BOLD SCRIPT SMALL R" },
	{ 0x1D4FC, "MATHEMATICAL BOLD SCRIPT SMALL S" },
	{ 0x1D4FD, "MATHEMATICAL BOLD SCRIPT SMALL T" },
	{ 0x1D4FE, "MATHEMATICAL BOLD SCRIPT SMALL U" },
	{ 0x1D4FF, "MATHEMATICAL BOLD SCRIPT SMALL V" },
	{ 0x1D500, "MATHEMATICAL BOLD SCRIPT SMALL W" },
	{ 0x1D501, "MATHEMATICAL BOLD SCRIPT SMALL X" },
	{ 0x1D502, "MATHEMATICAL BOLD SCRIPT SMALL Y" },
	{ 0x1D503, "MATHEMATICAL BOLD SCRIPT SMALL Z" },
	{ 0x1D504, "MATHEMATICAL FRAKTUR CAPITAL A" },
	{ 0x1D505, "MATHEMATICAL FRAKTUR CAPITAL B" },
	{ 0x1D507, "MATHEMATICAL FRAKTUR CAPITAL D" },
	{ 0x1D508, "MATHEMATICAL FRAKTUR CAPITAL E" },
	{ 0x1D509, "MATHEMATICAL FRAKTUR CAPITAL F" },
	{ 0x1D50A, "MATHEMATICAL FRAKTUR CAPITAL G" },
	{ 0x1D50D, "MATHEMATICAL FRAKTUR CAPITAL J" },
	{ 0x1D50E, "MATHEMATICAL FRAKTUR CAPITAL K" },
	{ 0x1D50F, "MATHEMATICAL FRAKTUR CAPITAL L" },
	{ 0x1D510, "MATHEMATICAL FRAKTUR CAPITAL M" },
	{ 0x1D511, "MATHEMATICAL FRAKTUR CAPITAL N" },
	{ 0x1D512, "MATHEMATICAL FRAKTUR CAPITAL O" },
	{ 0x1D513, "MATHEMATICAL FRAKTUR CAPITAL P" },
	{ 0x1D514, "MATHEMATICAL FRAKTUR CAPITAL Q" },
	{ 0x1D516, "MATHEMATICAL FRAKTUR CAPITAL S" },
	{ 0x1D517, "MATHEMATICAL FRAKTUR CAPITAL T" },
	{ 0x1D518, "MATHEMATICAL FRAKTUR CAPITAL U" },
	{ 0x1D519, "MATHEMATICAL FRAKTUR CAPITAL V" },
	{ 0x1D51A, "MATHEMATICAL FRAKTUR CAPITAL W" },
	{ 0x1D51B, "MATHEMATICAL FRAKTUR CAPITAL X" },
	{ 0x1D51C, "MATHEMATICAL FRAKTUR CAPITAL Y" },
	{ 0x1D51E, "MATHEMATICAL FRAKTUR SMALL A" },
	{ 0x1D51F, "MATHEMATICAL FRAKTUR SMALL B" },
	{ 0x1D520, "MATHEMATICAL FRAKTUR SMALL C" },
	{ 0x1D521, "MATHEMATICAL FRAKTUR SMALL D" },
	{ 0x1D522, "MATHEMATICAL FRAKTUR SMALL E" },
	{ 0x1D523, "MATHEMATICAL FRAKTUR SMALL F" },
	{ 0x1D524, "MATHEMATICAL FRAKTUR SMALL G" },
	{ 0x1D525, "MATHEMATICAL FRAKTUR SMALL H" },
	{ 0x1D526, "MATHEMATICAL FRAKTUR SMALL I" },
	{ 0x1D527, "MATHEMATICAL FRAKTUR SMALL J" },
	{ 0x1D528, "MATHEMATICAL FRAKTUR SMALL K" },
	{ 0x1D529, "MATHEMATICAL FRAKTUR SMALL L" },
	{ 0x1D52A, "MATHEMATICAL FRAKTUR SMALL M" },
	{ 0x1D52B, "MATHEMATICAL FRAKTUR SMALL N" },
	{ 0x1D52C, "MATHEMATICAL FRAKTUR SMALL O" },
	{ 0x1D52D, "MATHEMATICAL FRAKTUR SMALL P" },
	{ 0x1D52E, "MATHEMATICAL FRAKTUR SMALL Q" },
	{ 0x1D52F, "MATHEMATICAL FRAKTUR SMALL R" },
	{ 0x1D530, "MATHEMATICAL FRAKTUR SMALL S" },
	{ 0x1D531, "MATHEMATICAL FRAKTUR SMALL T" },
	{ 0x1D532, "MATHEMATICAL FRAKTUR SMALL U" },
	{ 0x1D533, "MATHEMATICAL FRAKTUR SMALL V" },
	{ 0x1D534, "MATHEMATICAL FRAKTUR SMALL W" },
	{ 0x1D535, "MATHEMATICAL FRAKTUR SMALL X" },
	{ 0x1D536, "MATHEMATICAL FRAKTUR SMALL Y" },
	{ 0x1D537, "MATHEMATICAL FRAKTUR SMALL Z" },
	{ 0x1D538, "MATHEMATICAL DOUBLE-STRUCK CAPITAL A" },
	{ 0x1D539, "MATHEMATICAL DOUBLE-STRUCK CAPITAL B" },
	{ 0x1D53B, "MATHEMATICAL DOUBLE-STRUCK CAPITAL D" },
	{ 0x1D53C, "MATHEMATICAL DOUBLE-STRUCK CAPITAL E" },
	{ 0x1D53D, "MATHEMATICAL DOUBLE-STRUCK CAPITAL F" },
	{ 0x1D53E, "MATHEMATICAL DOUBLE-STRUCK CAPITAL G" },
	{ 0x1D540, "MATHEMATICAL DOUBLE-STRUCK CAPITAL I" },
	{ 0x1D541, "MATHEMATICAL DOUBLE-STRUCK CAPITAL J" },
	{ 0x1D542, "MATHEMATICAL DOUBLE-STRUCK CAPITAL K" },
	{ 0x1D543, "MATHEMATICAL DOUBLE-STRUCK CAPITAL L" },
	{ 0x1D544, "MATHEMATICAL DOUBLE-STRUCK CAPITAL M" },
	{ 0x1D546, "MATHEMATICAL DOUBLE-STRUCK CAPITAL O" },
	{ 0x1D54A, "MATHEMATICAL DOUBLE-STRUCK CAPITAL S" },
	{ 0x1D54B, "MATHEMATICAL DOUBLE-STRUCK CAPITAL T" },
	{ 0x1D54C, "MATHEMATICAL DOUBLE-STRUCK CAPITAL U" },
	{ 0x1D54D, "MATHEMATICAL DOUBLE-STRUCK CAPITAL V" },
	{ 0x1D54E, "MATHEMATICAL DOUBLE-STRUCK CAPITAL W" },
	{ 0x1D54F, "MATHEMATICAL DOUBLE-STRUCK CAPITAL X" },
	{ 0x1D550, "MATHEMATICAL DOUBLE-STRUCK CAPITAL Y" },
	{ 0x1D552, "MATHEMATICAL DOUBLE-STRUCK SMALL A" },
	{ 0x1D553, "MATHEMATICAL DOUBLE-STRUCK SMALL B" },
	{ 0x1D554, "MATHEMATICAL DOUBLE-STRUCK SMALL C" },
	{ 0x1D555, "MATHEMATICAL DOUBLE-STRUCK SMALL D" },
	{ 0x1D556, "MATHEMATICAL DOUBLE-STRUCK SMALL E" },
	{ 0x1D557, "MATHEMATICAL DOUBLE-STRUCK SMALL F" },
	{ 0x1D558, "MATHEMATICAL DOUBLE-STRUCK SMALL G" },
	{ 0x1D559, "MATHEMATICAL DOUBLE-STRUCK SMALL H" },
	{ 0x1D55A, "MATHEMATICAL DOUBLE-STRUCK SMALL I" },
	{ 0x1D55B, "MATHEMATICAL DOUBLE-STRUCK SMALL J" },
	{ 0x1D55C, "MATHEMATICAL DOUBLE-STRUCK SMALL K" },
	{ 0x1D55D, "MATHEMATICAL DOUBLE-STRUCK SMALL L" },
	{ 0x1D55E, "MATHEMATICAL DOUBLE-STRUCK SMALL M" },
	{ 0x1D55F, "MATHEMATICAL DOUBLE-STRUCK SMALL N" },
	{ 0x1D560, "MATHEMATICAL DOUBLE-STRUCK SMALL O" },
	{ 0x1D561, "MATHEMATICAL DOUBLE-STRUCK SMALL P" },
	{ 0x1D562, "MATHEMATICAL DOUBLE-STRUCK SMALL Q" },
	{ 0x1D563, "MATHEMATICAL DOUBLE-STRUCK SMALL R" },
	{ 0x1D564, "MATHEMATICAL DOUBLE-STRUCK SMALL S" },
	{ 0x1D565, "MATHEMATICAL DOUBLE-STRUCK SMALL T" },
	{ 0x1D566, "MATHEMATICAL DOUBLE-STRUCK SMALL U" },
	{ 0x1D567, "MATHEMATICAL DOUBLE-STRUCK SMALL V" },
	{ 0x1D568, "MATHEMATICAL DOUBLE-STRUCK SMALL W" },
	{ 0x1D569, "MATHEMATICAL DOUBLE-STRUCK SMALL X" },
	{ 0x1D56A, "MATHEMATICAL DOUBLE-STRUCK SMALL Y" },
	{ 0x1D56B, "MATHEMATICAL DOUBLE-STRUCK SMALL Z" },
	{ 0x1D56C, "MATHEMATICAL BOLD FRAKTUR CAPITAL A" },
	{ 0x1D56D, "MATHEMATICAL BOLD FRAKTUR CAPITAL B" },
	{ 0x1D56E, "MATHEMATICAL BOLD FRAKTUR CAPITAL C" },
	{ 0x1D56F, "MATHEMATICAL BOLD FRAKTUR CAPITAL D" },
	{ 0x1D570, "MATHEMATICAL BOLD FRAKTUR CAPITAL E" },
	{ 0x1D571, "MATHEMATICAL BOLD FRAKTUR CAPITAL F" },
	{ 0x1D572, "MATHEMATICAL BOLD FRAKTUR CAPITAL G" },
	{ 0x1D573, "MATHEMATICAL BOLD FRAKTUR CAPITAL H" },
	{ 0x1D574, "MATHEMATICAL BOLD FRAKTUR CAPITAL I" },
	{ 0x1D575, "MATHEMATICAL BOLD FRAKTUR CAPITAL J" },
	{ 0x1D576, "MATHEMATICAL BOLD FRAKTUR CAPITAL K" },
	{ 0x1D577, "MATHEMATICAL BOLD FRAKTUR CAPITAL L" },
	{ 0x1D578, "MATHEMATICAL BOLD FRAKTUR CAPITAL M" },
	{ 0x1D579, "MATHEMATICAL BOLD FRAKTUR CAPITAL N" },
	{ 0x1D57A, "MATHEMATICAL BOLD FRAKTUR CAPITAL O" },
	{ 0x1D57B, "MATHEMATICAL BOLD FRAKTUR CAPITAL P" },
	{ 0x1D57C, "MATHEMATICAL BOLD FRAKTUR CAPITAL Q" },
	{ 0x1D57D, "MATHEMATICAL BOLD FRAKTUR CAPITAL R" },
	{ 0x1D57E, "MATHEMATICAL BOLD FRAKTUR CAPITAL S" },
	{ 0x1D57F, "MATHEMATICAL BOLD FRAKTUR CAPITAL T" },
	{ 0x1D580, "MATHEMATICAL BOLD FRAKTUR CAPITAL U" },
	{ 0x1D581, "MATHEMATICAL BOLD FRAKTUR CAPITAL V" },
	{ 0x1D582, "MATHEMATICAL BOLD FRAKTUR CAPITAL W" },
	{ 0x1D583, "MATHEMATICAL BOLD FRAKTUR CAPITAL X" },
	{ 0x1D584, "MATHEMATICAL BOLD FRAKTUR CAPITAL Y" },
	{ 0x1D585, "MATHEMATICAL BOLD FRAKTUR CAPITAL Z" },
	{ 0x1D586, "MATHEMATICAL BOLD FRAKTUR SMALL A" },
	{ 0x1D587, "MATHEMATICAL BOLD FRAKTUR SMALL B" },
	{ 0x1D588, "MATHEMATICAL BOLD FRAKTUR SMALL C" },
	{ 0x1D589, "MATHEMATICAL BOLD FRAKTUR SMALL D" },
	{ 0x1D58A, "MATHEMATICAL BOLD FRAKTUR SMALL E" },
	{ 0x1D58B, "MATHEMATICAL BOLD FRAKTUR SMALL F" },
	{ 0x1D58C, "MATHEMATICAL BOLD FRAKTUR SMALL G" },
	{ 0x1D58D, "MATHEMATICAL BOLD FRAKTUR SMALL H" },
	{ 0x1D58E, "MATHEMATICAL BOLD FRAKTUR SMALL I" },
	{ 0x1D58F, "MATHEMATICAL BOLD FRAKTUR SMALL J" },
	{ 0x1D590, "MATHEMATICAL BOLD FRAKTUR SMALL K" },
	{ 0x1D591, "MATHEMATICAL BOLD FRAKTUR SMALL L" },
	{ 0x1D592, "MATHEMATICAL BOLD FRAKTUR SMALL M" },
	{ 0x1D593, "MATHEMATICAL BOLD FRAKTUR SMALL N" },
	{ 0x1D594, "MATHEMATICAL BOLD FRAKTUR SMALL O" },
	{ 0x1D595, "MATHEMATICAL BOLD FRAKTUR SMALL P" },
	{ 0x1D596, "MATHEMATICAL BOLD FRAKTUR SMALL Q" },
	{ 0x1D597, "MATHEMATICAL BOLD FRAKTUR SMALL R" },
	{ 0x1D598, "MATHEMATICAL BOLD FRAKTUR SMALL S" },
	{ 0x1D599, "MATHEMATICAL BOLD FRAKTUR SMALL T" },
	{ 0x1D59A, "MATHEMATICAL BOLD FRAKTUR SMALL U" },
	{ 0x1D59B, "MATHEMATICAL BOLD FRAKTUR SMALL V" },
	{ 0x1D59C, "MATHEMATICAL BOLD FRAKTUR SMALL W" },
	{ 0x1D59D, "MATHEMATICAL BOLD FRAKTUR SMALL X" },
	{ 0x1D59E, "MATHEMATICAL BOLD FRAKTUR SMALL Y" },
	{ 0x1D59F, "MATHEMATICAL BOLD FRAKTUR SMALL Z" },
	{ 0x1D5A0, "MATHEMATICAL SANS-SERIF CAPITAL A" },
	{ 0x1D5A1, "MATHEMATICAL SANS-SERIF CAPITAL B" },
	{ 0x1D5A2, "MATHEMATICAL SANS-SERIF CAPITAL C" },
	{ 0x1D5A3, "MATHEMATICAL SANS-SERIF CAPITAL D" },
	{ 0x1D5A4, "MATHEMATICAL SANS-SERIF CAPITAL E" },
	{ 0x1D5A5, "MATHEMATICAL SANS-SERIF CAPITAL F" },
	{ 0x1D5A6, "MATHEMATICAL SANS-SERIF CAPITAL G" },
	{ 0x1D5A7, "MATHEMATICAL SANS-SERIF CAPITAL H" },
	{ 0x1D5A8, "MATHEMATICAL SANS-SERIF CAPITAL I" },
	{ 0x1D5A9, "MATHEMATICAL SANS-SERIF CAPITAL J" },
	{ 0x1D5AA, "MATHEMATICAL SANS-SERIF CAPITAL K" },
	{ 0x1D5AB, "MATHEMATICAL SANS-SERIF CAPITAL L" },
	{ 0x1D5AC, "MATHEMATICAL SANS-SERIF CAPITAL M" },
	{ 0x1D5AD, "MATHEMATICAL SANS-SERIF CAPITAL N" },
	{ 0x1D5AE, "MATHEMATICAL SANS-SERIF CAPITAL O" },
	{ 0x1D5AF, "MATHEMATICAL SANS-SERIF CAPITAL P" },
	{ 0x1D5B0, "MATHEMATICAL SANS-SERIF CAPITAL Q" },
	{ 0x1D5B1, "MATHEMATICAL SANS-SERIF CAPITAL R" },
	{ 0x1D5B2, "MATHEMATICAL SANS-SERIF CAPITAL S" },
	{ 0x1D5B3, "MATHEMATICAL SANS-SERIF CAPITAL T" },
	{ 0x1D5B4, "MATHEMATICAL SANS-SERIF CAPITAL U" },
	{ 0x1D5B5, "MATHEMATICAL SANS-SERIF CAPITAL V" },
	{ 0x1D5B6, "MATHEMATICAL SANS-SERIF CAPITAL W" },
	{ 0x1D5B7, "MATHEMATICAL SANS-SERIF CAPITAL X" },
	{ 0x1D5B8, "MATHEMATICAL SANS-SERIF CAPITAL Y" },
	{ 0x1D5B9, "MATHEMATICAL SANS-SERIF CAPITAL Z" },
	{ 0x1D5BA, "MATHEMATICAL SANS-SERIF SMALL A" },
	{ 0x1D5BB, "MATHEMATICAL SANS-SERIF SMALL B" },
	{ 0x1D5BC, "MATHEMATICAL SANS-SERIF SMALL C" },
	{ 0x1D5BD, "MATHEMATICAL SANS-SERIF SMALL D" },
	{ 0x1D5BE, "MATHEMATICAL SANS-SERIF SMALL E" },
	{ 0x1D5BF, "MATHEMATICAL SANS-SERIF SMALL F" },
	{ 0x1D5C0, "MATHEMATICAL SANS-SERIF SMALL G" },
	{ 0x1D5C1, "MATHEMATICAL SANS-SERIF SMALL H" },
	{ 0x1D5C2, "MATHEMATICAL SANS-SERIF SMALL I" },
	{ 0x1D5C3, "MATHEMATICAL SANS-SERIF SMALL J" },
	{ 0x1D5C4, "MATHEMATICAL SANS-SERIF SMALL K" },
	{ 0x1D5C5, "MATHEMATICAL SANS-SERIF SMALL L" },
	{ 0x1D5C6, "MATHEMATICAL SANS-SERIF SMALL M" },
	{ 0x1D5C7, "MATHEMATICAL SANS-SERIF SMALL N" },
	{ 0x1D5C8, "MATHEMATICAL SANS-SERIF SMALL O" },
	{ 0x1D5C9, "MATHEMATICAL SANS-SERIF SMALL P" },
	{ 0x1D5CA, "MATHEMATICAL SANS-SERIF SMALL Q" },
	{ 0x1D5CB, "MATHEMATICAL SANS-SERIF SMALL R" },
	{ 0x1D5CC, "MATHEMATICAL SANS-SERIF SMALL S" },
	{ 0x1D5CD, "MATHEMATICAL SANS-SERIF SMALL T" },
	{ 0x1D5CE, "MATHEMATICAL SANS-SERIF SMALL U" },
	{ 0x1D5CF, "MATHEMATICAL SANS-SERIF SMALL V" },
	{ 0x1D5D0, "MATHEMATICAL SANS-SERIF SMALL W" },
	{ 0x1D5D1, "MATHEMATICAL SANS-SERIF SMALL X" },
	{ 0x1D5D2, "MATHEMATICAL SANS-SERIF SMALL Y" },
	{ 0x1D5D3, "MATHEMATICAL SANS-SERIF SMALL Z" },
	{ 0x1D5D4, "MATHEMATICAL SANS-SERIF BOLD CAPITAL A" },
	{ 0x1D5D5, "MATHEMATICAL SANS-SERIF BOLD CAPITAL B" },
	{ 0x1D5D6, "MATHEMATICAL SANS-SERIF BOLD CAPITAL C" },
	{ 0x1D5D7, "MATHEMATICAL SANS-SERIF BOLD CAPITAL D" },
	{ 0x1D5D8, "MATHEMATICAL SANS-SERIF BOLD CAPITAL E" },
	{ 0x1D5D9, "MATHEMATICAL SANS-SERIF BOLD CAPITAL F" },
	{ 0x1D5DA, "MATHEMATICAL SANS-SERIF BOLD CAPITAL G" },
	{ 0x1D5DB, "MATHEMATICAL SANS-SERIF BOLD CAPITAL H" },
	{ 0x1D5DC, "MATHEMATICAL SANS-SERIF BOLD CAPITAL I" },
	{ 0x1D5DD, "MATHEMATICAL SANS-SERIF BOLD CAPITAL J" },
	{ 0x1D5DE, "MATHEMATICAL SANS-SERIF BOLD CAPITAL K" },
	{ 0x1D5DF, "MATHEMATICAL SANS-SERIF BOLD CAPITAL L" },
	{ 0x1D5E0, "MATHEMATICAL SANS-SERIF BOLD CAPITAL M" },
	{ 0x1D5E1, "MATHEMATICAL SANS-SERIF BOLD CAPITAL N" },
	{ 0x1D5E2, "MATHEMATICAL SANS-SERIF BOLD CAPITAL O" },
	{ 0x1D5E3, "MATHEMATICAL SANS-SERIF BOLD CAPITAL P" },
	{ 0x1D5E4, "MATHEMATICAL SANS-SERIF BOLD CAPITAL Q" },
	{ 0x1D5E5, "MATHEMATICAL SANS-SERIF BOLD CAPITAL R" },
	{ 0x1D5E6, "MATHEMATICAL SANS-SERIF BOLD CAPITAL S" },
	{ 0x1D5E7, "MATHEMATICAL SANS-SERIF BOLD CAPITAL T" },
	{ 0x1D5E8, "MATHEMATICAL SANS-SERIF BOLD CAPITAL U" },
	{ 0x1D5E9, "MATHEMATICAL SANS-SERIF BOLD CAPITAL V" },
	{ 0x1D5EA, "MATHEMATICAL SANS-SERIF BOLD CAPITAL W" },
	{ 0x1D5EB, "MATHEMATICAL SANS-SERIF BOLD CAPITAL X" },
	{ 0x1D5EC, "MATHEMATICAL SANS-SERIF BOLD CAPITAL Y" },
	{ 0x1D5ED, "MATHEMATICAL SANS-SERIF BOLD CAPITAL Z" },
	{ 0x1D5EE, "MATHEMATICAL SANS-SERIF BOLD SMALL A" },
	{ 0x1D5EF, "MATHEMATICAL SANS-SERIF BOLD SMALL B" },
	{ 0x1D5F0, "MATHEMATICAL SANS-SERIF BOLD SMALL C" },
	{ 0x1D5F1, "MATHEMATICAL SANS-SERIF BOLD SMALL D" },
	{ 0x1D5F2, "MATHEMATICAL SANS-SERIF BOLD SMALL E" },
	{ 0x1D5F3, "MATHEMATICAL SANS-SERIF BOLD SMALL F" },
	{ 0x1D5F4, "MATHEMATICAL SANS-SERIF BOLD SMALL G" },
	{ 0x1D5F5, "MATHEMATICAL SANS-SERIF BOLD SMALL H" },
	{ 0x1D5F6, "MATHEMATICAL SANS-SERIF BOLD SMALL I" },
	{ 0x1D5F7, "MATHEMATICAL SANS-SERIF BOLD SMALL J" },
	{ 0x1D5F8, "MATHEMATICAL SANS-SERIF BOLD SMALL K" },
	{ 0x1D5F9, "MATHEMATICAL SANS-SERIF BOLD SMALL L" },
	{ 0x1D5FA, "MATHEMATICAL SANS-SERIF BOLD SMALL M" },
	{ 0x1D5FB, "MATHEMATICAL SANS-SERIF BOLD SMALL N" },
	{ 0x1D5FC, "MATHEMATICAL SANS-SERIF BOLD SMALL O" },
	{ 0x1D5FD, "MATHEMATICAL SANS-SERIF BOLD SMALL P" },
	{ 0x1D5FE, "MATHEMATICAL SANS-SERIF BOLD SMALL Q" },
	{ 0x1D5FF, "MATHEMATICAL SANS-SERIF BOLD SMALL R" },
	{ 0x1D600, "MATHEMATICAL SANS-SERIF BOLD SMALL S" },
	{ 0x1D601, "MATHEMATICAL SANS-SERIF BOLD SMALL T" },
	{ 0x1D602, "MATHEMATICAL SANS-SERIF BOLD SMALL U" },
	{ 0x1D603, "MATHEMATICAL SANS-SERIF BOLD SMALL V" },
	{ 0x1D604, "MATHEMATICAL SANS-SERIF BOLD SMALL W" },
	{ 0x1D605, "MATHEMATICAL SANS-SERIF BOLD SMALL X" },
	{ 0x1D606, "MATHEMATICAL SANS-SERIF BOLD SMALL Y" },
	{ 0x1D607, "MATHEMATICAL SANS-SERIF BOLD SMALL Z" },
	{ 0x1D608, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL A" },
	{ 0x1D609, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL B" },
	{ 0x1D60A, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL C" },
	{ 0x1D60B, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL D" },
	{ 0x1D60C, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL E" },
	{ 0x1D60D, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL F" },
	{ 0x1D60E, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL G" },
	{ 0x1D60F, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL H" },
	{ 0x1D610, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL I" },
	{ 0x1D611, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL J" },
	{ 0x1D612, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL K" },
	{ 0x1D613, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL L" },
	{ 0x1D614, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL M" },
	{ 0x1D615, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL N" },
	{ 0x1D616, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL O" },
	{ 0x1D617, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL P" },
	{ 0x1D618, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q" },
	{ 0x1D619, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL R" },
	{ 0x1D61A, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL S" },
	{ 0x1D61B, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL T" },
	{ 0x1D61C, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL U" },
	{ 0x1D61D, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL V" },
	{ 0x1D61E, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL W" },
	{ 0x1D61F, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL X" },
	{ 0x1D620, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y" },
	{ 0x1D621, "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z" },
	{ 0x1D622, "MATHEMATICAL SANS-SERIF ITALIC SMALL A" },
	{ 0x1D623, "MATHEMATICAL SANS-SERIF ITALIC SMALL B" },
	{ 0x1D624, "MATHEMATICAL SANS-SERIF ITALIC SMALL C" },
	{ 0x1D625, "MATHEMATICAL SANS-SERIF ITALIC SMALL D" },
	{ 0x1D626, "MATHEMATICAL SANS-SERIF ITALIC SMALL E" },
	{ 0x1D627, "MATHEMATICAL SANS-SERIF ITALIC SMALL F" },
	{ 0x1D628, "MATHEMATICAL SANS-SERIF ITALIC SMALL G" },
	{ 0x1D629, "MATHEMATICAL SANS-SERIF ITALIC SMALL H" },
	{ 0x1D62A, "MATHEMATICAL SANS-SERIF ITALIC SMALL I" },
	{ 0x1D62B, "MATHEMATICAL SANS-SERIF ITALIC SMALL J" },
	{ 0x1D62C, "MATHEMATICAL SANS-SERIF ITALIC SMALL K" },
	{ 0x1D62D, "MATHEMATICAL SANS-SERIF ITALIC SMALL L" },
	{ 0x1D62E, "MATHEMATICAL SANS-SERIF ITALIC SMALL M" },
	{ 0x1D62F, "MATHEMATICAL SANS-SERIF ITALIC SMALL N" },
	{ 0x1D630, "MATHEMATICAL SANS-SERIF ITALIC SMALL O" },
	{ 0x1D631, "MATHEMATICAL SANS-SERIF ITALIC SMALL P" },
	{ 0x1D632, "MATHEMATICAL SANS-SERIF ITALIC SMALL Q" },
	{ 0x1D633, "MATHEMATICAL SANS-SERIF ITALIC SMALL R" },
	{ 0x1D634, "MATHEMATICAL SANS-SERIF ITALIC SMALL S" },
	{ 0x1D635, "MATHEMATICAL SANS-SERIF ITALIC SMALL T" },
	{ 0x1D636, "MATHEMATICAL SANS-SERIF ITALIC SMALL U" },
	{ 0x1D637, "MATHEMATICAL SANS-SERIF ITALIC SMALL V" },
	{ 0x1D638, "MATHEMATICAL SANS-SERIF ITALIC SMALL W" },
	{ 0x1D639, "MATHEMATICAL SANS-SERIF ITALIC SMALL X" },
	{ 0x1D63A, "MATHEMATICAL SANS-SERIF ITALIC SMALL Y" },
	{ 0x1D63B, "MATHEMATICAL SANS-SERIF ITALIC SMALL Z" },
	{ 0x1D63C, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A" },
	{ 0x1D63D, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B" },
	{ 0x1D63E, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C" },
	{ 0x1D63F, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D" },
	{ 0x1D640, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E" },
	{ 0x1D641, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F" },
	{ 0x1D642, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G" },
	{ 0x1D643, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H" },
	{ 0x1D644, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I" },
	{ 0x1D645, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J" },
	{ 0x1D646, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K" },
	{ 0x1D647, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L" },
	{ 0x1D648, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M" },
	{ 0x1D649, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N" },
	{ 0x1D64A, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O" },
	{ 0x1D64B, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P" },
	{ 0x1D64C, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q" },
	{ 0x1D64D, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R" },
	{ 0x1D64E, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S" },
	{ 0x1D64F, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T" },
	{ 0x1D650, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U" },
	{ 0x1D651, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V" },
	{ 0x1D652, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W" },
	{ 0x1D653, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X" },
	{ 0x1D654, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y" },
	{ 0x1D655, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z" },
	{ 0x1D656, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A" },
	{ 0x1D657, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B" },
	{ 0x1D658, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C" },
	{ 0x1D659, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D" },
	{ 0x1D65A, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E" },
	{ 0x1D65B, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F" },
	{ 0x1D65C, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G" },
	{ 0x1D65D, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H" },
	{ 0x1D65E, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I" },
	{ 0x1D65F, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J" },
	{ 0x1D660, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K" },
	{ 0x1D661, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L" },
	{ 0x1D662, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M" },
	{ 0x1D663, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N" },
	{ 0x1D664, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O" },
	{ 0x1D665, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P" },
	{ 0x1D666, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q" },
	{ 0x1D667, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R" },
	{ 0x1D668, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S" },
	{ 0x1D669, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T" },
	{ 0x1D66A, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U" },
	{ 0x1D66B, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V" },
	{ 0x1D66C, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W" },
	{ 0x1D66D, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X" },
	{ 0x1D66E, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y" },
	{ 0x1D66F, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z" },
	{ 0x1D670, "MATHEMATICAL MONOSPACE CAPITAL A" },
	{ 0x1D671, "MATHEMATICAL MONOSPACE CAPITAL B" },
	{ 0x1D672, "MATHEMATICAL MONOSPACE CAPITAL C" },
	{ 0x1D673, "MATHEMATICAL MONOSPACE CAPITAL D" },
	{ 0x1D674, "MATHEMATICAL MONOSPACE CAPITAL E" },
	{ 0x1D675, "MATHEMATICAL MONOSPACE CAPITAL F" },
	{ 0x1D676, "MATHEMATICAL MONOSPACE CAPITAL G" },
	{ 0x1D677, "MATHEMATICAL MONOSPACE CAPITAL H" },
	{ 0x1D678, "MATHEMATICAL MONOSPACE CAPITAL I" },
	{ 0x1D679, "MATHEMATICAL MONOSPACE CAPITAL J" },
	{ 0x1D67A, "MATHEMATICAL MONOSPACE CAPITAL K" },
	{ 0x1D67B, "MATHEMATICAL MONOSPACE CAPITAL L" },
	{ 0x1D67C, "MATHEMATICAL MONOSPACE CAPITAL M" },
	{ 0x1D67D, "MATHEMATICAL MONOSPACE CAPITAL N" },
	{ 0x1D67E, "MATHEMATICAL MONOSPACE CAPITAL O" },
	{ 0x1D67F, "MATHEMATICAL MONOSPACE CAPITAL P" },
	{ 0x1D680, "MATHEMATICAL MONOSPACE CAPITAL Q" },
	{ 0x1D681, "MATHEMATICAL MONOSPACE CAPITAL R" },
	{ 0x1D682, "MATHEMATICAL MONOSPACE CAPITAL S" },
	{ 0x1D683, "MATHEMATICAL MONOSPACE CAPITAL T" },
	{ 0x1D684, "MATHEMATICAL MONOSPACE CAPITAL U" },
	{ 0x1D685, "MATHEMATICAL MONOSPACE CAPITAL V" },
	{ 0x1D686, "MATHEMATICAL MONOSPACE CAPITAL W" },
	{ 0x1D687, "MATHEMATICAL MONOSPACE CAPITAL X" },
	{ 0x1D688, "MATHEMATICAL MONOSPACE CAPITAL Y" },
	{ 0x1D689, "MATHEMATICAL MONOSPACE CAPITAL Z" },
	{ 0x1D68A, "MATHEMATICAL MONOSPACE SMALL A" },
	{ 0x1D68B, "MATHEMATICAL MONOSPACE SMALL B" },
	{ 0x1D68C, "MATHEMATICAL MONOSPACE SMALL C" },
	{ 0x1D68D, "MATHEMATICAL MONOSPACE SMALL D" },
	{ 0x1D68E, "MATHEMATICAL MONOSPACE SMALL E" },
	{ 0x1D68F, "MATHEMATICAL MONOSPACE SMALL F" },
	{ 0x1D690, "MATHEMATICAL MONOSPACE SMALL G" },
	{ 0x1D691, "MATHEMATICAL MONOSPACE SMALL H" },
	{ 0x1D692, "MATHEMATICAL MONOSPACE SMALL I" },
	{ 0x1D693, "MATHEMATICAL MONOSPACE SMALL J" },
	{ 0x1D694, "MATHEMATICAL MONOSPACE SMALL K" },
	{ 0x1D695, "MATHEMATICAL MONOSPACE SMALL L" },
	{ 0x1D696, "MATHEMATICAL MONOSPACE SMALL M" },
	{ 0x1D697, "MATHEMATICAL MONOSPACE SMALL N" },
	{ 0x1D698, "MATHEMATICAL MONOSPACE SMALL O" },
	{ 0x1D699, "MATHEMATICAL MONOSPACE SMALL P" },
	{ 0x1D69A, "MATHEMATICAL MONOSPACE SMALL Q" },
	{ 0x1D69B, "MATHEMATICAL MONOSPACE SMALL R" },
	{ 0x1D69C, "MATHEMATICAL MONOSPACE SMALL S" },
	{ 0x1D69D, "MATHEMATICAL MONOSPACE SMALL T" },
	{ 0x1D69E, "MATHEMATICAL MONOSPACE SMALL U" },
	{ 0x1D69F, "MATHEMATICAL MONOSPACE SMALL V" },
	{ 0x1D6A0, "MATHEMATICAL MONOSPACE SMALL W" },
	{ 0x1D6A1, "MATHEMATICAL MONOSPACE SMALL X" },
	{ 0x1D6A2, "MATHEMATICAL MONOSPACE SMALL Y" },
	{ 0x1D6A3, "MATHEMATICAL MONOSPACE SMALL Z" },
	{ 0x1D6A8, "MATHEMATICAL BOLD CAPITAL ALPHA" },
	{ 0x1D6A9, "MATHEMATICAL BOLD CAPITAL BETA" },
	{ 0x1D6AA, "MATHEMATICAL BOLD CAPITAL GAMMA" },
	{ 0x1D6AB, "MATHEMATICAL BOLD CAPITAL DELTA" },
	{ 0x1D6AC, "MATHEMATICAL BOLD CAPITAL EPSILON" },
	{ 0x1D6AD, "MATHEMATICAL BOLD CAPITAL ZETA" },
	{ 0x1D6AE, "MATHEMATICAL BOLD CAPITAL ETA" },
	{ 0x1D6AF, "MATHEMATICAL BOLD CAPITAL THETA" },
	{ 0x1D6B0, "MATHEMATICAL BOLD CAPITAL IOTA" },
	{ 0x1D6B1, "MATHEMATICAL BOLD CAPITAL KAPPA" },
	{ 0x1D6B2, "MATHEMATICAL BOLD CAPITAL LAMDA" },
	{ 0x1D6B3, "MATHEMATICAL BOLD CAPITAL MU" },
	{ 0x1D6B4, "MATHEMATICAL BOLD CAPITAL NU" },
	{ 0x1D6B5, "MATHEMATICAL BOLD CAPITAL XI" },
	{ 0x1D6B6, "MATHEMATICAL BOLD CAPITAL OMICRON" },
	{ 0x1D6B7, "MATHEMATICAL BOLD CAPITAL PI" },
	{ 0x1D6B8, "MATHEMATICAL BOLD CAPITAL RHO" },
	{ 0x1D6B9, "MATHEMATICAL BOLD CAPITAL THETA SYMBOL" },
	{ 0x1D6BA, "MATHEMATICAL BOLD CAPITAL SIGMA" },
	{ 0x1D6BB, "MATHEMATICAL BOLD CAPITAL TAU" },
	{ 0x1D6BC, "MATHEMATICAL BOLD CAPITAL UPSILON" },
	{ 0x1D6BD, "MATHEMATICAL BOLD CAPITAL PHI" },
	{ 0x1D6BE, "MATHEMATICAL BOLD CAPITAL CHI" },
	{ 0x1D6BF, "MATHEMATICAL BOLD CAPITAL PSI" },
	{ 0x1D6C0, "MATHEMATICAL BOLD CAPITAL OMEGA" },
	{ 0x1D6C1, "MATHEMATICAL BOLD NABLA" },
	{ 0x1D6C2, "MATHEMATICAL BOLD SMALL ALPHA" },
	{ 0x1D6C3, "MATHEMATICAL BOLD SMALL BETA" },
	{ 0x1D6C4, "MATHEMATICAL BOLD SMALL GAMMA" },
	{ 0x1D6C5, "MATHEMATICAL BOLD SMALL DELTA" },
	{ 0x1D6C6, "MATHEMATICAL BOLD SMALL EPSILON" },
	{ 0x1D6C7, "MATHEMATICAL BOLD SMALL ZETA" },
	{ 0x1D6C8, "MATHEMATICAL BOLD SMALL ETA" },
	{ 0x1D6C9, "MATHEMATICAL BOLD SMALL THETA" },
	{ 0x1D6CA, "MATHEMATICAL BOLD SMALL IOTA" },
	{ 0x1D6CB, "MATHEMATICAL BOLD SMALL KAPPA" },
	{ 0x1D6CC, "MATHEMATICAL BOLD SMALL LAMDA" },
	{ 0x1D6CD, "MATHEMATICAL BOLD SMALL MU" },
	{ 0x1D6CE, "MATHEMATICAL BOLD SMALL NU" },
	{ 0x1D6CF, "MATHEMATICAL BOLD SMALL XI" },
	{ 0x1D6D0, "MATHEMATICAL BOLD SMALL OMICRON" },
	{ 0x1D6D1, "MATHEMATICAL BOLD SMALL PI" },
	{ 0x1D6D2, "MATHEMATICAL BOLD SMALL RHO" },
	{ 0x1D6D3, "MATHEMATICAL BOLD SMALL FINAL SIGMA" },
	{ 0x1D6D4, "MATHEMATICAL BOLD SMALL SIGMA" },
	{ 0x1D6D5, "MATHEMATICAL BOLD SMALL TAU" },
	{ 0x1D6D6, "MATHEMATICAL BOLD SMALL UPSILON" },
	{ 0x1D6D7, "MATHEMATICAL BOLD SMALL PHI" },
	{ 0x1D6D8, "MATHEMATICAL BOLD SMALL CHI" },
	{ 0x1D6D9, "MATHEMATICAL BOLD SMALL PSI" },
	{ 0x1D6DA, "MATHEMATICAL BOLD SMALL OMEGA" },
	{ 0x1D6DB, "MATHEMATICAL BOLD PARTIAL DIFFERENTIAL" },
	{ 0x1D6DC, "MATHEMATICAL BOLD EPSILON SYMBOL" },
	{ 0x1D6DD, "MATHEMATICAL BOLD THETA SYMBOL" },
	{ 0x1D6DE, "MATHEMATICAL BOLD KAPPA SYMBOL" },
	{ 0x1D6DF, "MATHEMATICAL BOLD PHI SYMBOL" },
	{ 0x1D6E0, "MATHEMATICAL BOLD RHO SYMBOL" },
	{ 0x1D6E1, "MATHEMATICAL BOLD PI SYMBOL" },
	{ 0x1D6E2, "MATHEMATICAL ITALIC CAPITAL ALPHA" },
	{ 0x1D6E3, "MATHEMATICAL ITALIC CAPITAL BETA" },
	{ 0x1D6E4, "MATHEMATICAL ITALIC CAPITAL GAMMA" },
	{ 0x1D6E5, "MATHEMATICAL ITALIC CAPITAL DELTA" },
	{ 0x1D6E6, "MATHEMATICAL ITALIC CAPITAL EPSILON" },
	{ 0x1D6E7, "MATHEMATICAL ITALIC CAPITAL ZETA" },
	{ 0x1D6E8, "MATHEMATICAL ITALIC CAPITAL ETA" },
	{ 0x1D6E9, "MATHEMATICAL ITALIC CAPITAL THETA" },
	{ 0x1D6EA, "MATHEMATICAL ITALIC CAPITAL IOTA" },
	{ 0x1D6EB, "MATHEMATICAL ITALIC CAPITAL KAPPA" },
	{ 0x1D6EC, "MATHEMATICAL ITALIC CAPITAL LAMDA" },
	{ 0x1D6ED, "MATHEMATICAL ITALIC CAPITAL MU" },
	{ 0x1D6EE, "MATHEMATICAL ITALIC CAPITAL NU" },
	{ 0x1D6EF, "MATHEMATICAL ITALIC CAPITAL XI" },
	{ 0x1D6F0, "MATHEMATICAL ITALIC CAPITAL OMICRON" },
	{ 0x1D6F1, "MATHEMATICAL ITALIC CAPITAL PI" },
	{ 0x1D6F2, "MATHEMATICAL ITALIC CAPITAL RHO" },
	{ 0x1D6F3, "MATHEMATICAL ITALIC CAPITAL THETA SYMBOL" },
	{ 0x1D6F4, "MATHEMATICAL ITALIC CAPITAL SIGMA" },
	{ 0x1D6F5, "MATHEMATICAL ITALIC CAPITAL TAU" },
	{ 0x1D6F6, "MATHEMATICAL ITALIC CAPITAL UPSILON" },
	{ 0x1D6F7, "MATHEMATICAL ITALIC CAPITAL PHI" },
	{ 0x1D6F8, "MATHEMATICAL ITALIC CAPITAL CHI" },
	{ 0x1D6F9, "MATHEMATICAL ITALIC CAPITAL PSI" },
	{ 0x1D6FA, "MATHEMATICAL ITALIC CAPITAL OMEGA" },
	{ 0x1D6FB, "MATHEMATICAL ITALIC NABLA" },
	{ 0x1D6FC, "MATHEMATICAL ITALIC SMALL ALPHA" },
	{ 0x1D6FD, "MATHEMATICAL ITALIC SMALL BETA" },
	{ 0x1D6FE, "MATHEMATICAL ITALIC SMALL GAMMA" },
	{ 0x1D6FF, "MATHEMATICAL ITALIC SMALL DELTA" },
	{ 0x1D700, "MATHEMATICAL ITALIC SMALL EPSILON" },
	{ 0x1D701, "MATHEMATICAL ITALIC SMALL ZETA" },
	{ 0x1D702, "MATHEMATICAL ITALIC SMALL ETA" },
	{ 0x1D703, "MATHEMATICAL ITALIC SMALL THETA" },
	{ 0x1D704, "MATHEMATICAL ITALIC SMALL IOTA" },
	{ 0x1D705, "MATHEMATICAL ITALIC SMALL KAPPA" },
	{ 0x1D706, "MATHEMATICAL ITALIC SMALL LAMDA" },
	{ 0x1D707, "MATHEMATICAL ITALIC SMALL MU" },
	{ 0x1D708, "MATHEMATICAL ITALIC SMALL NU" },
	{ 0x1D709, "MATHEMATICAL ITALIC SMALL XI" },
	{ 0x1D70A, "MATHEMATICAL ITALIC SMALL OMICRON" },
	{ 0x1D70B, "MATHEMATICAL ITALIC SMALL PI" },
	{ 0x1D70C, "MATHEMATICAL ITALIC SMALL RHO" },
	{ 0x1D70D, "MATHEMATICAL ITALIC SMALL FINAL SIGMA" },
	{ 0x1D70E, "MATHEMATICAL ITALIC SMALL SIGMA" },
	{ 0x1D70F, "MATHEMATICAL ITALIC SMALL TAU" },
	{ 0x1D710, "MATHEMATICAL ITALIC SMALL UPSILON" },
	{ 0x1D711, "MATHEMATICAL ITALIC SMALL PHI" },
	{ 0x1D712, "MATHEMATICAL ITALIC SMALL CHI" },
	{ 0x1D713, "MATHEMATICAL ITALIC SMALL PSI" },
	{ 0x1D714, "MATHEMATICAL ITALIC SMALL OMEGA" },
	{ 0x1D715, "MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL" },
	{ 0x1D716, "MATHEMATICAL ITALIC EPSILON SYMBOL" },
	{ 0x1D717, "MATHEMATICAL ITALIC THETA SYMBOL" },
	{ 0x1D718, "MATHEMATICAL ITALIC KAPPA SYMBOL" },
	{ 0x1D719, "MATHEMATICAL ITALIC PHI SYMBOL" },
	{ 0x1D71A, "MATHEMATICAL ITALIC RHO SYMBOL" },
	{ 0x1D71B, "MATHEMATICAL ITALIC PI SYMBOL" },
	{ 0x1D71C, "MATHEMATICAL BOLD ITALIC CAPITAL ALPHA" },
	{ 0x1D71D, "MATHEMATICAL BOLD ITALIC CAPITAL BETA" },
	{ 0x1D71E, "MATHEMATICAL BOLD ITALIC CAPITAL GAMMA" },
	{ 0x1D71F, "MATHEMATICAL BOLD ITALIC CAPITAL DELTA" },
	{ 0x1D720, "MATHEMATICAL BOLD ITALIC CAPITAL EPSILON" },
	{ 0x1D721, "MATHEMATICAL BOLD ITALIC CAPITAL ZETA" },
	{ 0x1D722, "MATHEMATICAL BOLD ITALIC CAPITAL ETA" },
	{ 0x1D723, "MATHEMATICAL BOLD ITALIC CAPITAL THETA" },
	{ 0x1D724, "MATHEMATICAL BOLD ITALIC CAPITAL IOTA" },
	{ 0x1D725, "MATHEMATICAL BOLD ITALIC CAPITAL KAPPA" },
	{ 0x1D726, "MATHEMATICAL BOLD ITALIC CAPITAL LAMDA" },
	{ 0x1D727, "MATHEMATICAL BOLD ITALIC CAPITAL MU" },
	{ 0x1D728, "MATHEMATICAL BOLD ITALIC CAPITAL NU" },
	{ 0x1D729, "MATHEMATICAL BOLD ITALIC CAPITAL XI" },
	{ 0x1D72A, "MATHEMATICAL BOLD ITALIC CAPITAL OMICRON" },
	{ 0x1D72B, "MATHEMATICAL BOLD ITALIC CAPITAL PI" },
	{ 0x1D72C, "MATHEMATICAL BOLD ITALIC CAPITAL RHO" },
	{ 0x1D72D, "MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL" },
	{ 0x1D72E, "MATHEMATICAL BOLD ITALIC CAPITAL SIGMA" },
	{ 0x1D72F, "MATHEMATICAL BOLD ITALIC CAPITAL TAU" },
	{ 0x1D730, "MATHEMATICAL BOLD ITALIC CAPITAL UPSILON" },
	{ 0x1D731, "MATHEMATICAL BOLD ITALIC CAPITAL PHI" },
	{ 0x1D732, "MATHEMATICAL BOLD ITALIC CAPITAL CHI" },
	{ 0x1D733, "MATHEMATICAL BOLD ITALIC CAPITAL PSI" },
	{ 0x1D734, "MATHEMATICAL BOLD ITALIC CAPITAL OMEGA" },
	{ 0x1D735, "MATHEMATICAL BOLD ITALIC NABLA" },
	{ 0x1D736, "MATHEMATICAL BOLD ITALIC SMALL ALPHA" },
	{ 0x1D737, "MATHEMATICAL BOLD ITALIC SMALL BETA" },
	{ 0x1D738, "MATHEMATICAL BOLD ITALIC SMALL GAMMA" },
	{ 0x1D739, "MATHEMATICAL BOLD ITALIC SMALL DELTA" },
	{ 0x1D73A, "MATHEMATICAL BOLD ITALIC SMALL EPSILON" },
	{ 0x1D73B, "MATHEMATICAL BOLD ITALIC SMALL ZETA" },
	{ 0x1D73C, "MATHEMATICAL BOLD ITALIC SMALL ETA" },
	{ 0x1D73D, "MATHEMATICAL BOLD ITALIC SMALL THETA" },
	{ 0x1D73E, "MATHEMATICAL BOLD ITALIC SMALL IOTA" },
	{ 0x1D73F, "MATHEMATICAL BOLD ITALIC SMALL KAPPA" },
	{ 0x1D740, "MATHEMATICAL BOLD ITALIC SMALL LAMDA" },
	{ 0x1D741, "MATHEMATICAL BOLD ITALIC SMALL MU" },
	{ 0x1D742, "MATHEMATICAL BOLD ITALIC SMALL NU" },
	{ 0x1D743, "MATHEMATICAL BOLD ITALIC SMALL XI" },
	{ 0x1D744, "MATHEMATICAL BOLD ITALIC SMALL OMICRON" },
	{ 0x1D745, "MATHEMATICAL BOLD ITALIC SMALL PI" },
	{ 0x1D746, "MATHEMATICAL BOLD ITALIC SMALL RHO" },
	{ 0x1D747, "MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA" },
	{ 0x1D748, "MATHEMATICAL BOLD ITALIC SMALL SIGMA" },
	{ 0x1D749, "MATHEMATICAL BOLD ITALIC SMALL TAU" },
	{ 0x1D74A, "MATHEMATICAL BOLD ITALIC SMALL UPSILON" },
	{ 0x1D74B, "MATHEMATICAL BOLD ITALIC SMALL PHI" },
	{ 0x1D74C, "MATHEMATICAL BOLD ITALIC SMALL CHI" },
	{ 0x1D74D, "MATHEMATICAL BOLD ITALIC SMALL PSI" },
	{ 0x1D74E, "MATHEMATICAL BOLD ITALIC SMALL OMEGA" },
	{ 0x1D74F, "MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL" },
	{ 0x1D750, "MATHEMATICAL BOLD ITALIC EPSILON SYMBOL" },
	{ 0x1D751, "MATHEMATICAL BOLD ITALIC THETA SYMBOL" },
	{ 0x1D752, "MATHEMATICAL BOLD ITALIC KAPPA SYMBOL" },
	{ 0x1D753, "MATHEMATICAL BOLD ITALIC PHI SYMBOL" },
	{ 0x1D754, "MATHEMATICAL BOLD ITALIC RHO SYMBOL" },
	{ 0x1D755, "MATHEMATICAL BOLD ITALIC PI SYMBOL" },
	{ 0x1D756, "MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA" },
	{ 0x1D757, "MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA" },
	{ 0x1D758, "MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA" },
	{ 0x1D759, "MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA" },
	{ 0x1D75A, "MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON" },
	{ 0x1D75B, "MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA" },
	{ 0x1D75C, "MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA" },
	{ 0x1D75D, "MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA" },
	{ 0x1D75E, "MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA" },
	{ 0x1D75F, "MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA" },
	{ 0x1D760, "MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA" },
	{ 0x1D761, "MATHEMATICAL SANS-SERIF BOLD CAPITAL MU" },
	{ 0x1D762, "MATHEMATICAL SANS-SERIF BOLD CAPITAL NU" },
	{ 0x1D763, "MATHEMATICAL SANS-SERIF BOLD CAPITAL XI" },
	{ 0x1D764, "MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON" },
	{ 0x1D765, "MATHEMATICAL SANS-SERIF BOLD CAPITAL PI" },
	{ 0x1D766, "MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO" },
	{ 0x1D767, "MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL" },
	{ 0x1D768, "MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA" },
	{ 0x1D769, "MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU" },
	{ 0x1D76A, "MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON" },
	{ 0x1D76B, "MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI" },
	{ 0x1D76C, "MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI" },
	{ 0x1D76D, "MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI" },
	{ 0x1D76E, "MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA" },
	{ 0x1D76F, "MATHEMATICAL SANS-SERIF BOLD NABLA" },
	{ 0x1D770, "MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA" },
	{ 0x1D771, "MATHEMATICAL SANS-SERIF BOLD SMALL BETA" },
	{ 0x1D772, "MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA" },
	{ 0x1D773, "MATHEMATICAL SANS-SERIF BOLD SMALL DELTA" },
	{ 0x1D774, "MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON" },
	{ 0x1D775, "MATHEMATICAL SANS-SERIF BOLD SMALL ZETA" },
	{ 0x1D776, "MATHEMATICAL SANS-SERIF BOLD SMALL ETA" },
	{ 0x1D777, "MATHEMATICAL SANS-SERIF BOLD SMALL THETA" },
	{ 0x1D778, "MATHEMATICAL SANS-SERIF BOLD SMALL IOTA" },
	{ 0x1D779, "MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA" },
	{ 0x1D77A, "MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA" },
	{ 0x1D77B, "MATHEMATICAL SANS-SERIF BOLD SMALL MU" },
	{ 0x1D77C, "MATHEMATICAL SANS-SERIF BOLD SMALL NU" },
	{ 0x1D77D, "MATHEMATICAL SANS-SERIF BOLD SMALL XI" },
	{ 0x1D77E, "MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON" },
	{ 0x1D77F, "MATHEMATICAL SANS-SERIF BOLD SMALL PI" },
	{ 0x1D780, "MATHEMATICAL SANS-SERIF BOLD SMALL RHO" },
	{ 0x1D781, "MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA" },
	{ 0x1D782, "MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA" },
	{ 0x1D783, "MATHEMATICAL SANS-SERIF BOLD SMALL TAU" },
	{ 0x1D784, "MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON" },
	{ 0x1D785, "MATHEMATICAL SANS-SERIF BOLD SMALL PHI" },
	{ 0x1D786, "MATHEMATICAL SANS-SERIF BOLD SMALL CHI" },
	{ 0x1D787, "MATHEMATICAL SANS-SERIF BOLD SMALL PSI" },
	{ 0x1D788, "MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA" },
	{ 0x1D789, "MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL" },
	{ 0x1D78A, "MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL" },
	{ 0x1D78B, "MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL" },
	{ 0x1D78C, "MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL" },
	{ 0x1D78D, "MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL" },
	{ 0x1D78E, "MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL" },
	{ 0x1D78F, "MATHEMATICAL SANS-SERIF BOLD PI SYMBOL" },
	{ 0x1D790, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA" },
	{ 0x1D791, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA" },
	{ 0x1D792, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA" },
	{ 0x1D793, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA" },
	{ 0x1D794, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON" },
	{ 0x1D795, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA" },
	{ 0x1D796, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA" },
	{ 0x1D797, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA" },
	{ 0x1D798, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA" },
	{ 0x1D799, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA" },
	{ 0x1D79A, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA" },
	{ 0x1D79B, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU" },
	{ 0x1D79C, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU" },
	{ 0x1D79D, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI" },
	{ 0x1D79E, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON" },
	{ 0x1D79F, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI" },
	{ 0x1D7A0, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO" },
	{ 0x1D7A1, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL" },
	{ 0x1D7A2, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA" },
	{ 0x1D7A3, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU" },
	{ 0x1D7A4, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON" },
	{ 0x1D7A5, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI" },
	{ 0x1D7A6, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI" },
	{ 0x1D7A7, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI" },
	{ 0x1D7A8, "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA" },
	{ 0x1D7A9, "MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA" },
	{ 0x1D7AA, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA" },
	{ 0x1D7AB, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA" },
	{ 0x1D7AC, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA" },
	{ 0x1D7AD, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA" },
	{ 0x1D7AE, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON" },
	{ 0x1D7AF, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA" },
	{ 0x1D7B0, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA" },
	{ 0x1D7B1, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA" },
	{ 0x1D7B2, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA" },
	{ 0x1D7B3, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA" },
	{ 0x1D7B4, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA" },
	{ 0x1D7B5, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU" },
	{ 0x1D7B6, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU" },
	{ 0x1D7B7, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI" },
	{ 0x1D7B8, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON" },
	{ 0x1D7B9, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI" },
	{ 0x1D7BA, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO" },
	{ 0x1D7BB, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA" },
	{ 0x1D7BC, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA" },
	{ 0x1D7BD, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU" },
	{ 0x1D7BE, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON" },
	{ 0x1D7BF, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI" },
	{ 0x1D7C0, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI" },
	{ 0x1D7C1, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI" },
	{ 0x1D7C2, "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA" },
	{ 0x1D7C3, "MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL" },
	{ 0x1D7C4, "MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL" },
	{ 0x1D7C5, "MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL" },
	{ 0x1D7C6, "MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL" },
	{ 0x1D7C7, "MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL" },
	{ 0x1D7C8, "MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL" },
	{ 0x1D7C9, "MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL" },
	{ 0x1D7CE, "MATHEMATICAL BOLD DIGIT ZERO" },
	{ 0x1D7CF, "MATHEMATICAL BOLD DIGIT ONE" },
	{ 0x1D7D0, "MATHEMATICAL BOLD DIGIT TWO" },
	{ 0x1D7D1, "MATHEMATICAL BOLD DIGIT THREE" },
	{ 0x1D7D2, "MATHEMATICAL BOLD DIGIT FOUR" },
	{ 0x1D7D3, "MATHEMATICAL BOLD DIGIT FIVE" },
	{ 0x1D7D4, "MATHEMATICAL BOLD DIGIT SIX" },
	{ 0x1D7D5, "MATHEMATICAL BOLD DIGIT SEVEN" },
	{ 0x1D7D6, "MATHEMATICAL BOLD DIGIT EIGHT" },
	{ 0x1D7D7, "MATHEMATICAL BOLD DIGIT NINE" },
	{ 0x1D7D8, "MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO" },
	{ 0x1D7D9, "MATHEMATICAL DOUBLE-STRUCK DIGIT ONE" },
	{ 0x1D7DA, "MATHEMATICAL DOUBLE-STRUCK DIGIT TWO" },
	{ 0x1D7DB, "MATHEMATICAL DOUBLE-STRUCK DIGIT THREE" },
	{ 0x1D7DC, "MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR" },
	{ 0x1D7DD, "MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE" },
	{ 0x1D7DE, "MATHEMATICAL DOUBLE-STRUCK DIGIT SIX" },
	{ 0x1D7DF, "MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN" },
	{ 0x1D7E0, "MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT" },
	{ 0x1D7E1, "MATHEMATICAL DOUBLE-STRUCK DIGIT NINE" },
	{ 0x1D7E2, "MATHEMATICAL SANS-SERIF DIGIT ZERO" },
	{ 0x1D7E3, "MATHEMATICAL SANS-SERIF DIGIT ONE" },
	{ 0x1D7E4, "MATHEMATICAL SANS-SERIF DIGIT TWO" },
	{ 0x1D7E5, "MATHEMATICAL SANS-SERIF DIGIT THREE" },
	{ 0x1D7E6, "MATHEMATICAL SANS-SERIF DIGIT FOUR" },
	{ 0x1D7E7, "MATHEMATICAL SANS-SERIF DIGIT FIVE" },
	{ 0x1D7E8, "MATHEMATICAL SANS-SERIF DIGIT SIX" },
	{ 0x1D7E9, "MATHEMATICAL SANS-SERIF DIGIT SEVEN" },
	{ 0x1D7EA, "MATHEMATICAL SANS-SERIF DIGIT EIGHT" },
	{ 0x1D7EB, "MATHEMATICAL SANS-SERIF DIGIT NINE" },
	{ 0x1D7EC, "MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO" },
	{ 0x1D7ED, "MATHEMATICAL SANS-SERIF BOLD DIGIT ONE" },
	{ 0x1D7EE, "MATHEMATICAL SANS-SERIF BOLD DIGIT TWO" },
	{ 0x1D7EF, "MATHEMATICAL SANS-SERIF BOLD DIGIT THREE" },
	{ 0x1D7F0, "MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR" },
	{ 0x1D7F1, "MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE" },
	{ 0x1D7F2, "MATHEMATICAL SANS-SERIF BOLD DIGIT SIX" },
	{ 0x1D7F3, "MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN" },
	{ 0x1D7F4, "MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT" },
	{ 0x1D7F5, "MATHEMATICAL SANS-SERIF BOLD DIGIT NINE" },
	{ 0x1D7F6, "MATHEMATICAL MONOSPACE DIGIT ZERO" },
	{ 0x1D7F7, "MATHEMATICAL MONOSPACE DIGIT ONE" },
	{ 0x1D7F8, "MATHEMATICAL MONOSPACE DIGIT TWO" },
	{ 0x1D7F9, "MATHEMATICAL MONOSPACE DIGIT THREE" },
	{ 0x1D7FA, "MATHEMATICAL MONOSPACE DIGIT FOUR" },
	{ 0x1D7FB, "MATHEMATICAL MONOSPACE DIGIT FIVE" },
	{ 0x1D7FC, "MATHEMATICAL MONOSPACE DIGIT SIX" },
	{ 0x1D7FD, "MATHEMATICAL MONOSPACE DIGIT SEVEN" },
	{ 0x1D7FE, "MATHEMATICAL MONOSPACE DIGIT EIGHT" },
	{ 0x1D7FF, "MATHEMATICAL MONOSPACE DIGIT NINE" },
	{ 0x20000, "<CJK Ideograph Extension B, First>" },
	{ 0x2A6D6, "<CJK Ideograph Extension B, Last>" },
	{ 0x2F800, "CJK COMPATIBILITY IDEOGRAPH-2F800" },
	{ 0x2F801, "CJK COMPATIBILITY IDEOGRAPH-2F801" },
	{ 0x2F802, "CJK COMPATIBILITY IDEOGRAPH-2F802" },
	{ 0x2F803, "CJK COMPATIBILITY IDEOGRAPH-2F803" },
	{ 0x2F804, "CJK COMPATIBILITY IDEOGRAPH-2F804" },
	{ 0x2F805, "CJK COMPATIBILITY IDEOGRAPH-2F805" },
	{ 0x2F806, "CJK COMPATIBILITY IDEOGRAPH-2F806" },
	{ 0x2F807, "CJK COMPATIBILITY IDEOGRAPH-2F807" },
	{ 0x2F808, "CJK COMPATIBILITY IDEOGRAPH-2F808" },
	{ 0x2F809, "CJK COMPATIBILITY IDEOGRAPH-2F809" },
	{ 0x2F80A, "CJK COMPATIBILITY IDEOGRAPH-2F80A" },
	{ 0x2F80B, "CJK COMPATIBILITY IDEOGRAPH-2F80B" },
	{ 0x2F80C, "CJK COMPATIBILITY IDEOGRAPH-2F80C" },
	{ 0x2F80D, "CJK COMPATIBILITY IDEOGRAPH-2F80D" },
	{ 0x2F80E, "CJK COMPATIBILITY IDEOGRAPH-2F80E" },
	{ 0x2F80F, "CJK COMPATIBILITY IDEOGRAPH-2F80F" },
	{ 0x2F810, "CJK COMPATIBILITY IDEOGRAPH-2F810" },
	{ 0x2F811, "CJK COMPATIBILITY IDEOGRAPH-2F811" },
	{ 0x2F812, "CJK COMPATIBILITY IDEOGRAPH-2F812" },
	{ 0x2F813, "CJK COMPATIBILITY IDEOGRAPH-2F813" },
	{ 0x2F814, "CJK COMPATIBILITY IDEOGRAPH-2F814" },
	{ 0x2F815, "CJK COMPATIBILITY IDEOGRAPH-2F815" },
	{ 0x2F816, "CJK COMPATIBILITY IDEOGRAPH-2F816" },
	{ 0x2F817, "CJK COMPATIBILITY IDEOGRAPH-2F817" },
	{ 0x2F818, "CJK COMPATIBILITY IDEOGRAPH-2F818" },
	{ 0x2F819, "CJK COMPATIBILITY IDEOGRAPH-2F819" },
	{ 0x2F81A, "CJK COMPATIBILITY IDEOGRAPH-2F81A" },
	{ 0x2F81B, "CJK COMPATIBILITY IDEOGRAPH-2F81B" },
	{ 0x2F81C, "CJK COMPATIBILITY IDEOGRAPH-2F81C" },
	{ 0x2F81D, "CJK COMPATIBILITY IDEOGRAPH-2F81D" },
	{ 0x2F81E, "CJK COMPATIBILITY IDEOGRAPH-2F81E" },
	{ 0x2F81F, "CJK COMPATIBILITY IDEOGRAPH-2F81F" },
	{ 0x2F820, "CJK COMPATIBILITY IDEOGRAPH-2F820" },
	{ 0x2F821, "CJK COMPATIBILITY IDEOGRAPH-2F821" },
	{ 0x2F822, "CJK COMPATIBILITY IDEOGRAPH-2F822" },
	{ 0x2F823, "CJK COMPATIBILITY IDEOGRAPH-2F823" },
	{ 0x2F824, "CJK COMPATIBILITY IDEOGRAPH-2F824" },
	{ 0x2F825, "CJK COMPATIBILITY IDEOGRAPH-2F825" },
	{ 0x2F826, "CJK COMPATIBILITY IDEOGRAPH-2F826" },
	{ 0x2F827, "CJK COMPATIBILITY IDEOGRAPH-2F827" },
	{ 0x2F828, "CJK COMPATIBILITY IDEOGRAPH-2F828" },
	{ 0x2F829, "CJK COMPATIBILITY IDEOGRAPH-2F829" },
	{ 0x2F82A, "CJK COMPATIBILITY IDEOGRAPH-2F82A" },
	{ 0x2F82B, "CJK COMPATIBILITY IDEOGRAPH-2F82B" },
	{ 0x2F82C, "CJK COMPATIBILITY IDEOGRAPH-2F82C" },
	{ 0x2F82D, "CJK COMPATIBILITY IDEOGRAPH-2F82D" },
	{ 0x2F82E, "CJK COMPATIBILITY IDEOGRAPH-2F82E" },
	{ 0x2F82F, "CJK COMPATIBILITY IDEOGRAPH-2F82F" },
	{ 0x2F830, "CJK COMPATIBILITY IDEOGRAPH-2F830" },
	{ 0x2F831, "CJK COMPATIBILITY IDEOGRAPH-2F831" },
	{ 0x2F832, "CJK COMPATIBILITY IDEOGRAPH-2F832" },
	{ 0x2F833, "CJK COMPATIBILITY IDEOGRAPH-2F833" },
	{ 0x2F834, "CJK COMPATIBILITY IDEOGRAPH-2F834" },
	{ 0x2F835, "CJK COMPATIBILITY IDEOGRAPH-2F835" },
	{ 0x2F836, "CJK COMPATIBILITY IDEOGRAPH-2F836" },
	{ 0x2F837, "CJK COMPATIBILITY IDEOGRAPH-2F837" },
	{ 0x2F838, "CJK COMPATIBILITY IDEOGRAPH-2F838" },
	{ 0x2F839, "CJK COMPATIBILITY IDEOGRAPH-2F839" },
	{ 0x2F83A, "CJK COMPATIBILITY IDEOGRAPH-2F83A" },
	{ 0x2F83B, "CJK COMPATIBILITY IDEOGRAPH-2F83B" },
	{ 0x2F83C, "CJK COMPATIBILITY IDEOGRAPH-2F83C" },
	{ 0x2F83D, "CJK COMPATIBILITY IDEOGRAPH-2F83D" },
	{ 0x2F83E, "CJK COMPATIBILITY IDEOGRAPH-2F83E" },
	{ 0x2F83F, "CJK COMPATIBILITY IDEOGRAPH-2F83F" },
	{ 0x2F840, "CJK COMPATIBILITY IDEOGRAPH-2F840" },
	{ 0x2F841, "CJK COMPATIBILITY IDEOGRAPH-2F841" },
	{ 0x2F842, "CJK COMPATIBILITY IDEOGRAPH-2F842" },
	{ 0x2F843, "CJK COMPATIBILITY IDEOGRAPH-2F843" },
	{ 0x2F844, "CJK COMPATIBILITY IDEOGRAPH-2F844" },
	{ 0x2F845, "CJK COMPATIBILITY IDEOGRAPH-2F845" },
	{ 0x2F846, "CJK COMPATIBILITY IDEOGRAPH-2F846" },
	{ 0x2F847, "CJK COMPATIBILITY IDEOGRAPH-2F847" },
	{ 0x2F848, "CJK COMPATIBILITY IDEOGRAPH-2F848" },
	{ 0x2F849, "CJK COMPATIBILITY IDEOGRAPH-2F849" },
	{ 0x2F84A, "CJK COMPATIBILITY IDEOGRAPH-2F84A" },
	{ 0x2F84B, "CJK COMPATIBILITY IDEOGRAPH-2F84B" },
	{ 0x2F84C, "CJK COMPATIBILITY IDEOGRAPH-2F84C" },
	{ 0x2F84D, "CJK COMPATIBILITY IDEOGRAPH-2F84D" },
	{ 0x2F84E, "CJK COMPATIBILITY IDEOGRAPH-2F84E" },
	{ 0x2F84F, "CJK COMPATIBILITY IDEOGRAPH-2F84F" },
	{ 0x2F850, "CJK COMPATIBILITY IDEOGRAPH-2F850" },
	{ 0x2F851, "CJK COMPATIBILITY IDEOGRAPH-2F851" },
	{ 0x2F852, "CJK COMPATIBILITY IDEOGRAPH-2F852" },
	{ 0x2F853, "CJK COMPATIBILITY IDEOGRAPH-2F853" },
	{ 0x2F854, "CJK COMPATIBILITY IDEOGRAPH-2F854" },
	{ 0x2F855, "CJK COMPATIBILITY IDEOGRAPH-2F855" },
	{ 0x2F856, "CJK COMPATIBILITY IDEOGRAPH-2F856" },
	{ 0x2F857, "CJK COMPATIBILITY IDEOGRAPH-2F857" },
	{ 0x2F858, "CJK COMPATIBILITY IDEOGRAPH-2F858" },
	{ 0x2F859, "CJK COMPATIBILITY IDEOGRAPH-2F859" },
	{ 0x2F85A, "CJK COMPATIBILITY IDEOGRAPH-2F85A" },
	{ 0x2F85B, "CJK COMPATIBILITY IDEOGRAPH-2F85B" },
	{ 0x2F85C, "CJK COMPATIBILITY IDEOGRAPH-2F85C" },
	{ 0x2F85D, "CJK COMPATIBILITY IDEOGRAPH-2F85D" },
	{ 0x2F85E, "CJK COMPATIBILITY IDEOGRAPH-2F85E" },
	{ 0x2F85F, "CJK COMPATIBILITY IDEOGRAPH-2F85F" },
	{ 0x2F860, "CJK COMPATIBILITY IDEOGRAPH-2F860" },
	{ 0x2F861, "CJK COMPATIBILITY IDEOGRAPH-2F861" },
	{ 0x2F862, "CJK COMPATIBILITY IDEOGRAPH-2F862" },
	{ 0x2F863, "CJK COMPATIBILITY IDEOGRAPH-2F863" },
	{ 0x2F864, "CJK COMPATIBILITY IDEOGRAPH-2F864" },
	{ 0x2F865, "CJK COMPATIBILITY IDEOGRAPH-2F865" },
	{ 0x2F866, "CJK COMPATIBILITY IDEOGRAPH-2F866" },
	{ 0x2F867, "CJK COMPATIBILITY IDEOGRAPH-2F867" },
	{ 0x2F868, "CJK COMPATIBILITY IDEOGRAPH-2F868" },
	{ 0x2F869, "CJK COMPATIBILITY IDEOGRAPH-2F869" },
	{ 0x2F86A, "CJK COMPATIBILITY IDEOGRAPH-2F86A" },
	{ 0x2F86B, "CJK COMPATIBILITY IDEOGRAPH-2F86B" },
	{ 0x2F86C, "CJK COMPATIBILITY IDEOGRAPH-2F86C" },
	{ 0x2F86D, "CJK COMPATIBILITY IDEOGRAPH-2F86D" },
	{ 0x2F86E, "CJK COMPATIBILITY IDEOGRAPH-2F86E" },
	{ 0x2F86F, "CJK COMPATIBILITY IDEOGRAPH-2F86F" },
	{ 0x2F870, "CJK COMPATIBILITY IDEOGRAPH-2F870" },
	{ 0x2F871, "CJK COMPATIBILITY IDEOGRAPH-2F871" },
	{ 0x2F872, "CJK COMPATIBILITY IDEOGRAPH-2F872" },
	{ 0x2F873, "CJK COMPATIBILITY IDEOGRAPH-2F873" },
	{ 0x2F874, "CJK COMPATIBILITY IDEOGRAPH-2F874" },
	{ 0x2F875, "CJK COMPATIBILITY IDEOGRAPH-2F875" },
	{ 0x2F876, "CJK COMPATIBILITY IDEOGRAPH-2F876" },
	{ 0x2F877, "CJK COMPATIBILITY IDEOGRAPH-2F877" },
	{ 0x2F878, "CJK COMPATIBILITY IDEOGRAPH-2F878" },
	{ 0x2F879, "CJK COMPATIBILITY IDEOGRAPH-2F879" },
	{ 0x2F87A, "CJK COMPATIBILITY IDEOGRAPH-2F87A" },
	{ 0x2F87B, "CJK COMPATIBILITY IDEOGRAPH-2F87B" },
	{ 0x2F87C, "CJK COMPATIBILITY IDEOGRAPH-2F87C" },
	{ 0x2F87D, "CJK COMPATIBILITY IDEOGRAPH-2F87D" },
	{ 0x2F87E, "CJK COMPATIBILITY IDEOGRAPH-2F87E" },
	{ 0x2F87F, "CJK COMPATIBILITY IDEOGRAPH-2F87F" },
	{ 0x2F880, "CJK COMPATIBILITY IDEOGRAPH-2F880" },
	{ 0x2F881, "CJK COMPATIBILITY IDEOGRAPH-2F881" },
	{ 0x2F882, "CJK COMPATIBILITY IDEOGRAPH-2F882" },
	{ 0x2F883, "CJK COMPATIBILITY IDEOGRAPH-2F883" },
	{ 0x2F884, "CJK COMPATIBILITY IDEOGRAPH-2F884" },
	{ 0x2F885, "CJK COMPATIBILITY IDEOGRAPH-2F885" },
	{ 0x2F886, "CJK COMPATIBILITY IDEOGRAPH-2F886" },
	{ 0x2F887, "CJK COMPATIBILITY IDEOGRAPH-2F887" },
	{ 0x2F888, "CJK COMPATIBILITY IDEOGRAPH-2F888" },
	{ 0x2F889, "CJK COMPATIBILITY IDEOGRAPH-2F889" },
	{ 0x2F88A, "CJK COMPATIBILITY IDEOGRAPH-2F88A" },
	{ 0x2F88B, "CJK COMPATIBILITY IDEOGRAPH-2F88B" },
	{ 0x2F88C, "CJK COMPATIBILITY IDEOGRAPH-2F88C" },
	{ 0x2F88D, "CJK COMPATIBILITY IDEOGRAPH-2F88D" },
	{ 0x2F88E, "CJK COMPATIBILITY IDEOGRAPH-2F88E" },
	{ 0x2F88F, "CJK COMPATIBILITY IDEOGRAPH-2F88F" },
	{ 0x2F890, "CJK COMPATIBILITY IDEOGRAPH-2F890" },
	{ 0x2F891, "CJK COMPATIBILITY IDEOGRAPH-2F891" },
	{ 0x2F892, "CJK COMPATIBILITY IDEOGRAPH-2F892" },
	{ 0x2F893, "CJK COMPATIBILITY IDEOGRAPH-2F893" },
	{ 0x2F894, "CJK COMPATIBILITY IDEOGRAPH-2F894" },
	{ 0x2F895, "CJK COMPATIBILITY IDEOGRAPH-2F895" },
	{ 0x2F896, "CJK COMPATIBILITY IDEOGRAPH-2F896" },
	{ 0x2F897, "CJK COMPATIBILITY IDEOGRAPH-2F897" },
	{ 0x2F898, "CJK COMPATIBILITY IDEOGRAPH-2F898" },
	{ 0x2F899, "CJK COMPATIBILITY IDEOGRAPH-2F899" },
	{ 0x2F89A, "CJK COMPATIBILITY IDEOGRAPH-2F89A" },
	{ 0x2F89B, "CJK COMPATIBILITY IDEOGRAPH-2F89B" },
	{ 0x2F89C, "CJK COMPATIBILITY IDEOGRAPH-2F89C" },
	{ 0x2F89D, "CJK COMPATIBILITY IDEOGRAPH-2F89D" },
	{ 0x2F89E, "CJK COMPATIBILITY IDEOGRAPH-2F89E" },
	{ 0x2F89F, "CJK COMPATIBILITY IDEOGRAPH-2F89F" },
	{ 0x2F8A0, "CJK COMPATIBILITY IDEOGRAPH-2F8A0" },
	{ 0x2F8A1, "CJK COMPATIBILITY IDEOGRAPH-2F8A1" },
	{ 0x2F8A2, "CJK COMPATIBILITY IDEOGRAPH-2F8A2" },
	{ 0x2F8A3, "CJK COMPATIBILITY IDEOGRAPH-2F8A3" },
	{ 0x2F8A4, "CJK COMPATIBILITY IDEOGRAPH-2F8A4" },
	{ 0x2F8A5, "CJK COMPATIBILITY IDEOGRAPH-2F8A5" },
	{ 0x2F8A6, "CJK COMPATIBILITY IDEOGRAPH-2F8A6" },
	{ 0x2F8A7, "CJK COMPATIBILITY IDEOGRAPH-2F8A7" },
	{ 0x2F8A8, "CJK COMPATIBILITY IDEOGRAPH-2F8A8" },
	{ 0x2F8A9, "CJK COMPATIBILITY IDEOGRAPH-2F8A9" },
	{ 0x2F8AA, "CJK COMPATIBILITY IDEOGRAPH-2F8AA" },
	{ 0x2F8AB, "CJK COMPATIBILITY IDEOGRAPH-2F8AB" },
	{ 0x2F8AC, "CJK COMPATIBILITY IDEOGRAPH-2F8AC" },
	{ 0x2F8AD, "CJK COMPATIBILITY IDEOGRAPH-2F8AD" },
	{ 0x2F8AE, "CJK COMPATIBILITY IDEOGRAPH-2F8AE" },
	{ 0x2F8AF, "CJK COMPATIBILITY IDEOGRAPH-2F8AF" },
	{ 0x2F8B0, "CJK COMPATIBILITY IDEOGRAPH-2F8B0" },
	{ 0x2F8B1, "CJK COMPATIBILITY IDEOGRAPH-2F8B1" },
	{ 0x2F8B2, "CJK COMPATIBILITY IDEOGRAPH-2F8B2" },
	{ 0x2F8B3, "CJK COMPATIBILITY IDEOGRAPH-2F8B3" },
	{ 0x2F8B4, "CJK COMPATIBILITY IDEOGRAPH-2F8B4" },
	{ 0x2F8B5, "CJK COMPATIBILITY IDEOGRAPH-2F8B5" },
	{ 0x2F8B6, "CJK COMPATIBILITY IDEOGRAPH-2F8B6" },
	{ 0x2F8B7, "CJK COMPATIBILITY IDEOGRAPH-2F8B7" },
	{ 0x2F8B8, "CJK COMPATIBILITY IDEOGRAPH-2F8B8" },
	{ 0x2F8B9, "CJK COMPATIBILITY IDEOGRAPH-2F8B9" },
	{ 0x2F8BA, "CJK COMPATIBILITY IDEOGRAPH-2F8BA" },
	{ 0x2F8BB, "CJK COMPATIBILITY IDEOGRAPH-2F8BB" },
	{ 0x2F8BC, "CJK COMPATIBILITY IDEOGRAPH-2F8BC" },
	{ 0x2F8BD, "CJK COMPATIBILITY IDEOGRAPH-2F8BD" },
	{ 0x2F8BE, "CJK COMPATIBILITY IDEOGRAPH-2F8BE" },
	{ 0x2F8BF, "CJK COMPATIBILITY IDEOGRAPH-2F8BF" },
	{ 0x2F8C0, "CJK COMPATIBILITY IDEOGRAPH-2F8C0" },
	{ 0x2F8C1, "CJK COMPATIBILITY IDEOGRAPH-2F8C1" },
	{ 0x2F8C2, "CJK COMPATIBILITY IDEOGRAPH-2F8C2" },
	{ 0x2F8C3, "CJK COMPATIBILITY IDEOGRAPH-2F8C3" },
	{ 0x2F8C4, "CJK COMPATIBILITY IDEOGRAPH-2F8C4" },
	{ 0x2F8C5, "CJK COMPATIBILITY IDEOGRAPH-2F8C5" },
	{ 0x2F8C6, "CJK COMPATIBILITY IDEOGRAPH-2F8C6" },
	{ 0x2F8C7, "CJK COMPATIBILITY IDEOGRAPH-2F8C7" },
	{ 0x2F8C8, "CJK COMPATIBILITY IDEOGRAPH-2F8C8" },
	{ 0x2F8C9, "CJK COMPATIBILITY IDEOGRAPH-2F8C9" },
	{ 0x2F8CA, "CJK COMPATIBILITY IDEOGRAPH-2F8CA" },
	{ 0x2F8CB, "CJK COMPATIBILITY IDEOGRAPH-2F8CB" },
	{ 0x2F8CC, "CJK COMPATIBILITY IDEOGRAPH-2F8CC" },
	{ 0x2F8CD, "CJK COMPATIBILITY IDEOGRAPH-2F8CD" },
	{ 0x2F8CE, "CJK COMPATIBILITY IDEOGRAPH-2F8CE" },
	{ 0x2F8CF, "CJK COMPATIBILITY IDEOGRAPH-2F8CF" },
	{ 0x2F8D0, "CJK COMPATIBILITY IDEOGRAPH-2F8D0" },
	{ 0x2F8D1, "CJK COMPATIBILITY IDEOGRAPH-2F8D1" },
	{ 0x2F8D2, "CJK COMPATIBILITY IDEOGRAPH-2F8D2" },
	{ 0x2F8D3, "CJK COMPATIBILITY IDEOGRAPH-2F8D3" },
	{ 0x2F8D4, "CJK COMPATIBILITY IDEOGRAPH-2F8D4" },
	{ 0x2F8D5, "CJK COMPATIBILITY IDEOGRAPH-2F8D5" },
	{ 0x2F8D6, "CJK COMPATIBILITY IDEOGRAPH-2F8D6" },
	{ 0x2F8D7, "CJK COMPATIBILITY IDEOGRAPH-2F8D7" },
	{ 0x2F8D8, "CJK COMPATIBILITY IDEOGRAPH-2F8D8" },
	{ 0x2F8D9, "CJK COMPATIBILITY IDEOGRAPH-2F8D9" },
	{ 0x2F8DA, "CJK COMPATIBILITY IDEOGRAPH-2F8DA" },
	{ 0x2F8DB, "CJK COMPATIBILITY IDEOGRAPH-2F8DB" },
	{ 0x2F8DC, "CJK COMPATIBILITY IDEOGRAPH-2F8DC" },
	{ 0x2F8DD, "CJK COMPATIBILITY IDEOGRAPH-2F8DD" },
	{ 0x2F8DE, "CJK COMPATIBILITY IDEOGRAPH-2F8DE" },
	{ 0x2F8DF, "CJK COMPATIBILITY IDEOGRAPH-2F8DF" },
	{ 0x2F8E0, "CJK COMPATIBILITY IDEOGRAPH-2F8E0" },
	{ 0x2F8E1, "CJK COMPATIBILITY IDEOGRAPH-2F8E1" },
	{ 0x2F8E2, "CJK COMPATIBILITY IDEOGRAPH-2F8E2" },
	{ 0x2F8E3, "CJK COMPATIBILITY IDEOGRAPH-2F8E3" },
	{ 0x2F8E4, "CJK COMPATIBILITY IDEOGRAPH-2F8E4" },
	{ 0x2F8E5, "CJK COMPATIBILITY IDEOGRAPH-2F8E5" },
	{ 0x2F8E6, "CJK COMPATIBILITY IDEOGRAPH-2F8E6" },
	{ 0x2F8E7, "CJK COMPATIBILITY IDEOGRAPH-2F8E7" },
	{ 0x2F8E8, "CJK COMPATIBILITY IDEOGRAPH-2F8E8" },
	{ 0x2F8E9, "CJK COMPATIBILITY IDEOGRAPH-2F8E9" },
	{ 0x2F8EA, "CJK COMPATIBILITY IDEOGRAPH-2F8EA" },
	{ 0x2F8EB, "CJK COMPATIBILITY IDEOGRAPH-2F8EB" },
	{ 0x2F8EC, "CJK COMPATIBILITY IDEOGRAPH-2F8EC" },
	{ 0x2F8ED, "CJK COMPATIBILITY IDEOGRAPH-2F8ED" },
	{ 0x2F8EE, "CJK COMPATIBILITY IDEOGRAPH-2F8EE" },
	{ 0x2F8EF, "CJK COMPATIBILITY IDEOGRAPH-2F8EF" },
	{ 0x2F8F0, "CJK COMPATIBILITY IDEOGRAPH-2F8F0" },
	{ 0x2F8F1, "CJK COMPATIBILITY IDEOGRAPH-2F8F1" },
	{ 0x2F8F2, "CJK COMPATIBILITY IDEOGRAPH-2F8F2" },
	{ 0x2F8F3, "CJK COMPATIBILITY IDEOGRAPH-2F8F3" },
	{ 0x2F8F4, "CJK COMPATIBILITY IDEOGRAPH-2F8F4" },
	{ 0x2F8F5, "CJK COMPATIBILITY IDEOGRAPH-2F8F5" },
	{ 0x2F8F6, "CJK COMPATIBILITY IDEOGRAPH-2F8F6" },
	{ 0x2F8F7, "CJK COMPATIBILITY IDEOGRAPH-2F8F7" },
	{ 0x2F8F8, "CJK COMPATIBILITY IDEOGRAPH-2F8F8" },
	{ 0x2F8F9, "CJK COMPATIBILITY IDEOGRAPH-2F8F9" },
	{ 0x2F8FA, "CJK COMPATIBILITY IDEOGRAPH-2F8FA" },
	{ 0x2F8FB, "CJK COMPATIBILITY IDEOGRAPH-2F8FB" },
	{ 0x2F8FC, "CJK COMPATIBILITY IDEOGRAPH-2F8FC" },
	{ 0x2F8FD, "CJK COMPATIBILITY IDEOGRAPH-2F8FD" },
	{ 0x2F8FE, "CJK COMPATIBILITY IDEOGRAPH-2F8FE" },
	{ 0x2F8FF, "CJK COMPATIBILITY IDEOGRAPH-2F8FF" },
	{ 0x2F900, "CJK COMPATIBILITY IDEOGRAPH-2F900" },
	{ 0x2F901, "CJK COMPATIBILITY IDEOGRAPH-2F901" },
	{ 0x2F902, "CJK COMPATIBILITY IDEOGRAPH-2F902" },
	{ 0x2F903, "CJK COMPATIBILITY IDEOGRAPH-2F903" },
	{ 0x2F904, "CJK COMPATIBILITY IDEOGRAPH-2F904" },
	{ 0x2F905, "CJK COMPATIBILITY IDEOGRAPH-2F905" },
	{ 0x2F906, "CJK COMPATIBILITY IDEOGRAPH-2F906" },
	{ 0x2F907, "CJK COMPATIBILITY IDEOGRAPH-2F907" },
	{ 0x2F908, "CJK COMPATIBILITY IDEOGRAPH-2F908" },
	{ 0x2F909, "CJK COMPATIBILITY IDEOGRAPH-2F909" },
	{ 0x2F90A, "CJK COMPATIBILITY IDEOGRAPH-2F90A" },
	{ 0x2F90B, "CJK COMPATIBILITY IDEOGRAPH-2F90B" },
	{ 0x2F90C, "CJK COMPATIBILITY IDEOGRAPH-2F90C" },
	{ 0x2F90D, "CJK COMPATIBILITY IDEOGRAPH-2F90D" },
	{ 0x2F90E, "CJK COMPATIBILITY IDEOGRAPH-2F90E" },
	{ 0x2F90F, "CJK COMPATIBILITY IDEOGRAPH-2F90F" },
	{ 0x2F910, "CJK COMPATIBILITY IDEOGRAPH-2F910" },
	{ 0x2F911, "CJK COMPATIBILITY IDEOGRAPH-2F911" },
	{ 0x2F912, "CJK COMPATIBILITY IDEOGRAPH-2F912" },
	{ 0x2F913, "CJK COMPATIBILITY IDEOGRAPH-2F913" },
	{ 0x2F914, "CJK COMPATIBILITY IDEOGRAPH-2F914" },
	{ 0x2F915, "CJK COMPATIBILITY IDEOGRAPH-2F915" },
	{ 0x2F916, "CJK COMPATIBILITY IDEOGRAPH-2F916" },
	{ 0x2F917, "CJK COMPATIBILITY IDEOGRAPH-2F917" },
	{ 0x2F918, "CJK COMPATIBILITY IDEOGRAPH-2F918" },
	{ 0x2F919, "CJK COMPATIBILITY IDEOGRAPH-2F919" },
	{ 0x2F91A, "CJK COMPATIBILITY IDEOGRAPH-2F91A" },
	{ 0x2F91B, "CJK COMPATIBILITY IDEOGRAPH-2F91B" },
	{ 0x2F91C, "CJK COMPATIBILITY IDEOGRAPH-2F91C" },
	{ 0x2F91D, "CJK COMPATIBILITY IDEOGRAPH-2F91D" },
	{ 0x2F91E, "CJK COMPATIBILITY IDEOGRAPH-2F91E" },
	{ 0x2F91F, "CJK COMPATIBILITY IDEOGRAPH-2F91F" },
	{ 0x2F920, "CJK COMPATIBILITY IDEOGRAPH-2F920" },
	{ 0x2F921, "CJK COMPATIBILITY IDEOGRAPH-2F921" },
	{ 0x2F922, "CJK COMPATIBILITY IDEOGRAPH-2F922" },
	{ 0x2F923, "CJK COMPATIBILITY IDEOGRAPH-2F923" },
	{ 0x2F924, "CJK COMPATIBILITY IDEOGRAPH-2F924" },
	{ 0x2F925, "CJK COMPATIBILITY IDEOGRAPH-2F925" },
	{ 0x2F926, "CJK COMPATIBILITY IDEOGRAPH-2F926" },
	{ 0x2F927, "CJK COMPATIBILITY IDEOGRAPH-2F927" },
	{ 0x2F928, "CJK COMPATIBILITY IDEOGRAPH-2F928" },
	{ 0x2F929, "CJK COMPATIBILITY IDEOGRAPH-2F929" },
	{ 0x2F92A, "CJK COMPATIBILITY IDEOGRAPH-2F92A" },
	{ 0x2F92B, "CJK COMPATIBILITY IDEOGRAPH-2F92B" },
	{ 0x2F92C, "CJK COMPATIBILITY IDEOGRAPH-2F92C" },
	{ 0x2F92D, "CJK COMPATIBILITY IDEOGRAPH-2F92D" },
	{ 0x2F92E, "CJK COMPATIBILITY IDEOGRAPH-2F92E" },
	{ 0x2F92F, "CJK COMPATIBILITY IDEOGRAPH-2F92F" },
	{ 0x2F930, "CJK COMPATIBILITY IDEOGRAPH-2F930" },
	{ 0x2F931, "CJK COMPATIBILITY IDEOGRAPH-2F931" },
	{ 0x2F932, "CJK COMPATIBILITY IDEOGRAPH-2F932" },
	{ 0x2F933, "CJK COMPATIBILITY IDEOGRAPH-2F933" },
	{ 0x2F934, "CJK COMPATIBILITY IDEOGRAPH-2F934" },
	{ 0x2F935, "CJK COMPATIBILITY IDEOGRAPH-2F935" },
	{ 0x2F936, "CJK COMPATIBILITY IDEOGRAPH-2F936" },
	{ 0x2F937, "CJK COMPATIBILITY IDEOGRAPH-2F937" },
	{ 0x2F938, "CJK COMPATIBILITY IDEOGRAPH-2F938" },
	{ 0x2F939, "CJK COMPATIBILITY IDEOGRAPH-2F939" },
	{ 0x2F93A, "CJK COMPATIBILITY IDEOGRAPH-2F93A" },
	{ 0x2F93B, "CJK COMPATIBILITY IDEOGRAPH-2F93B" },
	{ 0x2F93C, "CJK COMPATIBILITY IDEOGRAPH-2F93C" },
	{ 0x2F93D, "CJK COMPATIBILITY IDEOGRAPH-2F93D" },
	{ 0x2F93E, "CJK COMPATIBILITY IDEOGRAPH-2F93E" },
	{ 0x2F93F, "CJK COMPATIBILITY IDEOGRAPH-2F93F" },
	{ 0x2F940, "CJK COMPATIBILITY IDEOGRAPH-2F940" },
	{ 0x2F941, "CJK COMPATIBILITY IDEOGRAPH-2F941" },
	{ 0x2F942, "CJK COMPATIBILITY IDEOGRAPH-2F942" },
	{ 0x2F943, "CJK COMPATIBILITY IDEOGRAPH-2F943" },
	{ 0x2F944, "CJK COMPATIBILITY IDEOGRAPH-2F944" },
	{ 0x2F945, "CJK COMPATIBILITY IDEOGRAPH-2F945" },
	{ 0x2F946, "CJK COMPATIBILITY IDEOGRAPH-2F946" },
	{ 0x2F947, "CJK COMPATIBILITY IDEOGRAPH-2F947" },
	{ 0x2F948, "CJK COMPATIBILITY IDEOGRAPH-2F948" },
	{ 0x2F949, "CJK COMPATIBILITY IDEOGRAPH-2F949" },
	{ 0x2F94A, "CJK COMPATIBILITY IDEOGRAPH-2F94A" },
	{ 0x2F94B, "CJK COMPATIBILITY IDEOGRAPH-2F94B" },
	{ 0x2F94C, "CJK COMPATIBILITY IDEOGRAPH-2F94C" },
	{ 0x2F94D, "CJK COMPATIBILITY IDEOGRAPH-2F94D" },
	{ 0x2F94E, "CJK COMPATIBILITY IDEOGRAPH-2F94E" },
	{ 0x2F94F, "CJK COMPATIBILITY IDEOGRAPH-2F94F" },
	{ 0x2F950, "CJK COMPATIBILITY IDEOGRAPH-2F950" },
	{ 0x2F951, "CJK COMPATIBILITY IDEOGRAPH-2F951" },
	{ 0x2F952, "CJK COMPATIBILITY IDEOGRAPH-2F952" },
	{ 0x2F953, "CJK COMPATIBILITY IDEOGRAPH-2F953" },
	{ 0x2F954, "CJK COMPATIBILITY IDEOGRAPH-2F954" },
	{ 0x2F955, "CJK COMPATIBILITY IDEOGRAPH-2F955" },
	{ 0x2F956, "CJK COMPATIBILITY IDEOGRAPH-2F956" },
	{ 0x2F957, "CJK COMPATIBILITY IDEOGRAPH-2F957" },
	{ 0x2F958, "CJK COMPATIBILITY IDEOGRAPH-2F958" },
	{ 0x2F959, "CJK COMPATIBILITY IDEOGRAPH-2F959" },
	{ 0x2F95A, "CJK COMPATIBILITY IDEOGRAPH-2F95A" },
	{ 0x2F95B, "CJK COMPATIBILITY IDEOGRAPH-2F95B" },
	{ 0x2F95C, "CJK COMPATIBILITY IDEOGRAPH-2F95C" },
	{ 0x2F95D, "CJK COMPATIBILITY IDEOGRAPH-2F95D" },
	{ 0x2F95E, "CJK COMPATIBILITY IDEOGRAPH-2F95E" },
	{ 0x2F95F, "CJK COMPATIBILITY IDEOGRAPH-2F95F" },
	{ 0x2F960, "CJK COMPATIBILITY IDEOGRAPH-2F960" },
	{ 0x2F961, "CJK COMPATIBILITY IDEOGRAPH-2F961" },
	{ 0x2F962, "CJK COMPATIBILITY IDEOGRAPH-2F962" },
	{ 0x2F963, "CJK COMPATIBILITY IDEOGRAPH-2F963" },
	{ 0x2F964, "CJK COMPATIBILITY IDEOGRAPH-2F964" },
	{ 0x2F965, "CJK COMPATIBILITY IDEOGRAPH-2F965" },
	{ 0x2F966, "CJK COMPATIBILITY IDEOGRAPH-2F966" },
	{ 0x2F967, "CJK COMPATIBILITY IDEOGRAPH-2F967" },
	{ 0x2F968, "CJK COMPATIBILITY IDEOGRAPH-2F968" },
	{ 0x2F969, "CJK COMPATIBILITY IDEOGRAPH-2F969" },
	{ 0x2F96A, "CJK COMPATIBILITY IDEOGRAPH-2F96A" },
	{ 0x2F96B, "CJK COMPATIBILITY IDEOGRAPH-2F96B" },
	{ 0x2F96C, "CJK COMPATIBILITY IDEOGRAPH-2F96C" },
	{ 0x2F96D, "CJK COMPATIBILITY IDEOGRAPH-2F96D" },
	{ 0x2F96E, "CJK COMPATIBILITY IDEOGRAPH-2F96E" },
	{ 0x2F96F, "CJK COMPATIBILITY IDEOGRAPH-2F96F" },
	{ 0x2F970, "CJK COMPATIBILITY IDEOGRAPH-2F970" },
	{ 0x2F971, "CJK COMPATIBILITY IDEOGRAPH-2F971" },
	{ 0x2F972, "CJK COMPATIBILITY IDEOGRAPH-2F972" },
	{ 0x2F973, "CJK COMPATIBILITY IDEOGRAPH-2F973" },
	{ 0x2F974, "CJK COMPATIBILITY IDEOGRAPH-2F974" },
	{ 0x2F975, "CJK COMPATIBILITY IDEOGRAPH-2F975" },
	{ 0x2F976, "CJK COMPATIBILITY IDEOGRAPH-2F976" },
	{ 0x2F977, "CJK COMPATIBILITY IDEOGRAPH-2F977" },
	{ 0x2F978, "CJK COMPATIBILITY IDEOGRAPH-2F978" },
	{ 0x2F979, "CJK COMPATIBILITY IDEOGRAPH-2F979" },
	{ 0x2F97A, "CJK COMPATIBILITY IDEOGRAPH-2F97A" },
	{ 0x2F97B, "CJK COMPATIBILITY IDEOGRAPH-2F97B" },
	{ 0x2F97C, "CJK COMPATIBILITY IDEOGRAPH-2F97C" },
	{ 0x2F97D, "CJK COMPATIBILITY IDEOGRAPH-2F97D" },
	{ 0x2F97E, "CJK COMPATIBILITY IDEOGRAPH-2F97E" },
	{ 0x2F97F, "CJK COMPATIBILITY IDEOGRAPH-2F97F" },
	{ 0x2F980, "CJK COMPATIBILITY IDEOGRAPH-2F980" },
	{ 0x2F981, "CJK COMPATIBILITY IDEOGRAPH-2F981" },
	{ 0x2F982, "CJK COMPATIBILITY IDEOGRAPH-2F982" },
	{ 0x2F983, "CJK COMPATIBILITY IDEOGRAPH-2F983" },
	{ 0x2F984, "CJK COMPATIBILITY IDEOGRAPH-2F984" },
	{ 0x2F985, "CJK COMPATIBILITY IDEOGRAPH-2F985" },
	{ 0x2F986, "CJK COMPATIBILITY IDEOGRAPH-2F986" },
	{ 0x2F987, "CJK COMPATIBILITY IDEOGRAPH-2F987" },
	{ 0x2F988, "CJK COMPATIBILITY IDEOGRAPH-2F988" },
	{ 0x2F989, "CJK COMPATIBILITY IDEOGRAPH-2F989" },
	{ 0x2F98A, "CJK COMPATIBILITY IDEOGRAPH-2F98A" },
	{ 0x2F98B, "CJK COMPATIBILITY IDEOGRAPH-2F98B" },
	{ 0x2F98C, "CJK COMPATIBILITY IDEOGRAPH-2F98C" },
	{ 0x2F98D, "CJK COMPATIBILITY IDEOGRAPH-2F98D" },
	{ 0x2F98E, "CJK COMPATIBILITY IDEOGRAPH-2F98E" },
	{ 0x2F98F, "CJK COMPATIBILITY IDEOGRAPH-2F98F" },
	{ 0x2F990, "CJK COMPATIBILITY IDEOGRAPH-2F990" },
	{ 0x2F991, "CJK COMPATIBILITY IDEOGRAPH-2F991" },
	{ 0x2F992, "CJK COMPATIBILITY IDEOGRAPH-2F992" },
	{ 0x2F993, "CJK COMPATIBILITY IDEOGRAPH-2F993" },
	{ 0x2F994, "CJK COMPATIBILITY IDEOGRAPH-2F994" },
	{ 0x2F995, "CJK COMPATIBILITY IDEOGRAPH-2F995" },
	{ 0x2F996, "CJK COMPATIBILITY IDEOGRAPH-2F996" },
	{ 0x2F997, "CJK COMPATIBILITY IDEOGRAPH-2F997" },
	{ 0x2F998, "CJK COMPATIBILITY IDEOGRAPH-2F998" },
	{ 0x2F999, "CJK COMPATIBILITY IDEOGRAPH-2F999" },
	{ 0x2F99A, "CJK COMPATIBILITY IDEOGRAPH-2F99A" },
	{ 0x2F99B, "CJK COMPATIBILITY IDEOGRAPH-2F99B" },
	{ 0x2F99C, "CJK COMPATIBILITY IDEOGRAPH-2F99C" },
	{ 0x2F99D, "CJK COMPATIBILITY IDEOGRAPH-2F99D" },
	{ 0x2F99E, "CJK COMPATIBILITY IDEOGRAPH-2F99E" },
	{ 0x2F99F, "CJK COMPATIBILITY IDEOGRAPH-2F99F" },
	{ 0x2F9A0, "CJK COMPATIBILITY IDEOGRAPH-2F9A0" },
	{ 0x2F9A1, "CJK COMPATIBILITY IDEOGRAPH-2F9A1" },
	{ 0x2F9A2, "CJK COMPATIBILITY IDEOGRAPH-2F9A2" },
	{ 0x2F9A3, "CJK COMPATIBILITY IDEOGRAPH-2F9A3" },
	{ 0x2F9A4, "CJK COMPATIBILITY IDEOGRAPH-2F9A4" },
	{ 0x2F9A5, "CJK COMPATIBILITY IDEOGRAPH-2F9A5" },
	{ 0x2F9A6, "CJK COMPATIBILITY IDEOGRAPH-2F9A6" },
	{ 0x2F9A7, "CJK COMPATIBILITY IDEOGRAPH-2F9A7" },
	{ 0x2F9A8, "CJK COMPATIBILITY IDEOGRAPH-2F9A8" },
	{ 0x2F9A9, "CJK COMPATIBILITY IDEOGRAPH-2F9A9" },
	{ 0x2F9AA, "CJK COMPATIBILITY IDEOGRAPH-2F9AA" },
	{ 0x2F9AB, "CJK COMPATIBILITY IDEOGRAPH-2F9AB" },
	{ 0x2F9AC, "CJK COMPATIBILITY IDEOGRAPH-2F9AC" },
	{ 0x2F9AD, "CJK COMPATIBILITY IDEOGRAPH-2F9AD" },
	{ 0x2F9AE, "CJK COMPATIBILITY IDEOGRAPH-2F9AE" },
	{ 0x2F9AF, "CJK COMPATIBILITY IDEOGRAPH-2F9AF" },
	{ 0x2F9B0, "CJK COMPATIBILITY IDEOGRAPH-2F9B0" },
	{ 0x2F9B1, "CJK COMPATIBILITY IDEOGRAPH-2F9B1" },
	{ 0x2F9B2, "CJK COMPATIBILITY IDEOGRAPH-2F9B2" },
	{ 0x2F9B3, "CJK COMPATIBILITY IDEOGRAPH-2F9B3" },
	{ 0x2F9B4, "CJK COMPATIBILITY IDEOGRAPH-2F9B4" },
	{ 0x2F9B5, "CJK COMPATIBILITY IDEOGRAPH-2F9B5" },
	{ 0x2F9B6, "CJK COMPATIBILITY IDEOGRAPH-2F9B6" },
	{ 0x2F9B7, "CJK COMPATIBILITY IDEOGRAPH-2F9B7" },
	{ 0x2F9B8, "CJK COMPATIBILITY IDEOGRAPH-2F9B8" },
	{ 0x2F9B9, "CJK COMPATIBILITY IDEOGRAPH-2F9B9" },
	{ 0x2F9BA, "CJK COMPATIBILITY IDEOGRAPH-2F9BA" },
	{ 0x2F9BB, "CJK COMPATIBILITY IDEOGRAPH-2F9BB" },
	{ 0x2F9BC, "CJK COMPATIBILITY IDEOGRAPH-2F9BC" },
	{ 0x2F9BD, "CJK COMPATIBILITY IDEOGRAPH-2F9BD" },
	{ 0x2F9BE, "CJK COMPATIBILITY IDEOGRAPH-2F9BE" },
	{ 0x2F9BF, "CJK COMPATIBILITY IDEOGRAPH-2F9BF" },
	{ 0x2F9C0, "CJK COMPATIBILITY IDEOGRAPH-2F9C0" },
	{ 0x2F9C1, "CJK COMPATIBILITY IDEOGRAPH-2F9C1" },
	{ 0x2F9C2, "CJK COMPATIBILITY IDEOGRAPH-2F9C2" },
	{ 0x2F9C3, "CJK COMPATIBILITY IDEOGRAPH-2F9C3" },
	{ 0x2F9C4, "CJK COMPATIBILITY IDEOGRAPH-2F9C4" },
	{ 0x2F9C5, "CJK COMPATIBILITY IDEOGRAPH-2F9C5" },
	{ 0x2F9C6, "CJK COMPATIBILITY IDEOGRAPH-2F9C6" },
	{ 0x2F9C7, "CJK COMPATIBILITY IDEOGRAPH-2F9C7" },
	{ 0x2F9C8, "CJK COMPATIBILITY IDEOGRAPH-2F9C8" },
	{ 0x2F9C9, "CJK COMPATIBILITY IDEOGRAPH-2F9C9" },
	{ 0x2F9CA, "CJK COMPATIBILITY IDEOGRAPH-2F9CA" },
	{ 0x2F9CB, "CJK COMPATIBILITY IDEOGRAPH-2F9CB" },
	{ 0x2F9CC, "CJK COMPATIBILITY IDEOGRAPH-2F9CC" },
	{ 0x2F9CD, "CJK COMPATIBILITY IDEOGRAPH-2F9CD" },
	{ 0x2F9CE, "CJK COMPATIBILITY IDEOGRAPH-2F9CE" },
	{ 0x2F9CF, "CJK COMPATIBILITY IDEOGRAPH-2F9CF" },
	{ 0x2F9D0, "CJK COMPATIBILITY IDEOGRAPH-2F9D0" },
	{ 0x2F9D1, "CJK COMPATIBILITY IDEOGRAPH-2F9D1" },
	{ 0x2F9D2, "CJK COMPATIBILITY IDEOGRAPH-2F9D2" },
	{ 0x2F9D3, "CJK COMPATIBILITY IDEOGRAPH-2F9D3" },
	{ 0x2F9D4, "CJK COMPATIBILITY IDEOGRAPH-2F9D4" },
	{ 0x2F9D5, "CJK COMPATIBILITY IDEOGRAPH-2F9D5" },
	{ 0x2F9D6, "CJK COMPATIBILITY IDEOGRAPH-2F9D6" },
	{ 0x2F9D7, "CJK COMPATIBILITY IDEOGRAPH-2F9D7" },
	{ 0x2F9D8, "CJK COMPATIBILITY IDEOGRAPH-2F9D8" },
	{ 0x2F9D9, "CJK COMPATIBILITY IDEOGRAPH-2F9D9" },
	{ 0x2F9DA, "CJK COMPATIBILITY IDEOGRAPH-2F9DA" },
	{ 0x2F9DB, "CJK COMPATIBILITY IDEOGRAPH-2F9DB" },
	{ 0x2F9DC, "CJK COMPATIBILITY IDEOGRAPH-2F9DC" },
	{ 0x2F9DD, "CJK COMPATIBILITY IDEOGRAPH-2F9DD" },
	{ 0x2F9DE, "CJK COMPATIBILITY IDEOGRAPH-2F9DE" },
	{ 0x2F9DF, "CJK COMPATIBILITY IDEOGRAPH-2F9DF" },
	{ 0x2F9E0, "CJK COMPATIBILITY IDEOGRAPH-2F9E0" },
	{ 0x2F9E1, "CJK COMPATIBILITY IDEOGRAPH-2F9E1" },
	{ 0x2F9E2, "CJK COMPATIBILITY IDEOGRAPH-2F9E2" },
	{ 0x2F9E3, "CJK COMPATIBILITY IDEOGRAPH-2F9E3" },
	{ 0x2F9E4, "CJK COMPATIBILITY IDEOGRAPH-2F9E4" },
	{ 0x2F9E5, "CJK COMPATIBILITY IDEOGRAPH-2F9E5" },
	{ 0x2F9E6, "CJK COMPATIBILITY IDEOGRAPH-2F9E6" },
	{ 0x2F9E7, "CJK COMPATIBILITY IDEOGRAPH-2F9E7" },
	{ 0x2F9E8, "CJK COMPATIBILITY IDEOGRAPH-2F9E8" },
	{ 0x2F9E9, "CJK COMPATIBILITY IDEOGRAPH-2F9E9" },
	{ 0x2F9EA, "CJK COMPATIBILITY IDEOGRAPH-2F9EA" },
	{ 0x2F9EB, "CJK COMPATIBILITY IDEOGRAPH-2F9EB" },
	{ 0x2F9EC, "CJK COMPATIBILITY IDEOGRAPH-2F9EC" },
	{ 0x2F9ED, "CJK COMPATIBILITY IDEOGRAPH-2F9ED" },
	{ 0x2F9EE, "CJK COMPATIBILITY IDEOGRAPH-2F9EE" },
	{ 0x2F9EF, "CJK COMPATIBILITY IDEOGRAPH-2F9EF" },
	{ 0x2F9F0, "CJK COMPATIBILITY IDEOGRAPH-2F9F0" },
	{ 0x2F9F1, "CJK COMPATIBILITY IDEOGRAPH-2F9F1" },
	{ 0x2F9F2, "CJK COMPATIBILITY IDEOGRAPH-2F9F2" },
	{ 0x2F9F3, "CJK COMPATIBILITY IDEOGRAPH-2F9F3" },
	{ 0x2F9F4, "CJK COMPATIBILITY IDEOGRAPH-2F9F4" },
	{ 0x2F9F5, "CJK COMPATIBILITY IDEOGRAPH-2F9F5" },
	{ 0x2F9F6, "CJK COMPATIBILITY IDEOGRAPH-2F9F6" },
	{ 0x2F9F7, "CJK COMPATIBILITY IDEOGRAPH-2F9F7" },
	{ 0x2F9F8, "CJK COMPATIBILITY IDEOGRAPH-2F9F8" },
	{ 0x2F9F9, "CJK COMPATIBILITY IDEOGRAPH-2F9F9" },
	{ 0x2F9FA, "CJK COMPATIBILITY IDEOGRAPH-2F9FA" },
	{ 0x2F9FB, "CJK COMPATIBILITY IDEOGRAPH-2F9FB" },
	{ 0x2F9FC, "CJK COMPATIBILITY IDEOGRAPH-2F9FC" },
	{ 0x2F9FD, "CJK COMPATIBILITY IDEOGRAPH-2F9FD" },
	{ 0x2F9FE, "CJK COMPATIBILITY IDEOGRAPH-2F9FE" },
	{ 0x2F9FF, "CJK COMPATIBILITY IDEOGRAPH-2F9FF" },
	{ 0x2FA00, "CJK COMPATIBILITY IDEOGRAPH-2FA00" },
	{ 0x2FA01, "CJK COMPATIBILITY IDEOGRAPH-2FA01" },
	{ 0x2FA02, "CJK COMPATIBILITY IDEOGRAPH-2FA02" },
	{ 0x2FA03, "CJK COMPATIBILITY IDEOGRAPH-2FA03" },
	{ 0x2FA04, "CJK COMPATIBILITY IDEOGRAPH-2FA04" },
	{ 0x2FA05, "CJK COMPATIBILITY IDEOGRAPH-2FA05" },
	{ 0x2FA06, "CJK COMPATIBILITY IDEOGRAPH-2FA06" },
	{ 0x2FA07, "CJK COMPATIBILITY IDEOGRAPH-2FA07" },
	{ 0x2FA08, "CJK COMPATIBILITY IDEOGRAPH-2FA08" },
	{ 0x2FA09, "CJK COMPATIBILITY IDEOGRAPH-2FA09" },
	{ 0x2FA0A, "CJK COMPATIBILITY IDEOGRAPH-2FA0A" },
	{ 0x2FA0B, "CJK COMPATIBILITY IDEOGRAPH-2FA0B" },
	{ 0x2FA0C, "CJK COMPATIBILITY IDEOGRAPH-2FA0C" },
	{ 0x2FA0D, "CJK COMPATIBILITY IDEOGRAPH-2FA0D" },
	{ 0x2FA0E, "CJK COMPATIBILITY IDEOGRAPH-2FA0E" },
	{ 0x2FA0F, "CJK COMPATIBILITY IDEOGRAPH-2FA0F" },
	{ 0x2FA10, "CJK COMPATIBILITY IDEOGRAPH-2FA10" },
	{ 0x2FA11, "CJK COMPATIBILITY IDEOGRAPH-2FA11" },
	{ 0x2FA12, "CJK COMPATIBILITY IDEOGRAPH-2FA12" },
	{ 0x2FA13, "CJK COMPATIBILITY IDEOGRAPH-2FA13" },
	{ 0x2FA14, "CJK COMPATIBILITY IDEOGRAPH-2FA14" },
	{ 0x2FA15, "CJK COMPATIBILITY IDEOGRAPH-2FA15" },
	{ 0x2FA16, "CJK COMPATIBILITY IDEOGRAPH-2FA16" },
	{ 0x2FA17, "CJK COMPATIBILITY IDEOGRAPH-2FA17" },
	{ 0x2FA18, "CJK COMPATIBILITY IDEOGRAPH-2FA18" },
	{ 0x2FA19, "CJK COMPATIBILITY IDEOGRAPH-2FA19" },
	{ 0x2FA1A, "CJK COMPATIBILITY IDEOGRAPH-2FA1A" },
	{ 0x2FA1B, "CJK COMPATIBILITY IDEOGRAPH-2FA1B" },
	{ 0x2FA1C, "CJK COMPATIBILITY IDEOGRAPH-2FA1C" },
	{ 0x2FA1D, "CJK COMPATIBILITY IDEOGRAPH-2FA1D" },
	{ 0xE0001, "LANGUAGE TAG" },
	{ 0xE0020, "TAG SPACE" },
	{ 0xE0021, "TAG EXCLAMATION MARK" },
	{ 0xE0022, "TAG QUOTATION MARK" },
	{ 0xE0023, "TAG NUMBER SIGN" },
	{ 0xE0024, "TAG DOLLAR SIGN" },
	{ 0xE0025, "TAG PERCENT SIGN" },
	{ 0xE0026, "TAG AMPERSAND" },
	{ 0xE0027, "TAG APOSTROPHE" },
	{ 0xE0028, "TAG LEFT PARENTHESIS" },
	{ 0xE0029, "TAG RIGHT PARENTHESIS" },
	{ 0xE002A, "TAG ASTERISK" },
	{ 0xE002B, "TAG PLUS SIGN" },
	{ 0xE002C, "TAG COMMA" },
	{ 0xE002D, "TAG HYPHEN-MINUS" },
	{ 0xE002E, "TAG FULL STOP" },
	{ 0xE002F, "TAG SOLIDUS" },
	{ 0xE0030, "TAG DIGIT ZERO" },
	{ 0xE0031, "TAG DIGIT ONE" },
	{ 0xE0032, "TAG DIGIT TWO" },
	{ 0xE0033, "TAG DIGIT THREE" },
	{ 0xE0034, "TAG DIGIT FOUR" },
	{ 0xE0035, "TAG DIGIT FIVE" },
	{ 0xE0036, "TAG DIGIT SIX" },
	{ 0xE0037, "TAG DIGIT SEVEN" },
	{ 0xE0038, "TAG DIGIT EIGHT" },
	{ 0xE0039, "TAG DIGIT NINE" },
	{ 0xE003A, "TAG COLON" },
	{ 0xE003B, "TAG SEMICOLON" },
	{ 0xE003C, "TAG LESS-THAN SIGN" },
	{ 0xE003D, "TAG EQUALS SIGN" },
	{ 0xE003E, "TAG GREATER-THAN SIGN" },
	{ 0xE003F, "TAG QUESTION MARK" },
	{ 0xE0040, "TAG COMMERCIAL AT" },
	{ 0xE0041, "TAG LATIN CAPITAL LETTER A" },
	{ 0xE0042, "TAG LATIN CAPITAL LETTER B" },
	{ 0xE0043, "TAG LATIN CAPITAL LETTER C" },
	{ 0xE0044, "TAG LATIN CAPITAL LETTER D" },
	{ 0xE0045, "TAG LATIN CAPITAL LETTER E" },
	{ 0xE0046, "TAG LATIN CAPITAL LETTER F" },
	{ 0xE0047, "TAG LATIN CAPITAL LETTER G" },
	{ 0xE0048, "TAG LATIN CAPITAL LETTER H" },
	{ 0xE0049, "TAG LATIN CAPITAL LETTER I" },
	{ 0xE004A, "TAG LATIN CAPITAL LETTER J" },
	{ 0xE004B, "TAG LATIN CAPITAL LETTER K" },
	{ 0xE004C, "TAG LATIN CAPITAL LETTER L" },
	{ 0xE004D, "TAG LATIN CAPITAL LETTER M" },
	{ 0xE004E, "TAG LATIN CAPITAL LETTER N" },
	{ 0xE004F, "TAG LATIN CAPITAL LETTER O" },
	{ 0xE0050, "TAG LATIN CAPITAL LETTER P" },
	{ 0xE0051, "TAG LATIN CAPITAL LETTER Q" },
	{ 0xE0052, "TAG LATIN CAPITAL LETTER R" },
	{ 0xE0053, "TAG LATIN CAPITAL LETTER S" },
	{ 0xE0054, "TAG LATIN CAPITAL LETTER T" },
	{ 0xE0055, "TAG LATIN CAPITAL LETTER U" },
	{ 0xE0056, "TAG LATIN CAPITAL LETTER V" },
	{ 0xE0057, "TAG LATIN CAPITAL LETTER W" },
	{ 0xE0058, "TAG LATIN CAPITAL LETTER X" },
	{ 0xE0059, "TAG LATIN CAPITAL LETTER Y" },
	{ 0xE005A, "TAG LATIN CAPITAL LETTER Z" },
	{ 0xE005B, "TAG LEFT SQUARE BRACKET" },
	{ 0xE005C, "TAG REVERSE SOLIDUS" },
	{ 0xE005D, "TAG RIGHT SQUARE BRACKET" },
	{ 0xE005E, "TAG CIRCUMFLEX ACCENT" },
	{ 0xE005F, "TAG LOW LINE" },
	{ 0xE0060, "TAG GRAVE ACCENT" },
	{ 0xE0061, "TAG LATIN SMALL LETTER A" },
	{ 0xE0062, "TAG LATIN SMALL LETTER B" },
	{ 0xE0063, "TAG LATIN SMALL LETTER C" },
	{ 0xE0064, "TAG LATIN SMALL LETTER D" },
	{ 0xE0065, "TAG LATIN SMALL LETTER E" },
	{ 0xE0066, "TAG LATIN SMALL LETTER F" },
	{ 0xE0067, "TAG LATIN SMALL LETTER G" },
	{ 0xE0068, "TAG LATIN SMALL LETTER H" },
	{ 0xE0069, "TAG LATIN SMALL LETTER I" },
	{ 0xE006A, "TAG LATIN SMALL LETTER J" },
	{ 0xE006B, "TAG LATIN SMALL LETTER K" },
	{ 0xE006C, "TAG LATIN SMALL LETTER L" },
	{ 0xE006D, "TAG LATIN SMALL LETTER M" },
	{ 0xE006E, "TAG LATIN SMALL LETTER N" },
	{ 0xE006F, "TAG LATIN SMALL LETTER O" },
	{ 0xE0070, "TAG LATIN SMALL LETTER P" },
	{ 0xE0071, "TAG LATIN SMALL LETTER Q" },
	{ 0xE0072, "TAG LATIN SMALL LETTER R" },
	{ 0xE0073, "TAG LATIN SMALL LETTER S" },
	{ 0xE0074, "TAG LATIN SMALL LETTER T" },
	{ 0xE0075, "TAG LATIN SMALL LETTER U" },
	{ 0xE0076, "TAG LATIN SMALL LETTER V" },
	{ 0xE0077, "TAG LATIN SMALL LETTER W" },
	{ 0xE0078, "TAG LATIN SMALL LETTER X" },
	{ 0xE0079, "TAG LATIN SMALL LETTER Y" },
	{ 0xE007A, "TAG LATIN SMALL LETTER Z" },
	{ 0xE007B, "TAG LEFT CURLY BRACKET" },
	{ 0xE007C, "TAG VERTICAL LINE" },
	{ 0xE007D, "TAG RIGHT CURLY BRACKET" },
	{ 0xE007E, "TAG TILDE" },
	{ 0xE007F, "CANCEL TAG" },
	{ 0xF0000, "<Plane 15 Private Use, First>" },
	{ 0xFFFFD, "<Plane 15 Private Use, Last>" },
	{ 0x100000, "<Plane 16 Private Use, First>" },
	{ 0x10FFFD, "<Plane 16 Private Use, Last>" },
};
